/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.views;

import com.rocktasticgames.diamonds.animated.AnimatedElement;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.parameters.C2MValues;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.MotionEvent;
import com.rocktasticgames.diamonds.views.View;
import javax.microedition.lcdui.Image;

public class IntroView
extends View {
    private static final float[][] COORDS = new float[][]{{755.0f, 561.0f}, {876.0f, 1018.0f}, {592.0f, 327.0f}, {946.0f, 582.0f}, {776.0f, 1283.0f}};
    private static final float[][] TEXT_LOC = new float[][]{{768.0f, 1315.0f}, {768.0f, 1560.0f}, {768.0f, 807.0f}, {768.0f, 1567.0f}};
    private static final String[] STORY_IMG = new String[]{"introscreen_panel1", "introscreen_panel2", "introscreen_panel3", "introscreen_panel4", "introscreen_panel5"};
    private static final int[] ANIM_TYPE = new int[]{3, 5, 3, 5, 3};
    private static final long[] ANIM_TIME = new long[]{0L, 10000000L, 20000000L, 20000000L, 30000000L};
    private static final int MAX_TOUCHES = 2;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement[] story;
    private AnimatedElement play;
    private AnimatedElement background;
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private int[] touch_ptr = new int[2];
    private boolean play_tapped = false;
    private long start_time = System.currentTimeMillis();
    private boolean destroyed = false;
    private String bg_image = "introscreen_bg";
    private int tapnum = 0;

    public IntroView(MainActivity mainActivity) {
        super(mainActivity);
        this.activity.getMusic().playMusic("pizza_openingscreen_music_j2me");
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (this.play != null) {
            return this.play;
        }
        return null;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.story != null) {
            for (int i = 0; i < this.story.length; ++i) {
                this.story[i].unload();
            }
        }
        if (this.background != null) {
            this.background.unload();
        }
    }

    public boolean onBack() {
        if (this.tapnum < 4) {
            ++this.tapnum;
        }
        this.activity.setPlaceholder("introscreen_bg");
        return true;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.play = new AnimatedElement(this.activity.getAssetLoader(), "button_272_play", 0.5f, 1.0f - (1.0f - f2 * 4.0f / 3.0f) / 2.0f - 120.0f * f2 / 1156.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.story = new AnimatedElement[STORY_IMG.length];
        for (int i = 0; i < this.story.length; ++i) {
            this.story[i] = new AnimatedElement(this.activity.getAssetLoader(), STORY_IMG[i], COORDS[i][0] / 1536.0f, COORDS[i][1] * f2 / 1536.0f + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, ANIM_TYPE[i], ANIM_TIME[i]);
        }
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        int n;
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n2 = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 240;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded && this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
            this.start_time = System.currentTimeMillis();
        }
        this.time = System.currentTimeMillis() - this.start_time + (long)this.tapnum * 10000000L;
        if (this.time < 0L) {
            this.time = 0L;
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        this.background.render(graphicsContainer, n2, this.time);
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n2);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n2);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        if (this.activity.getCanvas().getFocus() == null) {
            this.activity.getCanvas().setFocus(this.play);
        }
        if (this.play_tapped) {
            this.play.setColorFilter(Params.filter_dark);
        }
        this.play.render(graphicsContainer, n2, this.time);
        if (this.play_tapped) {
            this.play.setColorFilter(null);
        }
        for (n = 0; n <= this.tapnum && n < C2MValues.INTRO_LINES.length; ++n) {
            graphicsContainer.setColor(-16777216);
            int n3 = 255;
            if (this.tapnum < 2) {
                n3 = (int)Math.max(0L, Math.min(255L, this.time - (long)n * 10000000L));
            } else if (n < 2) {
                n3 = (int)Math.max(0L, Math.min(255L, 20000255L - this.time));
            } else if (this.tapnum >= 4) {
                n3 = (int)Math.max(0L, Math.min(255L, 40000255L - this.time));
            }
            this.activity.getBrady().setSize(45.0f);
            if (n3 <= 0) continue;
            for (int i = 0; i < C2MValues.INTRO_LINES[n][this.activity.getLanguage()].length; ++i) {
                graphicsContainer.save();
                graphicsContainer.translate(TEXT_LOC[n][0] * (float)graphicsContainer.getWidth() / this.scale / 1536.0f - (float)(this.activity.getBrady().measure(C2MValues.INTRO_LINES[n][this.activity.getLanguage()][i]) / 2), TEXT_LOC[n][1] * (float)graphicsContainer.getWidth() / this.scale / 1536.0f + (float)graphicsContainer.getHeight() / this.scale * (1.0f - (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight() * 4.0f / 3.0f) / 2.0f + (float)i * this.activity.getBrady().getSize(graphicsContainer) * 4.0f / 3.0f);
                this.activity.getBrady().renderString(graphicsContainer, n2, C2MValues.INTRO_LINES[n][this.activity.getLanguage()][i]);
                graphicsContainer.restore();
            }
        }
        for (n = 0; n < this.story.length; ++n) {
            if (this.tapnum >= 2 && n < 2 && !this.story[n].isAnimatingOut()) {
                this.story[n].animateThrough(this.time);
            }
            if (this.tapnum >= 4 && !this.story[n].isAnimatingOut()) {
                this.story[n].animateThrough(this.time);
            }
            if (this.story[n].render(graphicsContainer, n2, this.time)) continue;
            bl = true;
        }
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = System.currentTimeMillis() - this.start_time + (long)this.tapnum * 10000000L;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time > 40000500L) {
            this.activity.startMap(0);
        } else if (bl) {
            this.invalidate();
        } else {
            this.postInvalidateDelayed(50L);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.tapnum >= 4) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.play_tapped) {
                    this.activity.setPlaceholder("introscreen_bg");
                    this.play_tapped = false;
                    ++this.tapnum;
                    this.start_time = System.currentTimeMillis();
                }
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                if (this.play.isLoaded() && this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = true;
                    this.activity.playSound("standard_click");
                } else {
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.play_tapped && !this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = false;
                }
                return true;
            }
        }
        return true;
    }
}

