/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CarSelectionScreen;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SingleRace;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SelectDriverScreen
extends MainUSRScreen {
    private int currentElement = 0;
    private final int MAX_ELEMENTS;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private CGTexture[] texts = new CGTexture[5];
    public static String[] nationalities = new String[]{"TID_NATIONALITY_ENGLISH", "TID_NATIONALITY_SPANISH", "TID_NATIONALITY_ITALIAN", "TID_NATIONALITY_GERMAN", "TID_NATIONALITY_FRENCH"};
    public static String[] names = new String[]{"JohnT", "PaulB", "TommyP", "UweS", "PatrikJ"};
    private CGTexture bg = TextureManager.CreateTexture("/car_bg.png");
    public static String playerName;

    public SelectDriverScreen() {
        this.MAX_ELEMENTS = 5;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        for (int i = 0; i < 5; ++i) {
            this.texts[i] = TextureManager.CreateTexture("/drivers/driver_" + (i + 1) + ".png");
        }
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        int arrowLeftX = 0;
        int arrowRightX = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX - ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.bg.GetHeight() / 4 - ObjectsCache.scrollRightImg.GetHeight() / 2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX + ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.bg.GetHeight() / 4 - ObjectsCache.scrollRightImg.GetHeight() / 2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1);
        this.addButton(leftB);
    }

    public void onUpdate(int deltaTime) {
        this.lifeTime += deltaTime;
    }

    public void draw() {
        Graphic2D.DrawImage(this.bg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.bg.GetHeight() / 4, 3);
        Graphic2D.DrawImage(this.texts[this.currentElement], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.bg.GetHeight() / 4, 3);
        int fontHeight = ApplicationData.defaultFont.getFontHeight();
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_DRIVER_NATIONALITY"), ApplicationData.screenWidth / 10, ApplicationData.screenHeight / 2 + this.bg.GetHeight() / 4 + fontHeight * 1, 20, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, nationalities[this.currentElement]), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + this.bg.GetHeight() / 4 + fontHeight * 2, 17, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_DRIVER_NAME"), ApplicationData.screenWidth / 10, ApplicationData.screenHeight / 2 + this.bg.GetHeight() / 4 + fontHeight * 3, 20, 0);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(names[this.currentElement]), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + this.bg.GetHeight() / 4 + fontHeight * 4, 17, 0);
    }

    public boolean rightSoftButton() {
        if (CGUserCareer.isAnyGameStored()) {
            UIScreen.SetCurrentScreen(new MainMenu());
        } else {
            UIScreen.SetCurrentScreen(new SingleRace());
        }
        return true;
    }

    public boolean leftSoftButton() {
        playerName = names[this.currentElement];
        EditChampionshipsUserName.playerNick = ApplicationData.defaultFont.encodeDynamicString(playerName);
        if (CGEngine.selectedGameMode == 2) {
            CGUserCareer.SetNick(EditChampionshipsUserName.playerNick);
        }
        UIScreen.SetCurrentScreen(new CarSelectionScreen(this));
        return true;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentElement;
        if (this.currentElement >= 5) {
            this.currentElement = 0;
        }
        return true;
    }

    public boolean onLeftAction() {
        --this.currentElement;
        if (this.currentElement < 0) {
            this.currentElement = 4;
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

