/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class EndOfCareerScreen
extends MainScreen {
    private int seasonPos = -1;
    private String message;
    private Vector mainText;
    private int textHeight;
    private CGTexture trophyTexture = null;

    public EndOfCareerScreen(int nSeasonPosition) {
        ApplicationData.achievements.completeAchievment(3);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_END_OF_CAREER")));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.setDrawTitle(false);
        this.seasonPos = nSeasonPosition;
        this.trophyTexture = null;
        if (this.seasonPos == 0) {
            this.trophyTexture = TextureManager.AddTexture("/trophy_1.png");
            EventScreen.medalEvents[EventScreen.selectedWorld] = 1;
        } else if (this.seasonPos == 1) {
            this.trophyTexture = TextureManager.AddTexture("/trophy_2.png");
            EventScreen.medalEvents[EventScreen.selectedWorld] = 2;
        } else if (this.seasonPos == 2) {
            this.trophyTexture = TextureManager.AddTexture("/trophy_3.png");
            EventScreen.medalEvents[EventScreen.selectedWorld] = 3;
        } else {
            this.message = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_NO_PODIUM");
        }
        this.message = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_CONGRATULATIONS");
        this.message = this.message + ApplicationData.defaultFont.encodeDynamicString("" + (this.seasonPos + 1));
        this.mainText = Utils.splitText(this.message, "+", ApplicationData.screenWidth, 2);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
        CGUserCareer.unlockCar();
        if (EventScreen.selectedWorld == 0) {
            CGUserCareer.unlockKart(3);
        } else if (EventScreen.selectedWorld == 1) {
            CGUserCareer.unlockKart(4);
        }
    }

    public void onUpdate(int deltaTime) {
        this.lifeTime += deltaTime;
    }

    public boolean leftSoftButton() {
        CGUserCareer.NextEventReset();
        CGUserCareer.m_nRaceID = 0;
        if (CGUserCareer.difficultyLevel == 0) {
            CGUserCareer.availableDifficultyLevel = 1;
        } else if (CGUserCareer.difficultyLevel == 1) {
            CGUserCareer.availableDifficultyLevel = 2;
        }
        CGUserCareer.unlockCar();
        if (this.seasonPos < 3 && EventScreen.selectedWorld < 3) {
            CGUserCareer.avalaibleEvents[EventScreen.selectedWorld + 1] = true;
        }
        CareerScreen.nextEvent = 0;
        ApplicationData.generalGameMode = 3;
        UIScreen.SetCurrentScreen(new EventScreen());
        return true;
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
    }

    public void draw() {
        int fontHeight = 9 * ApplicationData.getFontByID(0).getFontHeight() / 10;
        if (this.trophyTexture != null) {
            int nY = ApplicationData.screenHeight / 2 - ObjectsCache.menuFooterImage.GetHeight();
            Graphic2D.DrawImage(this.trophyTexture, ApplicationData.screenWidth / 2, nY, 3);
            Utils.drawString(this.mainText, ApplicationData.screenWidth / 2, nY += this.trophyTexture.GetHeight() / 2, 17, 0);
        } else {
            int nY = ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() - (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight()) / 2;
            Utils.drawString(this.mainText, ApplicationData.screenWidth / 2, nY, 33, 0);
        }
    }

    public boolean rightSoftButton() {
        return false;
    }
}

