/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGBolid;
import baltorogames.project_gameplay.CGBolidRecord;
import baltorogames.project_gameplay.CGCamera;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGRainSystem;
import baltorogames.project_gameplay.CGTrack;
import baltorogames.project_gameplay.CGTrackNode;
import baltorogames.project_gameplay.FXUtility;
import baltorogames.project_gameplay.MissionParams;
import baltorogames.project_gameplay.RoadRenderer;
import baltorogames.project_gameplay.Vector2FX;
import baltorogames.project_gameplay.Vector3FX;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.system.Options;
import baltorogames.system.Platform;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Image;

public class CarEngine2D {
    public static final int SHIFT = 12;
    public static final int MAX_TO_BAND_DISTANCE = 5;
    public static final int[] backgroundColor1 = new int[]{9212504, 5864065, 7692378, 11247148, 8484438, 5728384, 0x5A8555, 6717313, 9861474};
    public static final int[] backgroundColor2 = new int[]{5409920, 6049131, 5198914, 2196017, 4411959, 5455194, 3625800, 4275537, 4808760};
    public static final int[][] m_MinTimeAI = new int[][]{{138000, 142000, 124000, 123000, 135000, 133000, 149000, 129000, 140000, 142000, 146000, 149000}, {128000, 132000, 114000, 113000, 125000, 123000, 139000, 119000, 130000, 132000, 136000, 139000}, {118000, 122000, 104000, 103000, 115000, 113000, 129000, 109000, 120000, 122000, 126000, 129000}};
    public static final int[][] m_MaxTimeAI = new int[][]{{190000, 185000, 155000, 150000, 162000, 160000, 172000, 175000, 155000, 160000, 162000, 160000}, {180000, 175000, 145000, 140000, 152000, 150000, 162000, 165000, 145000, 150000, 152000, 150000}, {170000, 165000, 135000, 130000, 142000, 140000, 152000, 155000, 135000, 140000, 142000, 140000}};
    static boolean m_bDrawBackground = true;
    static boolean m_bDrawHorizontsAndClouds = true;
    static boolean m_bDrawRoad = true;
    static boolean m_bDrawObjects = true;
    static boolean m_bDrawCars = true;
    static boolean m_bDrawWeather = true;
    public int m_nCurrentLevelIndex = -1;
    public int m_nTranslateScreenY = 0;
    long m_fxCameraDistanceFromStart = 12288L;
    long m_fxCameraStraight = 0L;
    int m_nMaxObjectsDistance = 900;
    CGCamera m_Camera = null;
    CGTrack m_Track = null;
    MissionParams m_Mission = null;
    public RoadRenderer m_RoadRenderer = null;
    CGRainSystem m_RainSystem = null;
    CGTexture m_BackGroundTexture = null;
    CGTexture m_HorizTexture = null;
    CGTexture m_Horiz2Texture = null;
    CGTexture m_RoadTexture = null;
    CGTexture m_CloudTexture = TextureManager.AddTexture("/gameplay/clouds.png");
    int m_nNrOfBolids;
    CGBolid[] m_Bolid;
    public long m_fxDeltaTime;
    public long m_fxCurrentTime;
    CGBolidRecord m_BestBolidRecord = null;
    CGBolidRecord m_BolidRecord = null;
    public long m_fxCameraAngle;
    int m_nGameState;
    public static int m_nPlayerGender = 0;
    public static final int ENGINE2D_STATE_PREPARE = 0;
    public static final int ENGINE2D_STATE_DRIVE = 1;
    public static final int ENGINE2D_STATE_ON_FINISH = 2;
    public static final int ENVIRONMENT_SAFARI = 1;
    public static final int ENVIRONMENT_WINTER = 2;
    public static final int ENVIRONMENT_HALOWEEN = 3;
    public static final int[] levelWeather = new int[]{1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0};
    public static final int[] levelEnvironment = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 4, 4, 5, 5, 5};
    public CGTexture[] m_TexturesSmoke = null;
    public int m_nNrOfPlayers = 0;
    public int m_nCurrentPlayer = 0;
    public int[] m_FinishTimes = new int[12];
    public int[] m_SortIndexFinishTimes = null;
    int roadLineParamsSize = 0;
    RoadLineParam[] roadLineParams = new RoadLineParam[320];
    protected CGTexture[] roadTex = new CGTexture[9];
    Vector2FX g_vecDir;
    Vector3FX g_vecPos3D;
    Vector2FX v;
    Random rnd;
    public static final int MAX_NUM_BOLIDS = 6;
    CGBillboardObject[] arrObj;
    int[] arrObjIndexes;
    CGBolid[] bol;
    Vector2FX vecPos;
    Vector2FX vecCameraDir;
    int[] arrPixels;

    public void SetGameState(int i) {
        this.m_nGameState = i;
    }

    public int GetGameState() {
        return this.m_nGameState;
    }

    public CGBolid GetHumanBolid() {
        return this.m_Bolid[0];
    }

    CGTrack GetTrack() {
        return this.m_Track;
    }

    public CGBolid GetBolid(int i) {
        return this.m_Bolid[i];
    }

    CarEngine2D() {
        this.roadTex[0] = TextureManager.AddTexture("/gameplay/Road1.png", 0, 0, null, null);
        this.roadTex[1] = TextureManager.AddTexture("/gameplay/Road2.png", 0, 0, null, null);
        this.roadTex[2] = TextureManager.AddTexture("/gameplay/Road3.png", 0, 0, null, null);
        this.roadTex[3] = TextureManager.AddTexture("/gameplay/Road4.png", 0, 0, null, null);
        this.roadTex[4] = TextureManager.AddTexture("/gameplay/Road5.png", 0, 0, null, null);
        this.roadTex[5] = TextureManager.AddTexture("/gameplay/Road6.png", 0, 0, null, null);
        this.roadTex[6] = TextureManager.AddTexture("/gameplay/Road7.png", 0, 0, null, null);
        this.roadTex[7] = TextureManager.AddTexture("/gameplay/Road8.png", 0, 0, null, null);
        this.roadTex[8] = TextureManager.AddTexture("/gameplay/Road9.png", 0, 0, null, null);
        this.g_vecDir = new Vector2FX();
        this.g_vecPos3D = new Vector3FX();
        this.v = new Vector2FX();
        this.rnd = new Random();
        this.arrObj = new CGBillboardObject[6];
        this.arrObjIndexes = new int[6];
        this.bol = new CGBolid[6];
        this.vecPos = new Vector2FX();
        this.vecCameraDir = new Vector2FX();
        this.arrPixels = new int[4];
        this.m_RainSystem = new CGRainSystem();
        this.m_RainSystem.Init(180, 90);
    }

    public void PrepareFinishTimes(int nMinTime, int nMaxTime) {
        this.m_FinishTimes[0] = this.GetBolid(0).GetTotalTime();
        int i = 1;
        while (i < 12) {
            long fAlpha = 4096 * i / 12;
            long fAdd1 = (long)RandSync.nextInt(250) - 500L;
            long fAdd2 = (long)RandSync.nextInt(250) - 500L;
            this.m_FinishTimes[i] = (int)((long)nMinTime * fAlpha + (long)nMaxTime * (4096L - fAlpha) + fAdd1);
            int n = i;
            this.m_FinishTimes[n] = this.m_FinishTimes[n] / 4096;
            this.m_FinishTimes[i] = (int)((long)nMinTime * fAlpha + (long)nMaxTime * (4096L - fAlpha) + fAdd2);
            int n2 = i++;
            this.m_FinishTimes[n2] = this.m_FinishTimes[n2] / 4096;
        }
    }

    public int GetRankingPos() {
        int nCurPlayer = 0;
        int nSize = this.m_nNrOfPlayers;
        if (nSize == 1) {
            nSize = 12;
        } else {
            nSize = this.m_nCurrentPlayer + 1;
            nCurPlayer = this.m_nCurrentPlayer;
        }
        int[] m_TmpTimeArray = new int[nSize];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = this.m_FinishTimes[i];
        }
        int[] m_IndexesArray = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] >= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            m_IndexesArray[j] = nMinIndex;
            if (nMinIndex == nCurPlayer) {
                return j;
            }
            m_TmpTimeArray[nMinIndex] = 1000000;
        }
        return -1;
    }

    public int GetSummaryRankingPos() {
        int nCurPlayer = 0;
        int nSize = this.m_nNrOfPlayers;
        if (nSize == 1) {
            nSize = 12;
        } else {
            nSize = this.m_nCurrentPlayer + 1;
            nCurPlayer = this.m_nCurrentPlayer;
        }
        int[] m_TmpTimeArray = new int[nSize];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = this.m_FinishTimes[i];
        }
        int[] m_IndexesArray = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] >= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            m_IndexesArray[j] = nMinIndex;
            if (nMinIndex == nCurPlayer) {
                return j;
            }
            m_TmpTimeArray[nMinIndex] = 1000000;
        }
        return -1;
    }

    public void Sort() {
        int nCurPlayer = 0;
        int nSize = this.m_nNrOfPlayers;
        if (nSize == 1) {
            nSize = 12;
        } else {
            nSize = this.m_nNrOfPlayers;
            nCurPlayer = -1;
        }
        int[] m_TmpTimeArray = new int[12];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = this.m_FinishTimes[i];
        }
        this.m_SortIndexFinishTimes = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] >= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            this.m_SortIndexFinishTimes[j] = nMinIndex;
            if (nMinIndex != nCurPlayer || nSize == 12) {
                // empty if block
            }
            m_TmpTimeArray[nMinIndex] = 1000000;
        }
        m_TmpTimeArray = null;
    }

    public void CreateAllTextures() {
    }

    protected void DeleteIngameTextures() {
    }

    public void PrepareRoad(int nEnvironment) {
        if (this.m_RoadRenderer != null && this.m_RoadRenderer.m_nEnvironment == nEnvironment) {
            return;
        }
        this.DeleteIngameTextures();
        this.m_TexturesSmoke = new CGTexture[9];
        this.m_TexturesSmoke[0] = TextureManager.AddTexture("/gameplay/dust1_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[1] = TextureManager.AddTexture("/gameplay/dust1_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[2] = TextureManager.AddTexture("/gameplay/dust1_3.png", 0, 0, null, null);
        this.m_TexturesSmoke[3] = TextureManager.AddTexture("/gameplay/s_right_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[4] = TextureManager.AddTexture("/gameplay/s_right_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[5] = TextureManager.AddTexture("/gameplay/s_right_3.png", 0, 0, null, null);
        this.m_TexturesSmoke[6] = TextureManager.AddTexture("/gameplay/s_left_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[7] = TextureManager.AddTexture("/gameplay/s_left_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[8] = TextureManager.AddTexture("/gameplay/s_left_3.png", 0, 0, null, null);
        for (int i = 0; i < 320; ++i) {
            this.roadLineParams[i] = new RoadLineParam();
        }
        this.m_RoadRenderer = new RoadRenderer();
        this.m_RoadRenderer.m_nType = 0;
        System.out.println("Prepare road env = " + nEnvironment);
        this.m_RoadTexture = this.roadTex[this.m_nCurrentLevelIndex % this.roadTex.length];
        this.m_RoadRenderer.m_nType = 1;
        this.m_RoadRenderer.m_Color1 = 50;
        this.m_RoadRenderer.m_Color2 = 60;
        int nRoadBlendColor = 0;
        this.m_RoadRenderer.m_R = (nRoadBlendColor & 0xFF0000) >> 16;
        this.m_RoadRenderer.m_G = (nRoadBlendColor & 0xFF00) >> 8;
        this.m_RoadRenderer.m_B = nRoadBlendColor & 0xFF;
        this.m_RoadRenderer.m_nEnvironment = nEnvironment;
        int color1 = backgroundColor1[(nEnvironment - 1) % backgroundColor1.length];
        int color2 = backgroundColor2[(nEnvironment - 1) % backgroundColor2.length];
        this.m_RoadRenderer.m_nColor1_R = color1 >> 16 & 0xFF;
        this.m_RoadRenderer.m_nColor1_G = color1 >> 8 & 0xFF;
        this.m_RoadRenderer.m_nColor1_B = color1 & 0xFF;
        this.m_RoadRenderer.m_nColor2_R = color2 >> 16 & 0xFF;
        this.m_RoadRenderer.m_nColor2_G = color2 >> 8 & 0xFF;
        this.m_RoadRenderer.m_nColor2_B = color2 & 0xFF;
        if (this.m_RoadTexture != null) {
            this.m_RoadRenderer.SetImage(this.m_RoadTexture.m_Image);
        }
        long fxRoadHalfSize = 380L * this.m_Camera.m_fxCameraScale;
        this.m_RoadRenderer.Setup((int)(fxRoadHalfSize >> 12), this.m_Camera.m_arrScaleForRay, this.m_Camera.m_nRayCastingCount);
    }

    public void SaveBolidRecord() {
        if (this.m_BolidRecord == null) {
            this.m_BestBolidRecord = null;
        } else {
            if (this.m_BestBolidRecord == null) {
                this.m_BestBolidRecord = this.m_BolidRecord;
            } else if (this.m_BolidRecord.GetTotalTime() < this.m_BestBolidRecord.GetTotalTime()) {
                this.m_BestBolidRecord = this.m_BolidRecord;
            }
            this.m_BolidRecord = null;
        }
    }

    public CGBolidRecord GetBestBolidRecord() {
        return this.m_BestBolidRecord;
    }

    public void ResetBestBolidRecord() {
        if (this.m_BestBolidRecord != null) {
            this.m_BestBolidRecord.Reset();
        }
        this.m_BestBolidRecord = null;
    }

    public CGBolidRecord GetBolidRecord() {
        return this.m_BolidRecord;
    }

    public void ResetBolidRecord() {
        if (this.m_BolidRecord != null) {
            this.m_BolidRecord.Reset();
            this.m_BolidRecord = null;
        }
    }

    public void Load(DataInputStream dis, int nLevelNr) {
        CGTexture bgTexture;
        this.m_nCurrentLevelIndex = nLevelNr;
        int nEnvironment = levelEnvironment[nLevelNr];
        System.out.println("Level ID = " + this.m_nCurrentLevelIndex + " Ev ID =  " + nEnvironment);
        this.m_BackGroundTexture = null;
        this.m_HorizTexture = null;
        this.m_Horiz2Texture = null;
        this.m_RoadTexture = null;
        if (this.m_Bolid != null && this.m_Bolid[0] != null) {
            this.m_Bolid[0].ResetObj();
            this.m_Bolid[0] = null;
            this.m_Bolid = null;
        }
        int nTrackIndex = nLevelNr;
        if (CGEngine.selectedRaceType == 1) {
            nTrackIndex = 10;
        }
        if (nTrackIndex != CGTrack.m_nLastTrackIndex) {
            if (this.m_Track != null) {
                this.m_Track.ResetObj();
                this.m_Track = null;
            }
            this.m_Track = new CGTrack();
            if (this.m_Mission == null) {
                this.m_Mission = new MissionParams();
            }
            try {
                this.deSerialize(dis);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.PrepareRoad(nEnvironment);
        }
        if ((bgTexture = TextureManager.AddTexture("/gameplay/BackGround" + nEnvironment + ".png", 0, 0, null, null)) != null) {
            this.m_BackGroundTexture = new CGTexture();
            this.m_BackGroundTexture.m_nSizeX = bgTexture.m_Image.getWidth();
            this.m_BackGroundTexture.m_nSizeY = ApplicationData.screenHeight;
            this.m_BackGroundTexture.m_szName = this.m_BackGroundTexture.m_szName;
            this.m_BackGroundTexture.m_Image = Graphic2D.ScaleImage(bgTexture.m_Image, this.m_BackGroundTexture.m_nSizeX, this.m_BackGroundTexture.m_nSizeY);
        }
        nEnvironment = nEnvironment <= 3 ? 1 : (nEnvironment <= 6 ? 2 : 3);
        this.m_HorizTexture = TextureManager.AddTexture("/gameplay/Horiz1Texture" + nEnvironment + ".png", 0, 0, null, null);
        this.m_Horiz2Texture = TextureManager.AddTexture("/gameplay/Horiz2Texture" + nEnvironment + ".png", 0, 0, null, null);
        this.AfterLoad();
        this.m_fxCurrentTime = 0L;
    }

    public void AfterLoad() {
        this.m_fxCameraDistanceFromStart = 4096L;
        this.m_fxCameraStraight = 0L;
        this.m_Camera.SetCurrentTrackNode(null);
        this.m_Track.m_vecLastCameraDir.x = -409600L;
        this.m_Track.m_vecLastCameraDir.y = -409600L;
        this.m_Camera.SetCurrentTrackNode(this.m_Track.m_pFirstTrackNode);
        this.m_nGameState = 0;
        this.m_Track.m_nCurrentCheckPointIndex = 0;
        this.m_Track.m_nCurrentStoneIndex = 0;
        this.m_Track.m_fxCurrentCameraAngle = 4096000L;
        this.m_RainSystem.SetMode(levelWeather[this.m_nCurrentLevelIndex]);
    }

    private void deSerialize(DataInputStream dis) throws IOException {
        System.out.println("m_Track.deSerialize(dis) start...");
        this.m_Track.deSerialize(dis);
        System.out.println("m_Mission.deSerialize(dis) start...");
        this.m_Mission.deSerialize(dis);
        System.out.println("m_Track.CreateCheckPointsFromMissionParams start...");
        this.m_Track.CreateCheckPointsFromMissionParams(this.m_Mission);
    }

    public void Go() {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Go();
        }
        this.m_nGameState = 1;
        this.m_fxCurrentTime = 0L;
    }

    public long GetMaxObjectsDistanceScale() {
        return this.m_Camera.CalculateObjectScaleForDistance(this.m_nMaxObjectsDistance * 4096);
    }

    public void SetCameraSettings(int nScreenX, int nScreenY, int nRayCount, int nCameraY, int nCameraDeep, long fxScale, int nTranslateScreenY) {
        this.m_Camera = new CGCamera();
        this.m_Camera.m_nScreenXSize = nScreenX;
        this.m_Camera.m_nScreenYSize = nScreenY;
        this.m_Camera.m_nCameraHeight = nCameraY;
        this.m_Camera.m_nCameraDistance = nCameraDeep;
        this.m_Camera.m_nRayCastingCount = nRayCount;
        this.m_Camera.m_fxCameraScale = fxScale;
        this.m_Camera.PreparePlaneDistanceForRay();
        this.m_Camera.PrepareScaleForRay();
        this.m_Camera.PrepareMipMapForRay();
        this.m_fxCameraDistanceFromStart = 4096L;
        this.m_fxCameraStraight = 0L;
        this.m_Camera.SetCurrentTrackNode(null);
        this.m_nTranslateScreenY = nTranslateScreenY;
    }

    public int GetHumanRacePosition() {
        long fxHumanDist = this.m_Bolid[0].GetRealDistanceFromStart();
        int nPos = 0;
        for (int i = 1; i < this.m_nNrOfBolids; ++i) {
            if (this.m_Bolid[i].GetState() != 2 && this.m_Bolid[i].GetRealDistanceFromStart() <= fxHumanDist) continue;
            ++nPos;
        }
        return nPos;
    }

    public int GetBolidRacePosition(int nIndex) {
        long fxHumanDist = this.m_Bolid[nIndex].GetRealDistanceFromStart();
        int nPos = 0;
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            if (nIndex == i || this.m_Bolid[i].GetState() != 2 && this.m_Bolid[i].GetRealDistanceFromStart() <= fxHumanDist) continue;
            ++nPos;
        }
        return nPos;
    }

    public void SetupLaps(int n) {
        if (Platform.IS_DEBUG_MODE) {
            n = 1;
        }
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].SetupLaps(n);
        }
        this.m_nGameState = 0;
    }

    void StepBolids() {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Step();
        }
        if (this.m_nGameState == 1 && this.m_Bolid[0].GetState() == 2) {
            this.m_nGameState = 2;
            System.out.println("Change state to ENGINE2D_STATE_ON_FINISH");
        }
        this.m_fxCameraDistanceFromStart = this.m_Bolid[0].GetDistanceFromStart() - 102400L;
        this.m_fxCameraStraight = this.m_Bolid[0].GetCurrentStraight();
        CGTrackNode pTN = this.m_Track.FindPlaceOnTrack3D(this.m_Bolid[0].GetDistanceFromStart(), 0L, null, this.g_vecPos3D, this.g_vecDir);
        this.m_Bolid[0].GetBillboardObject().m_fxY = this.g_vecPos3D.y;
        if (this.m_fxCameraDistanceFromStart > this.m_Track.m_fxTrackLength) {
            this.m_fxCameraDistanceFromStart -= this.m_Track.m_fxTrackLength;
            this.m_Camera.SetCurrentTrackNode(this.m_Track.m_pFirstTrackNode);
        } else if (this.m_fxCameraDistanceFromStart < 0L) {
            this.m_fxCameraDistanceFromStart = this.m_Track.m_fxTrackLength + this.m_fxCameraDistanceFromStart;
        }
    }

    void DrawWeather() {
        if (m_bDrawWeather && this.m_RainSystem != null) {
            this.m_RainSystem.Step(this.m_fxDeltaTime);
            this.m_RainSystem.Render();
        }
    }

    void DrawBackground() {
        if (this.m_BackGroundTexture != null) {
            int nW = this.m_BackGroundTexture.m_Image.getWidth();
            int numHorizonStrips = this.m_Camera.m_nScreenXSize / nW;
            for (int i = 0; i <= numHorizonStrips; ++i) {
                Graphic2D.DrawImage(this.m_BackGroundTexture, i * nW, 0 - this.m_nTranslateScreenY, 20);
            }
        } else {
            Graphic2D.FillRect(-1, 0, this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount - this.m_nTranslateScreenY, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nRayCastingCount);
            Graphic2D.FillRect(-7360513, 0, 0 - this.m_nTranslateScreenY, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount);
        }
    }

    public void RenderObject(Image t, int CenterX, int BottomY, int transf) {
        int nX = CenterX - t.getWidth() / 2;
        int nY = BottomY - t.getHeight();
        Graphic2D.DrawRegion(t, 0, 0, t.getWidth(), t.getHeight(), transf, nX, nY, 20);
    }

    public void RenderHoriz(CGTexture t, int dx, int dy, int nStartX, int nStartY) {
        int nMaxX = t.GetWidth();
        if ((nStartX %= nMaxX) > 0) {
            nStartX = -nStartX;
        }
        do {
            Graphic2D.DrawImage(t, nStartX, nStartY, 20);
        } while ((nStartX += nMaxX) < dx);
    }

    void DrawHorizontsAndClouds() {
        if (m_bDrawHorizontsAndClouds && this.m_Horiz2Texture != null) {
            int nRC = this.m_Camera.m_nRayCastingCount;
            if (this.roadLineParamsSize < nRC) {
                nRC = this.roadLineParamsSize;
            }
            int nStartX = 0;
            int nStartY2 = this.m_Camera.m_nScreenYSize - nRC - this.m_Horiz2Texture.GetHeight() + 3;
            this.m_RoadRenderer.m_nLandShaftY = this.m_Camera.m_nScreenYSize - nStartY2 - this.m_Horiz2Texture.GetHeight();
            this.RenderHoriz(this.m_Horiz2Texture, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nScreenYSize, nStartX / 2, 0);
        }
    }

    void DrawRoadToTable() {
        long fxRoadHalfSize = 190L * this.m_Camera.m_fxCameraScale;
        CGTrackNode pNN = this.m_Camera.GetCurrentTrackNode();
        CGTrackNode pOutNode = null;
        int nLastRayIndex = -1;
        int g_lastRayNumber = 0;
        long fxLastV = -4096L;
        this.roadLineParamsSize = 0;
        int nStepSize = 1;
        if (m_bDrawRoad) {
            for (int i = 0; i <= 300; i += nStepSize) {
                int nScreenY = this.m_Camera.m_nScreenYSize - 1 - i;
                long fxStartRayZ = 0L;
                long fxStartRayY = i * 4096;
                long fxStopRayZ = this.m_Camera.m_nCameraDistance * 4096;
                long fxStopRayY = (i - this.m_Camera.m_nCameraHeight) * 4096;
                long fxDlg = FXUtility.Sqrt(fxStopRayZ * fxStopRayZ / 4096L + fxStopRayY * fxStopRayY / 4096L);
                fxStopRayZ *= 4096L;
                fxStopRayZ /= fxDlg;
                fxStopRayY *= 4096L;
                fxStopRayY /= fxDlg;
                fxStopRayZ = (long)((float)fxStopRayZ * ((float)this.m_Camera.m_fxLastDistance / 4096.0f));
                fxStopRayY = (long)((float)fxStopRayY * ((float)this.m_Camera.m_fxLastDistance / 4096.0f));
                long fxV = this.m_Track.GetZForRay(fxStartRayY, fxStartRayZ, fxStopRayY += fxStartRayY, fxStopRayZ += fxStartRayZ, pNN);
                if ((float)fxV < 0.0f && fxLastV < 0L && ++g_lastRayNumber > 10) break;
                fxLastV = fxV;
                long fxZ = fxV;
                pOutNode = this.m_Track.GetXForZ(fxZ, pNN, this.v);
                if (pOutNode == null) break;
                long fxX = this.v.x;
                long fxY = this.v.y;
                pNN = pOutNode;
                long fxDist = fxZ;
                int nRayIndex = this.m_Camera.FindRayIndexForDistance(fxDist);
                if (nRayIndex < nLastRayIndex) break;
                nLastRayIndex = nRayIndex;
                fxX = this.m_Camera.CalculateFloatScreenX(fxX, fxZ);
                int nX = (int)((fxX *= this.m_Camera.m_fxCameraScale) / 0x1000000L);
                long v1 = (this.m_fxCameraDistanceFromStart + fxDist) / 4096L % 256L;
                this.roadLineParams[this.roadLineParamsSize].depth = fxDist;
                this.roadLineParams[this.roadLineParamsSize].nRayIndex = nRayIndex;
                this.roadLineParams[this.roadLineParamsSize].nX = nX + this.m_Camera.m_nScreenXSize / 2;
                this.roadLineParams[this.roadLineParamsSize].nY = nScreenY - this.m_nTranslateScreenY;
                this.roadLineParams[this.roadLineParamsSize].uv = v1;
                ++this.roadLineParamsSize;
            }
        }
        this.m_RoadRenderer.m_nLandShaftY = ApplicationData.screenHeight - this.m_nTranslateScreenY - this.roadLineParams[this.roadLineParamsSize - 1].nY;
        if (this.m_RoadRenderer.m_nLandShaftY < ApplicationData.screenHeight / 3) {
            this.m_RoadRenderer.m_nLandShaftY = ApplicationData.screenHeight / 3;
        }
    }

    void Step() {
        int i;
        this.m_fxCurrentTime += this.m_fxDeltaTime;
        this.StepBolids();
        for (i = 0; i < this.m_nNrOfBolids; ++i) {
            this.bol[i] = this.m_Bolid[i];
        }
        for (i = 0; i < this.m_nNrOfBolids; ++i) {
            int nIndex = -1;
            long fxD = -4096L;
            for (int k = 0; k < this.m_nNrOfBolids; ++k) {
                if (this.bol[k] == null || this.bol[k].GetRealDistanceFromStart() <= fxD) continue;
                nIndex = k;
                fxD = this.bol[k].GetRealDistanceFromStart();
            }
            if (nIndex < 0) break;
            this.arrObj[this.m_nNrOfBolids - 1 - i] = this.bol[nIndex].GetBillboardObject();
            this.arrObjIndexes[this.m_nNrOfBolids - 1 - i] = nIndex;
            this.bol[nIndex] = null;
        }
        CGTrackNode pN = this.m_Track.PrepareTrackForCamera(this.m_fxCameraDistanceFromStart, this.m_fxCameraStraight, null, this.m_Camera.m_fxLastDistance, this.vecPos, this.vecCameraDir, this.arrObj, this.m_nNrOfBolids);
        this.m_Camera.SetCurrentTrackNode(pN);
        this.m_fxCameraAngle = Vector2FX.AngleFromVector(this.vecCameraDir);
        this.DrawBackground();
        this.DrawHorizontsAndClouds();
        this.roadLineParamsSize = 0;
        this.DrawRoadToTable();
        int nCenterX = 0;
        int nBottomY = 0;
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
        if (m_bDrawObjects) {
            for (int j = this.roadLineParamsSize - 1; j >= 0; --j) {
                int nSize = this.m_Track.m_arrCurrentObjects.size();
                for (int i2 = nSize - 1; i2 >= 0; --i2) {
                    CGBillboardObject pO = (CGBillboardObject)this.m_Track.m_arrCurrentObjects.elementAt(i2);
                    if (pO.m_fxTrZ < 0L || pO.m_fxTrZ > (long)(this.m_nMaxObjectsDistance * 4096) || pO.m_fxTrZ < this.roadLineParams[j].depth || this.m_Camera.CalculateObjectScreenPosition(pO, this.arrPixels) <= 0) continue;
                    this.arrPixels[1] = this.m_Camera.m_nScreenYSize - this.arrPixels[1];
                    this.arrPixels[3] = this.m_Camera.m_nScreenYSize - this.arrPixels[3];
                    this.arrPixels[0] = this.arrPixels[0] + this.m_Camera.m_nScreenXSize / 2;
                    this.arrPixels[2] = this.arrPixels[2] + this.m_Camera.m_nScreenXSize / 2;
                    if (this.arrPixels[0] > this.m_Camera.m_nScreenXSize || this.arrPixels[2] < 0) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                        continue;
                    }
                    nCenterX = (this.arrPixels[0] + this.arrPixels[2]) / 2;
                    if (nCenterX > this.m_Camera.m_nScreenXSize || nCenterX < 0) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                        continue;
                    }
                    nBottomY = this.arrPixels[3];
                    if (pO.m_nLinearScale <= 0) {
                        int nMipMapIndex;
                        long fxD;
                        if (pO.m_nCarIndex == 0) {
                            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForObjects;
                            if (pO.m_Texture != null) {
                                fxD = pO.m_fxTrZ;
                                nMipMapIndex = CGTexture.m_nNrOfMipMaps * (int)(pO.m_fxTrZ / (long)this.m_nMaxObjectsDistance) / 4096;
                                if (nMipMapIndex >= CGTexture.m_nNrOfMipMaps) {
                                    nMipMapIndex = CGTexture.m_nNrOfMipMaps - 1;
                                }
                                if (nMipMapIndex < 0) {
                                    nMipMapIndex = 0;
                                }
                                nMipMapIndex = CGTexture.m_nNrOfMipMaps - 1 - nMipMapIndex;
                                this.RenderObject(pO.m_Texture.m_MipMaps[nMipMapIndex], nCenterX, nBottomY - this.m_nTranslateScreenY, pO.m_nMirrored);
                            }
                        } else {
                            int jump;
                            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
                            fxD = pO.m_fxTrZ;
                            nMipMapIndex = CGTexture.m_nNrOfMipMaps * (int)((pO.m_fxTrZ + 614400L) / (long)this.m_nMaxObjectsDistance) / 4096;
                            if (nMipMapIndex >= CGTexture.m_nNrOfMipMaps) {
                                nMipMapIndex = CGTexture.m_nNrOfMipMaps - 1;
                            }
                            if (nMipMapIndex < 0) {
                                nMipMapIndex = 0;
                            }
                            nMipMapIndex = CGTexture.m_nNrOfMipMaps - 1 - nMipMapIndex;
                            int nBolidIndex = pO.m_nCarIndex - 1;
                            int nAngleVariant = 3;
                            boolean rVariant = false;
                            int nTransf = 0;
                            long fxBolidAngle = Vector2FX.AngleFromVector(this.m_Bolid[nBolidIndex].m_DirVector);
                            if ((fxBolidAngle -= this.m_fxCameraAngle) > 737280L) {
                                fxBolidAngle -= 1474560L;
                            } else if (fxBolidAngle < -737280L) {
                                fxBolidAngle += 1474560L;
                            }
                            if (pO.m_nCarIndex > 1) {
                                if (fxBolidAngle > 143360L) {
                                    nAngleVariant = 0;
                                    nTransf = 2;
                                } else if (fxBolidAngle > 81920L) {
                                    nAngleVariant = 1;
                                    nTransf = 2;
                                } else if (fxBolidAngle > 10L) {
                                    nAngleVariant = 2;
                                    nTransf = 2;
                                } else if (fxBolidAngle < -143360L) {
                                    nAngleVariant = 0;
                                } else if (fxBolidAngle < -81920L) {
                                    nAngleVariant = 1;
                                } else if (fxBolidAngle < -10L) {
                                    nAngleVariant = 2;
                                } else {
                                    nAngleVariant = 3;
                                    nTransf = 0;
                                }
                                if (this.m_nGameState == 2) {
                                    nAngleVariant = 3;
                                }
                            } else if (this.m_Bolid[nBolidIndex].IsStraightLeft() > 0) {
                                nAngleVariant = this.m_Bolid[nBolidIndex].m_fxSterringLeftTime < 600L ? 2 : 1;
                                this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant;
                            } else if (this.m_Bolid[nBolidIndex].IsStraightRight() > 0) {
                                nAngleVariant = this.m_Bolid[nBolidIndex].m_fxSterringRightTime < 600L ? 2 : 1;
                                nTransf = 2;
                                this.m_Bolid[nBolidIndex].m_nViewAngleVariant = -nAngleVariant;
                            } else {
                                long fxff = this.m_Bolid[nBolidIndex].GetCurrentSterringStraight();
                                if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == 1) {
                                    this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant = 2;
                                } else if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == -1) {
                                    nAngleVariant = 2;
                                    this.m_Bolid[nBolidIndex].m_nViewAngleVariant = -nAngleVariant;
                                    nTransf = 2;
                                } else if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == 2) {
                                    this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant = 3;
                                } else if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == -2) {
                                    this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant = 3;
                                    nTransf = 2;
                                }
                            }
                            if ((jump = this.m_Bolid[nBolidIndex].m_nJumpHeight) != 0) {
                                System.out.println("JJJ = " + jump);
                            }
                            if (pO.m_nCarIndex == 1) {
                                if (this.m_Bolid[0].IsDrift() != 0) {
                                    nAngleVariant = 0;
                                    nTransf = this.m_Bolid[0].IsDrift() > 0 ? 2 : 0;
                                }
                                this.m_Bolid[nBolidIndex].DrawSmoke(nCenterX, nBottomY - this.m_nTranslateScreenY);
                                this.RenderObject(this.m_Bolid[nBolidIndex].m_Textures[nAngleVariant].m_MipMaps[nMipMapIndex], nCenterX, nBottomY - this.m_nTranslateScreenY - jump, nTransf);
                            } else {
                                this.m_Bolid[nBolidIndex].DrawSmoke(nCenterX, nBottomY - this.m_nTranslateScreenY);
                                this.RenderObject(this.m_Bolid[nBolidIndex].m_Textures[nAngleVariant].m_MipMaps[nMipMapIndex], nCenterX, nBottomY - this.m_nTranslateScreenY - jump, nTransf);
                            }
                        }
                    }
                    this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                }
                this.m_RoadRenderer.DrawLine(j, this.roadLineParams[j].nRayIndex, this.roadLineParams[j].depth, this.roadLineParams[j].nX, this.roadLineParams[j].nY, this.roadLineParams[j].uv);
            }
        }
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
        this.DrawWeather();
    }

    public void SetupBolids(int nCount) {
        int i;
        int i2;
        this.m_nNrOfBolids = nCount;
        long[] arrStartPos = new long[nCount];
        long[] arrStartStraight = new long[nCount];
        long[] arrMaxVelocity = new long[nCount];
        long[] arrAccelerate = new long[nCount];
        String[] arrNick = new String[nCount];
        arrNick[0] = EditChampionshipsUserName.playerNick;
        if (CGEngine.selectedGameMode == 2) {
            // empty if block
        }
        if (nCount > 1) {
            arrNick[1] = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_1");
        }
        if (nCount > 8) {
            for (i2 = 2; i2 < nCount; ++i2) {
                arrNick[i2] = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_" + (i2 + 1));
            }
        }
        if (nCount == 1) {
            this.ResetBestBolidRecord();
            this.m_nNrOfBolids = nCount;
            arrStartPos[0] = 0x190000L;
            arrStartStraight[0] = 0L;
            arrMaxVelocity[0] = 1843200L;
            arrAccelerate[0] = 327680L;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (i2 = 0; i2 < this.m_nNrOfBolids; ++i2) {
                this.m_Bolid[i2] = new CGBolid(i2);
            }
            this.m_Bolid[0].SetHuman(1);
        } else if (nCount == 2) {
            this.ResetBolidRecord();
            this.ResetBestBolidRecord();
            arrStartPos[0] = 0x190000L;
            arrStartPos[1] = 0x190000L;
            arrStartStraight[0] = 2048L;
            arrStartStraight[1] = -2048L;
            arrMaxVelocity[0] = 1843200L;
            arrMaxVelocity[1] = 1720320L;
            arrAccelerate[0] = 327680L;
            arrAccelerate[1] = 368640L;
            this.m_nNrOfBolids = nCount;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (i2 = 0; i2 < this.m_nNrOfBolids; ++i2) {
                this.m_Bolid[i2] = new CGBolid(i2);
            }
            for (i2 = 0; i2 < this.m_nNrOfBolids; ++i2) {
                this.m_Bolid[i2].SetOpponents(this.m_nNrOfBolids, this.m_Bolid);
            }
            this.m_Bolid[0].SetHuman(1);
        } else if (nCount == 6) {
            this.ResetBolidRecord();
            this.ResetBestBolidRecord();
            arrStartPos[0] = 1024000L;
            arrStartPos[1] = 0x104000L;
            arrStartPos[2] = 1228800L;
            arrStartPos[3] = 1228800L;
            arrStartPos[4] = 1433600L;
            arrStartPos[5] = 1433600L;
            for (i2 = 0; i2 < 6; ++i2) {
                arrStartStraight[i2] = (i2 % 2 == 0 ? -5 : 5) * 4096 / 10;
            }
            arrMaxVelocity[0] = 1843200L;
            arrMaxVelocity[1] = 0x226000L;
            arrMaxVelocity[2] = 2048000L;
            arrMaxVelocity[3] = 0x208000L;
            arrMaxVelocity[4] = 1843200L;
            arrMaxVelocity[5] = 1433600L;
            arrAccelerate[0] = 327680L;
            arrAccelerate[1] = 368640L;
            arrAccelerate[2] = 471040L;
            arrAccelerate[3] = 491520L;
            arrAccelerate[4] = 450560L;
            arrAccelerate[5] = 430080L;
            this.m_nNrOfBolids = nCount;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (i2 = 0; i2 < this.m_nNrOfBolids; ++i2) {
                this.m_Bolid[i2] = new CGBolid(i2);
            }
            for (i2 = 0; i2 < this.m_nNrOfBolids; ++i2) {
                this.m_Bolid[i2].SetOpponents(this.m_nNrOfBolids, this.m_Bolid);
            }
            this.m_Bolid[0].SetHuman(1);
        } else {
            int i3;
            this.ResetBolidRecord();
            this.ResetBestBolidRecord();
            Random rnd = new Random();
            for (i3 = 0; i3 < nCount; ++i3) {
                arrStartPos[i3] = i3 * 50 * 4096;
                arrStartStraight[i3] = (i3 % 2 == 0 ? 5 : -5) * 4096 / 10;
                arrMaxVelocity[i3] = (400 + i3 % 3 * 50) * 4096;
                arrAccelerate[i3] = (80 + i3 % 3 * 10) * 4096;
            }
            this.m_nNrOfBolids = nCount;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (i3 = 0; i3 < this.m_nNrOfBolids; ++i3) {
                this.m_Bolid[i3] = new CGBolid(i3);
            }
            for (i3 = 0; i3 < this.m_nNrOfBolids; ++i3) {
                this.m_Bolid[i3].SetOpponents(this.m_nNrOfBolids, this.m_Bolid);
            }
            arrStartPos[0] = 50 * nCount;
            this.m_Bolid[0].SetHuman(1);
        }
        for (i = 2; i < nCount; ++i) {
            arrNick[i] = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_" + (i + 1));
        }
        for (i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Setup(arrStartPos[i], arrStartStraight[i], arrMaxVelocity[i], arrAccelerate[i]);
            this.m_Bolid[i].SetBolidIndex(i);
            this.m_Bolid[i].SetNick(arrNick[i]);
            System.out.println("Name " + arrNick[i]);
        }
        this.m_nGameState = 0;
    }

    public class RoadLineParam {
        public long depth;
        public int nRayIndex;
        public int nX;
        public int nY;
        public long uv;
    }
}

