/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class LoadingLevelScreen
extends MainUSRScreen {
    private int emptyBarColor = -16777216;
    private int emptyBarHeight = 30;
    private int fullBarColor = -1507581;
    private int fullBarHeight = 22;
    private static int numPlayedGames = 0;
    private int counterDraw = 0;
    private int fontID = 0;
    private Vector textLines;

    public LoadingLevelScreen() {
        CGEngine.damageSystem.reapairAll();
        this.drawLogo = true;
        this.drawStrip1 = false;
        this.drawCash = false;
        this.drawFP = false;
        ApplicationData.soundEngine.stopMID();
        this.counterDraw = 0;
        this.setupDrawingArea();
        String loadingHintID = "ID_GAME_LOADING";
        if (CGEngine.selectedRaceType == 1) {
            loadingHintID = "ID_LOADING_HINT_14MILE";
        } else if (CGEngine.selectedRaceType == 2) {
            loadingHintID = "ID_LOADING_HINT_TIMEATTACK";
        }
        this.textLines = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, loadingHintID), "+", ApplicationData.screenWidth, 0);
    }

    public void updateSize() {
    }

    public void drawWindowForeground() {
    }

    public static void deSerialize(DataInputStream dis) throws IOException {
        numPlayedGames = dis.readInt();
    }

    public static void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(numPlayedGames);
    }

    private void setupDrawingArea() {
    }

    public void draw() {
        String szName;
        int nTop = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() / 2 - this.emptyBarHeight;
        Graphic2D.SetColor(this.emptyBarColor);
        Graphic2D.FillRect(0, nTop, ApplicationData.screenWidth, (this.emptyBarHeight - this.fullBarHeight) / 2);
        Graphic2D.FillRect(0, nTop + this.emptyBarHeight - (this.emptyBarHeight - this.fullBarHeight) / 2, ApplicationData.screenWidth, (this.emptyBarHeight - this.fullBarHeight) / 2);
        Graphic2D.SetColor(this.fullBarColor);
        Graphic2D.FillRect(0, nTop += (this.emptyBarHeight - this.fullBarHeight) / 2, this.counterDraw * ApplicationData.screenWidth / 100, this.fullBarHeight);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_LOADING"), ApplicationData.screenWidth / 2, nTop + this.fullBarHeight / 2, 3, this.fontID);
        if (this.counterDraw == 10) {
            szName = "/gameplay/track" + (CGEngine.selectedTrack + 1) % 4 + ".tk";
            ApplicationData.game.startLoading(szName);
        }
        if (this.counterDraw == 20) {
            szName = "/gameplay/track" + (CGEngine.selectedTrack + 1) % 4 + ".tk";
            ApplicationData.game.stepLoading(szName);
        }
        if (this.counterDraw == 30) {
            szName = "/gameplay/track" + (CGEngine.selectedTrack + 1) % 4 + ".tk";
            ApplicationData.game.stepLoading(szName);
        }
        if (this.counterDraw == 40) {
            szName = "/gameplay/track" + (CGEngine.selectedTrack + 1) % 4 + ".tk";
            ApplicationData.game.stepLoading(szName);
        }
        if (this.counterDraw == 50) {
            szName = "/gameplay/track" + (CGEngine.selectedTrack + 1) % 4 + ".tk";
            ApplicationData.game.stepLoading(szName);
        }
        if (this.counterDraw >= 100) {
            szName = "/gameplay/track" + (CGEngine.selectedTrack + 1) % 4 + ".tk";
            System.out.println("-----------------------------------------------------------ktory track " + CGEngine.selectedTrack);
            ApplicationData.game.endLoading(szName);
            ApplicationData.generalGameMode = 4;
            this.readyForClose = true;
        }
    }

    public void onUpdate(int deltaTime) {
        ++this.counterDraw;
    }
}

