/*
 * Decompiled with CFR 0.152.
 */
package pagenetsoft.game;

import java.io.IOException;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import pagenetsoft.game.Block;
import pagenetsoft.game.PNCanvas;
import pagenetsoft.game.PNMidlet;
import pagenetsoft.game.PNSound;
import pagenetsoft.game.PNStage;
import pagenetsoft.game.ShameMain;
import pagenetsoft.game.VectorBlock;

class GameShame
extends PNStage {
    private final String lite;
    private final String girl;
    private final String[] sLevel = new String[]{"/yoshe/yoshe_1.png"};
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private boolean jump = false;
    private boolean isGameOver = false;
    private int scores = 0;
    private VectorBlock listFall = new VectorBlock();
    private Stack stackFall = new Stack();
    private boolean isFall = false;
    private Vector listDown = new Vector();
    private int maskDown = 0;
    private boolean isDown = false;
    private VectorBlock listFlip = new VectorBlock();
    private boolean isFlip = false;
    private Block[][] area;
    private byte[] colorNext;
    private byte countNext = 0;
    private long timeNext = 0L;
    private int areaRows;
    private int areaCols;
    private byte level = 0;
    private Image[] img = null;
    private Image imgBG;
    private Random rand;
    private int cursorCol;
    private int cursorRow;
    private boolean cursorVisible;
    private boolean cursorSelect;
    private int BLOCK_SIZE = 24;
    private final int BLOCK_TYPES;
    private final int IMG_BG;
    private final int IMG_BG_DARK;
    private final int IMG_BLOCKS;
    private final int IMG_CURSOR;
    private final int IMG_CURSOR_SEL;
    private int PANE_HEIGHT = 32;
    private long stateTime = 0L;
    private byte state = 0;
    private final byte G_PREPARE;
    private final byte G_PLAY;
    private final byte G_WAITREADY = (byte)2;
    private final byte G_OVER = (byte)3;
    private final byte G_LEVELMSG = (byte)5;
    private final int txtColor;
    private boolean gotHighScr = false;
    private boolean hsSound = false;
    private int backlightTime;
    private boolean isMoveCursor = false;
    private boolean isAddLine = false;
    private boolean isAddBlock = false;
    private boolean changeScores = false;
    private boolean isChangeHeap = false;
    private boolean paintBegin = false;
    private int[] oldCur = new int[]{0, 0};
    private int[] rect = new int[]{0, 0, 0, 0};
    private int[] rct = new int[]{0, 0, 0, 0};
    private int[] transLevelImg;
    int numPixles = 25520;
    PNSound sound;
    private long freeMem = 0L;
    private long totalMem = 0L;
    Runtime rt = Runtime.getRuntime();

    public GameShame(PNCanvas pNCanvas) {
        super(pNCanvas);
        this.lite = "lite";
        this.girl = "yoshe";
        this.BLOCK_TYPES = 5;
        this.IMG_BG = 0;
        this.IMG_BG_DARK = 1;
        this.IMG_BLOCKS = 2;
        this.IMG_CURSOR = 7;
        this.IMG_CURSOR_SEL = 8;
        this.G_PREPARE = 0;
        this.G_PLAY = 1;
        this.txtColor = 16631041;
        this.imgBG = ShameMain.imgBG;
        this.rand = new Random();
        this.sound = PNSound.SOUND;
        int n = 25520;
        this.transLevelImg = new int[n];
        for (int i = 0; i < n; ++i) {
            this.transLevelImg[i] = -1627389952;
        }
        System.out.println(" <<<<<<<<<<-----------After GameShame Constractor CALLED---------->>>>>>");
        System.out.println(" Freememory =" + this.freeMem);
        System.out.println(" totalmemory =" + this.totalMem);
    }

    public void reload() {
        this.freeMemory();
        System.out.println("reload () CalledMemory Release FreeMemory ");
        System.out.println(" <<<<<<<<<<---------reload() called GameShame---------->>>>>>");
        this.freeMem = this.rt.freeMemory();
        this.totalMem = this.rt.totalMemory();
        System.out.println(" Freememory =" + this.freeMem);
        System.out.println(" totalmemory =" + this.totalMem);
        this.imgBG = ShameMain.imgBG;
        System.out.println(" Img BG reload ");
        this.sound = PNSound.SOUND;
        System.out.println(" SOUND  reload");
        this.transLevelImg = new int[this.numPixles];
        for (int i = 0; i < this.numPixles; ++i) {
            this.transLevelImg[i] = -1627389952;
        }
        this.state = 0;
        this.stateTime = 0L;
        this.scores = 0;
        this.isGameOver = false;
    }

    protected void paint(Graphics graphics) {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.paintGame(graphics);
                break;
            }
            case 2: {
                this.paintWaitReady(graphics);
                break;
            }
            case 3: {
                if (this.scores > ShameMain.highScr) {
                    ShameMain.highScr = this.scores;
                    this.gotHighScr = true;
                    this.hsSound = true;
                }
                if (this.gotHighScr) {
                    if (this.stateTime < 2000L) {
                        this.paintGameOver(graphics);
                        break;
                    }
                    this.paintHighScore(graphics);
                    break;
                }
                this.paintGameOver(graphics);
                break;
            }
            case 5: {
                this.paintLevelMsg(graphics);
            }
        }
    }

    private void msgPane(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(45, this.centerY - 60, 230, 100);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(45, this.centerY - 60, 230, 100);
    }

    private void paintLevelMsg(Graphics graphics) {
        this.paintGame(graphics);
        this.msgPane(graphics);
        ShameMain.drawString(graphics, "Clear the playfield", this.centerX - 103, this.centerY - 20, 1, 2);
    }

    private void paintPrepare(Graphics graphics) {
        graphics.drawImage(ShameMain.imgBG, 0, 0, 0x10 | 4);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        graphics.setColor(16631041);
    }

    private void paintHighScore(Graphics graphics) {
        this.paintGame(graphics);
        this.msgPane(graphics);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.drawShString(graphics, "Game Over", this.centerX, this.centerY + 1, 17, 16631041);
        ShameMain.drawString(graphics, "CONGRATULATIONS!", this.centerX - 106, this.centerY - 32, 1, 2);
        ShameMain.drawString(graphics, "you set a new", this.centerX - 75, this.centerY - 10, 1, 2);
        ShameMain.drawString(graphics, "high score!", this.centerX - 60, this.centerY + 15, 1, 2);
    }

    private void paintGameOver(Graphics graphics) {
        this.paintGame(graphics);
        this.msgPane(graphics);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.drawShString(graphics, "Game Over", this.centerX, this.centerY + 1, 17, 16631041);
        ShameMain.drawString(graphics, "Well Done!", this.centerX - 56, this.centerY - 14, 1, 2);
        System.gc();
    }

    private void paintWaitReady(Graphics graphics) {
        this.paintGame(graphics);
        graphics.setClip(0, 0, this.sizeX, this.sizeY);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.drawShString(graphics, "Wait Ready", this.centerX, this.centerY + 1, 17, 16631041);
    }

    private void paintGame(Graphics graphics) {
        graphics.setClip(0, 0, this.sizeX, this.sizeY);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.sizeX, this.sizeY);
        this.paintBG(graphics);
        this.paintArea(graphics);
        if (this.isFall) {
            this.paintFall(graphics);
        }
        this.paintPane(graphics);
        this.paintCursor(graphics);
    }

    private void drawShString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        ShameMain.drawString(graphics, string, n, n2, n3, n4);
    }

    private void paintBG(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.sizeX, this.sizeY);
    }

    private void paintPane(Graphics graphics) {
        graphics.setColor(255);
        graphics.fillRect(0, this.sizeY - this.PANE_HEIGHT, this.sizeX, this.PANE_HEIGHT);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        int n = this.sizeY - (this.PANE_HEIGHT - this.BLOCK_SIZE - 8 >> 1) - (graphics.getFont().getHeight() >> 1);
        this.drawShString(graphics, "SCORE:", 5, n - 13, 1, 2);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        String string = String.valueOf(this.scores);
        this.drawShString(graphics, string, 95, n - 13, 1, 2);
    }

    private void paintArea(Graphics graphics) {
        for (int i = 0; i < this.areaCols; ++i) {
            for (int j = 0; j < this.areaRows; ++j) {
                Block block = this.area[j][i];
                if (block == null) continue;
                graphics.drawImage(this.img[2 + block.color], block.x, block.y, 0x20 | 4);
            }
        }
    }

    private void paintCursor(Graphics graphics) {
        if (this.isFall) {
            return;
        }
        if (this.cursorVisible && this.state == 1) {
            int n = this.cursorCol * this.BLOCK_SIZE;
            int n2 = this.sizeY - this.PANE_HEIGHT - this.cursorRow * this.BLOCK_SIZE - this.BLOCK_SIZE;
            if (!this.paintBegin) {
                graphics.setClip(n, n2, this.BLOCK_SIZE, this.BLOCK_SIZE);
            }
            Image image = this.cursorSelect ? this.img[8] : this.img[7];
            graphics.drawImage(image, n, n2, 0x10 | 4);
            image = null;
            this.oldCur[0] = this.cursorCol;
            this.oldCur[1] = this.cursorRow;
        }
    }

    protected void update(long l) {
        this.stateTime += l;
        switch (this.state) {
            case 0: {
                this.stopSound();
                this.prepareLevel();
                this.sound.playRing(3);
                this.state = (byte)2;
                this.stateTime = 0L;
                break;
            }
            case 1: {
                if (this.isGameOver) {
                    this.state = (byte)3;
                    this.stateTime = 0L;
                    this.startSoundOver(1);
                    break;
                }
                this.updateGame(l);
                break;
            }
            case 2: {
                if (this.stateTime <= 1000L) break;
                this.state = (byte)5;
                this.stateTime = 0L;
                break;
            }
            case 5: {
                if (!this.jump && this.stateTime <= 5000L) break;
                this.state = 1;
                this.stateTime = 0L;
                break;
            }
            case 3: {
                if (this.hsSound && this.stateTime > 2000L) {
                    this.stopSound();
                    this.startSoundOver(2);
                    this.hsSound = false;
                }
                if (this.stateTime <= 3000L || this.gotHighScr) break;
                this.stateTime = 0L;
                this.stopSound();
                this.freeMemory();
                System.out.println("<<<<<<-------update () GameShame FreeMemory -->>Before Shrot Menu display----->>>>>>> ");
                this.freeMem = this.rt.freeMemory();
                this.totalMem = this.rt.totalMemory();
                System.out.println(" update() GameShame Freememory =" + this.freeMem);
                System.out.println(" update() GameShame totalmemory =" + this.totalMem);
                PNMidlet.MIDLET.setNewState(12);
            }
        }
        this.jump = false;
    }

    protected void updateGame(long l) {
        if (this.left) {
            --this.cursorCol;
            if (this.cursorCol < 0) {
                this.cursorCol = this.areaCols - 1;
            }
            this.left = false;
        }
        if (this.right) {
            ++this.cursorCol;
            if (this.cursorCol >= this.areaCols) {
                this.cursorCol = 0;
            }
            this.right = false;
        }
        if (this.down) {
            --this.cursorRow;
            if (this.cursorRow < 0) {
                this.cursorRow = this.areaRows - 1;
            }
            this.down = false;
        }
        if (this.up) {
            ++this.cursorRow;
            if (this.cursorRow >= this.areaRows) {
                this.cursorRow = 0;
            }
            this.up = false;
        }
        if (this.cursorSelect && !this.isFall && !this.isDown && !this.isFlip) {
            this.cursorSelect = false;
            this.checkGameStatus();
        }
        if (this.jump && !this.cursorSelect) {
            this.cursorSelect = true;
            this.jump = false;
            this.explode();
        }
        if (this.cursorSelect) {
            if (this.isFall) {
                this.updateFall((int)l);
            }
            if (this.isDown) {
                this.updateDown((int)l);
            }
            if (this.isFlip) {
                this.updateFlip((int)l);
            }
        }
    }

    private void updateDown(int n) {
        boolean bl = true;
        int n2 = this.listDown.size();
        for (int i = 0; i < n2; ++i) {
            Block block = (Block)this.listDown.elementAt(i);
            block.update(n);
            if (!bl || !block.movement) continue;
            bl = false;
        }
        if (bl) {
            this.listDown.removeAllElements();
            this.isDown = false;
            this.startFlip();
        }
    }

    private void updateFlip(int n) {
        boolean bl = true;
        int n2 = this.listFlip.size();
        for (int i = 0; i < n2; ++i) {
            Block block = (Block)this.listFlip.elementAt(i);
            block.update(n);
            if (!bl || !block.movement) continue;
            bl = false;
        }
        if (bl) {
            this.isFlip = false;
            this.listFlip.removeAllElements();
        }
    }

    private void updateFall(int n) {
        boolean bl = true;
        int n2 = this.listFall.size();
        for (int i = 0; i < n2; ++i) {
            Block block = (Block)this.listFall.elementAt(i);
            block.update(n);
            if (!bl || !block.movement) continue;
            bl = false;
        }
        if (bl) {
            this.isFall = false;
            this.listFall.deleteAll();
            this.stopSound();
        }
    }

    private void paintFall(Graphics graphics) {
        for (int i = this.listFall.size() - 1; i >= 0; --i) {
            Block block;
            try {
                block = (Block)this.listFall.elementAt(i);
                graphics.drawImage(this.img[2 + block.color], block.x, block.y, 0x20 | 4);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            block = null;
        }
        System.gc();
    }

    private void startSoundOver(int n) {
        this.sound.pause();
        this.sound.resume();
        this.sound.playOver(n);
    }

    private void startSound() {
        this.sound.resume();
    }

    private void startSoundRing() {
        this.sound.resume();
        this.sound.playRing(0);
    }

    private void stopSound() {
        this.sound.pause();
    }

    private void backlight() {
    }

    private void startFall() {
        this.sound.playClickBlocks();
        int n = this.listFall.size();
        this.scores += n * (n - 1);
        for (int i = 0; i < n; ++i) {
            Block block = (Block)this.listFall.elementAt(i);
            block.startFall(i);
        }
    }

    private void startDown() {
        this.listDown.removeAllElements();
        for (int i = 0; i < this.areaCols; ++i) {
            if ((this.maskDown & 1 << i) == 0) continue;
            byte by = 0;
            for (int j = 0; j < this.areaRows; ++j) {
                Block block = this.area[j][i];
                if (block == null) {
                    by = (byte)(by - 1);
                    continue;
                }
                if (by >= 0) continue;
                this.area[j][i] = null;
                this.area[j + by][i] = block;
                block.startDown(by);
                this.listDown.addElement(block);
            }
        }
        if (this.listDown.size() > 0) {
            this.isDown = true;
        } else {
            this.startFlip();
        }
    }

    private void startFlip() {
        Block block;
        int n;
        int n2;
        this.listFlip.removeAllElements();
        int n3 = 1 + this.areaCols >> 1;
        byte by = 0;
        for (n2 = n3; n2 < this.areaCols; ++n2) {
            if (this.area[0][n2] == null) {
                by = (byte)(by - 1);
                continue;
            }
            if (by == 0) continue;
            for (n = 0; n < this.areaRows && this.area[n][n2] != null; ++n) {
                Block block2 = this.area[n][n2];
                this.area[n][n2 + by] = block2;
                block = block2;
                this.area[n][n2] = null;
                block.startFlip(by);
                this.listFlip.addElement(block);
            }
        }
        by = 0;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            block = this.area[0][n2];
            if (block == null) {
                by = (byte)(by + 1);
                continue;
            }
            if (by == 0) continue;
            for (n = 0; n < this.areaRows && this.area[n][n2] != null; ++n) {
                Block block3 = this.area[n][n2];
                this.area[n][n2 + by] = block3;
                block = block3;
                this.area[n][n2] = null;
                block.startFlip(by);
                this.listFlip.addElement(block);
            }
        }
        if (this.listFlip.size() > 0) {
            this.isFlip = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        if (this.state == 3 && this.stateTime > 2000L) {
            this.stateTime = 0L;
            this.gotHighScr = false;
            this.stopSound();
            this.freeMemory();
            System.out.println("<<<<<<<----- keyPressed GAME Over Memory Free---->>>>>> ");
            System.out.println(" <<<<<<<<<<----------- GameShame keyPressed CALLED---------->>>>>>");
            this.freeMem = this.rt.freeMemory();
            this.totalMem = this.rt.totalMemory();
            System.out.println(" Freememory =" + this.freeMem);
            System.out.println(" totalmemory =" + this.totalMem);
            PNMidlet.MIDLET.setNewState(12);
            System.gc();
        } else {
            if (n == -7) {
                if (ShameMain.smallfontyellow != null) {
                    ShameMain.smallfontyellow = null;
                }
                System.out.println("Memory Release FreeMemory");
                System.out.println(" <<<<<<<<<<-----------Left Button pressed GameShame keyPressed CALLED---------->>>>>>");
                this.freeMem = this.rt.freeMemory();
                this.totalMem = this.rt.totalMemory();
                System.out.println(" Freememory =" + this.freeMem);
                System.out.println(" totalmemory =" + this.totalMem);
                PNMidlet.MIDLET.setNewState(2);
            }
            if (this.isFall) {
                return;
            }
            int n2 = this.canvas.getGameAction(n);
            if (n == 0x520000) {
                System.out.println("KEY.KEY_NUM3 = " + n);
                PNMidlet.MIDLET.setNewState(2);
                System.gc();
            }
            if (this.state == 5 && n2 == 8) {
                this.state = 1;
                return;
            }
            if (this.state != 1) {
                return;
            }
            if (n2 == 2 || n == 0x530000) {
                GameShame gameShame = this;
                synchronized (gameShame) {
                    this.left = true;
                }
            }
            if (n2 == 5 || n == 0x460000) {
                GameShame gameShame = this;
                synchronized (gameShame) {
                    this.right = true;
                }
            }
            if (n2 == 1 || n == 0x450000) {
                GameShame gameShame = this;
                synchronized (gameShame) {
                    this.up = true;
                }
            }
            if (n2 == 6 || n == 0x580000) {
                GameShame gameShame = this;
                synchronized (gameShame) {
                    this.down = true;
                }
            }
            if (n2 == 8 || n == 0x440000) {
                GameShame gameShame = this;
                synchronized (gameShame) {
                    this.jump = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyRepeated(int n) {
        if (n == 2) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.left = true;
            }
        }
        if (n == 5) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.right = true;
            }
        }
        if (n == 1) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.up = true;
            }
        }
        if (n == 6) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.down = true;
            }
        }
        if (n == 8) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.jump = true;
            }
        }
    }

    private void freeAllMemory() {
        int n;
        if (this.img != null) {
            for (n = 0; n < this.img.length; ++n) {
                this.img[n] = null;
            }
        }
        if (this.area != null) {
            for (n = 0; n < this.area.length; ++n) {
                for (int i = 0; i < this.area[n].length; ++i) {
                    if (this.area[n][i] != null) {
                        this.area[n][i].delBlock();
                    }
                    this.area[n][i] = null;
                }
                this.area[n] = null;
            }
        }
        this.area = null;
        this.colorNext = null;
        this.stackFall.removeAllElements();
        this.listDown.removeAllElements();
        this.listFlip.deleteAll();
        this.listFall.deleteAll();
        System.gc();
    }

    private void prepareLevel() {
        this.freeAllMemory();
        String[] stringArray = new String[]{this.sLevel[0], this.sLevel[0], "/bl01.png", "/bl02.png", "/bl03.png", "/bl04.png", "/bl05.png", "/cursor0.png", "/cursor_sel0.png"};
        this.BLOCK_SIZE = 20;
        this.PANE_HEIGHT = 20;
        this.img = GameShame.loadImageList(stringArray);
        this.imgBG = ShameMain.imgBG;
        System.out.println(" Img BG reload prepareLevel");
        this.sound = PNSound.SOUND;
        System.out.println(" SOUND  reload PrepareLevel");
        this.areaCols = this.sizeX / this.BLOCK_SIZE;
        this.areaRows = (this.sizeY - this.PANE_HEIGHT) / this.BLOCK_SIZE;
        Block.BLOCK_SIZE = this.BLOCK_SIZE;
        Block.BOTTOM_Y = this.sizeY - this.PANE_HEIGHT;
        this.area = new Block[this.areaRows][this.areaCols];
        this.colorNext = new byte[this.areaCols];
        for (byte by = 0; by < this.areaCols; by = (byte)((byte)(by + 1))) {
            byte by2 = 0;
            for (byte by3 = 0; by3 < this.areaRows; by3 = (byte)((byte)(by3 + 1))) {
                if (by3 < this.areaRows) {
                    by2 = (byte)(this.rand.nextInt() % 5);
                    if (by2 < 0) {
                        by2 = -by2;
                    }
                    this.area[by3][by] = Block.newBlock(by3, by, by2);
                    continue;
                }
                this.area[by3][by] = null;
            }
            this.colorNext[by] = by2;
        }
        this.cursorCol = this.areaCols >> 1;
        this.cursorRow = this.areaRows >> 1;
        this.cursorVisible = true;
        this.cursorSelect = false;
        try {
            if (ShameMain.smallfontyellow == null) {
                ShameMain.smallfontyellow = Image.createImage((String)"/font_small_yellow.png");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in Font Image " + exception);
        }
    }

    public static Image[] loadImageList(String[] stringArray) {
        Image[] imageArray = new Image[stringArray.length];
        try {
            imageArray[0] = Image.createImage((String)stringArray[0]);
            for (int i = 1; i < imageArray.length; ++i) {
                imageArray[i] = stringArray[i].equals(stringArray[i - 1]) ? imageArray[i - 1] : Image.createImage((String)stringArray[i]);
            }
            return imageArray;
        }
        catch (IOException iOException) {
            return imageArray;
        }
    }

    private void explode() {
        Block block = this.area[this.cursorRow][this.cursorCol];
        if (block != null) {
            byte by = block.color;
            this.listFall.deleteAll();
            this.stackFall.push(block);
            boolean bl = false;
            while (!this.stackFall.empty()) {
                block = (Block)this.stackFall.pop();
                if (this.listFall.contain(block.row, block.col)) continue;
                this.listFall.addElement(block);
                if (block.row > 0 && this.area[block.row - 1][block.col] != null && this.area[block.row - 1][block.col].color == by && !this.listFall.contain(block.row - 1, block.col)) {
                    this.stackFall.push(this.area[block.row - 1][block.col]);
                }
                if (block.col > 0 && this.area[block.row][block.col - 1] != null && this.area[block.row][block.col - 1].color == by && !this.listFall.contain(block.row, block.col - 1)) {
                    this.stackFall.push(this.area[block.row][block.col - 1]);
                }
                if (block.row < this.areaRows - 1 && this.area[block.row + 1][block.col] != null && this.area[block.row + 1][block.col].color == by && !this.listFall.contain(block.row + 1, block.col)) {
                    this.stackFall.push(this.area[block.row + 1][block.col]);
                }
                if (block.col >= this.areaCols - 1 || this.area[block.row][block.col + 1] == null || this.area[block.row][block.col + 1].color != by || this.listFall.contain(block.row, block.col + 1)) continue;
                this.stackFall.push(this.area[block.row][block.col + 1]);
            }
            if (this.listFall.size() >= 2) {
                this.maskDown = 0;
                for (int i = 0; i < this.listFall.size(); ++i) {
                    block = (Block)this.listFall.elementAt(i);
                    this.area[block.row][block.col] = null;
                    this.maskDown |= 1 << block.col;
                }
                this.isFall = true;
                this.startFall();
                this.startDown();
                return;
            }
        }
        this.cursorSelect = false;
        this.listFall.removeAllElements();
    }

    private void checkGameStatus() {
        for (int i = 0; i < this.areaCols; ++i) {
            for (int j = 0; j < this.areaRows; ++j) {
                Block block = this.area[j][i];
                VectorBlock vectorBlock = new VectorBlock();
                Stack<Block> stack = new Stack<Block>();
                if (block == null) continue;
                byte by = block.color;
                vectorBlock.deleteAll();
                stack.push(block);
                while (!stack.empty()) {
                    block = (Block)stack.pop();
                    if (vectorBlock.contain(block.row, block.col)) continue;
                    vectorBlock.addElement(block);
                    if (block.row > 0 && this.area[block.row - 1][block.col] != null && this.area[block.row - 1][block.col].color == by && !vectorBlock.contain(block.row - 1, block.col)) {
                        stack.push(this.area[block.row - 1][block.col]);
                    }
                    if (block.col > 0 && this.area[block.row][block.col - 1] != null && this.area[block.row][block.col - 1].color == by && !vectorBlock.contain(block.row, block.col - 1)) {
                        stack.push(this.area[block.row][block.col - 1]);
                    }
                    if (block.row < this.areaRows - 1 && this.area[block.row + 1][block.col] != null && this.area[block.row + 1][block.col].color == by && !vectorBlock.contain(block.row + 1, block.col)) {
                        stack.push(this.area[block.row + 1][block.col]);
                    }
                    if (block.col >= this.areaCols - 1 || this.area[block.row][block.col + 1] == null || this.area[block.row][block.col + 1].color != by || vectorBlock.contain(block.row, block.col + 1)) continue;
                    stack.push(this.area[block.row][block.col + 1]);
                }
                if (vectorBlock.size() < 2) continue;
                vectorBlock.removeAllElements();
                return;
            }
        }
        this.isGameOver = true;
    }

    public void freeMemory() {
        int n;
        if (this.img != null) {
            for (n = 0; n < this.img.length; ++n) {
                this.img[n] = null;
            }
        }
        if (this.area != null) {
            for (n = 0; n < this.area.length; ++n) {
                for (int i = 0; i < this.area[n].length; ++i) {
                    if (this.area[n][i] != null) {
                        this.area[n][i].delBlock();
                    }
                    this.area[n][i] = null;
                }
                this.area[n] = null;
            }
        }
        this.area = null;
        this.imgBG = null;
        this.transLevelImg = null;
        this.sound = null;
        this.stackFall.removeAllElements();
        this.listDown.removeAllElements();
        this.listFlip.deleteAll();
        this.listFall.deleteAll();
        if (ShameMain.smallfontyellow != null) {
            ShameMain.smallfontyellow = null;
        }
        System.out.println("memory release freeMemory called ");
    }
}

