/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Score {
    private TRLCanvas c;
    private int currLevel;
    private long startTime;
    private long endTime;
    public long pauseTotalTime;
    public long pauseStartTime;
    public long pauseEndTime;
    public long bulletShots = 0L;
    public int damagesTaken = 0;
    public int nbDeaths = 0;
    public int damagesInflicted = 0;
    private int Score;
    private String rank;
    private long totalTime;
    private int hours;
    private int minutes;
    private int seconds;

    public Score(TRLCanvas _c) {
        this.c = _c;
    }

    public void setStartTime(long time, int level) {
        this.startTime = time;
        this.currLevel = level;
        this.pauseTotalTime = 0L;
        this.bulletShots = 0L;
        this.damagesTaken = 0;
        this.nbDeaths = 0;
        this.damagesInflicted = 0;
        this.totalTime = 0L;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
    }

    public void setEndTime(long time) {
        this.endTime = time;
    }

    public void startPause() {
        this.pauseStartTime = System.currentTimeMillis();
    }

    public void endPause() {
        this.pauseEndTime = System.currentTimeMillis();
        this.pauseTotalTime += this.pauseEndTime - this.pauseStartTime;
    }

    public void addDamageInflicted(int _dmg) {
        this.damagesInflicted += _dmg;
    }

    public void addBulletShot() {
        ++this.bulletShots;
    }

    public void addDamageTaken(int _dmg) {
        this.damagesTaken += _dmg;
    }

    public void addDeath() {
        ++this.nbDeaths;
    }

    private void getTime() {
        System.out.println("0. " + this.totalTime);
        this.totalTime = (int)(this.totalTime / 1000L);
        this.hours = (int)(this.totalTime / 3600L);
        this.totalTime = (int)this.totalTime % 3600;
        this.minutes = (int)(this.totalTime / 60L);
        this.totalTime = (int)(this.totalTime % 60L);
        this.seconds = (int)this.totalTime;
    }

    public void finalScore() {
        long tmpTime = this.totalTime = this.endTime - this.startTime - this.pauseTotalTime;
        this.getTime();
        this.totalTime = tmpTime;
        this.totalTime += this.bulletShots * 1000L + (long)this.damagesTaken * 100L + (long)this.nbDeaths * 3000L;
        this.totalTime -= (long)this.damagesInflicted * 100L;
        long refTime = 0L;
        switch (this.currLevel) {
            case 1: {
                refTime = Globals.LEVEL_1_REF_TIME;
                break;
            }
            case 2: {
                refTime = Globals.LEVEL_2_REF_TIME;
                break;
            }
            case 3: {
                refTime = Globals.LEVEL_3_REF_TIME;
            }
        }
        if (this.totalTime <= refTime) {
            this.Score = 7;
            this.rank = "A+";
        } else if (this.totalTime <= refTime + 10000L) {
            this.Score = 6;
            this.rank = "A";
        } else if (this.totalTime <= refTime + 20000L) {
            this.Score = 5;
            this.rank = "B";
        } else if (this.totalTime <= refTime + 30000L) {
            this.Score = 4;
            this.rank = "C";
        } else if (this.totalTime <= refTime + 40000L) {
            this.Score = 3;
            this.rank = "D";
        } else if (this.totalTime <= refTime + 50000L) {
            this.Score = 2;
            this.rank = "E";
        } else {
            this.Score = 1;
            this.rank = "F";
        }
        int currScore = 0;
        switch (this.currLevel) {
            case 1: {
                currScore = this.c.Level1Score;
                break;
            }
            case 2: {
                currScore = this.c.Level2Score;
                break;
            }
            case 3: {
                currScore = this.c.Level3Score;
            }
        }
        if (this.Score > currScore) {
            switch (this.currLevel) {
                case 1: {
                    RMS rMS = this.c.rms;
                    this.c.getClass();
                    rMS.setValueOf(5, this.Score);
                    break;
                }
                case 2: {
                    RMS rMS = this.c.rms;
                    this.c.getClass();
                    rMS.setValueOf(6, this.Score);
                    break;
                }
                case 3: {
                    RMS rMS = this.c.rms;
                    this.c.getClass();
                    rMS.setValueOf(7, this.Score);
                }
            }
        }
    }

    public void drawScoreScreen(Graphics _g) {
        try {
            this.c.bmFont.drawString(_g, this.c.scoreText[0], (int)((float)this.c.getWidth() / 2.0f), (int)((float)this.c.getHeight() * 0.05f), 17);
            this.c.bmFont.drawString(_g, this.c.LevelName[this.currLevel - 1], (int)((float)this.c.getWidth() / 2.0f), (int)((float)this.c.getHeight() * 0.1f), 17);
            this.c.bmFont.drawString(_g, this.c.scoreText[1], (int)((float)this.c.getWidth() * 0.1f), (int)((float)this.c.getHeight() * 0.2f), 20);
            this.c.bmFont.drawString(_g, String.valueOf(this.hours) + "h " + this.minutes + "m " + this.seconds + "s", (int)((float)this.c.getWidth() * 0.9f), (int)((float)this.c.getHeight() * 0.2f), 24);
            this.c.bmFont.drawString(_g, this.c.scoreText[2], (int)((float)this.c.getWidth() / 2.0f), (int)((float)this.c.getHeight() * 0.3f), 17);
            this.c.bmFont.drawString(_g, this.c.scoreText[3], (int)((float)this.c.getWidth() * 0.1f), (int)((float)this.c.getHeight() * 0.35f), 20);
            this.c.bmFont.drawString(_g, "" + this.bulletShots, (int)((float)this.c.getWidth() * 0.9f), (int)((float)this.c.getHeight() * 0.35f), 24);
            this.c.bmFont.drawString(_g, this.c.scoreText[4], (int)((float)this.c.getWidth() * 0.1f), (int)((float)this.c.getHeight() * 0.4f), 20);
            this.c.bmFont.drawString(_g, "" + this.damagesTaken, (int)((float)this.c.getWidth() * 0.9f), (int)((float)this.c.getHeight() * 0.4f), 24);
            this.c.bmFont.drawString(_g, this.c.scoreText[5], (int)((float)this.c.getWidth() * 0.1f), (int)((float)this.c.getHeight() * 0.45f), 20);
            this.c.bmFont.drawString(_g, "" + this.nbDeaths, (int)((float)this.c.getWidth() * 0.9f), (int)((float)this.c.getHeight() * 0.45f), 24);
            this.c.bmFont.drawString(_g, this.c.scoreText[6], (int)((float)this.c.getWidth() / 2.0f), (int)((float)this.c.getHeight() * 0.6f), 17);
            this.c.bmFont.drawString(_g, this.c.scoreText[7], (int)((float)this.c.getWidth() * 0.1f), (int)((float)this.c.getHeight() * 0.65f), 20);
            this.c.bmFont.drawString(_g, "" + this.damagesInflicted, (int)((float)this.c.getWidth() * 0.9f), (int)((float)this.c.getHeight() * 0.65f), 24);
            this.c.bmFont.drawString(_g, String.valueOf(this.c.scoreText[8]) + ": " + this.rank, (int)((float)this.c.getWidth() / 2.0f), (int)((float)this.c.getHeight() * 0.8f), 17);
        }
        catch (Exception e) {
            System.out.println("Error in drawScoreScreen");
        }
    }
}

