/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class RMS {
    private TRLCanvas c;
    private String recordStoreName = "TombRaiderRMS24";
    private int maxLevel;
    public int bSound;
    public int bVibration;
    public int bTechTeam;
    public int language;
    public int level1Score;
    public int level2Score;
    public int level3Score;
    public int currMaxLevel;
    public int currMaxCheckpoint;
    public static final int MAX_LEVEL = 0;
    public static final int B_SOUND = 1;
    public static final int B_VIBRATION = 2;
    public static final int B_TECHTEAM = 3;
    public static final int LANGUAGE = 4;
    public static final int LEVEL_1_SCORE = 5;
    public static final int LEVEL_2_SCORE = 6;
    public static final int LEVEL_3_SCORE = 7;
    public static final int CURR_MAX_LEVEL = 8;
    public static final int CURR_MAX_CHECKPOINT = 9;
    public static final int NB_RECORD_STORED = 10;
    private RecordStore recordStore;

    public RMS(TRLCanvas _c) {
        try {
            this.c = _c;
            boolean bRSFound = false;
            String[] recArray = RecordStore.listRecordStores();
            if (recArray != null) {
                int i = 0;
                while (i < recArray.length) {
                    System.out.println("RMS: RS found: " + recArray[i]);
                    if (recArray[i].equals(this.recordStoreName)) {
                        bRSFound = true;
                    }
                    ++i;
                }
            }
            if (!bRSFound) {
                this.recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeInt(-1);
                dos.writeInt(Globals.B_SOUND);
                dos.writeInt(Globals.B_VIBRATION);
                dos.writeInt(Globals.B_TECHTEAM);
                dos.writeInt(-1);
                dos.writeInt(0);
                dos.writeInt(0);
                dos.writeInt(0);
                dos.writeInt(-1);
                dos.writeInt(-1);
                dos.flush();
                byte[] result = baos.toByteArray();
                this.recordStore.addRecord(result, 0, result.length);
                baos.close();
                dos.close();
                this.recordStore.closeRecordStore();
            }
            recArray = null;
        }
        catch (Exception e) {
            System.out.println("Error in RMS() " + e.toString());
            e.printStackTrace();
        }
    }

    public void setValueOf(int valueId, int newValue) {
        try {
            switch (valueId) {
                case 0: {
                    this.maxLevel = newValue;
                    break;
                }
                case 1: {
                    this.bSound = newValue;
                    break;
                }
                case 3: {
                    this.bTechTeam = newValue;
                    break;
                }
                case 2: {
                    this.bVibration = newValue;
                    break;
                }
                case 4: {
                    this.language = newValue;
                    break;
                }
                case 5: {
                    this.level1Score = newValue;
                    break;
                }
                case 6: {
                    this.level2Score = newValue;
                    break;
                }
                case 7: {
                    this.level3Score = newValue;
                    break;
                }
                case 8: {
                    this.currMaxLevel = newValue;
                    break;
                }
                case 9: {
                    this.currMaxCheckpoint = newValue;
                }
            }
            this.storeValues();
        }
        catch (Exception e) {
            if (this.c.bEnableErrorMsg) {
                TRLCanvas.message = "Error setvalueof";
                TRLCanvas.message2 = e.toString();
                this.c.getClass();
                this.c.APPLISTATUS = 4;
            }
            System.out.println("Error in setValueOf " + e.getMessage());
            e.printStackTrace();
        }
    }

    public int getValueOf(int valueId) {
        int toReturn = -1;
        try {
            this.refreshValues();
            switch (valueId) {
                case 0: {
                    toReturn = this.maxLevel;
                    break;
                }
                case 1: {
                    toReturn = this.bSound;
                    break;
                }
                case 3: {
                    toReturn = this.bTechTeam;
                    break;
                }
                case 2: {
                    toReturn = this.bVibration;
                    break;
                }
                case 4: {
                    toReturn = this.language;
                    break;
                }
                case 5: {
                    toReturn = this.level1Score;
                    break;
                }
                case 6: {
                    toReturn = this.level2Score;
                    break;
                }
                case 7: {
                    toReturn = this.level3Score;
                    break;
                }
                case 8: {
                    toReturn = this.currMaxLevel;
                    break;
                }
                case 9: {
                    toReturn = this.currMaxCheckpoint;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in getValueOf " + e.getMessage());
            e.printStackTrace();
        }
        return toReturn;
    }

    private void refreshValues() {
        int posError = 0;
        try {
            this.recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)false);
            RecordEnumeration recordEnum = this.recordStore.enumerateRecords(null, null, false);
            ByteArrayInputStream baos = new ByteArrayInputStream(recordEnum.nextRecord());
            DataInputStream dis = new DataInputStream(baos);
            posError = 1;
            this.maxLevel = dis.readInt();
            this.bSound = dis.readInt();
            this.bVibration = dis.readInt();
            this.bTechTeam = dis.readInt();
            this.language = dis.readInt();
            this.level1Score = dis.readInt();
            this.level2Score = dis.readInt();
            this.level3Score = dis.readInt();
            this.currMaxLevel = dis.readInt();
            this.currMaxCheckpoint = dis.readInt();
            baos.close();
            dis.close();
            this.recordStore.closeRecordStore();
        }
        catch (Exception e) {
            if (this.c.bEnableErrorMsg) {
                TRLCanvas.message = "RefreshValues error";
                TRLCanvas.message2 = e.toString();
                this.c.getClass();
                this.c.APPLISTATUS = 4;
            }
            System.out.println("Error in refreshValues() posError=" + posError);
            e.printStackTrace();
        }
    }

    private void storeValues() {
        int posError = 0;
        try {
            this.recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)false);
            posError = 1;
            RecordEnumeration recordEnum = this.recordStore.enumerateRecords(null, null, false);
            posError = 2;
            int recId = recordEnum.nextRecordId();
            posError = 3;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(this.maxLevel);
            dos.writeInt(this.bSound);
            dos.writeInt(this.bVibration);
            dos.writeInt(this.bTechTeam);
            dos.writeInt(this.language);
            dos.writeInt(this.level1Score);
            dos.writeInt(this.level2Score);
            dos.writeInt(this.level3Score);
            dos.writeInt(this.currMaxLevel);
            dos.writeInt(this.currMaxCheckpoint);
            dos.flush();
            posError = 4;
            byte[] result = baos.toByteArray();
            this.recordStore.setRecord(recId, result, 0, result.length);
            baos.close();
            dos.close();
            this.recordStore.closeRecordStore();
        }
        catch (Exception e) {
            if (this.c.bEnableErrorMsg) {
                TRLCanvas.message = "StoreValues error " + posError;
                TRLCanvas.message2 = e.toString();
                this.c.getClass();
                this.c.APPLISTATUS = 4;
            }
            System.out.println("Error in storeValues");
            e.printStackTrace();
        }
    }
}

