/*
 * Decompiled with CFR 0.152.
 */
public class Float11 {
    public static final double SQRT3 = 1.7320508075688772;
    public static final double LOG10 = 2.302585092994046;
    public static final double LOGdiv2 = -0.6931471805599453;

    public static double acos(double x) {
        double f = Float11.asin(x);
        if (f == Double.NaN) {
            return f;
        }
        return 1.5707963267948966 - f;
    }

    public static double asin(double x) {
        if (x < -1.0 || x > 1.0) {
            return Double.NaN;
        }
        if (x == -1.0) {
            return -1.5707963267948966;
        }
        if (x == 1.0) {
            return 1.5707963267948966;
        }
        return Float11.atan(x / Math.sqrt(1.0 - x * x));
    }

    public static double atan(double x) {
        double a;
        boolean signChange = false;
        boolean Invert = false;
        int sp = 0;
        if (x < 0.0) {
            x = -x;
            signChange = true;
        }
        if (x > 1.0) {
            x = 1.0 / x;
            Invert = true;
        }
        while (x > 0.2617993877991494) {
            ++sp;
            a = x + 1.7320508075688772;
            a = 1.0 / a;
            x *= 1.7320508075688772;
            x -= 1.0;
            x *= a;
        }
        double x2 = x * x;
        a = x2 + 1.4087812;
        a = 0.55913709 / a;
        a += 0.60310579;
        a -= x2 * 0.05160454;
        a *= x;
        while (sp > 0) {
            a += 0.5235987755982988;
            --sp;
        }
        if (Invert) {
            a = 1.5707963267948966 - a;
        }
        if (signChange) {
            a = -a;
        }
        return a;
    }

    public static double atan2(double y, double x) {
        if (y == 0.0 && x == 0.0) {
            return 0.0;
        }
        if (x > 0.0) {
            return Float11.atan(y / x);
        }
        if (x < 0.0) {
            if (y < 0.0) {
                return -(Math.PI - Float11.atan(y / x));
            }
            return Math.PI - Float11.atan(-y / x);
        }
        if (y < 0.0) {
            return -1.5707963267948966;
        }
        return 1.5707963267948966;
    }

    public static double exp(double x) {
        boolean isless;
        if (x == 0.0) {
            return 1.0;
        }
        double f = 1.0;
        long d = 1L;
        boolean bl = isless = x < 0.0;
        if (isless) {
            x = -x;
        }
        double k = x / (double)d;
        long i = 2L;
        while (i < 50L) {
            f += k;
            k = k * x / (double)i;
            ++i;
        }
        if (isless) {
            return 1.0 / f;
        }
        return f;
    }

    private static double _log(double x) {
        double y;
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        double f = 0.0;
        int appendix = 0;
        while (x > 0.0 && x <= 1.0) {
            x *= 2.0;
            ++appendix;
        }
        --appendix;
        double y1 = (x /= 2.0) - 1.0;
        double y2 = x + 1.0;
        double k = y = y1 / y2;
        y2 = k * y;
        long i = 1L;
        while (i < 50L) {
            f += k / (double)i;
            k *= y2;
            i += 2L;
        }
        f *= 2.0;
        int i2 = 0;
        while (i2 < appendix) {
            f += -0.6931471805599453;
            ++i2;
        }
        return f;
    }

    public static double log(double x) {
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x > 1.0) {
            x = 1.0 / x;
            return -Float11._log(x);
        }
        return Float11._log(x);
    }

    public static double log10(double x) {
        return Float11.log(x) / 2.302585092994046;
    }

    public static double pow(double x, double y) {
        boolean integerValue;
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (y == 0.0) {
            return 1.0;
        }
        if (y == 1.0) {
            return x;
        }
        long l = (long)Math.floor(y);
        boolean bl = integerValue = y == (double)l;
        if (integerValue) {
            boolean neg = false;
            if (y < 0.0) {
                neg = true;
            }
            double result = x;
            long i = 1L;
            while (i < (neg ? -l : l)) {
                result *= x;
                ++i;
            }
            if (neg) {
                return 1.0 / result;
            }
            return result;
        }
        if (x > 0.0) {
            return Float11.exp(y * Float11.log(x));
        }
        return Double.NaN;
    }
}

