/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CutScene {
    private TRLCanvas canvas;
    private BitmapFont bmFont;
    private Image topImage;
    public int currCutScene = 0;
    public final int START_CUTSCENE;
    public final int END_CUTSCENE;
    private StringBuffer cutSceneTxt;
    private int textDeltaY = -1;
    public int textScrollSpeed = -1;
    private int textInitialY;
    private int charHeight;
    private int numChar;
    private String line;
    private int numLine;
    private boolean bEndOfTextReached = false;
    private int currPos;
    private int currStrWidth;
    private int lastSpacePos;
    private StringBuffer cell = new StringBuffer();

    public CutScene(TRLCanvas _canvas, BitmapFont _bmFont) {
        this.START_CUTSCENE = 1;
        this.END_CUTSCENE = 2;
        this.canvas = _canvas;
        this.bmFont = _bmFont;
        this.charHeight = this.bmFont.getCharHeight();
    }

    private void loadCutSceneFromCSV() {
        try {
            InputStream file = this.getClass().getResourceAsStream("/CutSceneTxt.csv");
            InputStreamReader file_reader = new InputStreamReader(file);
            this.skipLine(1 + 2 * (this.canvas.currEpisode - 1) + (this.currCutScene - 1), file_reader, 1 + this.canvas.nbLanguages);
            this.skipCell(1 + this.canvas.currLang, file_reader);
            this.readCell(file_reader);
            this.cutSceneTxt = this.cell;
        }
        catch (Exception e) {
            System.out.println("Error in loadCutSceneFromCSV");
            e.printStackTrace();
        }
    }

    public void loadCutSceneMemory(int numScene) {
        try {
            this.canvas.loadingScreen.setCurrentMethodProgress(0);
            this.textInitialY = this.canvas.getHeight() - 5 * this.charHeight;
            this.textDeltaY = 0;
            this.currCutScene = numScene;
            String fileName = null;
            if (this.currCutScene == 1) {
                fileName = this.canvas.startCutSceneFile;
            }
            if (this.currCutScene == 2) {
                fileName = this.canvas.endCutSceneFile;
            }
            this.topImage = Image.createImage((String)fileName);
            this.canvas.loadingScreen.setCurrentMethodProgress(30);
            this.loadCutSceneFromCSV();
            this.canvas.loadingScreen.setCurrentMethodProgress(80);
            this.canvas.loadingScreen.setCurrentMethodProgress(100);
        }
        catch (Exception e) {
            System.out.println("Error in loadCutSceneMemory " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void releaseCutSceneMemory() {
        this.topImage = null;
        this.cutSceneTxt = null;
        this.line = null;
        System.gc();
    }

    /*
     * Unable to fully structure code
     */
    public void drawCutScene(Graphics g2d) {
        g2d.setColor(0, 0, 0);
        g2d.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        g2d.drawImage(this.topImage, 0, 0, 0);
        try {
            this.charHeight = this.bmFont.getCharHeight();
            this.numLine = 0;
            this.numChar = 0;
            this.textDeltaY += this.textScrollSpeed;
            ** GOTO lbl21
            {
                ++this.numChar;
                do {
                    if (this.cutSceneTxt.charAt(this.numChar) == ' ' || this.cutSceneTxt.charAt(this.numChar) == '\n') continue block2;
                    nextNumChar = this.getLargestString(this.numChar, this.cutSceneTxt, this.canvas.getWidth());
                    this.line = this.cutSceneTxt.toString().substring(this.numChar, nextNumChar);
                    yText = this.numLine * this.charHeight + this.textInitialY + this.textDeltaY;
                    if ((double)yText > 0.4 * (double)this.canvas.getHeight() && yText < this.canvas.getHeight() - 3 * this.charHeight) {
                        this.bmFont.drawString(g2d, this.line, 0, this.numLine * this.charHeight + this.textInitialY + this.textDeltaY, 0);
                        this.bEndOfTextReached = nextNumChar >= this.cutSceneTxt.length();
                    }
                    this.numChar = nextNumChar;
                    ++this.numLine;
lbl21:
                    // 2 sources

                } while (this.numChar < this.cutSceneTxt.length());
            }
            if (this.currCutScene == 1) {
                if (this.bEndOfTextReached) {
                    if (System.currentTimeMillis() % 2000L >= 700L) {
                        this.canvas.drawLeftSoftKey(g2d, this.canvas.softKeys[10]);
                    } else {
                        this.canvas.clearLeftSoftKey();
                    }
                } else {
                    this.canvas.drawLeftSoftKey(g2d, this.canvas.softKeys[5]);
                }
            } else if (this.currCutScene == 2) {
                if (this.bEndOfTextReached) {
                    if (System.currentTimeMillis() % 2000L >= 700L) {
                        this.canvas.drawLeftSoftKey(g2d, this.canvas.softKeys[10]);
                    } else {
                        this.canvas.clearLeftSoftKey();
                    }
                } else {
                    this.canvas.drawLeftSoftKey(g2d, this.canvas.softKeys[10]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error while displaying text in drawCutScene");
            e.printStackTrace();
        }
    }

    public int getLargestString(int _numChar, StringBuffer _cutSceneTxt, int _availableWidth) {
        try {
            this.currPos = _numChar;
            this.currStrWidth = this.bmFont.getCharWidth(_cutSceneTxt.charAt(_numChar));
            this.lastSpacePos = _numChar;
            while (this.currStrWidth < _availableWidth) {
                if (this.currPos == _cutSceneTxt.length() - 1) {
                    return this.currPos + 1;
                }
                ++this.currPos;
                if (_cutSceneTxt.charAt(this.currPos) == '\n') {
                    return this.currPos + 1;
                }
                if (_cutSceneTxt.charAt(this.currPos) == ' ') {
                    this.lastSpacePos = this.currPos;
                }
                this.currStrWidth += this.bmFont.charSpacing + this.bmFont.getCharWidth(_cutSceneTxt.charAt(this.currPos));
            }
            if (_cutSceneTxt.charAt(this.currPos) != ' ' && _cutSceneTxt.charAt(this.currPos) != '\n') {
                this.currPos = this.lastSpacePos;
            }
        }
        catch (Exception e) {
            System.out.println("Error in getLargestString ");
        }
        return this.currPos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int skipLine(int n, InputStreamReader in, int semiColonsPerLine) {
        int c = 0;
        int nbSemiColons = 0;
        int skipped = 0;
        try {
            if (semiColonsPerLine == 0) {
                return 0;
            }
            c = in.read();
            while (true) {
                if (c == -1) {
                    return -1;
                }
                if (skipped == n) {
                    return 0;
                }
                if ((char)c == ';' && ++nbSemiColons == semiColonsPerLine) {
                    c = in.read();
                    ++skipped;
                    nbSemiColons = 0;
                }
                c = in.read();
            }
        }
        catch (Exception e) {
            System.out.println("Error in skipLine");
            e.printStackTrace();
            return 0;
        }
    }

    private void skipCell(int n, InputStreamReader in) {
        int c = 0;
        int cellSkipped = 0;
        try {
            if (n == 0) {
                return;
            }
            c = in.read();
            while (c != -1) {
                if ((char)c == ';' && ++cellSkipped == n) {
                    return;
                }
                c = in.read();
            }
        }
        catch (Exception e) {
            System.out.println("Error in skipCell");
            e.printStackTrace();
        }
    }

    private void readCell(InputStreamReader in) {
        int c = 0;
        this.cell.setLength(0);
        try {
            c = in.read();
            while (c != -1) {
                if ((char)c == ';') {
                    return;
                }
                this.cell.append((char)c);
                c = in.read();
            }
        }
        catch (Exception e) {
            System.out.println("Error in readCell");
            e.printStackTrace();
        }
    }
}

