/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;

public class BadGuy {
    public static final boolean BIPED_DUPLICATE = false;
    private static final PrintStream so = System.out;
    public TRLCanvas canvas;
    public Random rand = new Random();
    public static final int TYPE_GUARD = 0;
    public static final int TYPE_GUARD2 = 1;
    public static final int TYPE_GUARD3 = 2;
    public static final int TYPE_TAKAMOTO = 99;
    public static final int TYPE_TAKAMOTO_FINAL = 100;
    public static final int GRENADE_ARRAY_DIMENSION = 3;
    public static final int BULLETS_ARRAY_DIMENSION = 3;
    public int damage;
    public int type;
    public int rank;
    public Group biped;
    public int numAnim;
    public float guyP;
    public float guyV;
    public float guyH;
    public float startV;
    public float startH;
    public float hSpeed;
    public int m_bipedStep;
    private long curAnimStartTime;
    private float multFrame;
    private float lastHSpeed;
    private boolean bCollided;
    private int collisionHeight;
    private int nbBullets;
    private int nbBulletsLeft;
    private int nbRafaleLeft;
    private long rafaleDelay;
    private boolean hasShot = false;
    private long reloadDelay;
    private long startReloadingTime;
    private boolean bReloading;
    private boolean bSwitchDirection;
    private boolean bLaunchGrenade;
    private long lastSwitchingTime;
    private long switchingDelay;
    private boolean bWaitingRight = false;
    private boolean bWaitingLeft = false;
    private long lastWaitingTime;
    private long waitingDelay;
    private float roundtripRadius;
    private long startGroggyTime;
    private long groggyDelay;
    private boolean bGroggy;
    public boolean bGroggyYet;
    private int startLife;
    public int life;
    public int lastLifeCheck;
    private int maxLifeLostBeforeFlee;
    public int direction;
    private boolean bUp;
    private Grenade[] grenades;
    private Bullet[] bullets;
    private Mesh shootEffect;
    private int nbGrenades;
    private long gunDelay;
    private long grenadeDelay;
    private int grenadeLaunched;
    private long deathTime;
    private long deathTime2;
    private boolean deathCligno;
    public boolean wakeup;
    public boolean bAlert = false;
    public long startAlertTime;
    public long alertDelay;
    public int takaRank;
    private boolean takaFire;
    public boolean bLookingForTrap = false;
    public boolean bRemote = false;
    public boolean bIsVisible;
    private boolean bIsBlown;
    private float[] newPos = new float[3];
    public float fDistToCam;
    public Sprite3D lifeSprite;
    Plane[] cam_planes = new Plane[6];
    Transform trans2 = new Transform();
    float[] comboMatrix = new float[16];
    float[] comboMatrix2 = new float[16];
    Transform trans = new Transform();
    private int[] trapIndex = new int[]{-1, -1};
    public boolean[] trapTriggered = new boolean[3];
    private float colThresold = 1.5f;
    private int orientation;

    public BadGuy(Group _biped, TRLCanvas _c, float[] _tabPos, float _radius, int _dir, int _rank, int _type) {
        this.type = _type;
        this.canvas = _c;
        this.nbBulletsLeft = this.nbBullets = Globals.NMBR_BULLETS;
        this.nbRafaleLeft = 0;
        this.bReloading = false;
        this.startReloadingTime = 0L;
        this.gunDelay = 0L;
        this.rafaleDelay = 0L;
        this.bLaunchGrenade = false;
        this.grenadeDelay = 0L;
        this.bSwitchDirection = false;
        this.bUp = true;
        this.direction = _dir == 0 ? -1 : 1;
        this.groggyDelay = Globals.YAK_GROGGY_DELAY;
        this.alertDelay = Globals.YAK_ALERT_DELAY;
        this.startGroggyTime = 0L;
        this.bGroggy = false;
        this.bGroggyYet = false;
        switch (this.type) {
            case 0: {
                this.life = Globals.YAK_1_LIFE;
                this.reloadDelay = Globals.RELOAD_DELAY;
                this.damage = Globals.YAK_1_DAMAGE;
                break;
            }
            case 1: {
                this.life = Globals.YAK_2_LIFE;
                this.reloadDelay = 2L * Globals.RELOAD_DELAY;
                this.damage = Globals.YAK_2_DAMAGE;
                this.switchingDelay = Globals.YAK_SWITCHING_DELAY;
                this.lastSwitchingTime = 0L;
                break;
            }
            case 2: {
                this.life = Globals.YAK_3_LIFE;
                this.reloadDelay = Globals.RELOAD_DELAY;
                this.damage = Globals.YAK_3_DAMAGE;
                this.waitingDelay = Globals.YAK_WAITING_DELAY;
                this.lastWaitingTime = 0L;
                if (_radius == 0.0f) {
                    this.roundtripRadius = Globals.YAK_ROUNDTRIP_RADIUS;
                    break;
                }
                this.roundtripRadius = _radius / 2.0f;
                break;
            }
            case 99: {
                this.lastLifeCheck = this.life = Globals.TAKA_LIFE;
                this.maxLifeLostBeforeFlee = Globals.TAKA_MAX_LIFE_BEFORE_FLEE;
                this.reloadDelay = Globals.RELOAD_DELAY;
                this.damage = Globals.TAKA_DAMAGE;
                break;
            }
            case 100: {
                this.lastLifeCheck = this.life = Globals.TAKA_LIFE;
                this.maxLifeLostBeforeFlee = Globals.TAKA_MAX_LIFE_BEFORE_FLEE;
                this.reloadDelay = Globals.RELOAD_DELAY;
                this.damage = Globals.YARI_DAMAGE;
            }
        }
        this.startLife = this.life;
        try {
            Image im = Image.createImage((String)"/life.png");
            Image2D im2D = new Image2D(99, (Object)im);
            this.lifeSprite = new Sprite3D(true, im2D, new Appearance());
            this.lifeSprite.setOrientation(-90.0f, 0.0f, 1.0f, 0.0f);
            this.lifeSprite.setRenderingEnable(false);
            this.canvas.world.addChild((Node)this.lifeSprite);
        }
        catch (Exception im) {
            // empty catch block
        }
        this.grenades = new Grenade[3];
        int i = 3;
        while (--i >= 0) {
            this.grenades[i] = new Grenade(this.canvas.grenade, this);
        }
        this.grenadeLaunched = 0;
        this.bullets = new Bullet[3];
        i = 0;
        while (i < 3) {
            switch (this.type) {
                case 0: {
                    this.bullets[i] = new Bullet(this.canvas.action.bulletImage, this.canvas, false, this, Globals.YAK_1_DAMAGE);
                    break;
                }
                case 1: {
                    this.bullets[i] = new Bullet(this.canvas.action.bulletImage, this.canvas, false, this, Globals.YAK_2_DAMAGE);
                    break;
                }
                case 2: {
                    this.bullets[i] = new Bullet(this.canvas.action.expBulletImage, this.canvas, false, this, Globals.YAK_3_DAMAGE);
                    break;
                }
                case 99: {
                    this.bullets[i] = new Bullet(this.canvas.action.expBulletImage, this.canvas, false, this, Globals.TAKA_DAMAGE);
                    break;
                }
                case 100: {
                    this.bullets[i] = new Bullet(this.canvas.action.yariImage, this.canvas, false, this, Globals.YARI_DAMAGE);
                }
            }
            ++i;
        }
        this.init(_biped, _tabPos, _rank);
    }

    private final void init(Group _biped, float[] _tabPos, int _rank) {
        try {
            this.rank = _rank;
            this.numAnim = 0;
            this.m_bipedStep = TRLCanvas.tabAnims[this.numAnim * 2];
            this.guyP = _tabPos[0];
            this.guyV = _tabPos[1];
            this.guyH = _tabPos[2];
            this.startV = this.guyV;
            this.startH = this.guyH;
            this.bCollided = false;
            this.lastHSpeed = this.hSpeed;
            this.multFrame = 50.0f;
            this.hSpeed = 0.0f;
            this.collisionHeight = -2;
            this.wakeup = false;
            this.takaFire = false;
            this.bIsVisible = true;
            this.bIsBlown = false;
            this.biped = _biped;
            this.shootEffect = this.canvas.createPlane(2, 0.3f);
            this.shootEffect.setOrientation(-90.0f, 0.0f, 1.0f, 0.0f);
            this.canvas.world.addChild((Node)this.shootEffect);
            this.shootEffect.setRenderingEnable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void delete() {
        try {
            if (this.grenades != null) {
                int i = this.nbGrenades;
                while (--i >= 0) {
                    this.grenades[i].delete();
                    this.grenades[i] = null;
                }
            }
            this.grenades = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void changeAnim(int _newAnim) {
        if (this.hSpeed != 0.0f) {
            this.guyH += this.hSpeed;
            this.hSpeed = 0.0f;
        }
        this.numAnim = _newAnim;
        if (this.numAnim < 100) {
            this.m_bipedStep = TRLCanvas.tabAnims[this.numAnim * 2];
        }
        this.curAnimStartTime = System.currentTimeMillis();
        this.shootEffect.setRenderingEnable(false);
    }

    void NormalizePlane(Plane plane) {
        float mag = (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
        plane.x /= mag;
        plane.y /= mag;
        plane.z /= mag;
        plane.d /= mag;
    }

    void ExtractPlanesGL(Plane[] p_planes, boolean normalize) {
        this.canvas.cam.getProjection(this.trans2);
        this.trans2.get(this.comboMatrix2);
        this.canvas.cam.getCompositeTransform(this.trans);
        this.trans.transpose();
        this.trans.get(this.comboMatrix);
        this.trans.postMultiply(this.trans2);
        this.trans.get(this.comboMatrix);
        int i = 0;
        while (i < 6) {
            p_planes[i] = new Plane();
            ++i;
        }
        p_planes[0].x = this.comboMatrix[3] + this.comboMatrix[0];
        p_planes[0].y = this.comboMatrix[7] + this.comboMatrix[4];
        p_planes[0].z = this.comboMatrix[11] + this.comboMatrix[8];
        p_planes[0].d = this.comboMatrix[15] + this.comboMatrix[12];
        p_planes[1].x = this.comboMatrix[3] - this.comboMatrix[0];
        p_planes[1].y = this.comboMatrix[7] - this.comboMatrix[4];
        p_planes[1].z = this.comboMatrix[11] - this.comboMatrix[8];
        p_planes[1].d = this.comboMatrix[15] - this.comboMatrix[12];
        p_planes[2].x = this.comboMatrix[3] - this.comboMatrix[1];
        p_planes[2].y = this.comboMatrix[7] - this.comboMatrix[5];
        p_planes[2].z = this.comboMatrix[11] - this.comboMatrix[9];
        p_planes[2].d = this.comboMatrix[15] - this.comboMatrix[13];
        p_planes[3].x = this.comboMatrix[3] + this.comboMatrix[1];
        p_planes[3].y = this.comboMatrix[7] + this.comboMatrix[5];
        p_planes[3].z = this.comboMatrix[11] + this.comboMatrix[9];
        p_planes[3].d = this.comboMatrix[15] + this.comboMatrix[13];
        p_planes[4].x = this.comboMatrix[3] + this.comboMatrix[2];
        p_planes[4].y = this.comboMatrix[7] + this.comboMatrix[6];
        p_planes[4].z = this.comboMatrix[11] + this.comboMatrix[10];
        p_planes[4].d = this.comboMatrix[15] + this.comboMatrix[14];
        p_planes[5].x = this.comboMatrix[3] - this.comboMatrix[2];
        p_planes[5].y = this.comboMatrix[7] - this.comboMatrix[6];
        p_planes[5].z = this.comboMatrix[11] - this.comboMatrix[10];
        p_planes[5].d = this.comboMatrix[15] - this.comboMatrix[14];
        if (normalize) {
            this.NormalizePlane(p_planes[0]);
            this.NormalizePlane(p_planes[1]);
            this.NormalizePlane(p_planes[2]);
            this.NormalizePlane(p_planes[3]);
            this.NormalizePlane(p_planes[4]);
            this.NormalizePlane(p_planes[5]);
        }
    }

    boolean cylinderInFrustum(float px, float py, float pz, float radius_h, float radius_v) {
        float distance = 0.0f;
        boolean result = true;
        distance = this.cam_planes[0].x * px + this.cam_planes[0].y * py + this.cam_planes[0].z * pz + this.cam_planes[0].d;
        System.out.print(">> " + distance + " ");
        distance = this.cam_planes[1].x * px + this.cam_planes[1].y * py + this.cam_planes[1].z * pz + this.cam_planes[1].d;
        System.out.print(String.valueOf(distance) + " ");
        distance = this.cam_planes[2].x * px + this.cam_planes[2].y * py + this.cam_planes[2].z * pz + this.cam_planes[2].d;
        System.out.print(String.valueOf(distance) + " ");
        distance = this.cam_planes[3].x * px + this.cam_planes[3].y * py + this.cam_planes[3].z * pz + this.cam_planes[3].d;
        System.out.print(String.valueOf(distance) + " ");
        distance = this.cam_planes[4].x * px + this.cam_planes[4].y * py + this.cam_planes[4].z * pz + this.cam_planes[4].d;
        System.out.print(String.valueOf(distance) + " ");
        distance = this.cam_planes[5].x * px + this.cam_planes[5].y * py + this.cam_planes[5].z * pz + this.cam_planes[5].d;
        return result;
    }

    public final void behavior() {
        if (this.numAnim != 40 && this.numAnim != 200) {
            if (this.fDistToCam > Globals.MAX_DISTANCE_ENEMY_RENDERING) {
                return;
            }
            switch (this.type) {
                case 0: {
                    this.bhvrGuard();
                    break;
                }
                case 1: {
                    this.bhvrGuard2();
                    break;
                }
                case 2: {
                    this.bhvrGuard3();
                    break;
                }
                case 99: {
                    this.bhvrTakamoto();
                    break;
                }
                case 100: {
                    this.bhvrTakamotoFinal();
                }
            }
        }
    }

    private final void bhvrGuard() {
        if (this.numAnim != 49) {
            if (this.wakeup) {
                if (this.canvas.laraV > this.guyV + 2.0f || this.canvas.laraV < this.guyV - 1.8f || this.canvas.laraH < this.guyH - Globals.SPAWN_DISTANCE || this.canvas.laraH > this.guyH + Globals.SPAWN_DISTANCE) {
                    this.wakeup = false;
                    this.startAlertTime = System.currentTimeMillis();
                } else if (this.numAnim == 0) {
                    this.changeAnim(51);
                }
            } else if (Math.abs(this.guyV - this.canvas.laraV) < 1.0f && (this.canvas.numAnim == 0 || this.canvas.numAnim == 32 || this.canvas.numAnim == 2 || this.canvas.numAnim == 11)) {
                if (this.direction == 1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE || this.direction == -1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE) {
                    this.wakeup = true;
                } else if (this.direction == 1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE / 2.0f || this.direction == -1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE / 2.0f) {
                    this.direction *= -1;
                    this.wakeup = true;
                }
                if (this.wakeup && !this.bGroggy && this.numAnim != 51) {
                    this.changeAnim(51);
                }
            }
            if (this.wakeup && (this.direction == 1 && this.canvas.laraH < this.guyH || this.direction == -1 && this.canvas.laraH > this.guyH) && this.canvas.state != 4) {
                this.bSwitchDirection = true;
            }
            long currTime = System.currentTimeMillis();
            if (this.wakeup && !this.bGroggy) {
                if (this.numAnim == 53) {
                    if (this.nbBulletsLeft > 0) {
                        if (this.canvas.action.lastStand < this.canvas.action.lastCrouch && currTime - this.canvas.action.lastCrouch >= this.canvas.action.maxCrouch && currTime - this.grenadeDelay > Globals.GRENADE_DELAY && Math.abs(this.guyH - this.canvas.laraH) >= Globals.GRENADE_MIN_DISTANCE) {
                            this.bhvrKillLaraGrenade(39);
                        } else if (this.nbRafaleLeft > 0) {
                            if (currTime - this.rafaleDelay > Globals.RAFALE_DELAY && this.isReadyToShoot()) {
                                this.bhvrShoot();
                                --this.nbRafaleLeft;
                            }
                        } else {
                            int max = this.nbBulletsLeft > Globals.RAFALE_MAX ? Globals.RAFALE_MAX : this.nbBulletsLeft;
                            this.nbRafaleLeft = this.rand.nextInt(max + 1);
                            this.rafaleDelay = currTime;
                        }
                    } else if (!this.bReloading) {
                        this.reload();
                    }
                } else if (this.bReloading && (this.numAnim == 48 || this.numAnim == 56)) {
                    this.isReloadingDone();
                }
            } else if (currTime >= this.startAlertTime && currTime - this.startAlertTime < this.alertDelay) {
                if (this.numAnim != 53) {
                    this.changeAnim(53);
                }
            } else {
                if (this.numAnim == 51 || this.numAnim == 53) {
                    this.changeAnim(52);
                }
                this.nbBulletsLeft = Globals.NMBR_BULLETS;
            }
        }
    }

    private void bhvrGuard2() {
        if (this.numAnim != 49) {
            if (this.wakeup) {
                if (this.canvas.laraV > this.guyV + 2.0f || this.canvas.laraV < this.guyV - 1.8f || this.canvas.laraH < this.guyH - Globals.SPAWN_DISTANCE || this.canvas.laraH > this.guyH + Globals.SPAWN_DISTANCE) {
                    this.wakeup = false;
                    this.startAlertTime = System.currentTimeMillis();
                    this.nbBulletsLeft = Globals.NMBR_BULLETS;
                } else if (this.numAnim == 0 && !this.bGroggy) {
                    this.changeAnim(22);
                }
            } else if (Math.abs(this.guyV - this.canvas.laraV) < 1.0f && (this.canvas.numAnim == 0 || this.canvas.numAnim == 32 || this.canvas.numAnim == 2 || this.canvas.numAnim == 11)) {
                if (this.direction == 1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE || this.direction == -1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE) {
                    this.wakeup = true;
                } else if (this.direction == 1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE / 2.0f || this.direction == -1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE / 2.0f) {
                    this.direction *= -1;
                    this.wakeup = true;
                }
                if (this.wakeup && !this.bGroggy && this.numAnim != 32 && this.numAnim != 22) {
                    this.changeAnim(22);
                }
            }
            if (!this.bGroggy && this.wakeup && (this.direction == 1 && this.canvas.laraH < this.guyH || this.direction == -1 && this.canvas.laraH > this.guyH) && this.canvas.state != 4) {
                this.bSwitchDirection = true;
            }
            long currTime = System.currentTimeMillis();
            if (this.wakeup && !this.bGroggy) {
                if (this.numAnim == 60) {
                    if (this.nbBulletsLeft > 0) {
                        if (this.nbRafaleLeft > 0) {
                            if (currTime - this.rafaleDelay > 2L * Globals.RAFALE_DELAY && this.isReadyToShoot()) {
                                this.bhvrShoot();
                                --this.nbRafaleLeft;
                            }
                        } else {
                            int max = this.nbBulletsLeft > Globals.RAFALE_MAX ? Globals.RAFALE_MAX : this.nbBulletsLeft;
                            this.nbRafaleLeft = this.rand.nextInt(max + 1);
                            this.rafaleDelay = currTime;
                        }
                    } else if (!this.bReloading) {
                        this.reload();
                    }
                } else if (this.bReloading && (this.numAnim == 48 || this.numAnim == 56)) {
                    this.isReloadingDone();
                }
            } else if (currTime >= this.startAlertTime && currTime - this.startAlertTime <= this.alertDelay) {
                if (this.numAnim != 60) {
                    this.changeAnim(58);
                }
            } else if (this.numAnim == 32 || this.numAnim == 22 || this.numAnim == 60) {
                this.changeAnim(23);
            } else if (this.numAnim != 23 && this.numAnim == 0 && currTime - this.lastSwitchingTime > this.switchingDelay) {
                this.changeAnim(68);
            }
        }
    }

    private final void bhvrGuard3() {
        if (this.numAnim != 68 && this.numAnim != 49) {
            long currTime = System.currentTimeMillis();
            if (this.wakeup) {
                if (this.canvas.laraV > this.guyV + 2.0f || this.canvas.laraV < this.guyV - 1.8f || this.canvas.laraH < this.guyH - Globals.SPAWN_DISTANCE || this.canvas.laraH > this.guyH + Globals.SPAWN_DISTANCE) {
                    this.wakeup = false;
                    this.startAlertTime = System.currentTimeMillis();
                    this.nbBulletsLeft = Globals.NMBR_BULLETS;
                } else if (this.numAnim == 0) {
                    this.changeAnim(51);
                }
            } else if (Math.abs(this.guyV - this.canvas.laraV) < 1.0f && (this.canvas.numAnim == 0 || this.canvas.numAnim == 32 || this.canvas.numAnim == 2 || this.canvas.numAnim == 11)) {
                if (this.direction == 1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE || this.direction == -1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE) {
                    this.wakeup = true;
                } else if (this.direction == 1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE / 2.0f || this.direction == -1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE / 2.0f) {
                    this.direction *= -1;
                    this.wakeup = true;
                }
                if (this.wakeup && !this.bGroggy && this.numAnim != 51) {
                    this.changeAnim(51);
                }
            }
            if (!this.bGroggy && this.wakeup && (this.direction == 1 && this.canvas.laraH < this.guyH || this.direction == -1 && this.canvas.laraH > this.guyH) && this.canvas.state != 4) {
                this.bSwitchDirection = true;
            }
            if (this.wakeup && !this.bGroggy) {
                if (this.bUp && this.canvas.action.lastCrouch > this.canvas.action.lastStand && currTime - this.canvas.action.lastCrouch > 300L && !this.bReloading) {
                    this.changeAnim(22);
                    this.bUp = false;
                }
                if (!this.bUp && this.canvas.action.lastCrouch < this.canvas.action.lastStand && currTime - this.canvas.action.lastStand > 300L && !this.bReloading) {
                    this.changeAnim(23);
                    this.bUp = true;
                }
                if (this.numAnim == 53 || this.numAnim == 60) {
                    if (this.nbBulletsLeft > 0) {
                        if (this.canvas.action.lastStand < this.canvas.action.lastCrouch && currTime - this.canvas.action.lastCrouch >= this.canvas.action.maxCrouch && currTime - this.grenadeDelay > Globals.GRENADE_DELAY && Math.abs(this.guyH - this.canvas.laraH) >= Globals.GRENADE_MIN_DISTANCE) {
                            if (this.numAnim == 53) {
                                this.bhvrKillLaraGrenade(39);
                            }
                            if (this.numAnim == 60) {
                                this.bhvrKillLaraGrenade(23);
                            }
                        } else if (this.nbRafaleLeft > 0) {
                            if (currTime - this.rafaleDelay > Globals.RAFALE_DELAY && this.numAnim == 53 || currTime - this.rafaleDelay > 4L * Globals.RAFALE_DELAY && this.numAnim == 60) {
                                this.bhvrShoot();
                                --this.nbRafaleLeft;
                            }
                        } else {
                            int max = this.nbBulletsLeft > Globals.RAFALE_MAX ? Globals.RAFALE_MAX : this.nbBulletsLeft;
                            this.nbRafaleLeft = this.rand.nextInt(max + 1);
                            this.rafaleDelay = currTime;
                        }
                    } else if (!this.bReloading) {
                        this.reload();
                    }
                } else if (this.bReloading && (this.numAnim == 48 || this.numAnim == 56)) {
                    this.isReloadingDone();
                }
            } else if (currTime >= this.startAlertTime && currTime - this.startAlertTime <= this.alertDelay) {
                if (this.bUp) {
                    if (this.numAnim != 53) {
                        this.changeAnim(53);
                    }
                } else if (this.numAnim != 60) {
                    this.changeAnim(60);
                }
            } else {
                if (this.numAnim == 60) {
                    this.changeAnim(23);
                } else if (this.numAnim == 23) {
                    return;
                }
                if (this.direction == -1 && this.guyH + this.hSpeed < this.startH - this.roundtripRadius && !this.bWaitingLeft) {
                    this.bWaitingLeft = true;
                    this.lastWaitingTime = currTime;
                } else if (this.direction == 1 && this.guyH + this.hSpeed > this.startH + this.roundtripRadius && !this.bWaitingRight) {
                    this.bWaitingRight = true;
                    this.lastWaitingTime = currTime;
                }
                if (this.bWaitingRight) {
                    if (currTime - this.lastWaitingTime < this.waitingDelay) {
                        if (this.numAnim != 0) {
                            this.changeAnim(0);
                        }
                    } else {
                        if (this.direction == 1) {
                            this.changeAnim(68);
                            return;
                        }
                        this.bWaitingRight = false;
                        this.changeAnim(62);
                    }
                } else if (this.bWaitingLeft) {
                    if (currTime - this.lastWaitingTime < this.waitingDelay) {
                        if (this.numAnim != 0) {
                            this.changeAnim(0);
                        }
                    } else {
                        if (this.direction == -1) {
                            this.changeAnim(68);
                            return;
                        }
                        this.bWaitingLeft = false;
                        this.changeAnim(62);
                    }
                } else if (this.numAnim != 62) {
                    this.changeAnim(62);
                }
            }
        }
    }

    private void bhvrTakamotoFinal() {
        if (this.wakeup) {
            if (this.numAnim == 0) {
                this.changeAnim(73);
            }
        } else if (Math.abs(this.guyV - this.canvas.laraV) < 0.1f && (this.canvas.numAnim == 0 || this.canvas.numAnim == 32 || this.canvas.numAnim == 80 || this.canvas.numAnim == 11)) {
            if (this.direction == 1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE || this.direction == -1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE) {
                this.wakeup = true;
            } else if (this.direction == 1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE / 2.0f || this.direction == -1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE / 2.0f) {
                this.direction *= -1;
                this.wakeup = true;
            }
            if (this.wakeup && this.numAnim != 73) {
                this.changeAnim(73);
            }
        }
        if (this.wakeup) {
            long currTime = System.currentTimeMillis();
            if (!this.bRemote && !this.bLookingForTrap && this.isTriggerUnpulled() && (Math.abs(this.canvas.laraH - this.guyH) < Globals.TAKA_MIN_DISTANCE || this.lastLifeCheck - this.life > this.maxLifeLostBeforeFlee)) {
                this.lastLifeCheck = this.life;
                this.bLookingForTrap = true;
                this.direction = 1;
                this.bUp = true;
                this.changeAnim(80);
                return;
            }
            if (this.bLookingForTrap && !this.bRemote && this.isOnTrigger()) {
                this.changeAnim(63);
                this.bRemote = true;
                this.bLookingForTrap = false;
                this.lastLifeCheck = this.life;
            }
            if (this.numAnim == 63) {
                return;
            }
            if (this.numAnim != 80) {
                if (this.bUp && this.canvas.action.lastCrouch > this.canvas.action.lastStand && currTime - this.canvas.action.lastCrouch > 300L && !this.bReloading) {
                    this.changeAnim(22);
                    this.bUp = false;
                }
                if (!this.bUp && this.canvas.action.lastCrouch < this.canvas.action.lastStand && currTime - this.canvas.action.lastStand > 300L && !this.bReloading) {
                    this.changeAnim(23);
                    this.bUp = true;
                }
            }
            if (this.numAnim == 75 || this.numAnim == 78) {
                if (this.nbBulletsLeft > 0) {
                    if (this.nbRafaleLeft > 0) {
                        if (currTime - this.rafaleDelay > Globals.RAFALE_DELAY * 4L && this.isReadyToShoot()) {
                            this.bhvrShoot();
                            --this.nbRafaleLeft;
                        }
                    } else {
                        int max = this.nbBulletsLeft > Globals.RAFALE_MAX ? Globals.RAFALE_MAX : this.nbBulletsLeft;
                        this.nbRafaleLeft = this.rand.nextInt(max + 1);
                        this.rafaleDelay = currTime;
                    }
                } else if (!this.bReloading) {
                    this.reload();
                } else if (System.currentTimeMillis() - this.startReloadingTime > Globals.RELOAD_DELAY) {
                    this.nbBulletsLeft = Globals.NMBR_BULLETS;
                    this.bReloading = false;
                }
            } else if (this.bReloading && (this.numAnim == 48 || this.numAnim == 56)) {
                this.isReloadingDone();
            }
        }
    }

    private void bhvrTakamoto() {
        if (this.wakeup) {
            if (this.numAnim == 0) {
                this.changeAnim(51);
            }
        } else if (Math.abs(this.guyV - this.canvas.laraV) < 0.1f && (this.canvas.numAnim == 0 || this.canvas.numAnim == 32 || this.canvas.numAnim == 2 || this.canvas.numAnim == 11)) {
            if (this.direction == 1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE || this.direction == -1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE) {
                this.wakeup = true;
            } else if (this.direction == 1 && this.canvas.laraH <= this.guyH && this.canvas.laraH >= this.guyH - Globals.SPAWN_DISTANCE / 2.0f || this.direction == -1 && this.canvas.laraH >= this.guyH && this.canvas.laraH <= this.guyH + Globals.SPAWN_DISTANCE / 2.0f) {
                this.direction *= -1;
                this.wakeup = true;
            }
            if (this.wakeup && this.numAnim != 51) {
                this.changeAnim(51);
            }
        }
        if (this.wakeup) {
            long currTime = System.currentTimeMillis();
            if (this.takaRank == 1) {
                if (!this.bRemote && !this.bLookingForTrap && Math.abs(this.canvas.laraH - this.guyH) < Globals.TAKA_MIN_DISTANCE && this.isTriggerUnpulled() || this.lastLifeCheck - this.life > this.maxLifeLostBeforeFlee) {
                    this.lastLifeCheck = this.life;
                    this.bLookingForTrap = true;
                    this.direction = 1;
                    this.bUp = true;
                    this.changeAnim(62);
                    return;
                }
                if (this.bLookingForTrap && !this.bRemote && this.isOnTrigger()) {
                    this.changeAnim(63);
                    this.bRemote = true;
                    this.bLookingForTrap = false;
                    this.lastLifeCheck = this.life;
                }
                if (this.numAnim == 63) {
                    return;
                }
                this.bRemote = false;
            } else if (this.canvas.action.bTakaFlee) {
                if (this.numAnim != 62) {
                    this.direction = 1;
                    this.bUp = true;
                    this.changeAnim(62);
                }
                if (this.isOnDummy()) {
                    this.canvas.action.badGuys[this.rank] = null;
                }
            }
            if (this.numAnim != 62) {
                if (this.bUp && this.canvas.action.lastCrouch > this.canvas.action.lastStand && currTime - this.canvas.action.lastCrouch > 300L) {
                    this.bUp = false;
                    if (!this.bReloading) {
                        this.changeAnim(22);
                    }
                }
                if (!this.bUp && this.canvas.action.lastCrouch < this.canvas.action.lastStand && currTime - this.canvas.action.lastStand > 300L) {
                    this.bUp = true;
                    if (!this.bReloading) {
                        this.changeAnim(23);
                    }
                }
            }
            if (this.numAnim == 53 || this.numAnim == 60) {
                if (this.nbBulletsLeft > 0) {
                    if (this.canvas.action.lastStand < this.canvas.action.lastCrouch && currTime - this.canvas.action.lastCrouch >= this.canvas.action.maxCrouch && currTime - this.grenadeDelay > Globals.GRENADE_DELAY && Math.abs(this.guyH - this.canvas.laraH) > 2.0f) {
                        if (this.numAnim == 53) {
                            this.bhvrKillLaraGrenade(39);
                        }
                        if (this.numAnim == 60) {
                            this.bhvrKillLaraGrenade(23);
                        }
                    } else if (this.nbRafaleLeft > 0) {
                        if (currTime - this.rafaleDelay > Globals.RAFALE_DELAY && this.isReadyToShoot()) {
                            this.bhvrShoot();
                            --this.nbRafaleLeft;
                        }
                    } else {
                        int max = this.nbBulletsLeft > Globals.RAFALE_MAX ? Globals.RAFALE_MAX : this.nbBulletsLeft;
                        this.nbRafaleLeft = this.rand.nextInt(max + 1);
                        this.rafaleDelay = currTime;
                    }
                } else if (!this.bReloading) {
                    this.reload();
                }
            } else if (this.bReloading && (this.numAnim == 48 || this.numAnim == 56)) {
                this.isReloadingDone();
            }
        }
    }

    private void bhvrShoot() {
        switch (this.type) {
            case 0: {
                if (this.numAnim != 53) break;
                int i = 0;
                while (i < 3) {
                    if (!this.bullets[i].isShot()) {
                        this.changeAnim(54);
                        this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                        this.playGunSound();
                        --this.nbBulletsLeft;
                        this.gunDelay = System.currentTimeMillis();
                        return;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                if (this.numAnim != 60) break;
                int i = 0;
                while (i < 3) {
                    if (!this.bullets[i].isShot()) {
                        this.changeAnim(57);
                        this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT_CROUCH, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                        this.playGunSound();
                        --this.nbBulletsLeft;
                        this.gunDelay = System.currentTimeMillis();
                        return;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                if (this.numAnim == 53) {
                    int i = 0;
                    while (i < 3) {
                        if (!this.bullets[i].isShot()) {
                            this.changeAnim(54);
                            this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                            this.playGunSound();
                            --this.nbBulletsLeft;
                            this.gunDelay = System.currentTimeMillis();
                            return;
                        }
                        ++i;
                    }
                } else {
                    if (this.numAnim != 60) break;
                    int i = 0;
                    while (i < 3) {
                        if (!this.bullets[i].isShot()) {
                            this.changeAnim(57);
                            this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT_CROUCH, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                            this.playGunSound();
                            --this.nbBulletsLeft;
                            this.gunDelay = System.currentTimeMillis();
                            return;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 99: {
                if (this.numAnim == 53) {
                    int i = 0;
                    while (i < 3) {
                        if (!this.bullets[i].isShot()) {
                            this.changeAnim(54);
                            this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                            this.playGunSound();
                            --this.nbBulletsLeft;
                            this.gunDelay = System.currentTimeMillis();
                            return;
                        }
                        ++i;
                    }
                } else {
                    if (this.numAnim != 60) break;
                    int i = 0;
                    while (i < 3) {
                        if (!this.bullets[i].isShot()) {
                            this.changeAnim(57);
                            this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT_CROUCH, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                            this.playGunSound();
                            --this.nbBulletsLeft;
                            this.gunDelay = System.currentTimeMillis();
                            return;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 100: {
                if (this.numAnim == 75) {
                    int i = 0;
                    while (i < 3) {
                        if (!this.bullets[i].isShot()) {
                            this.changeAnim(70);
                            this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                            this.playGunSound();
                            --this.nbBulletsLeft;
                            this.gunDelay = System.currentTimeMillis();
                            return;
                        }
                        ++i;
                    }
                } else {
                    if (this.numAnim != 78) break;
                    int i = 0;
                    while (i < 3) {
                        if (!this.bullets[i].isShot()) {
                            this.changeAnim(71);
                            this.bullets[i].launch(this.guyP, this.guyV + Globals.YAK_SHOOT_HEIGHT_CROUCH - 0.4f, this.guyH + this.hSpeed + (float)this.direction * 0.8f, this.direction);
                            this.playGunSound();
                            --this.nbBulletsLeft;
                            this.gunDelay = System.currentTimeMillis();
                            return;
                        }
                        ++i;
                    }
                }
                break;
            }
        }
    }

    private void playGunSound() {
        this.canvas.sound.PlayerStart(0);
    }

    private void reload() {
        this.bReloading = true;
        this.startReloadingTime = System.currentTimeMillis();
    }

    private boolean isReloadingDone() {
        long currTime = System.currentTimeMillis();
        boolean bl = this.bReloading = currTime - this.startReloadingTime <= this.reloadDelay;
        if (!this.bReloading) {
            this.nbBulletsLeft = Globals.NMBR_BULLETS;
            return true;
        }
        return false;
    }

    private boolean isReadyToShoot() {
        long currTime = System.currentTimeMillis();
        return currTime - this.gunDelay > Globals.GUN_DELAY;
    }

    private final void bhvrKillLaraGrenade(int newAnim) {
        this.bLaunchGrenade = true;
        if (this.numAnim != 39 && System.currentTimeMillis() - this.grenadeDelay > Globals.GRENADE_DELAY) {
            int i = 3;
            while (--i >= 0) {
                if (!this.grenades[i].isAvailable()) continue;
                this.grenadeLaunched = i;
                break;
            }
            this.changeAnim(newAnim);
        }
    }

    public void restartNadesAndBullets(long pauseTime) {
        int i = 3;
        while (--i >= 0) {
            if (this.grenades[i].isAvailable()) continue;
            this.grenades[i].restart(pauseTime);
        }
        i = 3;
        while (--i >= 0) {
            if (this.bullets[i].isShot()) continue;
            this.bullets[i].restart(pauseTime);
        }
        this.rafaleDelay += pauseTime;
        this.startReloadingTime += pauseTime;
        this.lastSwitchingTime += pauseTime;
        this.lastWaitingTime += pauseTime;
        this.startGroggyTime += pauseTime;
        this.gunDelay += pauseTime;
        this.grenadeDelay += pauseTime;
        this.startAlertTime += pauseTime;
    }

    public int toLara() {
        int dir = 1;
        if (this.canvas.laraH < this.guyH) {
            dir = -1;
        }
        return dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOnTrigger() {
        try {
            float colStart = 0.0f;
            float colEnd = 0.0f;
            int i = 0;
            int col = 0;
            while (col < this.canvas.nbCollisionsVert) {
                int trapNum;
                if (this.canvas.tabCollisionsVTType[col * 12 + 0] == 17 && this.canvas.tabCollisionsVTType[col * 12 + 8] == 1 && this.canvas.tabCollisionsVTType[(trapNum = this.canvas.tabCollisionsVTType[col * 12 + 10]) * 12 + 11] == 2) {
                    colStart = this.canvas.tabCollisionsVert[col * 5 + 0];
                    colEnd = this.canvas.tabCollisionsVert[col * 5 + 2];
                    if (this.guyH + this.hSpeed >= colStart && this.guyH + this.hSpeed <= colEnd) {
                        this.trapIndex[i] = trapNum;
                        ++i;
                    }
                }
                ++col;
            }
            if (i != 2) return false;
            int k = 0;
            while (k < 3) {
                if (!this.trapTriggered[k]) {
                    this.trapTriggered[k] = true;
                    return true;
                }
                ++k;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOnDummy() {
        try {
            float colStart = 0.0f;
            float colEnd = 0.0f;
            float colTop = 0.0f;
            float colBottom = 0.0f;
            int col = 0;
            while (true) {
                if (col >= this.canvas.nbCollisionsVert) {
                    return false;
                }
                if (this.canvas.tabCollisionsVTType[col * 12 + 0] == 19) {
                    int colNum = col * 5;
                    colStart = this.canvas.tabCollisionsVert[colNum + 0];
                    colEnd = this.canvas.tabCollisionsVert[colNum + 2];
                    colTop = this.canvas.tabCollisionsVert[colNum + 3];
                    colBottom = this.canvas.tabCollisionsVert[colNum + 1];
                    if (this.guyH + this.hSpeed >= colStart && this.guyH + this.hSpeed <= colEnd && this.guyV >= colBottom && this.guyV <= colTop) {
                        return true;
                    }
                }
                ++col;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void activateTrap() {
        if (this.trapIndex[0] != -1 && this.trapIndex[1] != -1) {
            this.canvas.tabCollisionsVTType[this.trapIndex[0] * 12 + 11] = 1;
            this.canvas.tabCollisionsVTType[this.trapIndex[1] * 12 + 11] = 1;
        }
        this.trapIndex[0] = -1;
        this.trapIndex[1] = -1;
    }

    private boolean isTriggerUnpulled() {
        int i = 0;
        while (i < 3) {
            if (!this.trapTriggered[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void transition() {
        block95: {
            block96: {
                if (this.fDistToCam > Globals.MAX_DISTANCE_ENEMY_RENDERING) {
                    return;
                }
                this.lastHSpeed = this.hSpeed;
                boolean bStandardAnim = true;
                boolean bSpecialState = false;
                if (this.numAnim < 100) {
                    if (TRLCanvas.tabAnims[this.numAnim * 2 + 1] < TRLCanvas.tabAnims[this.numAnim * 2]) {
                        bStandardAnim = false;
                    }
                } else {
                    bSpecialState = true;
                }
                switch (this.numAnim) {
                    case 0: {
                        this.multFrame = 30.0f;
                        break;
                    }
                    case 63: {
                        this.multFrame = 50.0f;
                        break;
                    }
                    case 13: {
                        this.multFrame = 70.0f;
                        break;
                    }
                    case 46: {
                        this.multFrame = 20.0f;
                        break;
                    }
                    case 51: {
                        this.multFrame = 50.0f;
                        break;
                    }
                    case 52: {
                        this.multFrame = 40.0f;
                        break;
                    }
                    case 48: {
                        this.multFrame = 15.0f;
                        break;
                    }
                    case 56: {
                        this.multFrame = 5.0f;
                        break;
                    }
                    case 68: {
                        this.multFrame = 80.0f;
                        break;
                    }
                    case 53: 
                    case 54: {
                        this.multFrame = 40.0f;
                        break;
                    }
                    default: {
                        this.multFrame = 50.0f;
                    }
                }
                if (this.canvas.lastFps < this.canvas.fpsNeeded) {
                    this.multFrame = this.multFrame * (float)this.canvas.fpsNeeded / (float)Math.max(this.canvas.lastFps, 8);
                }
                if (!bSpecialState) {
                    this.m_bipedStep = bStandardAnim ? (int)((float)this.m_bipedStep + this.multFrame) : (int)((float)this.m_bipedStep - this.multFrame);
                }
                if (!bSpecialState && (!bStandardAnim || this.m_bipedStep < TRLCanvas.tabAnims[this.numAnim * 2 + 1]) && (bStandardAnim || this.m_bipedStep > TRLCanvas.tabAnims[this.numAnim * 2 + 1])) break block95;
                if (!bSpecialState && bStandardAnim) {
                    this.m_bipedStep = TRLCanvas.tabAnims[this.numAnim * 2 + 1];
                }
                if (this.type != 100) break block96;
                switch (this.numAnim) {
                    case 49: {
                        this.changeAnim(0);
                        break;
                    }
                    case 68: {
                        this.changeAnim(0);
                        this.direction *= -1;
                        this.lastSwitchingTime = System.currentTimeMillis();
                        break;
                    }
                    case 63: {
                        this.changeAnim(0);
                        this.direction *= -1;
                        this.bRemote = false;
                        break;
                    }
                    case 0: {
                        this.changeAnim(0);
                        break;
                    }
                    case 80: {
                        if (this.bLookingForTrap) {
                            this.changeAnim(80);
                            break;
                        }
                        this.changeAnim(0);
                        break;
                    }
                    case 39: {
                        if (this.grenades[this.grenadeLaunched].isAvailable()) {
                            this.grenades[this.grenadeLaunched].launch(this.guyP, this.guyV + 1.715f, this.guyH + (float)this.direction, Math.abs(this.canvas.laraH - this.guyH));
                            this.grenadeDelay = System.currentTimeMillis();
                        }
                        if (!this.wakeup) {
                            this.changeAnim(0);
                        } else if (this.bUp) {
                            this.changeAnim(73);
                        } else {
                            this.changeAnim(22);
                        }
                        this.bLaunchGrenade = false;
                        break;
                    }
                    case 73: {
                        this.gunDelay = System.currentTimeMillis();
                        this.changeAnim(75);
                        break;
                    }
                    case 74: {
                        if (this.bSwitchDirection) {
                            this.bSwitchDirection = false;
                            this.direction *= -1;
                            this.lastSwitchingTime = System.currentTimeMillis();
                            this.changeAnim(73);
                            break;
                        }
                        this.changeAnim(0);
                        break;
                    }
                    case 75: {
                        if (this.bSwitchDirection) {
                            this.changeAnim(74);
                            break;
                        }
                        break block95;
                    }
                    case 70: {
                        this.shootEffect.setRenderingEnable(false);
                        this.changeAnim(75);
                        break;
                    }
                    case 32: {
                        if (this.bUp) {
                            this.changeAnim(23);
                            break;
                        }
                        this.changeAnim(76);
                        break;
                    }
                    case 22: {
                        this.changeAnim(32);
                        break;
                    }
                    case 23: {
                        if (this.bLaunchGrenade) {
                            this.changeAnim(39);
                            break;
                        }
                        this.changeAnim(0);
                        break;
                    }
                    case 77: {
                        this.changeAnim(32);
                        break;
                    }
                    case 76: {
                        this.changeAnim(78);
                        break;
                    }
                    case 78: {
                        if (this.bUp) {
                            this.changeAnim(23);
                            break;
                        }
                        this.changeAnim(78);
                        break;
                    }
                    case 71: {
                        this.shootEffect.setRenderingEnable(false);
                        this.changeAnim(78);
                        break;
                    }
                }
                break block95;
            }
            switch (this.numAnim) {
                case 49: {
                    this.changeAnim(0);
                    break;
                }
                case 68: {
                    this.changeAnim(0);
                    this.direction *= -1;
                    this.lastSwitchingTime = System.currentTimeMillis();
                    break;
                }
                case 63: {
                    this.changeAnim(0);
                    this.direction *= -1;
                    break;
                }
                case 0: {
                    this.changeAnim(0);
                    break;
                }
                case 47: {
                    if (!this.bReloading) break;
                    this.changeAnim(48);
                    break;
                }
                case 62: {
                    if (this.type == 99) {
                        if (this.bLookingForTrap) {
                            this.changeAnim(62);
                            break;
                        }
                        this.changeAnim(0);
                        break;
                    }
                    this.changeAnim(0);
                    break;
                }
                case 46: {
                    this.shootEffect.setRenderingEnable(false);
                    this.changeAnim(47);
                    break;
                }
                case 39: {
                    if (this.grenades[this.grenadeLaunched].isAvailable()) {
                        this.grenades[this.grenadeLaunched].launch(this.guyP, this.guyV + 1.715f, this.guyH + (float)this.direction, Math.abs(this.canvas.laraH - this.guyH));
                        this.grenadeDelay = System.currentTimeMillis();
                    }
                    if (!this.wakeup) {
                        this.changeAnim(0);
                    } else if (this.type == 2 || this.type == 99) {
                        if (this.bUp) {
                            this.changeAnim(51);
                        } else {
                            this.changeAnim(22);
                        }
                    } else if (this.type == 0) {
                        this.changeAnim(51);
                    }
                    this.bLaunchGrenade = false;
                    break;
                }
                case 48: 
                case 56: {
                    if (!this.bReloading) {
                        if (this.type == 0) {
                            this.changeAnim(51);
                        }
                        if (this.type == 1) {
                            this.changeAnim(22);
                        }
                        if (this.type != 2 && this.type != 99) break;
                        if (this.bUp) {
                            this.changeAnim(51);
                            break;
                        }
                        this.changeAnim(22);
                        break;
                    }
                    this.changeAnim(56);
                    break;
                }
                case 55: {
                    if (this.wakeup) {
                        this.changeAnim(51);
                        break;
                    }
                    this.changeAnim(0);
                    break;
                }
                case 51: {
                    this.gunDelay = System.currentTimeMillis();
                    this.changeAnim(53);
                    break;
                }
                case 52: {
                    if (this.bSwitchDirection) {
                        this.bSwitchDirection = false;
                        this.direction *= -1;
                        this.lastSwitchingTime = System.currentTimeMillis();
                        this.changeAnim(51);
                        break;
                    }
                    if (this.bReloading) {
                        this.changeAnim(48);
                        break;
                    }
                    this.changeAnim(0);
                    break;
                }
                case 53: {
                    if (!this.bReloading && !this.bSwitchDirection) break;
                    this.changeAnim(52);
                    break;
                }
                case 54: {
                    this.shootEffect.setRenderingEnable(false);
                    this.changeAnim(53);
                    break;
                }
                case 32: {
                    if (this.bReloading || (this.type == 2 || this.type == 99) && this.bUp) {
                        this.changeAnim(23);
                        break;
                    }
                    this.changeAnim(58);
                    break;
                }
                case 22: {
                    this.changeAnim(32);
                    break;
                }
                case 23: {
                    if (this.bLaunchGrenade) {
                        this.changeAnim(39);
                        break;
                    }
                    if (this.bReloading) {
                        this.changeAnim(48);
                        break;
                    }
                    this.changeAnim(0);
                    break;
                }
                case 59: {
                    this.changeAnim(32);
                    break;
                }
                case 58: {
                    this.changeAnim(60);
                    break;
                }
                case 60: {
                    if (this.bReloading || this.type == 2 && this.bUp) {
                        this.changeAnim(23);
                    } else {
                        this.changeAnim(60);
                    }
                    if (!this.bSwitchDirection) break;
                    this.bSwitchDirection = false;
                    this.direction *= -1;
                    this.lastSwitchingTime = System.currentTimeMillis();
                    break;
                }
                case 57: {
                    this.shootEffect.setRenderingEnable(false);
                    this.changeAnim(60);
                    break;
                }
                case 40: {
                    if (!this.bIsBlown) break;
                    this.bIsBlown = false;
                    this.changeAnim(0);
                }
            }
        }
    }

    public final void animate() {
        block23: {
            boolean posError = false;
            try {
                if (this.fDistToCam > Globals.MAX_DISTANCE_ENEMY_RENDERING) {
                    return;
                }
                if (this.numAnim >= 100) break block23;
                int dep1 = TRLCanvas.tabAnims[this.numAnim * 2];
                int dep2 = TRLCanvas.tabAnims[this.numAnim * 2 + 1];
                float dist = TRLCanvas.tabDists[this.numAnim * 2];
                posError = true;
                switch (this.numAnim) {
                    case 80: {
                        if (this.m_bipedStep >= dep1 && this.m_bipedStep <= dep2) {
                            this.hSpeed = (float)this.direction * (dist * (float)(this.m_bipedStep - dep1)) / (float)(dep2 - dep1);
                        }
                        break;
                    }
                    case 62: {
                        if (this.m_bipedStep >= dep1 && this.m_bipedStep <= dep2) {
                            this.hSpeed = (float)this.direction * (dist * (float)(this.m_bipedStep - dep1)) / (float)(dep2 - dep1);
                        }
                        break;
                    }
                    case 54: {
                        float height = Globals.YAK_SHOOT_HEIGHT;
                        if (this.direction == 1) {
                            this.shootEffect.setOrientation(-90.0f, 0.0f, 1.0f, 0.0f);
                            this.shootEffect.postRotate(180.0f, 0.0f, 0.0f, 1.0f);
                        } else {
                            this.shootEffect.setOrientation(-90.0f, 0.0f, 1.0f, 0.0f);
                        }
                        this.shootEffect.setTranslation(this.guyP - 0.05f, this.guyV + height, this.guyH + this.hSpeed + (float)this.direction * 0.8f);
                        float ffScale = (float)(this.m_bipedStep - dep1) / (float)((dep2 - dep1) / 2) * 2.0f;
                        if (ffScale > 1.0f) {
                            ffScale = 1.0f;
                        }
                        this.shootEffect.setScale(ffScale, ffScale, ffScale);
                        this.shootEffect.setRenderingEnable(true);
                        break;
                    }
                    case 57: {
                        float height = Globals.YAK_SHOOT_HEIGHT_CROUCH;
                        if (this.direction == 1) {
                            this.shootEffect.setOrientation(-90.0f, 0.0f, 1.0f, 0.0f);
                            this.shootEffect.postRotate(180.0f, 0.0f, 0.0f, 1.0f);
                        } else {
                            this.shootEffect.setOrientation(-90.0f, 0.0f, 1.0f, 0.0f);
                        }
                        this.shootEffect.setTranslation(this.guyP - 0.05f, this.guyV + height, this.guyH + this.hSpeed + (float)this.direction);
                        float ffScale = (float)(this.m_bipedStep - dep1) / (float)((dep2 - dep1) / 2) * 2.0f;
                        if (ffScale > 1.0f) {
                            ffScale = 1.0f;
                        }
                        this.shootEffect.setScale(ffScale, ffScale, ffScale);
                        this.shootEffect.setRenderingEnable(true);
                        break;
                    }
                    case 63: {
                        if ((float)this.m_bipedStep > (float)(dep2 + dep1) / 2.0f && this.trapIndex[0] != -1 && this.trapIndex[1] != -1) {
                            this.activateTrap();
                        }
                        break;
                    }
                    case 40: {
                        if (this.bIsBlown) break;
                        this.shootEffect.setRenderingEnable(false);
                        long ctm = System.currentTimeMillis();
                        if (ctm > this.deathTime + 4000L) {
                            this.bIsVisible = false;
                            this.changeAnim(200);
                            break;
                        }
                        if (ctm <= this.deathTime + 2000L || ctm <= this.deathTime2 + 200L) break;
                        this.bIsVisible = this.deathCligno = !this.deathCligno;
                        this.deathTime2 = ctm;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean collisions() {
        if (this.fDistToCam > Globals.MAX_DISTANCE_ENEMY_RENDERING) {
            return false;
        }
        float colRight = 0.0f;
        float colLeft = 0.0f;
        float colBottom = 0.0f;
        float colTop = 0.0f;
        int col = 0;
        while (col < this.canvas.nbCollisionsVert) {
            if (this.canvas.tabCollisionsVTType[col * 12 + 0] == 0) {
                int colNum = col * 5;
                colLeft = this.canvas.tabCollisionsVert[colNum + 0];
                colRight = this.canvas.tabCollisionsVert[colNum + 2];
                colTop = this.canvas.tabCollisionsVert[colNum + 3];
                colBottom = this.canvas.tabCollisionsVert[colNum + 1];
                if (this.direction == -1 && this.guyH + this.hSpeed - this.colThresold <= colRight && this.guyH + this.hSpeed - this.colThresold >= colLeft && this.guyV >= colBottom && this.guyV <= colTop) {
                    return true;
                }
                if (this.direction == 1 && this.guyH + this.hSpeed + this.colThresold >= colLeft && this.guyH + this.hSpeed + this.colThresold <= colRight && this.guyV >= colBottom && this.guyV <= colTop) {
                    return true;
                }
            }
            ++col;
        }
        return false;
    }

    public final void paint() {
        int i;
        if (this.grenades != null) {
            i = 3;
            while (--i >= 0) {
                this.grenades[i].move();
                this.grenades[i].paint();
            }
        }
        if (this.bullets != null) {
            i = 0;
            while (i < 3) {
                if (this.bullets[i].isShot()) {
                    this.bullets[i].move();
                }
                this.bullets[i].showImpact();
                ++i;
            }
        }
        if (this.fDistToCam > Globals.MAX_DISTANCE_ENEMY_RENDERING) {
            return;
        }
        if (this.bIsVisible) {
            this.biped.animate(this.m_bipedStep);
            this.orientation = this.direction == 1 ? 0 : 180;
            this.biped.getTranslation(this.newPos);
            this.biped.setTranslation(0.0f, 0.0f, 0.0f);
            this.biped.preRotate((float)this.orientation, 0.0f, 1.0f, 0.0f);
            float rX = (float)((double)this.newPos[0] * Math.cos(this.orientation) + (double)this.newPos[2] * Math.sin(this.orientation));
            float rZ = (float)((double)this.newPos[2] * Math.cos(this.orientation) - (double)this.newPos[0] * Math.sin(this.orientation));
            this.biped.setTranslation(rX, this.newPos[1], rZ);
            this.biped.translate(this.guyP, this.guyV, this.guyH + this.hSpeed);
            this.biped.setRenderingEnable(true);
            if (this.life > 0) {
                this.lifeSprite.setRenderingEnable(true);
                this.lifeSprite.setTranslation(this.guyP, this.guyV + 1.715f + 0.2f, this.guyH + this.hSpeed);
                this.lifeSprite.setScale((float)this.life / (float)this.startLife, 0.1f, 1.0f);
            } else {
                this.lifeSprite.setRenderingEnable(false);
            }
        }
        if (this.bGroggy) {
            this.canvas.action.groggyPos += this.canvas.action.groggyIncrement;
            if (this.canvas.action.groggyPos >= 0.5f) {
                this.canvas.action.groggyIncrement = -0.1f;
            }
            if (this.canvas.action.groggyPos <= -0.5f) {
                this.canvas.action.groggyIncrement = 0.1f;
            }
            this.canvas.action.groggyEffect.setTranslation(this.guyP, this.guyV + 1.715f + 0.2f, this.guyH + this.hSpeed + this.canvas.action.groggyPos);
            this.canvas.action.groggyEffect.setRenderingEnable(true);
            if (System.currentTimeMillis() - this.startGroggyTime > this.groggyDelay) {
                this.bGroggy = false;
                this.canvas.action.groggyEffect.setRenderingEnable(false);
                if (this.life > 0) {
                    this.direction = this.toLara();
                    this.wakeup = true;
                }
            }
        }
    }

    public void setGroggy(int dmg) {
        if (!this.bGroggyYet) {
            this.life -= dmg;
            if (this.canvas.bMission) {
                this.canvas.score.addDamageInflicted(dmg);
            }
            if (this.life <= 0) {
                this.setKilled();
                return;
            }
            this.changeAnim(0);
            this.bGroggy = true;
            this.bGroggyYet = true;
            this.startGroggyTime = System.currentTimeMillis();
        }
    }

    public void setShot(int dmg) {
        this.wakeup = true;
        this.life -= dmg;
        if (this.canvas.bMission) {
            this.canvas.score.addDamageInflicted(dmg);
        }
        if (this.life <= 0) {
            this.setKilled();
        } else if (this.numAnim != 32 && this.numAnim != 60 && this.numAnim != 59 && this.numAnim != 58 && this.numAnim != 22 && this.numAnim != 80 && this.numAnim != 63 && this.numAnim != 77 && this.numAnim != 78 && this.numAnim != 76 && this.numAnim != 71) {
            this.changeAnim(49);
        }
    }

    public void setBlown(int damage) {
        this.wakeup = true;
        this.life -= damage;
        if (this.life <= 0) {
            this.setKilled();
        } else {
            this.bIsBlown = true;
            this.changeAnim(40);
        }
    }

    public final void setKilled() {
        if (this.numAnim != 40) {
            this.life = 0;
            this.changeAnim(40);
            this.deathTime = this.deathTime2 = this.curAnimStartTime;
            this.deathCligno = false;
            this.shootEffect.setRenderingEnable(false);
            this.lifeSprite.setRenderingEnable(false);
            if (this.type == 100) {
                this.canvas.action.shardP = this.guyP;
                this.canvas.action.shardH = this.guyH + this.hSpeed;
                this.canvas.action.shardV = this.guyV;
                this.canvas.action.shardImage.setTranslation(this.canvas.action.shardP, this.canvas.action.shardV, this.canvas.action.shardH);
                this.canvas.action.shardImage.setRenderingEnable(true);
                this.canvas.action.bShowShard = true;
                this.canvas.action.startShowingShard = System.currentTimeMillis();
            }
        }
    }

    public boolean isAlive() {
        boolean ret = this.life > 0;
        return ret;
    }

    class Plane {
        float x;
        float y;
        float z;
        float d;

        Plane() {
        }
    }

    private final class Grenade {
        private float nadeP;
        private float nadeV;
        private float nadeH;
        private float nextNadeV;
        private float nextNadeH;
        private Sprite3D sprite;
        private Sprite3D[] spriteExplo;
        private int exploFrame;
        private long launchTime;
        private long launchDuration;
        private long exploTime;
        private long exploDuration;
        private long startPauseTime;
        private long totalPauseTime;
        private int rebounds;
        private float hSpeedNade;
        private float hSpeedBase;
        private float vSpeedNade;
        private float vSpeedBase;
        private int direction;
        private BadGuy owner;
        private int state;
        private final int STATE_MOVING;
        private final int STATE_EXPLODING;
        private final int STATE_AVAILABLE;
        public static final int CLOSE = 0;
        public static final int MEDIUM = 1;
        public static final int FAR = 2;
        private long lastCheckTime;

        private Grenade(Sprite3D _sprite, BadGuy _bg) {
            this.STATE_MOVING = 0;
            this.STATE_EXPLODING = 1;
            this.STATE_AVAILABLE = 2;
            this.owner = _bg;
            this.sprite = _sprite;
            this.sprite.setRenderingEnable(false);
            this.spriteExplo = new Sprite3D[BadGuy.this.canvas.grenadeExplo.length];
            int i = BadGuy.this.canvas.grenadeExplo.length;
            while (--i >= 0) {
                this.spriteExplo[i] = BadGuy.this.canvas.grenadeExplo[i];
                this.spriteExplo[i].setRenderingEnable(false);
            }
            this.exploFrame = 0;
            this.launchDuration = Globals.GRENADE_TIME;
            this.exploDuration = 300L;
            this.state = 2;
        }

        private final void delete() {
            BadGuy.this.canvas.world.removeChild((Node)this.sprite);
            int i = BadGuy.this.canvas.grenadeExplo.length;
            while (--i >= 0) {
                BadGuy.this.canvas.world.removeChild((Node)this.spriteExplo[i]);
            }
            this.sprite = null;
            this.spriteExplo = null;
        }

        private final void launch(float _p, float _v, float _h, float _distance) {
            this.rebounds = 0;
            this.hSpeedBase = _distance / 18.0f;
            this.vSpeedBase = 0.25f;
            this.hSpeedNade = this.hSpeedBase;
            this.vSpeedNade = this.vSpeedBase;
            this.launchTime = System.currentTimeMillis();
            this.direction = this.owner.direction;
            this.nadeP = _p;
            this.nadeV = _v;
            this.nadeH = _h;
            this.state = 0;
            this.lastCheckTime = this.launchTime;
        }

        private final void move() {
            long currTime = System.currentTimeMillis();
            long pastTime = currTime - this.lastCheckTime;
            switch (this.state) {
                case 0: {
                    if (currTime - this.launchTime < this.launchDuration && this.rebounds < Globals.GRENADE_NBREBONDS) {
                        this.sprite.setRenderingEnable(true);
                        this.vSpeedNade -= (float)(currTime - this.lastCheckTime) / 100.0f * 0.1f;
                        this.nextNadeH = this.nadeH + (float)this.direction * this.hSpeedNade * ((float)pastTime / 100.0f);
                        this.nextNadeV = this.nadeV + this.vSpeedNade;
                        if (!this.collide()) {
                            this.nadeH = this.nextNadeH;
                            this.nadeV = this.nextNadeV;
                        }
                        this.lastCheckTime = currTime;
                        break;
                    }
                    if (currTime - this.launchTime < this.launchDuration) break;
                    if (Math.abs(BadGuy.this.canvas.laraH + BadGuy.this.canvas.hSpeed - this.nadeH) <= Globals.GRENADE_DISTANCE && Math.abs(BadGuy.this.canvas.laraV + BadGuy.this.canvas.vSpeed - this.nadeV) <= 1.0f) {
                        BadGuy.this.canvas.action.killLara(Globals.GRENADE_DAMAGE);
                    }
                    this.state = 1;
                    this.exploTime = currTime;
                    BadGuy.this.canvas.sound.PlayerStart(0);
                    break;
                }
                case 1: {
                    this.sprite.setRenderingEnable(false);
                    float past = (currTime - this.exploTime) / this.exploDuration;
                    int exploLength = BadGuy.this.canvas.grenadeExplo.length;
                    this.nadeV += 0.1f;
                    if (past > 1.0f) {
                        int i = 0;
                        while (i < exploLength) {
                            this.spriteExplo[i].setRenderingEnable(false);
                            ++i;
                        }
                        this.state = 2;
                        break;
                    }
                    this.exploFrame = (int)(past % (float)((int)((float)this.exploDuration / (float)exploLength)) + 1.0f);
                    int i = 0;
                    while (i < exploLength) {
                        if (i != this.exploFrame) {
                            this.spriteExplo[i].setRenderingEnable(false);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }

        private boolean isAvailable() {
            return this.state == 2;
        }

        private final boolean collide() {
            float halfNadeV = (this.nadeV + this.nextNadeV) / 2.0f;
            float halfNadeH = (this.nadeH + this.nextNadeH) / 2.0f;
            if (this.state == 0 && this.rebounds < Globals.GRENADE_NBREBONDS) {
                int numCol;
                int col = 0;
                while (col < BadGuy.this.canvas.nbCollisionsVert) {
                    if (BadGuy.this.canvas.tabCollisionsVTType[col * 12 + 0] == 0) {
                        numCol = col * 5;
                        float colH = 0.0f;
                        float colTop = BadGuy.this.canvas.tabCollisionsVert[numCol + 3];
                        float colBottom = BadGuy.this.canvas.tabCollisionsVert[numCol + 1];
                        colH = this.direction == 1 ? BadGuy.this.canvas.tabCollisionsVert[numCol + 0] : BadGuy.this.canvas.tabCollisionsVert[numCol + 2];
                        if ((this.nextNadeH - colH) * (this.nadeH - colH) <= 0.0f && (this.nextNadeV <= colTop && this.nextNadeV >= colBottom || this.nadeV <= colTop && this.nadeV >= colBottom)) {
                            this.nadeH = colH;
                            this.nadeV = halfNadeV;
                            this.direction *= -1;
                            return true;
                        }
                        float colStartH = BadGuy.this.canvas.tabCollisionsVert[numCol + 0];
                        float colEndH = BadGuy.this.canvas.tabCollisionsVert[numCol + 2];
                        if (halfNadeH <= colEndH && halfNadeH >= colStartH && this.nextNadeV <= colTop && this.nadeV >= colTop) {
                            ++this.rebounds;
                            if (this.rebounds < 3) {
                                this.nadeV = colTop + 0.1f;
                                this.nadeH = halfNadeH;
                                this.hSpeedNade *= 0.75f;
                                this.vSpeedNade *= -0.5f;
                            } else {
                                this.vSpeedNade = 0.0f;
                                this.hSpeedNade = 0.0f;
                            }
                            return true;
                        }
                    }
                    ++col;
                }
                col = 0;
                while (col < BadGuy.this.canvas.nbCollisions) {
                    numCol = col * 4;
                    if (BadGuy.this.canvas.tabCollisionsHZType[col * 3 + 0] != 5) {
                        float colStartH = BadGuy.this.canvas.tabCollisions[numCol + 0];
                        float colEndH = BadGuy.this.canvas.tabCollisions[numCol + 1];
                        float colV = BadGuy.this.canvas.tabCollisions[numCol + 2];
                        if (this.nextNadeH <= colEndH && this.nextNadeH >= colStartH && this.nadeV >= colV && this.nextNadeV <= colV) {
                            ++this.rebounds;
                            if (this.rebounds < 3) {
                                this.nadeH = halfNadeH;
                                this.nadeV = colV + 0.1f;
                                this.hSpeedNade *= 0.75f;
                                this.vSpeedNade *= -0.5f;
                            } else {
                                this.vSpeedNade = 0.0f;
                                this.hSpeedNade = 0.0f;
                            }
                            return true;
                        }
                    } else {
                        float startH = 0.0f;
                        float startV = 0.0f;
                        float endH = 0.0f;
                        float endV = 0.0f;
                        float deltaV = 0.0f;
                        float nextDeltaV = 0.0f;
                        startH = BadGuy.this.canvas.tabCollisions[numCol + 0];
                        startV = BadGuy.this.canvas.tabCollisions[numCol + 2];
                        endH = BadGuy.this.canvas.tabCollisions[numCol + 1];
                        endV = BadGuy.this.canvas.tabCollisions[numCol + 3];
                        if (this.nadeH >= startH && this.nadeH <= endH || this.nextNadeH >= startH && this.nextNadeH <= endH) {
                            deltaV = startV + (endV - startV) * ((this.nadeH - startH) / (endH - startH));
                            nextDeltaV = startV + (endV - startV) * ((this.nextNadeH - startH) / (endH - startH));
                            if (this.nadeV >= deltaV && this.nextNadeV <= nextDeltaV) {
                                ++this.rebounds;
                                if (this.rebounds < 5) {
                                    this.nadeV = deltaV + 0.1f;
                                    if (endV >= startV && this.direction == 1 || endV <= startV && this.direction == -1) {
                                        this.direction *= -1;
                                    }
                                    this.vSpeedNade = 0.1f;
                                } else {
                                    this.vSpeedNade = 0.0f;
                                    this.hSpeedNade = 0.0f;
                                }
                                return true;
                            }
                        }
                    }
                    ++col;
                }
            }
            return false;
        }

        private final synchronized void paint() {
            switch (this.state) {
                case 0: {
                    this.sprite.setTranslation(this.nadeP, this.nadeV, this.nadeH);
                    break;
                }
                case 1: {
                    this.spriteExplo[this.exploFrame].setTranslation(this.nadeP, this.nadeV, this.nadeH);
                    this.spriteExplo[this.exploFrame].setRenderingEnable(true);
                }
            }
        }

        public void restart(long _pauseDelay) {
            this.launchTime += _pauseDelay;
            this.lastCheckTime += _pauseDelay;
        }
    }
}

