/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PWScreenToolbox {
    private static PWScreenToolbox toolbox;
    private String pakManager_baseName = "resource";
    private int pakManager_numberOfPackages = 0;
    private int pakManager_files;
    public String[] pakManager_aFilename;
    private short[] pakManager_aPakNumber;
    private char[] pakManager_aBaseAddress;
    private char[] pakManager_aLength;
    private byte[][] pakManager_aCache;
    private boolean pakManager_initialized;
    private boolean allCached = false;

    public static PWScreenToolbox get() {
        if (toolbox == null) {
            toolbox = new PWScreenToolbox();
            toolbox.pakManager_load();
        }
        return toolbox;
    }

    public Image getDirectImage(String name) {
        byte[] data = this.pakManager_getResource(name);
        if (data == null) {
            // empty if block
        }
        return Image.createImage((byte[])data, (int)0, (int)data.length);
    }

    public byte[] getDirectResource(String name) {
        return this.pakManager_getResource(name);
    }

    public Image createARGBImage(int width, int height, int argbColor) {
        Image image = Image.createImage((int)width, (int)height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(argbColor);
        graphics.fillRect(0, 0, width, height);
        return image;
    }

    public Image createTransparentImage(int width, int height) {
        return this.createARGBImage(width, height, -16777216);
    }

    private void pakManager_load() {
        int j2;
        this.pakManager_files = 0;
        this.pakManager_aFilename = new String[200];
        this.pakManager_aPakNumber = new short[200];
        this.pakManager_aBaseAddress = new char[200];
        this.pakManager_aLength = new char[200];
        this.pakManager_aCache = new byte[200][];
        short i2 = 1;
        InputStream is = this.getClass().getResourceAsStream("/resource." + i2);
        while (is != null) {
            this.pakManager_numberOfPackages = i2;
            DataInputStream dis = new DataInputStream(is);
            while (this.pakManager_load(i2, dis)) {
            }
            try {
                dis.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            i2 = (short)(i2 + 1);
            is = this.getClass().getResourceAsStream("/resource." + i2);
        }
        boolean length = false;
        for (j2 = 0; j2 < this.pakManager_aFilename.length && this.pakManager_aFilename[j2] != null; ++j2) {
        }
        String[] aux_pakManager_aFilename = new String[j2];
        short[] aux_pakManager_aPakNumber = new short[j2];
        char[] aux_pakManager_aBaseAddress = new char[j2];
        char[] aux_pakManager_aLength = new char[j2];
        byte[][] aux_pakManager_aCache = new byte[j2][];
        for (int k2 = 0; k2 < aux_pakManager_aPakNumber.length; ++k2) {
            aux_pakManager_aPakNumber[k2] = this.pakManager_aPakNumber[k2];
            aux_pakManager_aBaseAddress[k2] = this.pakManager_aBaseAddress[k2];
            aux_pakManager_aLength[k2] = this.pakManager_aLength[k2];
        }
        this.pakManager_aPakNumber = aux_pakManager_aPakNumber;
        this.pakManager_aBaseAddress = aux_pakManager_aBaseAddress;
        this.pakManager_aLength = aux_pakManager_aLength;
        this.pakManager_initialized = true;
    }

    private boolean pakManager_load(short pakNumber, DataInputStream dis) {
        try {
            this.pakManager_aPakNumber[this.pakManager_files] = pakNumber;
            this.pakManager_aFilename[this.pakManager_files] = dis.readUTF();
            if (this.pakManager_aFilename[this.pakManager_files].equals("*EOF*")) {
                return false;
            }
            this.pakManager_aBaseAddress[this.pakManager_files] = dis.readChar();
            this.pakManager_aLength[this.pakManager_files] = dis.readChar();
            ++this.pakManager_files;
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public byte[] pakManager_getResource(String name) {
        int location = this.pakManager_locateResource(name);
        if (location == -1) {
            return null;
        }
        return this.pakManager_getResource(location);
    }

    public void addToCache(String name) {
        int location = this.pakManager_locateResource(name);
        if (location == -1) {
            return;
        }
        this.pakManager_aCache[location] = this.pakManager_getResource(location);
    }

    public void cacheAll() {
        if (this.allCached) {
            return;
        }
        this.cacheAll(new String[0]);
    }

    public void cache(String[] include) {
        int startPoint = 0;
        block2: for (int i2 = 1; i2 <= this.pakManager_numberOfPackages; ++i2) {
            DataInputStream d2 = new DataInputStream(this.getClass().getResourceAsStream("/resource." + i2));
            try {
                d2.skip(this.pakManager_aBaseAddress[startPoint]);
                for (int j2 = startPoint; j2 < this.pakManager_files; ++j2) {
                    if (this.pakManager_aFilename[j2].equals("*EOF*")) {
                        return;
                    }
                    if (this.pakManager_aPakNumber[j2] > i2) {
                        startPoint = j2;
                        continue block2;
                    }
                    byte[] result = new byte[this.pakManager_aLength[j2]];
                    int readed = d2.read(result);
                    while (readed < this.pakManager_aLength[j2]) {
                        d2.read(result, readed, readed - this.pakManager_aLength[j2]);
                    }
                    if (!this.arrayCompare(include, this.pakManager_aFilename[j2])) continue;
                    this.pakManager_aCache[j2] = result;
                }
                continue;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
        }
    }

    public void cacheAll(String[] exclude) {
        for (int i2 = 0; i2 < this.pakManager_files && !this.pakManager_aFilename[i2].equals("*EOF*"); ++i2) {
            this.pakManager_aCache[i2] = null;
        }
        int startPoint = 0;
        block3: for (int i3 = 1; i3 <= this.pakManager_numberOfPackages; ++i3) {
            DataInputStream d2 = new DataInputStream(this.getClass().getResourceAsStream("/resource." + i3));
            try {
                d2.skip(this.pakManager_aBaseAddress[startPoint]);
                for (int j2 = startPoint; j2 < this.pakManager_files; ++j2) {
                    if (this.pakManager_aFilename[j2].equals("*EOF*")) {
                        return;
                    }
                    if (this.pakManager_aPakNumber[j2] > i3) {
                        startPoint = j2;
                        continue block3;
                    }
                    byte[] result = new byte[this.pakManager_aLength[j2]];
                    int readed = d2.read(result);
                    while (readed < this.pakManager_aLength[j2]) {
                        d2.read(result, readed, readed - this.pakManager_aLength[j2]);
                    }
                    if (this.arrayCompare(exclude, this.pakManager_aFilename[j2])) continue;
                    this.pakManager_aCache[j2] = result;
                }
                continue;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
        }
        if (exclude.length == 0) {
            this.allCached = true;
        }
    }

    public void cleanCache(String[] list) {
        this.allCached = false;
        for (int i2 = 0; i2 < list.length; ++i2) {
            int number = this.pakManager_locateResource(list[i2]);
            if (number == -1) continue;
            this.pakManager_aCache[number] = null;
        }
    }

    public void cleanCache(String resource) {
        this.allCached = false;
        int number = this.pakManager_locateResource(resource);
        if (number != -1) {
            this.pakManager_aCache[number] = null;
        }
    }

    private boolean arrayCompare(String[] list, String search) {
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (!list[i2].equals(search)) continue;
            return true;
        }
        return false;
    }

    public int pakManager_locateResource(String name) {
        for (int i2 = 0; i2 < this.pakManager_files; ++i2) {
            if (this.pakManager_aFilename[i2] == null) {
                return -1;
            }
            if (!name.equals(this.pakManager_aFilename[i2])) continue;
            return i2;
        }
        return -1;
    }

    public byte[] pakManager_getResource(int location) {
        if (this.pakManager_aCache[location] != null) {
            return this.pakManager_aCache[location];
        }
        DataInputStream d2 = new DataInputStream(this.getClass().getResourceAsStream("/resource." + this.pakManager_aPakNumber[location]));
        byte[] result = new byte[this.pakManager_aLength[location]];
        try {
            d2.skip(this.pakManager_aBaseAddress[location]);
            for (int readed = d2.read(result); readed < this.pakManager_aLength[location]; readed += d2.read(result, readed, readed - this.pakManager_aLength[location])) {
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        return result;
    }

    public void cleanCache() {
        this.allCached = false;
        for (int i2 = 0; i2 < this.pakManager_files; ++i2) {
            if (this.pakManager_aFilename[i2] == null) {
                return;
            }
            this.pakManager_aCache[i2] = null;
        }
    }

    public Image getImage(String name) {
        byte[] data = this.pakManager_getResource(name);
        if (data == null) {
            // empty if block
        }
        return Image.createImage((byte[])data, (int)0, (int)data.length);
    }

    public byte[] getResource(String name) {
        return this.pakManager_getResource(name);
    }
}

