/*
 * Decompiled with CFR 0.152.
 */
package z.playw.DragonGuardian;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import z.playw.DragonGuardian.CMath;
import z.playw.DragonGuardian.GameActor;
import z.playw.DragonGuardian.GameBonus;
import z.playw.DragonGuardian.GameBullet;
import z.playw.DragonGuardian.GameEngine;
import z.playw.DragonGuardian.MainCanvas;
import z.playw.j2me.graphics.ColRect;

public class Player
extends GameActor {
    public static final byte STATUS_WAIT = 0;
    public static final byte STATUS_ATTACK = 1;
    public static final byte STATUS_SUPER_ATTACK_FIRE_STONE_STORM = 2;
    public static final byte STATUS_HURT = 3;
    public static final byte STATUS_EJECT = 4;
    public static final byte STATUS_CAUGHT = 5;
    public static final byte STATUS_DEAD = 6;
    public static final byte STATUS_REVIVAL = 7;
    public static final byte SUB_STATUS_NORMAL = 0;
    public static final byte SUB_STATUS_ATTRACT_BY_BOSS_THREE_HEAD = 1;
    public static final byte SUB_STATUS_EJECTING_RIGHT = 2;
    public static final byte SUB_STATUS_EJECTED_RIGHT = 3;
    public static final byte SUB_STATUS_EJECTING_TOP = 4;
    public static final byte SUB_STATUS_EJECTED_TOP = 5;
    private int playerLife = 216;
    private int playerMagicDamage = 8;
    private int playerDefenceClose = 12;
    private int playerDefenceFarAway = 6;
    private int playerFlySpeed = 7;
    private int playerLeanFlySpeed = 5;
    private int playerSpirit = 3;
    private static int totalKilledEnemy = 0;
    private static int deadCount = 0;
    private static int maxContinuousHits = 0;
    private static long totalPlayedTime = 0L;
    private static int bulletLevel = 0;
    private boolean addBullet = true;
    private int lastEffectX = 0;
    private int continuousHits = 0;
    private long lastHitTime = 0L;
    private int attackAnim = 0;
    private long invincibleTime = 0L;
    private int mana = 0;
    private long manaRestoreTime = 0L;
    private long renderPowerUpTime;

    public int getSuperAttackDamage() {
        return 200 + this.playerMagicDamage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(long gameTime, GameActor[] actorPool, GameEngine gameEngine) {
        if (this.isStopProcessing()) {
            if (gameTime - GameActor.stopProcessingTime > (long)(80 * GameActor.playerHitLevel)) {
                this.setGlobalStopProcessing(false, gameTime);
                MainCanvas.getGameEngine().setShakeScreen(false);
            }
            this.stateStartTime += MainCanvas.getGameEngine().getCurFrameTime();
            return;
        }
        if (this.manaRestoreTime > 5000L) {
            this.setMana(this.getMana() + this.playerSpirit);
            if (this.getMana() > 100) {
                this.setMana(100);
            }
            this.manaRestoreTime = 0L;
        } else {
            this.manaRestoreTime += MainCanvas.getGameEngine().getCurFrameTime();
        }
        if (this.getInvincibleTime() > 0L) {
            long newTime = this.getInvincibleTime() - gameEngine.getCurFrameTime();
            this.setInvincibleTime(newTime > 0L ? newTime : 0L);
        }
        switch (this.getState()) {
            case 0: {
                this.processWait(gameTime, gameEngine);
                break;
            }
            case 5: {
                if (GameEngine.keyReleased != 512 || this.getRelatePlayer() == null) break;
                this.getRelatePlayer().setPowerNewton(this.getRelatePlayer().getPowerNewton() + -10);
                break;
            }
            case 1: {
                this.processAttack(gameTime, actorPool);
                break;
            }
            case 6: {
                this.x += this.vx;
                this.y += this.vy;
                this.vy += this.ay;
                break;
            }
            case 7: {
                this.setX(this.getX() + 3);
                break;
            }
            case 3: {
                this.processKey(gameTime);
                if (this.isAnimationOver(gameTime)) {
                    this.setX(this.getX() - 14);
                    this.setState((byte)0, gameTime);
                    break;
                }
                if (this.getColRect(gameTime, 0) == null) break;
                break;
            }
            case 4: {
                if (this.getSubType() == 2) {
                    if (this.canMove(gameTime, -28, 0)) {
                        this.setX(this.getX() - 28);
                        break;
                    }
                    this.setSubType(3);
                    break;
                }
                if (this.getSubType() == 4) {
                    if (this.canMove(gameTime, 0, 28)) {
                        this.setY(this.getY() + 28);
                        break;
                    }
                    this.setSubType(5);
                    break;
                }
                if (this.getSubType() == 3) {
                    if (this.getX() < 28) {
                        MainCanvas.getGameEngine().setShakeScreen(true);
                        if (this.canMove(gameTime, 7, 0)) {
                            this.setX(this.getX() + 7);
                            break;
                        }
                        MainCanvas.getGameEngine().setShakeScreen(false);
                        this.setState((byte)0, gameTime);
                        break;
                    }
                    MainCanvas.getGameEngine().setShakeScreen(false);
                    this.setState((byte)0, gameTime);
                    break;
                }
                if (this.getSubType() != 5) break;
                if (this.getY() > 452) {
                    MainCanvas.getGameEngine().setShakeScreen(true);
                    if (this.canMove(gameTime, 0, -7)) {
                        this.setY(this.getY() - 7);
                        break;
                    }
                    MainCanvas.getGameEngine().setShakeScreen(false);
                    this.setState((byte)0, gameTime);
                    break;
                }
                MainCanvas.getGameEngine().setShakeScreen(false);
                this.setState((byte)0, gameTime);
                break;
            }
            case 2: {
                this.processFireStoneStorm(gameTime, gameEngine);
            }
        }
        if (this.getContinuousHits() > 0 && gameTime - this.getLastHitTime() > 2000L) {
            this.setContinuousHits(0);
            this.setLastHitTime(0L);
        }
        if (this.getSubType() != 1) return;
        ColRect crBoss = null;
        GameActor boss = null;
        int i2 = 0;
        while (true) {
            if (i2 >= GameEngine.actorPool.length) break;
            if (GameEngine.actorPool[i2] != null) {
                if (GameEngine.actorPool[i2].inUse()) {
                    if (GameEngine.actorPool[i2].getSubType() == 4) {
                        boss = GameEngine.actorPool[i2];
                        crBoss = GameEngine.actorPool[i2].getColRect(gameTime, 3);
                        break;
                    }
                }
            }
            ++i2;
        }
        if (crBoss != null) {
            ColRect crSelf = this.getColRect(gameTime, 0);
            if (!this.moveToArea(crBoss.x + (crBoss.w >> 1) + boss.getX(), crBoss.y + boss.getY() + (crSelf.h >> 1), 7, crBoss.w, crBoss.h, true, gameTime, false)) return;
        }
        this.setSubType(0);
    }

    private void invokeEndSuperAttack(long gameTime, int type) {
        GameEngine gameEngine = MainCanvas.getGameEngine();
        int i2 = 0;
        while (true) {
            if (i2 >= GameEngine.actorPool.length) break;
            if (GameEngine.actorPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.actorPool[i2].inUse()) {
                    GameEngine.actorPool[i2].endNotify(gameTime, type);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (true) {
            if (i2 >= GameEngine.bonusPool.length) break;
            if (GameEngine.bonusPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.bonusPool[i2].inUse()) {
                    GameEngine.bonusPool[i2].endNotify(gameTime, type);
                }
            }
            ++i2;
        }
    }

    private void processFireStoneStorm(long gameTime, GameEngine gameEngine) {
        block8: {
            block9: {
                block7: {
                    if (this.animID != 9) break block7;
                    if (!this.isAnimationOver(gameTime)) break block8;
                    MainCanvas.getGameEngine().setDarkScreen(false);
                    MainCanvas.getGameEngine().setShakeScreen(true);
                    this.setRenderContent(++this.animID, false, gameTime);
                    break block8;
                }
                if (!this.isAnimationOver(gameTime)) break block9;
                boolean superAttackEnd = true;
                int bulletIndex = 0;
                while (true) {
                    if (bulletIndex >= GameEngine.bulletPool.length) break;
                    if (GameEngine.bulletPool[bulletIndex] != null) {
                        if (GameEngine.bulletPool[bulletIndex].inUse()) {
                            if (GameEngine.bulletPool[bulletIndex].getSubType() == 11) {
                                superAttackEnd = false;
                                break;
                            }
                        }
                    }
                    ++bulletIndex;
                }
                if (!superAttackEnd) break block8;
                this.setState((byte)0, gameTime);
                this.invokeEndSuperAttack(gameTime, 0);
                break block8;
            }
            int i2 = 0;
            GameActor[] bulletPool = GameEngine.getBulletPool();
            if (i2 >= bulletPool.length || bulletPool[i2] != null && bulletPool[i2].inUse() && bulletPool[i2].getSubType() == 11) break block8;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            bulletPool[i2].setAnimation(gameEngine.superAttackFireStoneStormPif);
            bulletPool[i2].init(gameTime, 0);
            bulletPool[i2].setSubType(11);
            bulletPool[i2].setRenderContent(0, true, gameTime);
            ColRect rcFireStorm = bulletPool[i2].getColRect(gameTime, 0);
            int totalWidth = rcFireStorm.x + rcFireStorm.w + 90;
            int totalHeight = rcFireStorm.y + rcFireStorm.h + 222;
            int posX = 0;
            int posY = 0;
            if (totalWidth < totalHeight) {
                posX = -rcFireStorm.x - rcFireStorm.w;
                posY = 258 - (90 - posX);
            } else {
                posY = -rcFireStorm.y - rcFireStorm.h;
                posX = 90 - (222 - posY);
            }
            bulletPool[i2].setX(posX);
            bulletPool[i2].setY(posY);
            bulletPool[i2].setVx(8);
            bulletPool[i2].setVy(bulletPool[i2].getVx());
        }
    }

    private void processAttack(long gameTime, GameActor[] actorPool) {
        if (this.isAnimationOver(gameTime)) {
            if (this.attackAnim > this.animID) {
                if (this.attackAnim == 7) {
                    MainCanvas.getGameEngine().setDarkScreen(true);
                }
                this.setRenderContent(this.attackAnim, false, gameTime);
            } else {
                MainCanvas.getGameEngine().setDarkScreen(false);
                this.setState((byte)0, gameTime);
            }
        } else if (GameEngine.keyReleased == 512 && this.attackAnim < 7) {
            this.attackAnim = this.animID + 1;
        }
        boolean hitEnemy = false;
        int hitLevel = 0;
        for (int i2 = 0; i2 < actorPool.length; ++i2) {
            if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2].getType() != 1) continue;
            if (actorPool[i2].getSubType() == 4) {
                Vector col_rects = actorPool[i2].getAnimation().GetColRects(actorPool[i2].animID, gameTime, actorPool[i2].animCyclic);
                ColRect crSelf = new ColRect();
                ColRect crOther = new ColRect();
                crSelf.Copy(this.getX(), this.getY(), this.getColRect(gameTime, 3));
                for (int index = 0; index < col_rects.size(); ++index) {
                    ColRect cr = (ColRect)col_rects.elementAt(index);
                    if (0 != cr.GetVal()) continue;
                    crOther.Copy(actorPool[i2].getX(), actorPool[i2].getY(), cr);
                    if (!ColRect.RectIntersect(crOther, crSelf)) continue;
                    hitEnemy = true;
                    hitLevel = this.animID - 4;
                    int damage = this.getPlayerATS(hitLevel);
                    actorPool[i2].reduceLife(damage, 1 + hitLevel, cr, gameTime);
                    if (hitLevel == 3) {
                        hitLevel = 4;
                    }
                    if (gameTime - GameActor.stopProcessingTime <= 1000L && GameActor.playerHitLevel == hitLevel + 1) break;
                    actorPool[i2].setStopProcessing(true, gameTime);
                    this.setStopProcessing(true, gameTime);
                    MainCanvas.getGameEngine().setShakeScreen(true);
                    GameActor.playerHitLevel = hitLevel + 1;
                    break;
                }
                crSelf = null;
                crOther = null;
                continue;
            }
            if (!this.isCollide(gameTime, actorPool[i2], 3, 0)) continue;
            hitEnemy = true;
            hitLevel = this.animID - 4;
            int damage = this.getPlayerATS(hitLevel);
            actorPool[i2].reduceLife(damage, 1 + hitLevel, this.getIntersectRect(gameTime, actorPool[i2], 3, 0), gameTime);
            if (hitLevel == 3) {
                hitLevel = 4;
            }
            if (gameTime - GameActor.stopProcessingTime <= 1000L && GameActor.playerHitLevel == hitLevel + 1) continue;
            actorPool[i2].setStopProcessing(true, gameTime);
            this.setStopProcessing(true, gameTime);
            MainCanvas.getGameEngine().setShakeScreen(true);
            GameActor.playerHitLevel = hitLevel + 1;
        }
        if (hitEnemy && gameTime - this.getLastHitTime() > 500L) {
            this.setLastHitTime(gameTime);
            this.increaseContinuousHits();
        }
        if (this.getColRect(gameTime, 3) != null && this.canMove(gameTime, 2, 0)) {
            this.setX(this.getX() + 2);
        }
        if (this.processKey(gameTime)) {
            this.setState((byte)0, gameTime);
        }
    }

    public int getPlayerATS(int hitLevel) {
        return MainCanvas.weaponDamageValue[0][hitLevel];
    }

    public int getPlayerATL() {
        return 6;
    }

    public void setGlobalStopProcessing(boolean stop, long gameTime) {
        int i2 = 0;
        while (true) {
            MainCanvas.getGameEngine();
            if (i2 >= GameEngine.actorPool.length) break;
            MainCanvas.getGameEngine();
            if (GameEngine.actorPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.actorPool[i2].inUse()) {
                    MainCanvas.getGameEngine();
                    GameEngine.actorPool[i2].setStopProcessing(stop, gameTime);
                }
            }
            ++i2;
        }
    }

    private GameActor getABullet(long gameTime, ColRect bulletRect) {
        GameActor[] bulletPool = GameEngine.getBulletPool();
        for (int i2 = 0; i2 < bulletPool.length; ++i2) {
            if (bulletPool[i2] != null && bulletPool[i2].inUse()) continue;
            if (bulletPool[i2] == null) {
                bulletPool[i2] = new GameBullet();
            }
            return bulletPool[i2];
        }
        return null;
    }

    private void processWait(long gameTime, GameEngine gameEngine) {
        if (GameEngine.curKey == 256 || GameEngine.curKey == 32 || GameEngine.curKey == 2048) {
            if (this.animID != 2 && this.animID != 1) {
                this.setRenderContent(1, false, gameTime);
            } else if (this.animID == 1 && this.isAnimationOver(gameTime)) {
                this.setRenderContent(2, true, gameTime);
            }
        } else if (this.animID != 3) {
            this.setRenderContent(3, true, gameTime);
        }
        this.processKey(gameTime);
        ColRect bulletRect = this.getColRect(gameTime, 1);
        if (bulletRect != null) {
            if (this.addBullet) {
                GameActor bullet2;
                if (Player.getBulletLevel() == 0) {
                    bullet2 = this.getABullet(gameTime, bulletRect);
                    this.adjustBullet(gameTime, bulletRect, bullet2, 0);
                } else if (Player.getBulletLevel() == 1) {
                    bullet2 = this.getABullet(gameTime, bulletRect);
                    this.adjustBullet(gameTime, bulletRect, bullet2, 1);
                }
                if (Player.getBulletLevel() == 2) {
                    for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                        GameActor bullet3 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet3, 2 + bulletCount);
                        if (bulletCount == 0) {
                            bullet3.setVx(8);
                            bullet3.setVy(-4);
                            continue;
                        }
                        if (bulletCount != 2) continue;
                        bullet3.setVx(8);
                        bullet3.setVy(4);
                    }
                } else if (Player.getBulletLevel() == 3) {
                    for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                        GameActor bullet4 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet4, 5 + bulletCount);
                        if (bulletCount == 0) {
                            bullet4.setVx(8);
                            bullet4.setVy(-4);
                            continue;
                        }
                        if (bulletCount != 2) continue;
                        bullet4.setVx(8);
                        bullet4.setVy(4);
                    }
                } else if (Player.getBulletLevel() == 4) {
                    for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                        GameActor bullet5 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet5, 8 + bulletCount);
                        if (bulletCount == 0) {
                            bullet5.setVx(8);
                            bullet5.setVy(-4);
                            continue;
                        }
                        if (bulletCount != 2) continue;
                        bullet5.setVx(8);
                        bullet5.setVy(4);
                    }
                }
                this.addBullet = false;
            }
        } else {
            this.addBullet = true;
        }
    }

    private void adjustBullet(long gameTime, ColRect bulletRect, GameActor bullet2, int subType) {
        bullet2.setAnimation(MainCanvas.getGameEngine().bulletPif);
        bullet2.init(gameTime, 0);
        bullet2.setSubType(subType);
        bullet2.setState((byte)0, gameTime);
        bullet2.setX(this.getX() + bulletRect.x + (bulletRect.w >> 1));
        bullet2.setY(this.getY() + bulletRect.y + (bulletRect.h >> 1));
        bullet2.setVx(10);
        bullet2.setVy(0);
    }

    private boolean canMove(long gameTime, int offsetX, int offsetY) {
        GameEngine engine = MainCanvas.getGameEngine();
        boolean ret = true;
        ColRect crHero = this.getColRect(gameTime, 0);
        if (this.getX() - (crHero.w >> 1) <= 0 && offsetX < 0 || this.getX() + (crHero.w >> 1) >= 360 && offsetX > 0 || this.getY() - crHero.h <= 36 && offsetY < 0 || this.getY() >= 480 && offsetY > 0) {
            ret = false;
        }
        return ret;
    }

    private boolean processKey(long gameTime) {
        boolean ret = false;
        switch (GameEngine.curKey) {
            case 256: {
                if (!this.canMove(gameTime, -this.playerFlySpeed, 0)) break;
                this.setX(this.getX() - this.playerFlySpeed);
                ret = true;
                break;
            }
            case 1024: {
                if (!this.canMove(gameTime, this.playerFlySpeed, 0)) break;
                this.setX(this.getX() + this.playerFlySpeed);
                ret = true;
                break;
            }
            case 64: {
                if (!this.canMove(gameTime, 0, -this.playerFlySpeed)) break;
                this.setY(this.getY() - this.playerFlySpeed);
                ret = true;
                break;
            }
            case 4096: {
                if (!this.canMove(gameTime, 0, this.playerFlySpeed)) break;
                this.setY(this.getY() + this.playerFlySpeed);
                ret = true;
                break;
            }
            case 128: {
                if (!this.canMove(gameTime, this.playerLeanFlySpeed, -this.playerLeanFlySpeed)) break;
                this.setX(this.getX() + this.playerLeanFlySpeed);
                this.setY(this.getY() - this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 8192: {
                if (!this.canMove(gameTime, this.playerLeanFlySpeed, this.playerLeanFlySpeed)) break;
                this.setX(this.getX() + this.playerLeanFlySpeed);
                this.setY(this.getY() + this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 32: {
                if (!this.canMove(gameTime, -this.playerLeanFlySpeed, -this.playerLeanFlySpeed)) break;
                this.setX(this.getX() - this.playerLeanFlySpeed);
                this.setY(this.getY() - this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 2048: {
                if (!this.canMove(gameTime, -this.playerLeanFlySpeed, this.playerLeanFlySpeed)) break;
                this.setX(this.getX() - this.playerLeanFlySpeed);
                this.setY(this.getY() + this.playerLeanFlySpeed);
                ret = true;
                break;
            }
            case 32768: {
                if (this.getMana() >= 30) {
                    this.setState((byte)2, gameTime);
                    this.setMana(this.getMana() - 30);
                }
                ret = false;
                GameEngine.clearKey();
            }
        }
        if (GameEngine.keyReleased == 512 && this.getState() != 3 && this.getState() != 1) {
            this.setState((byte)1, gameTime);
            ret = false;
        }
        return ret;
    }

    public void setState(byte newState, long time) {
        MainCanvas.getGameEngine().setDarkScreen(false);
        MainCanvas.getGameEngine().setShakeScreen(false);
        switch (newState) {
            case 0: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
                break;
            }
            case 5: {
                super.setState(newState, time);
                this.setRenderContent(15, true, time);
                break;
            }
            case 1: {
                if (this.animID >= 4 && this.animID <= 7) break;
                this.lastEffectX = 0;
                this.attackAnim = 4;
                super.setState(newState, time);
                this.setRenderContent(this.attackAnim, false, time);
                break;
            }
            case 2: {
                this.setSubType(0);
                super.setState(newState, time);
                this.setRenderContent(9, false, time);
                MainCanvas.getGameEngine().setDarkScreen(true);
                MainCanvas.getGameEngine().resetBulletPool();
                this.invokeBeginSuperAttack(time, 0);
                break;
            }
            case 3: {
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                this.setX(this.getX() - 7);
                break;
            }
            case 6: {
                if (this.isPlayerDead()) break;
                this.setRelatePlayer(null);
                this.invokeBeginSuperAttack(time, 6);
                MainCanvas.getGameEngine().setStopScrollBG(true);
                GameBonus bonus2 = (GameBonus)this.getABonus();
                bonus2.init(time, 0);
                ColRect rect = this.getColRect(time, 0);
                bonus2.setX(this.getX() + (rect.w >> 1));
                bonus2.setY(this.getY() - (rect.h >> 1));
                super.setState(newState, time);
                this.setRenderContent(8, false, time);
                this.vx = this.x - this.lastX >> 2;
                this.vy = this.y - this.lastY;
                if (this.vy > -CMath.I2F(1) >> 1) {
                    this.vy = -CMath.I2F(1) >> 1;
                }
                this.ax = 0;
                this.ay = CMath.I2F(1) >> 1;
                break;
            }
            case 7: {
                this.init(time, this.type);
                ColRect crHero = this.getColRect(time, 0);
                super.setState(newState, time);
                this.setX(-crHero.w);
                this.setY(369);
                break;
            }
            case 4: {
                super.setState(newState, time);
                this.setRenderContent(15, true, time);
                break;
            }
            default: {
                super.setState(newState, time);
                this.setRenderContent(3, true, time);
            }
        }
    }

    private void invokeBeginSuperAttack(long time, int type) {
        int i2 = 0;
        while (true) {
            MainCanvas.getGameEngine();
            if (i2 >= GameEngine.actorPool.length) break;
            MainCanvas.getGameEngine();
            if (GameEngine.actorPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.actorPool[i2].inUse()) {
                    MainCanvas.getGameEngine();
                    GameEngine.actorPool[i2].beginNotify(time, type);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (true) {
            MainCanvas.getGameEngine();
            if (i2 >= GameEngine.bonusPool.length) break;
            MainCanvas.getGameEngine();
            if (GameEngine.bonusPool[i2] != null) {
                MainCanvas.getGameEngine();
                if (GameEngine.bonusPool[i2].inUse()) {
                    MainCanvas.getGameEngine();
                    GameEngine.bonusPool[i2].beginNotify(time, type);
                }
            }
            ++i2;
        }
    }

    public void init(long gameTime, int type) {
        this.playerLife = 216;
        this.playerMagicDamage = 8;
        this.playerDefenceClose = 12;
        this.playerDefenceFarAway = 6;
        this.playerFlySpeed = 7;
        this.playerLeanFlySpeed = 5;
        this.playerSpirit = 3;
        if (!this.isPlayerDead()) {
            Player.setKilledEnemy(0);
            Player.setDeadCount(0);
            Player.setMaxContinuousHits(0);
            Player.setTotalPlayedTime(0L);
        } else {
            Player.setBulletLevel(0);
        }
        this.stopProcessing = false;
        GameActor.stopProcessingTime = 0L;
        GameActor.playerHitLevel = 0;
        this.manaRestoreTime = 0L;
        this.setRenderPowerUpTime(0L);
        this.setInvincibleTime(0L);
        this.setLife(this.playerLife);
        this.setMaxlife(this.getLife());
        this.setMana(100);
        this.setX(180);
        this.setY(369);
        this.setRelatePlayer(null);
        if (!this.isPlayerDead() && MainCanvas.indexOfLevel == 6) {
            this.setLife(MainCanvas.getGameEngine().mainCanvas.playerLife);
            this.setMana(MainCanvas.getGameEngine().mainCanvas.playerMana);
        }
        this.setSubType(0);
        this.setState((byte)0, gameTime);
        this.setInUse(true);
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
        if (this.getLife() <= 0 || this.getInvincibleTime() > 0L || this.isPlayerDead()) {
            return;
        }
        this.setContinuousHits(0);
        this.setLastHitTime(0L);
        if (reducePoint > 1) {
            reducePoint = type == 0 ? (reducePoint -= this.playerDefenceFarAway) : (reducePoint -= this.playerDefenceClose);
            if (reducePoint < 1) {
                reducePoint = 1;
            }
        }
        if (this.getInvincibleTime() <= 0L) {
            this.setLife(this.getLife() - reducePoint);
        }
        if (this.getLife() <= 0) {
            this.setLife(0);
            this.setState((byte)6, gametime);
        } else if ((type == 6 || type == 7 || type == 8) && this.getRelatePlayer() == null) {
            if (this.getState() != 4) {
                this.setState((byte)4, gametime);
                this.setSubType(2);
            }
            if (type == 8) {
                this.setSubType(4);
            } else {
                this.setSubType(2);
            }
        } else if (type == 10) {
            if (this.getState() != 4) {
                this.setState((byte)4, gametime);
            }
            this.setSubType(4);
        } else if (this.getState() != 5 && this.getState() != 3) {
            this.setState((byte)3, gametime);
        }
    }

    public void beginNotify(long gameTime, int type) {
        if (type == 2 && this.getState() != 4) {
            this.setSubType(1);
        }
        if (this.getLife() > 0 && (type == 7 || type == 8 || type == 9)) {
            this.setState((byte)5, gameTime);
        }
        if (type == 0 || type == 3 || type == 4 || type == 5 || type == 1) {
            MainCanvas.getGameEngine().setStopScrollBG(true);
            if (this.getContinuousHits() > 0) {
                this.setLastHitTime(gameTime);
            }
        }
    }

    public void endNotify(long gameTime, int type) {
        if (type != 7) {
            if (type == 8 || type == 9 && !this.isPlayerDead()) {
                this.setState((byte)0, gameTime);
            }
            if (type != 2) {
                this.setSubType(0);
            }
            MainCanvas.getGameEngine().setShakeScreen(false);
        }
        MainCanvas.getGameEngine().setStopScrollBG(false);
    }

    public void renderGameActor(Graphics g2, long gameTime) {
        if (this.getRelatePlayer() != null) {
            return;
        }
        if (this.getInvincibleTime() > 0L && gameTime % 3L > 1L) {
            return;
        }
        super.renderGameActor(g2, gameTime);
        MainCanvas.getGameEngine().playerWeaponPif.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
        MainCanvas.getGameEngine().playerBladeShadowPif.drawAnimation(g2, this.animID, gameTime - this.stateStartTime, this.getX(), this.getY(), this.animCyclic);
    }

    public int getContinuousHits() {
        return this.continuousHits;
    }

    public void setContinuousHits(int continuousHits2) {
        this.continuousHits = continuousHits2;
    }

    public void increaseContinuousHits() {
        ++this.continuousHits;
        if (this.continuousHits > Player.getMaxContinuousHits()) {
            Player.setMaxContinuousHits(this.continuousHits);
        }
    }

    public boolean isPlayerDead() {
        return this.getState() >= 6;
    }

    public void adjustPosition(long time, GameActor[] actorPool) {
        ColRect crHero = this.getColRect(time, 0);
        if (!this.isPlayerDead() && this.getState() != 5) {
            for (int i2 = 0; i2 < actorPool.length; ++i2) {
                if (actorPool[i2] == null || !actorPool[i2].inUse() || actorPool[i2] == this || !this.isCollide(time, actorPool[i2], 0, 0)) continue;
                this.setX(this.getX() - this.playerFlySpeed);
            }
            if (this.getX() - (crHero.w >> 1) < 0) {
                this.setX(0 + (crHero.w >> 1));
            } else if (this.getX() + (crHero.w >> 1) > 360) {
                this.setX(360 - (crHero.w >> 1));
            }
            if (this.getY() - crHero.h < 36) {
                this.setY(36 + crHero.h);
            } else if (this.getY() > 480) {
                this.setY(480);
            }
        } else if (this.getState() == 6) {
            boolean outOfScren = false;
            if (this.getX() + (crHero.w >> 1) < 0) {
                outOfScren = true;
            } else if (this.getX() - (crHero.w >> 1) > 360) {
                outOfScren = true;
            }
            if (this.getY() < 36) {
                outOfScren = true;
            } else if (this.getY() - crHero.h > 480) {
                outOfScren = true;
            }
            if (outOfScren) {
                MainCanvas.getGameEngine().mainCanvas.pauseGame();
            }
        } else if (this.getState() == 7) {
            boolean outOfScreen = false;
            if (this.getX() + (crHero.w >> 1) < 0) {
                outOfScreen = true;
            } else if (this.getX() - (crHero.w >> 1) > 360) {
                outOfScreen = true;
            }
            if (this.getY() < 36) {
                outOfScreen = true;
            } else if (this.getY() - crHero.h > 480) {
                outOfScreen = true;
            }
            if (!outOfScreen) {
                this.invokeEndSuperAttack(time, 6);
                MainCanvas.getGameEngine().setStopScrollBG(false);
                this.setState((byte)0, time);
                this.setInvincibleTime(3000L);
            }
        }
    }

    public static final int getKilledEnemy() {
        return totalKilledEnemy;
    }

    public static final void setKilledEnemy(int killedEnemy) {
        totalKilledEnemy = killedEnemy > 9999 ? 9999 : killedEnemy;
    }

    public void increaseKilledEnemy(int experience) {
        ++totalKilledEnemy;
    }

    public void setLastHitTime(long lastHitTime) {
        this.lastHitTime = lastHitTime;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public static final void setBulletLevel(int bulletLevelPara) {
        bulletLevel = bulletLevelPara;
    }

    public void increaseBulletLevel(long gameTime) {
        this.setRenderPowerUpTime(gameTime);
        if (bulletLevel < 4) {
            ++bulletLevel;
        }
    }

    public static final int getBulletLevel() {
        return bulletLevel;
    }

    private void setRenderPowerUpTime(long renderPowerUpTime) {
        this.renderPowerUpTime = renderPowerUpTime;
    }

    private long getRenderPowerUpTime() {
        return this.renderPowerUpTime;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    public int getMana() {
        return this.mana;
    }

    public static final void setDeadCount(int deadCount) {
        Player.deadCount = deadCount;
    }

    public static final int getDeadCount() {
        return deadCount;
    }

    public static final void increaseDeadCount() {
        ++deadCount;
    }

    public static final void setMaxContinuousHits(int maxContinuousHits) {
        Player.maxContinuousHits = maxContinuousHits;
    }

    public static final int getMaxContinuousHits() {
        return maxContinuousHits;
    }

    public static final void setTotalPlayedTime(long totalPlayedTime) {
        Player.totalPlayedTime = totalPlayedTime;
    }

    public static final long getTotalPlayedTime() {
        return totalPlayedTime;
    }

    public static final void increaseTotalTime(long time) {
        totalPlayedTime += time;
    }

    public void setInvincibleTime(long invincibleTime) {
        this.invincibleTime = invincibleTime;
    }

    public long getInvincibleTime() {
        return this.invincibleTime;
    }
}

