/*
 * Decompiled with CFR 0.152.
 */
package com.ea.cnc;

import com.ea.cnc.AniSprite;
import com.ea.cnc.CGlobals;
import com.ea.cnc.GameConfig;
import com.ea.cnc.GameImpl;
import com.ea.cnc.Targetable;
import com.ea.cnc.Team;
import com.ea.cnc.Unit;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Projectile {
    private static final int STATE_SLOT_NOT_USED = 0;
    private static final int STATE_FLYING = 1;
    private static final int STATE_BLOWING = 2;
    private static final int STATE_BLOWING_AFTER_DAMAGE = 3;
    public static final int TYPE_LASER = 1;
    private static final int SPEED_LASER = 156;
    private static final int DAMAGE_LASER = 5;
    private static final int SIZE_LASER = 20;
    public static final int TYPE_GRENADE = 2;
    private static final int SPEED_GRENADE = 48;
    private static final int DAMAGE_GRENADE = 5;
    private static final int SPLASH_GRENADE = 16;
    private static final int SIZE_GRENADE = 3;
    public static final int TYPE_ROCKET = 3;
    private static final int SPEED_ROCKET = 64;
    private static final int DAMAGE_ROCKET = 20;
    private static final int SPLASH_ROCKET = 32;
    private static final int SIZE_ROCKET = 5;
    private static Projectile[] pool;
    public static AniSprite muzzleFlashAnimation;
    public static Image muzzleFlashImageGDI;
    public static Image muzzleFlashImageNOD;
    public static AniSprite blowingAnimation;
    public static Image blowingImage;
    private int type;
    private int state;
    private long initTime;
    private int sx;
    private int sy;
    private int x;
    private int y;
    private int z;
    private int tx;
    private int ty;
    private int speedx;
    private int speedy;
    private int speedz;
    private int accelz;
    private int speed;
    private int size;
    private int damage;
    private int distance_to_go;
    private int currentFrame;
    private Targetable target;
    private int[] history_x;
    private int[] history_y;
    private int[] history_z;
    private int history_len;

    Projectile() {
    }

    static void initProjectiles() {
        pool = new Projectile[30];
        for (int i = 0; i < 30; ++i) {
            Projectile.pool[i] = new Projectile();
            Projectile.pool[i].state = 0;
        }
    }

    static void clearProjectiles() {
        pool = null;
    }

    static void drawAll(Graphics graphics) {
        for (int i = 0; i < 30; ++i) {
            Projectile projectile = pool[i];
            if (projectile.state == 0) continue;
            projectile.draw(graphics);
        }
    }

    static void updateAll(long l) {
        for (int i = 0; i < 30; ++i) {
            Projectile projectile = pool[i];
            if (projectile.state == 0) continue;
            projectile.update(l);
        }
    }

    public static void attemptToCreateProjectile(int n, int n2, long l, Targetable targetable, Targetable targetable2) {
        Projectile.attemptToCreateProjectile(n, n2, l, targetable, targetable2, 0);
    }

    public static void attemptToCreateProjectile(int n, int n2, long l, Targetable targetable, Targetable targetable2, int n3) {
        for (int i = 0; i < 30; ++i) {
            if (Projectile.pool[i].state != 0) continue;
            Projectile.pool[i].state = 1;
            Projectile.pool[i].target = targetable2;
            Projectile.pool[i].type = n;
            Projectile.pool[i].damage = n2;
            switch (n) {
                case 1: {
                    Projectile.pool[i].speed = 156;
                    Projectile.pool[i].size = 20;
                    break;
                }
                case 2: {
                    Projectile.pool[i].speed = 48;
                    Projectile.pool[i].size = 3;
                    break;
                }
                case 3: {
                    Projectile.pool[i].speed = 64;
                    Projectile.pool[i].size = 5;
                }
            }
            Projectile.pool[i].damage += Projectile.pool[i].damage * n3 / 100;
            Projectile.pool[i].currentFrame = 0;
            Projectile.pool[i].initTime = l;
            if (Projectile.pool[i].type == 2 || Projectile.pool[i].type == 3) {
                Projectile.pool[i].history_x = new int[8];
                Projectile.pool[i].history_y = new int[8];
                Projectile.pool[i].history_z = new int[8];
                Projectile.pool[i].history_len = 0;
            }
            Projectile.pool[i].sx = targetable.getBulletPositionX();
            Projectile.pool[i].sy = targetable.getBulletPositionY();
            Projectile.pool[i].x = Projectile.pool[i].sx;
            Projectile.pool[i].y = Projectile.pool[i].sy;
            Projectile.pool[i].tx = targetable2.getTargetPointX();
            Projectile.pool[i].ty = targetable2.getTargetPointY();
            int n4 = Projectile.pool[i].tx - Projectile.pool[i].sx;
            int n5 = Projectile.pool[i].ty - Projectile.pool[i].sy;
            int n6 = CGlobals.distance(n4, n5);
            if (n4 == 0 && n5 == 0) {
                Projectile.pool[i].state = 2;
                return;
            }
            if (Projectile.pool[i].tx == Projectile.pool[i].sx) {
                Projectile.pool[i].speedx = 0;
                int n7 = 1;
                if (Projectile.pool[i].ty < Projectile.pool[i].sy) {
                    n7 = -1;
                }
                Projectile.pool[i].speedy = Projectile.pool[i].speed * n7;
            } else if (Projectile.pool[i].ty == Projectile.pool[i].sy) {
                Projectile.pool[i].speedy = 0;
                int n8 = 1;
                if (Projectile.pool[i].tx < Projectile.pool[i].sx) {
                    n8 = -1;
                }
                Projectile.pool[i].speedx = Projectile.pool[i].speed * n8;
            } else {
                Projectile.pool[i].speedx = Projectile.pool[i].speed * n4 / n6;
                Projectile.pool[i].speedy = Projectile.pool[i].speed * n5 / n6;
            }
            if (Projectile.pool[i].type == 2) {
                Projectile.pool[i].z = 1;
                Projectile.pool[i].speedz = 40;
                Projectile.pool[i].accelz = -7;
            }
            Projectile.pool[i].distance_to_go = n6 - Projectile.pool[i].size;
            return;
        }
    }

    private void update(long l) {
        switch (this.state) {
            case 1: {
                int n = (int)(l - this.initTime);
                if (this.type != 2 && n * this.speed / 1000 >= this.distance_to_go) {
                    this.state = 2;
                    this.currentFrame = 0;
                    this.initTime = l;
                    break;
                }
                if (this.type == 2 && this.z <= 0) {
                    this.state = 2;
                    this.currentFrame = 0;
                    this.initTime = l;
                    break;
                }
                this.x = this.sx + this.speedx * n / 1000;
                this.y = this.sy + this.speedy * n / 1000;
                if (this.type == 2 && this.z > 0) {
                    this.z += this.speedz * n / 1000;
                    this.speedz += this.accelz * n / 1000;
                } else {
                    this.z = 0;
                }
                if (this.type == 2 || this.type == 3) {
                    if (this.history_len >= this.history_x.length) {
                        for (int i = 0; i < this.history_len - 1; ++i) {
                            this.history_x[i] = this.history_x[i + 1];
                            this.history_y[i] = this.history_y[i + 1];
                            this.history_z[i] = this.history_z[i + 1];
                        }
                        --this.history_len;
                    }
                    this.history_x[this.history_len] = this.x;
                    this.history_y[this.history_len] = this.y;
                    this.history_z[this.history_len] = this.z;
                    ++this.history_len;
                }
                ++this.currentFrame;
                break;
            }
            case 2: {
                switch (this.type) {
                    case 1: {
                        if (this.currentFrame != 0) break;
                        this.target.takeDamage(this.damage);
                        break;
                    }
                    case 2: {
                        if (this.currentFrame == 0) {
                            this.sendDamageToTargetablesAtCoordinates(16, this.tx, this.ty);
                        }
                        this.state = 3;
                        break;
                    }
                    case 3: {
                        if (this.currentFrame == 0) {
                            this.sendDamageToTargetablesAtCoordinates(32, this.tx, this.ty);
                        }
                        this.state = 3;
                    }
                }
            }
            case 3: {
                if (this.type == 1) {
                    this.state = 0;
                    break;
                }
                this.currentFrame = (int)(l - this.initTime) / 200;
                if (this.currentFrame >= 7) {
                    // empty if block
                }
                this.state = 0;
            }
        }
    }

    private void sendDamageToTargetablesAtCoordinates(int n, int n2, int n3) {
        if (this.target.alliance == 0) {
            GameConfig gameConfig;
            int n4;
            for (n4 = 0; n4 < GameImpl.noOfTeams[0]; ++n4) {
                gameConfig = GameImpl.factions[0][n4];
                for (int i = 0; i < gameConfig.noOfUnits; ++i) {
                    Unit unit = gameConfig.troops[i];
                    this.tryToHitTarget(unit, n, n2, n3);
                }
            }
            for (n4 = 0; n4 < GameImpl.buildings.length; ++n4) {
                gameConfig = GameImpl.buildings[n4];
                if (gameConfig == null) continue;
                this.tryToHitTarget((Targetable)((Object)gameConfig), n, n2, n3);
            }
        } else if (this.target.alliance == 1) {
            for (int i = 0; i < GameImpl.noOfTeams[1]; ++i) {
                Team team = GameImpl.factions[1][i];
                for (int j = 0; j < team.noOfUnits; ++j) {
                    Unit unit = team.troops[j];
                    this.tryToHitTarget(unit, n, n2, n3);
                }
            }
        } else {
            this.target.takeDamage(this.damage);
        }
    }

    void tryToHitTarget(Targetable targetable, int n, int n2, int n3) {
        if (CGlobals.distance(targetable.posX - n2, targetable.posY - n3) <= n) {
            targetable.takeDamage(this.damage);
        }
    }

    private void draw(Graphics graphics) {
        int n = GameImpl.currentView.viewPort_x - GameImpl.currentView.viewPortMapX;
        int n2 = GameImpl.currentView.viewPort_y - GameImpl.currentView.viewPortMapY;
        switch (this.state) {
            case 1: {
                int n3 = CGlobals.getOrientation(-(this.sx - this.tx), -(this.sy - this.ty), 0);
                Projectile.muzzleFlashAnimation.image[0] = this.target.alliance == 0 ? muzzleFlashImageNOD : muzzleFlashImageGDI;
                int n4 = this.size * this.speedx / this.speed;
                int n5 = this.size * this.speedy / this.speed;
                switch (this.type) {
                    case 2: 
                    case 3: {
                        int n6 = 50;
                        for (int i = this.history_len - 1; i >= 0; --i) {
                            int n7 = 5 * i / this.history_len;
                            int n8 = this.history_x[i] + n;
                            int n9 = this.history_y[i] + n2 - this.history_z[i] / 7;
                            if (n8 < GameImpl.currentView.viewPort_x || n8 > 480 || n9 < GameImpl.currentView.viewPort_y || n9 > 320) continue;
                            for (int j = 0; j < n7; ++j) {
                                int n10 = (GameImpl.randGenerator.nextInt() & 0x3F) + 192;
                                graphics.setColor(n10, n10, n10);
                                int n11 = n6 * n7 / 100;
                                int n12 = n8 + GameImpl.randGenerator.nextInt() % 6;
                                int n13 = n9 + GameImpl.randGenerator.nextInt() % 6;
                                graphics.drawLine(n12 - n11, n13 - n11, n12 + n11, n13 + n11);
                                graphics.drawLine(n12 - n11, n13 + n11, n12 + n11, n13 - n11);
                            }
                            if (n6 <= 0) continue;
                            n6 -= 5;
                        }
                        break;
                    }
                }
                graphics.setColor(0xFFFFFF);
                switch (this.type) {
                    case 1: {
                        if (this.x + n + n4 / 2 < GameImpl.currentView.viewPort_x || this.x + n + n4 / 2 > 480 || this.y + n2 + n5 / 2 < GameImpl.currentView.viewPort_y || this.y + n2 + n5 / 2 > 320) break;
                        graphics.drawLine(this.x + n, this.y + n2, this.x + n4 + n, this.y + n5 + n2);
                        break;
                    }
                    case 2: {
                        if (this.x + n < GameImpl.currentView.viewPort_x || this.x + n > 480 || this.y + n2 - this.z / 7 < GameImpl.currentView.viewPort_y || this.y + n2 - this.z / 7 > 320) break;
                        graphics.setColor(0x339933);
                        graphics.fillArc(this.x + n - 1, this.y + n2 - 1 - this.z / 7, 2, 2, 0, 360);
                        break;
                    }
                    case 3: {
                        if (this.x + n < GameImpl.currentView.viewPort_x || this.x + n > 480 || this.y + n2 < GameImpl.currentView.viewPort_y || this.y + n2 > 320) break;
                        graphics.fillRect(this.x - 2 + n, this.y - 2 + n2, 4, 4);
                        graphics.drawLine(this.x - n4 + n, this.y - n5 + n2, this.x + 2 * n4 + n, this.y + 2 * n5 + n2);
                    }
                }
                if (this.currentFrame >= 1) break;
                muzzleFlashAnimation.drawAnimation(n3, graphics, this.sx + n, this.sy + n2);
                muzzleFlashAnimation.updateAnimation(n3, 1);
                break;
            }
            case 2: 
            case 3: {
                if (this.type == 1 || this.currentFrame >= 7) break;
                blowingAnimation.drawFrame(this.currentFrame, graphics, this.tx + n, this.ty + n2);
            }
        }
    }
}

