/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.BuildingConstants;
import com.ea.game.Constants;
import com.ea.game.GraphicsConstants;
import com.ea.game.Level;
import com.ea.game.MasterAI;
import com.ea.game.Script;
import com.ea.game.ScriptConstants;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class UtilEntity
implements Constants,
ScriptConstants,
UnitsConstants,
SpriteConstants,
GraphicsConstants,
BuildingConstants {
    static int nrTriggers;
    static int[] _triggers;
    static int nrWayPoints;
    static short[] _wayPoints;
    static int nrBuildSpots;
    static short[] _buildSpots;
    static int[] _objectives;

    static void Triggers_Init() {
        nrTriggers = 0;
        _triggers = new int[576];
    }

    static void Triggers_Release() {
        nrTriggers = 0;
        _triggers = null;
        System.gc();
    }

    static void Triggers_Clean() {
        int n = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            UtilEntity._triggers[n + 0] = 0;
            UtilEntity._triggers[n + 1] = 0;
            UtilEntity._triggers[n + 2] = 0;
            UtilEntity._triggers[n + 3] = 0;
            UtilEntity._triggers[n + 4] = 0;
            UtilEntity._triggers[n + 5] = 1;
            UtilEntity._triggers[n + 6] = 0;
            UtilEntity._triggers[n + 7] = 0;
            UtilEntity._triggers[n + 8] = -1;
            UtilEntity._triggers[n + 9] = -1;
            UtilEntity._triggers[n + 10] = -1;
            UtilEntity._triggers[n + 11] = 1;
            UtilEntity._triggers[n + 12] = -1;
            UtilEntity._triggers[n + 13] = -1;
            UtilEntity._triggers[n + 14] = -1;
            UtilEntity._triggers[n + 15] = -1;
            UtilEntity._triggers[n + 16] = -1;
            UtilEntity._triggers[n + 17] = -1;
            n += 18;
        }
        nrTriggers = 0;
    }

    static void Load_Trigger(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        int n = sDKInputStream.read();
        int n2 = sDKInputStream.read();
        byte by = (byte)sDKInputStream.read();
        byte by2 = (byte)sDKInputStream.read();
        short s6 = sDKInputStream.readShort();
        int n3 = sDKInputStream.read();
        short s7 = sDKInputStream.readShort();
        short s8 = sDKInputStream.readShort();
        short s9 = sDKInputStream.readShort();
        short s10 = sDKInputStream.readShort();
        short s11 = sDKInputStream.readShort();
        short s12 = sDKInputStream.readShort();
        if (nrTriggers >= 32) {
            return;
        }
        int n4 = nrTriggers * 18;
        UtilEntity._triggers[n4 + 0] = s2;
        UtilEntity._triggers[n4 + 1] = s3;
        UtilEntity._triggers[n4 + 2] = s2 + s4;
        UtilEntity._triggers[n4 + 3] = s3 + s5;
        UtilEntity._triggers[n4 + 4] = s;
        UtilEntity._triggers[n4 + 5] = n;
        UtilEntity._triggers[n4 + 6] = 0;
        UtilEntity._triggers[n4 + 7] = n2;
        UtilEntity._triggers[n4 + 8] = by;
        UtilEntity._triggers[n4 + 9] = by2;
        UtilEntity._triggers[n4 + 10] = s6;
        UtilEntity._triggers[n4 + 11] = n3;
        UtilEntity._triggers[n4 + 12] = s7;
        UtilEntity._triggers[n4 + 13] = s9;
        UtilEntity._triggers[n4 + 14] = s10;
        UtilEntity._triggers[n4 + 15] = s11;
        UtilEntity._triggers[n4 + 16] = s12;
        UtilEntity._triggers[n4 + 17] = s8;
        ++nrTriggers;
    }

    static boolean IsTriggerUnit(int n, Unit unit) {
        if (_triggers[n + 10] != -1 && unit._id != _triggers[n + 10]) {
            return false;
        }
        if (_triggers[n + 8] != -1 && unit._subtype != _triggers[n + 8]) {
            return false;
        }
        return _triggers[n + 9] == -1 || unit._allegiance == _triggers[n + 9];
    }

    static boolean IsUnitInTrigger(int n, Unit unit, int n2, int n3) {
        return n2 >= _triggers[n + 0] && n3 >= _triggers[n + 1] && n2 <= _triggers[n + 2] && n3 <= _triggers[n + 3];
    }

    static void CheckTrigger(int n, Unit unit, int n2, int n3) {
        if (UtilEntity.IsTriggerUnit(n, unit)) {
            if (UtilEntity.IsUnitInTrigger(n, unit, unit._pos_x, unit._pos_y) && unit._life > 0) {
                if (!UtilEntity.IsUnitInTrigger(n, unit, n2, n3)) {
                    int n4 = n + 6;
                    _triggers[n4] = _triggers[n4] + 1;
                }
            } else if (UtilEntity.IsUnitInTrigger(n, unit, n2, n3)) {
                int n5 = n + 6;
                _triggers[n5] = _triggers[n5] - 1;
            }
        }
    }

    static void CheckTriggers(Unit unit, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            UtilEntity.CheckTrigger(n3, unit, n, n2);
            n3 += 18;
        }
    }

    static void Update_Triggers() {
        int n = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            int n2 = _triggers[n + 5];
            switch (n2) {
                case 0: {
                    if (_triggers[n + 6] >= _triggers[n + 11]) break;
                    UtilEntity._triggers[n + 5] = 1;
                    break;
                }
                case 1: {
                    if (_triggers[n + 6] < _triggers[n + 11]) break;
                    if (_triggers[n + 17] > 0) {
                        for (int j = 0; j < 64; ++j) {
                            Unit unit;
                            if (Level._entities_usage[j] != 1 || !UtilEntity.IsTriggerUnit(n, unit = (Unit)Level._entities[j]) || !UtilEntity.IsUnitInTrigger(n, unit, unit._pos_x, unit._pos_y) || unit._id > 0) continue;
                            unit._id = _triggers[n + 17];
                            break;
                        }
                    }
                    if (_triggers[n + 12] >= 0) {
                        Script.StartScript(_triggers[n + 12], _triggers[n + 13], _triggers[n + 14], _triggers[n + 15], _triggers[n + 16]);
                    }
                    UtilEntity._triggers[n + 5] = _triggers[n + 7] > 0 ? 2 : 0;
                }
            }
            n += 18;
        }
    }

    static void WayPoints_Init() {
        nrWayPoints = 0;
        _wayPoints = new short[480];
    }

    static void WayPoints_Release() {
        nrWayPoints = 0;
        _wayPoints = null;
        System.gc();
    }

    static void WayPoints_Clean() {
        int n = 0;
        for (int i = 0; i < nrWayPoints; ++i) {
            UtilEntity._wayPoints[n + 0] = -1;
            UtilEntity._wayPoints[n + 1] = -1;
            UtilEntity._wayPoints[n + 2] = -1;
            UtilEntity._wayPoints[n + 3] = -1;
            UtilEntity._wayPoints[n + 4] = 0;
            n += 5;
        }
        nrWayPoints = 0;
    }

    static void Load_WayPoint(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        if (nrWayPoints >= 96) {
            return;
        }
        int n = nrWayPoints * 5;
        UtilEntity._wayPoints[n + 0] = s;
        UtilEntity._wayPoints[n + 1] = s2;
        UtilEntity._wayPoints[n + 2] = s3;
        UtilEntity._wayPoints[n + 3] = s4;
        UtilEntity._wayPoints[n + 4] = s5;
        ++nrWayPoints;
    }

    static int Get_WayPoint(int n) {
        int n2 = 0;
        for (int i = 0; i < nrWayPoints; ++i) {
            if (_wayPoints[n2 + 0] == n) {
                return n2;
            }
            n2 += 5;
        }
        return -1;
    }

    static void BuildSpots_Init() {
        nrBuildSpots = 0;
        _buildSpots = new short[160];
    }

    static void BuildSpots_Release() {
        nrBuildSpots = 0;
        _buildSpots = null;
        System.gc();
    }

    static void BuildSpots_Clean() {
        int n = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            UtilEntity._buildSpots[n + 0] = -1;
            UtilEntity._buildSpots[n + 1] = -1;
            UtilEntity._buildSpots[n + 2] = -1;
            UtilEntity._buildSpots[n + 3] = -1;
            UtilEntity._buildSpots[n + 4] = 0;
            n += 5;
        }
        nrBuildSpots = 0;
    }

    static void Load_BuildSpot(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = (short)sDKInputStream.read();
        if (nrBuildSpots >= 32) {
            return;
        }
        int n = nrBuildSpots * 5;
        UtilEntity._buildSpots[n + 0] = s;
        UtilEntity._buildSpots[n + 1] = s2;
        UtilEntity._buildSpots[n + 2] = s3;
        UtilEntity._buildSpots[n + 3] = s4;
        UtilEntity._buildSpots[n + 4] = 0;
        ++nrBuildSpots;
    }

    static int Update_BuildSpots() {
        int n = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            if (_buildSpots[n + 4] > 0) {
                int n2 = n + 4;
                _buildSpots[n2] = (short)(_buildSpots[n2] - 1);
            }
            n += 5;
        }
        return -1;
    }

    static int Get_BuildSpot(int n) {
        int n2 = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            if (_buildSpots[n2 + 0] == n) {
                return n2;
            }
            n2 += 5;
        }
        return -1;
    }

    static int FindBuildSpot(int n, int n2, int n3, boolean bl) {
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            int n7 = UtilEntity.BuildSpotScore(n6, n, n2, n3, bl);
            if (n7 >= 0 && (n4 < 0 || n7 < n4)) {
                n4 = n7;
                n5 = n6;
            }
            n6 += 5;
        }
        return n5;
    }

    static int BuildSpotScore(int n, int n2, int n3, int n4, boolean bl) {
        short s = _buildSpots[n + 3];
        if (_buildSpots[n + 4] > 0) {
            return -1;
        }
        if (bl && s != n2) {
            return -1;
        }
        if (!MasterAI.IsValidBuildingPosition(n2, _buildSpots[n + 1], _buildSpots[n + 2])) {
            return -1;
        }
        int n5 = Math.abs(n3 - _buildSpots[n + 1]) + Math.abs(n4 - _buildSpots[n + 2]);
        return n5;
    }

    static void Objectives_Init() {
        _objectives = null;
    }

    static void Objectives_Release() {
        _objectives = null;
        System.gc();
    }

    static void Objectives_Clean() {
    }

    static void Objectives_AddTypeGlobal(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    static void Objectives_AddTypeEntity(int n, int n2, int n3, int n4, int n5) {
    }

    static void Objectives_ChangeStatus(int n, int n2) {
    }

    static int Objectives_GetInfo(int n, int n2) {
        return 0;
    }

    static int Objectives_GetDisplayNr() {
        int n = 0;
        return n;
    }

    static boolean Objective_IsDisplayable(int n) {
        return false;
    }

    static void Objective_RefreshEntityPos(int n) {
    }
}

