/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Encyclopedia;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.MasterAI;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Unit;
import com.ea.game.UtilEntity;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Building
extends Entity
implements Constants,
BuildingConstants,
SpriteConstants {
    int[] _collisionBox;
    byte _subtype;
    byte _allegiance;
    byte _faction;
    byte _spawn_dx;
    byte _spawn_dy;
    byte _spawn_orientation;
    short _spawn_unit_types;
    short _life;
    short _initial_life;
    long _timer_last_hit;
    long _timer_last_repair;
    boolean _on_fire = false;
    boolean _bCanFire;
    boolean _bHasTurret;
    boolean _bNeedsPower;
    int _fire_range;
    int _fire_rate;
    int _damage;
    int _armour;
    int _bullet_type;
    int _targetPointer;
    int _baseEntityPointer;
    boolean _bTargeted;
    boolean _noticed;
    byte _beacon_time;
    byte _cycle;
    byte _prismTowerPowerAnim;
    boolean _prismTowerCharge;
    int _prismFriendlyTarget = -1;
    byte _prismTowers;
    int _firingTimer;
    byte _idle_anim_timer;
    short _spotPointer;
    public boolean _FOW_visible;

    public Building(int n) {
        super(n);
        this.Clean();
    }

    public void Clean() {
        this._id = 0;
        this._subtype = (byte)-1;
        this._allegiance = 0;
        this._spawn_dx = 0;
        this._spawn_dy = 0;
        this._spawn_orientation = 0;
        this._spawn_unit_types = 0;
        this._life = 0;
        this._initial_life = 0;
        this._bCanFire = false;
        this._bHasTurret = false;
        this._bNeedsPower = false;
        this._fire_range = 0;
        this._fire_rate = 0;
        this._damage = 0;
        this._armour = 0;
        this._bullet_type = 0;
        this._targetPointer = -1;
        this._baseEntityPointer = 0;
        this._bTargeted = false;
        this._type = 6;
        this._collisionBox = null;
        System.gc();
        this._collisionBox = new int[4];
        this._noticed = false;
        this._beacon_time = (byte)-1;
        this._cycle = 0;
        this._prismTowerPowerAnim = 0;
        this._prismTowerCharge = false;
        this._prismFriendlyTarget = -1;
        this._firingTimer = 0;
        this._flags = 0;
        this._idle_anim_timer = 0;
        this._spotPointer = (short)-1;
    }

    public void Building_Destructor() {
        Level.DeleteEntity(this._baseEntityPointer);
        this._baseEntityPointer = -1;
        this._spotPointer = (short)-1;
        if (!Level._b_tower_defense) {
            this.ApplyCreep(false);
        }
        this.EraseCollision();
        Level.RefreshCreep(1);
        Level.RefreshCreep(0);
    }

    public void Building_Load(SDKInputStream sDKInputStream) throws IOException {
        this._subtype = (byte)(sDKInputStream.read() & 0xFF);
        this._allegiance = (byte)(sDKInputStream.read() & 0xFF);
        this._faction = (byte)(sDKInputStream.read() & 0xFF);
    }

    public void Building_Init() {
        this._z_order = 3;
        this._sprite = this._faction == 0 ? 0 : 27;
        short[] sArray = this._faction == 0 ? Level._building_stats_soviets : Level._building_stats_allied;
        int n = this._subtype * 20;
        this._spawn_dx = (byte)sArray[n + 0];
        this._spawn_dy = (byte)sArray[n + 1];
        this._spawn_orientation = (byte)sArray[n + 2];
        this._spawn_unit_types = sArray[n + 6];
        this._life = this._initial_life = sArray[n + 9];
        this._fire_range = sArray[n + 10];
        this._fire_rate = sArray[n + 11];
        this._damage = sArray[n + 12];
        this._armour = sArray[n + 13];
        this._bullet_type = sArray[n + 14];
        this._bCanFire = false;
        this._bHasTurret = false;
        this._bNeedsPower = false;
        this._timer = 0;
        this._targetPointer = -1;
        this._baseEntityPointer = -1;
        this._spotPointer = (short)-1;
        this._bTargeted = false;
        short s = sArray[n + 16];
        switch (this._subtype) {
            case 5: {
                this._prismTowerPowerAnim = 0;
                this._prismTowerCharge = false;
                this._bCanFire = true;
                this._bNeedsPower = true;
                break;
            }
            case 6: {
                this._bCanFire = true;
                this._bHasTurret = true;
                break;
            }
            case 1: {
                if (this._allegiance == 0) {
                    Level._player_power -= s;
                    break;
                }
                if (this._allegiance != 1) break;
                Level._ai_power -= s;
            }
        }
        if (this._allegiance == 0) {
            if (s > 0) {
                Level._player_consumption += s;
            }
        } else if (this._allegiance == 1) {
            if (s > 0) {
                Level._ai_consumption += s;
            }
            if (this._subtype == 9) {
                for (int i = 0; i < 6; ++i) {
                    MasterAI._AI_sw_cooldown[i] = 14 * Level.GetSWStats(i, 0);
                }
            }
        }
        this._noticed = false;
        this._beacon_time = (byte)-1;
    }

    public void Building_Init2() {
        Entity entity;
        int n;
        this.ApplyCollision();
        if (!Level._b_tower_defense) {
            this.ApplyCreep(true);
        }
        if ((n = Level.GetBuildingStats(this._faction, this._subtype, 17)) != -1) {
            entity = Level.SpawnEntity(14);
            entity.BuildingBase_Init(this._pos_x, this._pos_y, 0, n, 0, 1);
            this._baseEntityPointer = entity.GetPointer();
        }
        if (this._subtype == 2) {
            this._targetPointer = -1;
            entity = Level.FindClosestMineralField(this._pos_x, this._pos_y, 64);
            if (entity != null) {
                this._targetPointer = entity.GetPointer();
            }
        }
        if (GameImpl._useFog && this._allegiance == 0) {
            int n2 = Level.GetBuildingStats(this._faction, this._subtype, 8) * 8;
            Level.FOW_DiscoverPixels(this._pos_x, this._pos_y, n2);
        }
        Level.IncEntityNo(6, this._subtype, this._allegiance);
        Hud.RefreshBuildMenuItems();
        this.SetState(0);
        this._prismTowerPowerAnim = 0;
        this._prismTowerCharge = false;
        this._prismFriendlyTarget = -1;
        this._firingTimer = 0;
        this._spotPointer = (short)-1;
        XSprite xSprite = Sprites._sprites[this._sprite];
        this.SetPalette(xSprite);
        if (this._allegiance == 0) {
            ++Level._player_build_points;
        }
        if (this._allegiance == 1) {
            ++Level._ai_build_points;
        }
        this._idle_anim_timer = 0;
        if (Level._b_tower_defense) {
            this._fire_range <<= 1;
        }
        this._FOW_visible = true;
    }

    public void Building_Update() {
        this._FOW_visible = this._allegiance == 0 ? true : (Level.FOW_PercentageVisible(this.ComputeDefaultBoundingBox()) >= 40 ? true : true);
        if (this._baseEntityPointer > 0) {
            Entity entity = Level.GetEntitySafe(this._baseEntityPointer);
            if (GameImpl._useFog) {
                entity._flags = this._FOW_visible ? (entity._flags &= 0xFFFFFFEF) : (entity._flags |= 0x10);
            }
            if ((this._flags & 0x10) != 0) {
                entity._flags |= 0x10;
            }
        }
        if ((this._flags & 8) != 0) {
            return;
        }
        if (this._life < this._initial_life && GameImpl._canvas.getAppTime() - this._timer_last_hit > 8000L && GameImpl._canvas.getAppTime() - this._timer_last_repair > 2000L) {
            if (this._life + 10 < this._initial_life) {
                this._life = (short)(this._life + 10);
                if (this._on_fire && this._life > this._initial_life / 2 && this._subtype != 6) {
                    this.SetStayAnim();
                    this._on_fire = false;
                }
            } else {
                this._life = this._initial_life;
            }
            this._timer_last_repair = GameImpl._canvas.getAppTime();
        }
        if ((this._subtype == 5 || this._subtype == 6) && this._firingTimer < this._fire_rate * 2) {
            ++this._firingTimer;
        }
        if (this._sprite >= 0) {
            this.UpdateCrtAnim();
        }
        switch (this._state) {
            case 0: {
                this.DoStay();
                break;
            }
            case 1: {
                this.DoFire();
                break;
            }
            case 2: {
                this.DoDie(false);
                break;
            }
            case 4: {
                this.DoDie(true);
                break;
            }
            case 3: {
                this.DoDemolish();
            }
        }
    }

    public void Building_Draw(SDKGraphics sDKGraphics) {
        int n;
        if ((this._flags & 0x10) != 0) {
            return;
        }
        XSprite xSprite = Sprites._sprites[this._sprite];
        this.SetPalette(xSprite);
        if (this._state == 3) {
            if (this._timer % 3 != 0) {
                this.DrawCrtAnim(sDKGraphics);
            }
        } else {
            this.DrawCrtAnim(sDKGraphics);
            if (this._subtype == 5 && this._faction == 1) {
                XSprite xSprite2 = Sprites._sprites[36];
                n = this._pos_x + GameImpl.SV_X - Camera._nCamX;
                int n2 = this._pos_y + GameImpl.SV_Y - Camera._nCamY;
                if (this._prismTowerPowerAnim >= 0) {
                    if (this._prismTowerCharge) {
                        for (int i = 0; i < this._prismTowerPowerAnim; ++i) {
                            xSprite2.DrawFrame(76, n - 0, n2 - 7 - i, 0);
                            xSprite2.DrawFrame(76, n - 1, n2 - 7 - i, 0);
                            xSprite2.DrawFrame(76, n - 2, n2 - 7 - i, 0);
                        }
                    } else {
                        xSprite2.DrawFrame(76, n - 1, n2 - 7 - this._prismTowerPowerAnim, 0);
                        xSprite2.DrawFrame(76, n - 2, n2 - 7 - this._prismTowerPowerAnim, 0);
                        xSprite2.DrawFrame(76, n - 0, n2 - 7 - this._prismTowerPowerAnim, 0);
                        xSprite2.DrawFrame(76, n - 1, n2 - 7 - 1 - this._prismTowerPowerAnim, 0);
                        xSprite2.DrawFrame(76, n - 2, n2 - 7 - 1 - this._prismTowerPowerAnim, 0);
                        xSprite2.DrawFrame(76, n - 0, n2 - 7 - 1 - this._prismTowerPowerAnim, 0);
                    }
                    this._prismTowerPowerAnim = (byte)((this._prismTowerPowerAnim + 1) % 9);
                }
            }
        }
        if (this._bTargeted || this._life < this._initial_life || Level._buildings_off_times[this._allegiance][this._subtype] > 0) {
            this.DrawLife(sDKGraphics);
        }
        if (this._bTargeted && (this._subtype == 5 || this._subtype == 6)) {
            int n3 = this._pos_x - Camera._nCamX + GameImpl.SV_X;
            n = this._pos_y - Camera._nCamY + GameImpl.SV_Y;
            Hud.Build_Draw_Range(sDKGraphics, this._subtype, n3, n);
        }
        this._bTargeted = false;
        boolean bl = false;
        if (Level._buildings_off_times[this._allegiance][this._subtype] > 0) {
            XSprite xSprite3 = Sprites._sprites[11];
            xSprite3.DrawFrame(91, this._pos_x - Camera._nCamX + GameImpl.SV_X, this._pos_y - Camera._nCamY + GameImpl.SV_Y, 0);
            bl = true;
        }
        if (this._subtype != 0 && !Level.HasPower(this._allegiance) && !bl && this._subtype != 6) {
            XSprite xSprite4 = Sprites._sprites[11];
            xSprite4.DrawFrame(90, this._pos_x - Camera._nCamX + GameImpl.SV_X, this._pos_y - Camera._nCamY + GameImpl.SV_Y, 0);
        }
    }

    private void SetPalette(XSprite xSprite) {
        int n = 0;
        if (this._allegiance == 0) {
            n = this._faction != Level._player_faction ? 1 : 0;
        } else if (this._allegiance == 1) {
            n = Level._player_faction != Level._ai_faction ? (this._faction != Level._ai_faction ? 1 : 0) : (this._faction != Level._ai_faction ? 0 : 1);
        }
        xSprite.SetCurrentPalette(n);
    }

    public int GetUsedPalette() {
        int n = 1;
        if (this._allegiance == 0) {
            n = this._faction != Level._player_faction ? 2 : 1;
        } else if (this._allegiance == 1) {
            n = Level._player_faction != Level._ai_faction ? (this._faction != Level._ai_faction ? 2 : 1) : (this._faction != Level._ai_faction ? 1 : 2);
        }
        return n;
    }

    private void DrawLife(SDKGraphics sDKGraphics) {
        int n = this._pos_x - 36 - Camera._nCamX + GameImpl.SV_X;
        int n2 = this._collisionBox[1] - 4 - Camera._nCamY + GameImpl.SV_Y - 15;
        int n3 = 0xFFFF00;
        if (this._allegiance == 0) {
            n3 = 700682;
        } else if (this._allegiance == 1) {
            n3 = 0xFF0000;
        }
        sDKGraphics.setColor(n3);
        short s = this._initial_life;
        if (this._life > s) {
            s = this._life;
        }
        if (this._initial_life != 0) {
            if (Level._buildings_off_times[this._allegiance][this._subtype] > 0) {
                sDKGraphics.setColor(0x404040);
            }
            sDKGraphics.fillRect(n, n2, this._life * 72 / s, 4);
        }
        if (this._allegiance == 0) {
            sDKGraphics.setColor(354565);
        } else if (this._allegiance == 1) {
            sDKGraphics.setColor(0x960000);
        }
        sDKGraphics.drawRect(n, n2, 72, 4);
        if (this._initial_life != 0) {
            sDKGraphics.drawRect(n, n2, this._life * 72 / s, 4);
        }
        if (Level._buildings_off_times[this._allegiance][this._subtype] > 0) {
            SDKUtils.setFont(GameImpl.fonts[4]);
            if (Level._b_tower_defense && this._subtype == 0) {
                Utils.DrawNumber(Level._buildings_off_times[this._allegiance][this._subtype] / 14, n + (this._life * 72 / 4000 >> 1), n2, 33);
            } else {
                Utils.DrawNumber(Level._buildings_off_times[this._allegiance][this._subtype] / 14, n + (this._life * 72 / this._initial_life >> 1), n2, 33);
            }
        }
    }

    public void DrawName(SDKGraphics sDKGraphics) {
        int n = this._pos_x - Camera._nCamX + GameImpl.SV_X;
        int n2 = this._collisionBox[1] - Camera._nCamY + GameImpl.SV_Y;
        SDKUtils.setFont(GameImpl.fonts[4]);
        Utils.DrawString(42 + this._faction * 10 + this._subtype, n, n2, 1);
    }

    public boolean IsSelectable(boolean bl) {
        if (this._life <= 0) {
            return false;
        }
        if ((this._flags & 0x10) != 0) {
            return false;
        }
        if (bl) {
            return this._allegiance == 0;
        }
        if (this._allegiance == 1 && (this._flags & 0x8000) != 0) {
            return false;
        }
        return (this._flags & 0x400) == 0;
    }

    public void SetBox() {
        this._collisionBox = Utils.Rect(this._collisionBox, this.ComputeBoundingBox());
        this._collisionBox[0] = this._collisionBox[0] + 8;
        this._collisionBox[2] = this._collisionBox[2] - 8;
        this._collisionBox[1] = this._collisionBox[1] + 8;
    }

    public void SpawnNewUnit(int n) {
        if ((1 << n & this._spawn_unit_types) == 0) {
            return;
        }
        Unit unit = null;
        unit = this._allegiance == 0 ? Level.SpawnUnit(n, this._pos_x + this._spawn_dx, this._pos_y + this._spawn_dy, this._allegiance, this._spawn_orientation, (byte)Hud._hud_current_squad) : Level.SpawnUnit(n, this._pos_x + this._spawn_dx, this._pos_y + this._spawn_dy, this._allegiance, this._spawn_orientation, (byte)0);
        if (unit != null) {
            if (this._allegiance == 0) {
                Level._player_money -= Level.GetUnitStats(n, 10);
                Level._statistics[2] = Level._statistics[2] + 1;
            } else if (this._allegiance == 1) {
                Level._ai_money -= Level.GetUnitStats(n, 10);
                Level._statistics[3] = Level._statistics[3] + 1;
            }
        }
    }

    public void ApplyCollision() {
        int n = 0;
        if (this._faction == 1) {
            n = 10;
        }
        Level.ApplyCollisionMap(this._pos_x, this._pos_y, n + this._subtype);
    }

    public void EraseCollision() {
        int n = 0;
        if (this._subtype == 2) {
            n = 6;
        }
        int n2 = 0;
        if (this._faction == 1) {
            n2 = 10;
        }
        if (Level._b_tower_defense && (this._subtype == 6 || this._subtype == 5)) {
            n = 1;
        }
        Level.EraseCollisionMap(this._pos_x, this._pos_y, n2 + this._subtype, n);
    }

    public void ApplyCreep(boolean bl) {
        int n = this._pos_x / 8;
        int n2 = this._pos_y / 8;
        int n3 = Level.GetBuildingStats(this._faction, this._subtype, 8);
        if ((this._subtype == 5 || this._subtype == 6) && bl) {
            return;
        }
        int n4 = 1 + this._allegiance;
        if (!bl) {
            n4 = 0;
        }
        for (int i = n2 - n3; i < n2 + n3; ++i) {
            for (int j = n - n3; j < n + n3; ++j) {
                if (Map.GetCollisionAtTile(j, i) > 4) continue;
                Map.SetCollisionAtTile(j, i, n4);
            }
        }
    }

    public void SellBuilding() {
        this.SetState(4);
    }

    public void TakeDamage(int n, int n2, int n3) {
        Level.SoundSwitch();
        if (this._allegiance == 0) {
            if (this._beacon_time < 0) {
                this._noticed = false;
            }
            this._beacon_time = (byte)30;
            if (GameImpl.IsCheatActive(3)) {
                return;
            }
        } else {
            this._noticed = true;
        }
        n *= Unit._units_damage_matrix[n2][this._armour];
        n >>= 6;
        if (this._life > 0) {
            this._life = (short)(this._life - n);
            this._timer_last_hit = GameImpl._canvas.getAppTime();
            this._timer_last_repair = GameImpl._canvas.getAppTime();
            Entity entity = Level.GetEntitySafe(n3);
            if (entity != null && entity._type == 5) {
                Unit unit = (Unit)entity;
                int n4 = this._subtype * 20;
                unit.ReceiveExperience(this._life, n, this._faction, 6, this._subtype);
            }
            if (this._life <= 0) {
                if ((entity._type == 114 || entity._type == 106 || entity._type == 110 || entity._type == 111) && this._allegiance == 1) {
                    Encyclopedia.SetSuperWeaponKills(false);
                }
                this._life = 0;
                this.SetState(2);
            } else if (this._life < this._initial_life >> 1 && this._subtype != 6) {
                this.SetCrtAnim(43 + this._subtype);
                this._on_fire = true;
            }
        }
    }

    public void StartAttack(Entity entity) {
        if (this._life <= 0) {
            return;
        }
        if (this._bNeedsPower && (this._allegiance == 0 ? Level._player_consumption > Level._player_power || Level._buildings_off_times[0][1] > 0 : this._allegiance == 1 && (Level._ai_consumption > Level._ai_power || Level._buildings_off_times[1][1] > 0))) {
            return;
        }
        this._targetPointer = entity.GetPointer();
        this.SetState(1);
    }

    private void Fire() {
        if (this._subtype == 5 && this._faction == 1) {
            if (this._firingTimer > this._fire_rate - 9 + 1 && this._targetPointer != -1 && !this._prismTowerCharge) {
                if (this._prismTowerPowerAnim != 0) {
                    return;
                }
                this._prismTowers = 1;
                int n = Level.GetBulletStats(this._bullet_type, 3);
                n *= n;
                if (Level.GetEntityNo(6, 5, this._allegiance) > 1) {
                    for (int i = 64; i < 160; ++i) {
                        int n2;
                        if (Level._entities_usage[i] != 1) continue;
                        Building building = (Building)Level.GetEntityUnsafe(i);
                        if (building._subtype != 5 || building._faction != 1 || building._life <= 0 || building.GetPointer() == this.GetPointer() || building._allegiance != this._allegiance || (n2 = (building._pos_x - this._pos_x) * (building._pos_x - this._pos_x) + (building._pos_y - this._pos_y) * (building._pos_y - this._pos_y)) >= n || !building.PrismTowerForceFire(this.GetPointer())) continue;
                        this._prismTowers = (byte)(this._prismTowers + 1);
                    }
                }
                this._firingTimer = this._fire_rate - 9 + 1;
                this._prismTowerCharge = true;
            } else if (this._firingTimer > this._fire_rate) {
                if ((this._flags & 0x4000) == 0) {
                    this._firingTimer = 0;
                    this._prismTowerCharge = false;
                    this.SetFireAnim();
                    if (this._targetPointer != -1) {
                        this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
                    } else if (this._prismFriendlyTarget != -1) {
                        this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._prismFriendlyTarget, this._pos_x, this._pos_y);
                    }
                    this._prismFriendlyTarget = -1;
                }
            } else if (this.IsCrtAnimEnded()) {
                this.SetStayAnim();
            }
        } else if (this._firingTimer > this._fire_rate) {
            if ((this._flags & 0x4000) == 0) {
                this._firingTimer = 0;
                this.SetFireAnim();
                this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
            }
        } else if (this.IsCrtAnimEnded()) {
            this.SetStayAnim();
        }
    }

    private int GetCraterFrame() {
        switch (this._subtype) {
            case 2: {
                return -1;
            }
            case 5: 
            case 6: {
                return 0;
            }
        }
        return 10;
    }

    public void ChangeAllegiance(int n) {
        if (this._allegiance == n) {
            return;
        }
        Level.DecEntityNo(6, this._subtype, this._allegiance);
        Level.IncEntityNo(6, this._subtype, n);
        Hud.RefreshBuildMenuItems();
        if (this._allegiance == 0) {
            --Level._player_build_points;
        }
        if (this._allegiance == 1) {
            --Level._ai_build_points;
        }
        int n2 = Level.GetBuildingStats(this._faction, this._subtype, 16);
        if (this._subtype == 1) {
            if (this._allegiance == 0) {
                Level._player_power += n2;
            } else if (this._allegiance == 1) {
                Level._ai_power += n2;
            }
        }
        if (this._allegiance == 0) {
            if (n2 > 0) {
                Level._player_consumption -= n2;
            }
        } else if (this._allegiance == 1 && n2 > 0) {
            Level._ai_consumption -= n2;
        }
        if (!Level._b_tower_defense) {
            this.ApplyCreep(false);
        }
        this._allegiance = (byte)n;
        if (this._subtype == 1) {
            if (this._allegiance == 0) {
                Level._player_power -= n2;
            } else if (this._allegiance == 1) {
                Level._ai_power -= n2;
            }
        }
        if (this._allegiance == 0) {
            if (n2 > 0) {
                Level._player_consumption += n2;
            }
            if (GameImpl._useFog) {
                int n3 = Level.GetBuildingStats(this._faction, this._subtype, 8) * 8;
                Level.FOW_DiscoverPixels(this._pos_x, this._pos_y, n3);
            }
            if (this._subtype == 9) {
                // empty if block
            }
            if (!Level._b_tower_defense) {
                this.ApplyCreep(true);
            }
        } else if (this._allegiance == 1) {
            if (n2 > 0) {
                Level._ai_consumption += n2;
            }
            if (this._subtype == 9) {
                for (int i = 0; i < 6; ++i) {
                    MasterAI._AI_sw_cooldown[i] = 14 * Level.GetSWStats(i, 0);
                }
            }
        }
        if (this._allegiance == 0) {
            ++Level._player_build_points;
        }
        if (this._allegiance == 1) {
            ++Level._ai_build_points;
        }
    }

    static void STATES__() {
    }

    public void SetState(int n) {
        if (this._state == n) {
            return;
        }
        switch (this._state) {
            case 0: {
                break;
            }
            case 1: {
                this._prismTowerCharge = false;
                break;
            }
            case 2: {
                break;
            }
        }
        this._z_order = 3;
        this._flags &= 0xFFFFF7FF;
        block5 : switch (n) {
            case 0: {
                this._timer = 0;
                this.SetStayAnim();
                this.SetBox();
                break;
            }
            case 1: {
                this._timer = 0;
                this.SetStayAnim();
                this.SetBox();
                break;
            }
            case 4: {
                this._z_order = 3;
                this._flags |= 0x800;
                this.SetSellAnim();
                Level.DecEntityNo(6, this._subtype, this._allegiance);
                if (this._allegiance == 0) {
                    --Level._player_build_points;
                }
                if (this._allegiance != 1) break;
                --Level._ai_build_points;
                break;
            }
            case 2: {
                this._z_order = 3;
                this._flags |= 0x800;
                this.SetDieAnim();
                this.SetBox();
                if (this._life > 0) {
                    this._life = 0;
                }
                if (this._spotPointer >= 0 && this._spotPointer < UtilEntity.nrBuildSpots * 5) {
                    UtilEntity._buildSpots[this._spotPointer + 4] = 48;
                }
                Level.DecEntityNo(6, this._subtype, this._allegiance);
                if (this._allegiance == 0) {
                    --Level._player_build_points;
                }
                if (this._allegiance == 1) {
                    --Level._ai_build_points;
                }
                switch (this._subtype) {
                    case 0: {
                        this.CreateExplosion(7, 30, true, 0, 0, 0);
                        break block5;
                    }
                    case 5: {
                        this.CreateExplosion(1, 0, true, 0, 0, 0);
                        this.CreateExplosion(1, 0, false, 0, -25, 1);
                        break block5;
                    }
                    case 6: {
                        this.CreateExplosion(1, 0, true, 0, 0, 0);
                        break block5;
                    }
                }
                this.CreateExplosion(5, 25, true, 0, 0, 0);
                break;
            }
            case 3: {
                this._timer = 0;
                this.SetStayAnim();
                this.SetBox();
            }
        }
        this._state = n;
    }

    private void DoStay() {
        if (this._subtype != 6 && this._subtype != 5 && !this._on_fire) {
            this._idle_anim_timer = (byte)(this._idle_anim_timer - 1);
            if (this._idle_anim_timer <= 0 && this.IsCrtAnimEnded() && Level.HasPower(this._allegiance)) {
                this._idle_anim_timer = (byte)Utils.random(1 * SDKConfig.getMaxFPS(), 10 * SDKConfig.getMaxFPS());
                this.SetIdleAnim();
            } else if (this._idle_anim_timer > 0 && this.IsCrtAnimEnded()) {
                this.SetStayAnim();
            }
        }
        this.EvaluateStaySituation();
        if (this._subtype == 2) {
            if (this._allegiance != 2 && Level._buildings_off_times[this._allegiance][this._subtype] <= 0) {
                Entity entity;
                ++this._timer;
                if (this._timer > 32 && (entity = Level.GetEntitySafe(this._targetPointer)) != null) {
                    this._timer = 0;
                    int n = entity.MField_ExtractMoney(100);
                    if (!Level.HasPower(this._allegiance)) {
                        n >>= 1;
                    }
                    if (this._allegiance == 0) {
                        Level._player_money += n;
                    } else if (this._allegiance == 1) {
                        Level._ai_money += n;
                    }
                }
            }
        } else if (this._subtype == 5 && this._faction == 0) {
            int n;
            if (this._allegiance == 0) {
                n = Level._player_power - Level._player_consumption;
            } else if (this._allegiance == 1) {
                n = Level._ai_power - Level._ai_consumption;
            } else {
                return;
            }
            if (n <= 0 || Level._buildings_off_times[this._allegiance][1] > 0) {
                if (this._crt_anim != 53) {
                    this.SetCrtAnim(53);
                }
            } else if (this._crt_anim != 5) {
                this.SetCrtAnim(5);
            }
        } else if (this._subtype == 5 && this._faction == 1) {
            int n;
            if (this._allegiance == 0) {
                n = Level._player_power - Level._player_consumption;
            } else if (this._allegiance == 1) {
                n = Level._ai_power - Level._ai_consumption;
            } else {
                return;
            }
            if (n <= 0 || Level._buildings_off_times[this._allegiance][1] > 0) {
                this._prismTowerPowerAnim = (byte)-1;
                if (this._crt_anim != 53) {
                    this.SetCrtAnim(53);
                }
            } else {
                if (this._prismTowerPowerAnim == -1) {
                    this._prismTowerPowerAnim = 0;
                }
                if (this._crt_anim != 5) {
                    this.SetCrtAnim(5);
                }
            }
        }
    }

    private void DoFire() {
        if (this.EvaluateFireSituation()) {
            return;
        }
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (this._prismFriendlyTarget != -1) {
            entity = Level.GetEntitySafe(this._prismFriendlyTarget);
        }
        if (entity == null) {
            return;
        }
        int n = entity._pos_x - this._pos_x;
        int n2 = entity._pos_y - this._pos_y;
        byte by = this.GetOrientation(n, n2);
        if (this._bHasTurret && by != this._orientation) {
            if (this._timer > 2) {
                this._orientation = this.TurnTowards(by, this._orientation);
                this.SetStayAnim();
                this._timer = 0;
            }
        } else {
            this._orientation = by;
        }
        if (this._bHasTurret) {
            ++this._timer;
            if (this._orientation == by) {
                this.Fire();
            }
        } else {
            this.Fire();
        }
    }

    private void DoDie(boolean bl) {
        if (this.IsCrtAnimEnded()) {
            int n;
            int n2 = Level.GetBuildingStats(this._faction, this._subtype, 16);
            if (this._subtype == 1) {
                if (this._allegiance == 0) {
                    Level._player_power += n2;
                } else if (this._allegiance == 1) {
                    Level._ai_power += n2;
                }
            }
            if (this._allegiance == 0) {
                if (n2 > 0) {
                    Level._player_consumption -= n2;
                }
                if ((n = Level.GetEntityNo(6, this._subtype, this._allegiance)) == 0) {
                    Hud.RefreshBuildMenuItems();
                }
                if (!bl) {
                    Level._statistics[5] = Level._statistics[5] + 1;
                }
            } else if (this._allegiance == 1) {
                if (n2 > 0) {
                    Level._ai_consumption -= n2;
                }
                if (!bl) {
                    Level._statistics[4] = Level._statistics[4] + 1;
                }
            }
            if (bl) {
                n = Level.GetBuildingStats(this._faction, this._subtype, 15) * 65 / 100;
                if (this._allegiance == 0) {
                    Level._player_money += n;
                } else if (this._allegiance == 1) {
                    Level._ai_money += n;
                }
            }
            Level.DeleteEntity(this);
            n = this.GetCraterFrame();
            if (n != -1 && !bl) {
                Level.AddFixedEntity(this._pos_x, this._pos_y, 2, n, 0, 1);
                XSprite xSprite = Sprites._sprites[2];
                xSprite.RectFrame(n, this._pos_x, this._pos_y, 0);
                Map.CDB_AddInvalidateRegion(XSprite._rect);
            }
        }
    }

    private void DoDemolish() {
        ++this._timer;
        if (this._timer > 14) {
            this.SetState(2);
        }
    }

    private void EvaluateStaySituation() {
        if (!this._bCanFire) {
            return;
        }
        --this._timer;
        if (this._timer < 0) {
            Entity entity;
            this._timer = 4;
            if ((this._flags & 0x4000) == 0 && (entity = this.FindTarget(this._allegiance, this._fire_range, this._fire_range, -1, 10)) != null) {
                this.StartAttack(entity);
            }
        }
    }

    private boolean EvaluateFireSituation() {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (this._bNeedsPower && !Level.HasPower(this._allegiance)) {
            this._timer = 0;
            this._firingTimer = 0;
            this._targetPointer = -1;
            this.SetState(0);
            return true;
        }
        if (entity == null || entity.GetLife() <= 0) {
            if (this._subtype == 5 && this._faction == 1 && this._prismFriendlyTarget != -1) {
                return false;
            }
            this._timer = 0;
            this._targetPointer = -1;
            if (this.IsCrtAnimEnded()) {
                this.SetState(0);
            }
            return true;
        }
        int n = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y);
        if (n > this._fire_range || (entity._flags & 0x8000) != 0 || (this._flags & 0x4000) != 0) {
            this._timer = 0;
            this._targetPointer = -1;
            this.SetState(0);
            return true;
        }
        return false;
    }

    static void __STATES() {
    }

    static void ANIMS__() {
    }

    public void SetStayAnim() {
        int n = 0;
        switch (this._subtype) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6 + this._orientation;
                break;
            }
            case 7: {
                n = 14;
                break;
            }
            case 8: {
                n = 15;
                break;
            }
            case 9: {
                n = 16;
            }
        }
        this.SetCrtAnim(n);
    }

    public void SetIdleAnim() {
        int n = 0;
        switch (this._subtype) {
            case 0: {
                n = 54;
                break;
            }
            case 1: {
                n = 55;
                break;
            }
            case 2: {
                n = 56;
                break;
            }
            case 3: {
                n = 57;
                break;
            }
            case 4: {
                n = 58;
                break;
            }
            case 7: {
                n = 59;
                break;
            }
            case 8: {
                n = 60;
                break;
            }
            case 9: {
                n = 61;
            }
        }
        if (this._crt_anim != n) {
            this.SetCrtAnim(n);
        }
    }

    private void SetSellAnim() {
    }

    private void SetDieAnim() {
        int n = 0;
        switch (this._subtype) {
            case 0: {
                n = 33;
                break;
            }
            case 1: {
                n = 34;
                break;
            }
            case 2: {
                n = 35;
                break;
            }
            case 3: {
                n = 36;
                break;
            }
            case 4: {
                n = 37;
                break;
            }
            case 5: {
                n = 38;
                break;
            }
            case 6: {
                n = 39;
                break;
            }
            case 7: {
                n = 40;
                break;
            }
            case 8: {
                n = 41;
                break;
            }
            case 9: {
                n = 42;
            }
        }
        if (this._crt_anim != n) {
            this.SetCrtAnim(n);
        }
    }

    private void SetFireAnim() {
        int n = 17;
        switch (this._subtype) {
            case 5: {
                n = 17;
                break;
            }
            case 6: {
                n = 25;
            }
        }
        if (this._crt_anim != n + this._orientation) {
            this.SetCrtAnim(n + this._orientation);
        }
    }

    static void __ANIMS() {
    }

    public boolean PrismTowerForceFire(int n) {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        Entity entity2 = Level.GetEntitySafe(this._prismFriendlyTarget);
        if (this._firingTimer >= this._fire_rate - 9 + 1 && (entity == null || this._targetPointer == -1) && entity2 == null) {
            this._state = 1;
            this.SetStayAnim();
            this.SetBox();
            this._prismFriendlyTarget = n;
            this._prismTowerCharge = true;
            this._prismTowerPowerAnim = 0;
            this._firingTimer = this._fire_rate - 9 + 1;
            this._prismTowers = 1;
            return true;
        }
        return false;
    }
}

