/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.GameImpl;
import com.ea.game.Level;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.io.IOException;
import java.util.Random;

public class Utils
implements Constants {
    public static byte[] _versorX = new byte[]{0, 1, 1, 1, 0, -1, -1, -1};
    public static byte[] _versorY = new byte[]{-1, -1, 0, 1, 1, 1, 0, -1};
    public static int[] _rgbData;
    public static int _rgbData_OldColor;
    public static int _rgbData_OldW;
    static int[] _rect;
    static Random _rand;
    public static long _randomSeed;
    static SDKString _temp_string;
    static int[] _qsort_w_array;
    static int[] _qsort_other_array;
    private static int _snow_state;
    private static int _snow_particles;
    private static int[] _snow_pos_x;
    private static int[] _snow_pos_y;
    private static int[] _snow_spd_x;
    private static int[] _snow_spd_y;
    private static int[] _snow_time;
    public static SDKString _numbersString;
    public static SDKString _separatedNumbersString;
    public static int _old_number;
    public static int _old_number1;
    public static int _old_number2;
    public static int _old_minSize;
    public static int _fadeCounter;
    public static boolean _darkFade;
    public static int _fadeSteps;
    public static boolean _fadeIn;

    static void FillRect(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = _rgbData.length / n4;
        if (n6 == 0) {
            return;
        }
        if (n6 > n5) {
            n6 = n5;
        }
        int n7 = n6 * n4;
        if (_rgbData_OldColor != n || _rgbData_OldW != n4) {
            _rgbData_OldColor = n;
            _rgbData_OldW = n4;
            Utils.MemSet(_rgbData, n, n7);
        }
        int n8 = 0;
        while (n8 + n6 < n5) {
            sDKGraphics.drawRGB(_rgbData, 0, n4, n2, n3 + n8, n4, n6, true);
            n8 += n6;
        }
        sDKGraphics.drawRGB(_rgbData, 0, n4, n2, n3 + n8, n4, n5 - n8, true);
    }

    public static void ResetRect(int[] nArray) {
        nArray[0] = 1024;
        nArray[1] = 1024;
        nArray[2] = -1024;
        nArray[3] = -1024;
    }

    public static int[] Rect(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n + n3;
        nArray[3] = n2 + n4;
        return nArray;
    }

    public static int[] Rect(int[] nArray, int[] nArray2) {
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        nArray[2] = nArray2[2];
        nArray[3] = nArray2[3];
        return nArray;
    }

    public static void RectUnion(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[0] = Math.min(nArray2[0], nArray3[0]);
        nArray[1] = Math.min(nArray2[1], nArray3[1]);
        nArray[2] = Math.max(nArray2[2], nArray3[2]);
        nArray[3] = Math.max(nArray2[3], nArray3[3]);
    }

    public static void RectExpand(int[] nArray, int[] nArray2, int n) {
        nArray[0] = nArray2[0] - n;
        nArray[1] = nArray2[1] - n;
        nArray[2] = nArray2[2] + n;
        nArray[3] = nArray2[3] + n;
    }

    public static boolean PointInRect(int[] nArray, int n, int n2) {
        return n >= nArray[0] && n2 >= nArray[1] && n <= nArray[2] && n2 <= nArray[3];
    }

    public static void RectIntersect(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[0] = Math.max(nArray2[0], nArray3[0]);
        nArray[1] = Math.max(nArray2[1], nArray3[1]);
        nArray[2] = Math.min(nArray2[2], nArray3[2]);
        nArray[3] = Math.min(nArray2[3], nArray3[3]);
    }

    public static boolean RectIntersect(int[] nArray, int[] nArray2) {
        int n = Math.max(nArray[0], nArray2[0]);
        int n2 = Math.max(nArray[1], nArray2[1]);
        int n3 = Math.min(nArray[2], nArray2[2]);
        int n4 = Math.min(nArray[3], nArray2[3]);
        if (n > n3) {
            return false;
        }
        return n2 <= n4;
    }

    public static void RectDraw(int[] nArray, boolean bl, int n, SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(n);
        if (bl) {
            sDKGraphics.drawRect(nArray[0] - Camera._nCamX, nArray[1] - Camera._nCamY, nArray[2] - nArray[0], nArray[3] - nArray[1]);
        } else {
            sDKGraphics.drawRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    public static void RectFill(int[] nArray, boolean bl, int n, SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(n);
        if (bl) {
            sDKGraphics.fillRect(nArray[0] - Camera._nCamX, nArray[1] - Camera._nCamY, nArray[2] - nArray[0], nArray[3] - nArray[1]);
        } else {
            sDKGraphics.fillRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    public static void RectFill(int[] nArray, int n, SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(n);
        sDKGraphics.fillRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
    }

    public static boolean IsRectNotVisible(int[] nArray) {
        return nArray[2] - Camera._nCamX < GameImpl.SV_X + 10 || nArray[0] - Camera._nCamX > GameImpl.SV_X + GameImpl.SV_W - 10 || nArray[3] - Camera._nCamY < GameImpl.SV_Y + 10 || nArray[1] - Camera._nCamY > GameImpl.SV_Y + GameImpl.SV_H - 10;
    }

    public static final int randomInt() {
        _randomSeed = _randomSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(_randomSeed >>> 16);
    }

    public static final int random(int n) {
        return Math.abs(Utils.randomInt()) % n;
    }

    public static int random(int n, int n2) {
        return n + Math.abs(Utils.randomInt()) % (n2 - n);
    }

    public static void setSeed(long l) {
        _randomSeed = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public static void MemSet(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 > 0) {
            nArray[0] = n;
        }
        for (int i = 1; i < n2; i += i) {
            System.arraycopy(nArray, 0, nArray, i, n2 - i < i ? n2 - i : i);
        }
    }

    public static void MemSet(int[] nArray, int n, int n2) {
        if (n2 > 0) {
            nArray[0] = n;
        }
        for (int i = 1; i < n2; i += i) {
            System.arraycopy(nArray, 0, nArray, i, n2 - i < i ? n2 - i : i);
        }
    }

    public static void MemSet(short[] sArray, short s) {
        int n = sArray.length;
        if (n > 0) {
            sArray[0] = s;
        }
        for (int i = 1; i < n; i += i) {
            System.arraycopy(sArray, 0, sArray, i, n - i < i ? n - i : i);
        }
    }

    public static void MemSet(byte[] byArray, byte by) {
        int n = byArray.length;
        if (n > 0) {
            byArray[0] = by;
        }
        for (int i = 1; i < n; i += i) {
            System.arraycopy(byArray, 0, byArray, i, n - i < i ? n - i : i);
        }
    }

    public static void DumpArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 16 && i < byArray.length; ++j, ++i) {
                String string = Integer.toHexString(byArray[i] & 0xFF);
                if (string.length() == 1) {
                    System.err.print("0" + string + " ");
                    continue;
                }
                System.err.print(string + " ");
            }
            System.err.println();
        }
    }

    public static SDKImage LoadImageWithPalette(byte[] byArray, byte[] byArray2) {
        SDKImage sDKImage = null;
        System.arraycopy(byArray2, 0, byArray, 41, byArray2.length);
        try {
            sDKImage = SDKUtils.createImage(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadImageWithPalette:", exception);
        }
        return sDKImage;
    }

    public static byte[] ReadByteArray(SDKInputStream sDKInputStream, int n, byte[] byArray, int n2) throws IOException {
        if (n > 0) {
            if (byArray == null) {
                byArray = new byte[n];
            }
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)sDKInputStream.read();
            }
        }
        return byArray;
    }

    public static short[] ReadShortArray(SDKInputStream sDKInputStream, int n, short[] sArray, int n2) throws IOException {
        if (n > 0) {
            if (sArray == null) {
                sArray = new short[n];
            }
            for (int i = n2; i < n; ++i) {
                sArray[i] = sDKInputStream.readShort();
            }
        }
        return sArray;
    }

    public static int[] ReadIntArray(SDKInputStream sDKInputStream, int n, int[] nArray, int n2) throws IOException {
        if (n > 0) {
            if (nArray == null) {
                nArray = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                nArray[i] = sDKInputStream.read() & 0xFF | (sDKInputStream.read() & 0xFF) << 8 | (sDKInputStream.read() & 0xFF) << 16 | (sDKInputStream.read() & 0xFF) << 24;
            }
        }
        return nArray;
    }

    public static void DrawString(int n, int n2, int n3, int n4) {
        SDKUtils.drawString(SDKUtils.getString(n, GameImpl._string), n2, n3, n4);
    }

    public static void QuickSort(int[] nArray, int[] nArray2, int n, int n2) {
        _qsort_w_array = nArray;
        _qsort_other_array = nArray2;
        Utils.QuickSort(n, n2);
    }

    public static void QuickSort(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = n;
        int n4 = _qsort_w_array[n3];
        Utils.QuickSort_SwitchValues(n3, n2);
        n3 = n;
        for (int i = n; i < n2; ++i) {
            if (_qsort_w_array[i] > n4) continue;
            Utils.QuickSort_SwitchValues(n3, i);
            ++n3;
        }
        Utils.QuickSort_SwitchValues(n3, n2);
        Utils.QuickSort(n, n3 - 1);
        Utils.QuickSort(n3 + 1, n2);
    }

    public static void QuickSort_SwitchValues(int n, int n2) {
        int n3 = _qsort_w_array[n];
        Utils._qsort_w_array[n] = _qsort_w_array[n2];
        Utils._qsort_w_array[n2] = n3;
        if (_qsort_other_array != null) {
            n3 = _qsort_other_array[n];
            Utils._qsort_other_array[n] = _qsort_other_array[n2];
            Utils._qsort_other_array[n2] = n3;
        }
    }

    public static long Sqrt(long l) {
        long l2;
        if (l == 0L) {
            return 0L;
        }
        long l3 = l2 = 1L + l >> 1;
        long l4;
        long l5;
        while ((l5 = Math.abs((l4 = l2 + l / l2 >> 1) - l2)) < l3) {
            l3 = l5;
            l2 = l4;
        }
        return l2;
    }

    public static long Ln(long l) {
        if (l == 0L) {
            return 0L;
        }
        long l2 = Utils.Sqrt(l);
        long l3 = (6L * (l - 1L) << 16) / (l + 1L + 4L * l2);
        return l3 >> 10;
    }

    public static void DrawLightningBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8) {
        if (n6 < n5) {
            sDKGraphics.setColor(n7);
            sDKGraphics.drawLine(GameImpl.SV_X + (n >> 6) - Camera._nCamX, GameImpl.SV_Y + (n2 >> 6) - Camera._nCamY, GameImpl.SV_X + (n3 >> 6) - Camera._nCamX, GameImpl.SV_Y + (n4 >> 6) - Camera._nCamY);
            sDKGraphics.setColor(n8);
            if (n3 >= n) {
                sDKGraphics.drawLine(GameImpl.SV_X + (n >> 6) - Camera._nCamX + 1, GameImpl.SV_Y + (n2 >> 6) - Camera._nCamY - 1, GameImpl.SV_X + (n3 >> 6) - Camera._nCamX + 1, GameImpl.SV_Y + (n4 >> 6) - Camera._nCamY - 1);
                sDKGraphics.drawLine(GameImpl.SV_X + (n >> 6) - Camera._nCamX - 1, GameImpl.SV_Y + (n2 >> 6) - Camera._nCamY + 1, GameImpl.SV_X + (n3 >> 6) - Camera._nCamX - 1, GameImpl.SV_Y + (n4 >> 6) - Camera._nCamY + 1);
            } else {
                sDKGraphics.drawLine(GameImpl.SV_X + (n >> 6) - Camera._nCamX + 1, GameImpl.SV_Y + (n2 >> 6) - Camera._nCamY + 1, GameImpl.SV_X + (n3 >> 6) - Camera._nCamX + 1, GameImpl.SV_Y + (n4 >> 6) - Camera._nCamY + 1);
                sDKGraphics.drawLine(GameImpl.SV_X + (n >> 6) - Camera._nCamX - 1, GameImpl.SV_Y + (n2 >> 6) - Camera._nCamY - 1, GameImpl.SV_X + (n3 >> 6) - Camera._nCamX - 1, GameImpl.SV_Y + (n4 >> 6) - Camera._nCamY - 1);
            }
        } else {
            int n9 = n3 + n >> 1;
            int n10 = n4 + n2 >> 1;
            int n11 = Utils.random(0, 12);
            n9 += (n11 - 6) * n6;
            n11 = Utils.random(0, 12);
            n10 = bl ? (n10 -= Math.abs(n11 - 6) * n6) : (n10 += (n11 - 6) * n6);
            Utils.DrawLightningBolt(sDKGraphics, n, n2, n9, n10, n5, n6 >> 1, bl, n7, n8);
            Utils.DrawLightningBolt(sDKGraphics, n3, n4, n9, n10, n5, n6 >> 1, bl, n7, n8);
            n11 = Utils.random(0, 12);
            if (n11 > 3) {
                Utils.DrawLightningBolt(sDKGraphics, n3, n4, n9, n10, n5, n6 >> 1, bl, n7, n8);
            }
            if (n11 > 9) {
                Utils.DrawLightningBolt(sDKGraphics, n3, n4, n9, n10, n5, n6 >> 1, bl, n7, n8);
            }
        }
    }

    public static void DrawNarrowBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 < n5) {
            sDKGraphics.setColor(n7);
            sDKGraphics.drawLine((n >> 6) - Camera._nCamX, (n2 >> 6) - Camera._nCamY, (n3 >> 6) - Camera._nCamX, (n4 >> 6) - Camera._nCamY);
        } else {
            int n8 = n3 + n >> 1;
            int n9 = n4 + n2 >> 1;
            int n10 = Utils.random(0, 12);
            n8 += (n10 - 6) * n6;
            n10 = Utils.random(0, 12);
            Utils.DrawNarrowBolt(sDKGraphics, n, n2, n8, n9 += (n10 - 6) * n6, n5, n6 >> 1, n7);
            Utils.DrawNarrowBolt(sDKGraphics, n3, n4, n8, n9, n5, n6 >> 1, n7);
        }
    }

    public static void DrawChargedBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        int n5 = Utils.random(n3 >> 2, n3);
        int n6 = Utils.random(n3 >> 2, n3);
        Utils.DrawNarrowBolt(sDKGraphics, n - (n5 << 6), n2 - (n6 << 6), n + (n5 << 6), n2 + (n6 << 6), 16, 64, n4);
        Utils.DrawNarrowBolt(sDKGraphics, n - (n5 << 6), n2 + (n6 << 6), n + (n5 << 6), n2 - (n6 << 6), 16, 64, n4);
    }

    public static void DrawCrossBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        int n5 = Utils.random(n3 >> 2, n3);
        Utils.DrawNarrowBolt(sDKGraphics, n - (n5 << 6), n2, n + (n5 << 6), n2, 2, 48, n4);
        Utils.DrawNarrowBolt(sDKGraphics, n, n2 + (n5 << 6), n, n2 - (n5 << 6), 2, 48, n4);
    }

    static void SnowSetState(int n) {
        _snow_state = n;
    }

    static void SnowInit() {
        _snow_pos_x = new int[100];
        _snow_pos_y = new int[100];
        _snow_spd_x = new int[100];
        _snow_spd_y = new int[100];
        _snow_time = new int[100];
        _snow_state = 1;
        _snow_particles = 0;
        for (int i = 0; i < _snow_particles; ++i) {
            Utils.SnowInitParticle(i);
        }
    }

    static void SnowClean() {
        _snow_particles = 0;
        _snow_state = 0;
    }

    static void SnowInitParticle(int n) {
        Utils._snow_pos_x[n] = Utils.random(0, GameImpl.SCR_W << 16);
        Utils._snow_pos_y[n] = Utils.random(0, GameImpl.SCR_H << 16);
        Utils._snow_spd_x[n] = Utils.random(-65536, 65536);
        Utils._snow_spd_y[n] = Utils.random(8192, 131072);
        Utils._snow_time[n] = Utils.random(50, 100);
    }

    static void SnowRelease() {
        _snow_pos_x = null;
        _snow_pos_y = null;
        _snow_spd_x = null;
        _snow_spd_y = null;
        _snow_time = null;
        _snow_particles = 0;
        _snow_state = 0;
    }

    static void SnowUpdate() {
        if (_snow_state == 0) {
            return;
        }
        if (_snow_state == 1) {
            if (_snow_particles == 100) {
                _snow_state = 2;
            } else {
                Utils.SnowInitParticle(_snow_particles);
                ++_snow_particles;
            }
        }
        for (int i = 0; i < _snow_particles; ++i) {
            int n;
            int n2 = _snow_spd_x[i] + Utils.random(-16384, 16384);
            if (n2 < -65536) {
                n2 = -65536;
            }
            if (n2 > 65536) {
                n2 = 65536;
            }
            if ((n = _snow_spd_y[i] + Utils.random(-1024, 1024)) < 8192) {
                n = 8192;
            }
            if (n > 131072) {
                n = 131072;
            }
            int n3 = i;
            _snow_pos_x[n3] = _snow_pos_x[n3] + n2;
            int n4 = i;
            _snow_pos_y[n4] = _snow_pos_y[n4] + n;
            Utils._snow_spd_x[i] = n2;
            Utils._snow_spd_y[i] = n;
            int n5 = i;
            _snow_time[n5] = _snow_time[n5] - 1;
            if (_snow_time[i] > 0 && _snow_pos_y[i] <= GameImpl.SCR_H << 16) continue;
            if (_snow_state == 3) {
                if (--_snow_particles == 0) {
                    _snow_state = 0;
                    continue;
                }
                Utils._snow_pos_x[i] = _snow_pos_x[_snow_particles];
                Utils._snow_pos_y[i] = _snow_pos_y[_snow_particles];
                Utils._snow_spd_x[i] = _snow_spd_x[_snow_particles];
                Utils._snow_spd_y[i] = _snow_spd_y[_snow_particles];
                Utils._snow_time[i] = _snow_time[_snow_particles];
                continue;
            }
            Utils.SnowInitParticle(i);
        }
    }

    static void SnowDraw(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(-1);
        for (int i = 0; i < _snow_particles; ++i) {
            int n;
            int n2;
            for (n2 = (_snow_pos_x[i] >> 16) - Camera._nCamX; n2 > GameImpl.SCR_W; n2 -= GameImpl.SCR_W) {
            }
            while (n2 < 0) {
                n2 += GameImpl.SCR_W;
            }
            for (n = (_snow_pos_y[i] >> 16) - Camera._nCamY; n > GameImpl.SCR_H; n -= GameImpl.SCR_H) {
            }
            while (n < 0) {
                n += GameImpl.SCR_H;
            }
            if (_snow_time[i] < 10 || _snow_time[i] > 90) {
                sDKGraphics.fillRect(n2, n, 1, 1);
                continue;
            }
            sDKGraphics.fillRect(n2, n, 2, 2);
        }
    }

    public static void DrawNumber(int n, int n2, int n3, int n4) {
        if (_old_number != n) {
            _old_number = n;
            _numbersString.setLength(0);
            _numbersString = Utils.AppendNumber(_numbersString, n, 0);
        }
        SDKUtils.drawString(_numbersString, n2, n3, n4);
    }

    public static void DrawSeparatedNumbers(int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (_old_number1 != n || _old_number2 != n2 || _old_minSize != n6) {
            _old_number1 = n;
            _old_number2 = n2;
            _old_minSize = n6;
            _separatedNumbersString.setLength(0);
            _separatedNumbersString = Utils.AppendNumber(_separatedNumbersString, n, 0);
            _separatedNumbersString.append(string);
            _separatedNumbersString = Utils.AppendNumber(_separatedNumbersString, n2, n6);
        }
        SDKUtils.drawString(_separatedNumbersString, n3, n4, n5);
    }

    public static SDKString ConcatNumber(SDKString sDKString, int n, int n2) {
        if (GameImpl._language == 1 && n > 999 && n2 == 0) {
            sDKString = Utils.ConcatNumber(sDKString, n / 1000, 0);
            sDKString = sDKString.concat(" ");
            n %= 1000;
            n2 = 3;
        }
        if (n2 == 3 & n < 100) {
            sDKString = sDKString.concat(0);
            --n2;
        }
        if (n2 == 2 && n < 10) {
            sDKString = sDKString.concat(0);
            --n2;
        }
        sDKString = sDKString.concat(n);
        return sDKString;
    }

    public static SDKString AppendNumber(SDKString sDKString, int n, int n2) {
        if (GameImpl._language == 1 && n > 999 && n2 == 0) {
            sDKString = Utils.AppendNumber(sDKString, n / 1000, 0);
            sDKString = sDKString.append(" ");
            n %= 1000;
            n2 = 3;
        }
        if (n2 == 3 & n < 100) {
            sDKString = sDKString.append(0);
            --n2;
        }
        if (n2 == 2 && n < 10) {
            sDKString = sDKString.append(0);
            --n2;
        }
        sDKString = sDKString.append(n);
        return sDKString;
    }

    public static int GetInitialSpeed(int n, int n2) {
        return n2 * n / 2;
    }

    public static int GetOrientation2(int n, int n2, int n3) {
        int n4 = n;
        int n5 = -n2 + n3;
        if (Math.abs(n4) <= 5 && Math.abs(n5) <= 5) {
            return 16;
        }
        int n6 = (int)Math.sqrt(n4 * n4 + n5 * n5 << 12);
        int n7 = Math.abs((n4 << 12) / n6);
        int n8 = Math.abs((n5 << 12) / n6);
        if (n4 <= 0 && n5 > 0) {
            if (n7 <= 4) {
                return 0;
            }
            if (n7 <= 32) {
                return 1;
            }
            if (n7 > 32 && n8 > 32) {
                return 2;
            }
            if (n8 >= 4) {
                return 3;
            }
            return 4;
        }
        if (n4 < 0 && n5 <= 0) {
            if (n7 <= 4) {
                return 8;
            }
            if (n7 <= 32) {
                return 7;
            }
            if (n7 > 32 && n8 > 32) {
                return 6;
            }
            if (n8 >= 4) {
                return 5;
            }
            return 4;
        }
        if (n4 >= 0 && n5 < 0) {
            if (n7 <= 4) {
                return 8;
            }
            if (n7 <= 32) {
                return 9;
            }
            if (n7 > 32 && n8 > 32) {
                return 10;
            }
            if (n8 >= 4) {
                return 11;
            }
            return 12;
        }
        if (n7 <= 4) {
            return 0;
        }
        if (n7 <= 32) {
            return 15;
        }
        if (n7 > 32 && n8 > 32) {
            return 14;
        }
        if (n8 >= 4) {
            return 13;
        }
        return 12;
    }

    public static void Clear_Fade() {
        _fadeCounter = 0;
        _darkFade = false;
        _fadeSteps = 20;
        _fadeIn = false;
    }

    public static void Fade(boolean bl, int n, boolean bl2) {
        if (Level._skipMovieState == 2) {
            return;
        }
        _darkFade = bl2;
        _fadeIn = bl;
        _fadeSteps = n;
        _fadeCounter = bl ? 0 : _fadeSteps;
    }

    public static void Update_FadeIn() {
        if (++_fadeCounter <= _fadeSteps) {
            ++_fadeCounter;
        }
    }

    public static void Update_FadeOut() {
        if (--_fadeCounter > 0) {
            --_fadeCounter;
        }
    }

    public static void Update_Fade() {
        if (_fadeIn) {
            Utils.Update_FadeIn();
        } else {
            Utils.Update_FadeOut();
        }
    }

    public static void Draw_Fade(SDKGraphics sDKGraphics) {
        if (_fadeCounter <= 0) {
            return;
        }
        int n = GameImpl.SCR_H / 2 / _fadeSteps * _fadeCounter;
        sDKGraphics.setColor(_darkFade ? -16777216 : -1);
        sDKGraphics.fillRect(0, 0, GameImpl.SCR_W, n);
        sDKGraphics.fillRect(0, GameImpl.SCR_H - n, GameImpl.SCR_W, n);
    }

    static {
        _rgbData_OldColor = 0;
        _rgbData_OldW = 0;
        _rect = new int[4];
        _rand = new Random();
        _randomSeed = 0L;
        _temp_string = new SDKString("");
        _qsort_w_array = null;
        _qsort_other_array = null;
        _numbersString = new SDKString(64, 1);
        _separatedNumbersString = new SDKString(64, 1);
        _old_number = -1;
        _old_number1 = -1;
        _old_number2 = -1;
        _old_minSize = -1;
        _darkFade = false;
        _fadeSteps = 20;
        _fadeIn = false;
    }
}

