/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.GameImpl;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;

public class XSprite
implements Constants {
    static int _op;
    static int[] _rect;
    static SDKGraphics _g;
    static final int[] _midp2_transform;
    public static final int MAX_PALETTES = 4;
    public static final int F_CACHE_PALETTE_MASK = 15;
    public static final int F_USED = 128;
    public static final int F_LOADED = 256;
    public static final int F_SOVIET = 1024;
    public static final int F_ALLIED = 2048;
    int _flags;
    int _modules;
    short[] _modules_x;
    short[] _modules_y;
    byte[] _modules_w;
    byte[] _modules_h;
    int _frames;
    short[] _frames_fm_offset;
    int _fmodules;
    short[] _fmodules_ox;
    short[] _fmodules_oy;
    byte[] _fmodules_id;
    byte[] _fmodules_flags;
    int _animations;
    short[] _animations_af_offset;
    int _aframes;
    byte[] _aframes_id;
    byte[] _aframes_time;
    int _crt_pal;
    SDKImage[] _images;

    static void SetGraphics(SDKGraphics sDKGraphics) {
        _g = sDKGraphics;
    }

    static SDKGraphics GetGraphics() {
        return _g;
    }

    XSprite(int n) {
        this._flags = n;
    }

    void Release() {
        this._modules_x = null;
        this._modules_y = null;
        this._modules_w = null;
        this._modules_h = null;
        this._frames_fm_offset = null;
        this._fmodules_ox = null;
        this._fmodules_oy = null;
        this._fmodules_id = null;
        this._fmodules_flags = null;
        this._animations_af_offset = null;
        this._aframes_id = null;
        this._aframes_time = null;
        this._images = null;
        this._flags &= 0xFFFFFEF0;
    }

    private static int CombineFlags(int n, int n2) {
        if ((n & 4) == 0) {
            return n ^ n2;
        }
        if ((n2 & 1) != 0) {
            n ^= 2;
        }
        if ((n2 & 2) != 0) {
            n ^= 1;
        }
        if ((n2 & 4) != 0) {
            n ^= 7;
        }
        return n;
    }

    void DrawAnimFrame(int n, int n2, int n3, int n4, int n5) {
        int n6 = this._animations_af_offset[n] + n2;
        this.DrawFrame(this._aframes_id[n6] & 0xFF, n3, n4, XSprite.CombineFlags(0, n5));
    }

    void DrawFrame(int n, int n2, int n3, int n4, int n5) {
        this.RectFrame(n, 0, 0, n4);
        int n6 = (n5 & 2) != 0 ? _rect[2] : ((n5 & 1) != 0 ? _rect[0] + _rect[2] >> 1 : _rect[0]);
        int n7 = (n5 & 0x20) != 0 ? _rect[3] : ((n5 & 0x10) != 0 ? _rect[1] + _rect[3] >> 1 : _rect[1]);
        this.DrawFrame(n, n2 - n6, n3 - n7, n4);
    }

    void DrawFrame(int n, int n2, int n3, int n4) {
        int n5 = this._frames_fm_offset[n + 1] - this._frames_fm_offset[n];
        for (int i = 0; i < n5; ++i) {
            this.DrawFrameModule(n, i, n2, n3, n4);
        }
    }

    private void DrawFrameModule(int n, int n2, int n3, int n4, int n5) {
        int n6 = this._frames_fm_offset[n] + n2;
        int n7 = this._fmodules_ox[n6];
        int n8 = this._fmodules_oy[n6];
        int n9 = this._fmodules_id[n6] & 0xFF;
        int n10 = this._fmodules_flags[n6] & 0xFF;
        if ((n5 & 7) != 0) {
            int n11 = 0;
            int n12 = 0;
            if ((n10 & 4) == 0) {
                n11 = this._modules_w[n9] & 0xFF;
                n12 = this._modules_h[n9] & 0xFF;
            } else {
                n11 = this._modules_h[n9] & 0xFF;
                n12 = this._modules_w[n9] & 0xFF;
            }
            if ((n5 & 1) != 0) {
                n7 = -n7 - n11;
            }
            if ((n5 & 2) != 0) {
                n8 = -n8 - n12;
            }
            if ((n5 & 4) != 0) {
                int n13 = n7;
                n7 = -n8 - n12;
                n8 = n13;
            }
            n10 = XSprite.CombineFlags(n10, n5);
        }
        this.DrawModule(n9, n3 + n7, n4 + n8, n10);
    }

    void DrawModule(int n, int n2, int n3, int n4) {
        n4 &= 7;
        if (_op == 0) {
            if (this._images == null) {
                return;
            }
            SDKImage sDKImage = this._images[this._crt_pal];
            _g.drawRegion(sDKImage, this._modules_x[n] & 0xFF, this._modules_y[n] & 0xFF, this._modules_w[n] & 0xFF, this._modules_h[n] & 0xFF, _midp2_transform[n4], n2, n3, 20);
        } else if (_op == 2) {
            int n5 = this._modules_w[n] & 0xFF;
            int n6 = this._modules_h[n] & 0xFF;
            if ((n4 & 4) != 0) {
                int n7 = n5;
                n5 = n6;
                n6 = n7;
            }
            GameImpl.RectUnion(_rect, _rect, GameImpl.Rect(GameImpl._rect, n2, n3, n5, n6));
        }
    }

    public void LoadData(SDKInputStream sDKInputStream) {
        try {
            int n;
            int n2 = sDKInputStream.read();
            this._modules = sDKInputStream.readShort() & 0xFFFF;
            this._modules_x = GameImpl.ReadShortArray(sDKInputStream, this._modules, null, 0);
            this._modules_y = GameImpl.ReadShortArray(sDKInputStream, this._modules, null, 0);
            this._modules_w = GameImpl.ReadByteArray(sDKInputStream, this._modules, null, 0);
            this._modules_h = GameImpl.ReadByteArray(sDKInputStream, this._modules, null, 0);
            this._frames = sDKInputStream.readShort() & 0xFFFF;
            this._frames_fm_offset = new short[this._frames + 1];
            this._frames_fm_offset[0] = 0;
            int n3 = 0;
            for (n = 1; n <= this._frames; ++n) {
                this._frames_fm_offset[n] = (short)(n3 += sDKInputStream.read() & 0xFF);
            }
            this._fmodules = sDKInputStream.readShort() & 0xFFFF;
            this._fmodules_ox = GameImpl.ReadShortArray(sDKInputStream, this._fmodules, null, 0);
            this._fmodules_oy = GameImpl.ReadShortArray(sDKInputStream, this._fmodules, null, 0);
            this._fmodules_id = GameImpl.ReadByteArray(sDKInputStream, this._fmodules, null, 0);
            this._fmodules_flags = GameImpl.ReadByteArray(sDKInputStream, this._fmodules, null, 0);
            this._animations = sDKInputStream.readShort() & 0xFFFF;
            this._animations_af_offset = new short[this._animations + 1];
            this._animations_af_offset[0] = 0;
            n = 0;
            for (int i = 1; i <= this._animations; ++i) {
                this._animations_af_offset[i] = (short)(n += sDKInputStream.read() & 0xFF);
            }
            this._aframes = sDKInputStream.readShort() & 0xFFFF;
            sDKInputStream.skip(this._aframes);
            sDKInputStream.skip(this._aframes);
            this._aframes_id = GameImpl.ReadByteArray(sDKInputStream, this._aframes, null, 0);
            this._aframes_time = GameImpl.ReadByteArray(sDKInputStream, this._aframes, null, 0);
            sDKInputStream.skip(this._aframes);
            this._flags |= 0x100;
        }
        catch (Exception exception) {
            Debug.CatchException("XSprite::LoadData", exception);
        }
    }

    int[] RectFrame(int n, int n2, int n3, int n4) {
        GameImpl.Rect(_rect, 0x40000000, 0x40000000, -1073741824, -1073741824);
        int n5 = _op;
        _op = 2;
        this.DrawFrame(n, n2, n3, n4);
        _op = n5;
        return _rect;
    }

    int GetAnimLength(int n) {
        return this._animations_af_offset[n + 1] - this._animations_af_offset[n];
    }

    int GetAnimFrameTime(int n, int n2) {
        return this._aframes_time[this._animations_af_offset[n] + n2] & 0xFF;
    }

    int GetAnimFrameId(int n, int n2) {
        return this._aframes_id[this._animations_af_offset[n] + n2] & 0xFF;
    }

    int GetCurFrameInAnim(int n, int n2) {
        return this._aframes_id[this._animations_af_offset[n] + n2];
    }

    void SetCurrentPalette(int n) {
        this._crt_pal = n;
    }

    static {
        _rect = new int[4];
        _midp2_transform = new int[]{0, 2, 1, 3, 5, 7, 4, 6};
    }
}

