/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Building
extends Entity
implements Constants,
BuildingConstants,
SpriteConstants {
    int[] _collisionBox;
    byte _subtype;
    byte _allegiance;
    byte _faction;
    byte _spawn_dx;
    byte _spawn_dy;
    byte _spawn_orientation;
    short _spawn_unit_types;
    long _timer_last_hit;
    long _timer_last_repair;
    short _life;
    short _initial_life;
    boolean _bCanFire;
    boolean _bNeedsPower;
    int _fire_range;
    int _fire_rate;
    int _damage;
    int _armour;
    int _bullet_type;
    int _targetPointer;
    boolean _bTargeted;
    boolean _noticed;
    byte _prismTowerPowerAnim;
    boolean _prismTowerCharge;
    int _prismFriendlyTarget = -1;
    byte _prismTowers;
    int _firingTimer;

    public Building(int n) {
        super(n);
        this.Clean();
    }

    public void Clean() {
        this._id = 0;
        this._subtype = (byte)-1;
        this._allegiance = 0;
        this._spawn_dx = 0;
        this._spawn_dy = 0;
        this._spawn_orientation = 0;
        this._spawn_unit_types = 0;
        this._life = 0;
        this._initial_life = 0;
        this._bCanFire = false;
        this._bNeedsPower = false;
        this._fire_range = 0;
        this._fire_rate = 0;
        this._damage = 0;
        this._armour = 0;
        this._bullet_type = 0;
        this._targetPointer = -1;
        this._bTargeted = false;
        this._type = 6;
        if (this._collisionBox == null) {
            this._collisionBox = new int[4];
        } else {
            this._collisionBox[0] = 0;
            this._collisionBox[1] = 0;
            this._collisionBox[2] = 0;
            this._collisionBox[3] = 0;
        }
        this._noticed = false;
        this._prismTowerPowerAnim = 0;
        this._prismTowerCharge = false;
        this._prismFriendlyTarget = -1;
        this._firingTimer = 0;
        this._flags = 0;
    }

    public void Building_Destructor() {
        this.ApplyCreep(false);
        this.EraseCollision();
        Level.RefreshCreep(0);
        Level.RefreshCreep(1);
    }

    public void Building_Load(SDKInputStream sDKInputStream) throws IOException {
        this._subtype = (byte)(sDKInputStream.read() & 0xFF);
        this._allegiance = (byte)(sDKInputStream.read() & 0xFF);
        this._faction = (byte)(sDKInputStream.read() & 0xFF);
    }

    public void Building_Init() {
        this._z_order = 2;
        this._flags |= 0x10000;
        this._sprite = this._faction == 0 ? 0 : 11;
        int n = this._faction * 8;
        int n2 = Level.GetCMapHeaderData(n + this._subtype, 0);
        int n3 = Level.GetCMapHeaderData(n + this._subtype, 1);
        int n4 = (this._pos_x + n2) / 8;
        int n5 = (this._pos_y + n3) / 8;
        this._pos_x = n4 * 8 - n2;
        this._pos_y = n5 * 8 - n3;
        short[] sArray = this._faction == 0 ? Level._building_stats_soviets : Level._building_stats_allied;
        int n6 = this._subtype * 20;
        this._spawn_dx = (byte)sArray[n6 + 0];
        this._spawn_dy = (byte)sArray[n6 + 1];
        this._spawn_orientation = (byte)sArray[n6 + 2];
        this._spawn_unit_types = sArray[n6 + 6];
        this._life = this._initial_life = sArray[n6 + 9];
        this._fire_range = sArray[n6 + 10];
        this._fire_rate = sArray[n6 + 11];
        this._damage = sArray[n6 + 12];
        this._armour = sArray[n6 + 13];
        this._bullet_type = sArray[n6 + 14];
        this._bCanFire = false;
        this._bNeedsPower = false;
        this._timer = 0;
        this._targetPointer = -1;
        this._bTargeted = false;
        short s = sArray[n6 + 16];
        switch (this._subtype) {
            case 5: {
                this._prismTowerPowerAnim = 0;
                this._prismTowerCharge = false;
                this._bCanFire = true;
                this._bNeedsPower = true;
                break;
            }
            case 1: {
                if (this._allegiance == 0) {
                    Level._player_power -= s;
                    break;
                }
                if (this._allegiance != 1) break;
                Level._ai_power -= s;
            }
        }
        if (this._allegiance == 0) {
            if (s > 0) {
                Level._player_consumption += s;
            }
        } else if (this._allegiance == 1 && s > 0) {
            Level._ai_consumption += s;
        }
        this._noticed = false;
    }

    public void Building_Init2() {
        Constants constants;
        this.ApplyCollision();
        this.ApplyCreep(true);
        if (this._subtype == 2) {
            this._targetPointer = -1;
            constants = Level.FindClosestMineralField(this._pos_x, this._pos_y, 64);
            if (constants != null) {
                this._targetPointer = constants.GetPointer();
            }
        }
        Level.IncEntityNo(6, this._subtype, this._allegiance);
        Hud.RefreshBuildMenuItems();
        this.SetState(0);
        this._prismTowerPowerAnim = 0;
        this._prismTowerCharge = false;
        this._prismFriendlyTarget = -1;
        this._firingTimer = 0;
        constants = GameImpl._sprites[this._sprite];
        this.SetPalette((XSprite)constants);
        if (this._allegiance == 0) {
            ++Level._player_build_points;
        }
        if (this._allegiance == 1) {
            ++Level._ai_build_points;
        }
        this.SetBox();
    }

    public void Building_Update() {
        if ((this._flags & 8) != 0) {
            return;
        }
        if (this._life < this._initial_life && GameImpl._canvas.getAppTime() - this._timer_last_hit > 8000L && GameImpl._canvas.getAppTime() - this._timer_last_repair > 2000L) {
            this._life = (short)Math.min(this._initial_life, this._life + 10);
            this._timer_last_repair = GameImpl._canvas.getAppTime();
        }
        if (this._subtype == 5 && this._firingTimer < this._fire_rate * 2) {
            ++this._firingTimer;
        }
        switch (this._state) {
            case 0: {
                this.DoStay();
                break;
            }
            case 1: {
                this.DoFire();
                break;
            }
            case 2: {
                this.DoDie(false);
                break;
            }
            case 4: {
                this.DoDie(true);
                break;
            }
            case 3: {
                this.DoDemolish();
            }
        }
        if (this._sprite >= 0) {
            this.UpdateCrtAnim();
        }
    }

    public void Building_Draw(SDKGraphics sDKGraphics) {
        if ((this._flags & 0x10) != 0) {
            return;
        }
        XSprite xSprite = GameImpl._sprites[this._sprite];
        this.SetPalette(xSprite);
        if (this._state == 3) {
            if (this._timer % 3 != 0) {
                this.DrawCrtAnim(sDKGraphics);
            }
        } else {
            this.DrawCrtAnim(sDKGraphics);
        }
    }

    public void Building_DrawDetails(SDKGraphics sDKGraphics) {
        if (this._bTargeted && this._subtype == 5) {
            int n = this._pos_x - Camera._nCamX + 0;
            int n2 = this._pos_y - Camera._nCamY + 38;
            Hud.Build_Draw_Range(sDKGraphics, this._subtype, n, n2);
        }
        this.Building_Draw_LifeName(sDKGraphics);
    }

    public void Building_Draw_LifeName(SDKGraphics sDKGraphics) {
        if (this._bTargeted || this._life < this._initial_life || Level._buildings_off_times[this._allegiance][this._subtype] > 0 || this._subtype != 0 && !Level.HasPower(this._allegiance)) {
            this.DrawLife(sDKGraphics);
        }
        if (this._bTargeted) {
            this.DrawName(sDKGraphics);
        }
        this._bTargeted = false;
    }

    private void SetPalette(XSprite xSprite) {
        int n = 0;
        xSprite.SetCurrentPalette(n);
    }

    public int GetUsedPalette() {
        int n = 1;
        return n;
    }

    private void DrawLife(SDKGraphics sDKGraphics) {
        boolean bl;
        boolean bl2 = Level._buildings_off_times[this._allegiance][this._subtype] > 0;
        boolean bl3 = bl = !bl2 && this._subtype != 0 && !Level.HasPower(this._allegiance);
        if (bl && GameImpl._frameCounter / 3 % 2 == 0) {
            return;
        }
        int n = this._pos_x - 20;
        if (n < 0) {
            n = 0;
        } else if (n + 40 > Level._map_w) {
            n = Level._map_w - 40 - 1;
        }
        n += 0 - Camera._nCamX;
        int n2 = this._collisionBox[1] - 4 - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        n2 += 38 - Camera._nCamY;
        int n3 = this._life;
        if (this._state == 3) {
            n3 = this._initial_life * (10 - this._timer) / 10;
        }
        int n4 = 0xFFFF00;
        if (this._allegiance == 0) {
            n4 = 65280;
        } else if (this._allegiance == 1) {
            n4 = 0xFF0000;
        }
        sDKGraphics.setColor(n4);
        if (this._initial_life != 0 || bl) {
            if (bl2) {
                sDKGraphics.setColor(0x404040);
            }
            sDKGraphics.fillRect(n, n2, n3 * 40 / this._initial_life, 4);
        }
        sDKGraphics.setColor(n4);
        sDKGraphics.drawRect(n, n2, 40, 4);
        if (Level._buildings_off_times[this._allegiance][this._subtype] > 0) {
            SDKUtils.setFont(GameImpl.fonts[0]);
            GameImpl.DrawNumber(Level._buildings_off_times[this._allegiance][this._subtype] / 14, n + (n3 * 40 / this._initial_life >> 1), n2, 33);
        }
    }

    private void DrawName(SDKGraphics sDKGraphics) {
        int n = this._pos_x;
        int n2 = this._collisionBox[1];
        if (n - 45 < 0) {
            n = 45;
        }
        if (n + 45 > Level._map_w) {
            n = Level._map_w - 45;
        }
        if (n2 - 4 - 1 < 0) {
            n2 = 5;
        }
        this._tooltipTxt = 32 + this._faction * 8 + this._subtype;
        Entity._descr_string = SDKUtils.getString(this._tooltipTxt, Entity._descr_string);
        SDKUtils.setFont(GameImpl.fonts[0]);
        Entity._txtDescrStringLines = SDKUtils.wrapString(Entity._descr_string, Entity._txtDescrStringLines, 90, (short)124);
        SDKUtils.drawWrappedString(Entity._descr_string, Entity._txtDescrStringLines, 1, Entity._txtDescrStringLines[0], n += -Camera._nCamX + 0, n2 += 1 - Camera._nCamY + 38, 1);
    }

    public boolean IsSelectable(boolean bl) {
        if (this._life <= 0) {
            return false;
        }
        if (bl) {
            if (this._allegiance == 0) {
                if (Hud._hud_state == 2 && Hud._hud_substate == 5) {
                    return true;
                }
                switch (this._subtype) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        if (this._allegiance == 1 && (this._flags & 0x8000) != 0) {
            return false;
        }
        return (this._flags & 0x400) == 0;
    }

    public void SetBox() {
        this._collisionBox = GameImpl.Rect(this._collisionBox, this.ComputeBoundingBox());
    }

    public void SpawnNewUnit(int n) {
        if ((1 << n & this._spawn_unit_types) == 0) {
            return;
        }
        int n2 = this._pos_x + this._spawn_dx;
        int n3 = this._pos_y + this._spawn_dy;
        if (Level.GetCollisionAt(n2, n3) > 4) {
            int n4 = n2 / 8;
            int n5 = n3 / 8;
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 >= Level._coll_map_tw) {
                n4 = Level._coll_map_tw - 1;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 >= Level._coll_map_th) {
                n5 = Level._coll_map_th - 1;
            }
            if (!Level.ValidateCollisionTile(n4, n5, 8)) {
                return;
            }
            n2 = Level._validTileX * 8 + 4;
            n3 = Level._validTileY * 8 + 4;
        }
        Unit unit = null;
        unit = this._allegiance == 0 ? Level.SpawnUnit(n, n2, n3, this._allegiance, this._spawn_orientation, (byte)Hud._hud_current_squad) : Level.SpawnUnit(n, n2, n3, this._allegiance, this._spawn_orientation, (byte)0);
        if (unit != null) {
            if (this._allegiance == 0) {
                Level._player_money -= Level.GetUnitStats(n, 10);
                Level._statistics[2] = Level._statistics[2] + 1;
            } else if (this._allegiance == 1) {
                Level._ai_money -= Level.GetUnitStats(n, 10);
                Level._statistics[3] = Level._statistics[3] + 1;
            }
        }
    }

    public void ApplyCollision() {
        int n = 0;
        if (this._faction == 1) {
            n = 8;
        }
        Level.ApplyCollisionMap(this._pos_x, this._pos_y, n + this._subtype);
    }

    public void EraseCollision() {
        int n = 0;
        if (this._subtype == 2) {
            n = 6;
        }
        int n2 = 0;
        if (this._faction == 1) {
            n2 = 8;
        }
        Level.EraseCollisionMap(this._pos_x, this._pos_y, n2 + this._subtype, n);
    }

    public void ApplyCreep(boolean bl) {
        int n = this._pos_x / 8;
        int n2 = this._pos_y / 8;
        int n3 = Level.GetBuildingStats(this._faction, this._subtype, 8);
        int n4 = 1 + this._allegiance;
        if (!bl) {
            n4 = 0;
        }
        for (int i = n2 - n3; i < n2 + n3; ++i) {
            for (int j = n - n3; j < n + n3; ++j) {
                if (Level.GetCollisionAtTile(j, i) > 4) continue;
                Level.SetCollisionAtTile(j, i, n4);
            }
        }
    }

    public void SellBuilding() {
        this.SetState(4);
    }

    public void Building_TakeDamage(int n, int n2, int n3) {
        if (this._allegiance != 0) {
            this._noticed = true;
        } else if (GameImpl.IsCheatActive(3)) {
            return;
        }
        n *= Unit._units_damage_matrix[n2][this._armour];
        n >>= 6;
        if (this._life > 0) {
            this._life = (short)(this._life - n);
            this._timer_last_hit = GameImpl._canvas.getAppTime();
            this._timer_last_repair = GameImpl._canvas.getAppTime();
            Entity entity = Level.GetEntitySafe(n3);
            if (entity != null && entity._type == 5) {
                Unit unit = (Unit)entity;
                unit.ReceiveExperience(this._life, n, this._faction, 6, this._subtype);
            }
            if (this._life <= 0) {
                this._life = 0;
                this.SetState(2);
            }
        }
    }

    public void StartAttack(Entity entity) {
        if (this._life <= 0) {
            return;
        }
        if (this._bNeedsPower && (this._allegiance == 0 ? Level._player_consumption >= Level._player_power || Level._buildings_off_times[0][1] > 0 : this._allegiance == 1 && (Level._ai_consumption >= Level._ai_power || Level._buildings_off_times[1][1] > 0))) {
            return;
        }
        this._targetPointer = entity.GetPointer();
        this.SetState(1);
    }

    private void Fire() {
        if (this._subtype == 5 && this._faction == 1) {
            if (this._firingTimer > this._fire_rate - 9 + 1 && this._targetPointer != -1 && !this._prismTowerCharge) {
                if (this._prismTowerPowerAnim != 0) {
                    return;
                }
                this._prismTowers = 1;
                int n = Level.GetBulletStats(this._bullet_type, 3);
                n *= n;
                if (Level.GetEntityNo(6, 5, this._allegiance) > 1) {
                    for (int i = 24; i < 48; ++i) {
                        int n2;
                        if (Level._entities_usage[i] != 1) continue;
                        Building building = (Building)Level.GetEntityUnsafe(i);
                        if (building._subtype != 5 || building._faction != 1 || building._life <= 0 || building == this || building._allegiance != this._allegiance || (n2 = (building._pos_x - this._pos_x) * (building._pos_x - this._pos_x) + (building._pos_y - this._pos_y) * (building._pos_y - this._pos_y)) >= n || !building.PrismTowerForceFire(this.GetPointer())) continue;
                        this._prismTowers = (byte)(this._prismTowers + 1);
                    }
                }
                this._firingTimer = this._fire_rate - 9 + 1;
                this._prismTowerCharge = true;
            } else if (this._firingTimer > this._fire_rate) {
                if ((this._flags & 0x4000) == 0) {
                    this._firingTimer = 0;
                    this._prismTowerCharge = false;
                    this.SetFireAnim();
                    if (this._targetPointer != -1) {
                        this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
                    } else if (this._prismFriendlyTarget != -1) {
                        this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._prismFriendlyTarget, this._pos_x, this._pos_y);
                    }
                    this._prismFriendlyTarget = -1;
                }
            } else if (this.IsCrtAnimEnded()) {
                this.SetStayAnim();
            }
        } else if (this._firingTimer > this._fire_rate) {
            if ((this._flags & 0x4000) == 0) {
                this._firingTimer = 0;
                this.SetFireAnim();
                this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
            }
        } else if (this.IsCrtAnimEnded()) {
            this.SetStayAnim();
        }
    }

    public void ChangeAllegiance(int n) {
        if (this._allegiance == n) {
            return;
        }
        Level.DecEntityNo(6, this._subtype, this._allegiance);
        Level.IncEntityNo(6, this._subtype, n);
        Hud.RefreshBuildMenuItems();
        if (this._allegiance == 0) {
            --Level._player_build_points;
        }
        if (this._allegiance == 1) {
            --Level._ai_build_points;
        }
        int n2 = Level.GetBuildingStats(this._faction, this._subtype, 16);
        if (this._subtype == 1) {
            if (this._allegiance == 0) {
                Level._player_power += n2;
            } else if (this._allegiance == 1) {
                Level._ai_power += n2;
            }
        }
        if (this._allegiance == 0) {
            if (n2 > 0) {
                Level._player_consumption -= n2;
            }
        } else if (this._allegiance == 1 && n2 > 0) {
            Level._ai_consumption -= n2;
        }
        this.ApplyCreep(false);
        this._allegiance = (byte)n;
        if (this._allegiance == 0) {
            if (n2 > 0) {
                Level._player_consumption += n2;
            }
            if (this._subtype == 1) {
                if (this._allegiance == 0) {
                    Level._player_power -= n2;
                } else if (this._allegiance == 1) {
                    Level._ai_power -= n2;
                }
            }
            this.ApplyCreep(true);
        } else if (this._allegiance == 1 && n2 > 0) {
            Level._ai_consumption += n2;
        }
        if (this._allegiance == 0) {
            ++Level._player_build_points;
        }
        if (this._allegiance == 1) {
            ++Level._ai_build_points;
        }
    }

    public static void DrawHudFrame(int n, int n2, int n3, int n4) {
        XSprite xSprite = n2 == 0 ? GameImpl._sprites[0] : GameImpl._sprites[11];
        xSprite.DrawFrame(8 + n, n3, n4, 0);
    }

    static void STATES__() {
    }

    public void SetState(int n) {
        if (this._state == n) {
            return;
        }
        switch (this._state) {
            case 0: {
                break;
            }
            case 1: {
                this._prismTowerCharge = false;
                break;
            }
            case 2: {
                break;
            }
        }
        this._z_order = 2;
        this._flags &= 0xFFFFF7FF;
        switch (n) {
            case 0: {
                this._timer = 0;
                this.SetStayAnim();
                break;
            }
            case 1: {
                this._timer = 0;
                this.SetStayAnim();
                break;
            }
            case 4: {
                this._flags |= 0x800;
                Level.DecEntityNo(6, this._subtype, this._allegiance);
                if (this._allegiance == 0) {
                    --Level._player_build_points;
                }
                if (this._allegiance != 1) break;
                --Level._ai_build_points;
                break;
            }
            case 2: {
                this._z_order = 3;
                this._flags |= 0x800;
                if (this._life > 0) {
                    this._life = 0;
                }
                Level.DecEntityNo(6, this._subtype, this._allegiance);
                if (this._allegiance == 0) {
                    --Level._player_build_points;
                }
                if (this._allegiance == 1) {
                    --Level._ai_build_points;
                }
                int n2 = 4;
                Entity entity = Level.SpawnEntity(2);
                entity.Decorator_Init(this._pos_x, this._pos_y, 5, n2, 512, 4);
                break;
            }
            case 3: {
                this._timer = 0;
                this.SetStayAnim();
            }
        }
        this._state = n;
    }

    private void DoStay() {
        this.EvaluateStaySituation();
        if (this._subtype == 2) {
            if (this._allegiance != 2 && Level._buildings_off_times[this._allegiance][this._subtype] <= 0) {
                Entity entity;
                ++this._timer;
                if (this._timer > 32 && (entity = Level.GetEntitySafe(this._targetPointer)) != null) {
                    this._timer = 0;
                    int n = entity.MField_ExtractMoney(100);
                    if (!Level.HasPower(this._allegiance)) {
                        n >>= 1;
                    }
                    if (this._allegiance == 0) {
                        Level._player_money += n;
                    } else if (this._allegiance == 1) {
                        Level._ai_money += n;
                    }
                }
            }
        } else if (this._subtype == 5 && this._faction == 0) {
            int n;
            if (this._allegiance == 0) {
                n = Level._player_power - Level._player_consumption;
            } else if (this._allegiance == 1) {
                n = Level._ai_power - Level._ai_consumption;
            } else {
                return;
            }
            if (n <= 0 || Level._buildings_off_times[this._allegiance][1] > 0) {
                if (this._crt_anim != 5) {
                    this.SetCrtAnim(5);
                }
            } else if (this._crt_anim != 5) {
                this.SetCrtAnim(5);
            }
        } else if (this._subtype == 5 && this._faction == 1) {
            int n;
            if (this._allegiance == 0) {
                n = Level._player_power - Level._player_consumption;
            } else if (this._allegiance == 1) {
                n = Level._ai_power - Level._ai_consumption;
            } else {
                return;
            }
            if (n <= 0 || Level._buildings_off_times[this._allegiance][1] > 0) {
                this._prismTowerPowerAnim = (byte)-1;
                if (this._crt_anim != 5) {
                    this.SetCrtAnim(5);
                }
            } else {
                if (this._prismTowerPowerAnim == -1) {
                    this._prismTowerPowerAnim = 0;
                }
                if (this._crt_anim != 5) {
                    this.SetCrtAnim(5);
                }
            }
        }
    }

    private void DoFire() {
        byte by;
        if (this.EvaluateFireSituation()) {
            return;
        }
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (this._prismFriendlyTarget != -1) {
            entity = Level.GetEntitySafe(this._prismFriendlyTarget);
        }
        if (entity == null) {
            return;
        }
        int n = entity._pos_x - this._pos_x;
        int n2 = entity._pos_y - this._pos_y;
        this._orientation = by = this.GetOrientation(n, n2);
        this.Fire();
    }

    private void DoDie(boolean bl) {
        if (this.IsCrtAnimEnded()) {
            int n;
            int n2 = Level.GetBuildingStats(this._faction, this._subtype, 16);
            if (this._subtype == 1) {
                if (this._allegiance == 0) {
                    Level._player_power += n2;
                } else if (this._allegiance == 1) {
                    Level._ai_power += n2;
                }
            }
            if (this._allegiance == 0) {
                if (n2 > 0) {
                    Level._player_consumption -= n2;
                }
                if ((n = Level.GetEntityNo(6, this._subtype, this._allegiance)) == 0) {
                    Hud.RefreshBuildMenuItems();
                }
                if (!bl) {
                    Level._statistics[5] = Level._statistics[5] + 1;
                }
            } else if (this._allegiance == 1) {
                if (n2 > 0) {
                    Level._ai_consumption -= n2;
                }
                if (!bl) {
                    Level._statistics[4] = Level._statistics[4] + 1;
                }
            }
            if (bl) {
                n = Level.GetBuildingStats(this._faction, this._subtype, 15) * 65 / 100;
                if (this._allegiance == 0) {
                    Level._player_money += n;
                } else if (this._allegiance == 1) {
                    Level._ai_money += n;
                }
            }
            Level.CDB_AddInvalidateRegion(this._collisionBox);
            Level.DeleteEntity(this);
            GameImpl.Vibrate(500);
        }
    }

    private void DoDemolish() {
        ++this._timer;
        if (this._timer > 10) {
            this.SetState(2);
        }
    }

    private void EvaluateStaySituation() {
        if (!this._bCanFire) {
            return;
        }
        --this._timer;
        if (this._timer < 0) {
            Entity entity;
            this._timer = 8;
            if ((this._flags & 0x4000) == 0 && (entity = this.FindTarget(this._allegiance, this._fire_range, this._fire_range, -1, 10)) != null) {
                this.StartAttack(entity);
            }
        }
    }

    private boolean EvaluateFireSituation() {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (this._bNeedsPower && !Level.HasPower(this._allegiance)) {
            this._timer = 0;
            this._firingTimer = 0;
            this._targetPointer = -1;
            this.SetState(0);
            return true;
        }
        if (entity == null || entity.GetLife() <= 0) {
            if (this._subtype == 5 && this._faction == 1 && this._prismFriendlyTarget != -1) {
                return false;
            }
            this._timer = 0;
            this._targetPointer = -1;
            if (this.IsCrtAnimEnded()) {
                this.SetState(0);
            }
            return true;
        }
        int n = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y);
        if (n > this._fire_range) {
            this._timer = 0;
            this._targetPointer = -1;
            this.SetState(0);
            return true;
        }
        return false;
    }

    static void __STATES() {
    }

    static void ANIMS__() {
    }

    public void SetStayAnim() {
        int n = 0;
        switch (this._subtype) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            case 7: {
                n = 7;
            }
        }
        if (this._crt_anim != n) {
            this.SetCrtAnim(n);
        }
    }

    private void SetFireAnim() {
        this.SetStayAnim();
    }

    static void __ANIMS() {
    }

    public boolean PrismTowerForceFire(int n) {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        Entity entity2 = Level.GetEntitySafe(this._prismFriendlyTarget);
        if (this._firingTimer >= this._fire_rate - 9 + 1 && (entity == null || this._targetPointer == -1) && entity2 == null) {
            if (this._prismTowerPowerAnim == -1) {
                return false;
            }
            this._state = 1;
            this.SetStayAnim();
            this._prismFriendlyTarget = n;
            this._prismTowerCharge = true;
            this._prismTowerPowerAnim = 0;
            this._firingTimer = this._fire_rate - 9 + 1;
            this._prismTowers = 1;
            return true;
        }
        return false;
    }
}

