/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.ScriptConstants;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Script
implements Constants,
ScriptConstants,
UnitsConstants,
SpriteConstants,
GraphicsConstants,
BuildingConstants {
    static short[][] _scripts;
    static short[][] _scriptInstances;
    static int _nrScripts;
    static short[] _memory;
    static int _first_script_file;
    static int _last_script_file;
    static String _debug_depth;
    public static int _AI_timer;
    public static int[][] _AI_groups;
    public static int _AI_script_instance;
    public static boolean _AI_defend;
    public static boolean _AI_run_script;
    public static int[] _AI_sw_cooldown;

    public static void Scripts_Init(int n) {
        if (n == -1) {
            _first_script_file = 0;
            _last_script_file = -1;
            return;
        }
        _first_script_file = Level.GetLevelStats(n, 11);
        _last_script_file = Level.GetLevelStats(n, 12);
        _scriptInstances = new short[10][9];
        _nrScripts = 0;
        _scripts = new short[25][];
        for (int i = 0; i < 10; ++i) {
            short[] sArray = _scriptInstances[i];
            sArray[2] = 0;
            sArray[0] = -1;
        }
        _memory = new short[128];
    }

    public static void Scripts_Release() {
        int n;
        Script.Scripts_Clean();
        if (_scripts != null) {
            for (n = 0; n < _nrScripts; ++n) {
                Script._scripts[n] = null;
            }
        }
        _nrScripts = 0;
        if (_scriptInstances != null) {
            for (n = 0; n < 10; ++n) {
                Script._scriptInstances[n] = null;
            }
            _scriptInstances = null;
        }
        _scripts = null;
        _memory = null;
        System.gc();
    }

    public static void Scripts_Clean() {
        if (_scriptInstances != null) {
            for (int i = 0; i < 10; ++i) {
                short[] sArray = _scriptInstances[i];
                if (sArray == null) continue;
                sArray[2] = 0;
                sArray[0] = -1;
            }
        }
        System.gc();
    }

    public static void LoadScripts(int n) {
        int n2 = _first_script_file + n;
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n2);
            int n3 = sDKInputStream.available() >> 1;
            Script.LoadScript(sDKInputStream, n, n3);
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
            ++n2;
        }
        catch (Exception exception) {
            Debug.CatchException("IO exception while loading script", exception);
        }
    }

    public static void LoadScript(SDKInputStream sDKInputStream, int n, int n2) throws IOException {
        Script._scripts[n] = new short[n2 + 1];
        short[] sArray = Script._scripts[n];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = sDKInputStream.readShort();
        }
        sArray[n2] = -1;
    }

    public static void KillScripts(int n) {
        if (_scriptInstances != null) {
            for (int i = 0; i < 10; ++i) {
                if (_scriptInstances[i][0] != n) continue;
                Script.KillScript(i);
            }
        }
    }

    public static void PauseScripts(int n) {
        if (_scriptInstances != null) {
            for (int i = 0; i < 10; ++i) {
                short[] sArray = _scriptInstances[i];
                if (sArray[0] != n) continue;
                sArray[2] = 2;
            }
        }
    }

    public static void ResumeScripts(int n) {
        if (_scriptInstances != null) {
            for (int i = 0; i < 10; ++i) {
                short[] sArray = _scriptInstances[i];
                if (sArray[0] != n) continue;
                sArray[2] = 1;
            }
        }
    }

    public static void KillScript(int n) {
        if (_scriptInstances != null) {
            short[] sArray = _scriptInstances[n];
            sArray[2] = 0;
            sArray[0] = -1;
        }
    }

    public static void PauseScript(int n) {
        if (_scriptInstances != null) {
            Script._scriptInstances[n][2] = 2;
        }
    }

    public static void ResumeScript(int n) {
        if (_scriptInstances != null) {
            Script._scriptInstances[n][2] = 1;
        }
    }

    public static int StartScript(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            return -1;
        }
        int n6 = Script.GetScriptSource(n);
        return Script.StartScript(n, n6, n2, n3, n4, n5);
    }

    public static int StartAIScript(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            return -1;
        }
        int n6 = Script.GetScriptSource(n);
        int n7 = Script.StartScript(n, n6, n2, n3, n4, n5);
        Script._scriptInstances[n7][2] = 4;
        return n7;
    }

    public static int StartScript(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Script.GetFreeSlot();
        if (n7 >= 0 && n2 >= 0) {
            Script._scriptInstances[n7][0] = (short)n;
            Script._scriptInstances[n7][1] = (short)n2;
            Script._scriptInstances[n7][2] = 1;
            Script._scriptInstances[n7][3] = 1;
            Script._scriptInstances[n7][4] = 0;
            Script._scriptInstances[n7][5] = (short)n3;
            Script._scriptInstances[n7][6] = (short)n4;
            Script._scriptInstances[n7][7] = (short)n5;
            Script._scriptInstances[n7][8] = (short)n6;
        }
        return n7;
    }

    static String GetInstructionName(int n) {
        switch (n) {
            case 0: {
                return "BLOCK";
            }
            case 1: {
                return "IF";
            }
            case 2: {
                return "WHILE";
            }
            case 10: {
                return "SET_ANIM";
            }
            case 11: {
                return "SET_ANIM_FRAME";
            }
            case 12: {
                return "SET_POSITION";
            }
            case 13: {
                return "SPAWN_ENTITY";
            }
            case 14: {
                return "KILL_ENTITY";
            }
            case 15: {
                return "FOLLOW_ENTITY";
            }
            case 16: {
                return "CENTER_TO";
            }
            case 17: {
                return "IS_ANIM_ENDED";
            }
            case 19: {
                return "SET_FLAGS";
            }
            case 20: {
                return "RESET_FLAGS";
            }
            case 21: {
                return "CAMERA_LINEAR_TO";
            }
            case 52: {
                return "BREAK";
            }
            case 31: {
                return "TEST_VARIABLE";
            }
            case 32: {
                return "SET_VARIABLE";
            }
            case 33: {
                return "TEST_REGISTERE";
            }
            case 34: {
                return "SET_REGISTER";
            }
            case 35: {
                return "TEST_STATE";
            }
            case 36: {
                return "SET_STATE";
            }
            case 37: {
                return "ADD_REGISTER";
            }
            case 38: {
                return "SAVE_VARIABLE";
            }
            case 39: {
                return "SAVE_STATE";
            }
            case 40: {
                return "WAIT";
            }
            case 41: {
                return "START_SCRIPT";
            }
            case 42: {
                return "PLAY_SOUND";
            }
            case 44: {
                return "MOVIE_BARS";
            }
            case 45: {
                return "TEST_MEMORY";
            }
            case 46: {
                return "SET_MEMORY";
            }
            case 47: {
                return "SAVE_MEMORY";
            }
            case 48: {
                return "KILL_SCRIPTS";
            }
            case 50: {
                return "STOP_SOUND";
            }
            case 100: {
                return "SPAWN_UNIT";
            }
            case 101: {
                return "SELECT_UNITS";
            }
            case 102: {
                return "GROUP_UNITS";
            }
            case 103: {
                return "TEST_NR_UNITS";
            }
            case 104: {
                return "TEST_NR_BUILDINGS";
            }
            case 105: {
                return "TRAIN_UNIT";
            }
            case 106: {
                return "START_ATTACK";
            }
            case 107: {
                return "END_LEVEL";
            }
            case 108: {
                return "TEST_RANDOM";
            }
            case 109: {
                return "SET_CAMERA_TO";
            }
            case 110: {
                return "START_MOVE";
            }
            case 111: {
                return "SHOW_MESSAGE";
            }
            case 112: {
                return "START_CURSOR_TUTORIAL";
            }
            case 113: {
                return "START_MOVEMENT_TUTORIAL";
            }
            case 114: {
                return "START_ATTACK_TUTORIAL";
            }
            case 115: {
                return "START_BUILD_TUTORIAL";
            }
            case 116: {
                return "START_GROUP_TUTORIAL";
            }
            case 117: {
                return "START_TRAIN_TUTORIAL";
            }
            case 118: {
                return "START_SELECT_TUTORIAL";
            }
            case 120: {
                return "TEST_ACTIVE_TUTORIA";
            }
            case 121: {
                return "SET_ASSET_AVALABLE";
            }
            case 122: {
                return "END_TUTORIAL";
            }
            case 123: {
                return "TEST_BUILDING_OFFLINE";
            }
            case 124: {
                return "INCREASE_ENTITY_NO";
            }
            case 125: {
                return "DECREASE_ENTITY_NO";
            }
            case 126: {
                return "TEST_TRIGGER_STATE";
            }
            case 127: {
                return "SET_AI_DEFENSE";
            }
            case 128: {
                return "SET_AI_SCRIPTING";
            }
            case 129: {
                return "FIRE_SUPERWEAPON";
            }
            case 130: {
                return "TEST_FINISHED_TUTORIAL";
            }
            case 131: {
                return "SET_UNIT_ACTION";
            }
            case 132: {
                return "SET_UNIT_ANIM";
            }
            case 133: {
                return "SET_HULL_ANIM";
            }
            case 134: {
                return "SET_TURRET_ANIM";
            }
            case 135: {
                return "UNIT_FORCE_CRAWL";
            }
            case 136: {
                return "AISUPERWEAPON";
            }
            case 137: {
                return "START_SW_TUTORIAL";
            }
            case 139: {
                return "BUILD_STRUCTURE";
            }
            case 141: {
                return "SET_CAMERA_STATE";
            }
            case 142: {
                return "SET_TRIGGER_STATE";
            }
            case 143: {
                return "SET_GROUP_ACTION";
            }
            case 144: {
                return "TEST_AREA_UNITS";
            }
            case 145: {
                return "TEST_AREA_BUILDINGS";
            }
            case 146: {
                return "ADD_BRIEFING_MESSAGE";
            }
            case 147: {
                return "START_SNOW";
            }
            case 148: {
                return "STOP_SNOW";
            }
            case 149: {
                return "SET_CAMERA_SPEED";
            }
            case 153: {
                return "START_ATTACK_ENTITY_TUTORIAL";
            }
            case 154: {
                return "SPAWN_ANIMATED_DECORATOR";
            }
            case 155: {
                return "FADE_TO_DARK";
            }
            case 156: {
                return "FADE_TO_GAME";
            }
            case 157: {
                return "SET_ALLEGIANCE_FLAGS";
            }
            case 158: {
                return "RESET_ALLEGIANCE_FLAGS";
            }
        }
        return "UNKNOWN INSTRUCTION: id " + n;
    }

    static int ExecuteInstruction(int n, int n2, int n3) {
        short s = _scripts[n2][n3];
        switch (s) {
            case 0: {
                return Script.ExecBlock(n, n2, n3);
            }
            case 1: {
                return Script.ExecIf(n, n2, n3);
            }
            case 2: {
                return Script.ExecWhile(n, n2, n3);
            }
            case 10: {
                return Script.ExecSetAnim(n, n2, n3);
            }
            case 11: {
                return Script.ExecSetAnimFrame(n, n2, n3);
            }
            case 12: {
                return Script.ExecSetPosition(n, n2, n3);
            }
            case 13: {
                return Script.ExecSpawnEntity(n, n2, n3);
            }
            case 14: {
                return Script.ExecKillEntity(n, n2, n3);
            }
            case 15: {
                return Script.ExecFollowEntity(n, n2, n3);
            }
            case 16: {
                return Script.ExecCenterTo(n, n2, n3);
            }
            case 17: {
                return Script.ExecIsAnimEnded(n, n2, n3);
            }
            case 19: {
                return Script.ExecSetFlags(n, n2, n3);
            }
            case 20: {
                return Script.ExecResetFlags(n, n2, n3);
            }
            case 21: {
                return Script.ExecCameraLinearTo(n, n2, n3);
            }
            case 52: {
                return Script.ExecBreak(n, n2, n3);
            }
            case 31: {
                return Script.ExecTestVariable(n, n2, n3);
            }
            case 32: {
                return Script.ExecSetVariable(n, n2, n3);
            }
            case 33: {
                return Script.ExecTestRegister(n, n2, n3);
            }
            case 34: {
                return Script.ExecSetRegister(n, n2, n3);
            }
            case 35: {
                return Script.ExecTestState(n, n2, n3);
            }
            case 36: {
                return Script.ExecSetState(n, n2, n3);
            }
            case 37: {
                return Script.ExecAddRegister(n, n2, n3);
            }
            case 38: {
                return Script.ExecSaveVariable(n, n2, n3);
            }
            case 39: {
                return Script.ExecSaveState(n, n2, n3);
            }
            case 40: {
                return Script.ExecWait(n, n2, n3);
            }
            case 41: {
                return Script.ExecStartScript(n, n2, n3);
            }
            case 42: {
                return Script.ExecPlaySound(n, n2, n3);
            }
            case 44: {
                return Script.ExecMovieBars(n, n2, n3);
            }
            case 45: {
                return Script.ExecTestMemory(n, n2, n3);
            }
            case 46: {
                return Script.ExecSetMemory(n, n2, n3);
            }
            case 47: {
                return Script.ExecSaveMemory(n, n2, n3);
            }
            case 48: {
                return Script.ExecKillScripts(n, n2, n3);
            }
            case 50: {
                return Script.ExecStopSound(n, n2, n3);
            }
            case 100: {
                return Script.ExecSpawnUnit(n, n2, n3);
            }
            case 101: {
                return Script.ExecSelectUnits(n, n2, n3);
            }
            case 102: {
                return Script.ExecGroupUnits(n, n2, n3);
            }
            case 103: {
                return Script.ExecTestNrUnits(n, n2, n3);
            }
            case 104: {
                return Script.ExecTestNrBuildings(n, n2, n3);
            }
            case 105: {
                return Script.ExecTrainUnit(n, n2, n3);
            }
            case 106: {
                return Script.ExecStartAttack(n, n2, n3);
            }
            case 107: {
                return Script.ExecEndLevel(n, n2, n3);
            }
            case 108: {
                return Script.ExecTestRandom(n, n2, n3);
            }
            case 109: {
                return Script.ExecSetCameraTo(n, n2, n3);
            }
            case 110: {
                return Script.ExecStartMove(n, n2, n3);
            }
            case 111: {
                return Script.ExecShowMessage(n, n2, n3);
            }
            case 112: {
                return Script.ExecStartCursorTutorial(n, n2, n3);
            }
            case 113: {
                return Script.ExecStartMovementTutorial(n, n2, n3);
            }
            case 114: {
                return Script.ExecStartAttackTutorial(n, n2, n3);
            }
            case 115: {
                return Script.ExecStartBuildTutorial(n, n2, n3);
            }
            case 116: {
                return Script.ExecStartGroupTutorial(n, n2, n3);
            }
            case 117: {
                return Script.ExecStartTrainTutorial(n, n2, n3);
            }
            case 118: {
                return Script.ExecStartSelectTutorial(n, n2, n3);
            }
            case 120: {
                return Script.ExecTestActiveTutorial(n, n2, n3);
            }
            case 121: {
                return Script.ExecSetAssetAvailable(n, n2, n3);
            }
            case 122: {
                return Script.ExecEndTutorial(n, n2, n3);
            }
            case 123: {
                return Script.ExecTestBuildingOffline(n, n2, n3);
            }
            case 124: {
                return Script.ExecIncreaseEntityNo(n, n2, n3);
            }
            case 125: {
                return Script.ExecDecreaseEntityNo(n, n2, n3);
            }
            case 126: {
                return Script.ExecTestTriggerState(n, n2, n3);
            }
            case 127: {
                return Script.ExecSetAIDefense(n, n2, n3);
            }
            case 128: {
                return Script.ExecSetAIScripting(n, n2, n3);
            }
            case 129: {
                return Script.ExecFireSuperWeapon(n, n2, n3);
            }
            case 130: {
                return Script.ExecTestFinishedTutorial(n, n2, n3);
            }
            case 131: {
                return Script.ExecSetUnitAction(n, n2, n3);
            }
            case 132: {
                return Script.ExecSetUnitAnim(n, n2, n3);
            }
            case 133: {
                return Script.ExecSetHullAnim(n, n2, n3);
            }
            case 134: {
                return Script.ExecSetTurretAnim(n, n2, n3);
            }
            case 135: {
                return Script.ExecUnitForceCrawl(n, n2, n3);
            }
            case 136: {
                return Script.ExecAISuperWeapon(n, n2, n3);
            }
            case 137: {
                return Script.ExecStartSwTutorial(n, n2, n3);
            }
            case 139: {
                return Script.ExecBuildStructure(n, n2, n3);
            }
            case 141: {
                return Script.ExecSetCameraState(n, n2, n3);
            }
            case 142: {
                return Script.ExecSetTriggerState(n, n2, n3);
            }
            case 143: {
                return Script.ExecSetGroupAction(n, n2, n3);
            }
            case 144: {
                return Script.ExecTestAreaUnits(n, n2, n3);
            }
            case 145: {
                return Script.ExecTestAreaBuildings(n, n2, n3);
            }
            case 146: {
                return Script.ExecAddBriefingMessage(n, n2, n3);
            }
            case 147: {
                return Script.ExecStartSnow(n, n2, n3);
            }
            case 148: {
                return Script.ExecStopSnow(n, n2, n3);
            }
            case 149: {
                return Script.ExecSetCameraSpeed(n, n2, n3);
            }
            case 153: {
                return Script.ExecStartAttackEntityTutorial(n, n2, n3);
            }
            case 154: {
                return Script.ExecSpawnAnimatedDecorator(n, n2, n3);
            }
            case 155: {
                return Script.ExecFadeToDark(n, n2, n3);
            }
            case 156: {
                return Script.ExecFadeToGame(n, n2, n3);
            }
            case 157: {
                return Script.ExecSetAllegianceFlags(n, n2, n3);
            }
            case 158: {
                return Script.ExecResetAlligeanceFlags(n, n2, n3);
            }
        }
        return n3;
    }

    public static int RunScript(int n) {
        short s = _scriptInstances[n][3];
        if (s == -1) {
            Script.KillScript(n);
            return 0;
        }
        short s2 = _scriptInstances[n][1];
        short s3 = _scripts[s2][s];
        if (s3 == -1) {
            Script.KillScript(n);
            return 0;
        }
        Script._scriptInstances[n][3] = (short)Script.ExecuteInstruction(n, s2, s);
        return 1;
    }

    public static void RunEngine() {
        if (_scriptInstances != null) {
            for (int i = 0; i < 10; ++i) {
                if (_scriptInstances[i] == null || _scriptInstances[i][2] != 1) continue;
                Script.RunScript(i);
            }
        }
    }

    public static int GetFreeSlot() {
        for (int i = 0; i < 10; ++i) {
            if (_scriptInstances[i][2] != 0) continue;
            return i;
        }
        return -1;
    }

    public static int GetScriptSource(int n) {
        int n2 = -1;
        if (_scripts != null) {
            int n3 = _scripts.length;
            for (int i = 0; i < n3; ++i) {
                if (_scripts[i] == null || _scripts[i][0] != n) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    static int GetVariabile(int n, int n2, int n3) {
        n2 = Script.GetRegistryValue(n, n2);
        switch (n3) {
            case 1: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._state;
            }
            case 2: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._pos_x;
            }
            case 3: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._pos_y;
            }
            case 4: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._orientation;
            }
            case 5: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._crt_anim;
            }
            case 6: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._crt_aframe;
            }
            case 7: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 6) {
                    return ((Building)entity)._allegiance;
                }
                if (entity._type == 5) {
                    return ((Unit)entity)._allegiance;
                }
                return 2;
            }
            case 8: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 6) {
                    return ((Building)entity)._life;
                }
                if (entity._type == 5) {
                    return ((Unit)entity)._life;
                }
                return 0;
            }
            case 9: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null || entity._type != 5) break;
                return ((Unit)entity)._veterancy_lvl;
            }
            case 100: {
                return Level._player_money;
            }
            case 101: {
                return Level._player_power;
            }
            case 102: {
                return Level._player_power - Level._player_consumption;
            }
            case 103: {
                return Level._ai_money;
            }
            case 104: {
                return Level._ai_power;
            }
            case 105: {
                return Level._ai_power - Level._ai_consumption;
            }
            case 106: {
                return Level._level_timer / 1000;
            }
            case 107: {
                return Hud._hud_state;
            }
            case 108: {
                return Level._player_max_command_points;
            }
            case 109: {
                return Level._ai_max_command_points;
            }
            case 115: {
                return Level._ai_command_points;
            }
            case 116: {
                return Level._player_max_build_points;
            }
            case 117: {
                return Level._ai_max_build_points;
            }
            case 118: {
                return Level._enableChangeSK ? 1 : 0;
            }
            case 119: {
                return Level._enableSelectionChange ? 1 : 0;
            }
            case 110: {
                return Hud._sw_cooldown[0];
            }
            case 113: {
                return Hud._sw_cooldown[1];
            }
            case 111: {
                return Level._timeline_counter / 14;
            }
            case 112: {
                return Hud._event_timer / 14;
            }
            case 114: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._z_order;
            }
        }
        int n4 = Script.GetRegistryValue(n, n3);
        if (n4 == n3) {
            return 0;
        }
        return n4;
    }

    static void SetVariabile(int n, int n2, int n3, int n4) {
        n2 = Script.GetRegistryValue(n, n2);
        n3 = Script.GetRegistryValue(n, n3);
        n4 = Script.GetRegistryValue(n, n4);
        switch (n3) {
            case 1: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 5) {
                    ((Unit)entity).SetState(n4);
                    break;
                }
                if (entity._type == 6) {
                    ((Building)entity).SetState(n4);
                    break;
                }
                entity._state = n4;
                break;
            }
            case 2: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity.SetPosition(n4, entity._pos_y);
                break;
            }
            case 3: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity.SetPosition(entity._pos_x, n4);
                break;
            }
            case 4: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity._orientation = (byte)n4;
                break;
            }
            case 5: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity.SetCrtAnim(n4);
                break;
            }
            case 6: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity._crt_aframe = n4;
                break;
            }
            case 7: {
                short s;
                Entity entity;
                Entity entity2 = Level.GetEntityById(-1, n2);
                if (entity2 == null) break;
                if (entity2._type == 6) {
                    entity = (Building)entity2;
                    entity.ChangeAllegiance(n4);
                }
                if (entity2._type != 5) break;
                entity = (Unit)entity2;
                Level.DecEntityNo(5, ((Unit)entity)._subtype, ((Unit)entity)._allegiance);
                Level.IncEntityNo(5, ((Unit)entity)._subtype, n4);
                int n5 = -1;
                byte by = ((Unit)entity)._group;
                if (((Unit)entity)._allegiance == 0) {
                    --Level._player_command_points;
                    Level.Group_Remove((Unit)entity);
                }
                if (((Unit)entity)._allegiance == 1) {
                    --Level._ai_command_points;
                }
                if (((Unit)entity)._group > 0 && ((Unit)entity)._allegiance == 1 && _AI_groups[s = (short)((Unit)entity)._group][0] > 0) {
                    int[] nArray = _AI_groups[s];
                    nArray[0] = nArray[0] - 1;
                }
                s = ((Unit)entity)._life;
                ((Unit)entity)._life = 0;
                Entity.CheckTriggers((Unit)entity, entity._pos_x, entity._pos_y);
                ((Unit)entity)._allegiance = (byte)n4;
                if (((Unit)entity)._allegiance == 0) {
                    ++Level._player_command_points;
                    Level.Group_Add((Unit)entity, by);
                }
                if (((Unit)entity)._allegiance == 1) {
                    ++Level._ai_command_points;
                }
                ((Unit)entity)._life = s;
                Entity.CheckTriggers((Unit)entity, entity._pos_x, entity._pos_y);
                break;
            }
            case 8: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 6) {
                    ((Building)entity)._life = (short)n4;
                }
                if (entity._type != 5) break;
                ((Unit)entity)._life = (short)n4;
                break;
            }
            case 9: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null || entity._type != 5) break;
                ((Unit)entity)._veterancy_lvl = (byte)n4;
                break;
            }
            case 100: {
                Level._player_money = n4;
                break;
            }
            case 101: {
                Level._player_power = n4;
                break;
            }
            case 102: {
                Level._player_power = Level._player_consumption + n4;
                break;
            }
            case 103: {
                Level._ai_money = n4;
                break;
            }
            case 104: {
                Level._ai_power = n4;
                break;
            }
            case 105: {
                Level._ai_power = Level._ai_consumption + n4;
                break;
            }
            case 106: {
                Level._level_timer = n4 * 1000;
                break;
            }
            case 107: {
                Hud.ChangeState(n4, true);
                break;
            }
            case 108: {
                Level._player_max_command_points = n4;
                break;
            }
            case 109: {
                Level._ai_max_command_points = n4;
                break;
            }
            case 115: {
                Level._ai_command_points = n4;
                break;
            }
            case 116: {
                Level._player_max_build_points = n4;
                break;
            }
            case 117: {
                Level._ai_max_build_points = n4;
                break;
            }
            case 118: {
                Level._enableChangeSK = n4 != 0;
                break;
            }
            case 119: {
                Level._enableSelectionChange = n4 != 0;
                break;
            }
            case 110: {
                Hud._sw_cooldown[0] = n4;
                break;
            }
            case 113: {
                Hud._sw_cooldown[1] = n4;
            }
            case 111: {
                Level._timeline_counter = n4 * 14;
                break;
            }
            case 112: {
                Hud._event_timer = n4 * 14;
                break;
            }
            case 114: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity._z_order = n4;
                break;
            }
            case 15000: {
                Script._scriptInstances[n][5] = (short)n4;
                break;
            }
            case 15001: {
                Script._scriptInstances[n][6] = (short)n4;
                break;
            }
            case 15002: {
                Script._scriptInstances[n][7] = (short)n4;
                break;
            }
            case 15003: {
                Script._scriptInstances[n][8] = (short)n4;
            }
        }
    }

    static String GetVariabileName(int n) {
        switch (n) {
            case 1: {
                return "ENTITY_STATE";
            }
            case 2: {
                return "ENTITY_POS_X";
            }
            case 3: {
                return "ENTITY_POS_Y";
            }
            case 4: {
                return "ENTITY_ORIENTATION";
            }
            case 5: {
                return "ENTITY_ANIM";
            }
            case 6: {
                return "ENTITY_FRAME";
            }
            case 7: {
                return "ENTITY_ALLEGIACE";
            }
            case 8: {
                return "ENTITY_LIFE";
            }
            case 9: {
                return "UNIT_VETERANCY";
            }
            case 100: {
                return "UPLAYER_MONEY";
            }
            case 101: {
                return "PLAYER_POWER";
            }
            case 102: {
                return "PLAYER_FREE_POWER";
            }
            case 103: {
                return "AI_MONEY";
            }
            case 104: {
                return "AI_POWER";
            }
            case 105: {
                return "AI_FREE_POWER";
            }
            case 106: {
                return "TIMER";
            }
            case 107: {
                return "HUD_STATE";
            }
            case 108: {
                return "PLAYER_MAX_COMMAND_POINTS";
            }
            case 109: {
                return "AI_MAX_COMMAND_POINTS";
            }
            case 110: {
                return "PLAYER_NUKE_COOLDOWN";
            }
            case 113: {
                return "PLAYER_WEATHER_COOLDOWN";
            }
            case 111: {
                return "TIMELINE_SECONDS";
            }
            case 112: {
                return "EVENT_TIMER";
            }
            case 116: {
                return "PLAYER_MAX_BUILD_COMMAND_POINTS";
            }
            case 117: {
                return "AI_MAX_BUILD_COMMAND_POINTS";
            }
            case 118: {
                return "ENABLE_CHANGE_SK";
            }
            case 119: {
                return "ENABLE_SELECTION_CHANGE";
            }
        }
        return "UNKNOWN VARIABLE: " + n;
    }

    public static int GetRegistryValue(int n, int n2) {
        switch (n2) {
            case 15000: {
                return _scriptInstances[n][5];
            }
            case 15001: {
                return _scriptInstances[n][6];
            }
            case 15002: {
                return _scriptInstances[n][7];
            }
            case 15003: {
                return _scriptInstances[n][8];
            }
        }
        return n2;
    }

    static int SpawnEntity(int n, int n2, int n3) {
        Entity entity = null;
        entity = n2 >= 0 ? Level.SpawnEntity(n2) : Level.SpawnEntity(2);
        if (entity != null) {
            if (n3 >= 0) {
                entity._sprite = n3;
            }
            if (n >= 0) {
                entity._id = n;
            }
            if (n2 < 0) {
                entity._z_order = 4;
                entity._flags &= 0xFFFFFDFF;
                entity._flags &= 0xFFFFF7FF;
            }
            return entity._id;
        }
        return -1;
    }

    static void MASTER_AI__() {
    }

    static void AI_Init() {
        _AI_groups = new int[24][4];
        _AI_sw_cooldown = new int[2];
        Script.AI_Clean();
    }

    static void AI_Clean() {
        for (int i = 0; i < 24; ++i) {
            Script._AI_groups[i][0] = 0;
            Script._AI_groups[i][1] = 0;
            Script._AI_groups[i][2] = 0;
            Script._AI_groups[i][3] = -1;
        }
        _AI_timer = 0;
        _AI_script_instance = -1;
    }

    static void AI_Release() {
        if (_AI_groups != null) {
            for (int i = 0; i < 24; ++i) {
                Script._AI_groups[i] = null;
            }
            _AI_groups = null;
        }
        System.gc();
    }

    static void AI_Update() {
        ++_AI_timer;
        for (int i = 0; i < 2; ++i) {
            if (_AI_sw_cooldown[i] <= 0) continue;
            int n = i;
            _AI_sw_cooldown[n] = _AI_sw_cooldown[n] - 1;
        }
        if (_AI_timer >= 8) {
            Script.EvaluateSituation();
            if (_AI_script_instance >= 0 && _AI_run_script && _scriptInstances[_AI_script_instance] != null && _scriptInstances[_AI_script_instance][2] == 4) {
                Script.RunScript(_AI_script_instance);
            }
            _AI_timer = 0;
        }
    }

    static boolean EvaluateSituation() {
        int n;
        for (n = 0; n < 24; ++n) {
            if (_AI_groups[n][0] <= 0 || _AI_groups[n][2] <= 0) continue;
            Script._AI_groups[n][2] = 0;
        }
        if (_AI_defend) {
            Script.EvaluateDanger();
        }
        for (n = 0; n < 24; ++n) {
            if (Level._entities_usage[n] != 1) continue;
            Unit unit = (Unit)Level._entities[n];
            if (unit._group <= 0 || unit._allegiance != 1 || _AI_groups[unit._group][0] <= 0 || _AI_groups[unit._group][1] != 1 || unit._action != 1 || unit._targetPointer >= 0) continue;
            int[] nArray = _AI_groups[unit._group];
            nArray[2] = nArray[2] + 1;
            if (_AI_groups[unit._group][2] < _AI_groups[unit._group][0]) continue;
            if (_AI_groups[unit._group][3] > 0) {
                int n2 = Entity.Get_WayPoint(_AI_groups[unit._group][3]);
                if (n2 != -1) {
                    short s = Entity._wayPoints[n2 + 3];
                    if (s > 0) {
                        int n3 = Entity.Get_WayPoint(s);
                        if (n3 != -1) {
                            Script.Attack(unit._group, s, Entity._wayPoints[n3 + 1], Entity._wayPoints[n3 + 2], -1);
                            unit._requested_action = false;
                            continue;
                        }
                        Script._AI_groups[unit._group][1] = 0;
                        continue;
                    }
                    Script._AI_groups[unit._group][1] = 0;
                    continue;
                }
                Script._AI_groups[unit._group][1] = 0;
                continue;
            }
            Script._AI_groups[unit._group][1] = 0;
        }
        return false;
    }

    static void Attack(int n, int n2, int n3, int n4, int n5) {
        if (n > 0) {
            int n6;
            if (n2 > 0 && (n6 = Entity.Get_WayPoint(n2)) != -1) {
                n3 = Entity._wayPoints[n6 + 1];
                n4 = Entity._wayPoints[n6 + 2];
            }
            Level.GetCurrentGravCenter(n, 1);
            for (n6 = 0; n6 < 24; ++n6) {
                if (Level._entities_usage[n6] != 1) continue;
                Unit unit = (Unit)Level._entities[n6];
                if (unit._group != n || unit._allegiance != 1 || (unit._flags & 0x400) != 0 || n5 >= 0 && unit._action != n5) continue;
                int n7 = unit._pos_x - Level._gravity_center_X;
                int n8 = unit._pos_y - Level._gravity_center_Y;
                while (Math.abs(n7) + Math.abs(n8) > 50) {
                    n7 >>= 1;
                    n8 >>= 1;
                }
                unit.DoAction(2, -1, n7 + n3, n8 + n4);
                Script._AI_groups[unit._group][1] = 1;
                Script._AI_groups[unit._group][3] = n2;
            }
        }
    }

    static void EvaluateDanger() {
        int n;
        int n2;
        int n3;
        Entity entity;
        int n4;
        Entity entity2 = null;
        Entity entity3 = null;
        short s = -1;
        for (n4 = 0; n4 < 24; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            entity = (Unit)Level._entities[n4];
            if (entity._allegiance != 1 || !entity._noticed) continue;
            n3 = entity._subtype * 27;
            if (Level._unit_stats[n3 + 11] > s) {
                entity3 = entity;
            }
            entity._noticed = false;
        }
        s = -1;
        for (n4 = 24; n4 < 48; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            entity = (Building)Level._entities[n4];
            if (((Building)entity)._allegiance != 1 || !((Building)entity)._noticed) continue;
            if (Level.GetBuildingStats(((Building)entity)._faction, ((Building)entity)._subtype, 11) > s) {
                entity2 = entity;
            }
            ((Building)entity)._noticed = false;
        }
        if (entity2 != null) {
            Unit unit;
            n4 = entity2.GetPointer();
            int n5 = 0;
            n3 = 0;
            for (n2 = 0; n2 < 24; ++n2) {
                if (Level._entities_usage[n2] != 1) continue;
                unit = (Unit)Level._entities[n2];
                if (unit._allegiance != 0 || unit._targetPointer != n4) continue;
                n5 = unit._pos_x + entity2._pos_x >> 1;
                n3 = unit._pos_y + entity2._pos_y >> 1;
                break;
            }
            if (n5 != 0 && n3 != 0) {
                for (n2 = 0; n2 < 24; ++n2) {
                    if (Level._entities_usage[n2] != 1) continue;
                    unit = (Unit)Level._entities[n2];
                    if (unit._allegiance != 1 || unit._action != 1 || unit._targetPointer >= 0 || (unit._flags & 0x4000) != 0) continue;
                    int n6 = unit._pos_x - entity2._pos_x;
                    n = unit._pos_y - entity2._pos_y;
                    if (Math.abs(n6) + Math.abs(n) >= 360) continue;
                    if (unit._group > 0 && _AI_groups[unit._group][0] > 0) {
                        int[] nArray = _AI_groups[unit._group];
                        nArray[0] = nArray[0] - 1;
                    }
                    int[] nArray = _AI_groups[23];
                    nArray[0] = nArray[0] + 1;
                    unit._group = (byte)23;
                }
                Script.Attack(23, -1, n5, n3, 1);
            }
        }
        if (entity3 != null) {
            int n7;
            n4 = entity3.GetPointer();
            int n8 = -1;
            n3 = 0;
            n2 = 0;
            for (n7 = 0; n7 < 24; ++n7) {
                if (Level._entities_usage[n7] != 1) continue;
                Unit unit = (Unit)Level._entities[n7];
                if (unit._allegiance != 0 || unit._targetPointer != n4) continue;
                n8 = unit.GetPointer();
                n3 = unit._pos_x;
                n2 = unit._pos_y;
                break;
            }
            if (n3 != 0 && n2 != 0) {
                for (n7 = 0; n7 < 24; ++n7) {
                    if (Level._entities_usage[n7] != 1) continue;
                    Unit unit = (Unit)Level._entities[n7];
                    if (unit._allegiance != 1 || unit._action != 1 || unit._targetPointer >= 0) continue;
                    n = unit._pos_x - entity3._pos_x;
                    int n9 = unit._pos_y - entity3._pos_y;
                    if (Math.abs(n) + Math.abs(n9) >= 180) continue;
                    unit.DoAction(3, n8, n3, n2);
                    unit._requested_action = false;
                    break;
                }
            }
        }
    }

    public static void TrainUnit(int n, int n2) {
        int n3 = n * 27;
        short s = Level._unit_stats[n3 + 10];
        if (s > Level._ai_money || Level._ai_command_points >= Level._ai_max_command_points) {
            return;
        }
        if (!Level.HasPower(1)) {
            return;
        }
        Building building = null;
        if (n2 > 0) {
            building = (Building)Level.GetEntityById(6, n2);
        }
        if (building == null) {
            building = Level.FindSpawnBuilding(n, 1);
        }
        if (building != null) {
            building.SpawnNewUnit(n);
        }
    }

    public static void UseSW(int n, int n2, int n3) {
        if (_AI_sw_cooldown[n] > 0 && Level.HasPower(1)) {
            return;
        }
        switch (n) {
            case 0: {
                Level.DropNuke(1, n2, n3);
                break;
            }
            case 1: {
                Level.DropStorm(1, n2, n3);
            }
        }
    }

    public static void BuildStructure(int n, int n2, int n3) {
        Entity entity;
        int n4 = Level.GetBuildingStats(Level._ai_faction, n, 15);
        if (n4 > Level._ai_money) {
            return;
        }
        if (Level._buildings_off_times[1][0] > 0) {
            return;
        }
        if (Level._ai_build_points >= Level._ai_max_build_points) {
            return;
        }
        int n5 = 0;
        n5 = Level.GetBuildingStats(Level._ai_faction, n, 3);
        if (n5 == 0) {
            return;
        }
        int n6 = 0;
        boolean bl = true;
        while (n5 != 0) {
            if ((n5 & 1) != 0 && Level.GetEntityNo(6, n6, 1) == 0) {
                bl = false;
                break;
            }
            ++n6;
            n5 >>= 1;
        }
        if (!bl) {
            return;
        }
        if (n2 <= 0 || n3 <= 0) {
            for (n6 = 24; n6 < 48; ++n6) {
                if (Level._entities_usage[n6] != 1) continue;
                Building building = (Building)Level._entities[n6];
                if (building._subtype != 0 || building._allegiance != 1) continue;
                n2 = building._pos_x;
                n3 = building._pos_y;
                break;
            }
        }
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        n6 = Entity.FindBuildSpot(n, n2, n3, true);
        if (n6 < 0) {
            n6 = Entity.FindBuildSpot(n, n2, n3, false);
        }
        if (n6 < 0) {
            return;
        }
        int n7 = Entity._buildSpots[n6 + 1];
        int n8 = Entity._buildSpots[n6 + 2];
        if (n == 2) {
            entity = Level.FindClosestMineralField(n7, n8, 64);
            if (entity != null) {
                n7 = entity._pos_x;
                n8 = entity._pos_y + 1;
            } else {
                return;
            }
        }
        if ((entity = Level.SpawnBuilding(n, n7, n8, 1, Level._ai_faction)) != null) {
            Level._ai_money -= Level.GetBuildingStats(((Building)entity)._faction, n, 15);
            Level._statistics[1] = Level._statistics[1] + 1;
        }
    }

    static boolean IsValidBuildingPosition(int n, int n2, int n3) {
        Entity entity;
        int n4 = 4;
        if (n == 2) {
            n4 = 6;
        }
        int n5 = 0;
        if (Level._ai_faction == 1) {
            n5 = 8;
        }
        if ((entity = Level.FindClosestMineralField(n2, n3, 64)) != null) {
            n2 = entity._pos_x;
            n3 = entity._pos_y;
        }
        byte[] byArray = Level.GetCMap(n5 + n);
        int n6 = Level.GetCMapHeaderData(n5 + n, 0);
        int n7 = Level.GetCMapHeaderData(n5 + n, 1);
        int n8 = Level.GetCMapHeaderData(n5 + n, 2);
        int n9 = Level.GetCMapHeaderData(n5 + n, 3);
        int n10 = (n2 + n6) / 8;
        int n11 = (n3 + n7) / 8;
        int n12 = n10 * 8;
        int n13 = n11 * 8;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        while (n16 < n9) {
            n14 = n12;
            int n17 = 0;
            while (n17 < n8) {
                if (byArray[n15] == 12 && Level.GetCollisionAtTile(n10 + n17, n11 + n16) > n4) {
                    return false;
                }
                ++n17;
                n14 += 8;
                ++n15;
            }
            ++n16;
            n13 += 8;
        }
        return true;
    }

    static void __MASTER_AI() {
    }

    static void SCRIPT_INSTRUCTIONS__() {
    }

    static int ExecBlock(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = n3 + 1;
        short s = sArray[n4++];
        int n5 = sArray[n4++];
        for (int i = 0; i < n5 && (n4 = Script.ExecuteInstruction(n, n2, n4)) >= 0; ++i) {
        }
        return n3 + s;
    }

    static int ExecIf(int n, int n2, int n3) {
        int n4;
        short[] sArray = _scripts[n2];
        int n5 = n3 + 1;
        short s = sArray[n5++];
        int n6 = sArray[n5++];
        short s2 = sArray[n5++];
        boolean bl = true;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = Script.ExecuteInstruction(n, n2, n5);
            if (_scriptInstances[n][4] <= 0) {
                bl = false;
                break;
            }
            n5 = n7;
        }
        if (bl) {
            for (n4 = 0; n4 < s2; ++n4) {
                if ((n5 = Script.ExecuteInstruction(n, n2, n5)) >= 0) continue;
                return -1;
            }
        }
        return n3 + s;
    }

    static int ExecWhile(int n, int n2, int n3) {
        int n4;
        short[] sArray = _scripts[n2];
        int n5 = n3 + 1;
        short s = sArray[n5++];
        int n6 = sArray[n5++];
        short s2 = sArray[n5++];
        boolean bl = false;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = Script.ExecuteInstruction(n, n2, n5);
            if (_scriptInstances[n][4] <= 0) {
                bl = true;
                break;
            }
            n5 = n7;
        }
        if (bl) {
            return n3 + s;
        }
        for (n4 = 0; n4 < s2; ++n4) {
            if ((n5 = Script.ExecuteInstruction(n, n2, n5)) >= 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return n3 + s;
        }
        return n3;
    }

    static int ExecSetAnim(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        Entity entity = Level.GetEntityById(-1, s);
        entity.SetCrtAnim(n6);
        return ++n3;
    }

    static int ExecSetAnimFrame(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        Entity entity = Level.GetEntityById(-1, s);
        entity._crt_aframe = n6;
        entity._crt_aframe_time = 0;
        return n3;
    }

    static int ExecSetPosition(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        Entity entity = Level.GetEntityById(-1, n5);
        entity.SetPosition(n7, n9);
        return ++n3;
    }

    static int ExecSpawnEntity(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        int n8 = -1;
        if (n7 < 0) {
            n8 = sArray[n3++];
        }
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n8 = Script.GetRegistryValue(n, n8);
        Script.SpawnEntity(n5, n7, n8);
        return n3;
    }

    static int ExecKillEntity(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        ++n3;
        int n5 = sArray[n4];
        Entity entity = Level.GetEntityById(-1, n5 = Script.GetRegistryValue(n, n5));
        if (entity != null) {
            switch (entity._type) {
                case 5: {
                    Unit unit = (Unit)entity;
                    Level.DecEntityNo(5, unit._subtype, unit._allegiance);
                    if (unit._allegiance == 0) {
                        --Level._player_command_points;
                    }
                    if (unit._allegiance == 1) {
                        --Level._ai_command_points;
                    }
                    unit._life = 0;
                    Entity.CheckTriggers(unit, unit._pos_x, unit._pos_y);
                    break;
                }
                case 6: {
                    Building building = (Building)entity;
                    Level.DecEntityNo(6, building._subtype, building._allegiance);
                    if (building._allegiance == 0) {
                        --Level._player_build_points;
                    }
                    if (building._allegiance == 1) {
                        --Level._ai_build_points;
                    }
                    building._life = 0;
                }
            }
            Level.DeleteEntity(entity);
        }
        return n3;
    }

    static int ExecFollowEntity(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n11 = Script.GetRegistryValue(n, n11);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null) {
            Camera.DoFollowEntity(entity.GetPointer());
        } else {
            Camera.SetState(0);
        }
        return n3;
    }

    static int ExecCenterTo(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        n7 -= Constants.SV_H >> 1;
        if ((n5 -= Constants.SV_W >> 1) < 0) {
            n5 = 0;
        }
        if (n5 > Level._map_w - Constants.SV_W) {
            n5 = Level._map_w - Constants.SV_W;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 > Level._map_h - Constants.SV_H) {
            n7 = Level._map_h - Constants.SV_H;
        }
        if (n9 == 0) {
            Camera.DoScroll(n5, n7);
        } else {
            Camera._nCamX = n5;
            Camera._nCamY = n7;
        }
        return n3;
    }

    static int ExecIsAnimEnded(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        Entity entity = Level.GetEntityById(-1, s);
        Script._scriptInstances[n][4] = entity.IsCrtAnimEnded() ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetFlags(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null) {
            entity._flags |= n7;
            if (entity._type == 5) {
                Unit unit = (Unit)entity;
                if ((n7 & 0x400) != 0) {
                    unit._bSelected = false;
                }
                if ((n7 & 0x4000) != 0) {
                    unit._targetPointer = -1;
                }
            }
        }
        return n3;
    }

    static int ExecResetFlags(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null) {
            entity._flags &= ~n7;
        }
        return n3;
    }

    static int ExecCameraLinearTo(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        return ++n3;
    }

    static int ExecBreak(int n, int n2, int n3) {
        return -1;
    }

    static int ExecTestVariable(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        short s2 = sArray[n5];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        short s3 = sArray[n8];
        n7 = Script.GetRegistryValue(n, n7);
        int n9 = Script.GetVariabile(n, s, s2);
        Script._scriptInstances[n][4] = s3 == 0 && n9 == n7 || s3 == 1 && n9 != n7 || s3 == 2 && n9 < n7 || s3 == 3 && n9 > n7 || s3 == 4 && n9 <= n7 || s3 == 5 && n9 >= n7 ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetVariable(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Script.SetVariabile(n, n5, n7, n9);
        return n3;
    }

    static int ExecTestRegister(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        int n7 = Script.GetRegistryValue(n, s);
        Script._scriptInstances[n][4] = n7 == n6 ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetRegister(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        Script._scriptInstances[n][s - 14995] = (short)n6;
        return ++n3;
    }

    static int ExecTestState(int n, int n2, int n3) {
        int n4;
        short[] sArray = _scripts[n2];
        int n5 = ++n3;
        short s = sArray[n5];
        int n6 = ++n3;
        int n7 = sArray[n6];
        Script._scriptInstances[n][4] = (n7 = Script.GetRegistryValue(n, n7)) == (n4 = Script.GetVariabile(n, s, 1)) ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetState(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        short s2 = sArray[n5];
        Script.SetVariabile(n, s, 1, s2);
        return ++n3;
    }

    static int ExecAddRegister(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        short[] sArray2 = _scriptInstances[n];
        int n7 = s - 14995;
        sArray2[n7] = (short)(sArray2[n7] + n6);
        return n3;
    }

    static int ExecSaveVariable(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        short s = sArray[n6];
        int n7 = ++n3;
        short s2 = sArray[n7];
        int n8 = Script.GetVariabile(n, n5, s);
        Script._scriptInstances[n][s2 - 14995] = (short)n8;
        return ++n3;
    }

    static int ExecSaveState(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        short s2 = sArray[n5];
        int n6 = Script.GetVariabile(n, s, 1);
        Script._scriptInstances[n][s2 - 14995] = (short)n6;
        return ++n3;
    }

    static int ExecWait(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = n3 + 1;
        int n5 = sArray[n4++];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = _scriptInstances[n][4];
        if (n6 >= 0) {
            n6 = -n5;
        }
        if (++n6 >= 0) {
            Script._scriptInstances[n][4] = (short)n6;
            return n4;
        }
        Script._scriptInstances[n][4] = (short)n6;
        return n3;
    }

    static int ExecStartScript(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        int n7 = ++n3;
        int n8 = sArray[n7];
        int n9 = ++n3;
        int n10 = sArray[n9];
        int n11 = ++n3;
        ++n3;
        int n12 = sArray[n11];
        n6 = Script.GetRegistryValue(n, n6);
        n8 = Script.GetRegistryValue(n, n8);
        n10 = Script.GetRegistryValue(n, n10);
        n12 = Script.GetRegistryValue(n, n12);
        Script.StartScript(s, n6, n8, n10, n12);
        return n3;
    }

    static int ExecPlaySound(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        short s = sArray[n6];
        return ++n3;
    }

    static int ExecMovieBars(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        ++n3;
        short s = sArray[n4];
        if (s > 0) {
            Hud.RiseMovieBars();
        } else {
            Hud.SinkMovieBars();
        }
        return n3;
    }

    static int ExecTestMemory(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        Script._scriptInstances[n][4] = (n7 = Script.GetRegistryValue(n, n7)) == _memory[n5] ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetMemory(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Script._memory[n5] = (short)n7;
        return ++n3;
    }

    static int ExecSaveMemory(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        short s = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        Script._scriptInstances[n][s - 14995] = _memory[n5];
        return ++n3;
    }

    static int ExecKillScripts(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Script.KillScripts(n5);
        return ++n3;
    }

    static int ExecStopSound(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        return ++n3;
    }

    static int ExecSpawnUnit(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Unit unit = Level.SpawnUnit(n7, n9, n11, n15 = Script.GetRegistryValue(n, n15), n13, (byte)(n17 = Script.GetRegistryValue(n, n17)));
        if (unit != null && n5 > 0) {
            unit._id = n5;
        }
        if (unit._allegiance == 1 && unit._group > 0) {
            int[] nArray = _AI_groups[n17];
            nArray[0] = nArray[0] + 1;
        }
        return n3;
    }

    static int ExecSelectUnits(int n, int n2, int n3) {
        int n4;
        short[] sArray = _scripts[n2];
        int n5 = ++n3;
        int n6 = sArray[n5];
        int n7 = ++n3;
        int n8 = sArray[n7];
        int n9 = ++n3;
        ++n3;
        int n10 = sArray[n9];
        n6 = Script.GetRegistryValue(n, n6);
        n8 = Script.GetRegistryValue(n, n8);
        n10 = Script.GetRegistryValue(n, n10);
        for (n4 = 0; n4 < 24; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            Unit unit = (Unit)Level._entities[n4];
            if ((n8 >= 0 && n8 != unit._allegiance || n6 >= 0) && n6 != unit._subtype) continue;
            if (n10 > 0) {
                unit._bSelected = true;
                Camera._bUnitsSelected = true;
            } else {
                unit._bSelected = false;
            }
            Level._currentGroup = 0;
        }
        if (n10 <= 0) {
            n4 = 0;
            for (int i = 0; i < 24; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._allegiance != 0 || !unit._bSelected) continue;
                ++n4;
            }
            Camera._bUnitsSelected = n4 > 0;
        }
        return n3;
    }

    static int ExecGroupUnits(int n, int n2, int n3) {
        Unit unit;
        int n4;
        short[] sArray = _scripts[n2];
        int n5 = ++n3;
        int n6 = sArray[n5];
        int n7 = ++n3;
        int n8 = sArray[n7];
        int n9 = ++n3;
        int n10 = sArray[n9];
        int n11 = ++n3;
        int n12 = sArray[n11];
        int n13 = ++n3;
        int n14 = sArray[n13];
        int n15 = ++n3;
        int n16 = sArray[n15];
        int n17 = ++n3;
        int n18 = sArray[n17];
        int n19 = ++n3;
        ++n3;
        int n20 = sArray[n19];
        n6 = Script.GetRegistryValue(n, n6);
        n8 = Script.GetRegistryValue(n, n8);
        n10 = Script.GetRegistryValue(n, n10);
        n12 = Script.GetRegistryValue(n, n12);
        n14 = Script.GetRegistryValue(n, n14);
        n16 = Script.GetRegistryValue(n, n16);
        n18 = Script.GetRegistryValue(n, n18);
        if ((n20 = Script.GetRegistryValue(n, n20)) < 0) {
            n20 = 24;
        }
        int n21 = 0;
        GameImpl._rect[0] = n8;
        GameImpl._rect[1] = n10;
        GameImpl._rect[2] = n12;
        GameImpl._rect[3] = n14;
        for (n4 = 0; n4 < 24; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            unit = (Unit)Level._entities[n4];
            if (n6 >= 0) {
                if (unit._subtype != n6 || unit._allegiance != n16 || !GameImpl.PointInRect(GameImpl._rect, unit._pos_x, unit._pos_y) || (unit._flags & 0x400) != 0 || n21 >= n20) continue;
                if (unit._allegiance == 1 && unit._group <= 0) {
                    int[] nArray = _AI_groups[n18];
                    nArray[0] = nArray[0] + 1;
                    unit._group = (byte)n18;
                    ++n21;
                    continue;
                }
                if (unit._allegiance != 0) continue;
                unit._group = (byte)n18;
                ++n21;
                continue;
            }
            if (unit._allegiance != n16 || !GameImpl.PointInRect(GameImpl._rect, unit._pos_x, unit._pos_y) || n21 >= n20) continue;
            if (unit._allegiance == 1 && unit._group <= 0) {
                int[] nArray = _AI_groups[n18];
                nArray[0] = nArray[0] + 1;
                unit._group = (byte)n18;
                ++n21;
                continue;
            }
            if (unit._allegiance != 0) continue;
            unit._group = (byte)n18;
            ++n21;
        }
        if (n21 < n20) {
            for (n4 = 0; n4 < 24; ++n4) {
                if (Level._entities_usage[n4] != 1) continue;
                unit = (Unit)Level._entities[n4];
                if (n6 >= 0) {
                    if (unit._subtype != n6 || unit._allegiance != n16 || !GameImpl.PointInRect(GameImpl._rect, unit._pos_x, unit._pos_y) || (unit._flags & 0x400) != 0 || n21 >= n20 || unit._allegiance != 1 || unit._group == n18) continue;
                    if (unit._group >= 0 && _AI_groups[unit._group][0] > 0) {
                        int[] nArray = _AI_groups[unit._group];
                        nArray[0] = nArray[0] - 1;
                    }
                    int[] nArray = _AI_groups[n18];
                    nArray[0] = nArray[0] + 1;
                    unit._group = (byte)n18;
                    ++n21;
                    continue;
                }
                if (unit._allegiance != n16 || !GameImpl.PointInRect(GameImpl._rect, unit._pos_x, unit._pos_y) || n21 >= n20 || unit._allegiance != 1 || unit._group == n18) continue;
                if (unit._group > 0 && _AI_groups[unit._group][0] > 0) {
                    int[] nArray = _AI_groups[unit._group];
                    nArray[0] = nArray[0] - 1;
                }
                int[] nArray = _AI_groups[n18];
                nArray[0] = nArray[0] + 1;
                unit._group = (byte)n18;
                ++n21;
            }
        }
        return n3;
    }

    static int ExecTestNrUnits(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        short s = sArray[n10];
        n9 = Script.GetRegistryValue(n, n9);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        int n11 = 0;
        if (n5 >= 0) {
            n11 = Level.GetEntityNo(5, n5, n7);
        } else {
            for (int i = 0; i < 10; ++i) {
                n11 += Level.GetEntityNo(5, i, n7);
            }
        }
        Script._scriptInstances[n][4] = s == 0 && n11 == n9 || s == 1 && n11 != n9 || s == 2 && n11 < n9 || s == 3 && n11 > n9 || s == 4 && n11 <= n9 || s == 5 && n11 >= n9 ? (short)1 : 0;
        return n3;
    }

    static int ExecTestNrBuildings(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        short s = sArray[n10];
        n9 = Script.GetRegistryValue(n, n9);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        int n11 = 0;
        if (n5 >= 0) {
            n11 = Level.GetEntityNo(6, n5, n7);
        } else {
            for (int i = 0; i < 8; ++i) {
                n11 += Level.GetEntityNo(6, i, n7);
            }
        }
        Script._scriptInstances[n][4] = s == 0 && n11 == n9 || s == 1 && n11 != n9 || s == 2 && n11 < n9 || s == 3 && n11 > n9 || s == 4 && n11 <= n9 || s == 5 && n11 >= n9 ? (short)1 : 0;
        return n3;
    }

    static int ExecTrainUnit(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Script.TrainUnit(n5, n7);
        return ++n3;
    }

    static int ExecStartAttack(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Script.Attack(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecEndLevel(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Level.EndLevel(n5);
        return ++n3;
    }

    static int ExecTestRandom(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        short s = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        int n11 = GameImpl.random(n5, n7);
        Script._scriptInstances[n][4] = s == 0 && n11 == n9 || s == 1 && n11 != n9 || s == 2 && n11 < n9 || s == 3 && n11 > n9 || s == 4 && n11 <= n9 || s == 5 && n11 >= n9 ? (short)1 : 0;
        return n3;
    }

    static int ExecSetCameraTo(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        n7 -= Constants.SV_H >> 1;
        if ((n5 -= Constants.SV_W >> 1) < 0) {
            n5 = 0;
        }
        if (n5 > Level._map_w - Constants.SV_W) {
            n5 = Level._map_w - Constants.SV_W;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 > Level._map_h - Constants.SV_H) {
            n7 = Level._map_h - Constants.SV_H;
        }
        if (n9 == 0) {
            Camera.DoScroll(n5, n7);
        } else {
            int n10 = Camera._nCursorPosX - Camera._nCamX;
            int n11 = Camera._nCursorPosY - Camera._nCamY;
            Camera._nCamX = n5;
            Camera._nCamY = n7;
            Camera._nCursorPosX = n5 + n10;
            Camera._nCursorPosY = n7 + n11;
            Camera.DoScroll(n5, n7);
        }
        return n3;
    }

    static int ExecStartMove(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Unit unit = (Unit)Level.GetEntityById(5, n5);
        if (unit != null) {
            unit.DoAction(2, -1, n7, n9);
        }
        return n3;
    }

    static int ExecShowMessage(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Hud.AddMessage(n5, n7, n13, n9, n11, 1);
        return n3;
    }

    static int ExecStartCursorTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        GameImpl.StartCursorMovementTutorial(n5, n7);
        return ++n3;
    }

    static int ExecStartMovementTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        GameImpl.StartUnitsMovementTutorial(n5, n7, n9, n11);
        return n3;
    }

    static int ExecStartAttackTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        GameImpl.StartAttackTutorial(n5, n7, n9, n11, -1);
        return n3;
    }

    static int ExecStartBuildTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        GameImpl.StartBuildTutorial(n5, n7, n9, n11);
        return n3;
    }

    static int ExecStartGroupTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        GameImpl.StartGroupTutorial(n5, n7, n9);
        return n3;
    }

    static int ExecStartTrainTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        GameImpl.StartTrainTutorial(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecStartSelectTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        GameImpl.StartSelectTutorial(n5, n7, n9);
        return n3;
    }

    static int ExecTestActiveTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if (GameImpl._tutorials[i][0] != 1 || GameImpl._tutorials[i][2] != n5) continue;
            bl = true;
            break;
        }
        Script._scriptInstances[n][4] = bl ? (short)1 : 0;
        return n3;
    }

    static int ExecSetAssetAvailable(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        if ((n9 = Script.GetRegistryValue(n, n9)) > 0) {
            Hud.AddAvailableBuildItems(n5, 1 << n7);
        } else {
            Hud.RemoveAvailableBuildItems(n5, 1 << n7);
        }
        return n3;
    }

    static int ExecEndTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        GameImpl.EndTutorial(n5);
        return ++n3;
    }

    static int ExecTestBuildingOffline(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        short s = Level._buildings_off_times[n7 = Script.GetRegistryValue(n, n7)][n5];
        Script._scriptInstances[n][4] = s > 0 ? (short)1 : 0;
        return ++n3;
    }

    static int ExecTestTriggerState(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = 0;
        Script._scriptInstances[n][4] = 0;
        for (int i = 0; i < Entity.nrTriggers; ++i) {
            int n9 = Entity._triggers[n8 + 4];
            if (n9 == n5) {
                int n10 = Entity._triggers[n8 + 5];
                if (n7 != n10) break;
                Script._scriptInstances[n][4] = 1;
                break;
            }
            n8 += 18;
        }
        return n3;
    }

    static int ExecSetAIDefense(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = Script.GetRegistryValue(n, sArray[n4]);
        _AI_defend = n5 > 0;
        return ++n3;
    }

    static int ExecSetAIScripting(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = Script.GetRegistryValue(n, sArray[n4]);
        _AI_run_script = n5 > 0;
        return ++n3;
    }

    static int ExecFireSuperWeapon(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        switch (n5) {
            case 0: {
                Level.DropNuke(n11, n7, n9);
                break;
            }
            case 1: {
                Level.DropStorm(n11, n7, n9);
            }
        }
        return n3;
    }

    static int ExecTestFinishedTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            if (GameImpl._tutorials[i][0] != 1 || GameImpl._tutorials[i][2] != n5) continue;
            bl = true;
            break;
        }
        Script._scriptInstances[n][4] = !bl ? (short)1 : 0;
        return n3;
    }

    static int ExecSetUnitAction(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            if (n7 != 6) {
                Entity entity2 = Level.GetEntityById(-1, n9);
                if (entity2 != null) {
                    n9 = entity2.GetPointer();
                    if (n11 <= 0) {
                        n11 = entity2._pos_x;
                    }
                    if (n13 <= 0) {
                        n13 = entity2._pos_y;
                    }
                } else {
                    n9 = -1;
                }
            }
            unit.DoAction(n7, n9, n11, n13);
        }
        return n3;
    }

    static int ExecSetUnitAnim(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            switch (n7) {
                case 0: {
                    unit.SetStayAnim();
                    break;
                }
                case 28: {
                    unit.SetDieAnim();
                    break;
                }
                case 29: {
                    unit.SetDeathAnim();
                    break;
                }
                case 30: {
                    unit.SetCrtAnim(30);
                    break;
                }
                case 38: {
                    int n8 = unit._orientation >> 1;
                    unit.SetCrtAnim(n7 + n8);
                    break;
                }
                default: {
                    unit.SetCrtAnim(n7 + unit._orientation);
                    if (!unit._bHasTurret) break;
                    int n9 = n7 + 16;
                    unit.Turret_SetCrtAnim(n9 + unit._turretOrientation);
                }
            }
        }
        return n3;
    }

    static int ExecSetHullAnim(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            unit.SetCrtAnim(n7 + unit._orientation);
        }
        return n3;
    }

    static int ExecSetTurretAnim(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            if (unit._bHasTurret) {
                unit.Turret_SetCrtAnim(n7 + unit._turretOrientation);
            }
        }
        return n3;
    }

    static int ExecUnitForceCrawl(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            unit._force_crawl = (byte)n7;
            if (n7 == 1) {
                unit._crawling_timer = (short)64;
                unit.RefreshCrawlingAnim();
            }
            if (n7 == 2) {
                unit._crawling_timer = 0;
                unit.RefreshCrawlingAnim();
            }
        }
        return n3;
    }

    static int ExecAISuperWeapon(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Script.UseSW(n5, n7, n9);
        return n3;
    }

    static int ExecStartSwTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        GameImpl.StartSWTutorial(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecBuildStructure(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Script.BuildStructure(n5, n7, n9);
        return n3;
    }

    static int ExecSetCameraState(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Camera.SetState(n5);
        return ++n3;
    }

    static int ExecSetTriggerState(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = 0;
        for (int i = 0; i < Entity.nrTriggers; ++i) {
            int n9 = Entity._triggers[n8 + 4];
            if (n9 == n5) {
                Entity._triggers[n8 + 5] = n7;
                break;
            }
            n8 += 18;
        }
        return n3;
    }

    static int ExecSetGroupAction(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        if (n11 != 6) {
            Entity entity = Level.GetEntityById(-1, n13);
            if (entity != null) {
                n13 = entity.GetPointer();
                if (n15 <= 0) {
                    n15 = entity._pos_x;
                }
                if (n17 <= 0) {
                    n17 = entity._pos_y;
                }
            } else {
                n13 = -1;
            }
        }
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (n5 > 0 && unit._group != n5 || n7 >= 0 && unit._allegiance != n7 || n9 >= 0 && unit._subtype != n9) continue;
            unit.DoAction(n11, n13, n15, n17);
        }
        return n3;
    }

    static int ExecTestAreaUnits(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        int n17 = sArray[n16];
        int n18 = ++n3;
        ++n3;
        short s = sArray[n18];
        n17 = Script.GetRegistryValue(n, n17);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        int n19 = 0;
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._subtype != n5 && n5 >= 0 || unit._allegiance != n7 && n7 >= 0 || unit._pos_x < n9 || unit._pos_x > n13 || unit._pos_y < n11 || unit._pos_y > n15) continue;
            ++n19;
        }
        Script._scriptInstances[n][4] = s == 0 && n19 == n17 || s == 1 && n19 != n17 || s == 2 && n19 < n17 || s == 3 && n19 > n17 || s == 4 && n19 <= n17 || s == 5 && n19 >= n17 ? (short)1 : 0;
        return n3;
    }

    static int ExecTestAreaBuildings(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        int n17 = sArray[n16];
        int n18 = ++n3;
        ++n3;
        short s = sArray[n18];
        n17 = Script.GetRegistryValue(n, n17);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        int n19 = 0;
        for (int i = 24; i < 48; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Building building = (Building)Level._entities[i];
            if (building._subtype != n5 && n5 >= 0 || building._allegiance != n7 && n7 >= 0 || building._pos_x < n9 || building._pos_x > n13 || building._pos_y < n11 || building._pos_y > n15) continue;
            ++n19;
        }
        Script._scriptInstances[n][4] = s == 0 && n19 == n17 || s == 1 && n19 != n17 || s == 2 && n19 < n17 || s == 3 && n19 > n17 || s == 4 && n19 <= n17 || s == 5 && n19 >= n17 ? (short)1 : 0;
        return n3;
    }

    static int ExecAddBriefingMessage(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Hud.AddBriefingMessage(n5);
        return ++n3;
    }

    static int ExecStartSnow(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        GameImpl.SnowSetState(1);
        return ++n3;
    }

    static int ExecStopSnow(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        GameImpl.SnowSetState(3);
        return ++n3;
    }

    static int ExecSetCameraSpeed(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        Camera._nCamMaxSpd = n5 = Script.GetRegistryValue(n, n5);
        Camera._nCamSpd = n5;
        return ++n3;
    }

    static int ExecStartAttackEntityTutorial(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        GameImpl.StartAttackTutorial(n5, 0, 0, n9, n7);
        return n3;
    }

    static int ExecSpawnAnimatedDecorator(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        Entity entity = Level.SpawnEntity(2);
        if (entity != null) {
            entity._id = n5;
            entity.Decorator_Init(n7, n9, n11, n13, n15, n17);
        }
        return n3;
    }

    static int ExecFadeToDark(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        GameImpl.Fade(true, n5, true);
        return ++n3;
    }

    static int ExecFadeToGame(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        GameImpl.Fade(false, n5, true);
        return ++n3;
    }

    static int ExecSetAllegianceFlags(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != n5 && n5 >= 0) continue;
            unit._flags |= n7;
            if ((n7 & 0x400) != 0) {
                unit._bSelected = false;
            }
            if ((n7 & 0x4000) == 0) continue;
            unit._targetPointer = -1;
        }
        return n3;
    }

    static int ExecResetAlligeanceFlags(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != n5 && n5 >= 0) continue;
            unit._flags &= ~n7;
        }
        return n3;
    }

    static int ExecIncreaseEntityNo(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Level.IncEntityNo(n5, n7, n9);
        if (n5 == 6 && n7 == 1) {
            if (n9 == 0) {
                Level._player_power -= Level.GetBuildingStats(Level._player_faction, n7, 16);
            }
            if (n9 == 0) {
                Level._ai_power -= Level.GetBuildingStats(Level._player_faction, n7, 16);
            }
        }
        return n3;
    }

    static int ExecDecreaseEntityNo(int n, int n2, int n3) {
        short[] sArray = _scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Level.IncEntityNo(n5, n7, n9);
        if (n5 == 6 && n7 == 1) {
            if (n9 == 0) {
                Level._player_power += Level.GetBuildingStats(Level._player_faction, n7, 16);
            }
            if (n9 == 0) {
                Level._ai_power += Level.GetBuildingStats(Level._player_faction, n7, 16);
            }
        }
        return n3;
    }

    static void __SCRIPT_INSTRUCTIONS() {
    }
}

