/*
 * Decompiled with CFR 0.152.
 */
package game;

import constants.AnimConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import game.AppEngine;
import game.MapObject;
import game.MapObjectSim;
import game.SceneGame;
import game.SimData;
import generic.MathExt;
import generic.ResourceManager;
import generic.TileMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SimWorld
implements AnimConstants,
ResourceConstants,
SoundEventConstants {
    private AppEngine m_engine;
    private byte[] d_objectParents;
    private short[] d_objectStringIds;
    private short[] d_objectActionIcons;
    private int[] d_objectFlags;
    private short[] d_objectNeeds;
    private short[] d_objectBuyPrices;
    private short[] d_objectSellPrices;
    private byte[] d_objectFootprintWidths;
    private byte[] d_objectFootprintHeights;
    private short[] d_objectAnimIds;
    private short[][] d_objectAnimSetIds;
    private byte[][] d_objectInterestPointXs;
    private byte[][] d_objectInterestPointYs;
    private short[][] d_objectActions;
    private short[] d_animSetIndexes;
    private short[][] d_appearances;
    private byte[][] d_tileArrays;
    private short[] d_itemDescStringIds;
    private short[] d_itemIcons;
    private int[] d_itemFlags;
    private short[] d_itemBuyPrices;
    private short[] d_itemSellPrices;
    private byte[] d_itemMaxInventory;
    private byte[] d_recipeItems;
    private byte[] d_recipeReplenishes;
    private short[][] d_recipeIngredients;
    private short[] d_houseMacroObjects;
    private byte[][] d_houseRoomXs;
    private byte[][] d_houseRoomYs;
    private byte[][] d_houseRoomWidths;
    private byte[][] d_houseRoomHeights;
    private byte[][] d_houseRoomFloors;
    private byte[][] d_houseRoomWalls;
    private byte[][] d_houseDoorXs;
    private byte[][] d_houseDoorYs;
    private byte[][] d_houseDoorWidths;
    private byte[][] d_houseObjectXs;
    private byte[][] d_houseObjectZs;
    private short[][] d_houseObjectTypes;
    private byte[][] d_houseObjectFacingDirs;
    private int m_houseIndex;
    private static final byte[] PLAYER_HOUSE_LIST = new byte[]{0, 1, 2};
    private static final short[] PLAYER_HOUSE_MM_ANIMS = new short[]{173, 174, 175};
    private byte m_playerHouseLevel;
    private byte[] m_playerHouseObjectXs;
    private byte[] m_playerHouseObjectZs;
    private short[] m_playerHouseObjectTypes;
    private byte[] m_playerHouseObjectFacingDirs;
    private int m_viewportX;
    private int m_viewportY;
    private int m_viewportWidth;
    private int m_viewportHeight;
    public static final int[] ROTATION_FLAGS = new int[]{128, 256, 512, 1024};
    public static boolean option_winter = true;
    private int m_screenOffsetX;
    private int m_screenOffsetY;
    private int m_screenOffsetXF;
    private int m_screenOffsetYF;
    private int m_attribWidth;
    private int m_attribHeight;
    private int m_attribOffsetX;
    private int m_attribOffsetZ;
    private byte[] m_attributesLayer;
    private TileMap m_tileMap;
    private TileMap m_tileMapWalls;
    public static boolean GLOW = true;
    public static int ANIM_GLOW_TIME = 100;
    public static boolean LIGHT_UP = false;
    private int m_cameraPosX;
    private int m_cameraPosZ;
    private int[][] d_patches;
    private byte[][] d_pals;
    private int m_pathStartX;
    private int m_pathStartY;
    private int m_pathDestX;
    private int m_pathDestY;
    private int[] m_pathAvoidTiles;
    private int m_pathNumAvoidTiles;
    private int m_pathOffsetX;
    private int m_pathOffsetY;
    private short[] m_pathOpenList;
    private int m_pathOpenCount;
    private short[] m_pathClosedList;
    private int m_pathClosedCount;
    private short[][] m_pathParentArray;
    private int[][] m_pathFCost;
    private int[][] m_pathGCost;
    private int[][] m_pathHCost;
    private short[] m_pathList;
    private int m_pathFlags;

    public SimWorld(AppEngine appEngine) {
        this.m_engine = appEngine;
        this.initWorld();
        this.initHouses();
        this.initColors();
        this.pathInit();
    }

    private static final short lookupSimsWorld(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private void initWorld() {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        try {
            int n;
            Object[] objectArray;
            int n2;
            int n3;
            int n4;
            Object object;
            int n5;
            short[] sArray;
            int n6;
            int n7;
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(70));
            int n8 = dataInputStream.readShort();
            byte[] byArray = new byte[n8];
            short[] sArray2 = new short[n8];
            short[] sArray3 = new short[n8];
            int[] nArray = new int[n8];
            short[] sArray4 = new short[n8];
            short[] sArray5 = new short[n8];
            short[] sArray6 = new short[n8];
            byte[] byArray2 = new byte[n8];
            byte[] byArray3 = new byte[n8];
            short[] sArray7 = new short[n8];
            short[][] sArrayArray = new short[n8][];
            byte[][] byArrayArray = new byte[n8][];
            byte[][] byArrayArray2 = new byte[n8][];
            short[][] sArrayArray2 = new short[n8][];
            for (n7 = 0; n7 < n8; ++n7) {
                byArray[n7] = dataInputStream.readByte();
                sArray2[n7] = SimWorld.lookupSimsWorld(dataInputStream);
                sArray3[n7] = SimWorld.lookupSimsWorld(dataInputStream);
                nArray[n7] = dataInputStream.readInt();
                sArray4[n7] = SimWorld.lookupSimsWorld(dataInputStream);
                if (sArray4[n7] == -1) {
                    sArray4[n7] = 0;
                }
                sArray5[n7] = dataInputStream.readShort();
                sArray6[n7] = dataInputStream.readShort();
                byArray2[n7] = dataInputStream.readByte();
                byArray3[n7] = dataInputStream.readByte();
                sArray7[n7] = SimWorld.lookupSimsWorld(dataInputStream);
                n6 = dataInputStream.readByte();
                sArray = new short[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    sArray[n5] = dataInputStream.readShort();
                }
                n5 = dataInputStream.readByte();
                object = new byte[n5];
                byte[] byArray4 = new byte[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    object[n4] = (short[])dataInputStream.readByte();
                    byArray4[n4] = dataInputStream.readByte();
                }
                n4 = dataInputStream.readByte();
                short[] sArray8 = new short[n4];
                for (int i = 0; i < n4; ++i) {
                    sArray8[i] = SimWorld.lookupSimsWorld(dataInputStream);
                }
                sArrayArray[n7] = sArray;
                byArrayArray[n7] = (byte[])object;
                byArrayArray2[n7] = byArray4;
                sArrayArray2[n7] = sArray8;
            }
            n7 = dataInputStream.readShort();
            n6 = n7 << 2;
            sArray = new short[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                sArray[n5] = SimWorld.lookupSimsWorld(dataInputStream);
            }
            n5 = dataInputStream.readByte();
            object = new short[n5][];
            for (n3 = 0; n3 < n5; ++n3) {
                n4 = dataInputStream.readByte();
                int n9 = n4 << 1;
                short[] sArray9 = new short[n9];
                for (n2 = 0; n2 < n9; ++n2) {
                    sArray9[n2] = dataInputStream.readShort();
                }
                object[n3] = sArray9;
            }
            n3 = dataInputStream.readByte();
            n4 = dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            byte[][] byArrayArray3 = new byte[by][];
            for (n2 = 0; n2 < by; ++n2) {
                byte by2 = dataInputStream.readByte();
                objectArray = new byte[by2];
                dataInputStream.readFully((byte[])objectArray);
                byArrayArray3[n2] = objectArray;
            }
            n2 = dataInputStream.readByte();
            short[] sArray10 = new short[n2];
            objectArray = new short[n2];
            int[] nArray2 = new int[n2];
            short[] sArray11 = new short[n2];
            short[] sArray12 = new short[n2];
            byte[] byArray5 = new byte[n2];
            for (n = 0; n < n2; ++n) {
                sArray10[n] = SimWorld.lookupSimsWorld(dataInputStream);
                objectArray[n] = SimWorld.lookupSimsWorld(dataInputStream);
                nArray2[n] = dataInputStream.readInt();
                sArray11[n] = dataInputStream.readShort();
                sArray12[n] = dataInputStream.readShort();
                byArray5[n] = dataInputStream.readByte();
            }
            n = dataInputStream.readByte();
            byte[] byArray6 = new byte[n];
            byte[] byArray7 = new byte[n];
            short[][] sArrayArray3 = new short[n][];
            for (int i = 0; i < n; ++i) {
                byArray6[i] = dataInputStream.readByte();
                byArray7[i] = dataInputStream.readByte();
                int n10 = dataInputStream.readByte();
                short[] sArray13 = new short[n10];
                for (int j = 0; j < n10; ++j) {
                    sArray13[j] = dataInputStream.readByte();
                }
                sArrayArray3[i] = sArray13;
            }
            dataInputStream.close();
            this.d_objectParents = byArray;
            this.d_objectStringIds = sArray2;
            this.d_objectActionIcons = sArray3;
            this.d_objectFlags = nArray;
            this.d_objectNeeds = sArray4;
            this.d_objectBuyPrices = sArray5;
            this.d_objectSellPrices = sArray6;
            this.d_objectFootprintWidths = byArray2;
            this.d_objectFootprintHeights = byArray3;
            this.d_objectAnimIds = sArray7;
            this.d_objectAnimSetIds = sArrayArray;
            this.d_objectInterestPointXs = byArrayArray;
            this.d_objectInterestPointYs = byArrayArray2;
            this.d_objectActions = sArrayArray2;
            this.d_animSetIndexes = sArray;
            this.d_appearances = object;
            this.d_tileArrays = byArrayArray3;
            this.d_itemDescStringIds = sArray10;
            this.d_itemIcons = objectArray;
            this.d_itemFlags = nArray2;
            this.d_itemBuyPrices = sArray11;
            this.d_itemSellPrices = sArray12;
            this.d_itemMaxInventory = byArray5;
            this.d_recipeItems = byArray6;
            this.d_recipeReplenishes = byArray7;
            this.d_recipeIngredients = sArrayArray3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final short lookupSimsHouses(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private void initHouses() {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        try {
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(68));
            int n = dataInputStream.readByte();
            short[] sArray = new short[n];
            byte[][] byArrayArray = new byte[n][];
            byte[][] byArrayArray2 = new byte[n][];
            byte[][] byArrayArray3 = new byte[n][];
            byte[][] byArrayArray4 = new byte[n][];
            byte[][] byArrayArray5 = new byte[n][];
            byte[][] byArrayArray6 = new byte[n][];
            byte[][] byArrayArray7 = new byte[n][];
            byte[][] byArrayArray8 = new byte[n][];
            byte[][] byArrayArray9 = new byte[n][];
            byte[][] byArrayArray10 = new byte[n][];
            byte[][] byArrayArray11 = new byte[n][];
            short[][] sArrayArray = new short[n][];
            byte[][] byArrayArray12 = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                sArray[i] = SimWorld.lookupSimsHouses(dataInputStream);
                int n4 = dataInputStream.readByte();
                byte[] byArray = new byte[n4];
                byte[] byArray2 = new byte[n4];
                byte[] byArray3 = new byte[n4];
                byte[] byArray4 = new byte[n4];
                byte[] byArray5 = new byte[n4];
                byte[] byArray6 = new byte[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    byArray[n3] = dataInputStream.readByte();
                    byArray2[n3] = dataInputStream.readByte();
                    byArray3[n3] = dataInputStream.readByte();
                    byArray4[n3] = dataInputStream.readByte();
                    byArray5[n3] = (byte)SimWorld.lookupSimsHouses(dataInputStream);
                    byArray6[n3] = (byte)SimWorld.lookupSimsHouses(dataInputStream);
                }
                n3 = dataInputStream.readByte();
                byte[] byArray7 = new byte[n3];
                byte[] byArray8 = new byte[n3];
                byte[] byArray9 = new byte[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray7[n2] = dataInputStream.readByte();
                    byArray8[n2] = dataInputStream.readByte();
                    byArray9[n2] = dataInputStream.readByte();
                }
                n2 = dataInputStream.readByte();
                byte[] byArray10 = new byte[n2];
                byte[] byArray11 = new byte[n2];
                short[] sArray2 = new short[n2];
                byte[] byArray12 = new byte[n2];
                for (int j = 0; j < n2; ++j) {
                    byArray10[j] = dataInputStream.readByte();
                    byArray11[j] = dataInputStream.readByte();
                    sArray2[j] = SimWorld.lookupSimsHouses(dataInputStream);
                    byArray12[j] = (byte)SimWorld.lookupSimsHouses(dataInputStream);
                }
                byArrayArray[i] = byArray;
                byArrayArray2[i] = byArray2;
                byArrayArray3[i] = byArray3;
                byArrayArray4[i] = byArray4;
                byArrayArray5[i] = byArray5;
                byArrayArray6[i] = byArray6;
                byArrayArray7[i] = byArray7;
                byArrayArray8[i] = byArray8;
                byArrayArray9[i] = byArray9;
                byArrayArray10[i] = byArray10;
                byArrayArray11[i] = byArray11;
                sArrayArray[i] = sArray2;
                byArrayArray12[i] = byArray12;
            }
            dataInputStream.close();
            this.d_houseMacroObjects = sArray;
            this.d_houseRoomXs = byArrayArray;
            this.d_houseRoomYs = byArrayArray2;
            this.d_houseRoomWidths = byArrayArray3;
            this.d_houseRoomHeights = byArrayArray4;
            this.d_houseRoomFloors = byArrayArray5;
            this.d_houseRoomWalls = byArrayArray6;
            this.d_houseDoorXs = byArrayArray7;
            this.d_houseDoorYs = byArrayArray8;
            this.d_houseDoorWidths = byArrayArray9;
            this.d_houseObjectXs = byArrayArray10;
            this.d_houseObjectZs = byArrayArray11;
            this.d_houseObjectTypes = sArrayArray;
            this.d_houseObjectFacingDirs = byArrayArray12;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getHouseId() {
        if (AppEngine.indexOf(this.m_houseIndex, PLAYER_HOUSE_LIST) != -1) {
            return 0;
        }
        return this.m_houseIndex;
    }

    public int getHouseMacroObject(int n) {
        return this.d_houseMacroObjects[n];
    }

    public int getHouseForObject(int n) {
        return AppEngine.indexOf(n, this.d_houseMacroObjects);
    }

    public void initPlayerHouse() {
        this.m_playerHouseLevel = 0;
        if (this.m_playerHouseObjectXs == null) {
            this.m_playerHouseObjectXs = new byte[150];
            this.m_playerHouseObjectZs = new byte[150];
            this.m_playerHouseObjectTypes = new short[150];
            this.m_playerHouseObjectFacingDirs = new byte[150];
        }
        AppEngine.fillArray(this.m_playerHouseObjectTypes, -1);
        byte[] byArray = this.d_houseObjectXs[0];
        byte[] byArray2 = this.d_houseObjectZs[0];
        short[] sArray = this.d_houseObjectTypes[0];
        byte[] byArray3 = this.d_houseObjectFacingDirs[0];
        System.arraycopy(byArray, 0, this.m_playerHouseObjectXs, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.m_playerHouseObjectZs, 0, byArray2.length);
        System.arraycopy(sArray, 0, this.m_playerHouseObjectTypes, 0, sArray.length);
        System.arraycopy(byArray3, 0, this.m_playerHouseObjectFacingDirs, 0, byArray3.length);
    }

    public int getHouseUpgradeCost() {
        if (this.m_playerHouseLevel == PLAYER_HOUSE_LIST.length - 1) {
            return -1;
        }
        if (this.m_playerHouseLevel == 0) {
            return this.m_engine.getSimData().getAchievements(16) ? 1000 : 0;
        }
        return this.m_engine.getSimData().getAchievements(32) ? 2500 : 0;
    }

    public boolean isBestHouse() {
        return this.m_playerHouseLevel == PLAYER_HOUSE_LIST.length - 1;
    }

    public int getHouseUpgradeLevel() {
        return this.m_playerHouseLevel;
    }

    public int getPlayerHouseMMAnim() {
        return PLAYER_HOUSE_MM_ANIMS[this.m_playerHouseLevel];
    }

    public boolean gotBestFurniture() {
        int n;
        int n2 = 0;
        short[] sArray = this.m_playerHouseObjectTypes;
        int[] nArray = this.d_objectFlags;
        for (n = sArray.length - 1; n >= 0; --n) {
            short s = sArray[n];
            if (s == -1 || (nArray[s] & 0x20000) == 0 || AppEngine.indexOf((int)s, sArray, n + 1) != -1) continue;
            ++n2;
        }
        n = AppEngine.countOfFlags(131072, nArray);
        return n2 == n;
    }

    public void upgradePlayerHouse() {
        AppEngine.ASSERT(this.m_playerHouseLevel < PLAYER_HOUSE_LIST.length - 1, "invalid house upgrade");
        this.m_playerHouseLevel = (byte)(this.m_playerHouseLevel + 1);
        byte by = PLAYER_HOUSE_LIST[this.m_playerHouseLevel];
        byte[] byArray = this.d_houseObjectXs[by];
        byte[] byArray2 = this.d_houseObjectZs[by];
        short[] sArray = this.d_houseObjectTypes[by];
        byte[] byArray3 = this.d_houseObjectFacingDirs[by];
        short[] sArray2 = this.m_playerHouseObjectTypes;
        byte[] byArray4 = this.m_playerHouseObjectXs;
        byte[] byArray5 = this.m_playerHouseObjectZs;
        byte[] byArray6 = this.m_playerHouseObjectFacingDirs;
        for (int i = 0; i < sArray.length; ++i) {
            int n;
            short s = sArray[i];
            byte by2 = byArray[i];
            byte by3 = byArray2[i];
            if (s == sArray2[i]) {
                n = this.getObjectFlags(s);
                if ((n & 4) != 0) {
                    byte by4 = byArray4[i];
                    byte by5 = byArray5[i];
                    for (int j = 0; j < 150; ++j) {
                        int n2;
                        short s2;
                        if (i == j || (s2 = sArray2[j]) == -1) continue;
                        int n3 = this.getObjectFlags(s2);
                        byte by6 = byArray4[j];
                        byte by7 = byArray5[j];
                        if ((n3 & 0x80004) != 0 || by6 != by4 || by7 != by5) continue;
                        byArray4[j] = by2;
                        byArray5[j] = by3;
                        if ((n3 & 0x40000) == 0) continue;
                        int n4 = this.getObjectFootprintWidth(s2);
                        int n5 = this.getObjectFootprintHeight(s2);
                        byte by8 = byArray6[j];
                        if (by8 == 1 || by8 == 3) {
                            n2 = n4;
                            n4 = n5;
                            n5 = n2;
                        }
                        for (n2 = 0; n2 < 150; ++n2) {
                            short s3 = sArray2[n2];
                            if (s3 == -1 || (this.getObjectFlags(s3) & 0x80000) == 0) continue;
                            byte by9 = byArray4[n2];
                            byte by10 = byArray5[n2];
                            if (by9 > by6 || by10 > by7 || by9 <= by6 - n4 || by10 <= by7 - n5) continue;
                            int n6 = n2;
                            byArray4[n6] = (byte)(byArray4[n6] + (by2 - by6));
                            int n7 = n2;
                            byArray5[n7] = (byte)(byArray5[n7] + (by3 - by7));
                        }
                    }
                }
            } else if (sArray2[i] != -1) {
                n = AppEngine.indexOf(-1, sArray2);
                AppEngine.ASSERT(n != -1, "no slots left in house records");
                sArray2[n] = sArray2[i];
                byArray4[n] = byArray4[i];
                byArray5[n] = byArray5[i];
                byArray6[n] = byArray6[i];
                this.m_engine.getSimData().moveObject(i, n);
            }
            sArray2[i] = s;
            byArray4[i] = by2;
            byArray5[i] = by3;
            byArray6[i] = byArray3[i];
        }
        this.m_engine.getSimData().upgradePlayerHouse();
    }

    public int objectBuy(int n, int n2, int n3, int n4) {
        AppEngine.ASSERT(this.getHouseId() == 0, "buying at non-home house");
        int n5 = AppEngine.indexOf(-1, this.m_playerHouseObjectTypes);
        AppEngine.ASSERT(n5 != -1, "out of house object slots");
        this.m_playerHouseObjectTypes[n5] = (short)n;
        this.m_playerHouseObjectXs[n5] = (byte)this.coordWorldToWorldTileX(n2);
        this.m_playerHouseObjectZs[n5] = (byte)this.coordWorldToWorldTileZ(n3);
        this.m_playerHouseObjectFacingDirs[n5] = (byte)n4;
        return n5;
    }

    public void objectSell(int n) {
        AppEngine.ASSERT(this.getHouseId() == 0, "selling at non-home house");
        this.m_playerHouseObjectTypes[n] = -1;
        this.m_engine.getSimData().removeObjectValue(0, n);
    }

    public void objectRotate(int n, int n2) {
        AppEngine.ASSERT(this.getHouseId() == 0, "rotating at non-home house");
        this.m_playerHouseObjectFacingDirs[n] = (byte)n2;
    }

    public void objectChange(int n, int n2) {
        AppEngine.ASSERT(this.getHouseId() == 0, "changing at non-home house");
        this.m_playerHouseObjectTypes[n] = (short)n2;
    }

    public void objectChange(int n, int n2, int n3, int n4) {
        AppEngine.ASSERT(this.getHouseId() == 0, "changing at non-home house");
        this.m_playerHouseObjectXs[n] = (byte)this.coordWorldToWorldTileX(n2);
        this.m_playerHouseObjectZs[n] = (byte)this.coordWorldToWorldTileZ(n3);
        this.m_playerHouseObjectFacingDirs[n] = (byte)n4;
    }

    public boolean playerOwnsParentType(int n) {
        short[] sArray = this.m_playerHouseObjectTypes;
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            if (s == -1 || this.getObjectParent(s) != n) continue;
            return true;
        }
        return false;
    }

    public boolean playerOwnsObject(int n) {
        return AppEngine.indexOf(n, this.m_playerHouseObjectTypes) != -1;
    }

    public void resetRMSGameData() {
        this.m_playerHouseLevel = 0;
        this.initPlayerHouse();
    }

    public void loadRMSGameData(DataInputStream dataInputStream) throws IOException {
        this.m_playerHouseLevel = dataInputStream.readByte();
        for (int i = 0; i < this.m_playerHouseObjectTypes.length; ++i) {
            this.m_playerHouseObjectTypes[i] = dataInputStream.readShort();
            this.m_playerHouseObjectXs[i] = dataInputStream.readByte();
            this.m_playerHouseObjectZs[i] = dataInputStream.readByte();
            this.m_playerHouseObjectFacingDirs[i] = dataInputStream.readByte();
        }
    }

    public void saveRMSGameData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.m_playerHouseLevel);
        for (int i = 0; i < this.m_playerHouseObjectTypes.length; ++i) {
            dataOutputStream.writeShort(this.m_playerHouseObjectTypes[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectXs[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectZs[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectFacingDirs[i]);
        }
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.m_viewportX = n;
        this.m_viewportY = n2;
        this.m_viewportWidth = n3;
        this.m_viewportHeight = n4;
    }

    public int getViewportX() {
        return this.m_viewportX;
    }

    public int getViewportY() {
        return this.m_viewportY;
    }

    public int getViewportWidth() {
        return this.m_viewportWidth;
    }

    public int getViewportHeight() {
        return this.m_viewportHeight;
    }

    private void prepareWorld() {
        this.m_attribWidth = 64;
        this.m_attribHeight = 64;
        this.m_attribOffsetX = this.m_attribWidth >> 1;
        this.m_attribOffsetZ = this.m_attribHeight >> 1;
        this.m_screenOffsetX = 512;
        this.m_screenOffsetXF = this.m_screenOffsetX << 16;
        this.m_screenOffsetY = 264;
        this.m_screenOffsetYF = this.m_screenOffsetY << 16;
        if (this.m_attributesLayer == null) {
            this.m_attributesLayer = new byte[this.m_attribWidth * this.m_attribHeight];
        }
        AppEngine.fillArray(this.m_attributesLayer, 0);
    }

    public void prepareWorldHouse(int n) {
        if (n == 0) {
            n = PLAYER_HOUSE_LIST[this.m_playerHouseLevel];
        }
        this.m_houseIndex = n;
        this.prepareWorld();
        this.prepareWorldHouse2D(n);
        this.createObjectsHouse(n);
    }

    public void createObjectsHouse(int n) {
        byte by;
        int n2;
        int n3;
        int n4;
        int n5;
        SceneGame sceneGame = (SceneGame)this.m_engine.getScene();
        byte[] byArray = this.d_houseObjectXs[n];
        byte[] byArray2 = this.d_houseObjectZs[n];
        short[] sArray = this.d_houseObjectTypes[n];
        byte[] byArray3 = this.d_houseObjectFacingDirs[n];
        if (this.getHouseId() == 0) {
            byArray = this.m_playerHouseObjectXs;
            byArray2 = this.m_playerHouseObjectZs;
            sArray = this.m_playerHouseObjectTypes;
            byArray3 = this.m_playerHouseObjectFacingDirs;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = sArray.length;
        for (n5 = 0; n5 < n9; ++n5) {
            n4 = sArray[n5];
            if (n4 == -1) continue;
            n3 = byArray[n5];
            n2 = byArray2[n5];
            by = byArray3[n5];
            sceneGame.createObjectOnWorldTile(n4, n3, n2, by, n5);
            if (n6 != 0 || this.d_objectParents[n4] != 16) continue;
            n6 = 1;
            n7 = n3;
            n8 = n2;
        }
        if (n6 != 0) {
            n5 = this.m_attribOffsetX;
            n4 = 0;
            this.drawGarden(n7 += n5, n8 += n4, 3, 3);
        }
        this.drawRoad();
        n6 = this.getHouseId() == 0 ? 2 : 3;
        n7 = -1;
        n7 = AppEngine.indexOf(n6, sArray);
        AppEngine.ASSERT(n7 >= 0, "no player start");
        n8 = byArray[n7];
        n9 = byArray2[n7];
        n5 = 0;
        n4 = byArray3[n7];
        sceneGame.createObjectOnWorldTile(n5, n8, n9, n4, 0);
        n8 = n6 == 2 ? n7 : -1;
        SimData simData = sceneGame.getSimData();
        n5 = simData.getSimCount();
        for (n4 = 1; n4 < n5; ++n4) {
            if (simData.getSimHome(n4) != n || ((n3 = simData.getTimeFlags(n4)) & 8) == 0) continue;
            AppEngine.ASSERT((n8 = AppEngine.indexOf(2, sArray, n8 + 1)) >= 0, "no NPC start");
            n2 = byArray[n8];
            by = byArray2[n8];
            int n10 = 1;
            byte by2 = byArray3[n8];
            MapObjectSim mapObjectSim = (MapObjectSim)sceneGame.createObjectOnWorldTile(n10, n2, by, by2, n4);
            if ((n3 & 0x10) == 0 || this.m_engine.randPercent() >= 30) continue;
            sceneGame.putSimInBed(mapObjectSim);
        }
    }

    public boolean isBenchTopObjectAt(int n, int n2) {
        AppEngine.ASSERT(this.getHouseId() == 0, "check for bench-top in non-player home");
        byte[] byArray = this.m_playerHouseObjectXs;
        byte[] byArray2 = this.m_playerHouseObjectZs;
        short[] sArray = this.m_playerHouseObjectTypes;
        for (int i = 0; i < sArray.length; ++i) {
            int n3;
            short s = sArray[i];
            if (s == -1 || ((n3 = this.getObjectFlags(s)) & 0x80000) == 0 || n != byArray[i] || n2 != byArray2[i]) continue;
            return true;
        }
        return false;
    }

    public int getFirstFacing(int n) {
        for (int i = 0; i < 4; ++i) {
            if ((n & ROTATION_FLAGS[i]) == 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isAgainstWall(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        block5: {
            block4: {
                bl = true;
                if (n5 != 0 && n5 != 2) break block4;
                int n6 = 1;
                if (n5 == 2) {
                    n6 = -1;
                }
                int n7 = n - n3 * n6;
                int n8 = n2;
                for (int i = 0; i < n4 && bl; ++i) {
                    bl = (this.getAttribute(n7, n8 - i * n6) & 0x40) != 0;
                }
                break block5;
            }
            if (n5 != 1 && n5 != 3) break block5;
            int n9 = 1;
            if (n5 == 3) {
                n9 = -1;
            }
            int n10 = n;
            int n11 = n2 - n3 * n9;
            for (int i = 0; i < n4 && bl; ++i) {
                bl = (this.getAttribute(n10 - i * n9, n11) & 0x40) != 0;
            }
        }
        return bl;
    }

    private static final void DEBUG_FURNITUREPOS(String string) {
    }

    public int getObjectValidRotations(int n, int n2, int n3) {
        int n4 = this.getObjectFlags(n);
        int n5 = this.getObjectFootprintWidth(n);
        int n6 = this.getObjectFootprintHeight(n);
        int n7 = this.getObjectInterestPointCount(n);
        int n8 = 0;
        for (int i = 0; i < ROTATION_FLAGS.length; ++i) {
            int n9 = ROTATION_FLAGS[i];
            if ((n4 & n9) == 0) {
                SimWorld.DEBUG_FURNITUREPOS("skip rot");
                continue;
            }
            int n10 = n5;
            int n11 = n6;
            if (i == 1 || i == 3) {
                n10 = n6;
                n11 = n5;
            }
            if ((n4 & 0x80000) == 0 && !this.checkFootprintOK(n2, n3, n10, n11)) {
                SimWorld.DEBUG_FURNITUREPOS("skip footprint");
                continue;
            }
            if (n7 > 0) {
                int n12 = 0;
                for (int j = 0; j < n7; ++j) {
                    int n13;
                    int n14 = this.getObjectInterestPointX(n, j, i);
                    if (!this.isWorldTileWalkable(n2 + n14, n3 + (n13 = this.getObjectInterestPointZ(n, j, i)))) continue;
                    ++n12;
                }
                if (n12 < 1) {
                    SimWorld.DEBUG_FURNITUREPOS("skip interest");
                    continue;
                }
            }
            if ((n4 & 0x100000) != 0 && !this.isAgainstWall(n2, n3, n5, n6, i)) {
                SimWorld.DEBUG_FURNITUREPOS("skip !againstWall");
                continue;
            }
            if ((n4 & 0x200000) != 0 && this.isAgainstWall(n2, n3, n5, n6, i)) {
                SimWorld.DEBUG_FURNITUREPOS("skip againstWall");
                continue;
            }
            SimWorld.DEBUG_FURNITUREPOS("ok rot");
            n8 |= n9;
        }
        return n8;
    }

    public int createBuildPoints(int n) {
        SceneGame sceneGame = (SceneGame)this.m_engine.getScene();
        byte[] byArray = this.m_playerHouseObjectXs;
        byte[] byArray2 = this.m_playerHouseObjectZs;
        short[] sArray = this.m_playerHouseObjectTypes;
        byte[] byArray3 = this.m_playerHouseObjectFacingDirs;
        int n2 = this.getObjectFlags(n);
        int n3 = this.getObjectFootprintWidth(n);
        int n4 = this.getObjectFootprintHeight(n);
        int n5 = 0;
        int n6 = sArray.length;
        for (int i = 0; i < n6; ++i) {
            int n7;
            int n8;
            short s = sArray[i];
            if (s == -1) continue;
            byte by = byArray[i];
            byte by2 = byArray2[i];
            byte by3 = byArray3[i];
            int n9 = this.getObjectFlags(s);
            int n10 = this.getObjectFootprintWidth(s);
            int n11 = this.getObjectFootprintHeight(s);
            if ((n2 & 0x80000) != 0) {
                if ((n9 & 0x40000) == 0) continue;
                if (by3 == 1 || by3 == 3) {
                    n8 = n10;
                    n10 = n11;
                    n11 = n8;
                }
                for (n8 = 0; n8 < n10; ++n8) {
                    for (n7 = 0; n7 < n11; ++n7) {
                        int n12;
                        int n13;
                        int n14 = by - n8;
                        int n15 = by2 - n7;
                        if (this.isBenchTopObjectAt(n14, n15) || (n13 = this.getFirstFacing(n12 = this.getObjectValidRotations(n, n14, n15))) == -1) continue;
                        sceneGame.createObjectOnWorldTile(11, n14, n15, n13, -1);
                        ++n5;
                    }
                }
                continue;
            }
            if ((n9 & 4) == 0 || n10 != n3 || n11 != n4 || (n7 = this.getFirstFacing(n8 = this.getObjectValidRotations(n, by, by2))) == -1) continue;
            sceneGame.createObjectOnWorldTile(10, by, by2, n7, -1);
            ++n5;
        }
        return n5;
    }

    public void prepareWorldZoomMap(int n) {
        this.prepareWorld();
        AppEngine appEngine = this.m_engine;
        int n2 = 1;
        Image image = appEngine.getResourceManager().loadImage(n2);
        TileMap tileMap = new TileMap(n, image);
        tileMap.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setUseOffscreenBuffer(true);
        this.m_tileMap = tileMap;
        this.initAttributesZoomMap(n);
        this.createObjectsFromTilemap(true);
        SceneGame sceneGame = this.m_engine.getSceneGame();
        MapObject mapObject = sceneGame.findRandomObjectByType(3);
        AppEngine.ASSERT(mapObject != null, "no start point!");
        int n3 = this.coordWorldToWorldTileX(mapObject.getPosX());
        int n4 = this.coordWorldToWorldTileZ(mapObject.getPosZ());
        sceneGame.createObjectOnWorldTile(0, n3, n4, 3, 0);
        int n5 = appEngine.getEncounterNPCId();
        if (n5 != -1) {
            MapObject mapObject2 = sceneGame.createObjectOnWorldTile(1, n3, n4 - 1, 1, n5);
            sceneGame.setCursorObject(mapObject2);
            sceneGame.showContextMenu(mapObject2);
        }
    }

    public void prepareWorldMacromap(boolean bl) {
        this.prepareWorld();
        AppEngine appEngine = this.m_engine;
        int n = 3;
        Image image = appEngine.getResourceManager().loadImage(n);
        int n2 = 42;
        TileMap tileMap = new TileMap(n2, image);
        tileMap.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setUseOffscreenBuffer(true);
        this.m_tileMap = tileMap;
        this.initAttributesMacromap();
        this.createObjectsFromTilemap(false);
        SceneGame sceneGame = appEngine.getSceneGame();
        if (bl) {
            SimData simData = sceneGame.getSimData();
            int n3 = simData.getCareerRabbitHole(simData.getSimCareer(0));
            MapObject mapObject = sceneGame.findRandomObjectByType(n3);
            AppEngine.ASSERT(mapObject != null, "couldn't find workplace");
            sceneGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            sceneGame.startPlayerAction(165, mapObject, 0, 0);
        } else {
            int n4 = appEngine.getNextHouseId();
            if (n4 != -1) {
                this.m_houseIndex = 13;
                int n5 = this.getHouseMacroObject(n4);
                MapObject mapObject = sceneGame.findRandomObjectByType(n5);
                sceneGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            } else {
                sceneGame.createObject(0, appEngine.getEncounterPlayerX(), appEngine.getEncounterPlayerZ(), 0, 0);
                int n6 = appEngine.getEncounterNPCId();
                if (n6 != -1) {
                    sceneGame.createObject(1, appEngine.getEncounterNPCX(), appEngine.getEncounterNPCZ(), 0, n6);
                }
                appEngine.setupEncounter(null);
            }
        }
    }

    private void createObjectsFromTilemap(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        SceneGame sceneGame = this.m_engine.getSceneGame();
        TileMap tileMap = this.m_tileMap;
        int n7 = tileMap.getObjectCount();
        short[] sArray = tileMap.getObjectData();
        for (n6 = 0; n6 < n7; ++n6) {
            int n8 = n6 * 3;
            n5 = sArray[n8 + 0];
            n4 = sArray[n8 + 1] << 16;
            n3 = sArray[n8 + 2] << 16;
            n2 = this.coordScreenToWorldX(n4, n3);
            n = this.coordScreenToWorldZ(n4, n3);
            if (bl) {
                n2 = this.coordWorldTileToWorldCenterX(this.coordWorldToWorldTileX(n2));
                n = this.coordWorldTileToWorldCenterZ(this.coordWorldToWorldTileZ(n));
            }
            sceneGame.createObject(n5, n2, n, 0, -1);
        }
        n6 = tileMap.getAnimCount();
        short[] sArray2 = tileMap.getAnimData();
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n5 * 3;
            n3 = sArray2[n4 + 0];
            n2 = sArray2[n4 + 1] << 16;
            n = sArray2[n4 + 2] << 16;
            int n9 = this.coordScreenToWorldX(n2, n);
            int n10 = this.coordScreenToWorldZ(n2, n);
            if (bl) {
                n9 = this.coordWorldTileToWorldCenterX(this.coordWorldToWorldTileX(n9));
                n10 = this.coordWorldTileToWorldCenterZ(this.coordWorldToWorldTileZ(n10));
            }
            MapObject mapObject = sceneGame.createObject(99, n9, n10, 0, -1);
            mapObject.setAnim(n3);
            if (n3 == 177 || n3 == 178 || n3 == 179 || n3 == 180 || n3 == 181) {
                mapObject.setZSortOffset(-50);
                continue;
            }
            if (n3 != 158 && n3 != 159 && n3 != 160 && n3 != 161) continue;
            mapObject.setZSortOffset(-18);
        }
    }

    public void unload() {
        this.m_tileMap = null;
        this.m_tileMapWalls = null;
    }

    public void renderWorld(Graphics graphics) {
        this.renderWorld2D(graphics);
    }

    public int getCameraPixelX() {
        return this.m_viewportX + (this.m_viewportWidth >> 1) - (this.getCameraPosX() >> 16);
    }

    public int getCameraPixelY() {
        return this.m_viewportY + (this.m_viewportHeight >> 1) - (this.getCameraPosZ() >> 16);
    }

    public int coordWorldToScreenX(int n, int n2) {
        return (n - n2 << 1) + this.m_screenOffsetXF;
    }

    public int coordWorldToScreenY(int n, int n2) {
        return n + n2 + this.m_screenOffsetYF;
    }

    public int coordWorldToScreenPixelsX(int n, int n2) {
        return (n - n2 >> 15) + this.m_screenOffsetX;
    }

    public int coordWorldToScreenPixelsY(int n, int n2) {
        return (n + n2 >> 16) + this.m_screenOffsetY;
    }

    public int coordScreenToWorldX(int n, int n2) {
        return (n - this.m_screenOffsetXF >> 1) + (n2 - this.m_screenOffsetYF) >> 1;
    }

    public int coordScreenToWorldZ(int n, int n2) {
        return (-(n - this.m_screenOffsetXF) >> 1) + (n2 - this.m_screenOffsetYF) >> 1;
    }

    public int coordWorldTileToScreenTileX(int n, int n2) {
        return n - n2;
    }

    public int coordWorldTileToScreenTileY(int n, int n2) {
        return n + n2;
    }

    public int coordWorldTileToWorldCenterX(int n) {
        return (n << 19) + 262144;
    }

    public int coordWorldTileToWorldCenterZ(int n) {
        return (n << 19) + 262144;
    }

    public int coordWorldToWorldTileX(int n) {
        return n >> 19;
    }

    public int coordWorldToWorldTileZ(int n) {
        return n >> 19;
    }

    public boolean isWorldPointWalkable(int n, int n2) {
        return this.isWorldTileWalkable(this.coordWorldToWorldTileX(n), this.coordWorldToWorldTileZ(n2));
    }

    public boolean isWorldTileWalkable(int n, int n2) {
        int n3 = this.getAttribute(n, n2);
        return (n3 & 0x80) == 0;
    }

    public int getAttribute(int n, int n2) {
        if ((n += this.m_attribOffsetX) >= 0 && n < this.m_attribWidth && (n2 += this.m_attribOffsetZ) >= 0 && n2 < this.m_attribHeight) {
            int n3 = n + n2 * this.m_attribWidth;
            return this.m_attributesLayer[n3];
        }
        return 128;
    }

    private void setAttribute(int n, int n2, int n3, int n4) {
        if ((n += this.m_attribOffsetX) >= 0 && n < this.m_attribWidth && (n2 += this.m_attribOffsetZ) >= 0 && n2 < this.m_attribHeight) {
            byte[] byArray = this.m_attributesLayer;
            int n5 = n + n2 * this.m_attribWidth;
            int n6 = byArray[n5] & n3;
            byArray[n5] = (byte)(n6 | n4);
        }
    }

    public void paintAttributes(int n, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = this.m_attributesLayer;
        int n7 = this.m_attribWidth;
        int n8 = this.m_attribOffsetX + n;
        int n9 = this.m_attribOffsetX + n + n3;
        int n10 = this.m_attribOffsetZ + n2;
        int n11 = this.m_attribOffsetZ + n2 + n4;
        for (int i = n8; i < n9; ++i) {
            for (int j = n10; j < n11; ++j) {
                int n12 = i + j * n7;
                int n13 = byArray[n12] & n5;
                byArray[n12] = (byte)(n13 | n6);
            }
        }
    }

    public boolean checkFootprintOK(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (this.isWorldTileWalkable(n - i, n2 - j)) continue;
                return false;
            }
        }
        return true;
    }

    public TileMap getTileMap() {
        return this.m_tileMap;
    }

    private void renderWorld2D(Graphics graphics) {
        TileMap tileMap = this.m_tileMap;
        AppEngine appEngine = this.m_engine;
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setClip(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setCameraX(this.getCameraPosX() - (this.m_viewportWidth >> 1 << 16));
        tileMap.setCameraY(this.getCameraPosZ() - (this.m_viewportHeight >> 1 << 16));
        tileMap.render(graphics);
        this.renderObjects2D(graphics);
        graphics.setClip(n, n2, n3, n4);
        int n5 = this.getCameraPixelX() + 431;
        int n6 = this.getCameraPixelY() + 203;
        int n7 = this.getCameraPixelX() + 123;
        int n8 = this.getCameraPixelY() + 155;
        if (this.m_engine.getSceneGame().isMapMode()) {
            graphics.drawImage(appEngine.skiing_icon, this.getCameraPixelX() + 130, this.getCameraPixelY() + 215, 40);
        }
        if (this.m_engine.getSceneGame().isMapMode() && appEngine.getSimData().plantSnowMan()) {
            graphics.drawImage(appEngine.snow_man, n5, n6, 33);
        }
        if (this.m_engine.getSceneGame().isMapMode() && appEngine.getSimData().plantReindeerSleigh()) {
            graphics.drawImage(appEngine.reindeersleigh, n7, n8, 33);
        }
        if (appEngine.m_rmsGSWinterSeasonEnabled && this.m_engine.getSceneGame().isMapMode()) {
            for (int i = 0; i < appEngine.m_snowParticle.length; ++i) {
                appEngine.m_snowParticle[i].drawSnow(graphics);
            }
        }
    }

    public void glowLightForXmas() {
        LIGHT_UP = true;
        AppEngine appEngine = this.m_engine;
        appEngine.m_rmsGSXmasLightingEnabled = true;
        appEngine.saveRMSAppSettings();
    }

    public void switchOffLightForXmas() {
        LIGHT_UP = false;
        AppEngine appEngine = this.m_engine;
        appEngine.m_rmsGSXmasLightingEnabled = false;
        appEngine.saveRMSAppSettings();
    }

    /*
     * WARNING - void declaration
     */
    private void prepareWorldHouse2D(int n) {
        void var18_21;
        int n2;
        int n3;
        int n4;
        byte by;
        void var18_19;
        Object object;
        int n5;
        Object object2;
        int n6;
        Object object3;
        Object object4;
        AppEngine appEngine = this.m_engine;
        if (this.m_tileMap == null) {
            object4 = appEngine.getResourceManager().loadImage(1);
            object3 = new TileMap(64, 64, (Image)object4);
            ((TileMap)object3).setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
            ((TileMap)object3).setUseOffscreenBuffer(true);
            this.m_tileMap = object3;
        }
        if (this.m_tileMapWalls == null) {
            object4 = appEngine.getResourceManager().loadImage(4);
            this.m_tileMapWalls = object3 = new TileMap(64, 64, (Image)object4);
            ((TileMap)object3).setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
            this.m_tileMap.setLinkedTileMap((TileMap)object3);
        }
        object4 = this.d_houseRoomXs[n];
        object3 = this.d_houseRoomYs[n];
        byte[] byArray = this.d_houseRoomWidths[n];
        byte[] byArray2 = this.d_houseRoomHeights[n];
        byte[] byArray3 = this.d_houseRoomFloors[n];
        byte[] byArray4 = this.d_houseRoomWalls[n];
        byte[] byArray5 = this.d_houseDoorXs[n];
        byte[] byArray6 = this.d_houseDoorYs[n];
        byte[] byArray7 = this.d_houseDoorWidths[n];
        int n7 = ((Image)object4).length;
        int n8 = byArray5.length;
        for (n6 = 0; n6 < n7; ++n6) {
            object2 = object4[n6];
            Object object5 = object3[n6];
            n5 = byArray[n6];
            object = byArray2[n6];
            this.paintAttributes((int)object2, (int)object5, n5, (int)object, 255, n6 + 1 | 0x10);
            this.paintAttributes((int)(object2 - true), (int)(object5 - true), n5 + 2, 1, 255, 128);
            this.paintAttributes((int)(object2 - true), (int)(object5 + object), n5 + 2, 1, 255, 128);
            this.paintAttributes((int)(object2 - true), (int)object5, 1, (int)object, 255, 128);
            this.paintAttributes((int)(object2 + n5), (int)object5, 1, (int)object, 255, 128);
        }
        for (n6 = 0; n6 < n8; ++n6) {
            object2 = byArray5[n6];
            byte by2 = byArray6[n6];
            n5 = Math.abs(byArray7[n6]);
            if ((this.getAttribute((int)(object2 - true), by2) & 0x80) != 0) {
                this.paintAttributes((int)object2, by2, n5, 1, -129, 0);
                continue;
            }
            this.paintAttributes((int)object2, by2, 1, n5, -129, 0);
            byArray7[n6] = (byte)(-n5);
        }
        AppEngine.fillArray(this.m_tileMap.getTileMapData(), 16);
        AppEngine.fillArray(this.m_tileMapWalls.getTileMapData(), 60);
        n6 = this.m_attribOffsetX;
        object2 = false;
        boolean bl = false;
        while (var18_19 < n7) {
            n5 = n6 + object4[var18_19];
            object = object2 + object3[var18_19];
            by = byArray[var18_19];
            n4 = byArray2[var18_19];
            n3 = byArray3[var18_19];
            n2 = byArray4[var18_19];
            this.drawRoom(n5, (int)object, by, n4, n3, n2);
            ++var18_19;
        }
        boolean bl2 = false;
        while (var18_21 < n8) {
            n5 = byArray5[var18_21];
            object = byArray6[var18_21];
            by = byArray7[var18_21];
            if (by > 0) {
                n4 = this.getAttribute(n5, object - 1);
                n3 = this.getAttribute(n5, object + 1);
            } else {
                n4 = this.getAttribute(n5 - 1, (int)object);
                n3 = this.getAttribute(n5 + 1, (int)object);
            }
            n2 = (n4 & 0xF) - 1;
            int n9 = (n3 & 0xF) - 1;
            int n10 = n2 == -1 ? 3 : byArray3[n2];
            int n11 = n9 == -1 ? 3 : byArray3[n9];
            byte by3 = n9 == -1 ? (byte)0 : byArray4[n9];
            this.drawDoor(n6 + n5, (int)(object2 + object), Math.abs(by), n10, n11, by3, by < 0 ? 2 : 1);
            ++var18_21;
        }
        this.tilemapFixupHouse();
        this.initAttributesHouse();
        this.m_tileMap.refreshOffscreenBuffer();
    }

    private void drawRoom(int n, int n2, int n3, int n4, int n5, int n6) {
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        byte[] byArray2 = this.m_tileMapWalls.getTileMapData();
        int n7 = tileMap.getWidth();
        int n8 = this.coordWorldTileToScreenTileX(n, n2);
        int n9 = this.coordWorldTileToScreenTileY(n, n2);
        int n10 = n3 + n4;
        byte by = this.getTile(5, n5);
        byte by2 = this.getTile(12, n6);
        byte by3 = this.getTile(18, n6);
        byte by4 = this.getTile(8, n6);
        byte by5 = this.getTile(14, n6);
        int n11 = n8 - n4;
        int n12 = n9 + n4;
        int n13 = n12 + 1;
        for (int i = 0; i < n10; ++i) {
            int n14;
            byte by6;
            byte by7;
            boolean bl = i < n4;
            boolean bl2 = i < n3;
            byArray2[n11 + (n12 - 0) * n7] = by7 = bl ? by2 : by3;
            byArray2[n11 + (n12 - 1) * n7] = by6 = bl ? by4 : by5;
            byArray2[n11 + (n13 + 0) * n7] = n14 = bl2 ? 56 : 48;
            int n15 = n13 - n12 + 2;
            for (int j = 0; j < n15; ++j) {
                byArray[n11 + (n12 + j) * n7] = by;
            }
            if (i == 0) {
                byArray2[n11 - 1 + (n12 + 0) * n7] = this.getTile(20, n6);
            } else if (i == n10 - 1) {
                byArray2[n11 + 1 + (n12 + 0) * n7] = this.getTile(21, n6);
            }
            ++n11;
            if (i != n3 - 1) {
                n13 += bl2 ? 1 : -1;
            }
            if (i == n4 - 1) continue;
            n12 += bl ? -1 : 1;
        }
    }

    private void drawDoor(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl;
        TileMap tileMap = this.m_tileMap;
        int n8 = tileMap.getWidth();
        byte[] byArray = this.m_tileMapWalls.getTileMapData();
        int n9 = this.coordWorldTileToScreenTileX(n, n2);
        int n10 = this.coordWorldTileToScreenTileY(n, n2);
        boolean bl2 = bl = (n7 & 1) != 0;
        if (bl) {
            byte by = this.getTile(24, n6);
            byte by2 = this.getTile(25, n6);
            byte by3 = this.getTile(7, n4);
            int n11 = --n9 + n10 * n8;
            byArray[n11] = by;
            byArray[n11 += n8] = by2;
            byArray[n11 += n8] = by3;
            for (int i = 0; i < n3; ++i) {
                n11 = ++n9 + ++n10 * n8;
                byArray[n11] = 60;
                byArray[n11 += n8] = 60;
                byArray[n11 += n8] = by3;
            }
            n11 = ++n9 + ++n10 * n8;
            byArray[n11] = 52;
            if (byArray[n11 += n8] == 60) {
                byArray[n11] = this.getTile(14, n6);
                byArray[n11 += n8] = this.getTile(18, n6);
            }
        } else {
            byte by = this.getTile(22, n6);
            byte by4 = this.getTile(23, n6);
            byte by5 = this.getTile(6, n4);
            int n12 = (n9 -= 2) + ((n10 += 2) + 0) * n8;
            byArray[n12] = 52;
            if (byArray[n12 += n8] == 60) {
                byArray[n12] = this.getTile(8, n6);
                byArray[n12 += n8] = this.getTile(12, n6);
            }
            for (int i = 0; i < n3; ++i) {
                n12 = ++n9 + (--n10 + 0) * n8;
                byArray[n12] = 60;
                byArray[n12 += n8] = 60;
                byArray[n12 += n8] = by5;
            }
            n12 = ++n9 + (--n10 + 0) * n8;
            byArray[n12] = by;
            byArray[n12 += n8] = by4;
            byArray[n12 += n8] = by5;
        }
    }

    private void drawGarden(int n, int n2, int n3, int n4) {
        int n5;
        AppEngine appEngine = this.m_engine;
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        int n6 = tileMap.getWidth();
        int n7 = this.coordWorldTileToScreenTileX(n, n2);
        int n8 = this.coordWorldTileToScreenTileY(n, n2);
        int n9 = n3 + n4 + 2;
        int n10 = n7 - n4 - 1;
        int n11 = n5 = n8 + n4 + 1;
        byArray[n10 - 1 + (n5 - 2) * n6] = 4;
        byArray[n10 - 1 + (n5 - 1) * n6] = 12;
        byArray[n10 - 1 + n5 * n6] = 13;
        byArray[n10 - 1 + (n5 + 1) * n6] = 21;
        byArray[n10 - 2 + (n5 - 1) * n6] = 4;
        byArray[n10 - 2 + n5 * n6] = 21;
        for (int i = 0; i < n9; ++i) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            boolean bl = i < n4 + 1;
            boolean bl2 = i < n3 + 1;
            int n17 = n11 - n5;
            for (n16 = 0; n16 < n17; ++n16) {
                byArray[n10 + (n5 + n16) * n6] = n15 = appEngine.randPercent() < 50 ? 6 : 7;
            }
            byArray[n10 + (n5 - 1) * n6] = n16 = bl ? 22 : 23;
            byArray[n10 + (n5 - 3) * n6] = n15 = bl ? 4 : 5;
            byArray[n10 + n11 * n6] = n14 = bl2 ? 15 : 14;
            byArray[n10 + (n11 + 2) * n6] = n13 = bl2 ? 21 : 20;
            byArray[n10 + (n5 - 2) * n6] = n12 = appEngine.randPercent() < 50 ? 12 : 13;
            byArray[n10 + (n11 + 1) * n6] = n12;
            if (i != n3) {
                n11 += bl2 ? 1 : -1;
            }
            if (i != n4) {
                n5 += bl ? -1 : 1;
            }
            ++n10;
        }
        byArray[n10 + (n5 - 3) * n6] = 5;
        byArray[n10 + (n5 - 2) * n6] = 12;
        byArray[n10 + (n5 - 1) * n6] = 13;
        byArray[n10 + n5 * n6] = 20;
        byArray[n10 + 1 + (n5 - 2) * n6] = 5;
        byArray[n10 + 1 + (n5 - 1) * n6] = 20;
    }

    private void drawRoad() {
        byte[] byArray;
        byte[] byArray2;
        SceneGame sceneGame = this.m_engine.getSceneGame();
        int n = 0;
        MapObject mapObject = sceneGame.findRandomObjectByParentType(10);
        if (mapObject.getFacingDir() == 1) {
            n = 1;
            byArray2 = this.getTileArray(1);
            this.drawCorner(1, byArray2);
            byArray = new byte[]{16, 86, 94, 6, 6, 6, 6, 6};
            this.drawCorner(0, byArray);
        } else {
            byArray2 = this.getTileArray(0);
            this.drawCorner(0, byArray2);
            byArray = new byte[]{17, 87, 95, 7, 7, 7, 7, 7};
            this.drawCorner(1, byArray);
        }
        if (n == 0) {
            int n2;
            int n3 = 21;
            int n4 = this.coordWorldToWorldTileZ(mapObject.getPosZ());
            sceneGame.createObjectOnWorldTile(57, n3, n4, n, -1);
            for (n2 = n4 + 6; n2 < 15; n2 += 4) {
                sceneGame.createObjectOnWorldTile(54, n3, n2, n, -1);
            }
            for (n2 = n4 - 6; n2 > -14; n2 -= 4) {
                sceneGame.createObjectOnWorldTile(54, n3, n2, n, -1);
            }
        } else {
            int n5;
            int n6 = this.coordWorldToWorldTileX(mapObject.getPosX());
            int n7 = 21;
            sceneGame.createObjectOnWorldTile(57, n6, n7, n, -1);
            for (n5 = n6 + 6; n5 < 15; n5 += 4) {
                sceneGame.createObjectOnWorldTile(54, n5, n7, n, -1);
            }
            for (n5 = n6 - 6; n5 > -14; n5 -= 4) {
                sceneGame.createObjectOnWorldTile(54, n5, n7, n, -1);
            }
        }
    }

    private void drawCorner(int n, byte[] byArray) {
        TileMap tileMap = this.m_tileMap;
        byte[] byArray2 = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        int n4 = byArray.length - 1;
        int n5 = n2 - n4;
        int n6 = n3 - 1;
        int n7 = 1;
        int n8 = -1;
        if (n == 1) {
            n5 = n4 - 1;
            n7 = -1;
        }
        byte[] byArray3 = this.getTileArray(2);
        byte[] byArray4 = this.getTileArray(3);
        while (n5 >= 0 && n5 < n2) {
            for (int i = 0; n6 + i < n3 && i < byArray.length; ++i) {
                int n9;
                byte by = byArray[i];
                if ((n5 & 1) == 0 && (n9 = AppEngine.indexOf((int)by, byArray3)) != -1) {
                    by = byArray4[n9];
                }
                n9 = n6 + i;
                byArray2[n5 + n9 * n2] = by;
                int n10 = tileMap.coordTileToWorldX(n5);
                int n11 = tileMap.coordTileToWorldY(n9);
                int n12 = this.coordScreenToWorldX(n10, n11);
                int n13 = this.coordScreenToWorldZ(n10, n11);
                int n14 = this.coordWorldToWorldTileX(n12);
                int n15 = this.coordWorldToWorldTileZ(n13);
                this.setAttribute(n14, n15, 255, 128);
            }
            n5 += n7;
            n6 += n8;
        }
    }

    private void tilemapFixupHouse() {
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = this.m_tileMapWalls.getTileMapData();
        byte[] byArray2 = tileMap.getTileMapData();
        int n = tileMap.getWidth();
        int n2 = tileMap.getHeight();
        byte[] byArray3 = this.getTileArray(4);
        byte[] byArray4 = this.getTileArray(5);
        byte[] byArray5 = this.getTileArray(26);
        byte[] byArray6 = this.getTileArray(8);
        byte[] byArray7 = this.getTileArray(14);
        byte[] byArray8 = this.getTileArray(20);
        byte[] byArray9 = this.getTileArray(21);
        for (int i = 1; i < n - 1; ++i) {
            boolean bl = false;
            for (int j = 0; j < n2 - 1; ++j) {
                int n3;
                int n4;
                int n5 = i + (j + 0) * n;
                int n6 = n5 + n;
                byte by = byArray2[n5];
                byte by2 = byArray2[n6];
                int n7 = byArray[n5];
                byte by3 = byArray[n6];
                if (n7 == 56 && by3 == 60) {
                    by3 = byArray7[0];
                }
                if (n7 == 48 && by3 == 60) {
                    by3 = byArray6[0];
                }
                if ((this.getTileIndex(n7, 27) != -1 || AppEngine.indexOf(n7, byArray8) != -1) && by3 == 60) {
                    by3 = byArray7[0];
                    n4 = n5 + n;
                    if (byArray[n4] == 60) {
                        byArray[n4] = this.getTile(18, 0);
                    }
                }
                if ((AppEngine.indexOf(n7, byArray5) != -1 || AppEngine.indexOf(n7, byArray9) != -1) && by3 == 60) {
                    by3 = byArray6[0];
                    n4 = n5 + n;
                    if (byArray[n4] == 60) {
                        byArray[n4] = this.getTile(12, 0);
                    }
                }
                n4 = -1;
                n4 = AppEngine.indexOf(n7, byArray7);
                if (n4 != -1) {
                    if (AppEngine.indexOf((int)by3, byArray6) != -1 || AppEngine.indexOf((int)by3, byArray8) != -1) {
                        n7 = byArray9[n4];
                    } else {
                        n3 = AppEngine.indexOf((int)by2, byArray4);
                        if (n3 != -1 && by3 == 60) {
                            by3 = this.getTile(18, n4);
                        }
                    }
                }
                if ((n4 = AppEngine.indexOf(n7, byArray6)) != -1) {
                    if (AppEngine.indexOf((int)by3, byArray7) != -1 || AppEngine.indexOf((int)by3, byArray9) != -1) {
                        n7 = byArray8[n4];
                    } else {
                        n3 = AppEngine.indexOf((int)by2, byArray4);
                        if (n3 != -1 && by3 == 60) {
                            by3 = this.getTile(12, n4);
                        }
                    }
                }
                if ((n3 = AppEngine.indexOf((int)by, byArray4)) != -1) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = -1;
                    n11 = AppEngine.indexOf((int)by3, byArray6);
                    if (n11 != -1 || (n11 = AppEngine.indexOf((int)by3, byArray8)) != -1) {
                        if (!bl) {
                            int n12 = this.getTile(10, n11);
                            n10 = this.getTile(11, n11);
                            for (n9 = 0; n9 < 5; ++n9) {
                                byArray[i + (j - n9) * n] = n8 = n9 == 4 ? n12 : n10;
                            }
                            n7 = n10;
                            byArray[i + (j - 5 - 1) * n] = 52;
                            n9 = i + (j - 5 - 0) * n;
                            byArray[n9] = this.getTile(9, n11);
                            if (byArray[--n9] == 52) {
                                byArray[n9] = 48;
                            }
                            if ((n11 = AppEngine.indexOf((int)by3, byArray6)) != -1) {
                                by3 = this.getTile(13, n11);
                            } else {
                                n11 = AppEngine.indexOf((int)by3, byArray8);
                                if (n11 != -1) {
                                    by3 = this.getTile(27, n11);
                                }
                            }
                            bl = true;
                        } else if (n7 == 60) {
                            n7 = 48;
                        }
                    } else {
                        n11 = AppEngine.indexOf((int)by3, byArray7);
                        if (n11 != -1 || (n11 = AppEngine.indexOf((int)by3, byArray9)) != -1) {
                            if (!bl) {
                                int n13 = this.getTile(16, n11);
                                n10 = this.getTile(17, n11);
                                for (n9 = 0; n9 < 5; ++n9) {
                                    byArray[i + (j - n9 - 1) * n] = n8 = n9 == 3 ? n13 : n10;
                                }
                                n7 = n10;
                                n9 = i + (j - 5 - 1) * n;
                                n8 = byArray[n9 - 1];
                                byArray[n9] = this.getTileIndex(n8, 15) != -1 || n8 == 52 ? 56 : 52;
                                byArray[i + (j - 5 - 0) * n] = this.getTile(15, n11);
                                if (byArray[--n9] == 52) {
                                    byArray[n9] = 48;
                                }
                                if ((n11 = AppEngine.indexOf((int)by3, byArray7)) != -1) {
                                    by3 = this.getTile(19, n11);
                                } else {
                                    n11 = AppEngine.indexOf((int)by3, byArray9);
                                    if (n11 != -1) {
                                        by3 = byArray5[n11];
                                    }
                                }
                                bl = true;
                            } else if (n7 == 60) {
                                n7 = 56;
                            }
                        } else {
                            int n14;
                            int n15;
                            int n16;
                            byte[] byArray10 = this.getTileArray(24);
                            if (n3 == 3) {
                                n10 = this.m_engine.rand(0, byArray3.length - 1);
                                by = byArray3[n10];
                            }
                            n10 = -1;
                            n9 = byArray[i + 1 + j * n];
                            n10 = AppEngine.indexOf(n9, byArray8);
                            if (n10 != -1) {
                                if (!bl) {
                                    n10 = 0;
                                    n8 = this.getTile(30, n10);
                                    n16 = this.getTile(29, n10);
                                    for (n15 = 0; n15 < 5; ++n15) {
                                        byArray[i + (j - n15 - 1) * n] = n14 = n15 == 4 ? n8 : n16;
                                    }
                                    n7 = this.getTile(28, n10);
                                    n15 = i + (j - 1 - 5) * n;
                                    byArray[n15] = this.getTile(22, n10);
                                    bl = true;
                                } else if (n7 == 60) {
                                    n7 = this.getTile(22, 0);
                                }
                                if (by3 == 60) {
                                    by3 = this.getTile(23, 0);
                                }
                            }
                            n8 = -1;
                            n16 = byArray[i - 1 + j * n];
                            if (AppEngine.indexOf(n16, byArray9) != -1) {
                                if (n7 == 60) {
                                    n15 = byArray[i - 1 + (j + 1) * n];
                                    n14 = AppEngine.indexOf(n15, byArray6);
                                    n7 = byArray10[n14];
                                    by3 = this.getTile(25, n14);
                                }
                            } else {
                                n8 = AppEngine.indexOf(n16, byArray5);
                                if (n8 != -1) {
                                    if (!bl) {
                                        int n17;
                                        n8 = 0;
                                        n15 = this.getTile(33, n8);
                                        n14 = this.getTile(32, n8);
                                        for (n17 = 0; n17 < 5; ++n17) {
                                            int n18;
                                            byArray[i + (j - n17 - 1) * n] = n18 = n17 == 4 ? n15 : n14;
                                        }
                                        n7 = this.getTile(31, n8);
                                        n17 = i + (j - 1 - 5) * n;
                                        byArray[n17] = byArray10[n8];
                                        bl = true;
                                        if (byArray[n17 -= n + 1] == 52) {
                                            byArray[n17] = 56;
                                        }
                                    } else if (n7 == 60) {
                                        n7 = byArray10[n8];
                                    }
                                    if (by3 == 60) {
                                        by3 = this.getTile(25, n8);
                                    }
                                }
                            }
                        }
                    }
                }
                byArray2[n5] = by;
                byArray2[n6] = by2;
                byArray[n5] = n7;
                byArray[n6] = by3;
            }
        }
    }

    private void initAttributesHouse() {
        int n;
        TileMap tileMap = this.m_tileMapWalls;
        byte[] byArray = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        byte[] byArray2 = this.m_attributesLayer;
        for (n = 0; n < this.m_attributesLayer.length; ++n) {
            if ((byArray2[n] & 0x80) == 0) continue;
            int n4 = n;
            byArray2[n4] = (byte)(byArray2[n4] | 0x40);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[n + i * n2];
                if (n != 0 && n != n2 - 1 && i != 0 && i != n3 - 1 && this.getTileIndex(by, 11) == -1 && this.getTileIndex(by, 17) == -1 && this.getTileIndex(by, 31) == -1 && this.getTileIndex(by, 32) == -1 && this.getTileIndex(by, 33) == -1 && this.getTileIndex(by, 8) == -1 && this.getTileIndex(by, 10) == -1 && this.getTileIndex(by, 9) == -1 && this.getTileIndex(by, 14) == -1 && this.getTileIndex(by, 16) == -1 && this.getTileIndex(by, 15) == -1) continue;
                int n5 = tileMap.coordTileToWorldX(n);
                int n6 = tileMap.coordTileToWorldY(i);
                int n7 = this.coordScreenToWorldX(n5, n6);
                int n8 = this.coordScreenToWorldZ(n5, n6);
                int n9 = this.coordWorldToWorldTileX(n7);
                int n10 = this.coordWorldToWorldTileZ(n8);
                this.setAttribute(n9, n10, 255, 128);
            }
        }
    }

    private void initAttributesMacromap() {
        int n;
        byte by;
        int n2;
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        int n3 = tileMap.getWidth();
        int n4 = tileMap.getHeight();
        byte[] byArray2 = this.getTileArray(34);
        AppEngine.fillArray(this.m_attributesLayer, 128);
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                by = byArray[i + n2 * n3];
                if (AppEngine.indexOf((int)by, byArray2) == -1) continue;
                n = tileMap.coordTileToWorldX(i);
                int n5 = tileMap.coordTileToWorldY(n2);
                int n6 = this.coordScreenToWorldX(n, n5);
                int n7 = this.coordScreenToWorldZ(n, n5);
                int n8 = this.coordWorldToWorldTileX(n6);
                int n9 = this.coordWorldToWorldTileZ(n7);
                this.setAttribute(n8, n9, -129, 32);
                this.setAttribute(n8 + 1, n9, 255, 16);
                this.setAttribute(n8 - 1, n9, 255, 16);
                this.setAttribute(n8, n9 + 1, 255, 16);
                this.setAttribute(n8, n9 - 1, 255, 16);
            }
        }
        byte[] byArray3 = this.m_attributesLayer;
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            by = byArray3[n2];
            n = 255;
            if ((by & 0x20) != 0) {
                n &= 0xFFFFFFEF;
            }
            if ((by & 0x10) != 0) {
                n &= 0xFFFFFF7F;
            }
            byArray3[n2] = (byte)(by & n);
        }
    }

    private void initAttributesZoomMap(int n) {
        byte[] byArray = this.getTileArray(n == 41 ? 36 : 35);
        TileMap tileMap = this.m_tileMap;
        byte[] byArray2 = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                boolean bl;
                byte by = byArray2[i + j * n2];
                boolean bl2 = bl = AppEngine.indexOf((int)by, byArray) != -1;
                if (i != 0 && i != n2 - 1 && j != 0 && j != n3 - 1 && !bl) continue;
                int n4 = i;
                if (!bl && n4 == n2 - 1) {
                    ++n4;
                }
                int n5 = tileMap.coordTileToWorldX(n4);
                int n6 = tileMap.coordTileToWorldY(j);
                int n7 = this.coordScreenToWorldX(n5, n6);
                int n8 = this.coordScreenToWorldZ(n5, n6);
                int n9 = this.coordWorldToWorldTileX(n7);
                int n10 = this.coordWorldToWorldTileZ(n8);
                this.setAttribute(n9, n10, 255, 128);
            }
        }
    }

    private void objectsZSort() {
        AppEngine appEngine = this.m_engine;
        SceneGame sceneGame = appEngine.getSceneGame();
        MapObject[] mapObjectArray = sceneGame.getObjects();
        boolean bl = false;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            for (int j = 1; j < mapObjectArray.length; ++j) {
                int n;
                MapObject mapObject = mapObjectArray[j];
                MapObject mapObject2 = mapObjectArray[j - 1];
                int n2 = this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
                if (n2 < (n = this.coordWorldToScreenPixelsX(mapObject2.getPosX(), mapObject2.getPosZ()))) {
                    if (mapObject.getZSortOrderRight() < mapObject2.getZSortOrderLeft()) {
                        mapObjectArray[j - 1] = mapObject;
                        mapObjectArray[j] = mapObject2;
                        bl = true;
                    }
                    if (mapObject.getType() == 99 && mapObject2.getType() == 0 && mapObjectArray.length < 25 && (mapObject.getZSortOrderRight() == 176 || mapObject.getZSortOrderRight() == 144 || mapObject.getZSortOrderRight() == 112 || mapObject.getZSortOrderRight() == 80 || mapObject.getZSortOrderRight() == 48)) {
                        mapObjectArray[j - 1] = mapObject;
                        mapObjectArray[j] = mapObject2;
                        bl = true;
                    }
                    if (mapObject.getType() != 0 || mapObject2.getType() != 99 || mapObjectArray.length >= 25 || mapObject2.getZSortOrderRight() != 400 && mapObject2.getZSortOrderRight() != 368 && mapObject2.getZSortOrderRight() != 336 && mapObject2.getZSortOrderRight() != 304 && mapObject2.getZSortOrderRight() != 272) continue;
                    mapObjectArray[j - 1] = mapObject;
                    mapObjectArray[j] = mapObject2;
                    bl = true;
                    continue;
                }
                if (mapObject.getZSortOrderLeft() < mapObject2.getZSortOrderRight()) {
                    mapObjectArray[j - 1] = mapObject;
                    mapObjectArray[j] = mapObject2;
                    bl = true;
                }
                if (mapObject.getType() == 99 && mapObject2.getType() == 0 && mapObjectArray.length < 25 && (mapObject.getZSortOrderRight() == 176 || mapObject.getZSortOrderRight() == 144 || mapObject.getZSortOrderRight() == 112 || mapObject.getZSortOrderRight() == 80)) {
                    mapObjectArray[j - 1] = mapObject;
                    mapObjectArray[j] = mapObject2;
                    bl = true;
                }
                if (mapObject.getType() != 0 || mapObject2.getType() != 99 || mapObjectArray.length >= 25 || mapObject2.getZSortOrderRight() != 400 && mapObject2.getZSortOrderRight() != 368 && mapObject2.getZSortOrderRight() != 336 && mapObject2.getZSortOrderRight() != 304 && mapObject2.getZSortOrderRight() != 272) continue;
                mapObjectArray[j - 1] = mapObject;
                mapObjectArray[j] = mapObject2;
                bl = true;
            }
            if (!bl) break;
            bl = false;
        }
    }

    private void objectsCheckInView2D() {
        AppEngine appEngine = this.m_engine;
        SceneGame sceneGame = appEngine.getSceneGame();
        MapObject[] mapObjectArray = sceneGame.getObjects();
        int n = this.m_viewportX - 50;
        int n2 = this.m_viewportY - 20;
        int n3 = this.m_viewportX + this.m_viewportWidth + 50;
        int n4 = this.m_viewportY + this.m_viewportHeight + 60;
        int n5 = this.getCameraPixelX();
        int n6 = this.getCameraPixelY();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            int n7 = n5 + this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
            int n8 = n6 + this.coordWorldToScreenPixelsY(mapObject.getPosX(), mapObject.getPosZ());
            mapObject.setInView(n7 >= n && n7 <= n3 && n8 >= n2 && n8 <= n4);
        }
    }

    private void renderObjects2D(Graphics graphics) {
        this.objectsZSort();
        this.objectsCheckInView2D();
        AppEngine appEngine = this.m_engine;
        SceneGame sceneGame = appEngine.getSceneGame();
        MapObject[] mapObjectArray = sceneGame.getObjects();
        int n = mapObjectArray.length;
        for (int i = 0; i < n; ++i) {
            MapObject mapObject = mapObjectArray[i];
            AppEngine.ASSERT(mapObject != null, "null object in render");
            if (!mapObject.isInView() || mapObject.getRuntimeFlag(8192) || mapObject.getType() == 42 && !appEngine.getSimData().plantReindeerSleigh()) continue;
            mapObject.render2D(graphics);
        }
    }

    public void renderObjects2D(Graphics graphics, MapObject mapObject, MapObject mapObject2, int n, int n2) {
        int n3 = this.m_cameraPosX;
        int n4 = this.m_cameraPosZ;
        this.m_cameraPosX = n;
        this.m_cameraPosZ = n2;
        AppEngine appEngine = this.m_engine;
        SceneGame sceneGame = appEngine.getSceneGame();
        MapObject[] mapObjectArray = sceneGame.getObjects();
        int n5 = mapObjectArray.length;
        for (int i = 0; i < n5; ++i) {
            MapObject mapObject3 = mapObjectArray[i];
            if (mapObject3 != mapObject && mapObject3 != mapObject2) continue;
            mapObject3.render2D(graphics);
        }
        this.m_cameraPosX = n3;
        this.m_cameraPosZ = n4;
    }

    public void setCameraPosX(int n) {
        this.m_cameraPosX = n;
    }

    public void setCameraPosZ(int n) {
        this.m_cameraPosZ = n;
    }

    public int getCameraPosX() {
        return this.m_cameraPosX;
    }

    public int getCameraPosZ() {
        return this.m_cameraPosZ;
    }

    public int getObjectCount() {
        return this.d_objectStringIds.length;
    }

    public int getObjectParent(int n) {
        return this.d_objectParents[n];
    }

    public int getObjectStringId(int n) {
        return this.d_objectStringIds[n];
    }

    public int getObjectActionIcon(int n) {
        return this.d_objectActionIcons[n];
    }

    public int getObjectFlags(int n) {
        return this.d_objectFlags[n];
    }

    public int getObjectNeed(int n) {
        return this.d_objectNeeds[n];
    }

    public int getObjectBuyPrice(int n) {
        return this.d_objectBuyPrices[n];
    }

    public int getObjectSellPrice(int n) {
        return this.d_objectSellPrices[n];
    }

    public int getObjectFootprintWidth(int n) {
        return this.d_objectFootprintWidths[n];
    }

    public int getObjectFootprintHeight(int n) {
        return this.d_objectFootprintHeights[n];
    }

    public int getObjectAnimId(int n) {
        return this.d_objectAnimIds[n];
    }

    public int getObjectAnimSetId(int n, int n2) {
        if (n2 < this.d_objectAnimSetIds[n].length) {
            return this.d_objectAnimSetIds[n][n2];
        }
        return 0;
    }

    public int getObjectInterestPointCount(int n) {
        return this.d_objectInterestPointXs[n].length;
    }

    public int getObjectInterestPointX(int n, int n2, int n3) {
        int n4 = this.d_objectInterestPointXs[n][n2];
        int n5 = this.d_objectInterestPointYs[n][n2];
        switch (n3) {
            default: {
                AppEngine.ASSERT(false, "invalid facing dir");
            }
            case 0: {
                break;
            }
            case 1: {
                n4 = n5;
                break;
            }
            case 2: {
                n4 = 1 - n4 - Math.max(this.d_objectFootprintHeights[n], 1);
                break;
            }
            case 3: {
                n4 = 1 - Math.max(this.d_objectFootprintWidths[n], 1) - n5;
            }
        }
        return n4;
    }

    public int getObjectInterestPointZ(int n, int n2, int n3) {
        int n4 = this.d_objectInterestPointXs[n][n2];
        int n5 = this.d_objectInterestPointYs[n][n2];
        switch (n3) {
            default: {
                AppEngine.ASSERT(false, "invalid facing dir");
            }
            case 0: {
                break;
            }
            case 1: {
                n5 = n4;
                break;
            }
            case 2: {
                n5 = 1 - n5 - Math.max(this.d_objectFootprintWidths[n], 1);
                break;
            }
            case 3: {
                n5 = 1 - Math.max(this.d_objectFootprintHeights[n], 1) - n4;
            }
        }
        return n5;
    }

    public short[] getObjectActions(int n) {
        return this.d_objectActions[n];
    }

    public int getObjectQuickLinkIndex(int n) {
        int[] nArray = this.d_objectFlags;
        if ((nArray[n] & 0x20) == 0) {
            return -1;
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0x20) == 0) continue;
            if (i == n) {
                return n2;
            }
            ++n2;
        }
        AppEngine.ASSERT(false, "invalid object type");
        return -1;
    }

    public int getAnim(int n, int n2) {
        int n3 = (n << 2) + n2;
        return this.d_animSetIndexes[n3];
    }

    public int mapSubAppearance(int n, boolean bl) {
        if (n < 0) {
            int n2 = this.m_engine.randPercent();
            if (n == -2) {
                if (!bl) {
                    n2 = n2 * 75 / 100;
                }
                n = n2 < 25 ? 6 : (n2 < 50 ? 7 : (n2 < 75 ? 8 : 9));
                AppEngine.ASSERT(n != 9 || bl, "no north chat 04");
            } else if (n == -3) {
                n = n2 < 50 ? 10 : 11;
            } else if (n == -4) {
                n = n2 < 50 ? 13 : 14;
            }
        }
        return n;
    }

    public int getSubAppearanceAnimSet(int n, int n2, boolean bl) {
        short[] sArray = this.d_appearances[n];
        n2 <<= 1;
        if (bl) {
            ++n2;
        }
        if (n2 < sArray.length) {
            return sArray[n2];
        }
        return bl ? 0 : sArray[0];
    }

    public boolean isFurnitureAvailable(int n) {
        int n2 = this.getFurnitureExcludeFlags();
        int n3 = this.getObjectFlags(n);
        return (n3 & n2) == 0;
    }

    private int getFurnitureExcludeFlags() {
        int n = this.m_engine.getSimData().getFurnitureStage();
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid furniture stage");
            }
            case 0: {
                return 0x30000000;
            }
            case 1: {
                return 0x20000000;
            }
            case 2: 
        }
        return 0;
    }

    public int getFurnitureNthCount() {
        return this.d_objectBuyPrices.length - AppEngine.countOf(-1, this.d_objectBuyPrices);
    }

    public int getFurnitureNthItem(int n) {
        return AppEngine.indexOfNthElement(n, this.d_objectBuyPrices, -1);
    }

    private final byte[] getTileArray(int n) {
        return this.d_tileArrays[n];
    }

    private final byte getTile(int n, int n2) {
        return this.d_tileArrays[n][n2];
    }

    private final int getTileIndex(int n, int n2) {
        return AppEngine.indexOf(n, this.d_tileArrays[n2]);
    }

    public int getItemCount() {
        return this.d_itemDescStringIds.length;
    }

    public int getItemDescString(int n) {
        return this.d_itemDescStringIds[n];
    }

    public int getItemIcon(int n) {
        return this.d_itemIcons[n];
    }

    public int getItemFlags(int n) {
        return this.d_itemFlags[n];
    }

    public int getItemBuyPrice(int n) {
        return this.d_itemBuyPrices[n];
    }

    public int getItemSellPrice(int n) {
        return this.d_itemSellPrices[n];
    }

    public int getItemMaxInventory(int n) {
        return this.d_itemMaxInventory[n];
    }

    public int getItemByName(int n) {
        return AppEngine.indexOf(n, this.d_itemDescStringIds);
    }

    private int getShopFlags(int n) {
        int n2 = 0;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "unknown shop item");
            }
            case 113: {
                n2 = 4096;
                break;
            }
            case 116: {
                n2 = 16384;
                break;
            }
            case 115: {
                n2 = 8192;
                break;
            }
            case 112: {
                n2 = 32768;
            }
        }
        return n2;
    }

    public int getItemNthCount(int n) {
        int n2 = this.getShopFlags(n);
        return AppEngine.countOfFlags(n2, this.d_itemFlags);
    }

    public int getItemNthItem(int n, int n2) {
        int n3 = this.getShopFlags(n);
        return AppEngine.indexOfNthElementFlags(n2, this.d_itemFlags, n3);
    }

    public int getRecipeReplenishes(int n) {
        return MathExt.Fmul(this.d_recipeReplenishes[n] << 16, 22937);
    }

    public int getRecipeItem(int n) {
        return this.d_recipeItems[n];
    }

    public int getRecipeIngredientCount(int n) {
        return this.d_recipeIngredients[n].length;
    }

    public int getRecipeIngredient(int n, int n2) {
        return this.d_recipeIngredients[n][n2];
    }

    public int getRecipeForItem(int n) {
        return AppEngine.indexOf(n, this.d_recipeItems);
    }

    public int getRecipeDesc(int n) {
        return this.d_itemDescStringIds[this.d_recipeItems[n]];
    }

    public int getRecipeByName(int n) {
        for (int i = 0; i < this.d_recipeItems.length; ++i) {
            if (this.getRecipeDesc(i) != n) continue;
            return i;
        }
        return -1;
    }

    private void initColors() {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(66));
            int n3 = dataInputStream.readByte();
            int[][] nArrayArray = new int[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = dataInputStream.readByte();
                int[] nArray = new int[n4];
                for (n = 0; n < n4; ++n) {
                    nArray[n] = dataInputStream.readInt();
                }
                nArrayArray[n2] = nArray;
            }
            n2 = dataInputStream.readByte();
            byte[][] byArrayArray = new byte[n2][];
            for (int i = 0; i < n2; ++i) {
                n = dataInputStream.readByte();
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                byArrayArray[i] = byArray;
            }
            dataInputStream.close();
            this.d_patches = nArrayArray;
            this.d_pals = byArrayArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void patchClear(int[] nArray, int[] nArray2) {
        AppEngine.ASSERT(nArray.length == nArray2.length, "sources and patches must be equal length");
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0xFF00FF;
            nArray2[i] = 0xFF00FF;
        }
    }

    public void patchAdd(int[] nArray, int[] nArray2, int n, int n2) {
        AppEngine.ASSERT(nArray.length == nArray2.length, "sources and patches must be equal length");
        if (n < 0 || n2 < 0) {
            return;
        }
        int[] nArray3 = this.d_patches[n];
        int[] nArray4 = this.d_patches[n2];
        AppEngine.ASSERT(nArray3.length == nArray4.length, "patches must be equal length");
        int n3 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0xFF00FF) continue;
            n3 = i;
            break;
        }
        AppEngine.ASSERT(n3 != -1, "patches array full");
        System.arraycopy(nArray3, 0, nArray, n3, nArray3.length);
        System.arraycopy(nArray4, 0, nArray2, n3, nArray4.length);
    }

    public int[] getPatch(int n) {
        return this.d_patches[n];
    }

    public byte[] getPal(int n) {
        return this.d_pals[n];
    }

    public void getSimPatches(int n, int[] nArray, int[] nArray2) {
        SimData simData = this.m_engine.getSimData();
        byte by = this.d_pals[1][simData.getSimAttribute(n, 3)];
        byte by2 = this.d_pals[2][simData.getSimAttribute(n, 4)];
        byte by3 = this.d_pals[3][simData.getSimAttribute(n, 5)];
        byte by4 = this.d_pals[4][simData.getSimAttribute(n, 6)];
        byte by5 = this.d_pals[5][simData.getSimAttribute(n, 7)];
        byte by6 = this.d_pals[6][simData.getSimAttribute(n, 8)];
        byte by7 = this.d_pals[7][simData.getSimAttribute(n, 9)];
        byte by8 = this.d_pals[0][simData.getSimAttribute(n, 1)];
        this.patchClear(nArray, nArray2);
        this.patchAdd(nArray, nArray2, 11, by);
        this.patchAdd(nArray, nArray2, 35, by2);
        this.patchAdd(nArray, nArray2, 20, by3);
        this.patchAdd(nArray, nArray2, 31, by4);
        this.patchAdd(nArray, nArray2, 32, by5);
        this.patchAdd(nArray, nArray2, 33, by6);
        this.patchAdd(nArray, nArray2, 34, by7);
        this.patchAdd(nArray, nArray2, 5, by8);
    }

    private void DEBUG_PATHFIND(String string) {
    }

    public void pathClearAvoidTiles() {
        this.m_pathNumAvoidTiles = 0;
    }

    public void pathAddAvoidTile(int n, int n2) {
        AppEngine.ASSERT(this.m_pathNumAvoidTiles < 10, "not enough avoid tile slots");
        int n3 = this.m_pathNumAvoidTiles << 1;
        this.m_pathAvoidTiles[n3] = n;
        this.m_pathAvoidTiles[n3 + 1] = n2;
        ++this.m_pathNumAvoidTiles;
    }

    public int[] pathFind(int n, int n2, int n3, int n4, int n5) {
        short s;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        AppEngine.timerBegin();
        this.pathReset();
        this.m_pathFlags = n5;
        this.m_pathStartX = this.coordWorldToWorldTileX(n);
        this.m_pathStartY = this.coordWorldToWorldTileZ(n2);
        this.m_pathDestX = this.coordWorldToWorldTileX(n3);
        this.m_pathDestY = this.coordWorldToWorldTileZ(n4);
        if (!this.isWorldTileWalkable(this.m_pathStartX, this.m_pathStartY) || !this.isWorldTileWalkable(this.m_pathDestX, this.m_pathDestY)) {
            AppEngine.timerEnd("pathfind");
            return new int[0];
        }
        this.m_pathOffsetX = this.m_pathStartX + this.m_pathDestX - 32 >> 1;
        this.m_pathOffsetY = this.m_pathStartY + this.m_pathDestY - 32 >> 1;
        int n11 = this.m_pathStartX - this.m_pathOffsetX;
        int n12 = this.m_pathStartY - this.m_pathOffsetY;
        if (n11 < 0 || n12 < 0 || n11 >= 32 || n12 >= 32) {
            AppEngine.timerEnd("pathfind");
            return new int[0];
        }
        n11 = this.m_pathDestX - this.m_pathOffsetX;
        n12 = this.m_pathDestY - this.m_pathOffsetY;
        if (n11 < 0 || n12 < 0 || n11 >= 32 || n12 >= 32) {
            AppEngine.timerEnd("pathfind");
            return new int[0];
        }
        this.pathAddToOpenList(this.m_pathStartX - this.m_pathOffsetX, this.m_pathStartY - this.m_pathOffsetY);
        n11 = 0;
        while (n11 == 0) {
            n12 = this.pathFindLowestF();
            if (n12 == -1) {
                this.DEBUG_PATHFIND("break");
                AppEngine.timerEnd("pathfind");
                return new int[0];
            }
            n10 = this.m_pathOpenList[n12] & 0xFF;
            n9 = (this.m_pathOpenList[n12] & 0xFF00) >> 8;
            for (n8 = 0; n8 < 4; ++n8) {
                n7 = n10 + (n8 == 0 ? -1 : (n8 == 1 ? 1 : 0));
                if (this.pathIsClosed(n7, n6 = n9 + (n8 == 2 ? -1 : (n8 == 3 ? 1 : 0)))) continue;
                if (this.pathAddToOpenList(n7, n6)) {
                    this.pathSetParent(n7, n6, n10, n9);
                    this.pathCalculateGCost(n7, n6);
                    this.pathCalculateHCost(n7, n6);
                    this.pathCalculateFCost(n7, n6);
                    continue;
                }
                if (!this.pathBetterGCost(n7, n6, n10, n9)) continue;
                this.pathSetParent(n7, n6, n10, n9);
                this.pathCalculateGCost(n7, n6);
                this.pathCalculateFCost(n7, n6);
            }
            this.pathSwitchToClosedList(n12);
            if (n10 != this.m_pathDestX - this.m_pathOffsetX || n9 != this.m_pathDestY - this.m_pathOffsetY) continue;
            n11 = 1;
        }
        n12 = Integer.MAX_VALUE;
        n10 = Integer.MAX_VALUE;
        n9 = this.m_pathDestX - this.m_pathOffsetX;
        n8 = this.m_pathDestY - this.m_pathOffsetY;
        n7 = this.m_pathStartX - this.m_pathOffsetX;
        n6 = this.m_pathStartY - this.m_pathOffsetY;
        int n13 = 0;
        while (!(n9 < 0 || n8 < 0 || n9 >= 32 || n8 >= 32 || n9 == n7 && n8 == n6 || n12 == n9 && n10 == n8 || (s = this.m_pathParentArray[n9][n8]) == -1)) {
            this.m_pathList[n13] = (short)(n9 | n8 << 8);
            ++n13;
            n12 = n9;
            n10 = n8;
            n9 = s & 0xFF;
            n8 = (s & 0xFF00) >> 8;
        }
        int[] nArray = new int[n13 << 1];
        for (int i = 0; i < n13; ++i) {
            int n14 = n13 - i - 1;
            int n15 = (this.m_pathList[n14] & 0xFF) + this.m_pathOffsetX;
            int n16 = ((this.m_pathList[n14] & 0xFF00) >> 8) + this.m_pathOffsetY;
            nArray[(i << 1) + 0] = this.coordWorldTileToWorldCenterX(n15);
            nArray[(i << 1) + 1] = this.coordWorldTileToWorldCenterZ(n16);
        }
        AppEngine.timerEnd("pathfind");
        return nArray;
    }

    private void pathInit() {
        int n;
        if (this.m_pathOpenList != null) {
            return;
        }
        this.m_pathOpenList = new short[1024];
        this.m_pathOpenCount = 0;
        this.m_pathClosedList = new short[1024];
        this.m_pathClosedCount = 0;
        this.m_pathParentArray = new short[32][];
        for (n = 0; n < this.m_pathParentArray.length; ++n) {
            this.m_pathParentArray[n] = new short[32];
        }
        this.m_pathGCost = new int[32][];
        for (n = 0; n < this.m_pathGCost.length; ++n) {
            this.m_pathGCost[n] = new int[32];
        }
        this.m_pathFCost = new int[32][];
        for (n = 0; n < this.m_pathFCost.length; ++n) {
            this.m_pathFCost[n] = new int[32];
        }
        this.m_pathHCost = new int[32][];
        for (n = 0; n < this.m_pathHCost.length; ++n) {
            this.m_pathHCost[n] = new int[32];
        }
        this.m_pathList = new short[256];
        this.m_pathNumAvoidTiles = 0;
        this.m_pathAvoidTiles = new int[20];
    }

    private boolean pathAddToOpenList(int n, int n2) {
        short s = (short)(n | n2 << 8);
        for (int i = 0; i < this.m_pathOpenCount; ++i) {
            if (this.m_pathOpenList[i] != s) continue;
            return false;
        }
        this.m_pathOpenList[this.m_pathOpenCount] = s;
        ++this.m_pathOpenCount;
        return true;
    }

    private void pathSwitchToClosedList(int n) {
        this.m_pathClosedList[this.m_pathClosedCount] = this.m_pathOpenList[n];
        ++this.m_pathClosedCount;
        for (int i = n; i < this.m_pathOpenCount - 1; ++i) {
            this.m_pathOpenList[i] = this.m_pathOpenList[i + 1];
        }
        --this.m_pathOpenCount;
    }

    private void pathSetParent(int n, int n2, int n3, int n4) {
        AppEngine.ASSERT(n >= 0 && n2 >= 0 && n < 32 && n2 < 32, "pathSetParent: rx, ry off pathfind");
        this.m_pathParentArray[n][n2] = (short)(n3 | n4 << 8);
    }

    private int pathTileGCost(int n, int n2) {
        AppEngine.ASSERT(n >= 0 && n2 >= 0 && n < 32 && n2 < 32, "pathTileGCost: rx, ry off pathfind");
        if ((this.m_pathFlags & 6) != 0) {
            int n3 = n + this.m_pathOffsetX;
            int n4 = n2 + this.m_pathOffsetY;
            int n5 = this.getAttribute(n3, n4);
            if ((n5 & 0x20) != 0) {
                return (this.m_pathFlags & 2) != 0 ? 5 : 50;
            }
            if ((n5 & 0x10) != 0) {
                return 10;
            }
            return 15;
        }
        return 15;
    }

    private void pathCalculateGCost(int n, int n2) {
        AppEngine.ASSERT(n >= 0 && n2 >= 0 && n < 32 && n2 < 32, "pathCalculateGCost: rx, ry off pathfind");
        int n3 = this.m_pathParentArray[n][n2] & 0xFF;
        int n4 = (this.m_pathParentArray[n][n2] & 0xFF00) >> 8;
        AppEngine.ASSERT(n3 >= 0 && n4 >= 0 && n3 < 32 && n4 < 32, "pathCalculateGCost: parent off pathfind");
        int n5 = this.m_pathGCost[n3][n4];
        int n6 = 0;
        if ((this.m_pathFlags & 8) != 0) {
            int n7 = this.m_pathParentArray[n3][n4] & 0xFF;
            int n8 = (this.m_pathParentArray[n3][n4] & 0xFF00) >> 8;
            if (!(n7 == n3 && n3 == n || n8 == n4 && n4 == n2)) {
                n6 = 20;
            }
        }
        this.m_pathGCost[n][n2] = n5 + this.pathTileGCost(n, n2) + n6;
    }

    private boolean pathBetterGCost(int n, int n2, int n3, int n4) {
        AppEngine.ASSERT(n >= 0 && n2 >= 0 && n < 32 && n2 < 32 && n3 >= 0 && n4 >= 0 && n3 < 32 && n4 < 32, "pathBetterGCost: (rx, ry) or (cx, cy) off pathfind");
        int n5 = this.m_pathGCost[n][n2];
        int n6 = this.m_pathGCost[n3][n4];
        return (n6 += this.pathTileGCost(n, n2)) < n5;
    }

    private void pathCalculateHCost(int n, int n2) {
        AppEngine.ASSERT(n >= 0 && n2 >= 0 && n < 32 && n2 < 32, "pathCalculateHCost: rx, ry off pathfind");
        int n3 = this.m_pathDestX - this.m_pathOffsetX - n;
        int n4 = this.m_pathDestY - this.m_pathOffsetY - n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = 0;
        AppEngine.ASSERT(this.pathIsWalkable(n, n2), "pathCalculateHCost: rx, ry non-walkable");
        if ((this.m_pathFlags & 1) != 0) {
            for (int i = 0; i < this.m_pathNumAvoidTiles; ++i) {
                int n6 = i << 1;
                if (n + this.m_pathOffsetX != this.m_pathAvoidTiles[n6] || n2 + this.m_pathOffsetY != this.m_pathAvoidTiles[n6 + 1]) continue;
                n5 = 250;
                break;
            }
        }
        this.m_pathHCost[n][n2] = n3 * 10 + n4 * 10 + n5;
    }

    private void pathCalculateFCost(int n, int n2) {
        AppEngine.ASSERT(n >= 0 && n2 >= 0 && n < 32 && n2 < 32, "pathCalculateFCost: rx, ry off pathfind");
        this.m_pathFCost[n][n2] = this.m_pathHCost[n][n2] + this.m_pathGCost[n][n2];
    }

    private int pathFindLowestF() {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_pathOpenCount; ++i) {
            int n3 = this.m_pathOpenList[i] & 0xFF;
            int n4 = (this.m_pathOpenList[i] & 0xFF00) >> 8;
            AppEngine.ASSERT(n3 >= 0 && n4 >= 0 && n3 < 32 && n4 < 32, "pathFindLowestF: open tile rx, ry off pathfind");
            if (n2 <= this.m_pathFCost[n3][n4]) continue;
            n2 = this.m_pathFCost[n3][n4];
            n = i;
        }
        return n;
    }

    private boolean pathIsWalkable(int n, int n2) {
        int n3 = n + this.m_pathOffsetX;
        int n4 = n2 + this.m_pathOffsetY;
        return this.isWorldTileWalkable(n3, n4);
    }

    private boolean pathIsClosed(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= 32 || n2 >= 32) {
            return true;
        }
        if (!this.pathIsWalkable(n, n2)) {
            return true;
        }
        int n3 = n | n2 << 8;
        for (int i = 0; i < this.m_pathClosedCount; ++i) {
            if (n3 != this.m_pathClosedList[i]) continue;
            return true;
        }
        return false;
    }

    private void pathReset() {
        this.m_pathClosedCount = 0;
        this.m_pathOpenCount = 0;
        AppEngine.fillArray(this.m_pathParentArray, 0);
        AppEngine.fillArray(this.m_pathGCost, 0);
        AppEngine.fillArray(this.m_pathFCost, 0);
        AppEngine.fillArray(this.m_pathHCost, 0);
    }
}

