/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import game.AppEngine;
import game.MoreGames;
import game.Scene;
import game.SimData;
import game.SimWorld;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import javax.microedition.lcdui.Graphics;

final class SceneMenu
extends Scene
implements Runnable {
    public static int m_state = 0;
    private int m_afterFadeState = 0;
    private int m_nextScene = 0;
    private int m_nextSceneState = -1;
    private int m_initialState;
    private short[] m_mainMenu;
    private int m_loadingState;
    private Thread m_loadingThread;
    private int m_loadingThreadState;
    private short[] m_languageMenu;
    private SDKString[] m_languageMenuStrings;
    private int m_introState;
    private int m_introTimer;
    private int m_introMaxTimer;
    private AnimPlayer m_casAnimPlayer;
    private int m_casHairAnim;
    private static final short[] BUTTON_STRINGS = new short[]{730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742};
    private int[] m_palSources = new int[32];
    private int[] m_palPatches = new int[32];
    private AnimPlayer m_casUpArrow;
    private AnimPlayer m_casDownArrow;
    private int m_casButtonIndex;
    private int m_casButtonsOffsetF;
    private int m_casButtonsOffsetTargetF;
    private int m_casAttribute;
    private int m_casAttributePatch;
    private int m_casColorsOffsetF;
    private int m_casColorsOffsetTargetF;
    private int m_casAttributesButtonsAnim;
    private int m_casAttributesAnimHi;
    private int m_casAttributesAnimLo;
    private int m_casAttributeIndex;
    private int m_casAttributeIndexMin;
    private int m_casAttributeIndexMax;
    private boolean m_casArms;
    private boolean m_casLegs;
    private boolean m_casHairAcc;
    private static final int[] GRAD_CAS_LIST = new int[]{11, 12, 13, 14, 15, 14, 13, 12, 11};
    private static final int[] GRAD_CAS_SKY = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
    private static final int[] GRAD_CAS_GROUND = new int[]{31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final char[][] KEY_CHARS = new char[][]{{'Q', 'W'}, {'E', 'R', '1'}, {'T', 'Y', '2'}, {'U', 'I', '3'}, {'O', 'P'}, {'A', 'S'}, {'D', 'F', '4'}, {'G', 'H', '5'}, {'J', 'K', '6'}, {'L'}, {'Z', 'X'}, {'C', 'V', '7'}, {'B', 'N', '8'}, {'M', '9'}, {'0'}};
    private boolean m_isCharSelected;
    private int m_cursorPosition;
    private int m_charSelectedTime;
    private int m_lastKeyPressed;
    private int m_charIndex;
    private boolean m_deleteButtonSelected;

    public SceneMenu(AppEngine appEngine) {
        super(appEngine);
        appEngine.setFadeStep(197379);
        this.m_casUpArrow = new AnimPlayer();
        this.m_casDownArrow = new AnimPlayer();
        this.m_casAnimPlayer = new AnimPlayer();
        this.m_casAnimPlayer.setAnimating(false);
    }

    public void start(int n) {
        AppEngine.DEBUG_MEMORY("SceneMenu.starting");
        this.initUI();
        this.m_engine.resetGDGoals();
        this.initLanguageMenu();
        if (n == -1) {
            n = 7;
        }
        this.m_initialState = n;
        if (n == 4 || n == 5) {
            this.m_initialState = 6;
            this.stateTransition(n);
        } else {
            this.stateTransition(1);
        }
        this.m_loadingState = 0;
        AppEngine.DEBUG_MEMORY("SceneMenu.started");
    }

    private void DEBUG_SCENEMENULOADING(String string) {
    }

    private void updateLoading(int n) {
        this.m_engine.updateLoading(n);
        if (this.m_loadingThread == null) {
            this.DEBUG_SCENEMENULOADING("thread starting");
            this.m_loadingThread = new Thread(this);
            this.m_loadingThreadState = 0;
            this.m_loadingThread.start();
        } else {
            this.m_loadingThreadState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_loadingThreadState != 2) {
            if (this.m_loadingThreadState != 0) {
                try {
                    SceneMenu sceneMenu = this;
                    synchronized (sceneMenu) {
                        this.DEBUG_SCENEMENULOADING("thread waiting");
                        this.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            this.m_loadingThreadState = 1;
            this.updateLoadingState();
        }
        this.DEBUG_SCENEMENULOADING("thread quiting");
    }

    private void updateLoadingState() {
        AppEngine appEngine = this.m_engine;
        if (appEngine.isFading()) {
            return;
        }
        this.DEBUG_SCENEMENULOADING("updateLoadingState: " + this.m_loadingState);
        switch (this.m_loadingState) {
            case 0: {
                AppEngine.timerBegin();
                short[] sArray = new short[15];
                this.m_mainMenu = sArray;
                this.initMainMenu(-1);
                this.loadSounds();
                SDKUtils.loadStringsChunk(1);
                ++this.m_loadingState;
                appEngine.loadImagesBegin();
                break;
            }
            case 1: {
                if (!appEngine.loadImagesNext(4)) break;
                ++this.m_loadingState;
                break;
            }
            case 2: {
                this.stateTransition(this.m_initialState);
                this.m_loadingThreadState = 2;
                AppEngine.timerEnd("loading");
            }
        }
    }

    private void loadSounds() {
        this.m_engine.getSoundManager().loadSound(10);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void end() {
        AppEngine.DEBUG_MEMORY("SceneMenu.ending");
        this.m_engine.unloadAllImages(3076, -1);
        this.m_engine.startMusic(-1);
        SDKSoundManager sDKSoundManager = this.m_engine.getSoundManager();
        sDKSoundManager.stopSounds();
        SDKUtils.freeStringsChunk(1);
        AppEngine.DEBUG_MEMORY("SceneMenu.ended");
    }

    public void render(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getSharedMenuState();
        if (n != -1) {
            if (n == 5) {
                if (m_state == 4) {
                    this.drawClear(graphics, 77);
                } else {
                    this.drawBG(graphics);
                }
                this.renderLanguageMenu(graphics);
            } else {
                this.drawBG(graphics);
                appEngine.renderSharedMenu(graphics);
                appEngine.renderSoftkeyBar(graphics);
            }
            return;
        }
        switch (m_state) {
            case 1: {
                appEngine.renderLoading(graphics);
                break;
            }
            case 4: {
                this.drawClear(graphics, 77);
                this.renderLanguageMenu(graphics);
                break;
            }
            case 5: {
                this.drawClear(graphics, 77);
                this.drawGenericMessageBox(graphics);
                appEngine.renderSoftkeyBar(graphics);
                break;
            }
            case 6: {
                this.renderIntro(graphics);
                break;
            }
            case 7: {
                this.drawBG(graphics);
                this.drawMainMenu(graphics);
                break;
            }
            case 8: {
                this.renderGoalsScreen(graphics, 3);
                appEngine.renderSoftkeyBar(graphics);
                break;
            }
            case 9: {
                appEngine.getMoreGames().paint(graphics);
                break;
            }
            case 10: {
                this.renderCASAppearance(graphics);
                break;
            }
            case 17: {
                this.renderCASAppearance(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawGenericMessageBox(graphics);
                appEngine.renderSoftkeyBar(graphics);
                break;
            }
            case 11: {
                this.renderCASPersona(graphics);
                break;
            }
            case 12: {
                this.renderCASTraits(graphics);
                break;
            }
            case 13: {
                this.renderCASName(graphics);
                break;
            }
            case 18: {
                this.renderCASName(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawGenericMessageBox(graphics);
                appEngine.renderSoftkeyBar(graphics);
                break;
            }
            case 14: 
            case 15: {
                this.renderSelectSim(graphics);
                break;
            }
            case 16: {
                this.renderSelectSim(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawGenericMessageBox(graphics);
                appEngine.renderSoftkeyBar(graphics);
                break;
            }
            case 19: {
                this.drawBG(graphics);
                this.drawMainMenu(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawGenericMessageBox(graphics);
                appEngine.renderSoftkeyBar(graphics);
            }
        }
    }

    public void processKeys(int n, int n2) {
        if (m_state == 1) {
            return;
        }
        AppEngine appEngine = this.m_engine;
        if (appEngine.fadeColorReached() && this.m_afterFadeState != 0) {
            this.stateTransition(this.m_afterFadeState);
            appEngine.startFadeIn();
            this.m_afterFadeState = 0;
            return;
        }
        if (appEngine.isFading()) {
            return;
        }
        int n3 = appEngine.getSharedMenuState();
        if (n3 != -1) {
            if (n3 == 5) {
                this.processKeysLanguageMenu(n, n2);
            } else {
                appEngine.processKeysSharedMenu(n, n2);
            }
            if (appEngine.getSharedMenuState() == -1) {
                this.stateTransition(m_state);
            }
            return;
        }
        switch (m_state) {
            case 4: {
                this.processKeysLanguageMenu(n, n2);
                break;
            }
            case 5: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    appEngine.getSoundManager().setSoundEnabled(true);
                    this.fadeStateTransition(1);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 512)) break;
                appEngine.getSoundManager().setSoundEnabled(false);
                this.fadeStateTransition(1);
                break;
            }
            case 6: {
                this.processKeysIntro(n, n2);
                break;
            }
            case 7: {
                if (this.checkKeys(n, n2, 4128, 16)) {
                    int n4 = 5 + this.m_mainMenu[2];
                    this.processAction(this.m_mainMenu[n4]);
                    break;
                }
                if (this.checkKeys(n, n2, 0, 4)) {
                    this.stateTransition(19);
                    break;
                }
                appEngine.menuCursorUpDown(this.m_mainMenu, n);
                break;
            }
            case 8: {
                this.processKeysList(n, n2);
                if (!this.checkKeys(n, n2, 0, 4)) break;
                this.stateTransition(7);
                break;
            }
            case 10: {
                this.processKeysCASAppearance(n, n2);
                break;
            }
            case 17: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    this.stateTransition(14);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 516)) break;
                this.stateTransition(10);
                break;
            }
            case 11: {
                this.processKeysCASPersona(n, n2);
                break;
            }
            case 12: {
                this.processKeysCASTraits(n, n2);
                break;
            }
            case 13: {
                this.processKeysCASName(n, n2);
                break;
            }
            case 18: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    appEngine.newGame();
                    appEngine.beginGame();
                    this.changeScene(2, -1);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 516)) break;
                this.stateTransition(13);
                break;
            }
            case 14: 
            case 15: {
                this.processKeysSelectSim(n, n2);
                break;
            }
            case 16: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    appEngine.resetSimSaveData(appEngine.getRMSGameSlotIndex());
                    appEngine.saveRMSAppSettings();
                    this.stateTransition(14);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 512)) break;
                this.stateTransition(15);
                break;
            }
            case 19: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    this.stateTransition(3);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 516)) break;
                this.stateTransition(7);
            }
        }
    }

    public void update(int n) {
        if (m_state == 1) {
            this.updateLoading(n);
            return;
        }
        switch (m_state) {
            case 6: {
                this.updateIntro(n);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.updateMoreGames();
                break;
            }
            case 10: {
                this.updateCASSim(n, false);
                this.updateCASAppearance(n);
                break;
            }
            case 11: {
                this.updateCASSim(n, true);
                break;
            }
            case 12: {
                this.updateCASSim(n, true);
                this.updateCASTraits(n);
                break;
            }
            case 13: {
                this.updateCASName(n);
                break;
            }
            case 14: {
                this.updateCASSim(n, false);
                break;
            }
        }
    }

    private void stateTransition(int n) {
        AppEngine appEngine = this.m_engine;
        int n2 = m_state;
        m_state = n;
        appEngine.clearKeysPressedDown();
        appEngine.clearCommandKeys();
        switch (n) {
            case 1: {
                appEngine.setSoftKeys(0, 0);
                break;
            }
            case 2: {
                appEngine.changeScene(this.m_nextScene, this.m_nextSceneState);
                break;
            }
            case 3: {
                appEngine.endGame();
                break;
            }
            case 4: {
                appEngine.setSoftKeys(0, 16384);
                break;
            }
            case 5: {
                appEngine.setSoftKeys(512, 256);
                this.prepareGenericMessageBox(81, 82);
                break;
            }
            case 6: {
                appEngine.loadAllImages(2);
                appEngine.setSoftKeys(0, 0);
                this.initIntro();
                break;
            }
            case 7: {
                appEngine.startMusic(10);
                this.m_introState = 18;
                appEngine.unloadAllImages(2, 0);
                appEngine.setSoftKeys(0, 16);
                break;
            }
            case 8: {
                this.initListGoals();
                appEngine.setSoftKeys(4, 0);
                break;
            }
            case 9: {
                appEngine.stopMusic();
                appEngine.setMoreGamesActive(true);
                appEngine.getMoreGames().reset();
                break;
            }
            case 10: {
                this.m_casUpArrow.startAnim(690, 20);
                this.m_casDownArrow.startAnim(688, 20);
                if (n2 != 11 && n2 != 17) {
                    this.setAppearanceButtonIndex(0, 0);
                } else if (n2 == 11) {
                    this.restartCASSim(false);
                }
                appEngine.setSoftKeys(4, 2);
                break;
            }
            case 11: {
                this.initListPersonas();
                this.restartCASSim(true);
                appEngine.wrapString(743, 1, this.m_uiInfoBoxWrapWidth);
                appEngine.setSoftKeys(4, appEngine.getSimData().getPersona() != -1 ? 2 : 0);
                break;
            }
            case 12: {
                this.initListTraits();
                this.restartCASSim(true);
                appEngine.wrapString(751, 1, this.m_uiInfoBoxWrapWidth);
                int n3 = appEngine.getSimData().getNumPlayerTraits();
                boolean bl = 5 == n3;
                appEngine.setSoftKeys(4, bl ? 2 : 0);
                break;
            }
            case 13: {
                if (n2 != 18) {
                    this.initCharEntry();
                }
                appEngine.setSoftKeys(0, 0);
                appEngine.clearExtKey();
                break;
            }
            case 17: {
                this.prepareGenericMessageBox(60, 59);
                appEngine.setSoftKeys(512, 256);
                break;
            }
            case 18: {
                this.prepareGenericMessageBox(61, 55);
                appEngine.setSoftKeys(512, 256);
                break;
            }
            case 14: {
                this.m_deleteButtonSelected = false;
                this.reloadCASSim(false);
                appEngine.setSoftKeys(4, 16);
                break;
            }
            case 15: {
                this.m_deleteButtonSelected = false;
                if (appEngine.getRMSGameSlotIndex() != 0) {
                    appEngine.setRMSGameSlotIndex(0);
                    this.reloadCASSim(false);
                }
                appEngine.setSoftKeys(64, appEngine.getRMSActiveGame() ? 32 : 0);
                break;
            }
            case 16: {
                appEngine.setSoftKeys(512, 256);
                this.prepareGenericMessageBox(58, 57);
                break;
            }
            case 19: {
                this.prepareGenericMessageBox(71, 45);
                appEngine.setSoftKeys(512, 256);
            }
        }
    }

    private void fadeStateTransition(int n) {
        this.m_afterFadeState = n;
        if (!this.m_engine.isFadingOut()) {
            this.m_engine.startFadeOut();
        }
    }

    private void changeScene(int n, int n2) {
        this.m_nextScene = n;
        this.m_nextSceneState = n2;
        this.fadeStateTransition(2);
    }

    public void initMainMenu(int n) {
        short[] sArray = this.m_mainMenu;
        AppEngine.menuClear(sArray, 53, this.m_engine.getMaxMenuItemsPerScreen());
        AppEngine.menuAppendItem(sArray, 54);
        AppEngine.menuAppendItem(sArray, 62);
        AppEngine.menuAppendItem(sArray, 63);
        AppEngine.menuAppendItem(sArray, 64);
        if (this.m_engine.getMoreGames().isAvailable()) {
            AppEngine.menuAppendItem(sArray, 66);
        }
        AppEngine.menuAppendItem(sArray, 45);
        AppEngine.menuSelectById(sArray, n);
    }

    private void processAction(int n) {
        AppEngine appEngine = this.m_engine;
        switch (n) {
            case 54: {
                appEngine.setRMSGameSlotIndex(0);
                this.stateTransition(14);
                break;
            }
            case 62: {
                this.stateTransition(8);
                break;
            }
            case 63: {
                appEngine.stateTransitionSharedMenu(0);
                break;
            }
            case 64: {
                appEngine.stateTransitionSharedMenu(3);
                break;
            }
            case 66: {
                this.stateTransition(9);
                break;
            }
            case 45: {
                this.stateTransition(19);
                break;
            }
            default: {
                AppEngine.ASSERT(false, "not implemented");
            }
        }
    }

    private void updateMoreGames() {
        MoreGames moreGames = this.m_engine.getMoreGames();
        if (moreGames.isActive()) {
            moreGames.update();
        } else {
            this.m_engine.setMoreGamesActive(false);
            this.stateTransition(7);
        }
    }

    private void initLanguageMenu() {
        if (this.m_languageMenu == null) {
            int n;
            int n2 = this.m_engine.getNumLanguages();
            short[] sArray = new short[5 + n2];
            this.m_languageMenu = sArray;
            AppEngine.menuClear(sArray, 3, this.m_engine.getMaxMenuItemsPerScreen());
            SDKString[] sDKStringArray = new SDKString[n2 + 1];
            this.m_languageMenuStrings = sDKStringArray;
            for (n = 0; n < n2; ++n) {
                AppEngine.menuAppendItem(sArray, n);
                sDKStringArray[n] = SDKUtils.getHeaderString(n, 0, null);
            }
            n = this.m_engine.getRMSLangIndex();
            if (n != -1) {
                sArray[2] = (short)n;
            }
        }
    }

    private void renderLanguageMenu(Graphics graphics) {
        this.drawGenericMenu(graphics, this.m_languageMenu, 1, this.m_languageMenuStrings);
        this.m_engine.renderSoftkeyBar(graphics);
    }

    private void processKeysLanguageMenu(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        short s = this.m_languageMenu[2];
        if (this.checkKeys(n, n2, 4128, 16384)) {
            appEngine.loadLanguageChunks(s);
            appEngine.saveRMSAppSettings();
            if (appEngine.getSharedMenuState() == 5) {
                appEngine.stateTransitionSharedMenu(0);
            } else {
                this.fadeStateTransition(5);
            }
        } else if (this.checkKeys(n, n2, 524288, 32768)) {
            if (appEngine.getSharedMenuState() == 5) {
                SDKUtils.setCurrentLanguage(appEngine.getRMSLangIndex());
                appEngine.stateTransitionSharedMenu(0);
            }
        } else {
            this.m_engine.menuCursorUpDown(this.m_languageMenu, n);
            short s2 = this.m_languageMenu[2];
            if (s2 != s) {
                SDKUtils.setCurrentLanguage(s2);
            }
        }
    }

    private void initIntro() {
        this.m_engine.stopFade();
        this.introStateTransition(0);
    }

    private void introStateTransition(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 500;
                break;
            }
            case 1: {
                n2 = 1000;
                break;
            }
            case 2: {
                n2 = 2000;
                break;
            }
            case 3: {
                n2 = 600;
                break;
            }
            case 4: {
                n2 = 500;
                break;
            }
            case 5: {
                n2 = 600;
                break;
            }
            case 6: {
                n2 = 300;
                break;
            }
            case 7: {
                n2 = 750;
                break;
            }
            case 8: {
                n2 = 700;
                break;
            }
            case 9: {
                n2 = 600;
                break;
            }
            case 10: {
                n2 = 600;
                break;
            }
            case 11: {
                n2 = 700;
                break;
            }
            case 12: {
                n2 = 750;
                break;
            }
            case 13: {
                n2 = 750;
                break;
            }
            case 14: {
                n2 = 500;
                break;
            }
            case 15: {
                n2 = 750;
                break;
            }
            case 16: {
                n2 = this.m_mainMenu[0] * 200;
                break;
            }
            case 17: {
                n2 = 500;
                break;
            }
            case 18: {
                this.stateTransition(7);
                break;
            }
            default: {
                AppEngine.ASSERT(false, "invalid state");
            }
        }
        this.m_introState = n;
        this.m_introTimer = 0;
        this.m_introMaxTimer = n2;
    }

    private void updateIntro(int n) {
        this.m_introTimer += n;
        if (this.m_introTimer >= this.m_introMaxTimer) {
            if (this.m_introState == 13) {
                this.m_introTimer %= 750;
            } else {
                this.introStateTransition(this.m_introState + 1);
            }
        }
    }

    private void processKeysIntro(int n, int n2) {
        if (this.m_introState == 13 && this.checkKeys(n, n2, 4128, 0)) {
            this.introStateTransition(this.m_introState + 1);
        }
    }

    private void renderIntro(Graphics graphics) {
        switch (this.m_introState) {
            case 0: {
                this.drawClear(graphics, 0);
                break;
            }
            case 1: {
                this.drawEALogo(graphics);
                this.drawBlackFade(graphics, this.m_introMaxTimer - this.m_introTimer, this.m_introMaxTimer);
                break;
            }
            case 2: {
                this.drawEALogo(graphics);
                break;
            }
            case 4: {
                this.drawClear(graphics, 0);
                break;
            }
            case 3: {
                this.drawEALogo(graphics);
                this.drawBlackFade(graphics, this.m_introTimer, this.m_introMaxTimer);
                break;
            }
            case 5: {
                this.drawGreyClear(graphics, this.m_introTimer, this.m_introMaxTimer);
                break;
            }
            case 6: {
                this.drawClear(graphics, 99);
                break;
            }
            case 7: {
                this.drawClear(graphics, 99);
                this.drawTheSims3(graphics);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.drawClear(graphics, 99);
                this.drawTheSims3(graphics);
                break;
            }
            case 12: 
            case 13: {
                this.drawTheSims3(graphics);
                break;
            }
            case 14: {
                this.drawTheSims3(graphics);
                this.drawMainMenu(graphics);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                this.drawBG(graphics);
                this.drawMainMenu(graphics);
                break;
            }
            case 18: {
                AppEngine.ASSERT(false, "shouldn't be rendering this state");
            }
        }
    }

    private void drawBlackFade(Graphics graphics, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        int n3 = 255 - Math.min(n * 255 / n2, 255);
        int n4 = 0xFF000000 | n3 << 16 | n3 << 8 | n3 << 0;
        appEngine.renderFade(graphics, 0, n4, 0, 0, appEngine.getWidth(), appEngine.getHeight());
    }

    private void drawGreyClear(Graphics graphics, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        int n3 = Math.min(n * 255 / n2, 255);
        int n4 = 0xFF000000 | n3 << 16 | n3 << 8 | n3 << 0;
        graphics.setColor(n4);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
    }

    private void drawClear(Graphics graphics, int n) {
        AppEngine appEngine = this.m_engine;
        AnimationManager.setColor(graphics, n);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
    }

    private void drawEALogo(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.drawClear(graphics, 60);
        AnimationManager.drawAnimFrame(graphics, 566, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight());
    }

    private void drawTheSims3(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        AppEngine appEngine = this.m_engine;
        int n5 = 567;
        if (appEngine.getRMSLangIndex() == 1) {
            n5 = 568;
        }
        int n6 = appEngine.getHalfWidth();
        int n7 = appEngine.getHalfHeight();
        int n8 = 0;
        if (this.m_introMaxTimer != 0) {
            n8 = MathExt.Fdiv(this.m_introTimer, this.m_introMaxTimer);
        }
        if (this.m_introState >= 12) {
            AnimationManager.drawAnimFrame(graphics, n5, 8, n6, n7);
        }
        if (this.m_introState >= 11) {
            AnimationManager.drawAnimFrame(graphics, n5, 6, n6, n7);
        }
        AnimationManager.drawAnimFrame(graphics, n5, 0, n6, n7);
        int n9 = n6;
        if (this.m_introState == 10) {
            n4 = appEngine.getWidth();
            n3 = n6;
            n9 = this.getPath(n4, n3, n8, 3);
        }
        n4 = Math.min(0, n9 - n6);
        if (this.m_introState >= 8) {
            n3 = AnimationManager.getAnimFrameHeight(n5, 1);
            n2 = -n3;
            int n10 = n = n7;
            if (this.m_introState == 8) {
                n10 = this.getPath(n2, n, n8, 4);
            }
            if (n10 >= n7) {
                AnimationManager.drawAnimFrame(graphics, n5, 2, n6, n7);
            }
            AnimationManager.drawAnimFrame(graphics, n5, 1, n6 + n4, n10);
        }
        if (this.m_introState >= 9) {
            n = n2 = n6;
            if (this.m_introState == 9) {
                n = this.getPath(0, n2, n8, 3);
            }
            int[] nArray = this.m_tempInt4;
            AnimationManager.getAnimFrameFirePoint(nArray, n5, 3, 0);
            this.drawThe(graphics, n + n4 + nArray[0], n7 + nArray[1] + 9, 3);
        }
        if (this.m_introState >= 10) {
            AnimationManager.drawAnimFrame(graphics, n5, 4, n9, n7);
            if (n9 <= n6) {
                AnimationManager.drawAnimFrame(graphics, n5, 5, n9, n7);
            }
        }
        if (this.m_introState == 13 && this.m_introTimer % 750 < 375) {
            int[] nArray = this.m_tempInt4;
            AnimationManager.getAnimFrameFirePoint(nArray, n5, 7, 0);
            appEngine.drawString(37, 0, n6 + nArray[0], n7 + nArray[1], 3);
        }
    }

    private void drawThe(Graphics graphics, int n, int n2, int n3) {
        AppEngine appEngine = this.m_engine;
        SDKString sDKString = appEngine.getString(28);
        appEngine.drawString(sDKString, n3, n, n2, 3);
    }

    private int getPath(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        switch (n4) {
            default: {
                AppEngine.ASSERT(false, "invalid path type");
            }
            case 0: {
                return n + MathExt.clip(MathExt.Fmul(n3, n5), 0, n5);
            }
            case 1: {
                n3 = MathExt.smoothstepF(0, 65536, n3);
                return n + MathExt.clip(MathExt.Fmul(n3, n5), 0, n5);
            }
            case 2: {
                n3 = MathExt.smoothstepF(0, 65536, 32768 + (n3 >> 1));
                return n + MathExt.clip(MathExt.Fmul(n3, n5), 0, n5);
            }
            case 3: {
                if (n3 < 58982) {
                    n3 = MathExt.Fmul(MathExt.smoothstepF(0, 58982, n3), 68812);
                } else {
                    int n6 = 65536 - MathExt.Fdiv(n3 - 58982, 6554);
                    n3 = 65536 + MathExt.Fmul(3276, n6);
                }
                return n + MathExt.Fmul(n3, n5);
            }
            case 4: {
                if (n3 < 55705) {
                    n3 = MathExt.Fmul(MathExt.smoothstepF(0, 55705, n3), 68812);
                } else {
                    int n7 = 65536 - MathExt.Fdiv(n3 - 55705, 9831);
                    n3 = 65536 + MathExt.Fmul(3276, n7);
                }
                return n + MathExt.Fmul(n3, n5);
            }
            case 5: {
                if (n3 < 49152) {
                    n3 = MathExt.Fmul(MathExt.smoothstepF(0, 49152, n3), 98304);
                } else {
                    int n8 = 65536 - MathExt.Fdiv(n3 - 49152, 16384);
                    n3 = 65536 + MathExt.Fmul(32768, n8);
                }
                return n + MathExt.Fmul(n3, n5);
            }
            case 6: 
        }
        if (n3 < 32768) {
            int n9 = MathExt.Fdiv(MathExt.Fmul(n3, 102944), 32768);
            n3 = MathExt.Fmul(MathExt.Fsin(n9), 72089);
        } else {
            int n10 = MathExt.Fdiv(n3 - 32768, 32768);
            int n11 = MathExt.Fmul(n10, 617662);
            int n12 = 6554 - MathExt.Fmul(6554, n10);
            n3 = MathExt.Fmul(MathExt.Fcos(n11), n12) + 65536;
        }
        return n + MathExt.Fmul(n3, n5);
    }

    private void drawBG(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = 567;
        if (appEngine.getRMSLangIndex() == 1) {
            n = 568;
        }
        int n2 = appEngine.getHalfWidth();
        int n3 = appEngine.getHalfHeight();
        AnimationManager.drawAnimFrame(graphics, n, 8, n2, n3);
    }

    private void drawMainMenu(Graphics graphics) {
        int n;
        int n2;
        AppEngine appEngine = this.m_engine;
        short[] sArray = this.m_mainMenu;
        int n3 = sArray[0];
        short s = sArray[2];
        int n4 = n3 * 22 - 2;
        int n5 = n4 + 14 + 19 + 5 + 19;
        int n6 = appEngine.getWidth() * 140 / 176;
        int n7 = appEngine.getWidth() - n6 >> 1;
        int n8 = (appEngine.getHeight() - n5 >> 1) + 2;
        int n9 = 0;
        if (this.m_introMaxTimer != 0) {
            n9 = MathExt.Fdiv(this.m_introTimer, this.m_introMaxTimer);
        }
        int n10 = n8;
        int n11 = n5;
        if (this.m_introState == 14) {
            n11 = this.getPath(27, n5, n9, 0);
            n10 = (appEngine.getHeight() - n11 >> 1) + 2;
        }
        this.drawTitleBox(graphics, n7, n10, n6, n11, -1, 4);
        if (this.m_introState >= 15) {
            n11 = appEngine.getWidth() >> 1;
            int n12 = n2 = n8 + 9;
            if (this.m_introState == 15) {
                int n13 = AnimationManager.getAnimFrameHeight(567, 9);
                n = -n13;
                n12 = this.getPath(n, n2, n9, 3);
            }
            if (appEngine.getRMSLangIndex() == 1) {
                AnimationManager.drawAnimFrame(graphics, 568, 9, n11, n12);
            } else {
                AnimationManager.drawAnimFrame(graphics, 567, 9, n11, n12);
            }
            int[] nArray = this.m_tempInt4;
            AnimationManager.getAnimFrameFirePoint(nArray, 567, 9, 0);
            this.drawThe(graphics, n11 + nArray[0], n12 + nArray[1] + 5, 4);
        }
        if (this.m_introState >= 16) {
            n10 = n6 - 14;
            n11 = n7 + 7;
            n2 = n3;
            if (this.m_introState == 16) {
                n2 = this.m_introTimer / 200;
                n9 = MathExt.Fdiv(this.m_introTimer % 200, 200);
            }
            int n14 = n8 + 22 + 7 + 19;
            for (n = 0; n < n3; ++n) {
                short s2 = sArray[5 + n];
                int n15 = n14;
                if (n == n2) {
                    n15 = n14 + this.getPath(-3, 0, n9, 5);
                } else if (n > n2) break;
                if (n == 4) {
                    this.drawButtonBoxForMoreGames(graphics, n11, n15, n10, 20, n == s, s2);
                } else {
                    this.drawButtonBox(graphics, n11, n15, n10, 20, n == s, s2);
                }
                n14 += 22;
            }
        }
        if (this.m_introState >= 17) {
            n10 = 0;
            if (this.m_introState == 17) {
                n10 = 15 - this.getPath(0, 15, n9, 0);
            }
            appEngine.renderSoftkeyBar(graphics, n10);
        }
    }

    private void casStart() {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        appEngine.resetRMSGameData();
        appEngine.clearSimName();
        this.m_casArms = simData.getSimAttribute(0, 6) != 0;
        this.m_casLegs = simData.getSimAttribute(0, 8) != 0;
        this.m_casHairAcc = this.doesHairStyleHaveAccent(simData.getSimAttribute(0, 2));
        this.m_cursorPosition = 0;
        this.stateTransition(10);
        this.reloadCASSim(false);
    }

    private void reloadCASSim(boolean bl) {
        this.restartCASSim(bl);
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = appEngine.getSimWorld();
        SimData simData = appEngine.getSimData();
        int[] nArray = this.m_palSources;
        int[] nArray2 = this.m_palPatches;
        simWorld.getSimPatches(0, nArray, nArray2);
        int n = simData.getSimAttribute(0, 0) == 0 ? 2048 : 1024;
        appEngine.unloadAllImages(3072, -1);
        appEngine.loadAllImages(n, nArray, nArray2, 0);
    }

    private void drawCASSim(Graphics graphics, int n, int n2, boolean bl) {
        int[] nArray;
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        int n3 = this.m_casAnimPlayer.getAnimID();
        if (bl) {
            nArray = this.m_tempInt4;
            AnimationManager.getAnimFrameFirePoint(nArray, n3, 0, 1);
            n -= nArray[0];
            n2 -= nArray[1];
        }
        this.m_casAnimPlayer.drawAnim(graphics, n, n2);
        nArray = this.m_tempInt4;
        this.m_casAnimPlayer.getFirePointCurrFrame(nArray, 0);
        int n4 = simData.getSimAttribute(0, 2);
        AnimationManager.drawAnimFrame(graphics, this.m_casHairAnim, n4, n + nArray[0], n2 + nArray[1]);
        if (simData.getSimAttribute(0, 8) != 0) {
            int n5 = n3 == 712 ? 713 : (n3 == 715 ? 716 : 17100);
            AnimationManager.drawAnimFrame(graphics, n5, 0, n, n2);
        }
    }

    private void restartCASSim(boolean bl) {
        int n;
        int n2;
        SimData simData = this.m_engine.getSimData();
        if (simData.getSimAttribute(0, 0) == 0) {
            if (bl) {
                n2 = 715;
                n = 717;
            } else {
                n2 = 17099;
                n = 17101;
            }
        } else {
            n2 = 712;
            n = 714;
        }
        this.m_casAnimPlayer.startAnim(n2, 4);
        this.m_casHairAnim = n;
    }

    private void updateCASSim(int n, boolean bl) {
        if (!this.m_casAnimPlayer.isAnimating()) {
            this.restartCASSim(bl);
        }
        this.m_casAnimPlayer.updateAnim(n);
    }

    private void updateCASAppearance(int n) {
        this.m_casUpArrow.updateAnim(n);
        if (!this.m_casUpArrow.isAnimating()) {
            this.m_casUpArrow.startAnim(690, 20);
        }
        this.m_casDownArrow.updateAnim(n);
        if (!this.m_casDownArrow.isAnimating()) {
            this.m_casDownArrow.startAnim(688, 20);
        }
        this.updateLeftRightArrows(n);
        this.m_casButtonsOffsetF = this.interpolateValue(this.m_casButtonsOffsetF, this.m_casButtonsOffsetTargetF, n, 8);
        this.m_casColorsOffsetF = this.interpolateValue(this.m_casColorsOffsetF, this.m_casColorsOffsetTargetF, n, 8);
        if (Math.abs(this.m_casButtonsOffsetF - this.m_casButtonsOffsetTargetF) < 32768) {
            this.m_casButtonsOffsetF = this.m_casButtonsOffsetTargetF;
        }
        if (Math.abs(this.m_casColorsOffsetF - this.m_casColorsOffsetTargetF) < 32768) {
            this.m_casColorsOffsetF = this.m_casColorsOffsetTargetF;
        }
    }

    private void processKeysCASAppearance(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 4)) {
            this.stateTransition(17);
        } else if (this.checkKeys(n, n2, 0, 2)) {
            this.fadeStateTransition(11);
        } else if (this.checkKeys(n, n2, 8196, 0) && this.m_casButtonIndex > 0) {
            this.m_casUpArrow.startAnim(689, 16);
            this.setAppearanceButtonIndex(this.m_casButtonIndex - 1, -1);
        } else if (this.checkKeys(n, n2, 16640, 0) && this.m_casButtonIndex < BUTTON_STRINGS.length - 1) {
            this.m_casDownArrow.startAnim(687, 16);
            this.setAppearanceButtonIndex(this.m_casButtonIndex + 1, 1);
        } else if (BUTTON_STRINGS[this.m_casButtonIndex] == 730) {
            if (this.checkKeys(n, n2, 32784, 0)) {
                this.setAppearancePreset(this.m_casAttributeIndex - 1);
                this.triggerLeftArrow();
            } else if (this.checkKeys(n, n2, 65600, 0)) {
                this.setAppearancePreset(this.m_casAttributeIndex + 1);
                this.triggerRightArrow();
            }
        } else if (this.checkKeys(n, n2, 32784, 0) && this.m_casAttributeIndex > this.m_casAttributeIndexMin) {
            this.setAppearanceAttributeIndex(this.m_casAttributeIndex - 1, false);
            this.triggerLeftArrow();
            this.reloadCASSim(false);
        } else if (this.checkKeys(n, n2, 65600, 0) && this.m_casAttributeIndex < this.m_casAttributeIndexMax) {
            this.setAppearanceAttributeIndex(this.m_casAttributeIndex + 1, false);
            this.triggerRightArrow();
            this.reloadCASSim(false);
        }
    }

    private void setAppearancePreset(int n) {
        SimData simData = this.m_engine.getSimData();
        int n2 = simData.getPresetCount();
        if (n < 0) {
            n = n2 - 1;
        } else if (n >= n2) {
            n = 0;
        }
        this.m_casAttributeIndex = n;
        byte[] byArray = simData.getAttributePreset(n);
        for (int i = 0; i < 10; ++i) {
            simData.setPlayerSimAttribute(i, byArray[i]);
        }
        this.m_casArms = byArray[10] == 0;
        this.m_casLegs = byArray[11] == 0;
        this.reloadCASSim(false);
    }

    private void setAppearanceButtonIndex(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        if (!this.m_casArms && BUTTON_STRINGS[n] == 738) {
            n += n2;
        }
        if (!this.m_casLegs && BUTTON_STRINGS[n] == 741) {
            n += n2;
        }
        if (!this.m_casHairAcc && BUTTON_STRINGS[n] == 735) {
            n += n2;
        }
        int n3 = appEngine.getHeight() - 15 - (AnimationManager.getAnimFrameHeight(706, 0) << 1);
        int n4 = AnimationManager.getAnimFrameCount(696);
        int n5 = AnimationManager.getAnimFrameHeight(697, 0);
        int n6 = (n3 >> 1) + 2 - n5 * n - (n5 >> 1);
        int n7 = n3 - 2 - n5 * n4;
        n6 = MathExt.clip(n6, n7, 2);
        this.m_casButtonsOffsetTargetF = n6 << 16;
        if (n2 == 0) {
            this.m_casButtonsOffsetF = n6 << 16;
        }
        this.m_casButtonIndex = n;
        n3 = 698;
        int n8 = 203;
        n4 = 203;
        n5 = -1;
        n6 = -1;
        n7 = 0;
        switch (BUTTON_STRINGS[n]) {
            case 730: {
                break;
            }
            case 731: {
                n4 = 700;
                n8 = 699;
                n5 = 0;
                break;
            }
            case 732: {
                n6 = 0;
                n5 = 1;
                break;
            }
            case 733: {
                if (appEngine.getSimData().getSimAttribute(0, 0) == 1) {
                    n8 = 701;
                    n4 = 702;
                } else {
                    n8 = 703;
                    n4 = 704;
                }
                n5 = 2;
                break;
            }
            case 734: {
                n6 = 1;
                n5 = 3;
                break;
            }
            case 735: {
                n6 = 2;
                n5 = 4;
                break;
            }
            case 736: {
                n6 = 3;
                n5 = 5;
                break;
            }
            case 737: {
                n8 = 709;
                n4 = 710;
                this.m_casAttributeIndex = this.m_casArms ? 0 : 1;
                break;
            }
            case 738: {
                n6 = 4;
                n5 = 6;
                n7 = 1;
                break;
            }
            case 739: {
                n6 = 5;
                n5 = 7;
                break;
            }
            case 740: {
                n8 = 707;
                n4 = 708;
                this.m_casAttributeIndex = this.m_casLegs ? 0 : 1;
                break;
            }
            case 741: {
                n6 = 6;
                n5 = 8;
                n7 = 1;
                break;
            }
            case 742: {
                n6 = 7;
                n5 = 9;
            }
        }
        this.m_casAttribute = n5;
        this.m_casAttributePatch = n6;
        this.m_casAttributesButtonsAnim = n3;
        this.m_casAttributesAnimHi = n8;
        this.m_casAttributesAnimLo = n4;
        this.m_casAttributeIndexMin = n7;
        if (n3 != 203) {
            if (n6 != -1) {
                AppEngine.ASSERT(n3 == 698, "need the color anim");
                this.m_casAttributeIndexMax = appEngine.getSimWorld().getPal(n6).length - 1;
            } else {
                this.m_casAttributeIndexMax = AnimationManager.getAnimFrameCount(n8) - 1;
            }
            if (n5 != -1) {
                this.setAppearanceAttributeIndex(appEngine.getSimData().getSimAttribute(0, n5), true);
            } else {
                this.setAppearanceAttributeIndex(this.m_casAttributeIndex, true);
            }
        }
    }

    private boolean doesHairStyleHaveAccent(int n) {
        int n2 = 1 << n;
        if (this.m_engine.getSimData().getSimAttribute(0, 0) == 0) {
            n2 <<= 16;
        }
        return (n2 & 0xC000D) != 0;
    }

    private void setAppearanceAttributeIndex(int n, boolean bl) {
        int n2;
        short s;
        SimData simData = this.m_engine.getSimData();
        this.m_casAttributeIndex = n;
        if (this.m_casAttribute != -1) {
            simData.setPlayerSimAttribute(this.m_casAttribute, n);
        }
        if ((s = BUTTON_STRINGS[this.m_casButtonIndex]) == 737) {
            if (n == 0) {
                this.m_casArms = true;
                n2 = simData.getSimAttribute(0, 5) + 1;
            } else {
                this.m_casArms = false;
                n2 = 0;
            }
            simData.setPlayerSimAttribute(6, n2);
        } else if (s == 740) {
            if (n == 0) {
                this.m_casLegs = true;
                n2 = simData.getSimAttribute(0, 7) + 1;
            } else {
                this.m_casLegs = false;
                n2 = 0;
            }
            simData.setPlayerSimAttribute(8, n2);
        } else if (s == 731 || s == 733) {
            this.m_casHairAcc = this.doesHairStyleHaveAccent(simData.getSimAttribute(0, 2));
        }
        int[] nArray = this.m_tempInt4;
        AnimationManager.getAnimFrameCollisionBox(nArray, 698, 0, 0);
        int n3 = nArray[2];
        int n4 = this.m_casAttributeIndexMax - this.m_casAttributeIndexMin + 1;
        int n5 = AnimationManager.getAnimFrameHeight(692, 0);
        int n6 = Math.min(n4 * n5, n3);
        int n7 = n3 - n6;
        int n8 = (n6 >> 1) + 0 - n5 * n - (n5 >> 1) + n7;
        int n9 = n6 - 0 - n5 * n4 + (n7 >> 1);
        n8 = MathExt.clip(n8, n9, 0);
        this.m_casColorsOffsetTargetF = n8 << 16;
        if (bl) {
            this.m_casColorsOffsetF = n8 << 16;
        }
    }

    private static final void drawVerticalGradient(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = nArray.length;
        int n6 = (n4 << 16) / n5;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            AnimationManager.setColor(graphics, nArray[i]);
            int n8 = (i + 1) * n6 + 32768 >> 16;
            graphics.fillRect(n, n2 + n7, n3, n8 - n7);
            n7 = n8;
        }
    }

    private static final void renderCASBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = SceneMenu.calculateCASGroundHeight(n4);
        int n6 = n4 - n5;
        SceneMenu.drawVerticalGradient(graphics, GRAD_CAS_SKY, n, n2, n3, n4);
        SceneMenu.drawVerticalGradient(graphics, GRAD_CAS_GROUND, n, n2 + n6, n3, n5);
    }

    private static final int calculateCASGroundHeight(int n) {
        return MathExt.Fmul(17902, n);
    }

    private void renderCASAppearance(Graphics graphics) {
        int n;
        int n2;
        int n3;
        AppEngine appEngine = this.m_engine;
        int n4 = appEngine.getWidth();
        int n5 = appEngine.getHeight() - 15;
        SceneMenu.renderCASBackground(graphics, 0, 0, n4, n5);
        int[] nArray = this.m_tempInt4;
        int n6 = AnimationManager.getAnimFrameHeight(706, 0);
        int n7 = AnimationManager.getAnimFrameWidth(706, 0);
        int n8 = n7 + 4;
        int n9 = 0 + n6;
        int n10 = n7 - 4;
        int n11 = n5 - (n6 << 1);
        int n12 = n4 + 2 + n8 >> 1;
        int n13 = SceneMenu.calculateCASGroundHeight(n5);
        int n14 = n5 - (n13 >> 1);
        int n15 = graphics.getClipX();
        int n16 = graphics.getClipY();
        int n17 = graphics.getClipWidth();
        int n18 = graphics.getClipHeight();
        AnimationManager.setColor(graphics, 60);
        graphics.fillRect(2, 0, 1, n5);
        graphics.fillRect(2 + n8 - 1, 0, 1, n5);
        AnimationManager.setColor(graphics, 77);
        graphics.fillRect(3, 0, 1, n5);
        graphics.fillRect(2 + n8 - 2, 0, 1, n5);
        AnimationManager.setColor(graphics, 76);
        graphics.fillRect(4, n6, 2, n11);
        graphics.fillRect(2 + n8 - 2 - 2, n6, 2, n11);
        SceneMenu.drawVerticalGradient(graphics, GRAD_CAS_LIST, 6, n9, n10, n11);
        AnimationManager.drawAnimFrame(graphics, 706, 0, 4, 0);
        AnimationManager.drawAnimFrame(graphics, 705, 0, 4, n5);
        int n19 = 6 + (n10 >> 1);
        int n20 = AnimationManager.getAnimFrameCount(696);
        int n21 = AnimationManager.getAnimFrameHeight(697, 0);
        if (this.m_casButtonIndex > 0) {
            AnimationManager.getAnimFrameFirePoint(nArray, 706, 0, 0);
            this.m_casUpArrow.drawAnim(graphics, 4 + nArray[0], 0 + nArray[1]);
        }
        if (this.m_casButtonIndex < n20 - 1) {
            AnimationManager.getAnimFrameFirePoint(nArray, 705, 0, 0);
            this.m_casDownArrow.drawAnim(graphics, 4 + nArray[0], n5 + nArray[1]);
        }
        graphics.setClip(6, n9, n10, n11);
        int n22 = n9 + (this.m_casButtonsOffsetF >> 16);
        for (n3 = 0; n3 < n20; ++n3) {
            n2 = n3 == this.m_casButtonIndex ? 697 : 696;
            n = n3;
            if (BUTTON_STRINGS[n3] == 738 && !this.m_casArms) {
                n2 = 695;
                n = 0;
            }
            if (BUTTON_STRINGS[n3] == 741 && !this.m_casLegs) {
                n2 = 694;
                n = 0;
            }
            if (BUTTON_STRINGS[n3] == 735 && !this.m_casHairAcc) {
                n2 = 693;
                n = 0;
            }
            AnimationManager.drawAnimFrame(graphics, n2, n, n19, n22);
            n22 += n21;
        }
        graphics.setClip(n15, n16, n17, n18);
        AnimationManager.drawAnimFrame(graphics, 711, 0, n12, n14);
        this.drawCASSim(graphics, n12, n14, false);
        n20 = BUTTON_STRINGS[this.m_casButtonIndex];
        n22 = appEngine.getWidth() - n8 - 2 - 8;
        n3 = 2 + n8 + 4;
        n19 = this.drawDropDownDoubleTitle(graphics, n3, n22, 726, n20);
        n21 = this.m_casAttributesButtonsAnim;
        if (n21 != 203) {
            n22 = n12;
            n3 = n19 + MathExt.Fmul(n5 - n13 - n19, 12179);
            AnimationManager.drawAnimFrame(graphics, n21, 0, n22, n3);
            AnimationManager.getAnimFrameCollisionBox(nArray, n21, 0, 0);
            n2 = n22 + nArray[0];
            n = n3 + nArray[1];
            int n23 = nArray[2];
            int n24 = nArray[3];
            int n25 = n + (n24 >> 1);
            int n26 = AnimationManager.getAnimFrameWidth(692, 0);
            graphics.setClip(n2, n, n23, n24);
            boolean bl = this.m_casAttributePatch != -1;
            int n27 = n2 + (this.m_casColorsOffsetF >> 16) + (bl ? 0 : n26 >> 1);
            for (int i = this.m_casAttributeIndexMin; i <= this.m_casAttributeIndexMax; ++i) {
                if (bl) {
                    SimWorld simWorld = appEngine.getSimWorld();
                    int n28 = this.m_casAttributePatch;
                    byte[] byArray = simWorld.getPal(n28);
                    int[] nArray2 = simWorld.getPatch(byArray[i]);
                    this.renderCASColor(graphics, n27, n25, nArray2, i == this.m_casAttributeIndex);
                } else {
                    int n29 = i == this.m_casAttributeIndex ? this.m_casAttributesAnimHi : this.m_casAttributesAnimLo;
                    AnimationManager.drawAnimFrame(graphics, n29, i, n27, n25);
                }
                n27 += n26;
            }
            graphics.setClip(n15, n16, n17, n18);
            if (this.m_casAttributeIndex > this.m_casAttributeIndexMin || n20 == 730) {
                AnimationManager.getAnimFrameFirePoint(nArray, n21, 0, 0);
                this.m_arrowLeftAnimPlayer.drawAnim(graphics, n22 + nArray[0], n3 + nArray[1]);
            }
            if (this.m_casAttributeIndex < this.m_casAttributeIndexMax || n20 == 730) {
                AnimationManager.getAnimFrameFirePoint(nArray, n21, 0, 1);
                this.m_arrowRightAnimPlayer.drawAnim(graphics, n22 + nArray[0], n3 + nArray[1]);
            }
        }
        appEngine.renderSoftkeyBar(graphics);
    }

    private void renderCASColor(Graphics graphics, int n, int n2, int[] nArray, boolean bl) {
        int n3 = bl ? 692 : 691;
        AnimationManager.drawAnimFrame(graphics, n3, 0, n, n2);
        int[] nArray2 = this.m_tempInt4;
        AnimationManager.getAnimFrameCollisionBox(nArray2, 691, 0, 0);
        int n4 = n + nArray2[0];
        int n5 = n2 + nArray2[1];
        int n6 = nArray2[2];
        int n7 = nArray2[3];
        graphics.setColor(nArray[1]);
        graphics.fillRect(n4, n5, n6, n7);
        graphics.setColor(nArray[3]);
        graphics.fillRect(n4 + 1, n5 + 1, n6 - 2, 3);
        graphics.setColor(nArray[2]);
        graphics.fillRect(n4 + 1, n5 + 1 + 3, n6 - 2, 5);
    }

    private void processKeysCASPersona(int n, int n2) {
        this.processKeysList(n, n2);
        if (this.checkKeys(n, n2, 0, 4)) {
            this.stateTransition(10);
        } else if (this.checkKeys(n, n2, 0, 2)) {
            this.stateTransition(12);
        } else if (this.checkKeys(n, n2, 4128, 16)) {
            int n3 = this.getListCursor();
            this.m_engine.getSimData().setPersona(n3);
            this.m_engine.setSoftKeys(4, 2);
        }
    }

    private void renderCASPersona(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.drawUIFullScreen(graphics, 18);
        int n = appEngine.getWidth();
        int n2 = appEngine.getHeight() - 15;
        this.drawCASSim(graphics, n, n2, true);
        appEngine.renderSoftkeyBar(graphics);
    }

    private void initListPersonas() {
        SimData simData = this.m_engine.getSimData();
        this.initList(simData.getPersonaCount(), 15, 0);
    }

    public void drawListPersonas(Graphics graphics, int n, int n2, int n3, int n4) {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        int n5 = n + (n3 >> 1);
        int n6 = n2;
        int n7 = this.getListCursor();
        for (int i = this.getListOffset(); n6 < n2 + n4 && i < this.getListNum(); ++i) {
            int n8;
            int n9;
            short s = simData.getPersonaDescString(i);
            int n10 = -1;
            if (i == simData.getPersona()) {
                n9 = 0;
                n8 = 1;
                n10 = 75;
            } else {
                n9 = 1;
                n8 = 2;
            }
            if (i == n7) {
                n10 = 82;
            }
            if (n10 != -1) {
                this.drawListSelect(graphics, n, n6, n3, 15, n2 + n4, n10, i);
            }
            appEngine.drawString(s, n9, n5, n6 + n8, 17);
            this.drawListDivider(graphics, n, n6 += 15, n3);
        }
    }

    public int drawUIPersonaDesc(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 8 + 4 * this.m_uiWrappedLineHeight;
        if (graphics != null) {
            this.drawDescBox(graphics, n, n2, n3, n5);
            int n6 = n3 - 8 - 15;
            int n7 = n + 4;
            int n8 = n2 + 4;
            int n9 = n8 + this.m_uiWrappedLineHeight;
            AppEngine appEngine = this.m_engine;
            appEngine.drawString(729, 1, n7, n8, 20);
            int n10 = this.getListCursor();
            short s = appEngine.getSimData().getPersonaLongDescString(n10);
            appEngine.drawWrappedStringChunk(0, s, 1, n6, n7, n9, 20);
        }
        return n5;
    }

    private void updateCASTraits(int n) {
        this.m_engine.updateScrollers(n);
    }

    private void processKeysCASTraits(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        this.processKeysList(n, n2);
        if (this.checkKeys(n, n2, 0, 4)) {
            this.stateTransition(11);
        } else if (this.checkKeys(n, n2, 0, 2)) {
            this.stateTransition(13);
        } else if (this.checkKeys(n, n2, 4128, 16)) {
            int n3 = this.getListCursor();
            if (simData.hasSimGotTrait(0, n3) == -1) {
                simData.traitPlayerAdd(n3);
            } else {
                simData.traitPlayerRemove(n3);
            }
            int n4 = appEngine.getSimData().getNumPlayerTraits();
            boolean bl = 5 == n4;
            appEngine.setSoftKeys(4, bl ? 2 : 0);
        }
    }

    private void renderCASTraits(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.drawUIFullScreen(graphics, 19);
        int n = appEngine.getWidth();
        int n2 = appEngine.getHeight() - 15;
        this.drawCASSim(graphics, n, n2, true);
        appEngine.renderSoftkeyBar(graphics);
    }

    private void initListTraits() {
        SimData simData = this.m_engine.getSimData();
        this.initList(simData.getTraitCount(), 15, 0);
    }

    public void drawListTraits(Graphics graphics, int n, int n2, int n3, int n4) {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        int n5 = n + (n3 >> 1);
        int n6 = n2;
        int n7 = this.getListCursor();
        for (int i = this.getListOffset(); n6 < n2 + n4 && i < this.getListNum(); ++i) {
            int n8;
            int n9;
            short s = simData.getTraitDescString(i);
            int n10 = -1;
            if (simData.hasSimGotTrait(0, i) != -1) {
                n9 = 0;
                n8 = 1;
                n10 = 75;
            } else {
                n9 = 1;
                n8 = 2;
            }
            if (i == n7) {
                n10 = 82;
            }
            if (n10 != -1) {
                this.drawListSelect(graphics, n, n6, n3, 15, n2 + n4, n10, i);
            }
            appEngine.drawString(s, n9, n5, n6 + n8, 17);
            this.drawListDivider(graphics, n, n6 += 15, n3);
        }
    }

    private void initCharEntry() {
        this.m_isCharSelected = false;
        this.m_cursorPosition = this.m_engine.getSimName().length();
        this.m_charSelectedTime = 0;
        this.m_lastKeyPressed = -1;
        this.m_charIndex = 0;
    }

    private void processKeysCASNameExtKey(char c) {
        if (this.m_isCharSelected) {
            this.finishCharEntry();
        }
        if (this.m_cursorPosition < 8 && this.m_engine.getSimNameLength() != 8) {
            this.m_engine.insertSimNameChar(this.m_cursorPosition, c);
            ++this.m_cursorPosition;
        }
    }

    private void finishCharEntry() {
        if (this.m_isCharSelected) {
            this.m_isCharSelected = false;
            if (this.m_cursorPosition < 8) {
                ++this.m_cursorPosition;
            }
            this.m_lastKeyPressed = -1;
        }
    }

    private void updateCASName(int n) {
        this.m_charSelectedTime += n;
        if (this.m_isCharSelected && this.m_charSelectedTime >= 1250) {
            this.finishCharEntry();
        }
    }

    private void processKeysCASName(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        int n3 = appEngine.getSimNameLength();
        char c = appEngine.getExtKey();
        if (c != '\u0000') {
            this.processKeysCASNameExtKey(c);
        } else if (this.checkKeys(n, n2, 4096, 2)) {
            if (appEngine.getSimNameLength() != 0) {
                this.stateTransition(18);
            }
        } else if (this.checkKeys(n, n2, 524288, 0)) {
            this.finishCharEntry();
            if (n3 == 0) {
                this.stateTransition(12);
            } else {
                if (this.m_cursorPosition > 0) {
                    --this.m_cursorPosition;
                }
                appEngine.removeSimNameChar(this.m_cursorPosition);
                appEngine.setSoftKeys(0, 0);
            }
        } else if (this.checkKeys(n, n2, 0, 4)) {
            this.stateTransition(12);
        } else if (this.checkKeys(n, n2, 32768, 0)) {
            this.finishCharEntry();
            if (this.m_cursorPosition != 0) {
                --this.m_cursorPosition;
            }
        } else if (this.checkKeys(n, n2, 65536, 0)) {
            this.finishCharEntry();
            if (this.m_cursorPosition != n3) {
                ++this.m_cursorPosition;
            }
        }
    }

    private void renderCASName(Graphics graphics) {
        int n;
        int n2;
        int n3;
        AppEngine.is_Z_keyPressed = true;
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        SceneMenu.renderCASBackground(graphics, 0, 0, appEngine.getWidth(), appEngine.getHeight() - 15);
        int n4 = appEngine.getWidth();
        int n5 = appEngine.getHeight() - 15;
        int n6 = n4 * 7 / 10;
        int n7 = n4 - n6 >> 1;
        int n8 = this.m_uiTextHeight * 6 + 6 + 22 + 5;
        int n9 = n5 - n8 + 5;
        int n10 = this.drawDropDownDoubleTitle(graphics, n7, n6, 753, -1);
        SDKString sDKString = appEngine.getSimName();
        int n11 = appEngine.getStringWidth(sDKString, 1);
        int n12 = n7 + (n6 - n11 >> 1);
        int n13 = n10 - 16;
        int n14 = appEngine.getLineHeight(1) - 2;
        appEngine.drawString(sDKString, 1, n12, n13, 20);
        int n15 = -1;
        if (this.m_isCharSelected || this.m_charSelectedTime / 750 % 2 == 1) {
            n15 = this.m_cursorPosition;
        }
        if (n15 != -1) {
            n3 = 5;
            n2 = n12;
            if (sDKString != null) {
                n2 += SDKUtils.getSubStringSize(sDKString, 0, n15);
                if (n15 != appEngine.getSimNameLength()) {
                    n3 = SDKUtils.getSubStringSize(sDKString, n15, 1);
                }
            }
            n = n13 + n14;
            AnimationManager.setColor(graphics, 0);
            graphics.fillRect(n2, n, n3, 1);
        }
        int n16 = n4 >> 1;
        n11 = n10 + (n5 - n10 - n8 >> 1);
        AnimationManager.drawAnimFrame(graphics, 718, 0, n16, n11);
        int[] nArray = this.m_tempInt4;
        AnimationManager.getAnimFrameFirePoint(nArray, 718, 0, 0);
        n13 = n16 + nArray[0];
        n14 = n11 + nArray[1];
        this.drawHUDSim(graphics, n13, n14);
        n16 = simData.getPersonaDescString(simData.getPersona());
        this.drawTitleBox(graphics, n7, n9, n6, n8, n16, 1);
        n11 = n7 + 3;
        int n17 = n9 + 22;
        n13 = n6 - 6;
        n14 = this.m_uiTextHeight * 5 + 6;
        this.drawDescBox(graphics, n11, n17, n13, n14);
        n15 = n11 + (n13 >> 1);
        n3 = n17 + 3 + 1;
        for (n2 = 0; n2 < 5; ++n2) {
            n = simData.getSimTrait(0, n2);
            short s = simData.getTraitDescString(n);
            appEngine.drawString(s, 1, n15, n3, 17);
            n3 += this.m_uiTextHeight;
        }
        appEngine.renderSoftkeyBar(graphics);
    }

    private void processKeysSelectSim(int n, int n2) {
        int n3;
        AppEngine appEngine = this.m_engine;
        int n4 = n3 = this.m_deleteButtonSelected ? 3 : appEngine.getRMSGameSlotIndex();
        int n5 = 3 + (m_state == 14 ? 1 : 0);
        if (this.checkKeys(n, n2, 0, 68)) {
            this.stateTransition(m_state == 14 ? 7 : 14);
        } else if (this.checkKeys(n, n2, 4128, 48)) {
            if (this.m_deleteButtonSelected) {
                AppEngine.ASSERT(m_state == 14, "argh!");
                this.stateTransition(15);
            } else if (m_state == 15) {
                if (appEngine.getRMSActiveGame()) {
                    this.stateTransition(16);
                }
            } else if (appEngine.getRMSActiveGame()) {
                appEngine.beginGame();
                this.changeScene(2, -1);
            } else {
                this.casStart();
            }
        } else if (this.checkKeys(n, n2, 8196, 0)) {
            n3 = (n3 + n5 - 1) % n5;
        } else if (this.checkKeys(n, n2, 16640, 0)) {
            n3 = (n3 + 1) % n5;
        }
        if (n3 != n4) {
            boolean bl = this.m_deleteButtonSelected = n3 == 3;
            if (!this.m_deleteButtonSelected) {
                appEngine.setRMSGameSlotIndex(n3);
                if (appEngine.getRMSActiveGame()) {
                    this.reloadCASSim(false);
                }
            }
            boolean bl2 = appEngine.getRMSActiveGame();
            if (m_state == 15) {
                appEngine.setSoftKeys(64, bl2 ? 32 : 0);
            }
        }
    }

    private void renderSelectSim(Graphics graphics) {
        int n;
        int n2;
        AppEngine appEngine = this.m_engine;
        int n3 = appEngine.getWidth();
        int n4 = appEngine.getHeight() - 15;
        int n5 = n4 - 6;
        int n6 = 3 + n5 - (SceneMenu.calculateCASGroundHeight(n5) >> 1);
        int n7 = n3 - 3 - 64 - 3 - 3;
        int n8 = m_state == 14 ? 77 : 43;
        AnimationManager.setColor(graphics, n8);
        graphics.fillRect(0, 0, n3, n4);
        n8 = graphics.getClipX();
        int n9 = graphics.getClipY();
        int n10 = graphics.getClipWidth();
        int n11 = graphics.getClipHeight();
        graphics.setClip(n8, 3, n10, n5);
        SceneMenu.renderCASBackground(graphics, 3, 3, 64, n5);
        graphics.setClip(n8, n9, n10, n11);
        AnimationManager.setColor(graphics, 0);
        graphics.drawRect(3, 3, 63, n5 - 1);
        if (!this.m_deleteButtonSelected && appEngine.getRMSActiveGame()) {
            this.drawCASSim(graphics, 35, n6, false);
        }
        n9 = m_state == 14 ? 67 : 68;
        n8 = this.drawDropDownTitle(graphics, 70, n7, n9);
        n9 = n8 + 3;
        n11 = n4 - 3 - 19;
        int n12 = (this.m_uiTextHeight << 2) + 8;
        int n13 = n11 - 3 - n12;
        int n14 = n4 - n9 - 3 - 19 - 3 - n12 - 3;
        int n15 = n14 - 6;
        int n16 = n15 / 3;
        int n17 = n9;
        for (n2 = 0; n2 < 3; ++n2) {
            n = !this.m_deleteButtonSelected && n2 == appEngine.getRMSGameSlotIndex() ? 1 : 0;
            SDKString sDKString = appEngine.getRMSActiveGame(n2) ? appEngine.getSimName(n2) : appEngine.getString(55);
            this.drawButtonBox(graphics, 70, n17, n7, n16, n != 0, sDKString);
            n17 += n16 + 3;
        }
        this.drawDescBoxDark(graphics, 70, n13, n7, n12);
        if (!this.m_deleteButtonSelected && appEngine.getRMSActiveGame()) {
            SimData simData = appEngine.getSimData();
            n16 = 70 + n7 - 4;
            n17 = n13 + 4 + 1;
            n2 = simData.getPersonaDescString(simData.getPersona());
            appEngine.drawString(n2, 1, 74, n17, 20);
            n = simData.getMoodDescStringId();
            appEngine.drawString(528, 1, 74, n17 += this.m_uiTextHeight, 20);
            appEngine.drawString(n, 1, n16, n17, 24);
            int n18 = simData.getSimCareer(0);
            int n19 = simData.getCareerDescString(n18);
            appEngine.drawString(653, 1, 74, n17 += this.m_uiTextHeight, 20);
            appEngine.drawString(n19, 1, n16, n17, 24);
            SDKString sDKString = appEngine.clearStringBuffer();
            appEngine.appendMoneyToBuffer(simData.getMoney());
            appEngine.drawString(sDKString, 1, 74, n17 += this.m_uiTextHeight, 20);
        }
        if (m_state == 14) {
            this.drawButtonBox(graphics, 70, n11, n7, 19, this.m_deleteButtonSelected, 57);
        }
        appEngine.renderSoftkeyBar(graphics);
    }
}

