/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import game.AppEngine;
import game.MapObject;
import game.MapObjectSim;
import game.Scene;
import game.SimData;
import game.SimWorld;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import generic.ResourceManager;
import generic.TileMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Stack;
import javax.microedition.lcdui.Graphics;

public final class SceneGame
extends Scene
implements Runnable {
    private int[] m_tempInt10 = new int[10];
    public static int m_state;
    private int m_stateTime;
    private int m_afterFadeState;
    private int m_nextScene;
    private int m_nextSceneState;
    private int m_initialState;
    private byte m_mapMode;
    private boolean m_suppressMenus;
    private int m_hudBottomHeight;
    private int m_viewportX;
    private int m_viewportY;
    private int m_viewportWidth;
    private int m_viewportHeight;
    private short m_maxContextMenuItems;
    private int m_loadingState;
    private Thread m_loadingThread;
    private int m_loadingThreadState;
    private int m_nextSimBank;
    private int m_loadSimId;
    private int[] m_palSources = new int[32];
    private int[] m_palPatches = new int[32];
    private byte m_loadSimCount;
    private byte[] m_loadedSims;
    private boolean m_playedMapModeMoveMusic;
    private boolean m_tutorialMessageActive;
    public static boolean isWinterToShow;
    private int m_normalTimeStep;
    private AnimPlayer m_timeAnimPlayer;
    private AnimPlayer m_buffRisingAnimPlayer;
    private AnimPlayer m_buffDroppingAnimPlayer;
    private int m_displayedMoney;
    private int m_postMessageBox;
    private int m_curtainState;
    private int m_curtainPlayerAction;
    private int m_curtainTime;
    private short m_tickerString1;
    private short m_tickerString2;
    private int m_tickerTimer;
    private int m_tickerOffsetF;
    private int m_tickerLengthF;
    private MapObject m_cursorObject;
    private int m_cursorPosX;
    private int m_cursorPosZ;
    private int m_cursorDestX;
    private int m_cursorDestZ;
    private boolean m_cursorAtDest;
    private int m_cursorAtDestTime;
    private AnimPlayer m_cursorAnimPlayer;
    private int m_cursorSelectTimer;
    private int m_cursorSelectFlags;
    private boolean m_cursorSnapping;
    private boolean m_keyLeft;
    private boolean m_keyRight;
    private boolean m_keyDown;
    private boolean m_keyUp;
    private int m_cameraDestX;
    private int m_cameraDestZ;
    private int m_cameraVelX;
    private int m_cameraVelZ;
    private int m_cameraLastVelX;
    private int m_cameraLastVelZ;
    private boolean m_cameraAtDest;
    private MapObject m_cameraFollowTarget;
    private boolean m_cameraFollowTargetReturn;
    private MapObject[] m_objects;
    private MapObjectSim[] m_objectsSims;
    private MapObjectSim m_playerSim;
    private Stack m_objectStack;
    private boolean m_refreshObjects;
    private boolean m_refreshObjectsSims;
    private boolean m_contextMenuActive;
    private boolean m_contextMenuOnSubMenu;
    private short m_contextMenuBackCursor;
    private short[] m_contextMenuItems;
    private short[] m_contextMenuActions;
    private short[] m_contextMenuFullActions;
    private MapObject m_contextMenuObject;
    private boolean m_pauseMenuActive;
    private short[] m_pauseMenuItems;
    private int m_pauseMenuState;
    private boolean m_shortcutMenuActive;
    private boolean m_shortcutByShortcutKey;
    private short[] m_shortcutMenuItems;
    private boolean m_quickLinksActive;
    private short[] m_quickLinksMenu;
    private int m_buyModeState;
    private int m_buyNewType;
    private MapObject m_buyModeObject;
    public static int XMAS_TREE_LIST_INDEX;
    private int m_infoScreenState;
    private int m_infoLoadedNPC;
    private int m_infoScreenSimSelectedIndex;
    private int m_npcLongestStringLength;
    private int m_skillLongestStringLength;
    private int m_motiveLongestStringLength;
    private int m_infoScreenRecipeSelected;
    private int m_infoScreenItemSelectedIndex;
    private int m_jobOfferCareer;
    private int m_jobOfferLevel;
    private int m_payIncome;
    private boolean m_quitJobConfirmed;
    private boolean m_showBonusUnlocked;
    private boolean m_showNewDream;
    private AnimPlayer[] m_dreamAnimPlayers;
    private int m_showGetItem;
    private int m_showGetItemQty;
    private int m_showGetItemTitle;
    private int m_showGetItemMessage;
    private int m_simAIEventTimer;
    private int m_ambientEventTimer;
    private short[] m_ambientSounds;
    private int m_ambientSoundRate;
    private int m_simInactivityTimer;
    private static final short[] AMBIENT_MM_SOUNDS;
    private static final short[] AMBIENT_LAKESIDE_SOUNDS;
    private int m_actionQueueSize;
    private int[] m_actionQueueActions;
    private MapObject[] m_actionQueueArg1s;
    private int[] m_actionQueueArg2s;
    private int[] m_actionQueueArg3s;
    private SimData m_simData;
    private SimWorld m_simWorld;
    private int m_displayedMoodLevel;
    private int m_timeHit;
    private AnimPlayer m_playerGemAnimPlayer;
    private int m_questId;
    private int m_questSimId;
    private int m_questState;
    private int m_chanceCardOutcome;
    private boolean m_showFetchQuestEnd;
    private int m_eventState;
    private int m_eventId;
    private int m_eventTopStringId;
    private int m_eventBottomStringId;
    private int m_eventParam;
    private int m_eventTimer;
    private MapObject m_preEventCursorObject;
    private int m_miniGameState;
    private MapObject m_miniGameTargetObject;
    private int m_miniGameType;
    private int m_miniGameSkill;
    private int m_minigameTop;
    private int m_minigameBottom;
    private AnimPlayer[] m_miniGameAnimPool;
    private int[][] m_miniGameAnimPoolPos;
    private int m_miniGameTimer;
    private int m_miniGameTimerMax;
    private int m_cookingPotCount;
    private int m_cookingPotActive;
    private int m_cookingLevelReduceF;
    private int m_cookingLevelIncreaseF;
    private int[] m_cookingLevelsF = new int[4];
    private int[] m_displayedCookingLevelsF = new int[4];
    private byte[] m_cookingPotContents = new byte[4];
    private int m_cookingDeadPotAnim;
    private int m_fishingCursorPosF;
    private int m_fishingFishPosF;
    private int m_fishingFishPosFromF;
    private int m_fishingFishPosToF;
    private int m_fishingLevelF;
    private AnimPlayer m_fishingAnimPlayer;
    private AnimPlayer m_fishingHighlightAnimPlayer;
    private int m_fishingFishSpeed;
    private int m_fishingMinFishMove;
    private int m_fishingFishType;
    public static int SKEER_Y;
    public static int SKIER_SPEED;
    public static int SKIER_CURRENT_SPEED;
    public static int FLAG_TAKEN_VALIDATION;
    public static int MINI_GAME_SCREEN_WIDTH;
    public static int MINI_GAME_SCREEN_HEIGHT;
    public static boolean MINIGAME_STARTED;
    public static boolean PRESS_OK;
    public static boolean START_COUNTDOWN;
    public static boolean VIBRATE_ON_COLLISION;
    public static int LIFE_COUNT;
    public static boolean LIFE_COLAPSE;
    public static boolean SKIER_BLINKING;
    private int borderCounter = 0;
    public static boolean collidedWithCandy;
    public static int START_PIT_Y;
    private int tempCounter = 0;
    static boolean switchOutOfMiniGameSuccess;
    static boolean switchOutOfMiniGameFailure;
    public static long SYSTEM_TIME;
    public static long SYSTEM_TEMP;
    public static int TIME_CAL;
    public static boolean GET_TIME;
    public static int TRACK_WIDTH;
    public static int STYLUS_TIP;
    public static int STYLUS_CURVE_PEAK_X;
    public static int CURVE_RENDERING_WIDTH;
    public static int BORDER_POINT_WIDTH;
    public static int BORDER_POINT_HEIGHT;
    public static int STYLUS_CURVE_PEAK_X_BUFFER;
    public static boolean GENERATE_NEXT_CURVE;
    public static float CURVENESS;
    public static float CURVE_FACTOR;
    public static int CURVE_START;
    public static float SPEED_TO_CURVE_RATIO;
    public static int FLAG_PLACE;
    public static int FLAG_PLACE_RANDOM;
    public static int FLAG_Y;
    public static int PLACE_BETWEEN_FLAG;
    public static int MAX_FLAG_OFFSET;
    public static int MAX_FLAG_OFFSET_X;
    public static int PATCH_Y;
    public static int SNOW_PATCH_RANDOM;
    public static int FLAG_Y_COORD;
    public static int FLAG_X_COORD;
    public static int FLAG_POINT_X;
    public static int FLAG_TAKEN;
    public static int FLAG_HAS_TO_TAKEN;
    public static boolean COLLISION_WITH_BORDER;
    public static boolean COLLISION_WITH_OBSTACLE;
    public static int TIME;
    public static int SKEER_WIDTH;
    public static int SKEER_HEIGHT;
    public static int SKEER_X;
    public static int SKIER_X;
    public static int SKIER_Y;
    public static int ANIM_COLLISION_TIME;
    public static int BLINKING_EFFECT_INTERVAL;
    public static int COLLISION_TIME;
    public static boolean SHOW_SKIER;
    public static int SKIING_GAME_HUD;
    public static boolean START_GAME;
    public static int COUNTDOWN_TIMER_INTERVAL;
    public static int GAME_COUNTDOWN_TIMER;
    public static int GAME_TIMER_COUNT;
    public static boolean skingSuccess;
    public static int flag_o;
    public static boolean collission;
    public static int SKEER_BEHAVIOUR;
    public static int CAMERA_PANNING_FACTOR;
    public static int SKIER_CONDITION;
    private AnimPlayer m_repairingAnimPlayer;
    private static final byte[] REPAIR_WIRE_DX;
    private static final byte[] REPAIR_WIRE_DY;
    private byte[][] m_repairWirePaths;
    private byte[] m_repairWireEnds;
    private short[][] m_repairWireStartEndsPos;
    private int m_repairingClippersPosF;
    private int m_repairingNumWires;
    private int m_repairingNumSparks;
    private int m_repairingSparkTimer;
    private AnimPlayer m_cleaningAnimPlayer;
    private int m_cleaningCursorPosXF;
    private int m_cleaningCursorPosYF;
    private int m_cleaningCursorDirtIndex;
    private int m_cleaningWobbleRange;
    private int m_cleaningWobbleAccelF;
    private int m_cleaningWobbleVelXF;
    private int m_cleaningWobbleVelYF;
    private int m_cleaningWobbleOffsetXF;
    private int m_cleaningWobbleOffsetYF;
    private int m_shoppingState;
    private int m_shoppingObjectType;
    private int m_shoppingTradeAmount;
    private short[] m_cheatMenu;
    private SDKString[] m_cheatMenuStrings;

    public SceneGame(AppEngine appEngine) {
        super(appEngine);
    }

    public boolean isHouseMode() {
        return this.m_mapMode == 0;
    }

    public boolean isMapMode() {
        return this.m_mapMode == 2;
    }

    public boolean isZoomMapMode() {
        return this.m_mapMode == 1;
    }

    private void DEBUG_SCENEGAMELOADING(String string) {
    }

    private void updateLoading(int n) {
        this.m_engine.updateLoading(n);
        if (this.m_loadingThread == null) {
            this.DEBUG_SCENEGAMELOADING("thread starting");
            this.m_loadingThread = new Thread(this);
            this.m_loadingThreadState = 0;
            this.m_loadingThread.start();
        } else {
            this.m_loadingThreadState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_loadingThreadState != 2) {
            if (this.m_loadingThreadState != 0) {
                try {
                    SceneGame sceneGame = this;
                    synchronized (sceneGame) {
                        this.DEBUG_SCENEGAMELOADING("thread waiting");
                        this.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            this.m_loadingThreadState = 1;
            this.updateLoadingState();
        }
        this.DEBUG_SCENEGAMELOADING("thread quiting");
    }

    private void updateLoadingState() {
        AppEngine appEngine = this.m_engine;
        switch (this.m_loadingState) {
            case 0: {
                AppEngine.timerBegin();
                ++this.m_loadingState;
                break;
            }
            case 1: {
                SimWorld simWorld = this.m_simWorld;
                simWorld.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
                this.m_refreshObjects = true;
                this.m_refreshObjectsSims = true;
                boolean bl = true;
                if (this.m_mapMode == 2) {
                    this.initMacroMap();
                } else if (this.m_mapMode == 1) {
                    this.initZoomMap();
                    if (this.getSimObjects().length > 1) {
                        bl = false;
                    }
                } else {
                    this.initHouseMap();
                }
                if (bl) {
                    MapObjectSim mapObjectSim = this.getPlayerSim();
                    int n = mapObjectSim.getPosX();
                    int n2 = mapObjectSim.getPosZ();
                    this.m_cursorDestX = simWorld.coordWorldToScreenX(n, n2);
                    this.m_cursorDestZ = simWorld.coordWorldToScreenY(n, n2);
                }
                this.m_cursorPosX = this.m_cursorDestX;
                this.m_cursorPosZ = this.m_cursorDestZ;
                this.clearCameraFollow();
                this.snapCameraPosition();
                ++this.m_loadingState;
                appEngine.loadImagesBegin();
                break;
            }
            case 2: {
                int n = 8;
                switch (this.m_mapMode) {
                    case 2: {
                        n |= 0x20;
                        break;
                    }
                    default: {
                        AppEngine.ASSERT(false, "invalid map mode");
                    }
                    case 0: {
                        n |= 0x10;
                        MapObject mapObject = this.findRandomObjectByParentType(10);
                        if (mapObject == null) break;
                        if (mapObject.getType() == 46) {
                            n |= 0x8000000;
                        }
                        if (mapObject.getType() == 48) {
                            n |= 0x10000000;
                        }
                        if (mapObject.getType() == 50) {
                            n |= 0x20000000;
                        }
                        if (mapObject.getType() != 52) break;
                        n |= 0x40000000;
                        break;
                    }
                    case 1: {
                        if (appEngine.getNextZoomMapId() == 41) {
                            n |= 0x20000;
                            break;
                        }
                        if (appEngine.getNextZoomMapId() != 43) break;
                        n |= 0x40000;
                    }
                }
                if (!appEngine.loadImagesNext(n)) break;
                ++this.m_loadingState;
                break;
            }
            case 3: {
                ResourceManager resourceManager = appEngine.getResourceManager();
                SimWorld simWorld = this.m_simWorld;
                if (this.isMapMode()) {
                    int[] nArray = simWorld.getPatch(0);
                    int n = 0;
                    int[] nArray2 = simWorld.getPatch(1);
                    AnimationManager.loadImage(resourceManager, 40, nArray, nArray2, n);
                    AnimationManager.loadImage(resourceManager, 37, nArray, nArray2, n);
                    nArray2 = simWorld.getPatch(2);
                    AnimationManager.loadImage(resourceManager, 40, nArray, nArray2, ++n);
                    AnimationManager.loadImage(resourceManager, 37, nArray, nArray2, n);
                    nArray2 = simWorld.getPatch(3);
                    AnimationManager.loadImage(resourceManager, 40, nArray, nArray2, ++n);
                    AnimationManager.loadImage(resourceManager, 37, nArray, nArray2, n);
                    nArray2 = simWorld.getPatch(4);
                    AnimationManager.loadImage(resourceManager, 40, nArray, nArray2, ++n);
                    AnimationManager.loadImage(resourceManager, 37, nArray, nArray2, n);
                    this.loadPlayerSim();
                    ++this.m_loadingState;
                    break;
                }
                this.loadNewSimBegin();
                while (this.m_loadSimCount > 0) {
                    this.updateLoadSim();
                }
                ++this.m_loadingState;
                break;
            }
            case 4: {
                short[] sArray = null;
                int n = 0;
                if (this.isMapMode()) {
                    sArray = AMBIENT_MM_SOUNDS;
                    n = 3000;
                } else if (appEngine.getNextZoomMapId() == 41) {
                    sArray = AMBIENT_LAKESIDE_SOUNDS;
                    n = 8000;
                } else if (appEngine.getNextZoomMapId() != -1) {
                    sArray = AMBIENT_MM_SOUNDS;
                    n = 10000;
                }
                this.m_ambientSounds = sArray;
                this.m_ambientSoundRate = n;
                ++this.m_loadingState;
                break;
            }
            case 5: {
                this.stateTransition(this.m_initialState);
                if (this.isMapMode()) {
                    this.showTutorialMessage((byte)1);
                } else {
                    this.showTutorialMessage((byte)0);
                }
                this.m_loadingThreadState = 2;
                AppEngine.timerEnd("loading");
                appEngine.setFadeStep(197379);
                appEngine.startFadeIn();
            }
        }
    }

    private final void DEBUG_LOADSIM(String string) {
    }

    private void initSimAssets() {
        this.m_nextSimBank = 0;
        this.m_loadSimId = 0;
        this.m_loadSimCount = 0;
        this.DEBUG_LOADSIM("initSimAssets");
        if (!this.isMapMode()) {
            if (this.m_loadedSims == null) {
                this.m_loadedSims = new byte[4];
            }
            AppEngine.fillArray(this.m_loadedSims, -1);
        }
    }

    private void loadNewSim(MapObjectSim mapObjectSim) {
        if (!this.isMapMode()) {
            AppEngine.ASSERT(this.m_loadSimId == -1 || m_state == 1, "trying to load too many sims mid-frame");
            this.m_loadSimCount = (byte)(this.m_loadSimCount + 1);
            int n = this.nextAvailableBank();
            AppEngine.ASSERT(n != -1, "no banks available to load sim");
            this.m_loadedSims[n] = (byte)mapObjectSim.getId();
        }
    }

    private void loadNewSimBegin() {
        for (int i = 0; i < 4; ++i) {
            MapObjectSim mapObjectSim;
            int n = this.m_loadedSims[i];
            if (n == -1 || (mapObjectSim = this.findSim(n)).getBank() != -1) continue;
            this.m_nextSimBank = i;
            this.m_loadSimId = n;
            this.m_simWorld.getSimPatches(n, this.m_palSources, this.m_palPatches);
            this.m_engine.loadImagesBegin();
            return;
        }
        AppEngine.ASSERT(false, "shouldn't get to here");
    }

    private int nextAvailableBank() {
        return AppEngine.indexOf(-1, this.m_loadedSims);
    }

    private void updateLoadSim() {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        int n = this.m_nextSimBank;
        int n2 = this.m_loadSimId;
        int n3 = simData.getSimAttribute(n2, 0) == 0 ? 512 : 256;
        AppEngine.doGC();
        if (appEngine.loadImagesNext(n3, this.m_palSources, this.m_palPatches, n)) {
            int n4 = this.getSimHairImage(n2);
            AnimationManager.loadImage(appEngine.getResourceManager(), n4, this.m_palSources, this.m_palPatches, n);
            MapObjectSim mapObjectSim = this.findSim(n2);
            mapObjectSim.setBank(n);
            this.m_loadSimId = -1;
            this.m_nextSimBank = n + 1;
            this.m_loadSimCount = (byte)(this.m_loadSimCount - 1);
            if (n2 == 0) {
                this.loadPlayerSim();
            }
            this.DEBUG_LOADSIM("finished loading sim");
            if (this.m_loadSimCount > 0) {
                this.DEBUG_LOADSIM("loading next sim");
                this.loadNewSimBegin();
            }
        }
    }

    private void loadPlayerSim() {
        this.m_simWorld.getSimPatches(0, this.m_palSources, this.m_palPatches);
        int n = this.m_simData.getSimAttribute(0, 0) == 0 ? 4096 : 8192;
        this.m_engine.loadAllImages(n, this.m_palSources, this.m_palPatches, 0);
    }

    private int getSimHairImage(int n) {
        SimData simData = this.m_simData;
        int n2 = simData.getSimAttribute(n, 2);
        if (simData.getSimAttribute(n, 0) == 0) {
            return n2 == 0 ? 86 : (n2 == 1 ? 87 : (n2 == 2 ? 88 : 89));
        }
        return n2 == 0 ? 77 : (n2 == 1 ? 78 : (n2 == 2 ? 79 : 80));
    }

    public void start(int n) {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        AppEngine.DEBUG_MEMORY("SceneGame.starting");
        simData.newScene();
        if (this.m_arrowLeftAnimPlayer == null) {
            this.m_arrowLeftAnimPlayer = new AnimPlayer();
            this.m_arrowRightAnimPlayer = new AnimPlayer();
        }
        m_state = 0;
        this.m_stateTime = 0;
        this.m_afterFadeState = 0;
        this.m_nextScene = 0;
        this.m_nextSceneState = -1;
        this.m_suppressMenus = false;
        this.m_hudBottomHeight = AnimationManager.getAnimFrameHeight(597, 0) + AnimationManager.getAnimFrameHeight(596, 0);
        this.m_viewportX = 0;
        this.m_viewportY = 0;
        this.m_viewportWidth = appEngine.getWidth() - this.m_viewportX;
        this.m_viewportHeight = appEngine.getHeight() - 15 - this.m_viewportY - this.m_hudBottomHeight + 5;
        this.m_maxContextMenuItems = (short)(this.m_viewportHeight / 26);
        this.m_loadingThread = null;
        this.m_loadingThreadState = 0;
        this.initSimAssets();
        this.m_playedMapModeMoveMusic = false;
        this.m_tutorialMessageActive = false;
        this.m_normalTimeStep = 0;
        this.m_displayedMoney = simData.getMoney();
        this.m_postMessageBox = 0;
        this.m_curtainState = 0;
        this.m_tickerString1 = (short)-1;
        this.m_tickerString2 = (short)-1;
        this.m_cursorObject = null;
        this.m_cursorSelectFlags = 0;
        this.m_cursorSnapping = false;
        this.m_keyLeft = false;
        this.m_keyRight = false;
        this.m_keyDown = false;
        this.m_keyUp = false;
        this.m_cameraDestX = 0;
        this.m_cameraDestZ = 0;
        this.m_cameraVelX = 0;
        this.m_cameraVelZ = 0;
        this.m_cameraLastVelX = 0;
        this.m_cameraLastVelZ = 0;
        this.m_cameraAtDest = false;
        this.m_cameraFollowTarget = null;
        this.m_cameraFollowTargetReturn = false;
        this.m_objects = null;
        this.m_objectsSims = null;
        this.m_playerSim = null;
        if (this.m_objectStack == null) {
            this.m_objectStack = new Stack();
        }
        this.m_objectStack.removeAllElements();
        this.m_refreshObjects = true;
        this.m_refreshObjectsSims = true;
        this.m_contextMenuActive = false;
        this.m_contextMenuOnSubMenu = false;
        this.m_contextMenuBackCursor = 0;
        if (this.m_contextMenuItems == null) {
            this.m_contextMenuItems = new short[55];
            this.m_contextMenuActions = new short[55];
            this.m_contextMenuFullActions = new short[55];
        }
        this.m_contextMenuObject = null;
        this.m_pauseMenuActive = false;
        if (this.m_pauseMenuItems == null) {
            short[] sArray = new short[15];
            AppEngine.menuClear(sArray, 69, appEngine.getMaxMenuItemsPerScreen());
            AppEngine.menuAppendItem(sArray, 70);
            AppEngine.menuAppendItem(sArray, 63);
            AppEngine.menuAppendItem(sArray, 64);
            AppEngine.menuAppendItem(sArray, 73);
            AppEngine.menuAppendItem(sArray, 75);
            AppEngine.menuAppendItem(sArray, 77);
            AppEngine.menuAppendItem(sArray, 79);
            this.m_pauseMenuItems = sArray;
        }
        this.m_pauseMenuState = 0;
        this.m_shortcutMenuActive = false;
        this.m_shortcutByShortcutKey = false;
        if (this.m_shortcutMenuItems == null) {
            this.m_shortcutMenuItems = new short[20];
        }
        this.m_quickLinksActive = false;
        if (this.m_quickLinksMenu == null) {
            this.m_quickLinksMenu = new short[25];
        }
        this.m_buyModeState = 0;
        this.m_buyModeObject = null;
        this.m_infoScreenState = -1;
        this.m_infoLoadedNPC = 0;
        this.m_infoScreenSimSelectedIndex = 0;
        this.m_infoScreenRecipeSelected = 0;
        this.m_infoScreenItemSelectedIndex = 0;
        this.m_jobOfferCareer = 0;
        this.m_jobOfferLevel = 0;
        this.m_payIncome = 0;
        this.m_quitJobConfirmed = false;
        this.m_showBonusUnlocked = false;
        this.m_showNewDream = false;
        this.m_showGetItem = -1;
        this.m_showGetItemQty = 0;
        this.m_showGetItemTitle = 0;
        this.m_showGetItemMessage = 0;
        this.m_simAIEventTimer = 0;
        this.m_ambientEventTimer = 0;
        this.m_ambientSounds = null;
        this.m_simInactivityTimer = 0;
        this.initActionQueue();
        this.m_simData = simData;
        this.m_simWorld = appEngine.getSimWorld();
        this.m_displayedMoodLevel = simData.getMoodLevel();
        this.m_timeHit = 0;
        this.m_showFetchQuestEnd = false;
        this.m_eventState = 0;
        this.m_preEventCursorObject = null;
        this.m_miniGameState = 0;
        this.m_miniGameTargetObject = null;
        if (this.m_cookingLevelsF == null) {
            this.m_cookingLevelsF = new int[4];
            this.m_displayedCookingLevelsF = new int[4];
            this.m_cookingPotContents = new byte[4];
        }
        this.m_repairWirePaths = null;
        this.m_repairWireEnds = null;
        this.m_repairWireStartEndsPos = null;
        this.m_shoppingState = 0;
        if (this.m_timeAnimPlayer == null) {
            int n2;
            this.m_timeAnimPlayer = new AnimPlayer();
            this.m_buffRisingAnimPlayer = new AnimPlayer();
            this.m_buffDroppingAnimPlayer = new AnimPlayer();
            this.m_cursorAnimPlayer = new AnimPlayer();
            this.m_dreamAnimPlayers = new AnimPlayer[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.m_dreamAnimPlayers[n2] = new AnimPlayer();
            }
            this.m_playerGemAnimPlayer = new AnimPlayer();
            this.m_miniGameAnimPool = new AnimPlayer[24];
            this.m_miniGameAnimPoolPos = new int[24][3];
            for (n2 = 0; n2 < 24; ++n2) {
                this.m_miniGameAnimPool[n2] = new AnimPlayer();
            }
        }
        this.m_timeAnimPlayer.startAnim(681, 20);
        this.m_buffRisingAnimPlayer.startAnim(646, 20);
        this.m_buffDroppingAnimPlayer.startAnim(645, 20);
        this.m_cursorAnimPlayer.startAnim(577, 20);
        this.m_playerGemAnimPlayer.startAnim(593, 20);
        this.initUI();
        this.m_mapMode = 0;
        if (n == 99) {
            this.m_mapMode = (byte)2;
        } else if (n == 98) {
            this.m_mapMode = (byte)2;
            n = 5;
        } else if (n == 100) {
            this.m_mapMode = 1;
            n = 5;
        } else if (n == 97) {
            this.m_timeHit = 30;
            n = 5;
        } else if (n == -1) {
            n = 5;
        }
        this.m_initialState = n;
        this.stateTransition(1);
        AppEngine.DEBUG_MEMORY("SceneGame.started");
    }

    public void pause() {
        if (!(m_state != 5 && m_state != 16 || this.m_pauseMenuActive)) {
            if (this.m_miniGameType == 4) {
                SKIER_SPEED = 0;
                START_GAME = false;
                PRESS_OK = false;
                START_COUNTDOWN = false;
            }
            this.showPauseMenu();
        }
    }

    public void resume() {
    }

    public void end() {
        AppEngine.DEBUG_MEMORY("SceneGame.ending");
        this.m_simWorld.unload();
        AppEngine.DEBUG_MEMORY("SceneGame.end: unloaded SimWorld");
        int n = 2013688824;
        if (this.m_engine.getNextSceneId() == 2) {
            n &= 0xFFFFFFF7;
        }
        this.m_engine.unloadAllImages(n, -1);
        AppEngine.DEBUG_MEMORY("SceneGame.end: unloaded images");
        SDKSoundManager sDKSoundManager = this.m_engine.getSoundManager();
        sDKSoundManager.stopSounds();
        AppEngine.DEBUG_MEMORY("SceneGame.ended");
    }

    public void render(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        switch (m_state) {
            case 1: {
                appEngine.renderLoading(graphics);
                break;
            }
            case 5: {
                this.renderMain(graphics);
                this.renderSoftkeyBar(graphics);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.renderBuildMode(graphics);
                break;
            }
            case 8: {
                this.renderInfoScreen(graphics);
                break;
            }
            case 3: 
            case 9: {
                this.renderMain(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawGenericMessageBox(graphics);
                this.renderSoftkeyBar(graphics);
                break;
            }
            case 10: {
                this.renderJobOffer(graphics);
                break;
            }
            case 11: {
                this.renderPay(graphics);
                break;
            }
            case 12: {
                this.renderRaiseFailure(graphics);
                break;
            }
            case 13: {
                this.renderQuitJob(graphics);
                break;
            }
            case 14: {
                this.renderNewDream(graphics);
                break;
            }
            case 15: {
                this.renderShowGetItem(graphics);
                break;
            }
            case 16: {
                this.renderMiniGame(graphics);
                break;
            }
            case 17: {
                this.renderShopping(graphics);
                break;
            }
            case 18: {
                this.renderQuest(graphics);
                break;
            }
            case 19: {
                this.renderEvent(graphics);
            }
        }
    }

    private void renderSoftkeyBar(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        appEngine.renderSoftkeyBar(graphics);
        int[] nArray = this.m_tempInt10;
        int n = appEngine.getWidth() >> 1;
        int n2 = appEngine.getHeight();
        AnimationManager.drawAnimFrame(graphics, 644, 0, n, n2);
        AnimationManager.getAnimFrameFirePoint(nArray, 644, 0, 0);
        int n3 = n + nArray[0];
        int n4 = n2 + nArray[1];
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendMoneyToBuffer(this.m_displayedMoney);
        appEngine.drawString(sDKString, 2, n3, n4, 24);
    }

    private void renderMain(Graphics graphics) {
        this.m_simWorld.renderWorld(graphics);
        if (!this.m_quickLinksActive) {
            this.renderHUDTop(graphics);
        }
        if (this.isCurtainActive()) {
            this.renderCurtain(graphics);
        }
        if (this.m_pauseMenuActive) {
            this.renderCursor(graphics);
            this.renderContextRelationships(graphics);
            this.renderHUDBottom(graphics);
            this.renderHUDMoodSim(graphics);
            this.renderPauseMenu(graphics);
        } else if (!this.m_suppressMenus && this.m_contextMenuActive) {
            this.renderContextRelationships(graphics);
            this.renderHUDBottom(graphics);
            this.renderHUDMoodSim(graphics);
            this.renderContextMenu(graphics);
        } else if (this.m_tutorialMessageActive) {
            this.renderContextRelationships(graphics);
            this.renderHUDBottom(graphics);
            this.renderHUDMoodSim(graphics);
            this.m_engine.renderBackgroundDim(graphics);
            this.drawTextScreen(graphics);
        } else {
            if (m_state != 16) {
                this.renderCursor(graphics);
            }
            this.renderContextRelationships(graphics);
            this.renderHUDBottom(graphics);
            this.renderHUDMoodSim(graphics);
            if (!this.m_suppressMenus && this.m_shortcutMenuActive) {
                this.renderShortcutMenu(graphics);
            }
        }
    }

    private final void DEBUG_CHECKKEYS_SOUND(String string) {
    }

    public boolean checkKeys(int n, int n2, int n3, int n4) {
        if (super.checkKeys(n, n2, n3, n4)) {
            SDKSoundManager sDKSoundManager = this.m_engine.getSoundManager();
            sDKSoundManager.setCurrentLoop(1);
            if ((n3 & 0x1020) != 0) {
                if (this.m_pauseMenuActive || this.m_contextMenuActive || this.m_shortcutMenuActive) {
                    this.DEBUG_CHECKKEYS_SOUND("SOUNDEVENT_UI_SELECT");
                    sDKSoundManager.playSound(3);
                }
            } else if ((n2 & 0x7D1B) != 0) {
                this.DEBUG_CHECKKEYS_SOUND("SOUNDEVENT_UI_SELECT");
                sDKSoundManager.playSound(3);
            } else if ((n2 & 0x82E4) != 0 || (n3 & 0x80000) != 0) {
                if (this.m_shortcutMenuActive || !this.m_contextMenuActive || this.m_contextMenuOnSubMenu) {
                    this.DEBUG_CHECKKEYS_SOUND("SOUNDEVENT_UI_BACK");
                    sDKSoundManager.playSound(2);
                }
            } else if ((n3 & 0x6104) != 0 && this.getListCursor() != -1) {
                this.DEBUG_CHECKKEYS_SOUND("SOUNDEVENT_UI_NAVIGATE");
                sDKSoundManager.playSound(0);
            } else if ((n3 & 0x18050) != 0) {
                this.DEBUG_CHECKKEYS_SOUND("SOUNDEVENT_UI_TOGGLE");
                sDKSoundManager.playSound(1);
            }
            return true;
        }
        return false;
    }

    public void processKeys(int n, int n2) {
        if (m_state == 1 || this.isCurtainActive() && this.m_curtainState != 2 && !this.m_pauseMenuActive) {
            return;
        }
        AppEngine appEngine = this.m_engine;
        if (appEngine.fadeColorReached() && this.m_afterFadeState != 0) {
            this.stateTransition(this.m_afterFadeState);
            appEngine.startFadeIn();
            this.m_afterFadeState = 0;
            return;
        }
        if (appEngine.isFading()) {
            return;
        }
        if (this.m_pauseMenuActive) {
            this.processKeysPauseMenu(n, n2);
        } else if (!this.m_suppressMenus && this.m_contextMenuActive) {
            this.processKeysContextMenu(n, n2);
        } else if (!this.m_suppressMenus && this.m_shortcutMenuActive) {
            this.processKeysShortcutMenu(n, n2);
        } else if (this.m_tutorialMessageActive) {
            this.processKeysTutorialMessage(n, n2);
        } else if (this.m_quickLinksActive) {
            this.processKeysQuickLinks(n, n2);
        } else {
            switch (m_state) {
                case 3: {
                    this.processKeysSavePrompt(n, n2);
                    break;
                }
                case 5: {
                    this.processKeysMain(n, n2);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    this.processKeysBuildMode(n, n2);
                    break;
                }
                case 8: {
                    this.processKeysInfoScreen(n, n2);
                    break;
                }
                case 9: {
                    this.processKeysMessageBox(n, n2);
                    break;
                }
                case 10: {
                    this.processKeysJobOffer(n, n2);
                    break;
                }
                case 11: {
                    this.processKeysPay(n, n2);
                    break;
                }
                case 12: {
                    this.processKeysRaiseFailure(n, n2);
                    break;
                }
                case 13: {
                    this.processKeysQuitJob(n, n2);
                    break;
                }
                case 14: {
                    this.processKeysNewDream(n, n2);
                    break;
                }
                case 15: {
                    this.processKeysShowGetItem(n, n2);
                    break;
                }
                case 16: {
                    this.processKeysMiniGame(n, n2);
                    break;
                }
                case 17: {
                    this.processKeysShopping(n, n2);
                    break;
                }
                case 18: {
                    this.processKeysQuest(n, n2);
                    break;
                }
                case 19: {
                    this.processKeysEvent(n, n2);
                }
            }
        }
    }

    private void processKeysSavePrompt(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 256)) {
            this.m_engine.saveRMSAppSettings();
            this.m_engine.saveRMSGameData();
            this.fadeStateTransition(2);
        } else if (this.checkKeys(n, n2, 0, 512)) {
            this.fadeStateTransition(2);
        }
    }

    private void processKeysMain(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 5)) {
            this.showPauseMenu();
            return;
        }
        if (this.checkKeys(n, n2, 0, 1024)) {
            this.showShortcutMenu();
            return;
        }
        this.processKeysCursor(n, n2);
        if (this.checkKeys(n, n2, 4128, 16)) {
            this.processKeysFire();
        }
        if (this.checkKeys(n, n2, 2048, 0)) {
            this.stateTransition(8);
            this.stateTransitionInfoScreen(4);
            this.m_shortcutByShortcutKey = true;
        } else if (this.checkKeys(n, n2, 1024, 0)) {
            this.stateTransition(8);
            this.stateTransitionInfoScreen(3);
            this.m_shortcutByShortcutKey = true;
        }
    }

    public void update(int n) {
        this.m_stateTime += n;
        if (m_state == 1) {
            this.updateLoading(n);
            return;
        }
        this.updateHUD(n);
        this.m_engine.updateScrollers(n);
        switch (m_state) {
            case 5: {
                this.updateMain(n);
                break;
            }
            case 6: {
                this.updateLoadSim();
                if (this.m_loadSimCount != 0) break;
                this.stateTransition(5);
                break;
            }
            case 7: {
                this.updateBuildMode(n);
                break;
            }
            case 8: {
                this.updateInfoScreen(n);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                this.updateMiniGame(n);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                this.updateEvent(n);
            }
        }
    }

    private void stateTransition(int n) {
        AppEngine appEngine = this.m_engine;
        m_state = n;
        this.m_stateTime = 0;
        this.m_suppressMenus = true;
        appEngine.resetScrollers();
        this.stopCursor();
        switch (n) {
            case 1: {
                this.m_loadingState = 0;
                this.m_contextMenuActive = false;
                this.m_pauseMenuActive = false;
                break;
            }
            case 2: {
                appEngine.changeScene(this.m_nextScene, this.m_nextSceneState);
                break;
            }
            case 3: {
                this.hideMenus();
                this.prepareGenericMessageBox(87, 72);
                break;
            }
            case 4: {
                appEngine.endGame();
                break;
            }
            case 5: {
                this.setCursorSelectFlags(1);
                this.m_suppressMenus = false;
                break;
            }
            case 6: {
                this.loadNewSimBegin();
                this.prepareGenericMessageBox(35, 36);
                break;
            }
            case 7: {
                this.m_suppressMenus = false;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                this.m_payIncome = this.m_simData.careerDayWorked();
                this.prepareGenericMessageBox(711, 710);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.prepareGenericMessageBox(this.m_showGetItemMessage, this.m_showGetItemTitle);
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
        }
        this.setupSoftkeys();
    }

    private void fadeStateTransition(int n) {
        this.m_afterFadeState = n;
        if (!this.m_engine.isFadingOut()) {
            this.m_engine.startFadeOut();
        }
        this.stopCursor();
    }

    private void changeSceneWithSavePrompt(int n, int n2) {
        if (this.m_engine.getSavePromptsEnabled()) {
            this.m_nextScene = n;
            this.m_nextSceneState = n2;
            this.stateTransition(3);
        } else {
            this.changeSceneWithFade(n, n2);
        }
    }

    private void changeSceneWithFade(int n, int n2) {
        this.m_nextScene = n;
        this.m_nextSceneState = n2;
        this.fadeStateTransition(2);
    }

    private void changeScene(int n, int n2) {
        this.m_nextScene = n;
        this.m_nextSceneState = n2;
        this.stateTransition(2);
    }

    private void setupSoftkeys() {
        int n = 0;
        int n2 = 0;
        if (this.m_pauseMenuActive) {
            if (this.m_pauseMenuState == 1 || this.m_pauseMenuState == 2 || this.m_pauseMenuState == 3 || this.m_pauseMenuState == 4) {
                n2 = 512;
                n = 256;
            } else {
                n2 = 4;
                n = 16;
            }
        } else if (!this.m_suppressMenus && this.m_contextMenuActive) {
            n2 = 4;
            n = 16;
        } else if (!this.m_suppressMenus && this.m_shortcutMenuActive) {
            n2 = 4;
            n = 16;
        } else if (this.m_tutorialMessageActive) {
            n = 8;
        } else if (this.m_quickLinksActive) {
            n2 = 4;
            n = 16;
        } else {
            block0 : switch (m_state) {
                case 3: {
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 5: {
                    n2 = 1;
                    n = 1024;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    switch (this.m_buyModeState) {
                        case 1: {
                            n2 = 4;
                            n = 16;
                            break;
                        }
                        case 2: {
                            n2 = 4;
                            n = 16;
                            break;
                        }
                        case 3: 
                        case 7: 
                        case 8: {
                            n = 8;
                            break;
                        }
                        case 4: 
                        case 11: {
                            n2 = 4;
                            n = 2048;
                            break;
                        }
                        case 5: 
                        case 9: {
                            n2 = 512;
                            n = 256;
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 10: {
                            if (this.m_simWorld.getHouseUpgradeCost() <= this.m_simData.getMoney()) {
                                n2 = 512;
                                n = 256;
                                break;
                            }
                            n = 8;
                        }
                    }
                    break;
                }
                case 8: {
                    int n3;
                    switch (this.m_infoScreenState) {
                        case 0: {
                            n2 = 4;
                            n = this.m_simData.getRelationshipNthCount() > 0 ? 16 : 0;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 9: 
                        case 10: {
                            n2 = 4;
                            break;
                        }
                        case 3: {
                            n2 = 4;
                            if (this.m_simData.getDream() == -1 || !this.m_simData.isDreamToPromisePossible()) break;
                            n = 8;
                            break;
                        }
                        case 6: {
                            n = 0;
                            n2 = 4;
                            n3 = this.getInfoItem();
                            if (n3 == -1 || (this.m_simWorld.getItemFlags(n3) & 0x800) == 0) break;
                            n = 16;
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    n2 = 0;
                    n = 8;
                    break;
                }
                case 10: {
                    if (this.m_jobOfferCareer != -1) {
                        n2 = 512;
                        n = 256;
                        break;
                    }
                    n = 8;
                    break;
                }
                case 11: {
                    n = 8;
                    break;
                }
                case 12: {
                    n = 8;
                    break;
                }
                case 13: {
                    if (this.m_quitJobConfirmed) {
                        n = 8;
                        break;
                    }
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 14: {
                    n2 = 128;
                    n = 8;
                    break;
                }
                case 15: {
                    n = 8;
                    break;
                }
                case 16: {
                    n2 = 1;
                    n = 64;
                    break;
                }
                case 17: {
                    int n3 = this.m_shoppingState;
                    if (n3 != 0) break;
                    n2 = 4;
                    if (this.m_shoppingTradeAmount > 0) {
                        n = 4096;
                        break;
                    }
                    if (this.m_shoppingTradeAmount >= 0) break;
                    n = 8192;
                    break;
                }
                case 18: {
                    switch (this.m_questState) {
                        case 0: {
                            n2 = 512;
                            n = 256;
                            break;
                        }
                        case 1: {
                            n = 8;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n = 8;
                        }
                    }
                    break;
                }
                case 19: {
                    switch (this.m_eventState) {
                        default: {
                            break block0;
                        }
                        case 3: 
                    }
                    n = 8;
                }
            }
        }
        AppEngine appEngine = this.m_engine;
        appEngine.clearCommandKeys();
        appEngine.clearKeysPressedDown();
        appEngine.setSoftKeys(n2, n);
    }

    private void hideMenus() {
        if (this.m_contextMenuActive) {
            this.hideContextMenu();
        }
        if (this.m_shortcutMenuActive) {
            this.hideShortcutMenu();
        }
        if (this.m_quickLinksActive) {
            this.hideQuickLinks();
        }
    }

    public void kickPlayer(int n, int n2) {
        this.showMessageBox(n, n2, 1);
    }

    public void killPlayer(int n) {
        this.m_engine.dynamicString(-11, n, this.m_engine.getSimName());
        this.triggerEvent(0, -11, -1);
    }

    public void passOut() {
        this.m_playerSim.beginSimAction(6, null);
        this.startCurtainIn();
    }

    public void goHome() {
        this.m_engine.setNextHouseId(0);
        this.changeSceneWithSavePrompt(2, 97);
    }

    public void gotoWork() {
        this.changeSceneWithSavePrompt(2, 99);
    }

    public void gotoMap() {
        this.changeSceneWithSavePrompt(2, 98);
    }

    public void gotoMapForObject(MapObject mapObject) {
        int n = mapObject.getType();
        if (n == 117) {
            this.m_engine.setupEncounter(null);
            this.m_engine.setNextZoomMapId(41);
            this.changeSceneWithSavePrompt(2, 100);
        } else if (n == 1) {
            this.m_engine.setupEncounter((MapObjectSim)mapObject);
            this.m_engine.setNextZoomMapId(43);
            this.changeSceneWithSavePrompt(2, 100);
        } else {
            int n2 = this.m_simWorld.getHouseForObject(n);
            this.m_engine.setNextHouseId(n2);
            this.changeSceneWithSavePrompt(2, -1);
        }
    }

    public void showTutorialMessage(byte by) {
        int n;
        int n2;
        AppEngine appEngine = this.m_engine;
        if (appEngine.getRMSHasSeenTutorial(by)) {
            return;
        }
        appEngine.setRMSHasSeenTutorial(by);
        if (!appEngine.getTutorialsEnabled()) {
            return;
        }
        isWinterToShow = by == 0;
        switch (by) {
            default: {
                AppEngine.ASSERT(false, "Invalid message ID");
            }
            case 0: {
                n2 = 93;
                n = 94;
                break;
            }
            case 16: {
                n2 = 95;
                n = 96;
                break;
            }
            case 1: {
                n2 = 97;
                n = 98;
                break;
            }
            case 2: {
                n2 = 99;
                n = 100;
                break;
            }
            case 3: {
                n2 = 101;
                n = 102;
                break;
            }
            case 17: {
                n2 = 112;
                n = 113;
                break;
            }
            case 4: {
                n2 = 103;
                n = 104;
                break;
            }
            case 5: {
                n2 = 105;
                n = 106;
                break;
            }
            case 6: {
                n2 = 507;
                n = 107;
                break;
            }
            case 8: {
                n2 = 514;
                n = 108;
                break;
            }
            case 9: {
                n2 = 500;
                n = 109;
                break;
            }
            case 7: {
                n2 = 521;
                n = 111;
                break;
            }
            case 10: {
                n2 = 407;
                n = 114;
                break;
            }
            case 11: {
                n2 = 410;
                n = 115;
                break;
            }
            case 12: {
                n2 = 411;
                n = 116;
                break;
            }
            case 13: {
                n2 = 416;
                n = 117;
                break;
            }
            case 14: {
                n2 = 415;
                n = 118;
                break;
            }
            case 15: {
                n2 = 417;
                n = 119;
            }
        }
        this.hideMenus();
        this.prepareTextScreen(n, n2);
        this.m_tutorialMessageActive = true;
        this.setupSoftkeys();
    }

    private void processKeysTutorialMessage(int n, int n2) {
        this.processKeysTextScreen(n);
        if (this.checkKeys(n, n2, 4128, 8)) {
            this.hideTutorialMessage();
        }
    }

    private void hideTutorialMessage() {
        this.m_tutorialMessageActive = false;
        if (isWinterToShow) {
            this.showTutorialMessage((byte)16);
        } else {
            this.setupSoftkeys();
        }
    }

    public int getNormalTimeStep() {
        return this.m_normalTimeStep;
    }

    private boolean gamePaused() {
        return this.m_pauseMenuActive || this.m_shortcutMenuActive || this.m_tutorialMessageActive || m_state != 5;
    }

    private void updateMain(int n) {
        if (this.gamePaused()) {
            return;
        }
        SimData simData = this.m_simData;
        if (this.m_loadSimCount > 0) {
            this.stateTransition(6);
            return;
        }
        if (this.isCurtainActive()) {
            this.updateCurtain(n);
        }
        if (!this.m_tutorialMessageActive && !simData.isDelayed() && this.checkTriggers()) {
            return;
        }
        this.updateTicker(n);
        this.m_normalTimeStep = n;
        int n2 = simData.getFastforward() ? n << 2 : n;
        this.updateObjects(n2);
        this.updateCursor(n);
        this.updateCamera(n);
        this.updateLeftRightArrows(n);
        if (!this.isCurtainActive() && !this.m_engine.isFading()) {
            this.updateSimData(n);
            if (this.m_mapMode == 2) {
                this.updateEventsMapMode(n);
            } else if (this.m_mapMode == 0) {
                this.updateEventsHouse(n);
            } else {
                this.updateEventsZoomMode(n);
            }
            if (this.m_ambientSounds != null) {
                this.updateAmbientSounds(n, this.m_ambientSoundRate, this.m_ambientSounds);
            }
            this.updateSimAction();
        }
    }

    private boolean checkTriggers() {
        SimData simData = this.m_simData;
        if (this.m_showFetchQuestEnd) {
            this.m_showFetchQuestEnd = false;
            this.stateTransition(18);
            this.stateTransitionQuest(3);
            return true;
        }
        if (this.m_showGetItem != -1) {
            this.stateTransition(15);
            return true;
        }
        if (simData.showPersonaComplete()) {
            this.triggerEvent(8, -1, -1);
            return true;
        }
        if (this.m_showBonusUnlocked) {
            this.m_showBonusUnlocked = false;
            this.m_engine.unlockBonus();
            this.showMessageBox(793, 754);
            return true;
        }
        if (simData.isFurnitureStageChange()) {
            this.showMessageBox(794, 795);
            return true;
        }
        int n = simData.getHouseUpgradeMessage();
        if (n != -1) {
            this.showMessageBox(n, 778);
            return true;
        }
        if (this.m_showNewDream) {
            this.m_showNewDream = false;
            if (simData.getDream() != -1) {
                this.showNewDreamMessage();
                return true;
            }
        }
        return false;
    }

    private void updateHUD(int n) {
        this.m_timeAnimPlayer.updateAnim(n);
        int n2 = this.m_simData.getMoney();
        this.m_displayedMoney = this.interpolateValue(this.m_displayedMoney, n2, n, 9);
        if (!this.gamePaused()) {
            this.m_buffDroppingAnimPlayer.updateAnim(n);
            this.m_buffRisingAnimPlayer.updateAnim(n);
            this.m_playerGemAnimPlayer.updateAnim(n);
        }
        if (m_state == 5 && !this.m_shortcutMenuActive && !this.m_pauseMenuActive) {
            SimData simData = this.m_simData;
            for (int i = 0; i < this.m_dreamAnimPlayers.length; ++i) {
                int n3 = simData.getPromise(i);
                AnimPlayer animPlayer = this.m_dreamAnimPlayers[i];
                animPlayer.updateAnim(n);
                if (animPlayer.isAnimating() || animPlayer.getAnimID() != 599 && n3 == -1) continue;
                animPlayer.startAnim(598, 20);
            }
        }
    }

    private void renderHUDTop(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        int[] nArray = this.m_tempInt10;
        int n10 = this.m_viewportX + this.m_viewportWidth;
        int n11 = this.m_viewportY;
        if (m_state == 7) {
            n9 = AnimationManager.getAnimFrameWidth(605, 0);
            n8 = AnimationManager.getAnimFrameHeight(605, 0);
            n7 = appEngine.getWidth() - (n9 + 9);
            n6 = n8 + 3 - 1;
            this.drawDropDownTitle(graphics, 3, n7, n6, 121);
        } else {
            n5 = AnimationManager.getAnimFrameWidth(4, 0);
            n9 = AnimationManager.getAnimFrameWidth(5, 0);
            n4 = this.m_viewportX + 5 + (n9 >> 1);
            n3 = n11 + 3 + (n9 >> 1);
            n2 = n4;
            n = this.m_actionQueueSize;
            int[] nArray2 = this.m_actionQueueActions;
            MapObject[] mapObjectArray = this.m_actionQueueArg1s;
            for (int i = 0; i < n; ++i) {
                int n12 = nArray2[i];
                MapObject mapObject = mapObjectArray[i];
                int n13 = 5;
                int n14 = n9;
                if (i == 0) {
                    n13 = 4;
                    n14 = n5;
                }
                int n15 = 203;
                if (n12 == 108) {
                    n15 = 3;
                } else if (mapObject != null) {
                    n15 = mapObject.getFlag(16384) && !this.isMapMode() ? 6 : this.m_simWorld.getObjectActionIcon(mapObject.getType());
                }
                AnimationManager.drawAnimFrame(graphics, n13, 0, n2, n3);
                AnimationManager.drawAnimFrame(graphics, n15, 0, n2, n3);
                n2 += n14 + 2;
            }
        }
        n5 = simData.getGameTime();
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendTimeToBuffer24Hour(n5);
        AnimationManager.drawAnimFrame(graphics, 605, 0, n10, n11);
        AnimationManager.getAnimFrameFirePoint(nArray, 605, 0, 0);
        n8 = n10 + nArray[0];
        n7 = n11 + nArray[1];
        AnimationManager.getAnimFrameFirePoint(nArray, 605, 0, 1);
        n6 = n10 + nArray[0];
        n4 = n11 + nArray[1];
        appEngine.drawString(sDKString, 2, n8 + 1, n7 + 1, 24);
        n3 = SimData.DAY_STRINGS[simData.getGameDay()];
        appEngine.drawString(n3, 2, n6 + 1, n4 + 1, 20);
        if (this.gamePaused()) {
            n2 = 2;
            n = 682;
        } else if (simData.getFastforward()) {
            n2 = 4;
            n = 680;
        } else {
            n2 = 3;
            n = 681;
        }
        this.m_timeAnimPlayer.startAnim(n, 4);
        AnimationManager.getAnimFrameFirePoint(nArray, 605, 0, n2);
        AnimationManager.drawAnim(graphics, this.m_timeAnimPlayer, n10 + nArray[0], n11 + nArray[1]);
    }

    private void renderHUDBottom(Graphics graphics) {
        short s;
        int n;
        int n2;
        int n3;
        if (this.m_quickLinksActive) {
            this.renderQuickLinks(graphics);
        }
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        int[] nArray = this.m_tempInt10;
        int n4 = appEngine.getHalfWidth();
        int n5 = appEngine.getHeight() - 15;
        if (m_state != 16 && m_state != 7 && this.getSimContext() == -1 && !this.m_quickLinksActive) {
            this.renderBuffs(graphics);
        }
        AnimationManager.drawAnimFrame(graphics, 597, 0, n4, n5);
        if (this.m_tickerString1 != -1) {
            this.renderTicker(graphics);
        }
        AnimationManager.getAnimFrameCollisionBox(nArray, 597, 0, 0);
        int n6 = n4 + nArray[0];
        int n7 = n5 + nArray[1];
        for (n3 = 0; n3 < 4; ++n3) {
            n2 = n6 + n3 * 16;
            AnimPlayer animPlayer = this.m_dreamAnimPlayers[n3];
            if (!animPlayer.isAnimating()) continue;
            AnimationManager.drawAnim(graphics, animPlayer, n2, n7);
        }
        AnimationManager.getAnimFrameCollisionBox(nArray, 597, 0, 1);
        n6 = n4 + nArray[0] + -8;
        n7 = n5 + nArray[1] + (nArray[3] >> 1);
        n3 = nArray[2];
        n2 = n6 + n3;
        int n8 = simData.getMotiveCount();
        for (n = 0; n < n8 && n2 > n6; ++n) {
            if (simData.getMotiveLevel(n) >= 0x230000) continue;
            s = simData.getMotiveLowAnim(n);
            AnimationManager.drawAnimFrame(graphics, s, 0, n2, n7);
            n2 -= 16;
        }
        for (n = 0; n < n8 && n2 > n6; ++n) {
            if (simData.getMotiveLevel(n) <= 0x410000) continue;
            s = simData.getMotiveHighAnim(n);
            AnimationManager.drawAnimFrame(graphics, s, 0, n2, n7);
            n2 -= 16;
        }
    }

    private void renderHUDMoodSim(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getWidth() >> 1;
        int n2 = appEngine.getHeight() - 15;
        AnimationManager.drawAnimFrame(graphics, 596, 0, n, n2);
        boolean bl = this.m_displayedMoodLevel < 0;
        int n3 = Math.abs(this.m_displayedMoodLevel >> 16);
        int n4 = 100;
        int n5 = AnimationManager.getAnimFrameWidth(594, 0);
        int n6 = n5 * n3 / n4;
        int n7 = n + (bl ? -n6 : 0);
        int n8 = graphics.getClipX();
        int n9 = graphics.getClipY();
        int n10 = graphics.getClipWidth();
        int n11 = graphics.getClipHeight();
        graphics.setClip(n7, n9, n6, n11);
        int n12 = bl ? 595 : 594;
        AnimationManager.drawAnimFrame(graphics, n12, 0, n, n2);
        graphics.setClip(n8, n9, n10, n11);
        this.drawHUDSim(graphics, n, n2);
    }

    public void showMessageBox(int n, int n2) {
        this.showMessageBox(n, n2, 0);
    }

    public void showMessageBox(int n, int n2, int n3) {
        this.hideQuickLinks();
        this.m_postMessageBox = n3;
        this.prepareGenericMessageBox(n, n2);
        this.stateTransition(9);
    }

    private void processKeysMessageBox(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 12)) {
            switch (this.m_postMessageBox) {
                case 0: {
                    this.stateTransition(5);
                    break;
                }
                case 1: {
                    this.gotoMap();
                    break;
                }
                case 2: {
                    if (this.getPlayerSim().getSimAction() == 165) {
                        this.getPlayerSim().interrupt();
                    }
                    this.stateTransition(5);
                    break;
                }
                case 3: {
                    this.triggerEvent(6, -1, -1);
                    break;
                }
                case 4: {
                    this.triggerEvent(7, -1, -1);
                }
            }
        }
    }

    public boolean isCurtainActive() {
        return this.m_curtainState != 0;
    }

    public void startCurtainIn() {
        this.hideMenus();
        this.m_curtainPlayerAction = this.m_playerSim.getSimAction();
        this.stateTransitionCurtain(1);
    }

    public void startCurtainOut() {
        this.hideMenus();
        this.stateTransitionCurtain(2);
    }

    private void stateTransitionCurtain(int n) {
        this.m_curtainState = n;
        switch (n) {
            case 0: {
                this.m_curtainTime = 0;
                break;
            }
            case 1: {
                this.m_simData.delayAlerts();
                this.m_curtainTime = 0;
                break;
            }
            case 2: {
                this.m_curtainTime = 1000;
                break;
            }
            case 3: {
                this.m_curtainTime = 1000;
            }
        }
    }

    private void updateCurtain(int n) {
        if (!this.m_cameraAtDest) {
            return;
        }
        switch (this.m_curtainState) {
            case 0: {
                break;
            }
            case 1: {
                this.m_simData.delayAlerts();
                if (this.m_curtainTime == 1000) {
                    this.stateTransitionCurtain(2);
                    this.doCurtainInUpdate();
                    break;
                }
                this.m_curtainTime = Math.min(this.m_curtainTime + n, 1000);
                break;
            }
            case 2: {
                this.m_simData.delayAlerts();
                this.m_curtainTime += n;
                if (this.m_curtainTime < 1500) break;
                this.stateTransitionCurtain(3);
                break;
            }
            case 3: {
                this.m_simData.delayAlerts();
                if (this.m_curtainTime == 0) {
                    this.stateTransitionCurtain(0);
                    this.doCurtainOutUpdate();
                    break;
                }
                this.m_curtainTime = Math.max(this.m_curtainTime - n, 0);
            }
        }
    }

    private void doCurtainInUpdate() {
        switch (this.m_curtainPlayerAction) {
            case 165: {
                AppEngine.ASSERT(this.m_playerSim.isWorking(), "sim not working!");
                this.m_simData.updateSkipWorking();
                this.cancelWorkMessages();
                this.m_playerSim.endSimPhase();
                break;
            }
            case 123: {
                this.m_simData.updateSkipSleeping(this.getPlayerSim().getFeedbackTime() - 15);
                break;
            }
            case 141: {
                MapObject[] mapObjectArray = this.getObjects();
                for (int i = 0; i < mapObjectArray.length; ++i) {
                    mapObjectArray[i].destroy();
                }
                this.m_simWorld.prepareWorldHouse(0);
                break;
            }
            case 6: {
                if (this.isHouseMode() && this.m_simWorld.getHouseId() == 0) {
                    this.putSimInBed(this.m_playerSim);
                    this.m_timeHit = 120;
                    this.m_simData.delayAlerts();
                    MapObjectSim[] mapObjectSimArray = this.getSimObjects();
                    for (int i = 0; i < mapObjectSimArray.length; ++i) {
                        MapObjectSim mapObjectSim = mapObjectSimArray[i];
                        if (mapObjectSim == this.m_playerSim) continue;
                        if (this.m_simData.getSimHome(mapObjectSim.getId()) != 0) {
                            mapObjectSim.destroy();
                            continue;
                        }
                        mapObjectSim.beginSimAction(0, null);
                    }
                    break;
                }
                this.m_engine.setNextHouseId(0);
                this.changeScene(2, 96);
            }
        }
    }

    private void doCurtainOutUpdate() {
        switch (this.m_curtainPlayerAction) {
            case 165: {
                this.finishWork();
                break;
            }
            case 141: {
                this.triggerEvent(5, -1, -1);
                break;
            }
            default: {
                this.m_simData.delayAlerts();
            }
        }
    }

    private void renderCurtain(Graphics graphics) {
        if (!this.m_cameraAtDest) {
            return;
        }
        int n = Math.min(this.m_curtainTime, 1000);
        int n2 = (n * this.m_viewportHeight / 1000 >> 1) + 1;
        graphics.setColor(0);
        graphics.fillRect(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, n2);
        graphics.fillRect(this.m_viewportX, this.m_viewportY + this.m_viewportHeight - n2, this.m_viewportWidth, n2);
    }

    public void showTickerMessage(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        this.m_tickerString1 = (short)n;
        this.m_tickerString2 = (short)n2;
        this.m_tickerTimer = 0;
        this.m_tickerOffsetF = 0;
        this.m_tickerLengthF = (appEngine.getStringWidth(n, 1) << 16) + 327680;
        if (n2 != -1) {
            this.m_tickerLengthF += 5 + appEngine.getStringWidth(n2, 1) << 16;
        }
    }

    public void cancelTickerMessage(int n) {
        if (this.m_tickerString1 == n) {
            this.m_tickerString1 = (short)-1;
        }
    }

    public boolean isShowingTickerMessage() {
        return this.m_tickerString1 != -1;
    }

    private void updateTicker(int n) {
        if (this.m_tickerString1 != -1) {
            this.m_tickerTimer += n;
            if (this.m_tickerTimer > 2000) {
                if (this.m_tickerOffsetF > this.m_tickerLengthF) {
                    this.m_tickerString1 = (short)-1;
                    this.m_tickerString2 = (short)-1;
                } else {
                    this.m_tickerOffsetF += n * 3276;
                }
            }
        }
    }

    private void renderTicker(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = AnimationManager.getAnimFrameHeight(679, 0);
        int n2 = appEngine.getHeight() - 15 - this.m_hudBottomHeight - n;
        int[] nArray = this.m_tempInt10;
        AnimationManager.getAnimFrameFirePoint(nArray, 679, 0, 0);
        int n3 = 0 + nArray[0];
        int n4 = n2 + nArray[1];
        AnimationManager.drawAnimFrame(graphics, 679, 0, 0, n2);
        if (this.m_tickerTimer < 1000 && (this.m_tickerTimer & 0x1FF) > 255) {
            return;
        }
        int n5 = n3 - (this.m_tickerOffsetF >> 16);
        appEngine.drawString(this.m_tickerString1, 1, n5, n4, 20);
        if (this.m_tickerString2 != -1) {
            int n6 = appEngine.getStringWidth(this.m_tickerString1, 1);
            int n7 = n5 + n6 + 5;
            appEngine.drawString(this.m_tickerString2, 1, n7, n4, 20);
        }
    }

    private void stopCursor() {
        this.m_keyLeft = false;
        this.m_keyRight = false;
        this.m_keyDown = false;
        this.m_keyUp = false;
        this.m_engine.clearKeysPressedDown();
        this.m_engine.clearCommandKeys();
    }

    private void processKeysCursor(int n, int n2) {
        this.processKeysCursorDirs(n);
        if ((n & 0x1E3DE) != 0) {
            this.clearCameraFollow();
        }
    }

    private void processKeysCursorDirs(int n) {
        this.m_keyLeft = (n & 0x8092) != 0;
        this.m_keyRight = (n & 0x10248) != 0;
        this.m_keyUp = (n & 0x200E) != 0;
        this.m_keyDown = (n & 0x4380) != 0;
    }

    private void processKeysFire() {
        int n;
        SimWorld simWorld;
        int n2;
        this.clearCameraFollow();
        MapObject mapObject = this.m_cursorObject;
        if (mapObject != null && this.m_cursorAtDest) {
            if (mapObject == this.m_playerSim) {
                this.showQuickLinks();
            } else {
                this.showContextMenu(mapObject);
            }
        } else if (m_state == 5 && this.m_cursorAtDest && this.m_simWorld.isWorldPointWalkable(n2 = (simWorld = this.m_simWorld).coordScreenToWorldX(this.m_cursorPosX, this.m_cursorPosZ), n = simWorld.coordScreenToWorldZ(this.m_cursorPosX, this.m_cursorPosZ))) {
            this.processSimAction(108, null, n2, n);
        }
    }

    private void renderCursor(Graphics graphics) {
        if (this.m_buyModeState == 6 || this.m_eventState == 1) {
            return;
        }
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = this.m_simWorld;
        int n = this.m_cursorPosX;
        int n2 = this.m_cursorPosZ;
        if (this.m_quickLinksActive && this.m_cursorObject != null) {
            n = this.m_cursorDestX;
            n2 = this.m_cursorDestZ;
        }
        n = (n >> 16) + simWorld.getCameraPixelX();
        n2 = (n2 >> 16) + simWorld.getCameraPixelY();
        if (this.m_quickLinksActive) {
            this.renderQuickLinksMarker(graphics, n, n2);
        } else {
            int n3;
            AnimationManager.drawAnim(graphics, this.m_cursorAnimPlayer, n, n2);
            if (this.m_cursorAtDest && this.m_cursorObject != null && this.m_cursorAtDestTime < 1000 && (n3 = this.m_cursorObject.getTooltipStringId()) != 27) {
                int n4 = appEngine.getStringWidth(n3, 1);
                int n5 = appEngine.getLineHeight(1) - 2;
                int n6 = 3 + n4 + 3;
                int n7 = 2 + n5 + 2;
                int n8 = Math.max(0, n + -5 - n6);
                int n9 = n2 + -5 - n7;
                AnimationManager.setColor(graphics, 77);
                graphics.drawRect(n8, n9, n6, n7);
                AnimationManager.setColor(graphics, 76);
                graphics.fillRect(n8 + 1, n9 + 1, n6 - 1, n7 - 1);
                appEngine.drawString(n3, 1, n8 + 3 + (n4 >> 1), n9 + 2, 17);
            }
        }
    }

    private void updateCursorPosition(int n) {
        int n2;
        int n3;
        int n4;
        if (!this.m_cursorSnapping) {
            n4 = (this.m_keyRight ? 65536 : 0) + (this.m_keyLeft ? -65536 : 0);
            n3 = (this.m_keyDown ? 65536 : 0) + (this.m_keyUp ? -65536 : 0);
            if (n4 != 0 || n3 != 0) {
                n2 = MathExt.Fatan2(n3, n4);
                this.changeCursorSnapCheck(n2);
            }
        }
        if (this.m_cursorSnapping) {
            int n5;
            if (this.m_cursorObject != null) {
                int[] nArray = this.m_tempInt10;
                this.m_cursorObject.getHotSpot(nArray);
                this.m_cursorDestX = nArray[0];
                this.m_cursorDestZ = nArray[1];
            }
            if ((n4 = (this.m_quickLinksActive ? 19660 : 19660) * n) >= (n5 = MathExt.Fmag2(n3 = this.m_cursorDestX - this.m_cursorPosX >> 8, n2 = this.m_cursorDestZ - this.m_cursorPosZ >> 8)) << 8) {
                this.m_cursorPosX = this.m_cursorDestX;
                this.m_cursorPosZ = this.m_cursorDestZ;
            } else {
                n4 = MathExt.Fdiv(n4, n5);
                this.m_cursorPosX += MathExt.Fmul(n3, n4);
                this.m_cursorPosZ += MathExt.Fmul(n2, n4);
            }
            this.m_cursorAtDest = this.m_cursorPosX == this.m_cursorDestX && this.m_cursorPosZ == this.m_cursorDestZ;
            this.m_cursorSnapping = this.m_cursorSnapping && !this.m_cursorAtDest;
        } else if (this.m_cursorSelectTimer <= 0) {
            n4 = n * ((this.m_keyRight ? 13107 : 0) + (this.m_keyLeft ? -13107 : 0));
            n3 = n * ((this.m_keyDown ? 13107 : 0) + (this.m_keyUp ? -13107 : 0));
            this.m_cursorPosX += n4;
            this.m_cursorPosZ += n3;
            if (n4 != 0 || n3 != 0) {
                this.m_cursorObject = null;
                this.m_cursorSelectTimer = 0;
                TileMap tileMap = this.m_simWorld.getTileMap();
                int n6 = (tileMap.getWidth() * tileMap.getTileSizeX() << 16) - 983040;
                int n7 = (tileMap.getHeight() * tileMap.getTileSizeY() << 16) - 983040;
                this.m_cursorPosX = MathExt.clip(this.m_cursorPosX, 0, n6);
                this.m_cursorPosZ = MathExt.clip(this.m_cursorPosZ, 0, n7);
                this.m_cursorDestX = this.m_cursorPosX;
                this.m_cursorDestZ = this.m_cursorPosZ;
                this.m_cursorAtDest = true;
                this.m_cursorAtDestTime = 0;
            } else if (this.m_cursorObject != null && this.m_cursorAtDest) {
                int[] nArray = this.m_tempInt10;
                this.m_cursorObject.getHotSpot(nArray);
                this.m_cursorDestX = nArray[0];
                this.m_cursorDestZ = nArray[1];
                this.m_cursorPosX = nArray[0];
                this.m_cursorPosZ = nArray[1];
            }
        }
        this.m_cursorAtDestTime = this.m_cursorAtDest ? (this.m_cursorAtDestTime += n) : 0;
    }

    private void updateCursor(int n) {
        if (this.isCurtainActive()) {
            return;
        }
        if (!this.m_pauseMenuActive) {
            this.updateCursorPosition(n);
        }
        if (this.m_cursorObject != null && this.m_cursorSelectTimer > 0) {
            this.m_cursorSelectTimer -= n;
        }
        int n2 = this.m_cursorAtDest && this.m_cursorObject != null || this.m_contextMenuActive || m_state == 7 && this.m_buyModeState == 2 ? 577 : 576;
        this.m_cursorAnimPlayer.startAnim(n2, 4);
        this.m_cursorAnimPlayer.updateAnim(n);
    }

    public void setCursorObject(MapObject mapObject) {
        this.m_cursorObject = mapObject;
        if (mapObject != null) {
            int[] nArray = this.m_tempInt10;
            mapObject.getHotSpot(nArray);
            this.m_cursorDestX = nArray[0];
            this.m_cursorDestZ = nArray[1];
            this.m_cursorSnapping = true;
            this.m_cursorAtDestTime = 0;
        } else {
            this.m_cursorDestX = this.m_cursorPosX;
            this.m_cursorDestZ = this.m_cursorPosZ;
            this.m_cursorSnapping = false;
        }
    }

    private void setCursorSelectFlags(int n) {
        this.m_cursorSelectFlags = n;
        if (this.m_cursorObject == null || !this.m_cursorObject.getFlag(n)) {
            this.setCursorObject(null);
        }
    }

    private void changeCursorSnapCheck(int n) {
        int[] nArray = this.m_tempInt10;
        MapObject mapObject = null;
        int n2 = 7680;
        int n3 = this.m_cursorPosX;
        int n4 = this.m_cursorPosZ;
        int n5 = MathExt.normaliseAngleRadiansF(n);
        MapObject[] mapObjectArray = this.getObjects();
        int n6 = mapObjectArray.length;
        int n7 = this.m_cursorSelectFlags;
        for (int i = 0; i < n6; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            MapObject mapObject2 = mapObjectArray[i];
            mapObject2.getHotSpot(nArray);
            int n13 = nArray[0];
            int n14 = nArray[1];
            if (mapObject2 == this.m_cursorObject || !mapObject2.getFlag(n7)) continue;
            int n15 = this.m_viewportWidth << 16;
            int n16 = this.m_viewportHeight << 16;
            int n17 = Math.abs(n3 - n13);
            int n18 = Math.abs(n4 - n14);
            if (n17 > n15 || n18 > n16 || n17 == 0 && n18 == 0 || (n12 = Math.abs(MathExt.normaliseAngleRadiansF(n5 - (n11 = MathExt.Fatan2(n14 - n4, n13 - n3))))) >= 51472 || (n10 = MathExt.Fmag2(n9 = n3 - n13 >> 8, n8 = n4 - n14 >> 8)) >= n2) continue;
            mapObject = mapObject2;
            n2 = n10;
        }
        if (mapObject != null) {
            this.setCursorObject(mapObject);
            this.m_cursorSelectTimer = 200;
        }
    }

    private void changeCursorDistanceCheck() {
        int[] nArray = this.m_tempInt10;
        MapObject mapObject = null;
        int n = Integer.MAX_VALUE;
        int n2 = this.m_cursorPosX;
        int n3 = this.m_cursorPosZ;
        MapObject[] mapObjectArray = this.getObjects();
        int n4 = mapObjectArray.length;
        int n5 = this.m_cursorSelectFlags;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            int n8;
            MapObject mapObject2 = mapObjectArray[i];
            mapObject2.getHotSpot(nArray);
            int n9 = nArray[0];
            int n10 = nArray[1];
            if (mapObject2 == this.m_cursorObject || !mapObject2.getFlag(n5) || (n8 = MathExt.Fmag2(n7 = n2 - n9 >> 8, n6 = n3 - n10 >> 8)) >= n) continue;
            mapObject = mapObject2;
            n = n8;
        }
        if (mapObject != null) {
            this.setCursorObject(mapObject);
            this.m_cursorSelectTimer = 200;
        }
    }

    private void calcCameraDest() {
        int n;
        Object object;
        SimWorld simWorld = this.m_simWorld;
        SimData simData = this.m_simData;
        int n2 = this.m_cursorDestX;
        int n3 = this.m_cursorDestZ;
        if (this.m_cameraFollowTarget != null) {
            object = this.m_tempInt10;
            this.m_cameraFollowTarget.getHotSpot((int[])object);
            n2 = object[0];
            n3 = object[1];
        } else if (this.m_contextMenuActive || simData.getLastNPC() != -1) {
            object = this.m_contextMenuObject;
            if (object == null && this.m_cursorObject != null && this.m_cursorObject.getFlag(16384) && ((MapObjectSim)this.m_cursorObject).getId() == simData.getLastNPC()) {
                object = this.m_cursorObject;
            }
            if (object != null) {
                n = this.m_viewportWidth << 14;
                n2 = ((MapObject)object).getFlag(16384) ? (n2 -= n) : (n2 += n);
            }
        }
        object = simWorld.getTileMap();
        n = simWorld.getViewportWidth();
        int n4 = n >> 1;
        int n5 = simWorld.getViewportHeight();
        int n6 = n5 >> 1;
        int n7 = n4 << 16;
        int n8 = ((TileMap)object).getWidth() * ((TileMap)object).getTileSizeX() - n4 - 1 << 16;
        int n9 = n6 << 16;
        int n10 = ((TileMap)object).getHeight() * ((TileMap)object).getTileSizeY() - n6 - 1 << 16;
        n2 = MathExt.clip(n2, n7, n8);
        n3 = MathExt.clip(n3, n9, n10);
        this.m_cameraDestX = n2;
        this.m_cameraDestZ = n3;
    }

    public void setCameraFollow(MapObject mapObject) {
        if (!this.m_contextMenuActive && !this.m_quickLinksActive) {
            this.m_cameraFollowTarget = mapObject;
            this.m_cursorObject = null;
            if (mapObject == null) {
                this.m_cameraFollowTargetReturn = true;
            }
        }
    }

    public void clearCameraFollow() {
        this.m_cameraFollowTarget = null;
        this.m_cameraFollowTargetReturn = false;
    }

    public MapObject getCameraFollow() {
        return this.m_cameraFollowTarget;
    }

    private void updateCamera(int n) {
        boolean bl;
        boolean bl2;
        SimWorld simWorld = this.m_simWorld;
        int n2 = 11534;
        int n3 = 1441;
        int n4 = 32;
        if (this.m_quickLinksActive) {
            n2 = MathExt.Fmul(n2, 196608);
            n4 = MathExt.Fmul(n4, 196608);
        }
        int n5 = simWorld.getCameraPosX();
        int n6 = simWorld.getCameraPosZ();
        this.calcCameraDest();
        int n7 = MathExt.sign(this.m_cameraDestX - n5);
        int n8 = MathExt.sign(this.m_cameraDestZ - n6);
        if (n7 > 0 && this.m_cameraLastVelX > 0) {
            this.m_cameraVelX += n4 * n;
        } else if (n7 > 0 && this.m_cameraLastVelX <= 0) {
            this.m_cameraVelX = n3;
        } else if (n7 < 0 && this.m_cameraLastVelX < 0) {
            this.m_cameraVelX -= n4 * n;
        } else if (n7 < 0 && this.m_cameraLastVelX >= 0) {
            this.m_cameraVelX = -n3;
        } else if (n7 == 0 && this.m_cameraLastVelX > 0) {
            this.m_cameraVelX = -n3;
        } else if (n7 == 0 && this.m_cameraLastVelX < 0) {
            this.m_cameraVelX = n3;
        }
        if (this.m_cameraVelX < -n2) {
            this.m_cameraVelX = -n2;
        }
        if (this.m_cameraVelX > n2) {
            this.m_cameraVelX = n2;
        }
        if (n8 > 0 && this.m_cameraLastVelZ > 0) {
            this.m_cameraVelZ += n4 * n;
        } else if (n8 > 0 && this.m_cameraLastVelZ <= 0) {
            this.m_cameraVelZ = n3;
        } else if (n8 < 0 && this.m_cameraLastVelZ < 0) {
            this.m_cameraVelZ -= n4 * n;
        } else if (n8 < 0 && this.m_cameraLastVelZ >= 0) {
            this.m_cameraVelZ = -n3;
        } else if (n8 == 0 && this.m_cameraLastVelZ > 0) {
            this.m_cameraVelZ = -n3;
        } else if (n8 == 0 && this.m_cameraLastVelZ < 0) {
            this.m_cameraVelZ = n3;
        }
        if (this.m_cameraVelZ < -n2) {
            this.m_cameraVelZ = -n2;
        }
        if (this.m_cameraVelZ > n2) {
            this.m_cameraVelZ = n2;
        }
        int n9 = n5 + this.m_cameraVelX * n;
        int n10 = n6 + this.m_cameraVelZ * n;
        if (this.m_cameraVelX > 0 && n9 > this.m_cameraDestX || this.m_cameraVelX < 0 && n9 < this.m_cameraDestX) {
            bl2 = true;
            n9 = this.m_cameraDestX;
        } else {
            boolean bl3 = bl2 = n9 == this.m_cameraDestX;
        }
        if (this.m_cameraVelZ > 0 && n10 > this.m_cameraDestZ || this.m_cameraVelZ < 0 && n10 < this.m_cameraDestZ) {
            bl = true;
            n10 = this.m_cameraDestZ;
        } else {
            bl = n10 == this.m_cameraDestZ;
        }
        this.m_cameraLastVelX = this.m_cameraVelX;
        this.m_cameraLastVelZ = this.m_cameraVelZ;
        simWorld.setCameraPosX(n9);
        simWorld.setCameraPosZ(n10);
        boolean bl4 = this.m_cameraAtDest = bl2 && bl;
        if (this.m_cameraFollowTarget != null || this.m_cameraFollowTargetReturn) {
            this.m_cursorPosX += n9 - n5;
            this.m_cursorPosZ += n10 - n6;
        }
    }

    private void snapCameraPosition() {
        this.calcCameraDest();
        this.m_simWorld.setCameraPosX(this.m_cameraDestX);
        this.m_simWorld.setCameraPosZ(this.m_cameraDestZ);
        this.m_cameraAtDest = true;
    }

    public void snapCameraAndCursor(MapObject mapObject) {
        this.setCursorObject(mapObject);
        this.m_cursorPosX = this.m_cursorDestX;
        this.m_cursorPosZ = this.m_cursorDestZ;
        this.snapCameraPosition();
    }

    private void initHouseMap() {
        this.m_simWorld.prepareWorldHouse(this.m_engine.getNextHouseId());
        if (this.m_initialState == 96) {
            this.m_initialState = 5;
            this.putSimInBed(this.m_playerSim);
            this.m_timeHit = 120;
            this.m_simData.delayAlerts();
            this.startCurtainOut();
        }
    }

    private void initZoomMap() {
        this.m_simWorld.prepareWorldZoomMap(this.m_engine.getNextZoomMapId());
        MapObjectSim[] mapObjectSimArray = this.getSimObjects();
        for (int i = 0; i < mapObjectSimArray.length; ++i) {
            MapObjectSim mapObjectSim = mapObjectSimArray[i];
            if (mapObjectSim.getId() == 0) continue;
            mapObjectSim.setNeedFlag(32);
        }
    }

    private void initMacroMap() {
        boolean bl = false;
        if (this.m_initialState == 99) {
            this.m_initialState = 5;
            bl = true;
        }
        this.m_simWorld.prepareWorldMacromap(bl);
        this.m_playerSim.setFlag(1);
    }

    public MapObject[] getObjects() {
        if (this.m_refreshObjects) {
            this.m_refreshObjects = false;
            if (this.m_objects == null || this.m_objects.length != this.m_objectStack.size()) {
                this.m_objects = null;
                this.m_objects = new MapObject[this.m_objectStack.size()];
            }
            this.m_objectStack.copyInto(this.m_objects);
        }
        return this.m_objects;
    }

    public MapObjectSim[] getSimObjects() {
        if (this.m_refreshObjectsSims) {
            this.m_refreshObjectsSims = false;
            MapObject[] mapObjectArray = this.getObjects();
            int n = 0;
            for (int i = 0; i < mapObjectArray.length; ++i) {
                if (!mapObjectArray[i].getFlag(16384)) continue;
                ++n;
            }
            MapObjectSim[] mapObjectSimArray = this.m_objectsSims;
            if (mapObjectSimArray == null || mapObjectSimArray.length != n) {
                this.m_objectsSims = null;
                mapObjectSimArray = null;
                this.m_objectsSims = mapObjectSimArray = new MapObjectSim[n];
            }
            int n2 = 0;
            for (int i = 0; i < mapObjectArray.length; ++i) {
                if (!mapObjectArray[i].getFlag(16384)) continue;
                mapObjectSimArray[n2] = (MapObjectSim)mapObjectArray[i];
                ++n2;
            }
        }
        return this.m_objectsSims;
    }

    public MapObjectSim getPlayerSim() {
        return this.m_playerSim;
    }

    public MapObject findRandomObjectByType(int n) {
        MapObject[] mapObjectArray = this.getObjects();
        int n2 = this.m_engine.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            if (mapObject.getType() != n) continue;
            return mapObject;
        }
        return null;
    }

    public MapObject findObjectByTypeNearest(int n, int n2, int n3) {
        MapObject mapObject = null;
        int n4 = -1;
        MapObject[] mapObjectArray = this.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n5;
            MapObject mapObject2 = mapObjectArray[i];
            if (mapObject2.getType() != n || (n5 = Math.abs(n2 - mapObject2.getPosX()) + Math.abs(n3 - mapObject2.getPosZ())) >= n4 && mapObject != null) continue;
            n4 = n5;
            mapObject = mapObject2;
        }
        return mapObject;
    }

    public boolean isObjectAt(int n, int n2, int n3) {
        SimWorld simWorld = this.m_simWorld;
        int n4 = simWorld.coordWorldToWorldTileX(n2);
        int n5 = simWorld.coordWorldToWorldTileX(n3);
        MapObject[] mapObjectArray = this.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (mapObject.getParentType() != n) continue;
            int n6 = simWorld.coordWorldToWorldTileX(mapObject.getPosX());
            int n7 = simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
            if (n6 != n4 || n7 != n5) continue;
            return true;
        }
        return false;
    }

    public MapObject findRandomObjectByParentType(int n) {
        MapObject[] mapObjectArray = this.getObjects();
        int n2 = this.m_engine.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            if (mapObject.getParentType() != n) continue;
            return mapObject;
        }
        return null;
    }

    public MapObject findRandomNeedObject(int n) {
        SimWorld simWorld = this.m_simWorld;
        MapObject[] mapObjectArray = this.getObjects();
        int n2 = this.m_engine.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            int n4 = mapObject.getType();
            if ((simWorld.getObjectNeed(n4) & n) == 0 || !mapObject.occupiedIsAnyAvailable() || mapObject.getRuntimeFlag(768)) continue;
            return mapObject;
        }
        return null;
    }

    public MapObjectSim findSim(int n) {
        MapObjectSim[] mapObjectSimArray = this.getSimObjects();
        int n2 = mapObjectSimArray.length;
        for (int i = 0; i < n2; ++i) {
            MapObjectSim mapObjectSim = mapObjectSimArray[i];
            if (mapObjectSim.getId() != n) continue;
            return mapObjectSim;
        }
        return null;
    }

    public MapObject createObject(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.m_simWorld.getObjectFlags(n);
        if (this.isZoomMapMode() && (n == 2 || n == 3)) {
            n6 |= 0x2000;
        }
        MapObject mapObject = null;
        if ((n6 & 0x4000) != 0) {
            mapObject = new MapObjectSim(this);
            if (n == 0) {
                this.m_playerSim = mapObject;
            }
        } else if ((n6 & 0x2000) != 0) {
            mapObject = new MapObject(this);
        }
        if (mapObject != null) {
            mapObject.init(n, n2, n3, n4, n5);
            this.addObject(mapObject);
            if (mapObject.getFlag(16384)) {
                this.loadNewSim((MapObjectSim)mapObject);
            }
        }
        return mapObject;
    }

    public MapObject createObjectOnObjectInterestPoint(int n, MapObject mapObject, int n2) {
        int[] nArray = this.m_tempInt10;
        int n3 = 0;
        do {
            mapObject.getInterestPoint(nArray, n3);
            ++n3;
        } while (!this.m_simWorld.isWorldPointWalkable(nArray[0], nArray[1]));
        return this.createObject(n, nArray[0], nArray[1], 0, n2);
    }

    public MapObject createObjectOnWorldTile(int n, int n2, int n3, int n4, int n5) {
        SimWorld simWorld = this.m_simWorld;
        int n6 = simWorld.coordWorldTileToWorldCenterX(n2);
        int n7 = simWorld.coordWorldTileToWorldCenterZ(n3);
        return this.createObject(n, n6, n7, n4, n5);
    }

    public void createEffectAnim(int n, int n2, int n3, int n4) {
        MapObject mapObject = this.createObject(7, n, n2, 3, -1);
        if (mapObject != null) {
            mapObject.effectPlayAnim(n3, n4);
        }
    }

    public void createEffectMoney(int n, int n2, int n3) {
        MapObject mapObject = this.createObject(8, n, n2, 3, -1);
        if (mapObject != null) {
            mapObject.effectShowMoney(n3);
        }
    }

    private void addObject(MapObject mapObject) {
        mapObject.applyFootprint(true);
        this.m_objectStack.addElement(mapObject);
        this.m_refreshObjects = true;
        if (mapObject.getFlag(16384)) {
            this.m_refreshObjectsSims = true;
        }
    }

    public void removeObject(MapObject mapObject) {
        if (this.m_cursorObject == mapObject) {
            this.setCursorObject(null);
        }
        if (this.m_contextMenuActive && this.m_contextMenuObject == mapObject) {
            this.hideContextMenu();
        }
        int n = -1;
        if (mapObject.getFlag(16384)) {
            n = mapObject.getId();
        }
        mapObject.applyFootprint(false);
        this.m_objectStack.removeElement(mapObject);
        this.m_refreshObjects = true;
        if (n != -1) {
            this.m_refreshObjectsSims = true;
            int n2 = AppEngine.indexOf(n, this.m_loadedSims);
            if (n2 != -1) {
                int n3 = this.m_simData.getSimAttribute(n, 0) == 0 ? 512 : 256;
                this.m_engine.unloadAllImages(n3 |= 0x4000, n2);
                this.m_loadedSims[n2] = -1;
            }
        }
    }

    private void updateObjects(int n) {
        MapObject[] mapObjectArray = this.getObjects();
        if (mapObjectArray != null) {
            for (int i = 0; i < mapObjectArray.length; ++i) {
                MapObject mapObject = mapObjectArray[i];
                mapObject.update(n);
            }
        }
    }

    private void updateObjectTypes(int n, int n2) {
        MapObject[] mapObjectArray = this.getObjects();
        if (mapObjectArray != null) {
            for (int i = 0; i < mapObjectArray.length; ++i) {
                MapObject mapObject = mapObjectArray[i];
                if (mapObject.getType() != n2) continue;
                mapObject.update(n);
            }
        }
    }

    public void removeBuildPoints() {
        MapObject[] mapObjectArray = this.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (!mapObject.getFlag(4)) continue;
            mapObject.destroy();
        }
    }

    public MapObject getContextMenuObject() {
        return this.m_contextMenuObject;
    }

    public void showContextMenu(MapObject mapObject) {
        SimData simData = this.m_simData;
        if (this.m_shortcutMenuActive) {
            this.hideShortcutMenu();
        }
        this.stopCursor();
        short[] sArray = this.m_contextMenuItems;
        short[] sArray2 = this.m_contextMenuActions;
        simData.setLastNPC(-1);
        this.m_contextMenuActive = true;
        this.m_contextMenuOnSubMenu = false;
        this.m_contextMenuBackCursor = (short)-1;
        this.m_contextMenuObject = mapObject;
        if (m_state == 7) {
            mapObject.createBuildContextMenu(sArray);
            sArray[4] = this.m_maxContextMenuItems;
            AppEngine.menuCopy(sArray2, sArray);
        } else {
            int n = AppEngine.indexOf(this.m_contextMenuObject, this.m_actionQueueArg1s);
            if (n != -1 && this.m_actionQueueActions[n] != 2) {
                int n2 = this.m_contextMenuObject.getFlag(16384) ? this.m_simData.getSimName(this.m_contextMenuObject.getId()) : this.m_contextMenuObject.getTypeString();
                AppEngine.menuClear(sArray, n2);
                AppEngine.menuClear(sArray2, n2);
                AppEngine.menuAppendItem(sArray, 120);
                AppEngine.menuAppendItem(sArray2, -3);
            } else {
                simData.createContextMenu(this.m_contextMenuObject, sArray, sArray2);
            }
            AppEngine.menuCopy(this.m_contextMenuFullActions, sArray2);
            if (sArray[0] > this.m_maxContextMenuItems) {
                simData.compactContextMenu(sArray, sArray2, this.m_contextMenuFullActions);
            }
            sArray[4] = this.m_maxContextMenuItems;
        }
        this.setupSoftkeys();
    }

    private void hideContextMenu() {
        this.m_contextMenuActive = false;
        this.m_contextMenuOnSubMenu = false;
        this.m_contextMenuBackCursor = (short)-1;
        this.m_contextMenuObject = null;
        this.setupSoftkeys();
        this.setCursorObject(this.m_cursorObject);
    }

    private void renderContextMenu(Graphics graphics) {
        boolean bl = this.m_contextMenuObject != null && this.m_contextMenuObject.getFlag(16384);
        int n = bl ? 2 : 4;
        this.drawGenericMenu(graphics, this.m_contextMenuItems, n);
    }

    private int getSimContext() {
        SimData simData = this.m_simData;
        if (!this.m_suppressMenus && this.m_contextMenuActive) {
            if (this.m_contextMenuObject != null && this.m_contextMenuObject.getFlag(16384)) {
                return ((MapObjectSim)this.m_contextMenuObject).getId();
            }
        } else if (simData.isLastNPCStillRelevant()) {
            return simData.getLastNPC();
        }
        return -1;
    }

    private void renderContextRelationships(Graphics graphics) {
        boolean bl;
        SimData simData = this.m_simData;
        int n = this.getSimContext();
        boolean bl2 = bl = !this.m_contextMenuActive || this.m_suppressMenus;
        if (!this.m_suppressMenus && this.m_contextMenuActive) {
            if (this.m_contextMenuObject != null && this.m_contextMenuObject.getFlag(16384)) {
                n = ((MapObjectSim)this.m_contextMenuObject).getId();
            }
        } else if (simData.isLastNPCStillRelevant()) {
            bl = true;
            n = simData.getLastNPC();
        }
        if (n != -1) {
            int n2;
            AppEngine appEngine = this.m_engine;
            int[] nArray = this.m_tempInt10;
            simData.getRelationshipLevels(n, nArray);
            int n3 = (nArray[0] != -1 ? 1 : 0) + (nArray[2] != -1 ? 1 : 0);
            int n4 = this.m_viewportX + 3;
            int n5 = appEngine.getWidth() >> 1;
            int n6 = AnimationManager.getAnimFrameHeight(679, 0);
            int n7 = appEngine.getHeight() - 15 - this.m_hudBottomHeight;
            int n8 = n7 - 18 * (n3 + 1);
            if (this.m_tickerString1 != -1) {
                n8 -= n6;
            }
            int n9 = n8;
            int n10 = simData.getRelState(n);
            this.drawRelBar(graphics, n4, n9, n5, n10, 65536, true);
            n9 += 18;
            for (n2 = 0; n2 < 4 && (n10 = nArray[n2]) != -1; n2 += 2) {
                int n11 = nArray[n2 + 1];
                this.drawRelBar(graphics, n4, n9, n5, n10, n11, false);
                n9 += 18;
            }
            if (bl) {
                n2 = -1;
                MapObjectSim mapObjectSim = this.getPlayerSim().getSimActionArg1Sim();
                if (mapObjectSim != null && mapObjectSim.getId() == n) {
                    n2 = simData.getActionString(this.getPlayerSim().getSimAction());
                }
                if (n2 == 27) {
                    n2 = -1;
                }
                int n12 = n8 - 14 - 4 - (n2 != -1 ? 12 : 0);
                int n13 = n5 - 4;
                AnimationManager.setColor(graphics, 76);
                graphics.fillRect(n4, n12, n5, 14);
                AnimationManager.setColor(graphics, 77);
                graphics.drawRect(n4, n12, n5, 14);
                appEngine.drawString(simData.getSimName(n), 0, n4 + (n5 >> 1), n12 + 0, 17);
                if (n2 != -1) {
                    int n14 = n12 + 14;
                    AnimationManager.setColor(graphics, 76);
                    graphics.fillRect(n4, n14, n5, 12);
                    AnimationManager.setColor(graphics, 77);
                    graphics.drawRect(n4, n14, n5, 12);
                    appEngine.drawClippedString(graphics, n2, 1, n4 + 2, n14 + 2, n13, 17);
                }
            }
        }
    }

    private void processKeysContextMenu(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 4)) {
            this.resetPlayerInactivity();
            if (this.m_contextMenuOnSubMenu) {
                this.m_simData.compactContextMenu(this.m_contextMenuItems, this.m_contextMenuActions, this.m_contextMenuFullActions);
                this.m_contextMenuItems[4] = this.m_maxContextMenuItems;
                this.m_contextMenuOnSubMenu = false;
                this.m_contextMenuItems[2] = this.m_contextMenuBackCursor;
                AppEngine.menuVisible(this.m_contextMenuItems);
            } else {
                this.hideContextMenu();
            }
        } else if (this.checkKeys(n, n2, 4128, 16)) {
            int n3 = 5 + this.m_contextMenuItems[2];
            if (m_state == 7) {
                this.processBasicAction(this.m_contextMenuItems[n3]);
            } else {
                short s = this.m_contextMenuActions[n3];
                if (s == -4) {
                    this.hideContextMenu();
                } else if (s == -3) {
                    this.processCancelAction(this.m_contextMenuObject);
                    this.hideContextMenu();
                } else if (s == -2) {
                    this.m_contextMenuBackCursor = this.m_contextMenuItems[2];
                    this.m_contextMenuOnSubMenu = true;
                    short s2 = this.m_contextMenuItems[n3];
                    this.m_simData.filterContextMenu(this.m_contextMenuItems, this.m_contextMenuActions, this.m_contextMenuFullActions, s2);
                    this.m_contextMenuItems[4] = this.m_maxContextMenuItems;
                } else if (s == 139 || s == 138) {
                    this.processCallAction();
                } else if (s == 113) {
                    this.processPlantAction();
                } else if (s == 128) {
                    this.processCookAction();
                } else {
                    this.hideMenus();
                    this.processSimAction(s, this.m_cursorObject, 0, 0);
                }
            }
        } else {
            this.m_engine.menuCursorUpDown(this.m_contextMenuItems, n);
        }
    }

    private void stateTransitionPauseMenu(int n) {
        this.m_pauseMenuState = n;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.prepareGenericMessageBox(80, 79);
                break;
            }
            case 2: {
                this.prepareGenericMessageBox(74, 72);
                break;
            }
            case 3: {
                this.prepareGenericMessageBox(76, 72);
                break;
            }
            case 4: {
                this.prepareGenericMessageBox(78, 72);
                break;
            }
            case 5: {
                this.initCheatMenu();
            }
        }
        this.setupSoftkeys();
    }

    private void showPauseMenu() {
        if (this.m_contextMenuActive) {
            this.hideContextMenu();
        }
        if (this.m_shortcutMenuActive) {
            this.hideShortcutMenu();
        }
        this.stopCursor();
        this.m_pauseMenuActive = true;
        this.m_pauseMenuState = 0;
        this.m_pauseMenuItems[2] = 0;
        this.setupSoftkeys();
    }

    private void hidePauseMenu() {
        this.m_pauseMenuActive = false;
        this.setupSoftkeys();
    }

    private void processKeysPauseMenu(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        if (appEngine.getSharedMenuState() != -1) {
            appEngine.processKeysSharedMenu(n, n2);
            return;
        }
        switch (this.m_pauseMenuState) {
            case 0: {
                if (this.checkKeys(n, n2, 0, 4)) {
                    this.hidePauseMenu();
                    break;
                }
                if (this.checkKeys(n, n2, 4128, 16)) {
                    int n3 = 5 + this.m_pauseMenuItems[2];
                    this.processBasicAction(this.m_pauseMenuItems[n3]);
                    break;
                }
                appEngine.menuCursorUpDown(this.m_pauseMenuItems, n);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    if (this.m_pauseMenuState != 1) {
                        appEngine.saveRMSAppSettings();
                        appEngine.saveRMSGameData();
                    }
                    if (this.m_pauseMenuState != 2) {
                        this.changeSceneWithFade(1, -1);
                        break;
                    }
                    this.hidePauseMenu();
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 516)) break;
                this.stateTransitionPauseMenu(0);
                break;
            }
            case 4: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    appEngine.saveRMSAppSettings();
                    appEngine.saveRMSGameData();
                    this.fadeStateTransition(4);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 516)) break;
                this.stateTransitionPauseMenu(0);
                break;
            }
            case 5: {
                this.processKeysCheatMenu(n, n2);
                break;
            }
            default: {
                AppEngine.ASSERT(false, "invalid state");
            }
        }
    }

    private void renderPauseMenu(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        appEngine.renderBackgroundDim(graphics);
        int n = this.m_pauseMenuState;
        if (appEngine.getSharedMenuState() != -1) {
            appEngine.renderSharedMenu(graphics);
        } else if (n == 0) {
            this.drawGenericMenu(graphics, this.m_pauseMenuItems, 1);
        } else if (n == 2 || n == 3 || n == 1 || n == 4) {
            this.drawGenericMessageBox(graphics);
        } else if (n == 5) {
            this.renderCheatMenu(graphics);
        }
    }

    private void showShortcutMenu() {
        this.m_shortcutByShortcutKey = false;
        if (this.m_contextMenuActive) {
            this.hideContextMenu();
        }
        this.stopCursor();
        short[] sArray = this.m_shortcutMenuItems;
        this.m_shortcutMenuActive = true;
        AppEngine.menuClear(sArray, 38, this.m_engine.getMaxMenuItemsPerScreen());
        if (this.m_actionQueueSize > 0) {
            AppEngine.menuAppendItem(sArray, 120);
        }
        if (this.m_simData.isTimeForWork(null, 0)) {
            AppEngine.menuAppendItem(sArray, 334);
        }
        if (!this.isMapMode()) {
            AppEngine.menuAppendItem(sArray, 335);
        } else {
            AppEngine.menuAppendItem(sArray, 131);
        }
        if (!this.isMapMode() && this.m_simWorld.getHouseId() == 0) {
            AppEngine.menuAppendItem(sArray, 121);
        } else {
            AppEngine.menuAppendItem(sArray, 336);
        }
        AppEngine.menuAppendItem(sArray, 123);
        AppEngine.menuAppendItem(sArray, 122);
        AppEngine.menuAppendItem(sArray, 124);
        AppEngine.menuAppendItem(sArray, 125);
        AppEngine.menuAppendItem(sArray, 126);
        AppEngine.menuAppendItem(sArray, 127);
        AppEngine.menuAppendItem(sArray, 129);
        if (this.m_engine.m_debugCheatMenuEnabled) {
            AppEngine.menuAppendItem(sArray, 130);
        }
        this.setupSoftkeys();
    }

    private void hideShortcutMenu() {
        this.m_shortcutMenuActive = false;
        this.setupSoftkeys();
    }

    private void processKeysShortcutMenu(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        if (this.checkKeys(n, n2, 0, 4)) {
            appEngine.clearCommandKeys();
            this.hideShortcutMenu();
        } else if (this.checkKeys(n, n2, 4128, 16)) {
            int n3 = this.m_shortcutMenuItems[2] + 5;
            this.processBasicAction(this.m_shortcutMenuItems[n3]);
        } else {
            appEngine.menuCursorUpDown(this.m_shortcutMenuItems, n);
        }
    }

    private void renderShortcutMenu(Graphics graphics) {
        this.m_engine.renderBackgroundDim(graphics);
        this.drawGenericMenu(graphics, this.m_shortcutMenuItems, 1);
    }

    private void showQuickLinks() {
        this.clearCameraFollow();
        this.m_quickLinksActive = true;
        short[] sArray = this.m_quickLinksMenu;
        AppEngine.menuClear(sArray, 27);
        int n = this.m_simWorld.getObjectCount();
        for (int i = 0; i < n; ++i) {
            if (!this.m_simData.isQuickLinkVisited(i)) continue;
            AppEngine.menuAppendItem(sArray, i);
        }
        this.quickLinksSelect(this.m_quickLinksMenu[2]);
        this.setupSoftkeys();
    }

    private void hideQuickLinks() {
        this.m_quickLinksActive = false;
        this.setupSoftkeys();
    }

    private void processKeysQuickLinks(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 4)) {
            this.hideQuickLinks();
        } else if (this.checkKeys(n, n2, 4128, 16)) {
            this.hideQuickLinks();
            this.processKeysFire();
        } else if (this.m_engine.menuCursorLeftRight(this.m_quickLinksMenu, n)) {
            this.quickLinksSelect(this.m_quickLinksMenu[2]);
        }
        if (this.checkKeys(n, n2, 32784, 0)) {
            this.triggerLeftArrow();
        } else if (this.checkKeys(n, n2, 65600, 0)) {
            this.triggerRightArrow();
        }
    }

    private void quickLinksSelect(int n) {
        short s = this.m_quickLinksMenu[5 + n];
        MapObject mapObject = this.findRandomObjectByType(s);
        this.setCursorObject(mapObject);
    }

    private void renderQuickLinks(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = AnimationManager.getAnimFrameHeight(591, 0);
        int n2 = this.m_viewportX + (this.m_viewportWidth >> 1);
        int n3 = this.m_viewportY + (n >> 1);
        int n4 = this.m_viewportY + this.m_viewportHeight - (n >> 1);
        this.drawAnimBox(graphics, this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight, 591, -1);
        appEngine.drawString(131, 0, n2, n3, 3);
        int n5 = this.m_quickLinksMenu[2] + 5;
        short s = this.m_quickLinksMenu[n5];
        MapObject mapObject = this.findRandomObjectByType(s);
        int n6 = mapObject.getTooltipStringId();
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendIntToBuffer(this.m_quickLinksMenu[2] + 1);
        appEngine.appendStringIdToBuffer(32);
        appEngine.appendStringIdToBuffer(n6);
        appEngine.drawString(sDKString, 1, n2, n4, 3);
        int n7 = AnimationManager.getAnimFrameHeight(569, 0);
        int n8 = n4 - (n7 >> 1);
        int n9 = appEngine.getWidth() - 3;
        this.m_arrowLeftAnimPlayer.drawAnim(graphics, 3, n8);
        this.m_arrowRightAnimPlayer.drawAnim(graphics, n9, n8);
    }

    private void renderQuickLinksMarker(Graphics graphics, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        AnimationManager.drawAnimFrame(graphics, 662, 0, n, n2);
        int[] nArray = this.m_tempInt10;
        AnimationManager.getAnimFrameFirePoint(nArray, 662, 0, 0);
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendIntToBuffer(this.m_quickLinksMenu[2] + 1);
        appEngine.drawString(sDKString, 0, n + nArray[0], n2 + nArray[1], 17);
    }

    private void stateTransitionBuildMode(int n) {
        SimWorld simWorld = this.m_simWorld;
        switch (n) {
            case 0: {
                this.stateTransition(5);
                break;
            }
            case 1: {
                this.setCursorSelectFlags(2);
                break;
            }
            case 2: {
                if (this.m_buyModeState == 7 || this.m_buyModeState == 8 || this.m_buyModeState == 3 || this.m_buyModeState == 4 || this.m_buyModeState == 6) break;
                this.initListFurniture();
                break;
            }
            case 3: {
                this.prepareGenericMessageBox(756, 755);
                break;
            }
            case 4: {
                if (this.m_buyModeState == 5) break;
                this.setCursorSelectFlags(4);
                this.changeCursorDistanceCheck();
                break;
            }
            case 5: {
                int n2 = simWorld.getObjectStringId(this.m_buyNewType);
                this.prepareGenericMessageBox(759, n2);
                break;
            }
            case 6: {
                this.m_stateTime = 0;
                break;
            }
            case 7: {
                int n3 = simWorld.getObjectStringId(this.m_buyNewType);
                this.prepareGenericMessageBox(757, n3);
                break;
            }
            case 8: {
                int n4 = simWorld.getObjectStringId(this.m_buyNewType);
                this.prepareGenericMessageBox(758, n4);
                break;
            }
            case 9: {
                int n5 = this.m_cursorObject.getTypeString();
                this.prepareGenericMessageBox(760, n5);
                break;
            }
            case 10: {
                if (simWorld.getHouseUpgradeCost() <= this.m_simData.getMoney()) {
                    this.prepareGenericMessageBox(779, 778);
                    break;
                }
                this.prepareGenericMessageBox(780, 778);
                break;
            }
            case 11: {
                this.m_buyNewType = this.m_cursorObject.getType();
                this.m_buyModeObject = this.m_cursorObject;
                this.m_buyModeObject.applyFootprint(false);
                this.m_buyModeObject.hide();
                simWorld.createBuildPoints(this.m_buyNewType);
                this.setCursorSelectFlags(4);
                this.changeCursorDistanceCheck();
            }
        }
        this.m_buyModeState = n;
        this.setupSoftkeys();
    }

    private void processKeysBuildMode(int n, int n2) {
        switch (this.m_buyModeState) {
            case 1: {
                this.processKeysBuildModeEdit(n, n2);
                break;
            }
            case 2: {
                this.processKeysBuildModeSelect(n, n2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                if (!this.checkKeys(n, n2, 4128, 12)) break;
                this.stateTransitionBuildMode(2);
                break;
            }
            case 4: 
            case 11: {
                this.processKeysBuildModePlace(n, n2);
                break;
            }
            case 5: {
                this.processKeysBuildModeBuyConfirm(n, n2);
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                this.processKeysBuildModeSellConfirm(n, n2);
                break;
            }
            case 10: {
                this.processKeysBuildModeUpgradeConfirm(n, n2);
            }
        }
    }

    private void updateBuildMode(int n) {
        switch (this.m_buyModeState) {
            case 1: 
            case 4: 
            case 6: 
            case 11: {
                this.updateTicker(n);
                this.updateCursor(n);
                this.updateCamera(n);
                this.updateObjectTypes(n, 8);
                if (this.m_buyModeState != 6 || this.m_stateTime <= 1500) break;
                this.stateTransitionBuildMode(2);
                break;
            }
            case 2: {
                this.updateCursor(n);
            }
        }
    }

    private void renderBuildMode(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        switch (this.m_buyModeState) {
            case 1: 
            case 4: 
            case 6: 
            case 11: {
                this.renderMain(graphics);
                break;
            }
            case 2: {
                this.renderBuyModeSelect(graphics);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                this.renderBuyModeSelect(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawGenericMessageBox(graphics);
                break;
            }
            case 5: 
            case 9: {
                int n;
                int n2;
                int n3;
                if (this.m_buyModeState == 5) {
                    n3 = this.m_simWorld.getObjectStringId(this.m_buyNewType);
                    n2 = 716;
                    n = this.m_simWorld.getObjectBuyPrice(this.m_buyNewType);
                } else {
                    n3 = this.m_simWorld.getObjectStringId(this.m_cursorObject.getType());
                    n2 = 717;
                    n = this.m_simWorld.getObjectSellPrice(this.m_cursorObject.getType());
                }
                this.setUIPlaceholderString(1, n3);
                this.setUIPlaceholderString(2, n2);
                SDKString sDKString = appEngine.clearStringBuffer();
                appEngine.appendMoneyToBuffer(n);
                appEngine.dynamicString(-9, sDKString);
                this.setUIPlaceholderString(3, -9);
                this.renderMain(graphics);
                appEngine.renderBackgroundDim(graphics);
                this.drawUIFullScreen(graphics, 20);
                this.renderSoftkeyBar(graphics);
                break;
            }
            case 10: {
                this.renderBuyModeUpgradeConfirm(graphics);
            }
        }
        this.renderSoftkeyBar(graphics);
    }

    private void processKeysBuildModeEdit(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 4)) {
            this.stateTransition(5);
        }
        this.processKeysCursor(n, n2);
        if (this.checkKeys(n, n2, 4128, 16)) {
            this.processKeysFire();
        }
    }

    private void processKeysBuildModeSelect(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 4)) {
            this.stateTransition(5);
            return;
        }
        if (this.checkKeys(n, n2, 4128, 16)) {
            int n3;
            int n4 = this.getListCursor();
            this.m_buyNewType = n3 = this.m_simWorld.getFurnitureNthItem(n4);
            if (!this.m_simWorld.isFurnitureAvailable(n3)) {
                this.stateTransitionBuildMode(8);
            } else {
                int n5 = this.m_simWorld.getObjectBuyPrice(this.m_buyNewType);
                if (this.m_simData.getMoney() >= n5) {
                    int n6 = this.m_simWorld.createBuildPoints(this.m_buyNewType);
                    if (n6 > 0) {
                        this.stateTransitionBuildMode(4);
                    } else {
                        this.stateTransitionBuildMode(3);
                    }
                } else {
                    this.stateTransitionBuildMode(7);
                }
            }
        }
        this.processKeysList(n, n2);
    }

    private void renderBuyModeSelect(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = this.m_simWorld;
        int n = simWorld.getFurnitureNthItem(this.getListCursor());
        if (!simWorld.isFurnitureAvailable(n)) {
            this.setUIPlaceholderString(1, 718);
        } else {
            SDKString sDKString = appEngine.clearStringBuffer();
            appEngine.appendMoneyToBuffer(simWorld.getObjectBuyPrice(n));
            appEngine.dynamicString(-9, sDKString);
            this.setUIPlaceholderString(1, -9);
        }
        this.drawUIFullScreen(graphics, 23);
        this.renderSoftkeyBar(graphics);
    }

    public void drawUIFurniturePreview(Graphics graphics, int[] nArray) {
        int n = nArray[2];
        int n2 = n * 3 / 5;
        if (graphics != null) {
            int n3 = nArray[0] + n - n2;
            int n4 = nArray[1];
            int n5 = nArray[3];
            this.drawDescBox(graphics, n3, n4, n2, n5);
            SimWorld simWorld = this.m_simWorld;
            int n6 = simWorld.getFurnitureNthItem(this.getListCursor());
            int n7 = simWorld.getObjectAnimId(n6);
            int n8 = simWorld.getObjectAnimSetId(n6, 0);
            if (n7 == 203 && n8 != 0 && (n7 = simWorld.getAnim(n8, 1)) == 203) {
                n7 = simWorld.getAnim(n8, 2);
            }
            AppEngine.ASSERT(n7 != 203, "where's the anim for this furniture?");
            int n9 = AnimationManager.getAnimFrameX(n7, 0);
            int n10 = AnimationManager.getAnimFrameY(n7, 0);
            int n11 = AnimationManager.getAnimFrameWidth(n7, 0);
            int n12 = AnimationManager.getAnimFrameHeight(n7, 0);
            int n13 = n3 + (n2 >> 1) - n9 - (n11 >> 1);
            int n14 = n4 + (n5 >> 1) - n10 - (n12 >> 1);
            AnimationManager.drawAnimFrame(graphics, n7, 0, n13, n14);
        }
        nArray[2] = n - n2 - 3;
    }

    private void initListFurniture() {
        this.initList(this.m_simWorld.getFurnitureNthCount(), 15, 0);
    }

    public void drawListFuniture(Graphics graphics, int n, int n2, int n3, int n4) {
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = this.m_simWorld;
        int n5 = n + 3;
        int n6 = n2;
        int n7 = this.getListCursor();
        for (int i = this.getListOffset(); n6 < n2 + n4 && i < this.getListNum(); ++i) {
            int n8 = simWorld.getFurnitureNthItem(i);
            int n9 = simWorld.getObjectStringId(n8);
            int n10 = 1;
            if (i == n7) {
                this.drawListSelect(graphics, n, n6, n3, 15, n2 + n4, 82, i);
                n10 = 0;
            }
            appEngine.drawString(n9, n10, n5, n6 + 7, 6);
            this.drawListDivider(graphics, n, n6 += 15, n3);
        }
    }

    private void processKeysBuildModePlace(int n, int n2) {
        this.processKeysCursor(n, n2);
        MapObject mapObject = this.m_buyModeObject;
        if (this.checkKeys(n, n2, 0, 4)) {
            this.removeBuildPoints();
            if (this.m_buyModeState == 11) {
                this.removeBuildPoints();
                mapObject.applyFootprint(true);
                mapObject.unhide();
                this.m_buyModeObject = null;
                this.stateTransitionBuildMode(1);
            } else {
                this.stateTransitionBuildMode(2);
            }
        } else if (this.checkKeys(n, n2, 4128, 2048) && this.m_cursorObject != null) {
            if (this.m_buyModeState == 11) {
                MapObject mapObject2 = this.m_cursorObject;
                if (mapObject2 != null) {
                    mapObject.unhide();
                    mapObject.reposition(mapObject2.getPosX(), mapObject2.getPosZ(), mapObject2.getFacingDir());
                    mapObject.applyFootprint(true);
                    this.m_simWorld.objectChange(mapObject.getId(), mapObject2.getPosX(), mapObject2.getPosZ(), mapObject2.getFacingDir());
                    this.setCursorObject(mapObject);
                    this.m_buyModeObject = null;
                    this.removeBuildPoints();
                    this.stateTransitionBuildMode(1);
                }
            } else {
                this.stateTransitionBuildMode(5);
            }
        }
    }

    private void processKeysBuildModeBuyConfirm(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 256)) {
            MapObject mapObject = this.m_cursorObject;
            if (mapObject != null) {
                SimData simData = this.m_simData;
                SimWorld simWorld = this.m_simWorld;
                AppEngine appEngine = this.m_engine;
                int n3 = this.m_simWorld.getObjectBuyPrice(this.m_buyNewType);
                this.createEffectMoney(mapObject.getPosX(), mapObject.getPosZ(), n3);
                simData.adjustMoney(-n3);
                int n4 = simWorld.objectBuy(this.m_buyNewType, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir());
                this.removeBuildPoints();
                MapObject mapObject2 = this.createObject(this.m_buyNewType, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir(), n4);
                this.setCursorObject(mapObject2);
                simData.registerBuyFurninture(this.m_buyNewType);
                this.stateTransitionBuildMode(6);
            }
        } else if (this.checkKeys(n, n2, 0, 516)) {
            this.stateTransitionBuildMode(4);
        }
    }

    private void processKeysBuildModeSellConfirm(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 256)) {
            MapObject mapObject = this.m_cursorObject;
            AppEngine.ASSERT(mapObject != null, "Can't sell null object");
            int n3 = mapObject.getType();
            int[] nArray = this.m_tempInt10;
            this.m_cursorObject.getHotSpot(nArray);
            this.m_simWorld.objectSell(this.m_cursorObject.getId());
            this.processCancelAction(this.m_cursorObject);
            this.m_cursorObject.destroy();
            this.setCursorObject(null);
            this.m_cursorSnapping = true;
            this.m_cursorDestX = nArray[0];
            this.m_cursorDestZ = nArray[1];
            int n4 = this.m_simWorld.getObjectSellPrice(n3);
            this.m_simData.adjustMoney(n4);
            this.stateTransitionBuildMode(1);
        } else if (this.checkKeys(n, n2, 0, 516)) {
            this.stateTransitionBuildMode(1);
        }
    }

    private void processKeysBuildModeUpgradeConfirm(int n, int n2) {
        int n3;
        int n4 = this.m_engine.getLeftCommandID() | this.m_engine.getRightCommandID();
        int n5 = (n4 & 8) != 0 ? 4128 : 0;
        int n6 = n3 = n5 == 0 ? 4128 : 0;
        if (this.checkKeys(n, n2, n5, 524)) {
            this.stateTransition(5);
        }
        if (this.checkKeys(n, n2, n3, 256)) {
            this.m_simData.adjustMoney(-this.m_simWorld.getHouseUpgradeCost());
            this.m_simWorld.upgradePlayerHouse();
            this.stateTransitionBuildMode(0);
            this.startCurtainIn();
        }
    }

    private void renderBuyModeUpgradeConfirm(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.setUIPlaceholderString(1, 778);
        this.setUIPlaceholderString(2, 783);
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendMoneyToBuffer(this.m_simWorld.getHouseUpgradeCost());
        appEngine.dynamicString(-9, sDKString);
        this.setUIPlaceholderString(3, -9);
        this.renderMain(graphics);
        appEngine.renderBackgroundDim(graphics);
        this.drawUIFullScreen(graphics, 20);
        this.renderSoftkeyBar(graphics);
    }

    private void stateTransitionInfoScreen(int n) {
        switch (n) {
            case 0: {
                if (this.m_infoScreenState != 9) {
                    this.m_infoScreenSimSelectedIndex = 0;
                }
                this.initListRelationships();
                break;
            }
            case 9: {
                this.m_infoScreenSimSelectedIndex = this.getListCursor();
                this.reloadInfoScreenSim();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n2 = 551;
                if (this.m_simData.getDream() == -1) {
                    n2 = 554;
                } else if (!this.m_simData.isDreamToPromisePossible()) {
                    n2 = 552;
                }
                this.m_engine.wrapString(n2, 1, this.m_uiInfoBoxWrapWidth);
                this.initListDreams();
                break;
            }
            case 4: {
                this.initListStatus();
                break;
            }
            case 5: {
                this.initListPersonaGoals();
                break;
            }
            case 6: {
                this.initListInventory();
                break;
            }
            case 10: {
                this.initListRecipe();
                break;
            }
            case 7: {
                this.stateTransition(5);
                break;
            }
            case 8: {
                this.stateTransition(5);
                if (this.m_shortcutByShortcutKey) break;
                this.showShortcutMenu();
                int n3 = -1;
                switch (this.m_infoScreenState) {
                    case 0: {
                        n3 = 123;
                        break;
                    }
                    case 1: {
                        n3 = 122;
                        break;
                    }
                    case 2: {
                        n3 = 124;
                        break;
                    }
                    case 3: {
                        n3 = 125;
                        break;
                    }
                    case 4: {
                        n3 = 126;
                        break;
                    }
                    case 5: {
                        n3 = 127;
                        break;
                    }
                    case 6: {
                        n3 = 129;
                    }
                }
                if (n3 == -1) break;
                AppEngine.menuSelectById(this.m_shortcutMenuItems, n3);
            }
        }
        this.m_infoScreenState = n;
        this.setupSoftkeys();
    }

    private void reloadInfoScreenSim() {
        int n = this.getInfoSim();
        if (n != this.m_infoLoadedNPC) {
            this.m_infoLoadedNPC = n;
            AppEngine appEngine = this.m_engine;
            int n2 = 98304;
            appEngine.unloadAllImages(n2, 1);
            n2 = this.m_simData.getSimAttribute(n, 0) == 0 ? 32768 : 65536;
            this.m_simWorld.getSimPatches(n, this.m_palSources, this.m_palPatches);
            appEngine.loadAllImages(n2, this.m_palSources, this.m_palPatches, 1);
        }
    }

    private void processKeysInfoScreen(int n, int n2) {
        SimData simData = this.m_simData;
        if (this.checkKeys(n, n2, 3072, 0)) {
            this.stateTransition(5);
            return;
        }
        if (this.m_infoScreenState == 9) {
            if (this.checkKeys(n, n2, 0, 4)) {
                this.stateTransitionInfoScreen(0);
                return;
            }
            int n3 = simData.getRelationshipNthCount();
            if (this.checkKeys(n, n2, 32784, 0)) {
                this.m_infoScreenSimSelectedIndex = (this.m_infoScreenSimSelectedIndex + n3 - 1) % n3;
                this.triggerLeftArrow();
                this.reloadInfoScreenSim();
            } else if (this.checkKeys(n, n2, 65600, 0)) {
                this.m_infoScreenSimSelectedIndex = (this.m_infoScreenSimSelectedIndex + 1) % n3;
                this.triggerRightArrow();
                this.reloadInfoScreenSim();
            }
        } else if (this.m_infoScreenState == 10) {
            if (this.checkKeys(n, n2, 0, 4)) {
                this.stateTransitionInfoScreen(6);
                return;
            }
            this.processKeysList(n, n2);
        } else {
            if (this.checkKeys(n, n2, 0, 4)) {
                this.stateTransitionInfoScreen(8);
                return;
            }
            switch (this.m_infoScreenState) {
                case 0: {
                    this.processKeysList(n, n2);
                    if (this.getListNum() <= 0 || !this.checkKeys(n, n2, 4128, 16)) break;
                    this.stateTransitionInfoScreen(9);
                    return;
                }
                case 3: {
                    this.processKeysList(n, n2);
                    if (simData.getDream() != -1 && simData.isDreamToPromisePossible() && this.checkKeys(n, n2, 4128, 8)) {
                        simData.dreamToPromise();
                        this.m_engine.wrapString(553, 1, this.m_uiInfoBoxWrapWidth);
                        this.m_engine.setSoftKeys(this.m_engine.getRightCommandID(), 0);
                    }
                    if (!this.m_engine.m_debugCheatMenuEnabled || !this.checkKeys(n, n2, 1, 0)) break;
                    simData.cheatMenuHook(23);
                    break;
                }
                case 4: 
                case 5: {
                    this.processKeysList(n, n2);
                    break;
                }
                case 6: {
                    int n4;
                    if (this.processKeysList(n, n2)) {
                        this.setupSoftkeys();
                    }
                    if ((n4 = this.getInfoItem()) == -1 || (this.m_simWorld.getItemFlags(n4) & 0x800) == 0 || !this.checkKeys(n, n2, 4128, 16)) break;
                    this.stateTransitionInfoScreen(10);
                    break;
                }
            }
            if (this.checkKeys(n, n2, 32784, 0)) {
                --this.m_infoScreenState;
                if (this.m_infoScreenState < 0) {
                    this.m_infoScreenState = 6;
                }
                this.stateTransitionInfoScreen(this.m_infoScreenState);
                this.triggerLeftArrow();
            } else if (this.checkKeys(n, n2, 65600, 0)) {
                ++this.m_infoScreenState;
                if (this.m_infoScreenState > 6) {
                    this.m_infoScreenState = 0;
                }
                this.stateTransitionInfoScreen(this.m_infoScreenState);
                this.triggerRightArrow();
            }
        }
    }

    private void updateInfoScreen(int n) {
        this.updateLeftRightArrows(n);
    }

    private void renderInfoScreen(Graphics graphics) {
        switch (this.m_infoScreenState) {
            case 0: {
                this.drawUIFullScreen(graphics, 14);
                break;
            }
            case 1: {
                this.renderInfoScreenCareer(graphics, false);
                break;
            }
            case 2: {
                this.drawUIFullScreen(graphics, 17);
                break;
            }
            case 3: {
                this.drawUIFullScreen(graphics, 11);
                break;
            }
            case 4: {
                this.renderInfoScreenStatus(graphics);
                break;
            }
            case 5: {
                this.renderInfoScreenPersona(graphics);
                break;
            }
            case 6: {
                this.drawUIFullScreen(graphics, 12);
                break;
            }
            case 9: {
                this.renderInfoScreenNPCRelationship(graphics);
                break;
            }
            case 10: {
                this.renderInfoScreenRecipe(graphics);
            }
        }
        this.renderSoftkeyBar(graphics);
    }

    private void initListRelationships() {
        this.initList(this.m_simData.getRelationshipNthCount(), 16, this.m_infoScreenSimSelectedIndex);
    }

    public void drawListRelationships(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        if (this.getListNum() == 0) {
            int n9 = n + (n3 >> 1);
            int n10 = n2 + 3;
            appEngine.drawString(671, 1, n9, n10, 17);
            return;
        }
        if (this.m_npcLongestStringLength == 0) {
            n8 = 0;
            n7 = simData.getSimCount();
            for (int i = 1; i < n7; ++i) {
                n6 = simData.getSimName(i);
                n5 = appEngine.getStringWidth(n6, 1);
                if (n5 <= n8) continue;
                n8 = n5;
            }
            this.m_npcLongestStringLength = n8;
        }
        n8 = n3 - this.m_npcLongestStringLength - 9;
        n7 = n + n3 - n8 - 3;
        n6 = n + 3;
        n5 = n2;
        int n11 = this.getListCursor();
        for (int i = this.getListOffset(); n5 < n2 + n4 && i < this.getListNum(); ++i) {
            int n12 = simData.getRelationshipNthItem(i);
            int n13 = simData.getSimName(n12);
            if (i == n11) {
                this.drawListSelect(graphics, n, n5, n3, 16, n2 + n4, 82, i);
            }
            appEngine.drawString(n13, 1, n6, n5 + 5, 20);
            int n14 = simData.getRelState(n12);
            int n15 = 65536;
            this.drawRelBar(graphics, n7, n5 + 2, n8, n14, n15, true);
            this.drawListDivider(graphics, n, n5 += 16, n3);
        }
    }

    private void renderInfoScreenCareer(Graphics graphics, boolean bl) {
        int n;
        SimData simData = this.m_simData;
        int n2 = -1;
        int n3 = 0;
        if (bl) {
            n = 8;
            n2 = this.m_jobOfferCareer;
            n3 = this.m_jobOfferLevel;
        } else {
            n2 = simData.getSimCareer(0);
            if (n2 == -1) {
                n = 5;
            } else {
                n = 6;
                n3 = simData.getSimCareerLevel(0);
            }
        }
        int n4 = 122;
        if (n2 == -1) {
            if (bl) {
                n4 = 635;
            }
        } else {
            int n5;
            AppEngine appEngine = this.m_engine;
            if (bl) {
                n4 = n2 == simData.getSimCareer(0) ? 637 : 636;
            }
            this.setUIPlaceholderString(1, n4);
            this.setUIPlaceholderString(2, simData.getCareerDescString(n2));
            this.setUIPlaceholderString(3, simData.getCareerLevelDescString(n2, n3));
            int n6 = simData.getCareerLevelIncome(n2, n3);
            SDKString sDKString = appEngine.clearStringBuffer();
            appEngine.appendMoneyToBuffer(n6);
            appEngine.dynamicString(-9, sDKString);
            this.setUIPlaceholderString(4, -9);
            int n7 = simData.getCareerRabbitHole(n2);
            this.setUIPlaceholderString(5, this.m_simWorld.getObjectStringId(n7));
            int n8 = simData.getCareerBoss(n2);
            this.setUIPlaceholderString(6, simData.getSimName(n8));
            int n9 = simData.getCareerLevelFlags(n2, n3);
            sDKString = appEngine.clearStringBuffer();
            SDKString sDKString2 = appEngine.getString(30);
            int n10 = 0;
            for (n5 = 0; n5 < SimData.DAY_FLAGS.length; ++n5) {
                if ((n9 & SimData.DAY_FLAGS[n5]) == 0) continue;
                if (n10 > 0) {
                    appEngine.appendSDKStringToBuffer(sDKString2);
                }
                appEngine.appendStringIdToBuffer(SimData.DAY_STRINGS[n5]);
                ++n10;
            }
            appEngine.dynamicString(-8, sDKString);
            this.setUIPlaceholderString(7, -8);
            sDKString = appEngine.clearStringBuffer();
            n5 = simData.getCareerLevelHoursStart(n2, n3);
            appEngine.appendTimeToBuffer24Hour(n5);
            appEngine.appendStringIdToBuffer(669);
            int n11 = simData.getCareerLevelHoursEnd(n2, n3);
            appEngine.appendTimeToBuffer24Hour(n11);
            appEngine.dynamicString(-7, sDKString);
            this.setUIPlaceholderString(8, -7);
            if (!bl) {
                sDKString = appEngine.clearStringBuffer();
                int n12 = 0;
                for (int i = 0; i < SimData.PERK_FLAGS.length; ++i) {
                    if ((n9 & SimData.PERK_FLAGS[i]) == 0) continue;
                    appEngine.appendStringIdToBuffer(SimData.PERK_STRINGS[i]);
                    ++n12;
                }
                if (n12 > 0) {
                    appEngine.dynamicString(-6, sDKString);
                    this.setUIPlaceholderString(9, -6);
                } else {
                    this.setUIPlaceholderString(9, 671);
                }
            }
        }
        this.setUIPlaceholderString(1, n4);
        this.drawUIFullScreen(graphics, n);
    }

    public int drawUISkill(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        if (this.m_skillLongestStringLength == 0) {
            n10 = simData.getSkillCount();
            n9 = 0;
            for (n8 = 0; n8 < n10; ++n8) {
                n7 = simData.getSkillDesc(n8);
                n6 = appEngine.getStringWidth(n7, 1);
                if (n6 <= n9) continue;
                n9 = n6;
            }
            this.m_skillLongestStringLength = n9;
        }
        if (graphics != null) {
            n10 = simData.getSkillDesc(n5);
            n9 = simData.getSkillLevel(n5);
            n8 = simData.getSkillLevelDesc(n5);
            n7 = n3 - this.m_skillLongestStringLength - 3;
            n6 = n + n3 - n7;
            appEngine.drawString(n10, 1, n, n2 + 1, 20);
            this.drawSkillBar(graphics, n6, n2 + 1, n7, n9);
            appEngine.drawString(n8, 1, n6, (n2 += this.m_uiTextHeight) + 1, 20);
        }
        return this.m_uiTextHeight << 1;
    }

    private void drawSkillBar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n4 - 0 >> 10;
        int n8 = 320;
        int n9 = n3 - 2;
        int n10 = n9 * n7 / n8;
        int n11 = AnimationManager.getAnimFrameHeight(666, 0);
        int n12 = n + 1;
        int n13 = n2 + 1;
        int n14 = n11 + 2;
        AnimationManager.setColor(graphics, 77);
        graphics.drawRect(n, n2, n3 - 1, n14 - 1);
        int n15 = graphics.getClipX();
        int n16 = graphics.getClipY();
        int n17 = graphics.getClipWidth();
        int n18 = graphics.getClipHeight();
        graphics.setClip(n12, n16, n9, n18);
        AnimationManager.drawAnimFrame(graphics, 666, 0, n12, n13);
        graphics.setClip(n15, n16, n17, n18);
        AnimationManager.setColor(graphics, 77);
        for (n6 = 1; n6 < 5; ++n6) {
            n5 = n + n3 * n6 / 5;
            graphics.fillRect(n5, n13, 1, n11);
        }
        graphics.setClip(n12, n16, n10, n18);
        AnimationManager.drawAnimFrame(graphics, 667, 0, n12, n13);
        AnimationManager.setColor(graphics, 76);
        for (n6 = 1; n6 < 5; ++n6) {
            n5 = n + n3 * n6 / 5;
            graphics.fillRect(n5, n13, 1, n11);
        }
        graphics.setClip(n15, n16, n17, n18);
    }

    private void initListDreams() {
        this.initList(4, 27, -1);
    }

    public int drawUICurrentDream(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics != null) {
            int n5 = n + 10;
            int n6 = AnimationManager.getAnimFrameHeight(575, 0);
            int n7 = 13 - (n6 >> 1);
            int n8 = n3 - 30;
            int n9 = n + n3 - n8;
            SimData simData = this.m_simData;
            int n10 = simData.getDream();
            int n11 = simData.getDreamDescString(n10);
            int n12 = 598;
            if (n10 == -1) {
                n12 = 203;
            }
            this.m_engine.drawWrappedStringChunk(19, n11, 1, n8, n9, n2 + 13 + 2, 6);
            AnimationManager.drawAnimFrame(graphics, n12, 0, n5, n2 + n7);
        }
        return 30;
    }

    private void renderInfoScreenStatus(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        this.setUIPlaceholderString(1, simData.getMoodDescStringId());
        int n = simData.getTotalDays();
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendIntToBuffer(n);
        appEngine.dynamicString(-9, sDKString);
        this.setUIPlaceholderString(2, -9);
        sDKString = appEngine.clearStringBuffer();
        appEngine.appendMoneyToBuffer(simData.getMoneySpent());
        appEngine.dynamicString(-8, sDKString);
        this.setUIPlaceholderString(3, -8);
        this.drawUIFullScreen(graphics, 10);
    }

    private void initListStatus() {
        this.initList(this.m_simData.getMotiveCount(), 17, -1);
    }

    public void drawListStatus(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        int n8 = simData.getMotiveCount();
        if (this.m_motiveLongestStringLength == 0) {
            n7 = 0;
            for (n6 = 0; n6 < n8; ++n6) {
                n5 = simData.getMotiveDescString(n6);
                int n9 = appEngine.getStringWidth(n5, 1);
                if (n9 <= n7) continue;
                n7 = n9;
            }
            this.m_motiveLongestStringLength = n7;
        }
        n7 = n + 3;
        n6 = n3 - this.m_motiveLongestStringLength - 9;
        n5 = n + n3 - n6 - 3;
        int n10 = n2;
        for (int i = this.getListOffset(); n10 < n2 + n4 && i < this.getListNum(); ++i) {
            short s = simData.getMotiveDescString(i);
            appEngine.drawString(s, 1, n7, n10 + 5, 20);
            int n11 = simData.getMotiveLevel(i);
            this.drawStatusBar(graphics, n5, n10 + 5, n6, n11);
            this.drawListDivider(graphics, n, n10 += 17, n3);
        }
    }

    private void initListPersonaGoals() {
        this.initList(this.m_simData.getPersonaNthGoalCount(), 27, -1);
    }

    private void renderInfoScreenPersona(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SDKString sDKString = appEngine.getSimName();
        appEngine.dynamicString(-9, sDKString);
        this.setUIPlaceholderString(1, -9);
        short s = this.m_simData.getPersonaDescString(this.m_simData.getPersona());
        this.setUIPlaceholderString(2, s);
        this.drawUIFullScreen(graphics, 16);
    }

    private void initListInventory() {
        int n = 0;
        if (this.m_infoScreenState == 10) {
            n = this.m_infoScreenItemSelectedIndex;
        }
        this.initList(this.m_simData.getInventoryNthCount(), 18, n);
    }

    private void initListRecipe() {
        this.m_infoScreenItemSelectedIndex = this.getListCursor();
        this.m_infoScreenRecipeSelected = this.m_simWorld.getRecipeForItem(this.getInfoItem());
        this.initList(this.m_simWorld.getRecipeIngredientCount(this.m_infoScreenRecipeSelected), 18, -1);
    }

    private int getInfoItem() {
        return this.m_simData.getInventoryNthItem(this.getListCursor());
    }

    public void drawListInventory(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        SimWorld simWorld = this.m_simWorld;
        int n6 = n + 3 + 8;
        int n7 = n + 3 + 16 + 3;
        int n8 = n7 + 3;
        int n9 = n + n3 - 3;
        int n10 = n9 - 25;
        AnimationManager.setColor(graphics, 75);
        graphics.fillRect(n7, n2, 1, n4);
        graphics.fillRect(n10, n2, 1, n4);
        int n11 = n2;
        int n12 = this.getListCursor();
        for (int i = this.getListOffset(); n11 < n2 + n4 && i < this.getListNum(); ++i) {
            int n13;
            if (n5 == 5) {
                n13 = simData.getInventoryNthItem(i);
            } else if (n5 == 9) {
                n13 = simWorld.getItemNthItem(this.m_shoppingObjectType, i);
            } else {
                AppEngine.ASSERT(n5 == 6, "argh!");
                n13 = simWorld.getRecipeIngredient(this.m_infoScreenRecipeSelected, i);
            }
            int n14 = simWorld.getItemDescString(n13);
            int n15 = simWorld.getItemIcon(n13);
            if (i == n12) {
                this.drawListSelect(graphics, n, n11, n3, 18, n2 + n4, 82, i);
            }
            AnimationManager.drawAnimFrame(graphics, n15, 0, n6, n11 + 9);
            appEngine.drawString(n14, 1, n8, n11 + 9, 6);
            int n16 = simData.getInventoryCount(n13);
            if (n16 > 0 || n5 == 6) {
                SDKString sDKString = appEngine.clearStringBuffer();
                appEngine.appendIntToBuffer(n16);
                appEngine.appendStringIdToBuffer(30);
                if (n5 == 6) {
                    appEngine.appendIntToBuffer(1);
                } else {
                    appEngine.appendIntToBuffer(simWorld.getItemMaxInventory(n13));
                }
                appEngine.drawString(sDKString, 1, n9, n11 + 9, 10);
            }
            this.drawListDivider(graphics, n, n11 += 18, n3);
        }
    }

    private void renderInfoScreenRecipe(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = this.m_simWorld;
        AnimationManager.setColor(graphics, 77);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
        int n = this.drawDropDownTitle(graphics, 4, appEngine.getWidth() - 8, 129);
        int n2 = simWorld.getRecipeItem(this.m_infoScreenRecipeSelected);
        int n3 = simWorld.getItemDescString(n2);
        this.setUIPlaceholderString(1, n3);
        this.drawUIFullScreen(graphics, 13, n);
    }

    public int getInfoSim() {
        return this.m_simData.getRelationshipNthItem(this.m_infoScreenSimSelectedIndex);
    }

    private void renderInfoScreenNPCRelationship(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        int n = this.getInfoSim();
        AnimationManager.setColor(graphics, 77);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
        int n2 = this.drawDropDownTitle(graphics, 4, appEngine.getWidth() - 8, 123);
        this.setUIPlaceholderString(1, simData.getSimName(n));
        int n3 = simData.getSimPartner(n);
        if (n3 == -1) {
            this.setUIPlaceholderString(2, 27);
            this.setUIPlaceholderString(3, 27);
        } else {
            this.setUIPlaceholderString(2, 652);
            this.setUIPlaceholderString(3, simData.getSimName(n3));
        }
        int n4 = simData.getSimCareer(n);
        int n5 = simData.getCareerDescString(n4);
        this.setUIPlaceholderString(4, n5);
        this.drawUIFullScreen(graphics, 15, n2);
    }

    public int drawUIRelationship(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics != null) {
            SimData simData = this.m_simData;
            int n5 = this.getInfoSim();
            int n6 = n2;
            int n7 = simData.getRelState(n5);
            this.drawRelBar(graphics, n, n6, n3, n7, 65536, true);
            n6 += 15;
            int[] nArray = this.m_tempInt10;
            simData.getRelationshipLevels(n5, nArray);
            for (int i = 0; i < 4 && (n7 = nArray[i]) != -1; i += 2) {
                int n8 = nArray[i + 1];
                this.drawRelBar(graphics, n, n6 += 3, n3, n7, n8, false);
                n6 += 15;
            }
        }
        return 51;
    }

    public void drawUINPCPortrait(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getInfoSim();
        int n6 = n + n3 - 20;
        int n7 = n2 + n4 - 1;
        this.drawHUDSim(graphics, n6, n7, n5, true, 1);
    }

    public void drawUIPlayerPortrait(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 20;
        int n6 = n2 + n4 - 1;
        this.drawHUDSim(graphics, n5, n6, 0, true, 0);
    }

    private void drawAnimBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        int n11 = graphics.getClipWidth();
        int n12 = graphics.getClipHeight();
        int n13 = MathExt.Fmul(n3, n4);
        int n14 = AnimationManager.getAnimFrameWidth(n5, n8);
        int n15 = AnimationManager.getAnimFrameWidth(n6, n8);
        int n16 = Math.min(n3 - n15 - n14, n13 - n14);
        graphics.setClip(n, n10, n13, n12);
        AnimationManager.drawAnimFrame(graphics, n5, n8, n, n2);
        AnimationManager.drawAnimFrame(graphics, n6, n8, n + n3 - n15, n2);
        graphics.setClip(n + n14, n10, n16, n12);
        AnimationManager.drawAnimFrame(graphics, n7, n8, n + n14, n2);
        graphics.setClip(n9, n10, n11, n12);
    }

    private void drawStatusBar(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawAnimBar(graphics, n, n2, n3, 65536, 673, 674, 672, 0);
        int n5 = n4 < 0x230000 ? 2 : 1;
        n4 = MathExt.Fdiv(n4, 0x640000);
        this.drawAnimBar(graphics, n, n2, n3, n4, 673, 674, 672, n5);
    }

    private void drawRelBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7 = this.m_simData.getRelStateFlags(n4);
        int n8 = (n7 & 2) != 0 ? 1 : ((n7 & 1) != 0 ? 3 : 2);
        int n9 = bl ? n8 : 0;
        this.drawAnimBar(graphics, n, n2, ++n3, 65536, 664, 665, 663, n9);
        if (!bl) {
            n6 = n8 + 3;
            this.drawAnimBar(graphics, n, n2, n3, n5, 664, 665, 663, n6);
        }
        n6 = this.m_simData.getRelStateDescString(n4);
        int n10 = n + (n3 >> 1);
        int n11 = n2 + 0;
        int n12 = bl ? 0 : 1;
        this.m_engine.drawString(n6, n12, n10, n11, 17);
    }

    public void showJobOffer(int n, int n2, boolean bl) {
        this.hideQuickLinks();
        this.m_jobOfferCareer = n;
        this.m_jobOfferLevel = n2;
        if (n == -1) {
            this.prepareGenericMessageBox(559, 635);
        } else {
            if (!bl && !this.m_simData.careerRequirementsMet(n, n2)) {
                this.showJobRaiseFail(n, n2);
                return;
            }
            int n3 = this.m_simData.getSimCareer(0);
            int n4 = n3 == -1 ? 638 : (n3 == n ? 640 : 639);
            this.m_engine.wrapString(n4, 1, this.m_uiMessageBoxWrapWidth);
        }
        this.stateTransition(10);
    }

    private void processKeysJobOffer(int n, int n2) {
        int n3;
        int n4 = this.m_jobOfferCareer == -1 ? 4128 : 0;
        int n5 = n3 = n4 == 0 ? 4128 : 0;
        if (this.checkKeys(n, n2, n4, 524)) {
            this.stateTransition(5);
        } else if (this.checkKeys(n, n2, n3, 256)) {
            SimData simData = this.m_simData;
            int n6 = simData.getSimCareer(0);
            int n7 = simData.getSimCareerLevel(0);
            int n8 = this.m_jobOfferCareer;
            int n9 = this.m_jobOfferLevel;
            simData.careerAcceptJob(n8, n9);
            if (n6 != n8 && n8 != -1) {
                simData.dreamCompleteEvent(27);
            }
            if (n6 == n8 && n7 < n9) {
                simData.dreamCompleteEvent(61);
            }
            if (n9 == simData.getCareerLevelCount(n8) - 1) {
                simData.dreamCompleteEvent(62);
            }
        }
    }

    private void renderJobOffer(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        int n = this.m_jobOfferCareer;
        if (n != -1) {
            this.renderInfoScreenCareer(graphics, true);
        } else {
            this.renderMain(graphics);
            appEngine.renderBackgroundDim(graphics);
            this.drawGenericMessageBox(graphics);
        }
        this.renderSoftkeyBar(graphics);
    }

    public void finishWork() {
        if (this.m_engine.randPercent() < 5) {
            int n = this.m_simData.getCareerDeathString();
            this.killPlayer(n);
        } else {
            this.stateTransition(11);
        }
    }

    public void processKeysPay(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 12)) {
            SimData simData = this.m_simData;
            if (simData.careerAutoPromotionDue()) {
                int n3 = simData.getSimCareer(0);
                int n4 = simData.getSimCareerLevel(0);
                this.showJobOffer(n3, n4 + 1, false);
            } else if (this.m_engine.randPercent() < 15) {
                int n5 = this.m_simData.getChanceCardForWork();
                this.triggerChanceCard(n5);
            } else {
                this.stateTransition(5);
            }
        }
    }

    private void renderPay(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        this.setUIPlaceholderString(1, 710);
        this.setUIPlaceholderString(2, 655);
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendMoneyToBuffer(this.m_payIncome);
        appEngine.dynamicString(-9, sDKString);
        this.setUIPlaceholderString(3, -9);
        this.renderMain(graphics);
        appEngine.renderBackgroundDim(graphics);
        this.drawUIFullScreen(graphics, 20);
        this.renderSoftkeyBar(graphics);
    }

    public void showJobRaiseFail(int n, int n2) {
        SimData simData = this.m_simData;
        this.m_jobOfferCareer = n;
        this.m_jobOfferLevel = n2;
        int n3 = simData.getCareerFailString(n);
        this.m_engine.wrapString(n3, 1, this.m_uiMessageBoxWrapWidth);
        this.stateTransition(12);
    }

    private void renderRaiseFailure(Graphics graphics) {
        SDKString sDKString;
        SimData simData = this.m_simData;
        AppEngine appEngine = this.m_engine;
        this.renderMain(graphics);
        this.m_engine.renderBackgroundDim(graphics);
        int n = this.m_jobOfferCareer;
        int n2 = this.m_jobOfferLevel;
        byte[] byArray = simData.getCareerLevelRequirements(n, n2);
        byte by = byArray[0];
        byte by2 = byArray[1];
        byte by3 = byArray[2];
        byte by4 = byArray[3];
        int n3 = simData.getSimName(simData.getCareerBoss(n));
        this.setUIPlaceholderString(0, n3);
        this.setUIPlaceholderString(1, n3);
        int n4 = 1;
        if (by != -1) {
            n4 = 20;
            this.setUIPlaceholderString(2, simData.getRequimentName(by));
            sDKString = appEngine.clearStringBuffer();
            appEngine.appendIntToBuffer(simData.getRequirementValue(by));
            appEngine.appendStringIdToBuffer(30);
            appEngine.appendIntToBuffer(by2);
            appEngine.dynamicString(-9, sDKString);
            this.setUIPlaceholderString(3, -9);
        }
        if (by3 != -1) {
            n4 = 21;
            this.setUIPlaceholderString(4, simData.getRequimentName(by3));
            sDKString = appEngine.clearStringBuffer();
            appEngine.appendIntToBuffer(simData.getRequirementValue(by3));
            appEngine.appendStringIdToBuffer(30);
            appEngine.appendIntToBuffer(by4);
            appEngine.dynamicString(-8, sDKString);
            this.setUIPlaceholderString(5, -8);
        }
        this.drawUIFullScreen(graphics, n4);
        this.renderSoftkeyBar(graphics);
    }

    private void processKeysRaiseFailure(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 8)) {
            this.stateTransition(5);
        }
    }

    public void showQuitJob() {
        this.m_quitJobConfirmed = false;
        SimData simData = this.m_simData;
        int n = simData.getCareerLevelDescString(simData.getSimCareer(0), simData.getSimCareerLevel(0));
        this.prepareGenericMessageBox(712, n);
        this.stateTransition(13);
    }

    public void processKeysQuitJob(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 524)) {
            this.stateTransition(5);
        } else if (this.checkKeys(n, n2, 0, 256)) {
            this.m_simData.careerAcceptJob(-1, 0);
            this.m_quitJobConfirmed = true;
            this.setupSoftkeys();
            this.prepareGenericMessageBox(713, 370);
        }
    }

    private void renderQuitJob(Graphics graphics) {
        this.renderMain(graphics);
        this.m_engine.renderBackgroundDim(graphics);
        this.drawGenericMessageBox(graphics);
        this.renderSoftkeyBar(graphics);
    }

    public void showNewDream() {
        this.m_showNewDream = true;
    }

    public void showExpiredDream(int n) {
        this.showTickerMessage(547, this.m_simData.getDreamDescString(n));
    }

    private void showNewDreamMessage() {
        this.hideQuickLinks();
        this.m_engine.vibrate();
        int n = 551;
        if (!this.m_simData.isDreamToPromisePossible()) {
            n = 552;
        }
        this.m_engine.wrapString(n, 1, this.m_uiInfoBoxWrapWidth);
        this.stateTransition(14);
    }

    private void renderNewDream(Graphics graphics) {
        this.renderMain(graphics);
        this.m_engine.renderBackgroundDim(graphics);
        this.drawUIFullScreen(graphics, 24);
        this.renderSoftkeyBar(graphics);
    }

    private void processKeysNewDream(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 196)) {
            this.stateTransition(5);
        } else if (this.checkKeys(n, n2, 4128, 8)) {
            if (this.m_simData.isDreamToPromisePossible()) {
                this.m_simData.dreamToPromise();
            }
            this.stateTransition(5);
        }
    }

    public void showNewPromise(int n) {
        this.m_dreamAnimPlayers[n].startAnim(599, 16);
    }

    public void showGoalCompleted(int n, int n2) {
        this.showTickerMessage(548, this.m_simData.getDreamDescString(n));
        this.getPlayerSim().queueSimAction(9, null, 0, 0);
        if (n2 != -1) {
            this.m_dreamAnimPlayers[n2].startAnim(600, 16);
        }
    }

    public void unlockBonus() {
        this.m_showBonusUnlocked = true;
    }

    public void showDoorKnock(int n) {
        this.showTickerMessage(this.m_simData.getSimName(n), 544);
    }

    public void showGetItem(int n, int n2, int n3, int n4) {
        this.m_showGetItem = n;
        this.m_showGetItemQty = n2;
        this.m_showGetItemTitle = n3;
        if (this.m_simData.getInventoryCount(n) == this.m_simWorld.getItemMaxInventory(n)) {
            n4 = 724;
        }
        this.m_showGetItemMessage = n4;
    }

    private void renderShowGetItem(Graphics graphics) {
        this.renderMain(graphics);
        this.m_engine.renderBackgroundDim(graphics);
        this.drawUIFullScreen(graphics, 25);
        this.renderSoftkeyBar(graphics);
    }

    private void processKeysShowGetItem(int n, int n2) {
        if (this.checkKeys(n, n2, 4128, 8)) {
            this.m_showGetItem = -1;
            this.stateTransition(5);
        }
    }

    public int drawUIGetItem(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics != null) {
            SimWorld simWorld = this.m_simWorld;
            AppEngine appEngine = this.m_engine;
            int n5 = this.m_showGetItem;
            int n6 = n + 3 + 8;
            int n7 = n2 + 9;
            int n8 = n + 3 + 16 + 3;
            int n9 = n8 + 3;
            int n10 = n2 + 9;
            int n11 = n + n3 - 3;
            int n12 = simWorld.getItemIcon(n5);
            AnimationManager.drawAnimFrame(graphics, n12, 0, n6, n7);
            SDKString sDKString = appEngine.clearStringBuffer();
            if (this.m_showGetItemQty != 1) {
                appEngine.appendIntToBuffer(this.m_showGetItemQty);
                appEngine.appendStringIdToBuffer(725);
            }
            appEngine.appendStringIdToBuffer(simWorld.getItemDescString(n5));
            this.m_engine.drawString(sDKString, 1, n9, n10, 6);
            sDKString = appEngine.clearStringBuffer();
            appEngine.appendIntToBuffer(this.m_simData.getInventoryCount(n5));
            appEngine.appendStringIdToBuffer(30);
            appEngine.appendIntToBuffer(simWorld.getItemMaxInventory(n5));
            appEngine.drawString(sDKString, 1, n11, n10, 10);
        }
        return 18;
    }

    public void DEBUG_EVENT(String string) {
    }

    public boolean isPlayerInactive() {
        return this.m_simInactivityTimer > 20000;
    }

    private void resetPlayerInactivity() {
        this.m_simInactivityTimer = 0;
        this.getPlayerSim().clearNeedFlags();
    }

    private void updateEventsHouse(int n) {
        int n2;
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        this.m_simAIEventTimer += n;
        int n3 = 3000;
        if (simData.getFastforward()) {
            n3 >>= 1;
        }
        if (this.m_simAIEventTimer > n3) {
            int n4;
            MapObject mapObject;
            int n5;
            this.m_simAIEventTimer = 0;
            int n6 = this.m_simWorld.getHouseId();
            n2 = simData.getSimCount();
            for (int i = 1; i < n2; ++i) {
                n5 = simData.getTimeFlags(i);
                MapObjectSim mapObjectSim = this.findSim(i);
                if (mapObjectSim != null) {
                    if ((n5 & 7) != 0) {
                        mapObjectSim.setNeedFlag(1);
                    }
                    if ((n5 & 0x10) == 0) continue;
                    if (n6 == simData.getSimHome(i)) {
                        mapObjectSim.setNeedFlag(4);
                        continue;
                    }
                    this.DEBUG_EVENT("adding leave (for sleep) flag");
                    mapObjectSim.setNeedFlag(256);
                    continue;
                }
                if ((n5 & 8) == 0 || n6 != simData.getSimHome(i) || this.nextAvailableBank() == -1) continue;
                mapObject = this.findRandomObjectByType(4);
                AppEngine.ASSERT(mapObject != null, "no town object!");
                mapObjectSim = (MapObjectSim)this.createObjectOnObjectInterestPoint(1, mapObject, i);
                n4 = (appEngine.randPercent() < 50 ? 2 : 0) | (appEngine.randPercent() < 50 ? 8 : 0) | (appEngine.randPercent() < 50 ? 64 : 0) | (appEngine.randPercent() < 50 ? 32 : 0) | (appEngine.randPercent() < 50 ? 16 : 0);
                mapObjectSim.setNeedFlag(n4);
            }
            MapObjectSim[] mapObjectSimArray = this.getSimObjects();
            for (n5 = 0; n5 < mapObjectSimArray.length; ++n5) {
                int n7 = appEngine.rand(0, mapObjectSimArray.length - 1);
                mapObject = mapObjectSimArray[n7];
                if (!((MapObjectSim)mapObject).isIdle() || !mapObject.occupiedIsEmpty() || mapObject.getType() == 0) continue;
                n4 = (appEngine.randPercent() < 50 ? 2 : 0) | (appEngine.randPercent() < 25 ? 8 : 0) | (appEngine.randPercent() < 50 ? 64 : 0) | (appEngine.randPercent() < 25 ? 16 : 0) | (appEngine.randPercent() < 60 ? 32 : 0);
                if (n6 != simData.getSimHome(mapObject.getId())) {
                    n4 &= 0xFFFFFFED;
                }
                ((MapObjectSim)mapObject).setNeedFlag(n4);
            }
        }
        MapObjectSim mapObjectSim = this.getPlayerSim();
        if (appEngine.getAutonomityEnabled()) {
            if (this.isPlayerInactive()) {
                if (mapObjectSim.isIdle()) {
                    n2 = simData.getPlayerNeedFlags();
                    if (this.m_simWorld.getHouseId() != 0 && !simData.getSimCurRelStateFlags(0, 1)) {
                        n2 |= 0x20;
                    }
                    mapObjectSim.setNeedFlag(n2);
                }
            } else {
                this.m_simInactivityTimer += n;
            }
        } else {
            mapObjectSim.clearNeedFlags();
        }
    }

    private void updateEventsZoomMode(int n) {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        this.m_simAIEventTimer += n;
        int n2 = 5000;
        if (simData.getFastforward()) {
            n2 >>= 1;
        }
        if (this.m_simAIEventTimer > n2) {
            int n3;
            this.m_simAIEventTimer = 0;
            this.DEBUG_EVENT("zoom map event");
            MapObjectSim[] mapObjectSimArray = this.getSimObjects();
            int n4 = 50;
            if (mapObjectSimArray.length >= 2) {
                n4 = 5;
            }
            boolean bl = false;
            int n5 = simData.getSimCount();
            int n6 = 4;
            for (n3 = 0; n3 < n6; ++n3) {
                int n7 = appEngine.rand(1, n5 - 1);
                MapObjectSim mapObjectSim = this.findSim(n7);
                int n8 = simData.getTimeFlags(n7);
                if (mapObjectSim != null) {
                    if ((n8 & 7) != 0) {
                        mapObjectSim.setNeedFlag(1);
                    }
                    if ((n8 & 0x10) == 0) continue;
                    this.DEBUG_EVENT("adding leave (for sleep) flag");
                    mapObjectSim.setNeedFlag(256);
                    continue;
                }
                if ((n8 & 8) == 0 || (n8 & 0x10) != 0 || this.nextAvailableBank() == -1 || bl) continue;
                bl = true;
                if (appEngine.randPercent() >= n4) continue;
                MapObject mapObject = this.findRandomObjectByType(4);
                AppEngine.ASSERT(mapObject != null, "no town object!");
                mapObjectSim = (MapObjectSim)this.createObjectOnObjectInterestPoint(1, mapObject, n7);
                mapObjectSim.setNeedFlag(32);
            }
            for (n3 = 0; n3 < mapObjectSimArray.length; ++n3) {
                MapObjectSim mapObjectSim = mapObjectSimArray[n3];
                if (mapObjectSim.getId() == 0) continue;
                mapObjectSim.setNeedFlag(32);
            }
        }
    }

    private void updateEventsMapMode(int n) {
        this.m_simAIEventTimer += n;
        if (this.m_simAIEventTimer > 5000) {
            this.m_simAIEventTimer = 0;
            SimData simData = this.m_simData;
            SimWorld simWorld = this.m_simWorld;
            int n2 = this.m_engine.rand(1, simData.getSimCount() - 1);
            MapObjectSim mapObjectSim = this.findSim(n2);
            if (mapObjectSim == null) {
                int n3 = simData.getSimHome(n2);
                int n4 = simWorld.getHouseMacroObject(n3);
                MapObject mapObject = this.findRandomObjectByType(n4);
                AppEngine.ASSERT(mapObject != null, "can't find an NPC house: " + n3);
                mapObjectSim = (MapObjectSim)this.createObjectOnObjectInterestPoint(1, mapObject, n2);
            }
            if (mapObjectSim.isIdle()) {
                MapObject mapObject = this.findRandomMapDestination();
                mapObjectSim.beginSimAction(108, mapObject);
            }
        }
    }

    private void updateAmbientSounds(int n, int n2, short[] sArray) {
        this.m_ambientEventTimer += n;
        if (this.m_ambientEventTimer > n2) {
            this.m_ambientEventTimer = 0;
            int n3 = this.m_engine.rand(0, sArray.length - 1);
            this.m_engine.getSoundManager().playSound(sArray[n3]);
        }
    }

    private MapObject findRandomMapDestination() {
        MapObject[] mapObjectArray = this.getObjects();
        AppEngine.ASSERT(mapObjectArray.length <= 257, "LGC isn't big enough for destination list");
        int n = this.m_engine.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[n];
            if (mapObject.getFlag(2048)) {
                return mapObject;
            }
            while ((n = (1543 * n + 3571) % 257) >= mapObjectArray.length) {
            }
        }
        return null;
    }

    public void putSimInBed(MapObjectSim mapObjectSim) {
        MapObject[] mapObjectArray = this.getObjects();
        MapObject mapObject = null;
        MapObject mapObject2 = null;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject3 = mapObjectArray[i];
            if (mapObject3.getParentType() == 4) {
                if (!mapObjectSim.setOccupied(mapObject3)) continue;
                mapObject = mapObject3;
                break;
            }
            if (mapObject3.getParentType() != 9 || !mapObject3.occupiedIsEmpty()) continue;
            mapObject2 = mapObject3;
        }
        if (mapObject == null) {
            mapObject = mapObject2;
        }
        if (mapObject != null) {
            mapObjectSim.gotoSleep(mapObject);
        } else if (mapObjectSim.getId() == 0) {
            mapObjectSim.beginSimAction(6, null);
        }
    }

    private void DEBUG_ADEVENT(String string) {
    }

    public void advertiseEvent(int n, MapObjectSim mapObjectSim, MapObject mapObject) {
        SimData simData = this.m_simData;
        int n2 = this.m_simWorld.getHouseId();
        MapObjectSim[] mapObjectSimArray = this.getSimObjects();
        int n3 = simData.getActionFlags(n);
        if (n == 23) {
            simData.setSimCurRelStateFlags(0, 1);
        }
        int n4 = mapObjectSimArray.length;
        for (int i = 0; i < n4; ++i) {
            boolean bl;
            MapObjectSim mapObjectSim2 = mapObjectSimArray[i];
            int n5 = mapObjectSim2.getId();
            if (n5 == 0 || mapObjectSim2 == mapObject || mapObjectSim2 == mapObjectSim || (n3 & 0x20000) != 0 && simData.getSimHome(n5) != n2 || !(bl = mapObjectSim2.respondToEvent(n, mapObjectSim, mapObject)) || (n3 & 0x400000) == 0) continue;
            this.DEBUG_ADEVENT("sim responded");
            return;
        }
    }

    private void processBasicAction(int n) {
        switch (n) {
            case 70: {
                this.hidePauseMenu();
                break;
            }
            case 73: {
                this.stateTransitionPauseMenu(2);
                break;
            }
            case 75: {
                this.stateTransitionPauseMenu(3);
                break;
            }
            case 77: {
                this.stateTransitionPauseMenu(4);
                break;
            }
            case 79: {
                this.stateTransitionPauseMenu(1);
                break;
            }
            case 63: {
                this.m_engine.stateTransitionSharedMenu(1);
                break;
            }
            case 64: {
                this.m_engine.stateTransitionSharedMenu(3);
                break;
            }
            case 120: {
                this.hideMenus();
                this.cancelSimAction();
                break;
            }
            case 121: {
                this.hideMenus();
                this.stateTransition(7);
                this.stateTransitionBuildMode(1);
                break;
            }
            case 335: {
                this.gotoMap();
                break;
            }
            case 131: {
                this.hideMenus();
                this.showQuickLinks();
                break;
            }
            case 334: {
                if (this.isMapMode()) {
                    this.hideMenus();
                    int n2 = this.m_simData.getSimCareer(0);
                    int n3 = this.m_simData.getCareerRabbitHole(n2);
                    MapObject mapObject = this.findRandomObjectByType(n3);
                    this.startPlayerAction(165, mapObject, 0, 0);
                    break;
                }
                this.gotoWork();
                break;
            }
            case 336: {
                this.goHome();
                break;
            }
            case 123: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(0);
                break;
            }
            case 122: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(1);
                break;
            }
            case 124: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(2);
                break;
            }
            case 125: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(3);
                break;
            }
            case 126: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(4);
                break;
            }
            case 127: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(5);
                break;
            }
            case 129: {
                this.hideMenus();
                this.stateTransition(8);
                this.stateTransitionInfoScreen(6);
                break;
            }
            case 130: {
                this.activateCheatMenu();
                break;
            }
            case 331: {
                this.hideMenus();
                this.stateTransitionBuildMode(9);
                break;
            }
            case 333: {
                this.hideMenus();
                this.m_cursorObject.buildRotate();
                this.m_simWorld.objectRotate(this.m_cursorObject.getId(), this.m_cursorObject.getFacingDir());
                break;
            }
            case 332: {
                this.hideMenus();
                this.stateTransitionBuildMode(11);
                break;
            }
            case 281: 
            case 282: {
                this.hideMenus();
                break;
            }
            default: {
                AppEngine.ASSERT(false, "action not implemented");
            }
        }
    }

    private void initActionQueue() {
        this.m_actionQueueSize = 0;
        if (this.m_actionQueueActions == null) {
            this.m_actionQueueActions = new int[3];
            this.m_actionQueueArg1s = new MapObject[3];
            this.m_actionQueueArg2s = new int[3];
            this.m_actionQueueArg3s = new int[3];
        }
        AppEngine.fillArray(this.m_actionQueueActions, -1);
        AppEngine.fillArray(this.m_actionQueueArg1s, null);
    }

    private void updateSimAction() {
        MapObjectSim mapObjectSim = this.getPlayerSim();
        int[] nArray = this.m_actionQueueActions;
        MapObject[] mapObjectArray = this.m_actionQueueArg1s;
        if (this.m_actionQueueSize > 0) {
            int n;
            if (mapObjectSim.isIdle()) {
                int n2;
                --this.m_actionQueueSize;
                for (n2 = 0; n2 < 2; ++n2) {
                    nArray[n2] = nArray[n2 + 1];
                    mapObjectArray[n2] = mapObjectArray[n2 + 1];
                    this.m_actionQueueArg2s[n2] = this.m_actionQueueArg2s[n2 + 1];
                    this.m_actionQueueArg3s[n2] = this.m_actionQueueArg3s[n2 + 1];
                }
                mapObjectArray[this.m_actionQueueSize] = null;
                if (this.m_actionQueueSize > 0) {
                    n2 = nArray[0];
                    MapObject mapObject = mapObjectArray[0];
                    int n3 = this.m_actionQueueArg2s[0];
                    int n4 = this.m_actionQueueArg3s[0];
                    this.startPlayerAction(n2, mapObject, n3, n4);
                }
            } else if (nArray[0] != mapObjectSim.getSimAction() && (this.m_simData.getActionFlags(n = mapObjectSim.getSimAction()) & 0x40000) == 0) {
                nArray[0] = n;
                mapObjectArray[0] = mapObjectSim.getSimActionArg1();
            }
        } else {
            int n = mapObjectSim.getSimAction();
            if ((this.m_simData.getActionFlags(n) & 0x40000) == 0) {
                nArray[0] = mapObjectSim.getSimAction();
                mapObjectArray[0] = mapObjectSim.getSimActionArg1();
                this.m_actionQueueSize = 1;
            }
        }
    }

    private void processSimAction(int n, MapObject mapObject, int n2, int n3) {
        this.resetPlayerInactivity();
        if (this.getPlayerSim().isIdle()) {
            this.startPlayerAction(n, mapObject, n2, n3);
        } else {
            int n4 = this.m_actionQueueSize == 3 ? 2 : this.m_actionQueueSize++;
            this.m_actionQueueActions[n4] = n;
            this.m_actionQueueArg1s[n4] = mapObject;
            this.m_actionQueueArg2s[n4] = n2;
            this.m_actionQueueArg3s[n4] = n3;
        }
    }

    public void startPlayerAction(int n, MapObject mapObject, int n2, int n3) {
        MapObjectSim mapObjectSim = this.getPlayerSim();
        mapObjectSim.beginSimAction(n, mapObject, n2, n3);
        MapObjectSim[] mapObjectSimArray = this.getSimObjects();
        for (int i = 0; i < mapObjectSimArray.length; ++i) {
            MapObjectSim mapObjectSim2 = mapObjectSimArray[i];
            if (mapObjectSim2 == mapObjectSim) continue;
            mapObjectSim2.playerAction(mapObject);
        }
    }

    private void cancelSimAction() {
        this.resetPlayerInactivity();
        if (this.m_actionQueueSize > 0) {
            --this.m_actionQueueSize;
            this.m_actionQueueArg1s[this.m_actionQueueSize] = null;
            if (this.m_actionQueueSize == 0) {
                this.getPlayerSim().interrupt();
            }
        }
    }

    private void processCancelAction(MapObject mapObject) {
        this.resetPlayerInactivity();
        if (mapObject != null && this.m_actionQueueSize > 0) {
            int n = AppEngine.indexOf(mapObject, this.m_actionQueueArg1s);
            if (n == 0) {
                this.getPlayerSim().interrupt();
            } else if (n > 0) {
                --this.m_actionQueueSize;
                for (int i = n; i < this.m_actionQueueSize; ++i) {
                    this.m_actionQueueActions[i] = this.m_actionQueueActions[i + 1];
                    this.m_actionQueueArg1s[i] = this.m_actionQueueArg1s[i + 1];
                    this.m_actionQueueArg2s[i] = this.m_actionQueueArg2s[i + 1];
                    this.m_actionQueueArg3s[i] = this.m_actionQueueArg3s[i + 1];
                }
                this.m_actionQueueArg1s[this.m_actionQueueSize] = null;
            }
        }
    }

    private void processCallAction() {
        int n = this.m_contextMenuItems[2] + 5;
        short s = this.m_contextMenuActions[n];
        short s2 = this.m_contextMenuItems[n];
        if (s2 == 316 || s2 == 315) {
            this.m_contextMenuBackCursor = this.m_contextMenuItems[2];
            this.m_contextMenuOnSubMenu = true;
            this.m_simData.createCallContextMenu(this.m_contextMenuItems, this.m_contextMenuActions, s);
            this.m_contextMenuItems[4] = this.m_maxContextMenuItems;
            if (this.m_contextMenuItems[0] == 0) {
                this.hideMenus();
                this.showMessageBox(768, 767);
            }
        } else {
            this.hideMenus();
            int n2 = this.m_simData.getSimByName(s2);
            this.processSimAction(s, this.m_cursorObject, n2, 0);
        }
    }

    public void finishCallAction(int n, int n2) {
        SimData simData = this.m_simData;
        if (n == 139) {
            if (this.findSim(n2) != null) {
                this.showMessageBox(769, 316);
            } else if (this.nextAvailableBank() != -1 && simData.acceptInvitation(n2)) {
                MapObject mapObject = this.findRandomObjectByType(4);
                AppEngine.ASSERT(mapObject != null, "no town object!");
                MapObjectSim mapObjectSim = (MapObjectSim)this.createObject(1, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir(), n2);
                mapObjectSim.setNeedFlag(32);
                this.showMessageBox(770, 316);
            } else {
                this.showMessageBox(771, 316);
            }
        } else if (n == 138) {
            if (this.findSim(n2) != null) {
                this.showMessageBox(769, 315);
            } else {
                int n3 = simData.getRelState(n2);
                if ((simData.getRelStateFlags(n3) & 0x10) != 0) {
                    simData.adjustMotiveLevel(4, 983040);
                }
            }
        }
    }

    private void processPlantAction() {
        int n = this.m_contextMenuItems[2] + 5;
        short s = this.m_contextMenuActions[n];
        short s2 = this.m_contextMenuItems[n];
        if (s2 == 291) {
            this.m_contextMenuBackCursor = this.m_contextMenuItems[2];
            this.m_contextMenuOnSubMenu = true;
            this.m_simData.createPlantContextMenu(this.m_contextMenuItems, this.m_contextMenuActions, s);
            this.m_contextMenuItems[4] = this.m_maxContextMenuItems;
            if (this.m_contextMenuItems[0] == 0) {
                this.hideMenus();
                this.showMessageBox(790, 789);
            }
        } else {
            this.hideMenus();
            int n2 = this.m_simWorld.getItemByName(s2);
            this.processSimAction(s, this.m_cursorObject, n2, 0);
        }
    }

    private void processCookAction() {
        int n = this.m_contextMenuItems[2] + 5;
        short s = this.m_contextMenuActions[n];
        short s2 = this.m_contextMenuItems[n];
        if (s2 == 307) {
            this.m_contextMenuBackCursor = this.m_contextMenuItems[2];
            this.m_contextMenuOnSubMenu = true;
            this.m_simData.createCookContextMenu(this.m_contextMenuItems, this.m_contextMenuActions, s);
            this.m_contextMenuItems[4] = this.m_maxContextMenuItems;
            if (this.m_contextMenuItems[0] == 0) {
                this.hideMenus();
                this.showMessageBox(788, 787);
            }
        } else {
            this.hideMenus();
            int n2 = this.m_simWorld.getRecipeByName(s2);
            this.processSimAction(s, this.m_cursorObject, n2, 0);
        }
    }

    public void buyFurniture() {
        this.hideMenus();
        this.stateTransition(7);
        this.stateTransitionBuildMode(2);
    }

    public void upgradeHouse() {
        this.hideMenus();
        int n = this.m_simWorld.getHouseUpgradeCost();
        if (n == -1) {
            this.showMessageBox(782, 317);
        } else if (n == 0) {
            this.showMessageBox(781, 317);
        } else {
            this.stateTransition(7);
            this.stateTransitionBuildMode(10);
        }
    }

    public SimData getSimData() {
        return this.m_simData;
    }

    private void updateSimData(int n) {
        int n2;
        SimData simData = this.m_simData;
        if (this.m_timeHit != 0) {
            simData.update(this.m_timeHit * 1000);
            this.m_timeHit = 0;
        } else {
            n2 = n;
            if (simData.getFastforward()) {
                n2 <<= 4;
            }
            simData.update(n2);
        }
        n2 = simData.getMoodLevel();
        this.m_displayedMoodLevel = this.interpolateValue(this.m_displayedMoodLevel, n2, n, 8);
        if (!this.getPlayerSim().isWorking()) {
            int n3 = simData.getTimeFlags(0);
            if ((n3 & 1) != 0 && !this.isShowingTickerMessage()) {
                this.showTickerMessage(645, -1);
            } else if ((n3 & 2) != 0 && !this.isShowingTickerMessage()) {
                this.showTickerMessage(646, -1);
            }
        } else {
            this.cancelWorkMessages();
        }
    }

    private void cancelWorkMessages() {
        this.cancelTickerMessage(646);
        this.cancelTickerMessage(645);
    }

    public void checkGameTimeTriggers(int n, int n2) {
        SimData simData = this.m_simData;
        if (!this.getPlayerSim().isWorking() && simData.getSimCareer(0) != -1) {
            for (int i = n; i < n2; ++i) {
                int n3 = simData.getTimeFlags(0, i);
                int n4 = simData.getTimeFlags(0, i + 1);
                if ((n3 & 2) == 0 || (n4 & 4) == 0) continue;
                simData.careerDayMissed();
                this.cancelWorkMessages();
                int n5 = 2;
                if (simData.getSimCareer(0) == -1) {
                    this.showMessageBox(650, 649, n5);
                    break;
                }
                this.showMessageBox(648, 647, n5);
                break;
            }
        }
    }

    public void renderPlayerGem(Graphics graphics, int n, int n2) {
        if (m_state != 19) {
            this.m_playerGemAnimPlayer.drawAnim(graphics, n, n2);
        }
    }

    private void renderBuffs(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        int n = this.m_viewportX;
        int n2 = n + 8;
        int n3 = appEngine.getHeight() - 15 - this.m_hudBottomHeight;
        if (this.m_tickerString1 != -1) {
            n3 -= AnimationManager.getAnimFrameHeight(679, 0);
        }
        for (int i = 0; i < 6; ++i) {
            int n4 = simData.getBuff(i);
            if (n4 == -1) continue;
            int n5 = simData.getBuffDescString(n4);
            int n6 = simData.getBuffFlags(n4);
            int n7 = appEngine.getStringWidth(n5, 1);
            AnimationManager.setColor(graphics, 76);
            graphics.fillRect(n, n3 - 12, n7 + n2 - n + 4, 12);
            AnimPlayer animPlayer = (n6 & 1) == 0 ? this.m_buffDroppingAnimPlayer : this.m_buffRisingAnimPlayer;
            animPlayer.drawAnim(graphics, n, n3 + -1);
            appEngine.drawString(n5, 1, n2, n3 + 1, 36);
            n3 -= 12;
        }
    }

    public void triggerChanceCard(int n) {
        this.m_questId = n;
        this.m_questSimId = -1;
        this.m_chanceCardOutcome = -1;
        this.stateTransition(18);
        this.stateTransitionQuest(0);
    }

    public void triggerFetchQuest(int n, int n2) {
        this.m_questId = n;
        this.m_questSimId = n2;
        this.stateTransition(18);
        this.stateTransitionQuest(2);
    }

    public void triggerFetchQuestEnd(int n, int n2) {
        this.m_showFetchQuestEnd = true;
        this.m_questId = n;
        this.m_questSimId = n2;
    }

    private void stateTransitionQuest(int n) {
        SimData simData = this.m_simData;
        this.m_questState = n;
        int n2 = this.m_questId;
        int n3 = -1;
        switch (n) {
            case 0: {
                n3 = simData.getChanceCardPromptString(n2);
                break;
            }
            case 1: {
                n3 = simData.getChanceCardOutcomeString(n2, this.m_chanceCardOutcome);
                break;
            }
            case 2: {
                n3 = simData.getQuestPromptString(n2);
                break;
            }
            case 3: {
                n3 = simData.getQuestMessageString(n2);
                break;
            }
            case 4: {
                this.stateTransition(5);
            }
        }
        if (n3 != -1) {
            int n4 = -1;
            n4 = this.m_questSimId != -1 ? simData.getSimName(this.m_questSimId) : 823;
            this.prepareGenericMessageBox(n3, n4);
        }
        this.setupSoftkeys();
    }

    private void renderQuest(Graphics graphics) {
        this.renderMain(graphics);
        this.m_engine.renderBackgroundDim(graphics);
        this.drawGenericMessageBox(graphics);
        this.renderSoftkeyBar(graphics);
    }

    private void processKeysQuest(int n, int n2) {
        SimData simData = this.m_simData;
        switch (this.m_questState) {
            case 1: {
                if (!this.checkKeys(n, n2, 4128, 12)) break;
                this.stateTransitionQuest(4);
                simData.performChanceCardOutcome(this.m_questId, this.m_chanceCardOutcome);
                break;
            }
            case 0: {
                if (this.checkKeys(n, n2, 4128, 256)) {
                    this.m_chanceCardOutcome = simData.getChanceCardOutcome(this.m_questId, true);
                    this.stateTransitionQuest(1);
                    break;
                }
                if (!this.checkKeys(n, n2, 0, 516)) break;
                this.m_chanceCardOutcome = simData.getChanceCardOutcome(this.m_questId, false);
                this.stateTransitionQuest(1);
                break;
            }
            case 2: {
                if (!this.checkKeys(n, n2, 4128, 8)) break;
                int n3 = simData.getQuestFlags(this.m_questId);
                if ((n3 & 2) != 0) {
                    this.showTutorialMessage((byte)6);
                } else if ((n3 & 8) != 0) {
                    this.showTutorialMessage((byte)7);
                }
                this.stateTransitionQuest(4);
                break;
            }
            case 3: {
                if (!this.checkKeys(n, n2, 4128, 8)) break;
                simData.questCompleted(this.m_questId);
                this.stateTransitionQuest(4);
            }
        }
    }

    public boolean isShowingEvent() {
        return this.m_eventState != 0 && this.m_eventState != 1 && this.m_eventState != 5;
    }

    public void triggerEvent(int n, int n2, int n3) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        SimData simData = this.m_simData;
        int[] nArray = this.m_palSources;
        int[] nArray2 = this.m_palPatches;
        SimWorld simWorld = this.m_simWorld;
        simData.delayAlerts();
        this.m_engine.vibrate();
        this.m_eventId = n;
        this.stateTransition(19);
        this.stateTransitionEvent(1);
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        switch (n) {
            case 0: {
                n5 = n2;
                n4 = 524288;
                break;
            }
            case 1: {
                n5 = 797;
                n4 = 0x100000;
                break;
            }
            case 2: {
                n5 = 796;
                n4 = 0x200000;
                break;
            }
            case 3: {
                n5 = 798;
                n4 = 0x400000;
                break;
            }
            case 4: {
                n5 = 799;
                n6 = n2;
                n4 = 0x800000;
                break;
            }
            case 5: {
                n5 = 801;
                n4 = 0x1000000;
                break;
            }
            case 6: {
                n5 = 802;
                n6 = n2;
                n4 = 0x2000000;
                break;
            }
            case 7: {
                n5 = 804;
                n6 = n2;
                n4 = 0x2000000;
                break;
            }
            case 8: {
                n5 = simData.getPersonaDescString(simData.getPersona());
                n6 = 806;
                n4 = 0x4000000;
            }
        }
        AnimationManager.loadImage(resourceManager, 16);
        AnimationManager.loadImage(resourceManager, 15);
        if (n4 == 0x2000000) {
            simWorld.getSimPatches(0, nArray, nArray2);
            AnimationManager.loadImage(resourceManager, 9, nArray, nArray2, 0);
            int n7 = simData.getCareerBoss(this.m_jobOfferCareer);
            simWorld.getSimPatches(n7, nArray, nArray2);
            AnimationManager.loadImage(resourceManager, 10, nArray, nArray2, 0);
        } else if (n4 == 0x100000) {
            simWorld.getSimPatches(0, nArray, nArray2);
            AnimationManager.loadImage(resourceManager, 13, nArray, nArray2, 0);
            simWorld.getSimPatches(n3, nArray, nArray2);
            AnimationManager.loadImage(resourceManager, 14, nArray, nArray2, this.findSim(n3).getBank());
        } else if (n4 == 0x800000) {
            simWorld.getSimPatches(0, nArray, nArray2);
            AnimationManager.loadImage(resourceManager, 18, nArray, nArray2, 0);
        } else {
            this.m_engine.loadAllImages(n4);
        }
        this.m_eventTopStringId = n5;
        this.m_eventBottomStringId = n6;
        this.m_eventParam = n3;
    }

    private void finishEvent() {
        int n = 133693440;
        if (this.isMapMode()) {
            n &= 0xFEFFFFFF;
        }
        this.m_engine.unloadAllImages(n, -1);
        switch (this.m_eventId) {
            case 0: {
                this.m_engine.changeScene(1, -1);
                break;
            }
            case 2: {
                this.stateTransition(5);
                break;
            }
            case 3: {
                if (this.m_simData.registerWooHoo()) {
                    this.killPlayer(811);
                    this.stateTransitionEvent(2);
                    break;
                }
                this.stateTransition(5);
                break;
            }
            case 5: {
                if (this.m_simWorld.isBestHouse()) {
                    this.m_simData.dreamCompleteEvent(70);
                }
                this.stateTransition(5);
                break;
            }
            default: {
                this.stateTransition(5);
            }
        }
    }

    private void stateTransitionEvent(int n) {
        this.m_eventState = n;
        this.m_stateTime = 0;
        switch (n) {
            case 1: {
                this.m_preEventCursorObject = this.m_cursorObject;
                this.setCursorObject(this.getPlayerSim());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                this.setCursorObject(this.m_preEventCursorObject);
                this.m_preEventCursorObject = null;
                this.finishEvent();
            }
        }
        this.setupSoftkeys();
    }

    private void updateEvent(int n) {
        this.m_eventTimer += n;
        switch (this.m_eventState) {
            case 1: {
                this.updateCamera(n);
                if (!this.m_cameraAtDest) break;
                this.setCursorObject(null);
                this.stateTransitionEvent(2);
                break;
            }
            case 2: {
                if (this.m_stateTime <= 500) break;
                this.stateTransitionEvent(3);
                break;
            }
            case 4: {
                if (this.m_stateTime <= 1000) break;
                this.stateTransitionEvent(5);
            }
        }
    }

    private void processKeysEvent(int n, int n2) {
        switch (this.m_eventState) {
            case 3: {
                if (!this.checkKeys(n, n2, 4128, 8)) break;
                this.stateTransitionEvent(4);
            }
        }
    }

    private void renderEvent(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        switch (this.m_eventState) {
            case 1: {
                this.renderMain(graphics);
                this.renderSoftkeyBar(graphics);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.renderEventMain(graphics);
                appEngine.renderSoftkeyBar(graphics);
            }
        }
        if (this.m_eventState == 2) {
            int n = 255 - Math.min(this.m_stateTime * 255 / 500, 255);
            int n2 = 0xFF000000 | n << 16 | n << 8 | n << 0;
            appEngine.renderFade(graphics, 1, n2, 0, 0, appEngine.getWidth(), appEngine.getHeight());
        } else if (this.m_eventState == 4) {
            int n = 255 - Math.min(this.m_stateTime * 255 / 1000, 255);
            int n3 = 0xFF000000 | n << 16 | n << 8 | n << 0;
            appEngine.renderFade(graphics, 0, n3, 0, 0, appEngine.getWidth(), appEngine.getHeight());
        }
    }

    private void renderEventMain(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        AnimationManager.drawAnimFrame(graphics, 46, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight() - 7);
        SDKString sDKString = null;
        if (this.m_eventParam != -1) {
            sDKString = appEngine.getString(this.m_simData.getSimName(this.m_eventParam));
        }
        switch (this.m_eventId) {
            case 0: {
                this.drawEventFrame(graphics, 63, appEngine.getSimName(), appEngine.getString(807));
                break;
            }
            case 1: {
                this.drawEventStreamers(graphics, 60, 57);
                this.drawEventFrame(graphics, 68, appEngine.getSimName(), sDKString);
                this.drawEventMarriage(graphics);
                break;
            }
            case 2: {
                this.drawEventStreamers(graphics, 57, 203);
                this.drawEventFrame(graphics, 67, appEngine.getSimName(), sDKString);
                this.drawEventKissSims(graphics);
                break;
            }
            case 3: {
                this.drawEventStreamers(graphics, 57, 62);
                this.drawEventFrame(graphics, 82, appEngine.getSimName(), sDKString);
                break;
            }
            case 4: {
                int n = this.m_eventParam;
                int n2 = simData.getSkillIcon1(n);
                int n3 = simData.getSkillIcon2(n);
                int n4 = simData.getSkillEventAnim(n);
                int n5 = simData.getSimAttribute(0, 0) == 0 ? 81 : 80;
                this.drawEventStreamers(graphics, n2, n3);
                this.drawEventFrame(graphics, n4, null, null);
                AnimationManager.drawAnimFrame(graphics, n5, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight());
                break;
            }
            case 5: {
                this.drawEventStreamers(graphics, 61, 88);
                this.drawEventFrame(graphics, 66, null, null);
                break;
            }
            case 6: {
                int n = simData.getCareerStreamer(simData.getSimCareer(0));
                this.drawEventStreamers(graphics, 61, n);
                this.drawEventFrame(graphics, 64, null, null);
                break;
            }
            case 7: {
                int n = simData.getCareerStreamer(simData.getSimCareer(0));
                this.drawEventStreamers(graphics, 61, n);
                this.drawEventFrame(graphics, 65, null, null);
                break;
            }
            case 8: {
                int n = simData.getPersonaIcon();
                this.drawEventStreamers(graphics, 87, n);
                this.drawEventFrame(graphics, 75, null, null);
                break;
            }
        }
    }

    private void drawEventFrame(Graphics graphics, int n, SDKString sDKString, SDKString sDKString2) {
        int n2;
        AppEngine appEngine = this.m_engine;
        int n3 = appEngine.getWidth();
        int n4 = appEngine.getHeight();
        int n5 = this.m_eventId;
        int n6 = 0;
        if (this.m_eventId == 0) {
            n6 = n4 / 10;
        }
        int n7 = n3 >> 1;
        int n8 = (n4 >> 1) + n6;
        AnimationManager.drawAnimFrame(graphics, n, 0, n7, n8);
        int[] nArray = this.m_tempInt4;
        if (sDKString != null) {
            AnimationManager.getAnimFrameFirePoint(nArray, n, 0, 0);
            appEngine.drawString(sDKString, 1, n7 + nArray[0], n8 + 1 + nArray[1], 17);
        }
        if (sDKString2 != null) {
            AnimationManager.getAnimFrameFirePoint(nArray, n, 0, 1);
            appEngine.drawString(sDKString2, 1, n7 + nArray[0], n8 + 1 + nArray[1], 17);
        }
        if (n5 == 8) {
            AnimationManager.getAnimFrameFirePoint(nArray, n, 0, 0);
            this.drawHUDSim(graphics, n7 + nArray[0], n8 + nArray[1], 0, true, 0);
        } else if (n5 == 5) {
            n2 = this.m_simWorld.getPlayerHouseMMAnim();
            AnimationManager.getAnimFrameFirePoint(nArray, n2, 0, 1);
            AnimationManager.drawAnimFrame(graphics, n2, 0, n7 - nArray[0], n8 - nArray[1]);
        }
        if (this.m_eventState == 3) {
            int n9;
            if (this.m_eventTopStringId != -1) {
                n2 = AnimationManager.getAnimFrameHeight(n, 0);
                n9 = n8 - (n2 >> 1);
                int n10 = n9 >> 1;
                if (n5 == 3 || n5 == 7) {
                    appEngine.renderWavyString(0, graphics, this.m_eventTopStringId, 0, n7, n10, 3);
                } else {
                    appEngine.drawWrappedStringChunk(0, this.m_eventTopStringId, 0, this.m_uiMessageBoxWrapWidth, n7, n10, 3);
                }
            }
            if (this.m_eventBottomStringId != -1) {
                n2 = n4 - 15 - (n8 + (AnimationManager.getAnimFrameHeight(n, 0) >> 1));
                n9 = n4 - 15 - (n2 >> 1);
                appEngine.drawWrappedStringChunk(0, this.m_eventBottomStringId, 0, this.m_uiMessageBoxWrapWidth, n7, n9, 3);
            }
        }
    }

    private void drawEventStreamers(Graphics graphics, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        int n3 = appEngine.getHeight() - 15;
        int n4 = appEngine.getWidth();
        int n5 = n4 / 3 >> 1;
        int n6 = n4 - n5;
        int n7 = n4 * 15 / 100;
        int n8 = Math.max(AnimationManager.getAnimFrameHeight(n, 0), AnimationManager.getAnimFrameHeight(n2, 0));
        int n9 = n3 + n8;
        int n10 = -(this.m_eventTimer * 850 % 0x5A0000);
        int n11 = n;
        if (n10 < -2949120) {
            n10 += 0x2D0000;
            n11 = n2;
        }
        int n12 = this.m_eventTimer * 125 % 411775;
        int n13 = n12 - MathExt.Fdiv(MathExt.Fmul(164709, -n10), 0x2D0000);
        int n14 = n10 >> 16;
        int n15 = n13;
        int n16 = n11;
        while (n14 < n9) {
            int n17 = n15;
            int n18 = MathExt.Fmul(n7, MathExt.Fcos(n17));
            int n19 = n14;
            int n20 = n16;
            if (n20 == n2 && this.m_eventId == 7) {
                AnimationManager.drawAnimFrame(graphics, 91, 0, n5 + n18, n19 + -15);
            }
            AnimationManager.drawAnimFrame(graphics, n20, 0, n5 + n18, n19);
            n17 = n15 + 82354;
            n18 = MathExt.Fmul(n7, MathExt.Fcos(n17));
            n19 = n14 + 22;
            if (n20 == n2 && this.m_eventId == 7) {
                AnimationManager.drawAnimFrame(graphics, 91, 0, n6 + n18, n19 + -15);
            }
            AnimationManager.drawAnimFrame(graphics, n20, 0, n6 + n18, n19);
            n14 += 45;
            n15 += 164709;
            n16 = n20 == n ? n2 : n;
        }
    }

    private void drawEventMarriage(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        int n5 = this.m_eventParam;
        if (simData.getSimAttribute(0, 0) == 0) {
            n4 = 74;
            n3 = 499;
            if (simData.getSimAttribute(n5, 0) == 0) {
                n2 = 71;
                n = 499;
            } else {
                n2 = 69;
                n = 392;
            }
        } else {
            if (simData.getSimAttribute(n5, 0) == 0) {
                n4 = 72;
                n2 = 70;
                n = 499;
            } else {
                n4 = 73;
                n2 = 69;
                n = 392;
            }
            n3 = 392;
        }
        int n6 = simData.getSimAttribute(0, 2) + 1;
        int n7 = simData.getSimAttribute(n5, 2) + 1;
        AnimationManager.setBank(0);
        AnimationManager.drawAnimFrameExt(graphics, n4, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight(), n3, n6, null);
        AnimationManager.setBank(this.findSim(n5).getBank());
        AnimationManager.drawAnimFrameExt(graphics, n2, 0, appEngine.getHalfWidth(), appEngine.getHalfHeight(), n, n7, null);
        AnimationManager.setBank(0);
    }

    private void drawEventKissSims(Graphics graphics) {
        SimWorld simWorld = this.m_simWorld;
        MapObjectSim mapObjectSim = this.m_playerSim;
        MapObjectSim mapObjectSim2 = this.findSim(this.m_eventParam);
        int[] nArray = this.m_tempInt4;
        int n = mapObjectSim.getPosX();
        int n2 = mapObjectSim.getPosZ();
        int n3 = mapObjectSim2.getPosX();
        int n4 = mapObjectSim2.getPosZ();
        int n5 = simWorld.coordWorldToScreenX(n, n2) + simWorld.coordWorldToScreenX(n3, n4) >> 1;
        int n6 = simWorld.coordWorldToScreenY(n, n2) + simWorld.coordWorldToScreenY(n3, n4) >> 1;
        AnimationManager.getAnimFrameFirePoint(nArray, 67, 0, 2);
        this.m_simWorld.renderObjects2D(graphics, mapObjectSim, mapObjectSim2, n5 += nArray[0] << 16, n6 -= nArray[1] << 17);
    }

    public boolean inMiniGame() {
        return m_state == 16;
    }

    public void beginMiniGame(int n, MapObject mapObject) {
        this.hideMenus();
        this.m_simData.delayAlerts();
        this.m_miniGameTargetObject = mapObject;
        this.m_miniGameType = n;
        this.miniGameResetAnimPool();
        int n2 = 0;
        this.m_miniGameTimer = 0;
        switch (n) {
            case 0: {
                n2 = 20;
                this.beginMiniGameCooking();
                break;
            }
            case 1: {
                n2 = 20;
                this.beginMiniGameFishing();
                break;
            }
            case 4: {
                n2 = 20;
                this.beginMiniGameSkiing();
                break;
            }
            case 2: {
                n2 = 20;
                this.beginMiniGameRepairing();
                break;
            }
            case 3: {
                n2 = 20;
                this.beginMiniGameCleaning();
            }
        }
        this.m_timeHit = n2;
        this.stateTransition(16);
        this.stateTransitionMiniGame(0);
    }

    private void stateTransitionMiniGame(int n) {
        SimWorld simWorld = this.m_simWorld;
        SimData simData = this.m_simData;
        this.m_miniGameState = n;
        boolean bl = false;
        switch (n) {
            case 0: {
                if (this.m_miniGameType == 1) {
                    int n2 = this.getPlayerSim().getPosX();
                    int n3 = this.getPlayerSim().getPosZ();
                    int n4 = simWorld.coordWorldToScreenPixelsX(n2, n3);
                    int n5 = simWorld.coordWorldToScreenPixelsY(n2, n3);
                    n4 = this.m_miniGameTargetObject.getType() == 5 ? (n4 += 50) : (n4 -= 10);
                    this.m_cursorObject = null;
                    this.m_cursorPosX = this.m_cursorDestX = n4 << 16;
                    this.m_cursorPosZ = this.m_cursorDestZ = n5 << 16;
                    break;
                }
                this.setCursorObject(this.getPlayerSim());
                break;
            }
            case 1: {
                switch (this.m_miniGameType) {
                    case 0: {
                        this.showTutorialMessage((byte)2);
                        break;
                    }
                    case 1: {
                        this.showTutorialMessage((byte)3);
                        break;
                    }
                    case 4: {
                        this.showTutorialMessage((byte)17);
                        break;
                    }
                    case 2: {
                        this.showTutorialMessage((byte)4);
                        break;
                    }
                    case 3: {
                        this.showTutorialMessage((byte)5);
                    }
                }
                break;
            }
            case 2: {
                this.setCursorObject(this.m_miniGameTargetObject);
                this.stateTransition(5);
                this.increaseSkill(this.m_miniGameSkill);
                switch (this.m_miniGameType) {
                    case 1: {
                        this.m_miniGameTargetObject.unhide();
                        simData.dreamCompleteEvent(29);
                        if (this.m_fishingFishType == 37) {
                            simData.dreamCompleteEvent(30);
                        } else if (this.m_fishingFishType == 38) {
                            simData.dreamCompleteEvent(31);
                        } else if (this.m_fishingFishType == 34) {
                            simData.dreamCompleteEvent(32);
                        } else if (this.m_fishingFishType == 36) {
                            simData.dreamCompleteEvent(15);
                        }
                        simData.adjustInventory(this.m_fishingFishType, 1);
                        this.showGetItem(this.m_fishingFishType, 1, 342, 723);
                        break;
                    }
                    case 4: {
                        this.m_miniGameTargetObject.unhide();
                        this.setCursorObject(this.m_miniGameTargetObject);
                        this.getPlayerSim().interrupt();
                        break;
                    }
                    case 0: {
                        simData.dreamCompleteEvent(35);
                        int n6 = simData.getActiveRecipe();
                        if (n6 == 0) {
                            simData.dreamCompleteEvent(36);
                            break;
                        }
                        if (n6 == 9) {
                            simData.dreamCompleteEvent(38);
                            break;
                        }
                        if (n6 != 6) break;
                        simData.dreamCompleteEvent(37);
                        break;
                    }
                    case 2: {
                        simData.dreamCompleteEvent(33);
                        this.m_miniGameTargetObject.repairObject();
                        if (this.m_miniGameTargetObject.getType() != 93) break;
                        simData.dreamCompleteEvent(10);
                        break;
                    }
                    case 3: {
                        this.m_miniGameTargetObject.cleanObject();
                        if (this.m_miniGameTargetObject.getType() != 94) break;
                        simData.dreamCompleteEvent(11);
                    }
                }
                bl = true;
                break;
            }
            case 3: {
                if (this.m_miniGameType == 1) {
                    this.m_miniGameTargetObject.unhide();
                }
                if (this.m_miniGameType == 4) {
                    this.m_miniGameTargetObject.unhide();
                }
                this.setCursorObject(this.m_miniGameTargetObject);
                if (this.m_miniGameType == 2 && this.m_engine.randPercent() < 5) {
                    this.killPlayer(812);
                    break;
                }
                this.getPlayerSim().interrupt();
                this.getPlayerSim().queueSimAction(8, null, 0, 0);
                this.showMessageBox(762, 761);
                bl = true;
                break;
            }
            case 4: {
                if (this.m_miniGameType == 1) {
                    this.m_miniGameTargetObject.unhide();
                }
                if (this.m_miniGameType == 4) {
                    this.m_miniGameTargetObject.unhide();
                    this.initMiniGameSkiing();
                }
                this.m_timeHit = 0;
                this.setCursorObject(this.m_miniGameTargetObject);
                this.getPlayerSim().interrupt();
                this.showMessageBox(763, 761);
                bl = true;
                break;
            }
            case 5: {
                AppEngine.ASSERT(this.m_miniGameType == 0, "only cooking uses timeup state");
                this.m_stateTime = 0;
                this.m_miniGameAnimPool[0].startAnim(643, 4);
                break;
            }
            case 6: {
                AppEngine.ASSERT(this.m_miniGameType == 0, "only cooking uses outro state");
                break;
            }
            case 7: {
                AppEngine.ASSERT(this.m_miniGameType == 1, "only fishing uses intro state");
                MapObjectSim mapObjectSim = this.getPlayerSim();
                mapObjectSim.unsetRuntimeFlag(128);
                mapObjectSim.setSubAppearance(22);
                break;
            }
            case 8: {
                AppEngine.ASSERT(this.m_miniGameType == 1, "only fishing uses outro state");
                MapObjectSim mapObjectSim = this.getPlayerSim();
                mapObjectSim.unsetRuntimeFlag(128);
                int n7 = this.fishingSuccess() ? 26 : 23;
                mapObjectSim.setSubAppearance(n7);
                break;
            }
            case 10: {
                AppEngine.ASSERT(this.m_miniGameType == 4, "only fishing uses intro state");
                MapObjectSim mapObjectSim = this.getPlayerSim();
                break;
            }
            case 11: {
                AppEngine.ASSERT(this.m_miniGameType == 4, "only fishing uses outro state");
                MapObjectSim mapObjectSim = this.getPlayerSim();
                mapObjectSim.unsetRuntimeFlag(128);
                n = this.skiingGameSuccess() ? 2 : 3;
                this.stateTransitionMiniGame(n);
                break;
            }
            case 9: {
                AppEngine.ASSERT(this.m_miniGameType == 3, "only cleaning uses timeup state");
                this.m_stateTime = 0;
                this.m_miniGameAnimPool[0].startAnim(643, 4);
            }
        }
        if (bl) {
            switch (this.m_miniGameType) {
                case 0: {
                    simData.dreamCompleteEvent(2);
                    break;
                }
                case 1: {
                    simData.dreamCompleteEvent(0);
                    break;
                }
                case 4: {
                    simData.dreamCompleteEvent(1);
                }
            }
        }
    }

    public void increaseSkill(int n) {
        SimData simData = this.m_simData;
        int n2 = simData.getSkillRank(n);
        simData.increaseSkill(n);
        int n3 = simData.getSkillRank(n);
        int n4 = 764;
        if (n2 != n3) {
            n4 = n3 == 5 ? 766 : 765;
            switch (n) {
                case 0: {
                    simData.dreamCompleteEvent(9);
                    if (n3 != 5) break;
                    simData.dreamCompleteEvent(81);
                    break;
                }
                case 2: {
                    simData.dreamCompleteEvent(12);
                    if (n3 != 5) break;
                    simData.dreamCompleteEvent(78);
                    break;
                }
                case 5: {
                    simData.dreamCompleteEvent(13);
                    if (n3 != 5) break;
                    simData.dreamCompleteEvent(79);
                    break;
                }
                case 1: {
                    simData.dreamCompleteEvent(16);
                    if (n3 != 5) break;
                    simData.dreamCompleteEvent(82);
                    break;
                }
                case 3: {
                    simData.dreamCompleteEvent(17);
                    if (n3 != 5) break;
                    simData.dreamCompleteEvent(80);
                    break;
                }
            }
        }
        if (n2 != n3 && n3 == 5) {
            this.m_engine.dynamicString(-11, 800, simData.getSkillDesc(n));
            this.triggerEvent(4, -11, n);
        } else if (n2 != 5) {
            int n5 = simData.getSkillDesc(n);
            this.showMessageBox(n4, n5);
        }
    }

    private void renderMiniGame(Graphics graphics) {
        this.m_simWorld.renderWorld(graphics);
        if (!this.m_pauseMenuActive && this.m_miniGameType != 1 && this.m_miniGameType != 4) {
            this.m_engine.renderBackgroundDim(graphics);
        }
        switch (this.m_miniGameType) {
            case 0: {
                this.renderMiniGameBGTimer(graphics);
                this.renderMiniGameCooking(graphics);
                break;
            }
            case 1: {
                this.renderMiniGameBGSlider(graphics);
                this.renderMiniGameFishing(graphics);
                break;
            }
            case 4: {
                this.renderMiniGameBGSlider(graphics);
                this.renderMiniGameSkee(graphics);
                break;
            }
            case 2: {
                this.renderMiniGameBGTimer(graphics);
                this.renderMiniGameRepairing(graphics);
                break;
            }
            case 3: {
                this.renderMiniGameBGTimer(graphics);
                this.renderMiniGameCleaning(graphics);
            }
        }
        if (this.m_tutorialMessageActive) {
            this.drawTextScreen(graphics);
        }
        if (this.m_pauseMenuActive) {
            this.renderPauseMenu(graphics);
        }
        this.renderSoftkeyBar(graphics);
    }

    private void renderMiniGameBGTimer(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager.drawAnimFrame(graphics, 578, 0, 0, 34);
        int n = AnimationManager.getAnimFrameHeight(596, 0);
        int n2 = appEngine.getHeight() - 15 - 34 - n;
        AnimationManager.drawAnimFrame(graphics, 579, 0, 0, n2);
        this.m_minigameTop = 34;
        this.m_minigameBottom = n2;
        this.renderHUDMoodSim(graphics);
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = appEngine.getWidth() >> 1;
        int n8 = AnimationManager.getAnimFrameHeight(643, 0);
        int n9 = 17 - n8;
        int n10 = appEngine.getWidth() - 40;
        int n11 = n7 - (n10 >> 1);
        graphics.setClip(n11, n4, n10, n6);
        AnimationManager.drawAnimFrame(graphics, 642, 0, n11, n9);
        int n12 = this.m_miniGameTimer * n10 / this.m_miniGameTimerMax;
        graphics.setClip(n11, n4, n12, n6);
        if (this.m_miniGameState == 5) {
            AnimationManager.drawAnim(graphics, this.m_miniGameAnimPool[0], n11, n9);
        } else {
            AnimationManager.drawAnimFrame(graphics, 643, 0, n11, n9);
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    private void renderMiniGameBGSlider(Graphics graphics) {
        AnimationManager.drawAnimFrame(graphics, 578, 0, 0, 14);
        int n = AnimationManager.getAnimFrameHeight(596, 0);
        int n2 = this.m_engine.getHeight() - 15 - 64 - n;
        AnimationManager.drawAnimFrame(graphics, 579, 0, 0, n2);
        this.m_minigameTop = 14;
        this.m_minigameBottom = n2;
        this.renderHUDMoodSim(graphics);
    }

    private void processKeysMiniGame(int n, int n2) {
        if (this.checkKeys(n, n2, 0, 5)) {
            if (this.m_miniGameType == 4) {
                SKIER_SPEED = 0;
                START_GAME = false;
                PRESS_OK = false;
                START_COUNTDOWN = false;
            }
            this.showPauseMenu();
            return;
        }
        if (this.checkKeys(n, n2, 0, 64)) {
            this.stateTransitionMiniGame(4);
            return;
        }
        if (this.m_miniGameState == 1) {
            switch (this.m_miniGameType) {
                case 0: {
                    this.processKeysMiniGameCooking(n, n2);
                    break;
                }
                case 1: {
                    this.processKeysMiniGameFishing(n, n2);
                    break;
                }
                case 4: {
                    this.processKeysMiniGameSkiing(n, n2);
                    break;
                }
                case 2: {
                    this.processKeysMiniGameRepairing(n, n2);
                    break;
                }
                case 3: {
                    this.processKeysMiniGameCleaning(n, n2);
                }
            }
        }
    }

    private void updateMiniGame(int n) {
        if (this.m_pauseMenuActive || this.m_tutorialMessageActive) {
            return;
        }
        this.getPlayerSim().update(n);
        this.m_miniGameTargetObject.update(n);
        this.updateObjectTypes(n, 7);
        if (this.m_miniGameState == 0) {
            this.updateCamera(n);
            if (this.m_cameraAtDest) {
                this.setCursorObject(null);
                int n2 = this.m_miniGameType == 1 ? 7 : (this.m_miniGameType == 4 ? 10 : 1);
                this.stateTransitionMiniGame(n2);
            }
        } else {
            switch (this.m_miniGameType) {
                case 0: {
                    this.updateMiniGameCooking(n);
                    break;
                }
                case 1: {
                    this.updateMiniGameFishing(n);
                    break;
                }
                case 4: {
                    this.updateMiniGameSkiing(n);
                    break;
                }
                case 2: {
                    this.updateMiniGameRepairing(n);
                    break;
                }
                case 3: {
                    this.updateMiniGameCleaning(n);
                }
            }
        }
    }

    private void miniGameResetAnimPool() {
        for (int i = 0; i < 24; ++i) {
            this.m_miniGameAnimPool[i].setAnimating(false);
            AppEngine.fillArray(this.m_miniGameAnimPoolPos[i], -1);
        }
    }

    private int miniGameStartAnim(int n, int n2, int n3, int n4) {
        int n5 = -1;
        for (int i = 0; i < 24; ++i) {
            if (this.m_miniGameAnimPool[i].isAnimating()) continue;
            n5 = i;
            break;
        }
        if (n5 != -1) {
            this.m_miniGameAnimPool[n5].startAnim(n, n4);
            this.m_miniGameAnimPoolPos[n5][0] = n2;
            this.m_miniGameAnimPoolPos[n5][1] = n3;
            this.m_miniGameAnimPoolPos[n5][2] = -1;
        }
        return n5;
    }

    private void miniGameRenderAnimPool(Graphics graphics, int n) {
        this.miniGameRenderAnimPool(graphics, n, 0, 0);
    }

    private void miniGameRenderAnimPool(Graphics graphics, int n, int n2, int n3) {
        for (int i = n; i < 24; ++i) {
            AnimPlayer animPlayer = this.m_miniGameAnimPool[i];
            if (!animPlayer.isAnimating()) continue;
            int[] nArray = this.m_miniGameAnimPoolPos[i];
            animPlayer.drawAnim(graphics, nArray[0] + n2, nArray[1] + n3);
        }
    }

    private void miniGameRenderAnimPoolFixed(Graphics graphics, int n, int n2, int n3) {
        for (int i = n; i < 24; ++i) {
            AnimPlayer animPlayer = this.m_miniGameAnimPool[i];
            if (!animPlayer.isAnimating()) continue;
            int[] nArray = this.m_miniGameAnimPoolPos[i];
            animPlayer.drawAnim(graphics, (nArray[0] >> 16) + n2, (nArray[1] >> 16) + n3);
        }
    }

    private void miniGameUpdateAnimPool(int n, int n2) {
        for (int i = n2; i < 24; ++i) {
            this.m_miniGameAnimPool[i].updateAnim(n);
        }
    }

    private void renderTiledArea(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        graphics.setClip(n, n2, n3, n4);
        int n10 = AnimationManager.getAnimFrameWidth(n5, 0);
        int n11 = AnimationManager.getAnimFrameHeight(n5, 0);
        for (int i = 0; i < n4; i += n11) {
            for (int j = 0; j < n3; j += n10) {
                AnimationManager.drawAnimFrame(graphics, n5, 0, n + j, n2 + i);
            }
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    private void beginMiniGameCooking() {
        int n;
        this.m_miniGameSkill = 0;
        int n2 = this.m_simData.getSkillRank(0);
        int n3 = 655;
        int n4 = 2;
        switch (n2) {
            default: {
                AppEngine.ASSERT(false, "invalid skill rank");
            }
            case 0: {
                n = 20000;
                break;
            }
            case 1: {
                n = 30000;
                n3 = 983;
                break;
            }
            case 2: {
                n4 = 3;
                n = 30000;
                break;
            }
            case 3: {
                n4 = 3;
                n = 30000;
                n3 = 983;
                break;
            }
            case 4: 
            case 5: {
                n4 = 4;
                n = 40000;
            }
        }
        this.m_cookingPotCount = n4;
        this.m_miniGameTimerMax = n;
        this.m_cookingLevelIncreaseF = n3;
        this.m_cookingLevelReduceF = 0x190000;
        this.m_cookingPotActive = 0;
        this.m_miniGameTimer = 0;
        AppEngine appEngine = this.m_engine;
        for (int i = 0; i < this.m_cookingPotCount; ++i) {
            int n5;
            this.m_cookingLevelsF[i] = n5 = appEngine.rand(0x190000, 0x4B0000);
            this.m_displayedCookingLevelsF[i] = n5;
            this.m_miniGameAnimPool[this.m_cookingPotCount + i].startAnim(621, 20);
            this.m_cookingPotContents[i] = (byte)appEngine.rand(0, 3);
        }
    }

    private void renderMiniGameCooking(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        int n5 = this.m_viewportX + (this.m_viewportWidth >> 1);
        int n6 = AnimationManager.getAnimFrameWidth(619, 0);
        int n7 = AnimationManager.getAnimFrameHeight(620, 0);
        int n8 = n5 - (n6 * this.m_cookingPotCount >> 1) + (n6 >> 1);
        int n9 = this.m_minigameTop + this.m_minigameBottom + n7 >> 1;
        int n10 = AnimationManager.getAnimFrameHeight(621, 0);
        int[] nArray = this.m_tempInt10;
        int n11 = n8;
        for (int i = 0; i < this.m_cookingPotCount; ++i) {
            int n12 = 620;
            int n13 = this.m_miniGameAnimPool[this.m_cookingPotCount + i].getAnimID();
            int n14 = this.m_miniGameAnimPool[this.m_cookingPotCount + i].getCurrAnimFrame();
            if (this.m_miniGameState == 5) {
                n13 = 622;
                n14 = 0;
            }
            if (i == this.m_cookingPotActive) {
                n12 = 619;
                if (n13 != 623) {
                    n13 = 621;
                }
            }
            int n15 = this.m_displayedCookingLevelsF[i];
            AnimationManager.drawAnimFrame(graphics, n12, 0, n11, n9);
            int n16 = n10 * (n15 >> 16) / 100;
            graphics.setClip(n, n9 - n16, n3, n16);
            AnimationManager.drawAnimFrame(graphics, n13, n14, n11, n9);
            graphics.setClip(n, n2, n3, n4);
            AnimationManager.drawAnimFrame(graphics, 624, 0, n11, n9);
            if (n15 > 0 && n15 < 0x640000) {
                AnimationManager.getAnimFrameFirePoint(nArray, 620, 0, 0);
                AnimationManager.drawAnimFrame(graphics, 617, this.m_cookingPotContents[i], n11 + nArray[0], n9 + nArray[1]);
            }
            n11 += n6;
        }
        graphics.setClip(n, n2, n3, n4);
        this.miniGameRenderAnimPool(graphics, this.m_cookingPotCount << 1);
    }

    private void updateMiniGameCooking(int n) {
        this.miniGameUpdateAnimPool(n, this.m_cookingPotCount);
        if (this.m_miniGameState == 5) {
            this.m_miniGameAnimPool[0].updateAnim(n);
            if (this.m_stateTime > 3200) {
                this.stateTransitionMiniGame(2);
            }
            return;
        }
        if (this.m_miniGameState == 6) {
            if (!this.m_miniGameAnimPool[this.m_cookingDeadPotAnim].isAnimating()) {
                this.stateTransitionMiniGame(3);
            }
            return;
        }
        this.m_miniGameTimer += n;
        if (this.m_miniGameTimer > this.m_miniGameTimerMax) {
            this.stateTransitionMiniGame(5);
            return;
        }
        int n2 = this.m_viewportX + (this.m_viewportWidth >> 1);
        int n3 = AnimationManager.getAnimFrameWidth(619, 0);
        int n4 = AnimationManager.getAnimFrameHeight(620, 0);
        int n5 = n2 - (n3 * this.m_cookingPotCount >> 1) + (n3 >> 1);
        int n6 = this.m_minigameTop + this.m_minigameBottom + n4 >> 1;
        int[] nArray = this.m_tempInt10;
        int n7 = n5;
        for (int i = 0; i < this.m_cookingPotCount; ++i) {
            int n8 = this.m_cookingLevelsF[i];
            if (n8 > 0) {
                this.m_cookingLevelsF[i] = n8 += n * this.m_cookingLevelIncreaseF;
            }
            if (n8 <= 0x640000) {
                int n9 = 32;
                int n10 = 623;
                if (n8 < 0x190000) {
                    n9 = 30;
                } else if (n8 < 0x4B0000) {
                    n9 = 31;
                    n10 = 622;
                }
                AnimPlayer animPlayer = this.m_miniGameAnimPool[i];
                animPlayer.startAnim(n9, 4);
                boolean bl = animPlayer.updateAnim(n);
                if (bl && animPlayer.getFirePointCurrFrame(nArray, 0)) {
                    this.miniGameStartAnim(43, n7 + nArray[0], n6 + nArray[1], 16);
                }
                AnimPlayer animPlayer2 = this.m_miniGameAnimPool[this.m_cookingPotCount + i];
                animPlayer2.startAnim(n10, 4);
            }
            this.m_displayedCookingLevelsF[i] = this.interpolateValue(this.m_displayedCookingLevelsF[i], n8, n, 8);
            if (n8 > 0x640000 || this.m_displayedCookingLevelsF[i] < 65536) {
                AnimationManager.getAnimFrameFirePoint(nArray, 620, 0, 0);
                this.m_cookingDeadPotAnim = this.miniGameStartAnim(618, n7 + nArray[0], n6 + nArray[1], 16);
                this.m_engine.vibrate();
                this.stateTransitionMiniGame(6);
            }
            n7 += n3;
        }
    }

    private void processKeysMiniGameCooking(int n, int n2) {
        int n3 = this.m_cookingPotCount;
        int n4 = this.m_cookingPotActive;
        if (this.checkKeys(n, n2, 32784, 0) && n4 > 0) {
            n4 = (n4 + n3 - 1) % n3;
        }
        if (this.checkKeys(n, n2, 65600, 0) && n4 < n3 - 1) {
            n4 = (n4 + 1) % n3;
        }
        if (this.checkKeys(n, n2, 4128, 0)) {
            int n5 = this.m_cookingLevelsF[n4];
            this.m_cookingLevelsF[n4] = n5 = Math.max(n5 - this.m_cookingLevelReduceF, 0);
        }
        this.m_cookingPotActive = n4;
        if (this.m_engine.m_debugCheatMenuEnabled && this.checkKeys(n, n2, 1, 0)) {
            this.m_miniGameTimer = this.m_miniGameTimerMax - 1;
        }
    }

    private void beginMiniGameFishing() {
        int n;
        int n2;
        int n3;
        AppEngine appEngine = this.m_engine;
        this.m_miniGameSkill = 2;
        this.m_keyLeft = false;
        this.m_keyRight = false;
        AppEngine.ASSERT(true, "fishy fish");
        AppEngine.ASSERT(false, "fishy fish");
        AppEngine.ASSERT(true, "fishy fish");
        AppEngine.ASSERT(true, "fishy fish");
        this.m_miniGameTargetObject.hide();
        int n4 = this.m_simData.getSkillRank(2);
        switch (n4) {
            default: {
                AppEngine.ASSERT(false, "invalid skill rank");
            }
            case 0: {
                n3 = 34;
                break;
            }
            case 1: {
                n3 = appEngine.rand(34, 35);
                break;
            }
            case 2: {
                n3 = appEngine.rand(34, 37);
                break;
            }
            case 3: {
                n3 = appEngine.rand(34, 38);
                break;
            }
            case 4: 
            case 5: {
                n3 = appEngine.rand(34, 39);
                if (n4 != 5 || n3 >= 37) break;
                n3 = appEngine.rand(34, 39);
            }
        }
        this.m_fishingFishType = n3;
        switch (n3) {
            default: {
                AppEngine.ASSERT(false, "invalid fish type");
            }
            case 34: {
                n2 = 32;
                n = 32768;
                break;
            }
            case 35: {
                n2 = 39;
                n = 26214;
                break;
            }
            case 37: {
                n2 = 45;
                n = 19660;
                break;
            }
            case 38: {
                n2 = 52;
                n = 13107;
                break;
            }
            case 36: 
            case 39: {
                n2 = 65;
                n = 13107;
            }
        }
        this.m_fishingFishSpeed = n2;
        this.m_fishingMinFishMove = n;
        this.m_fishingLevelF = 0;
        this.m_fishingCursorPosF = 65536;
        this.m_fishingFishPosF = this.m_engine.rand(0, 131071);
        this.m_fishingAnimPlayer = this.m_miniGameAnimPool[0];
        this.m_fishingAnimPlayer.startAnim(626, 20);
        this.m_fishingHighlightAnimPlayer = this.m_miniGameAnimPool[1];
        this.m_fishingHighlightAnimPlayer.startAnim(629, 20);
        this.fishPickNewDest();
    }

    private void beginMiniGameSkiing() {
        AppEngine appEngine = this.m_engine;
        this.m_miniGameSkill = 5;
        this.m_keyLeft = false;
        this.m_keyRight = false;
        if (appEngine.m_DrawBorderPoints == null) {
            appEngine.m_DrawBorderPoints = new AppEngine.DrawBorderPoints[MINI_GAME_SCREEN_HEIGHT / this.getCurrentGameSpeed() + 1];
            for (int i = 0; i < appEngine.m_DrawBorderPoints.length; ++i) {
                appEngine.m_DrawBorderPoints[i] = new AppEngine.DrawBorderPoints(STYLUS_TIP, this.getCurrentGameSpeed() * i);
            }
        } else {
            for (int i = 0; i < appEngine.m_DrawBorderPoints.length; ++i) {
                appEngine.m_DrawBorderPoints[i].pointY = this.getCurrentGameSpeed() * i;
            }
        }
        this.m_miniGameTargetObject.hide();
    }

    public int getCurrentGameSpeed() {
        switch (this.getCurrentSkillLevel()) {
            case 0: {
                SKIER_CURRENT_SPEED = 7;
                FLAG_TAKEN_VALIDATION = 5;
                break;
            }
            case 1: {
                SKIER_CURRENT_SPEED = 7;
                FLAG_TAKEN_VALIDATION = 5;
                break;
            }
            case 2: {
                SKIER_CURRENT_SPEED = 7;
                FLAG_TAKEN_VALIDATION = 5;
                break;
            }
            case 3: {
                SKIER_CURRENT_SPEED = 7;
                FLAG_TAKEN_VALIDATION = 5;
                break;
            }
            case 4: {
                SKIER_CURRENT_SPEED = 7;
                FLAG_TAKEN_VALIDATION = 5;
                break;
            }
            case 5: {
                SKIER_CURRENT_SPEED = 7;
                FLAG_TAKEN_VALIDATION = 5;
            }
        }
        return SKIER_CURRENT_SPEED;
    }

    private void initMiniGameSkiing() {
        int n;
        AppEngine appEngine = this.m_engine;
        START_GAME = false;
        MINIGAME_STARTED = false;
        PRESS_OK = false;
        GET_TIME = false;
        COLLISION_WITH_BORDER = false;
        COLLISION_WITH_OBSTACLE = false;
        VIBRATE_ON_COLLISION = false;
        LIFE_COUNT = 3;
        TIME_CAL = 0;
        SKIER_BLINKING = false;
        START_COUNTDOWN = false;
        GAME_TIMER_COUNT = 3;
        STYLUS_TIP = MINI_GAME_SCREEN_WIDTH - TRACK_WIDTH >> 1;
        CURVENESS = MINI_GAME_SCREEN_WIDTH - TRACK_WIDTH >> 1;
        START_PIT_Y = MINI_GAME_SCREEN_HEIGHT >> 1;
        SKIER_SPEED = 0;
        CAMERA_PANNING_FACTOR = 0;
        SKIER_CONDITION = 1;
        SKEER_BEHAVIOUR = 1;
        SKEER_X = STYLUS_TIP + (TRACK_WIDTH >> 1) - (AppEngine.skiing_sprite2.getWidth() >> 1);
        FLAG_TAKEN = 0;
        FLAG_Y = appEngine.getHeight();
        switchOutOfMiniGameSuccess = false;
        switchOutOfMiniGameFailure = false;
        for (n = 0; n < appEngine.m_DrawBorderPoints.length; ++n) {
            appEngine.m_DrawBorderPoints[n].pointX = MINI_GAME_SCREEN_WIDTH - TRACK_WIDTH >> 1;
        }
        for (n = 0; n < appEngine.m_Obstacle.length; ++n) {
            appEngine.m_Obstacle[n].obstacleX = MINI_GAME_SCREEN_WIDTH;
            appEngine.m_Obstacle[n].obstacleY = MINI_GAME_SCREEN_HEIGHT / 3 * (n + 1);
        }
        for (n = 0; n < appEngine.m_AddBoards.length; ++n) {
            appEngine.m_AddBoards[n].billBoard_x = MINI_GAME_SCREEN_WIDTH;
            appEngine.m_AddBoards[n].billBoard_y = MINI_GAME_SCREEN_HEIGHT / 3 * 0 + (AppEngine.adboard_red.getHeight() + 5) * n;
        }
        for (n = 0; n < appEngine.m_AddBoards.length; ++n) {
            appEngine.m_AddBoards1[n].billBoard_x = MINI_GAME_SCREEN_WIDTH;
            appEngine.m_AddBoards1[n].billBoard_y = MINI_GAME_SCREEN_HEIGHT / 3 * 1 + (AppEngine.adboard_red.getHeight() + 5) * n;
        }
        for (n = 0; n < appEngine.m_AddBoards.length; ++n) {
            appEngine.m_AddBoards2[n].billBoard_x = MINI_GAME_SCREEN_WIDTH;
            appEngine.m_AddBoards2[n].billBoard_y = MINI_GAME_SCREEN_HEIGHT / 3 * 2 + (AppEngine.adboard_red.getHeight() + 5) * n;
        }
        for (n = 0; n < appEngine.m_DrawTree.length; ++n) {
            appEngine.m_DrawTree[n].pointX = MINI_GAME_SCREEN_WIDTH + 20;
        }
        appEngine.initFence();
        for (n = 0; n < appEngine.m_Crowd.length; ++n) {
            appEngine.m_Crowd[n].x = MINI_GAME_SCREEN_WIDTH + 20;
        }
        appEngine.m_CandyCane.candyX = MINI_GAME_SCREEN_WIDTH + 20;
        appEngine.m_CandyCane.candyY = MINI_GAME_SCREEN_HEIGHT;
    }

    private void renderMiniGameSkee(Graphics graphics) {
        int n;
        AppEngine appEngine = this.m_engine;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
        if (START_GAME) {
            this.drawStylus(graphics);
            this.calculateTime();
        }
        for (n = 0; n < appEngine.m_DrawBorderPoints.length; ++n) {
            if (n % 2 != 0) continue;
            appEngine.m_DrawBorderPoints[n].drawBorderPoints(graphics);
        }
        for (n = 0; n < appEngine.m_AddBoards.length; ++n) {
            appEngine.m_AddBoards[n].drawAddBoards(graphics);
            appEngine.m_AddBoards1[n].drawAddBoards(graphics);
            appEngine.m_AddBoards2[n].drawAddBoards(graphics);
        }
        for (n = 0; n < appEngine.m_AddBoardsEA1.length; ++n) {
            appEngine.m_AddBoardsEA1[n].drawAddBoardsEA(graphics);
            appEngine.m_AddBoardsEA2[n].drawAddBoardsEA(graphics);
        }
        for (n = 0; n < appEngine.m_FencePoint2_0.length; ++n) {
            appEngine.m_FencePoint2_0[n].drawFencePoint2(graphics);
            appEngine.m_FencePoint2_1[n].drawFencePoint2(graphics);
            appEngine.m_FencePoint2_2[n].drawFencePoint2(graphics);
        }
        for (n = 0; n < appEngine.m_FencePoint.length; ++n) {
            appEngine.m_FencePoint[n].drawFencePoint(graphics);
            appEngine.m_FencePoint1[n].drawFencePoint(graphics);
            appEngine.m_FencePoint2[n].drawFencePoint(graphics);
        }
        for (n = 0; n < appEngine.m_Crowd.length; ++n) {
            appEngine.m_Crowd[n].drawCrowd(graphics);
        }
        for (n = 0; n < appEngine.m_DrawTree.length; ++n) {
            appEngine.m_DrawTree[n].drawTree(graphics);
        }
        appEngine.m_CandyCane.drawCandyCane(graphics);
        for (n = 0; n < appEngine.m_Obstacle.length; ++n) {
            appEngine.m_Obstacle[n].drawObstacle(graphics);
        }
        this.drawGameEnding();
        this.drawSkeer(graphics, SKEER_BEHAVIOUR, SKEER_X, SKEER_Y);
        this.drawStartPoint(graphics);
        this.renderskiingGameHud(graphics);
        if (collidedWithCandy) {
            this.drawBorder(graphics);
        }
    }

    public void drawBorder(Graphics graphics) {
        ++this.borderCounter;
        if (this.borderCounter < 15) {
            if (this.borderCounter >= 0 && this.borderCounter <= 3 || this.borderCounter > 6 && this.borderCounter <= 9 || this.borderCounter > 12 && this.borderCounter <= 15) {
                graphics.setColor(255, 0, 0);
                graphics.drawRect(0, SKIING_GAME_HUD, MINI_GAME_SCREEN_WIDTH - 3, MINI_GAME_SCREEN_HEIGHT - 15 - SKIING_GAME_HUD - 3);
                graphics.drawRect(1, SKIING_GAME_HUD + 1, MINI_GAME_SCREEN_WIDTH - 3, MINI_GAME_SCREEN_HEIGHT - 15 - SKIING_GAME_HUD - 3);
            }
        } else {
            this.borderCounter = 0;
            collidedWithCandy = false;
        }
    }

    public void drawStartPoint(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        if (START_PIT_Y > -AppEngine.start_Point.getHeight()) {
            graphics.drawImage(AppEngine.start_Point, (appEngine.getWidth() >> 1) - CAMERA_PANNING_FACTOR, START_PIT_Y, 17);
            START_PIT_Y -= SKIER_SPEED;
        }
    }

    public void drawGameEnding() {
        if (this.skiingGameSuccess()) {
            ++this.tempCounter;
            if (this.tempCounter % 3 == 0 && SKIER_SPEED > 0) {
                --SKIER_SPEED;
            }
            if (this.tempCounter < 22) {
                SKEER_BEHAVIOUR = 3;
            } else {
                this.tempCounter = 0;
                switchOutOfMiniGameSuccess = true;
            }
        } else if (this.lifeEnds() || this.timeEnds() || COLLISION_WITH_BORDER) {
            ++this.tempCounter;
            if (this.tempCounter % 3 == 0 && SKIER_SPEED > 0) {
                --SKIER_SPEED;
            }
            if (this.tempCounter < 22) {
                SKEER_BEHAVIOUR = 4;
            } else {
                this.tempCounter = 0;
                switchOutOfMiniGameFailure = true;
            }
        }
        if (COLLISION_WITH_BORDER && !VIBRATE_ON_COLLISION) {
            this.m_engine.vibrate(250);
            VIBRATE_ON_COLLISION = true;
        }
    }

    public void calculateTime() {
        if (this.miniGameOverByAnyCondition()) {
            return;
        }
        if (!GET_TIME) {
            SYSTEM_TIME = System.currentTimeMillis();
            TIME_CAL = this.getCurrentLevelTime();
            GET_TIME = true;
        }
        if ((SYSTEM_TEMP += System.currentTimeMillis() - SYSTEM_TIME) > 1000L) {
            --TIME_CAL;
            SYSTEM_TEMP = 0L;
        }
        SYSTEM_TIME = System.currentTimeMillis();
    }

    public boolean miniGameOverByAnyCondition() {
        return this.skiingGameSuccess() || this.lifeEnds() || this.timeEnds();
    }

    public void drawStylus(Graphics graphics) {
        SPEED_TO_CURVE_RATIO = this.getCurrentGameSpeed();
        if (GENERATE_NEXT_CURVE) {
            Random random = new Random();
            random.setSeed(System.currentTimeMillis());
            STYLUS_CURVE_PEAK_X = (MINI_GAME_SCREEN_WIDTH - CURVE_RENDERING_WIDTH >> 1) + CURVE_RENDERING_WIDTH / 5 * random.nextInt(3);
            GENERATE_NEXT_CURVE = false;
        }
        if (STYLUS_TIP > STYLUS_CURVE_PEAK_X) {
            CURVE_FACTOR = STYLUS_TIP - STYLUS_CURVE_PEAK_X < 10 && STYLUS_TIP - STYLUS_CURVE_PEAK_X > 6 ? SPEED_TO_CURVE_RATIO / 4.0f : (STYLUS_TIP - STYLUS_CURVE_PEAK_X < 7 && STYLUS_TIP - STYLUS_CURVE_PEAK_X > 3 ? SPEED_TO_CURVE_RATIO / 5.0f : (STYLUS_TIP - STYLUS_CURVE_PEAK_X < 4 ? SPEED_TO_CURVE_RATIO / 10.0f : SPEED_TO_CURVE_RATIO / 2.0f));
            CURVENESS -= CURVE_FACTOR;
        } else if (STYLUS_TIP < STYLUS_CURVE_PEAK_X) {
            CURVE_FACTOR = STYLUS_CURVE_PEAK_X - STYLUS_TIP < 10 && STYLUS_CURVE_PEAK_X - STYLUS_TIP > 6 ? SPEED_TO_CURVE_RATIO / 4.0f : (STYLUS_CURVE_PEAK_X - STYLUS_TIP < 7 && STYLUS_CURVE_PEAK_X - STYLUS_TIP > 3 ? SPEED_TO_CURVE_RATIO / 5.0f : (STYLUS_CURVE_PEAK_X - STYLUS_TIP < 4 ? SPEED_TO_CURVE_RATIO / 10.0f : SPEED_TO_CURVE_RATIO / 2.0f));
            CURVENESS += CURVE_FACTOR;
        } else {
            GENERATE_NEXT_CURVE = true;
        }
        STYLUS_TIP = (int)CURVENESS;
    }

    private int getCurrentSkillLevel() {
        SimData simData = this.m_simData;
        return simData.getSkillLevel(5) >> 16;
    }

    public boolean skiingGameSuccess() {
        int n = this.getCurrentSkillLevel();
        switch (n) {
            case 0: {
                FLAG_HAS_TO_TAKEN = 10;
                break;
            }
            case 1: {
                FLAG_HAS_TO_TAKEN = 15;
                break;
            }
            case 2: {
                FLAG_HAS_TO_TAKEN = 20;
                break;
            }
            case 3: {
                FLAG_HAS_TO_TAKEN = 25;
                break;
            }
            case 4: {
                FLAG_HAS_TO_TAKEN = 30;
                break;
            }
            case 5: {
                FLAG_HAS_TO_TAKEN = 30;
            }
        }
        return FLAG_HAS_TO_TAKEN == this.getFlagCount();
    }

    public int getCurrentLevelTime() {
        int n = this.getCurrentSkillLevel();
        switch (n) {
            case 1: {
                TIME = 90;
                break;
            }
            case 2: {
                TIME = 90;
                break;
            }
            case 3: {
                TIME = 90;
                break;
            }
            case 4: {
                TIME = 90;
                break;
            }
            case 0: {
                TIME = 90;
            }
        }
        return TIME;
    }

    private boolean skiiingMiniGameFinished() {
        return switchOutOfMiniGameSuccess || switchOutOfMiniGameFailure;
    }

    private int getFlagCount() {
        return FLAG_TAKEN;
    }

    public boolean lifeEnds() {
        if (LIFE_COUNT == 0) {
            if (!this.m_pauseMenuActive) {
                this.m_engine.vibrate(250);
            }
            return true;
        }
        return false;
    }

    public boolean timeEnds() {
        return TIME_CAL == -1;
    }

    private void drawSkeer(Graphics graphics, int n, int n2, int n3) {
        AppEngine appEngine = this.m_engine;
        SKIER_X = n2 + (SKEER_WIDTH >> 1);
        SKIER_Y = n3 + SKEER_HEIGHT;
        switch (n) {
            case 0: {
                appEngine.skeer = appEngine.skeer1;
                AppEngine.ski_sprite = AppEngine.skiing_sprite1;
                break;
            }
            case 1: {
                appEngine.skeer = appEngine.skeer2;
                AppEngine.ski_sprite = AppEngine.skiing_sprite2;
                break;
            }
            case 2: {
                appEngine.skeer = appEngine.skeer3;
                AppEngine.ski_sprite = AppEngine.skiing_sprite3;
                break;
            }
            case 3: {
                AppEngine.ski_sprite = AppEngine.skiing_sprite4;
                break;
            }
            case 4: {
                AppEngine.ski_sprite = AppEngine.skiing_sprite5;
            }
        }
        if (!SKIER_BLINKING) {
            if (n == 0 || n == 1 || n == 2) {
                graphics.drawImage(appEngine.skeer, n2, n3, 0);
            }
            AppEngine.ski_sprite.setRefPixelPosition(n2, n3);
            AppEngine.ski_sprite.paint(graphics);
        } else {
            if (this.animForSkierCollision()) {
                if (n == 0 || n == 1 || n == 2) {
                    graphics.drawImage(appEngine.skeer, n2, n3, 0);
                }
                AppEngine.ski_sprite.setRefPixelPosition(n2, n3);
                AppEngine.ski_sprite.paint(graphics);
            }
            if (--COLLISION_TIME < 0) {
                SKIER_BLINKING = false;
                COLLISION_TIME = BLINKING_EFFECT_INTERVAL;
            }
        }
        graphics.setClip(0, 0, appEngine.getWidth(), appEngine.getHeight());
    }

    public boolean animForSkierCollision() {
        if (--ANIM_COLLISION_TIME == 0) {
            SHOW_SKIER = !SHOW_SKIER;
            ANIM_COLLISION_TIME = 3;
        }
        return SHOW_SKIER;
    }

    private void renderskiingGameHud(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SDKString sDKString = new SDKString("" + this.getFlagCount());
        SDKString sDKString2 = new SDKString("/" + FLAG_HAS_TO_TAKEN);
        SDKString sDKString3 = new SDKString("x  " + LIFE_COUNT);
        SDKString sDKString4 = new SDKString("0:" + TIME_CAL);
        graphics.setColor(0);
        graphics.fillRect(0, 0, appEngine.getWidth(), SKIING_GAME_HUD);
        graphics.setColor(0xFFFFFF);
        graphics.drawImage(appEngine.hud_candy, (appEngine.getWidth() >> 1) - 10, SKIING_GAME_HUD >> 1, 3);
        appEngine.drawString(sDKString, 2, (appEngine.getWidth() >> 1) + 5, SKIING_GAME_HUD >> 1, 6);
        appEngine.drawString(sDKString2, 2, (appEngine.getWidth() >> 1) + 20, SKIING_GAME_HUD >> 1, 6);
        graphics.drawImage(appEngine.timer, appEngine.getWidth() - 50, SKIING_GAME_HUD >> 1, 3);
        appEngine.drawString(sDKString4, 2, appEngine.getWidth() - 10, SKIING_GAME_HUD >> 1, 10);
        graphics.drawImage(appEngine.life, 8, SKIING_GAME_HUD >> 1, 3);
        appEngine.drawString(sDKString3, 2, 8 + appEngine.life.getWidth() + 4, SKIING_GAME_HUD >> 1, 6);
        if (!PRESS_OK) {
            appEngine.drawString(37, 0, (appEngine.getWidth() >> 1) - 5, appEngine.getWidth() >> 1, 3);
        }
        if (START_COUNTDOWN) {
            this.renderskiingGameCountDown(graphics);
        }
    }

    private void renderskiingGameCountDown(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        if (!START_GAME) {
            int n = (appEngine.getWidth() >> 1) - (AppEngine.countdown.getWidth() >> 1);
            int n2 = (appEngine.getHeight() >> 1) - (AppEngine.countdown.getHeight() >> 2);
            int n3 = AppEngine.countdown.getWidth();
            int n4 = AppEngine.countdown.getHeight() / 4;
            int n5 = 0;
            if (GAME_COUNTDOWN_TIMER == 0) {
                GAME_COUNTDOWN_TIMER = COUNTDOWN_TIMER_INTERVAL;
                if (--GAME_TIMER_COUNT < 0) {
                    START_GAME = true;
                    SKIER_SPEED = this.getCurrentGameSpeed();
                    GAME_TIMER_COUNT = 3;
                    MINIGAME_STARTED = true;
                    START_COUNTDOWN = false;
                }
            }
            switch (GAME_TIMER_COUNT) {
                case 3: {
                    n5 = 0;
                    break;
                }
                case 2: {
                    n5 -= n4;
                    break;
                }
                case 1: {
                    n5 -= n4 * 2;
                    break;
                }
                case 0: {
                    n5 -= n4 * 3;
                }
            }
            graphics.setClip(n, n2, n3, n4);
            if (!MINIGAME_STARTED) {
                graphics.drawImage(AppEngine.countdown, n, n2 + n5, 0);
            }
            graphics.setClip(0, 0, appEngine.getWidth(), appEngine.getHeight());
            --GAME_COUNTDOWN_TIMER;
        }
    }

    private void renderMiniGameFishing(Graphics graphics) {
        if (this.m_miniGameState == 0 || this.m_miniGameState == 7) {
            return;
        }
        int n = this.m_viewportX + (this.m_viewportWidth >> 1);
        int n2 = this.m_minigameBottom + 18;
        AnimationManager.drawAnimFrame(graphics, 631, 0, n, n2);
        int[] nArray = this.m_tempInt10;
        AnimationManager.getAnimFrameCollisionBox(nArray, 631, 0, 0);
        int n3 = n2 + nArray[1] + nArray[3];
        int n4 = n + nArray[0];
        int n5 = nArray[2];
        int n6 = n4 + MathExt.Fmul(n5, MathExt.Fdiv(this.m_fishingCursorPosF, 131072));
        if (this.fishInZone()) {
            int n7;
            int n8;
            int n9 = -1;
            if (this.m_fishingLevelF < 58982) {
                n8 = AnimationManager.getAnimFrameCount(628);
                n7 = 65536 / n8;
                n9 = this.m_fishingLevelF / n7;
            }
            n8 = graphics.getClipX();
            n7 = graphics.getClipY();
            int n10 = graphics.getClipWidth();
            int n11 = graphics.getClipHeight();
            graphics.setClip(n4, n7, n5, n11);
            if (n9 != -1) {
                AnimationManager.drawAnimFrame(graphics, 628, n9, n6, n3);
            } else {
                AnimationManager.drawAnim(graphics, this.m_fishingHighlightAnimPlayer, n6, n3);
            }
            graphics.setClip(n8, n7, n10, n11);
        }
        if (this.m_fishingLevelF > -16384 && this.m_fishingLevelF < 65536) {
            AnimationManager.drawAnimFrame(graphics, 630, 0, n6, n3);
        }
        n6 = n4 + MathExt.Fmul(n5, MathExt.Fdiv(this.m_fishingFishPosF, 131072));
        AnimationManager.drawAnim(graphics, this.m_fishingAnimPlayer, n6, n3);
    }

    private void updateMiniGameFishing(int n) {
        int n2;
        int n3;
        MapObjectSim mapObjectSim = this.getPlayerSim();
        if (this.m_miniGameState == 7) {
            if (!mapObjectSim.isAnimating()) {
                this.stateTransitionMiniGame(1);
            }
            return;
        }
        if (this.m_miniGameState == 8) {
            if (!mapObjectSim.isAnimating()) {
                int n4 = this.fishingSuccess() ? 2 : 3;
                this.stateTransitionMiniGame(n4);
            }
            return;
        }
        int n5 = 0;
        if (this.m_keyLeft) {
            n5 -= n;
        }
        if (this.m_keyRight) {
            n5 += n;
        }
        if (n5 != 0) {
            n3 = this.m_fishingCursorPosF + n5 * 131;
            this.m_fishingCursorPosF = Math.max(Math.min(n3, 131072), 0);
        }
        this.m_fishingAnimPlayer.updateAnim(n);
        this.m_fishingHighlightAnimPlayer.updateAnim(n);
        if (this.m_fishingLevelF >= 65536) {
            if (!this.m_fishingAnimPlayer.isAnimating()) {
                this.stateTransitionMiniGame(8);
                return;
            }
        } else {
            n3 = this.fishInZone() ? 196 : -262;
            this.m_fishingLevelF += n3;
            if (this.m_fishingLevelF <= -16384) {
                this.m_engine.vibrate();
                this.stateTransitionMiniGame(8);
                return;
            }
            if (this.m_fishingLevelF >= 65536) {
                this.m_fishingLevelF = 65535;
            }
            n2 = 626;
            if (this.m_fishingLevelF > 32768) {
                n2 = 627;
            }
            this.m_fishingAnimPlayer.startAnim(n2, 4);
        }
        if (this.m_fishingLevelF > -16384 && this.m_fishingLevelF < 65536) {
            n3 = this.m_fishingFishPosToF < this.m_fishingFishPosFromF ? 1 : 0;
            n2 = n3 != 0 ? -n : n;
            this.m_fishingFishPosF += this.m_fishingFishSpeed * n2;
            if (n3 != 0 && this.m_fishingFishPosF < this.m_fishingFishPosToF || n3 == 0 && this.m_fishingFishPosF > this.m_fishingFishPosToF) {
                this.m_fishingFishPosF = this.m_fishingFishPosToF;
                this.fishPickNewDest();
            }
        }
        n3 = 24;
        if (this.m_fishingLevelF > 32768) {
            n3 = 25;
        }
        mapObjectSim.setRuntimeFlag(128);
        mapObjectSim.setSubAppearance(n3);
    }

    private void updateMiniGameSkiing(int n) {
        MapObjectSim mapObjectSim = this.getPlayerSim();
        if (this.m_miniGameState == 10) {
            this.stateTransitionMiniGame(1);
            return;
        }
        if (this.skiiingMiniGameFinished()) {
            this.stateTransitionMiniGame(11);
            this.initMiniGameSkiing();
            return;
        }
    }

    private boolean fishingSuccess() {
        return this.m_fishingLevelF == 65536;
    }

    private boolean fishInZone() {
        int n = Math.abs(this.m_fishingCursorPosF - this.m_fishingFishPosF);
        return n < 26214;
    }

    private void fishPickNewDest() {
        int n = this.m_fishingFishPosF;
        int n2 = Math.max(n, 131072 - n);
        int n3 = this.m_engine.rand(this.m_fishingMinFishMove, n2);
        boolean bl = n > 131072 - n3 ? true : (n < n3 ? false : this.m_engine.randPercent() < 50);
        this.m_fishingFishPosFromF = n;
        this.m_fishingFishPosToF = n + (bl ? -n3 : n3);
    }

    private void processKeysMiniGameFishing(int n, int n2) {
        if (this.m_fishingLevelF > -16384 && this.m_fishingLevelF < 65536) {
            this.m_keyLeft = (n & 0x8010) != 0;
            this.m_keyRight = (n & 0x10040) != 0;
        } else {
            this.m_keyLeft = false;
            this.m_keyRight = false;
        }
        if (this.checkKeys(n, n2, 4128, 0) && this.m_fishingLevelF >= 58982) {
            if (this.fishInZone()) {
                this.m_fishingCursorPosF = this.m_fishingFishPosF;
                this.m_fishingAnimPlayer.startAnim(625, 16);
                this.m_fishingLevelF = 65536;
            } else {
                this.m_engine.vibrate();
                this.stateTransitionMiniGame(8);
            }
        }
        if (this.m_engine.m_debugCheatMenuEnabled && this.checkKeys(n, n2, 1, 0)) {
            this.m_fishingCursorPosF = this.m_fishingFishPosF;
            this.m_fishingAnimPlayer.startAnim(625, 16);
            this.m_fishingLevelF = 65536;
        }
    }

    private void processKeysMiniGameSkiing(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        if (START_GAME && !this.miniGameOverByAnyCondition()) {
            if (this.checkKeys(n, n2, 32784, 0) && SKIER_CONDITION != 0) {
                --SKIER_CONDITION;
            }
            if (this.checkKeys(n, n2, 65600, 0) && SKIER_CONDITION != 2) {
                ++SKIER_CONDITION;
            }
            switch (SKIER_CONDITION) {
                case 0: {
                    SKEER_BEHAVIOUR = 0;
                    CAMERA_PANNING_FACTOR -= 3;
                    break;
                }
                case 1: {
                    SKEER_BEHAVIOUR = 1;
                    break;
                }
                case 2: {
                    SKEER_BEHAVIOUR = 2;
                    CAMERA_PANNING_FACTOR += 3;
                }
            }
        }
        if (this.checkKeys(n, n2, 4128, 0)) {
            PRESS_OK = true;
            if (MINIGAME_STARTED) {
                SKIER_SPEED = this.getCurrentGameSpeed();
                START_GAME = true;
            } else {
                START_COUNTDOWN = true;
            }
        }
    }

    private void loadRepairingMiniGameBoard(int n) {
        int n2 = 0;
        DataInputStream dataInputStream = new DataInputStream(this.m_engine.getResourceManager().loadBinaryFile(n));
        try {
            int n3;
            byte[][] byArrayArray = new byte[4][];
            for (int i = 0; i < 4; ++i) {
                n3 = dataInputStream.readByte();
                ++n2;
                byte[] byArray = new byte[n3];
                for (int j = 0; j < n3; ++j) {
                    byArray[j] = dataInputStream.readByte();
                    ++n2;
                }
                byArrayArray[i] = byArray;
            }
            this.m_repairWirePaths = byArrayArray;
            if (this.m_repairWireEnds == null) {
                this.m_repairWireEnds = new byte[4];
            }
            byte[] byArray = this.m_repairWireEnds;
            for (n3 = 0; n3 < 4; ++n3) {
                byArray[n3] = dataInputStream.readByte();
                ++n2;
            }
        }
        catch (IOException iOException) {
            this.m_repairWirePaths = null;
            this.m_repairWireEnds = null;
        }
    }

    private void beginMiniGameRepairing() {
        int n;
        AppEngine appEngine = this.m_engine;
        switch (appEngine.rand(0, 4)) {
            default: 
        }
        this.loadRepairingMiniGameBoard(55);
        this.m_miniGameSkill = 3;
        int n2 = (this.m_simData.getSkillLevel(3) >> 2) + 65536;
        this.m_repairingAnimPlayer = this.m_miniGameAnimPool[0];
        this.m_repairingNumWires = n = this.m_simData.getSkillRank(3) < 3 ? 3 : 4;
        this.m_miniGameTimerMax = this.m_repairingNumSparks = 10 * n2 >> 16;
        this.m_repairingClippersPosF = 65536;
        this.m_repairWireStartEndsPos = new short[n][5];
        int n3 = AnimationManager.getAnimFrameWidth(639, 0);
        int n4 = n3 / REPAIR_WIRE_DX[0];
        int n5 = n4 << 2;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = this.m_repairWirePaths[i];
            short[] sArray = this.m_repairWireStartEndsPos[i];
            int n6 = byArray.length;
            int n7 = 0;
            int n8 = i * n5;
            sArray[0] = (short)n7;
            sArray[1] = (short)n8;
            for (int j = 0; j < n6; ++j) {
                byte by = byArray[j];
                n7 += REPAIR_WIRE_DX[by] * n4;
                n8 += REPAIR_WIRE_DY[by] * n4;
                if (by != 1 && by != 2) continue;
                sArray[4] = (short)n7;
            }
            sArray[2] = (short)n7;
            sArray[3] = (short)n8;
        }
        this.m_repairingSparkTimer = 1;
        this.m_repairingAnimPlayer.startAnim(633, 20);
    }

    private void renderMiniGameRepairing(Graphics graphics) {
        int n;
        int n2 = AnimationManager.getAnimFrameWidth(639, 0);
        int n3 = n2 / REPAIR_WIRE_DX[0];
        int n4 = n3 << 2;
        int n5 = n4 * this.m_repairingNumWires;
        int n6 = this.m_minigameTop + this.m_minigameBottom - n5 >> 1;
        int n7 = n6 + n4;
        int n8 = this.m_viewportX + (this.m_viewportWidth >> 1) - (this.m_viewportWidth >> 2);
        int n9 = n8 + n3 * 11;
        this.renderTiledArea(graphics, this.m_viewportX + 10, this.m_minigameTop + 0, this.m_viewportWidth - 20, this.m_minigameBottom - this.m_minigameTop - 0, 632);
        for (n = 0; n < this.m_repairingNumWires; ++n) {
            int n10 = n8;
            int n11 = n7 + n * n4;
            AnimationManager.drawAnimFrame(graphics, 636, 0, n10, n11);
            byte[] byArray = this.m_repairWirePaths[n];
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                AnimationManager.drawAnimFrame(graphics, 639, by, n10, n11);
                n10 += REPAIR_WIRE_DX[by] * n3;
                n11 += REPAIR_WIRE_DY[by] * n3;
            }
        }
        n = n6 + MathExt.Fmul(n5, MathExt.Fdiv(this.m_repairingClippersPosF, 131072));
        this.m_repairingAnimPlayer.drawAnim(graphics, n9, n);
        this.miniGameRenderAnimPoolFixed(graphics, 1, n8, n7);
    }

    private void processKeysMiniGameRepairing(int n, int n2) {
        this.processKeysCursorDirs(n);
        if (this.m_repairingAnimPlayer.isLooping() && this.checkKeys(n, n2, 4128, 0)) {
            this.repairingFire();
        }
        if (this.m_engine.m_debugCheatMenuEnabled && this.checkKeys(n, n2, 1, 0)) {
            this.stateTransitionMiniGame(2);
        }
    }

    private void updateMiniGameRepairing(int n) {
        switch (this.m_miniGameState) {
            case 1: {
                int n2;
                int n3;
                this.m_repairingAnimPlayer.updateAnim(n);
                int n4 = this.m_simData.getSkillLevel(3) / 5;
                if (!this.m_repairingAnimPlayer.isAnimating()) {
                    this.m_repairingAnimPlayer.startAnim(633, 20);
                    this.repairingCreateCursorSpark();
                }
                this.miniGameUpdateAnimPool(n, 1);
                if (this.m_repairingAnimPlayer.isLooping()) {
                    n3 = n * ((this.m_keyDown ? 65 : 0) + (this.m_keyUp ? -65 : 0));
                    n2 = this.m_repairingClippersPosF + n3;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > 131072) {
                        n2 = 131072;
                    }
                    this.m_repairingClippersPosF = n2;
                }
                n3 = 0;
                for (n2 = 1; n2 < 24; ++n2) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    AnimPlayer animPlayer = this.m_miniGameAnimPool[n2];
                    if (!animPlayer.isAnimating()) continue;
                    n3 = 1;
                    int[] nArray = this.m_miniGameAnimPoolPos[n2];
                    int n11 = nArray[2];
                    if (n11 == -1) continue;
                    boolean bl = (n11 & 0x10000) != 0;
                    short[] sArray = this.m_repairWireStartEndsPos[n11 &= 0xFFFF];
                    if (bl) {
                        n10 = sArray[2] << 16;
                        n9 = sArray[3] << 16;
                        n8 = sArray[0] << 16;
                        n7 = sArray[1] << 16;
                    } else {
                        n10 = sArray[0] << 16;
                        n9 = sArray[1] << 16;
                        n8 = sArray[2] << 16;
                        n7 = sArray[3] << 16;
                    }
                    int n12 = sArray[4] << 16;
                    int n13 = nArray[0];
                    int n14 = nArray[1];
                    if (n13 == n12) {
                        n6 = 0;
                        n5 = MathExt.sign(n7 - n9);
                    } else {
                        n6 = MathExt.sign(n8 - n10);
                        n5 = 0;
                    }
                    int n15 = (n4 >> 1) + 65536;
                    int n16 = MathExt.Fmul(n * 1310, n15);
                    int n17 = n13 + n6 * n16;
                    int n18 = n14 + n5 * n16;
                    if (n6 > 0 && n13 < n12 && n17 > n12 || n6 < 0 && n13 > n12 && n17 < n12) {
                        n17 = n12;
                    } else {
                        if (n6 > 0 && n13 < n8 && n17 >= n8 || n6 < 0 && n13 > n8 && n17 <= n8) {
                            animPlayer.setAnimating(false);
                            this.m_engine.vibrate();
                            this.stateTransitionMiniGame(3);
                            return;
                        }
                        if (n5 > 0 && n14 < n7 && n18 >= n7 || n5 < 0 && n14 > n7 && n18 <= n7) {
                            n18 = n7;
                            n17 = n12 + MathExt.sign(n8 - n10);
                        }
                    }
                    for (int i = 1; i < 24; ++i) {
                        int n19;
                        int[] nArray2;
                        int n20;
                        AnimPlayer animPlayer2 = this.m_miniGameAnimPool[i];
                        if (i == n2 || !animPlayer2.isAnimating() || (n20 = (nArray2 = this.m_miniGameAnimPoolPos[i])[2] & 0xFFFF) != n11 || (n19 = Math.abs(nArray2[0] - n17) + Math.abs(nArray2[1] - n18)) >= 196608) continue;
                        animPlayer.startAnim(638, 16);
                        nArray[2] = -1;
                        animPlayer2.setAnimating(false);
                        nArray2[2] = -1;
                    }
                    nArray[0] = n17;
                    nArray[1] = n18;
                }
                if (this.m_repairingNumSparks > 0) {
                    this.m_repairingSparkTimer -= n;
                    if (this.m_repairingSparkTimer > 0) break;
                    n2 = this.m_engine.rand(0, this.m_repairingNumWires - 1);
                    this.repairingCreateSpark(n2, false);
                    --this.m_repairingNumSparks;
                    ++this.m_miniGameTimer;
                    int n21 = 5000 * (65536 - (n4 >> 1)) >> 16;
                    this.m_repairingSparkTimer = 1000 + this.m_engine.rand(0, n21);
                    break;
                }
                if (n3 != 0) break;
                this.stateTransitionMiniGame(2);
                break;
            }
        }
    }

    private void repairingFire() {
        int n;
        int n2 = 131072 / this.m_repairingNumWires;
        int n3 = Math.min(this.m_repairingClippersPosF / n2, this.m_repairingNumWires - 1);
        this.m_repairingClippersPosF = n = n3 * n2 + (n2 >> 1);
        this.m_repairingAnimPlayer.startAnim(634, 16);
    }

    private void repairingCreateCursorSpark() {
        int n = 131072 / this.m_repairingNumWires;
        int n2 = Math.min(this.m_repairingClippersPosF / n, this.m_repairingNumWires - 1);
        int n3 = AppEngine.indexOf(n2, this.m_repairWireEnds);
        this.repairingCreateSpark(n3, true);
    }

    private void repairingCreateSpark(int n, boolean bl) {
        int n2;
        short s;
        short s2;
        short[] sArray = this.m_repairWireStartEndsPos[n];
        if (bl) {
            s2 = sArray[2];
            s = sArray[3];
            n2 = 637;
        } else {
            s2 = sArray[0];
            s = sArray[1];
            n2 = 635;
        }
        int n3 = this.miniGameStartAnim(n2, s2 << 16, s << 16, 20);
        if (n3 != -1) {
            this.m_miniGameAnimPoolPos[n3][2] = n | (bl ? 65536 : 0);
        }
    }

    private void beginMiniGameCleaning() {
        int n;
        int n2;
        int n3;
        AppEngine appEngine = this.m_engine;
        this.m_miniGameSkill = 1;
        int n4 = this.m_simData.getSkillRank(1);
        switch (n4) {
            default: {
                AppEngine.ASSERT(false, "invalid skill rank");
            }
            case 0: {
                n3 = 32768;
                n2 = 19660;
                n = 45000;
                break;
            }
            case 1: {
                n3 = 32768;
                n2 = 29491;
                n = 40000;
                break;
            }
            case 2: {
                n3 = 39321;
                n2 = 39321;
                n = 40000;
                break;
            }
            case 3: {
                n3 = 49152;
                n2 = 52428;
                n = 35000;
                break;
            }
            case 4: 
            case 5: {
                n3 = 65536;
                n2 = 65536;
                n = 30000;
            }
        }
        this.m_cleaningWobbleAccelF = n3;
        this.m_cleaningWobbleRange = n2;
        this.m_miniGameTimerMax = n;
        this.m_cleaningAnimPlayer = this.m_miniGameAnimPool[1];
        this.m_cleaningAnimPlayer.startAnim(614, 20);
        int n5 = AnimationManager.getAnimFrameWidth(612, 0);
        int n6 = 4 * n5;
        int n7 = 4 * n5;
        int n8 = AnimationManager.getAnimFrameWidth(615, 0);
        int n9 = AnimationManager.getAnimFrameHeight(615, 0);
        int n10 = n8;
        int n11 = n9;
        int n12 = n6 - n8;
        int n13 = n7 - n9;
        int n14 = 5;
        for (int i = 0; i < n14; ++i) {
            int[] nArray = this.m_miniGameAnimPoolPos[i + 2];
            nArray[0] = appEngine.rand(n10, n12);
            nArray[1] = appEngine.rand(n11, n13);
            nArray[2] = 0;
        }
        this.stopCursor();
        this.m_cleaningCursorPosXF = 262144;
        this.m_cleaningCursorPosYF = 262144;
        this.m_cleaningCursorDirtIndex = -1;
        this.m_cleaningWobbleVelXF = MathExt.Fmul(1966, this.m_cleaningWobbleAccelF);
        this.m_cleaningWobbleVelYF = MathExt.Fmul(1638, this.m_cleaningWobbleAccelF);
        this.m_cleaningWobbleOffsetXF = 0;
        this.m_cleaningWobbleOffsetYF = 0;
        this.m_miniGameTimer = 0;
    }

    private void renderMiniGameCleaning(Graphics graphics) {
        int n;
        int n2;
        int n3 = AnimationManager.getAnimFrameWidth(612, 0);
        int n4 = 4 * n3;
        int n5 = 4 * n3;
        this.renderTiledArea(graphics, this.m_viewportX + 15, this.m_minigameTop + 5, this.m_viewportWidth - 30, this.m_minigameBottom - this.m_minigameTop - 10, 612);
        int n6 = this.m_viewportX + (this.m_viewportWidth >> 1);
        int n7 = n6 - (n4 >> 1);
        int n8 = this.m_minigameTop + this.m_minigameBottom - n5 >> 1;
        for (n2 = 2; n2 < 24; ++n2) {
            int[] nArray = this.m_miniGameAnimPoolPos[n2];
            n = nArray[2];
            if (n == -1) continue;
            AnimationManager.drawAnimFrame(graphics, 615, n, n7 + nArray[0], n8 + nArray[1]);
        }
        n2 = this.m_cleaningCursorPosXF + this.m_cleaningWobbleOffsetXF >> 3;
        int n9 = this.m_cleaningCursorPosYF + this.m_cleaningWobbleOffsetYF >> 3;
        n = MathExt.Fmul(n2, n4);
        int n10 = MathExt.Fmul(n9, n5);
        this.m_cleaningAnimPlayer.drawAnim(graphics, n7 + n, n8 + n10);
        this.miniGameRenderAnimPool(graphics, 2, n7, n8);
    }

    private void processKeysMiniGameCleaning(int n, int n2) {
        this.processKeysCursorDirs(n);
        if (this.m_cleaningAnimPlayer.getAnimID() != 613 && this.checkKeys(n, n2, 4128, 0)) {
            this.m_cleaningAnimPlayer.startAnim(613, 16);
        }
        if (this.m_engine.m_debugCheatMenuEnabled && this.checkKeys(n, n2, 1, 0)) {
            this.stateTransitionMiniGame(2);
        }
    }

    private void updateMiniGameCleaning(int n) {
        switch (this.m_miniGameState) {
            case 1: {
                int n2;
                int n3;
                int n4;
                int n5;
                this.miniGameUpdateAnimPool(n, 2);
                this.m_cleaningAnimPlayer.updateAnim(n);
                if (!this.m_cleaningAnimPlayer.isAnimating()) {
                    this.m_cleaningAnimPlayer.startAnim(614, 20);
                    this.cleaningCleanDirt(this.m_cleaningCursorDirtIndex);
                }
                if (this.m_cleaningAnimPlayer.getAnimID() != 613) {
                    n5 = n * ((this.m_keyRight ? 229 : 0) + (this.m_keyLeft ? -229 : 0));
                    int n6 = n * ((this.m_keyDown ? 229 : 0) + (this.m_keyUp ? -229 : 0));
                    this.m_cleaningCursorPosXF = Math.max(0, Math.min(524288, this.m_cleaningCursorPosXF + n5));
                    this.m_cleaningCursorPosYF = Math.max(0, Math.min(524288, this.m_cleaningCursorPosYF + n6));
                    this.m_cleaningWobbleVelXF += n;
                    this.m_cleaningWobbleVelYF += n;
                    n4 = MathExt.Fmul(this.m_cleaningWobbleAccelF, 1966);
                    n3 = MathExt.Fmul(this.m_cleaningWobbleAccelF, 1638);
                    if (this.m_cleaningWobbleVelXF > n4) {
                        this.m_cleaningWobbleVelXF = 0;
                    }
                    if (this.m_cleaningWobbleVelXF > n4 >> 1) {
                        n2 = MathExt.smoothstepF(n4 >> 1, n4, this.m_cleaningWobbleVelXF);
                        this.m_cleaningWobbleOffsetXF = this.m_cleaningWobbleRange - MathExt.Fmul(n2, this.m_cleaningWobbleRange);
                    } else {
                        n2 = MathExt.smoothstepF(0, n4 >> 1, this.m_cleaningWobbleVelXF);
                        this.m_cleaningWobbleOffsetXF = MathExt.Fmul(n2, this.m_cleaningWobbleRange);
                    }
                    this.m_cleaningWobbleOffsetXF -= this.m_cleaningWobbleRange >> 1;
                    if (this.m_cleaningWobbleVelYF > n3) {
                        this.m_cleaningWobbleVelYF = 0;
                    }
                    if (this.m_cleaningWobbleVelYF > n3 >> 1) {
                        n2 = MathExt.smoothstepF(n3 >> 1, n3, this.m_cleaningWobbleVelYF);
                        this.m_cleaningWobbleOffsetYF = this.m_cleaningWobbleRange - MathExt.Fmul(n2, this.m_cleaningWobbleRange);
                    } else {
                        n2 = MathExt.smoothstepF(0, n3 >> 1, this.m_cleaningWobbleVelYF);
                        this.m_cleaningWobbleOffsetYF = MathExt.Fmul(n2, this.m_cleaningWobbleRange);
                    }
                    this.m_cleaningWobbleOffsetYF -= this.m_cleaningWobbleRange >> 1;
                }
                n5 = AnimationManager.getAnimFrameWidth(612, 0);
                int n7 = 4 * n5;
                n4 = 4 * n5;
                n3 = this.m_cleaningCursorPosXF + this.m_cleaningWobbleOffsetXF >> 3;
                n2 = this.m_cleaningCursorPosYF + this.m_cleaningWobbleOffsetYF >> 3;
                int n8 = MathExt.Fmul(n3, n7);
                int n9 = MathExt.Fmul(n2, n4);
                boolean bl = true;
                int n10 = -1;
                int n11 = -1;
                for (int i = 2; i < 24; ++i) {
                    int[] nArray = this.m_miniGameAnimPoolPos[i];
                    int n12 = nArray[2];
                    if (n12 == -1) continue;
                    bl = false;
                    int n13 = nArray[0] - n8;
                    int n14 = nArray[1] - n9;
                    int n15 = n13 * n13 + n14 * n14;
                    if (n10 != -1 && n15 >= n11) continue;
                    n10 = i;
                    n11 = n15;
                }
                if (n11 > 225) {
                    n10 = -1;
                }
                this.m_cleaningCursorDirtIndex = n10;
                if (bl) {
                    this.stateTransitionMiniGame(9);
                    break;
                }
                this.m_miniGameTimer += n;
                if (this.m_miniGameTimer <= this.m_miniGameTimerMax) break;
                this.m_engine.vibrate();
                this.stateTransitionMiniGame(9);
                break;
            }
            case 9: {
                this.miniGameUpdateAnimPool(n, 2);
                this.m_miniGameAnimPool[0].updateAnim(n);
                if (this.m_stateTime <= 3200) break;
                if (this.m_miniGameTimer <= this.m_miniGameTimerMax) {
                    this.stateTransitionMiniGame(2);
                    break;
                }
                this.stateTransitionMiniGame(3);
            }
        }
    }

    private void cleaningCleanDirt(int n) {
        if (n != -1) {
            int[] nArray = this.m_miniGameAnimPoolPos[n];
            int n2 = nArray[2];
            if (++n2 >= AnimationManager.getAnimFrameCount(615)) {
                n2 = -1;
                this.m_miniGameAnimPool[n].startAnim(616, 16);
            }
            nArray[2] = n2;
        }
    }

    public void openShop(MapObject mapObject) {
        int n = mapObject.getType();
        if (n == 115 && !this.m_engine.isBonusUnlocked()) {
            this.showMessageBox(792, 791);
            return;
        }
        this.m_shoppingObjectType = n;
        this.m_shoppingTradeAmount = 0;
        this.stateTransition(17);
        this.stateTransitionShopping(0);
    }

    private void stateTransitionShopping(int n) {
        this.m_shoppingState = n;
        switch (n) {
            case 0: {
                this.initListShopping();
                break;
            }
            case 1: {
                this.stateTransition(5);
            }
        }
        this.setupSoftkeys();
    }

    private void renderShopping(Graphics graphics) {
        switch (this.m_shoppingState) {
            case 0: {
                this.renderShoppingBrowseMenu(graphics);
            }
        }
        this.renderSoftkeyBar(graphics);
    }

    private void renderShoppingBrowseMenu(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = this.m_simWorld;
        SimData simData = this.m_simData;
        int n = simWorld.getItemNthItem(this.m_shoppingObjectType, this.getListCursor());
        this.setUIPlaceholderString(1, this.m_simWorld.getObjectStringId(this.m_shoppingObjectType));
        int n2 = simWorld.getItemBuyPrice(n);
        if (n2 > 0) {
            SDKString sDKString = appEngine.clearStringBuffer();
            appEngine.appendMoneyToBuffer(n2);
            appEngine.dynamicString(-9, sDKString);
            this.setUIPlaceholderString(2, -9);
        } else {
            this.setUIPlaceholderString(2, 718);
        }
        int n3 = simWorld.getItemSellPrice(n);
        if (n3 > 0) {
            SDKString sDKString = appEngine.clearStringBuffer();
            appEngine.appendMoneyToBuffer(n3);
            appEngine.dynamicString(-8, sDKString);
            this.setUIPlaceholderString(3, -8);
        } else {
            this.setUIPlaceholderString(3, 718);
        }
        int n4 = this.m_shoppingTradeAmount >= 0 ? this.m_shoppingTradeAmount * n2 : -this.m_shoppingTradeAmount * n3;
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendIntToBuffer(simData.getInventoryCount(n));
        appEngine.appendStringIdToBuffer(30);
        appEngine.appendIntToBuffer(simWorld.getItemMaxInventory(n));
        appEngine.dynamicString(-7, sDKString);
        this.setUIPlaceholderString(4, -7);
        sDKString = appEngine.clearStringBuffer();
        appEngine.appendIntToBuffer(this.m_shoppingTradeAmount);
        appEngine.dynamicString(-6, sDKString);
        this.setUIPlaceholderString(5, -6);
        sDKString = appEngine.clearStringBuffer();
        appEngine.appendMoneyToBuffer(n4);
        appEngine.dynamicString(-5, sDKString);
        this.setUIPlaceholderString(6, -5);
        this.drawUIFullScreen(graphics, 22);
    }

    private void initListShopping() {
        this.initList(this.m_simWorld.getItemNthCount(this.m_shoppingObjectType), 18, 0);
    }

    private void processKeysShopping(int n, int n2) {
        SimData simData = this.m_simData;
        SimWorld simWorld = this.m_simWorld;
        switch (this.m_shoppingState) {
            case 0: {
                if (this.checkKeys(n, n2, 0, 4)) {
                    this.stateTransitionShopping(1);
                    return;
                }
                if (this.processKeysList(n, n2)) {
                    this.setShoppingTradeAmount(0);
                    break;
                }
                if (this.checkKeys(n, n2, 4128, 12288) && this.m_shoppingTradeAmount != 0) {
                    int n3 = simWorld.getItemNthItem(this.m_shoppingObjectType, this.getListCursor());
                    int n4 = this.m_shoppingTradeAmount * (this.m_shoppingTradeAmount > 0 ? simWorld.getItemBuyPrice(n3) : simWorld.getItemSellPrice(n3));
                    simData.adjustInventory(n3, this.m_shoppingTradeAmount);
                    if (this.m_shoppingTradeAmount > 0) {
                        simData.registerBuyItem(n3);
                    }
                    simData.adjustMoney(-n4);
                    this.setShoppingTradeAmount(0);
                    break;
                }
                if (this.checkKeys(n, n2, 32784, 0)) {
                    this.setShoppingTradeAmount(this.m_shoppingTradeAmount - 1);
                }
                if (!this.checkKeys(n, n2, 65600, 0)) break;
                this.setShoppingTradeAmount(this.m_shoppingTradeAmount + 1);
            }
        }
    }

    private void setShoppingTradeAmount(int n) {
        SimData simData = this.m_simData;
        SimWorld simWorld = this.m_simWorld;
        int n2 = simWorld.getItemNthItem(this.m_shoppingObjectType, this.getListCursor());
        int n3 = simData.getMoney();
        int n4 = simWorld.getItemBuyPrice(n2);
        int n5 = simWorld.getItemSellPrice(n2);
        int n6 = n4 <= 0 ? 0 : Math.min(Math.min(simWorld.getItemMaxInventory(n2) - simData.getInventoryCount(n2), n3 / n4), simWorld.getItemMaxInventory(n2));
        int n7 = n5 <= 0 ? 0 : -simData.getInventoryCount(n2);
        this.m_shoppingTradeAmount = MathExt.clip(n, n7, n6);
        this.setupSoftkeys();
    }

    public void activateCheatMenu() {
        if (!(m_state != 5 || this.m_pauseMenuActive && this.m_pauseMenuState == 5)) {
            this.hideMenus();
            this.showPauseMenu();
            this.stateTransitionPauseMenu(5);
        }
    }

    private void initCheatMenu() {
        AppEngine appEngine = this.m_engine;
        SimData simData = this.m_simData;
        short[] sArray = new short[35];
        SDKString[] sDKStringArray = new SDKString[35];
        AppEngine.menuClear(sArray, 130, appEngine.getMaxMenuItemsPerScreen() - 4);
        int n = 0;
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Give Money");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Advance 1 hour");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Advance 1 day");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Clear Motives");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Get Friends");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Break everything");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Fix everything");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Dirty everything");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Clean everything");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Unlock bonus");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("Give all");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("< Cooking: " + simData.getSkillRank(0) + " >");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("< Cleaning: " + simData.getSkillRank(1) + " >");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("< Fishing: " + simData.getSkillRank(2) + " >");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("< Repairing: " + simData.getSkillRank(3) + " >");
        AppEngine.menuAppendItem(sArray, 0);
        sDKStringArray[n++] = AppEngine.stringToSDKString("< Gardening: " + simData.getSkillRank(4) + " >");
        int n2 = simData.getLastNPC();
        if (n2 != -1) {
            String string = appEngine.getString(simData.getSimName(n2)).toString();
            AppEngine.menuAppendItem(sArray, 3);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Friends");
            AppEngine.menuAppendItem(sArray, 4);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Disliked");
            AppEngine.menuAppendItem(sArray, 5);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Romance");
            AppEngine.menuAppendItem(sArray, 6);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Good Friends");
            AppEngine.menuAppendItem(sArray, 7);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Enemies");
            AppEngine.menuAppendItem(sArray, 8);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Date");
            AppEngine.menuAppendItem(sArray, 9);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Best Friends");
            AppEngine.menuAppendItem(sArray, 10);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Nemesis");
            AppEngine.menuAppendItem(sArray, 11);
            sDKStringArray[n++] = AppEngine.stringToSDKString(string + ": Partner");
        }
        this.m_cheatMenu = sArray;
        this.m_cheatMenuStrings = sDKStringArray;
        this.m_cheatMenu[2] = 0;
    }

    private void processKeysCheatMenu(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        appEngine.menuCursorUpDown(this.m_cheatMenu, n);
        SimData simData = this.m_simData;
        int n3 = this.m_cheatMenu[2];
        if (this.checkKeys(n, n2, 4128, 16)) {
            switch (n3) {
                case 0: {
                    simData.adjustMoney(1000);
                    break;
                }
                case 1: {
                    simData.cheatMenuHook(0);
                    break;
                }
                case 2: {
                    simData.cheatMenuHook(1);
                    break;
                }
                case 3: {
                    simData.cheatMenuHook(2);
                    this.hidePauseMenu();
                    break;
                }
                case 4: {
                    simData.cheatMenuHook(12);
                    this.hidePauseMenu();
                    break;
                }
                case 5: {
                    MapObject[] mapObjectArray = this.getObjects();
                    for (int i = 0; i < mapObjectArray.length; ++i) {
                        if (!mapObjectArray[i].getFlag(0x4000000) || mapObjectArray[i].getRuntimeFlag(256)) continue;
                        mapObjectArray[i].breakObject();
                    }
                    this.hidePauseMenu();
                    break;
                }
                case 6: {
                    MapObject[] mapObjectArray = this.getObjects();
                    for (int i = 0; i < mapObjectArray.length; ++i) {
                        if (!mapObjectArray[i].getFlag(0x4000000) || !mapObjectArray[i].getRuntimeFlag(256)) continue;
                        mapObjectArray[i].repairObject();
                    }
                    this.hidePauseMenu();
                    break;
                }
                case 7: {
                    MapObject[] mapObjectArray = this.getObjects();
                    for (int i = 0; i < mapObjectArray.length; ++i) {
                        if (!mapObjectArray[i].getFlag(0x8000000) || mapObjectArray[i].getRuntimeFlag(512)) continue;
                        mapObjectArray[i].dirtyObject();
                    }
                    this.hidePauseMenu();
                    break;
                }
                case 8: {
                    MapObject[] mapObjectArray = this.getObjects();
                    for (int i = 0; i < mapObjectArray.length; ++i) {
                        if (!mapObjectArray[i].getFlag(0x8000000) || !mapObjectArray[i].getRuntimeFlag(512)) continue;
                        mapObjectArray[i].cleanObject();
                    }
                    this.hidePauseMenu();
                    break;
                }
                case 9: {
                    simData.cheatMenuHook(24);
                    this.hidePauseMenu();
                    break;
                }
                case 10: {
                    simData.cheatMenuHook(25);
                    this.hidePauseMenu();
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    simData.cheatMenuHook(this.m_cheatMenu[5 + n3]);
                    this.hidePauseMenu();
                    break;
                }
            }
        } else if (this.checkKeys(n, n2, 98384, 0)) {
            boolean bl = (n & 0x8010) != 0;
            int n4 = 11;
            if (n3 == n4) {
                simData.cheatMenuHook(bl ? 13 : 14);
                this.m_cheatMenuStrings[n4] = AppEngine.stringToSDKString("< Cooking: " + simData.getSkillRank(0) + " >");
            } else if (n3 == ++n4) {
                simData.cheatMenuHook(bl ? 15 : 16);
                this.m_cheatMenuStrings[n4] = AppEngine.stringToSDKString("< Cleaning: " + simData.getSkillRank(1) + " >");
            } else if (n3 == ++n4) {
                simData.cheatMenuHook(bl ? 17 : 18);
                this.m_cheatMenuStrings[n4] = AppEngine.stringToSDKString("< Fishing: " + simData.getSkillRank(2) + " >");
            } else if (n3 == ++n4) {
                simData.cheatMenuHook(bl ? 19 : 20);
                this.m_cheatMenuStrings[n4] = AppEngine.stringToSDKString("< Repairing: " + simData.getSkillRank(3) + " >");
            } else if (n3 == ++n4) {
                simData.cheatMenuHook(bl ? 21 : 22);
                this.m_cheatMenuStrings[n4] = AppEngine.stringToSDKString("< Gardening: " + simData.getSkillRank(4) + " >");
            }
        } else if (this.checkKeys(n, n2, 0, 4)) {
            this.hidePauseMenu();
        }
    }

    private void renderCheatMenu(Graphics graphics) {
        this.drawGenericMenu(graphics, this.m_cheatMenu, 0, this.m_cheatMenuStrings);
    }

    static {
        isWinterToShow = false;
        XMAS_TREE_LIST_INDEX = 55;
        AMBIENT_MM_SOUNDS = new short[]{14, 15, 12, 13};
        AMBIENT_LAKESIDE_SOUNDS = new short[]{14, 15};
        SKEER_Y = 30;
        SKIER_SPEED = 0;
        SKIER_CURRENT_SPEED = 0;
        FLAG_TAKEN_VALIDATION = 3;
        MINI_GAME_SCREEN_WIDTH = 320;
        MINI_GAME_SCREEN_HEIGHT = 240;
        MINIGAME_STARTED = false;
        PRESS_OK = false;
        START_COUNTDOWN = false;
        VIBRATE_ON_COLLISION = false;
        LIFE_COUNT = 3;
        LIFE_COLAPSE = false;
        SKIER_BLINKING = false;
        collidedWithCandy = false;
        START_PIT_Y = MINI_GAME_SCREEN_HEIGHT >> 1;
        switchOutOfMiniGameSuccess = false;
        switchOutOfMiniGameFailure = false;
        SYSTEM_TIME = 0L;
        SYSTEM_TEMP = 0L;
        TIME_CAL = 0;
        GET_TIME = false;
        TRACK_WIDTH = 120;
        STYLUS_TIP = MINI_GAME_SCREEN_WIDTH - TRACK_WIDTH >> 1;
        STYLUS_CURVE_PEAK_X = 0;
        CURVE_RENDERING_WIDTH = 200;
        BORDER_POINT_WIDTH = 6;
        BORDER_POINT_HEIGHT = 6;
        STYLUS_CURVE_PEAK_X_BUFFER = 0;
        GENERATE_NEXT_CURVE = true;
        CURVENESS = MINI_GAME_SCREEN_WIDTH - TRACK_WIDTH >> 1;
        CURVE_FACTOR = 1.0f;
        CURVE_START = 0;
        SPEED_TO_CURVE_RATIO = 0.0f;
        FLAG_PLACE = 0;
        FLAG_PLACE_RANDOM = 0;
        FLAG_Y = 320;
        PLACE_BETWEEN_FLAG = 20;
        MAX_FLAG_OFFSET = 70;
        MAX_FLAG_OFFSET_X = 5;
        PATCH_Y = 320;
        SNOW_PATCH_RANDOM = 0;
        FLAG_Y_COORD = 0;
        FLAG_X_COORD = 0;
        FLAG_POINT_X = STYLUS_TIP;
        FLAG_TAKEN = 0;
        FLAG_HAS_TO_TAKEN = 0;
        COLLISION_WITH_BORDER = false;
        COLLISION_WITH_OBSTACLE = false;
        TIME = 0;
        SKEER_WIDTH = 40;
        SKEER_HEIGHT = 47;
        SKEER_X = (MINI_GAME_SCREEN_WIDTH >> 1) - (AppEngine.skiing_sprite2.getWidth() >> 1);
        SKIER_X = 0;
        SKIER_Y = 0;
        ANIM_COLLISION_TIME = 3;
        COLLISION_TIME = BLINKING_EFFECT_INTERVAL = 30;
        SHOW_SKIER = false;
        SKIING_GAME_HUD = 20;
        START_GAME = false;
        GAME_COUNTDOWN_TIMER = COUNTDOWN_TIMER_INTERVAL = 8;
        GAME_TIMER_COUNT = 3;
        skingSuccess = true;
        flag_o = 0;
        collission = false;
        SKEER_BEHAVIOUR = 1;
        CAMERA_PANNING_FACTOR = 0;
        SKIER_CONDITION = 1;
        REPAIR_WIRE_DX = new byte[]{2, 2, 2, 0, 0, 2, 2, 1};
        REPAIR_WIRE_DY = new byte[]{0, 1, -1, -2, 2, -1, 1, 0};
    }
}

