/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import com.ea.sims3.MonkeyApp;
import constants.AnimConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import game.MapObjectSim;
import game.MoreGames;
import game.Scene;
import game.SceneGame;
import game.SceneMenu;
import game.SimData;
import game.SimWorld;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import generic.PostEffects;
import generic.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.system.SystemListener2;
import net.rim.device.api.ui.Keypad;

public final class AppEngine
extends Canvas
implements AnimConstants,
ResourceConstants,
SoundEventConstants,
GlobalEventListener,
KeyListener,
SystemListener2 {
    private MonkeyApp m_midlet;
    private boolean m_gameRunning;
    private Scene m_currentScene;
    private boolean m_paused;
    public SnowParticle[] m_snowParticle;
    Random m_randomObject = new Random();
    public DrawBorderPoints[] m_DrawBorderPoints;
    public DrawTree[] m_DrawTree;
    public AddBoards[] m_AddBoards;
    public AddBoards[] m_AddBoards1;
    public AddBoards[] m_AddBoards2;
    public AddBoardsEA[] m_AddBoardsEA1;
    public AddBoardsEA[] m_AddBoardsEA2;
    public FencePoint[] m_FencePoint;
    public FencePoint[] m_FencePoint1;
    public FencePoint[] m_FencePoint2;
    public FencePoint2[] m_FencePoint2_0;
    public FencePoint2[] m_FencePoint2_1;
    public FencePoint2[] m_FencePoint2_2;
    public Crowd[] m_Crowd;
    public Obstacle[] m_Obstacle;
    public CandyCane m_CandyCane;
    private MoreGames m_moreGames = null;
    private boolean m_moreGamesActive = false;
    private ResourceManager m_resourceManager = null;
    private int m_musicID;
    private SDKSoundManager m_soundManager;
    private Random m_randomInstance;
    public Image reindeersleigh;
    public Image reindeersleigh_large;
    public Image xmas;
    public Image snow_man;
    public Image skeer1;
    public Image skeer2;
    public Image skeer3;
    public Image skeer;
    public static Image obstacle1;
    public static Image obstacle3;
    public static Image obstacle4;
    public Image skiing_candy;
    public Image skiing_icon;
    public static Image ball;
    public static Image tree;
    public static Image tree1;
    public static Image tree2;
    public static Image countdown;
    public static Image adboard_red;
    public static Image adboard_green;
    public static Image adboard_orange;
    public static Image fence;
    public static Image fence2;
    public Image hud_candy;
    public Image life;
    public Image timer;
    public static Image crowd1;
    public static Image crowd2;
    public static Image crowd3;
    public static Image crowd1_1;
    public static Image crowd2_2;
    public static Image crowd3_3;
    public static Image ad_EA;
    public static Sprite skiing_sprite1;
    public static Sprite skiing_sprite2;
    public static Sprite skiing_sprite3;
    public static Sprite skiing_sprite4;
    public static Sprite skiing_sprite5;
    public static Sprite ski_sprite;
    public static Image start_Point;
    private int m_oldVolume;
    private boolean m_runGarbageCollect;
    private static AppEngine s_singletonAppEngine;
    public static boolean isMinimized;
    private Timer m_gameTimer = null;
    private boolean m_paintScheduled = false;
    private static boolean isFirstLaunch;
    private int m_keysPressedDown;
    private int m_commandPressedDown;
    private int[] m_keyBuffer;
    private int m_keyBufferIndex;
    private int m_rightCommandID;
    private int m_leftCommandID;
    private char m_extKey;
    private static int currentVolume;
    public boolean isMute = false;
    public static boolean is_Z_keyPressed;
    private Object[] m_fonts;
    private int m_numLanguages;
    private static byte[] s_blockBuf;
    private int m_getStringInstance;
    private SDKString[] m_sdkStringInstances;
    private SDKString[] m_dynamicStrings = new SDKString[10];
    private static final SDKString[] s_sdkStrings;
    private SDKString m_tempStringBuffer;
    private SDKString[] m_tempStringBuffers;
    private int m_tempBufferIndex;
    private short[] m_wrapOffsets;
    private SDKString m_wrapString;
    private short[][] m_wrapChunkOffsets;
    private SDKString[] m_wrapChunkStrings;
    private short[] m_wrapChunkStringIds;
    private int[] m_scrollerStringId = new int[2];
    private SDKString[] m_scrollerStringArray = new SDKString[2];
    private int[] m_scrollerStringWidth = new int[2];
    private int[] m_scrollerTime = new int[2];
    private int[] m_scrollerOffset = new int[2];
    private PostEffects m_postEffects = new PostEffects();
    private boolean m_fading;
    private boolean m_fadeColorReached;
    private int m_fadeColor;
    private int m_fadeDir;
    private int m_fadeStep;
    private int m_nextScene;
    private int m_nextSceneState;
    public boolean m_debugCheatMenuEnabled;
    private static final int[][] DEBUG_CODES;
    private long m_leftSoftkeyTime;
    private long m_rightSoftkeyTime;
    private AnimPlayer m_softKeyLAnimPlayer;
    private AnimPlayer m_softKeyRAnimPlayer;
    private boolean m_softKeyAnimateRight;
    private int[] d_images;
    private int m_loadImageIndex;
    private boolean m_rmsGSVibrationEnabled;
    private boolean m_rmsGSTutorialsEnabled;
    private boolean m_rmsGSAutonomityEnabled;
    private boolean m_rmsGSSavePrompts;
    public boolean m_rmsGSWinterSeasonEnabled;
    public static int m_rmsGSXmasCoordinates_X;
    public static int m_rmsGSXmasCoordinates_Y;
    public boolean m_rmsGSXmasLightingEnabled;
    private int m_rmsGSLangIndex;
    private int m_gameSlotIndex;
    private SDKString[] m_rmsSimNameString = new SDKString[3];
    private boolean[] m_rmsGSActiveGame = new boolean[3];
    private int m_rmsGDTutorialFlags;
    private boolean m_rmsGSBonusUnlocked;
    private long m_rmsGlobalDreamsDiscovered1;
    private long m_rmsGlobalDreamsDiscovered2;
    private long m_rmsGlobalDreamsComplete1;
    private long m_rmsGlobalDreamsComplete2;
    private long m_rmsGDDreamsDiscovered1;
    private long m_rmsGDDreamsDiscovered2;
    private long m_rmsGDDreamsComplete1;
    private long m_rmsGDDreamsComplete2;
    private int m_loadingString;
    private int m_loadingStringPosXF;
    private int m_loadingStringWidth;
    private int m_sharedMenuState;
    private short[] m_optionsMenu;
    private short[] m_inGameOptionsMenu;
    private short[] m_helpMenu;
    private short[] m_sharedMenu;
    private int m_sharedMenuBackState;
    private short m_maxMenuItemsPerScreen;
    private SimData m_simData;
    private SimWorld m_simWorld;
    private int m_nextHouseId;
    private int m_nextZoomMapId;
    private short[][] d_uiPanels;
    private int m_encounterPlayerXF;
    private int m_encounterPlayerZF;
    private int m_encounterNPCXF;
    private int m_encounterNPCZF;
    private int m_encounterNPCId;
    public static int FENCE_Y;

    public MoreGames getMoreGames() {
        return this.m_moreGames;
    }

    public void setMoreGamesActive(boolean bl) {
        this.m_moreGamesActive = bl;
    }

    public ResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public SDKSoundManager getSoundManager() {
        return this.m_soundManager;
    }

    public void startMusic(int n) {
        if (this.m_musicID != n && this.m_musicID != -1) {
            this.m_soundManager.stopSound(this.m_musicID);
        }
        this.m_musicID = n;
        if (n == -1) {
            this.m_soundManager.setCurrentLoop(1);
        } else {
            this.m_soundManager.setCurrentLoop(-1);
            this.m_soundManager.playSound(n);
        }
    }

    public void stopMusic() {
        this.startMusic(-1);
    }

    private void loadSounds() {
        SDKSoundManager sDKSoundManager = this.getSoundManager();
        sDKSoundManager.loadSound(11);
        sDKSoundManager.loadSound(10);
        sDKSoundManager.loadSound(2);
        sDKSoundManager.loadSound(3);
        sDKSoundManager.loadSound(0);
        sDKSoundManager.loadSound(1);
        sDKSoundManager.loadSound(4);
        sDKSoundManager.loadSound(5);
        sDKSoundManager.loadSound(6);
        sDKSoundManager.loadSound(7);
        sDKSoundManager.loadSound(8);
        sDKSoundManager.loadSound(9);
        sDKSoundManager.loadSound(14);
        sDKSoundManager.loadSound(15);
        sDKSoundManager.loadSound(12);
        sDKSoundManager.loadSound(13);
    }

    public int getHalfWidth() {
        return this.getWidth() >> 1;
    }

    public int getHalfHeight() {
        return this.getHeight() >> 1;
    }

    public static void createAppEngine(MonkeyApp monkeyApp) {
        s_singletonAppEngine = new AppEngine(monkeyApp);
    }

    public static AppEngine getCanvas() {
        return s_singletonAppEngine;
    }

    public static final void DEBUG_MEMORY(String string) {
    }

    public void usbConnectionStateChange(int n) {
    }

    public void batteryStatusChange(int n) {
    }

    public void powerOffRequested(int n) {
    }

    public void batteryGood() {
    }

    public void batteryLow() {
    }

    public void powerOff() {
    }

    public void powerUp() {
    }

    public void fastReset() {
    }

    public void cradleMismatch(boolean bl) {
    }

    public void backlightStateChange(boolean bl) {
        if (bl) {
            this.showNotify();
            this.repaint();
        } else {
            this.hideNotify();
        }
    }

    public void eventOccurred(long l, int n, int n2, Object object, Object object2) {
        if (l == 5961289116197897667L) {
            if (n == 1) {
                this.hideNotify();
            } else if (n == 2) {
                this.showNotify();
            }
        }
    }

    private AppEngine(MonkeyApp monkeyApp) {
        int n;
        int n2;
        SDKSoundManager sDKSoundManager;
        Application.getApplication().addKeyListener((KeyListener)this);
        Application.getApplication().addSystemListener((SystemListener)this);
        AppEngine.DEBUG_MEMORY("AppEngine()");
        SDKUtils.setMidlet(monkeyApp);
        this.m_midlet = monkeyApp;
        this.m_gameRunning = false;
        this.m_keyBuffer = new int[8];
        this.m_keyBufferIndex = 0;
        this.m_runGarbageCollect = false;
        this.m_resourceManager = new ResourceManager();
        this.m_soundManager = sDKSoundManager = SDKSoundManager.getManager();
        sDKSoundManager.setSoundEnabled(false);
        sDKSoundManager.setPlaybackType(1);
        sDKSoundManager.setLoader(this.m_resourceManager);
        this.m_musicID = -1;
        this.loadSounds();
        this.m_randomInstance = new Random();
        if (!AnimationManager.loadSubimageFile(this.m_resourceManager)) {
            AppEngine.DEBUG_MEMORY("Error reading subimage data");
        }
        if (!AnimationManager.loadAnimFile(this.m_resourceManager)) {
            AppEngine.DEBUG_MEMORY("Error reading anim data");
        }
        if (!AnimationManager.loadColorsFile(this.m_resourceManager)) {
            AppEngine.DEBUG_MEMORY("Error reading color data");
        }
        AppEngine.DEBUG_MEMORY("loaded subimage/anim/color data");
        this.m_softKeyLAnimPlayer = new AnimPlayer();
        this.m_softKeyRAnimPlayer = new AnimPlayer();
        this.loadGameData();
        AppEngine.DEBUG_MEMORY("loaded gamedata");
        this.m_moreGames = new MoreGames(this.getWidth(), this.getHeight());
        AppEngine.DEBUG_MEMORY("created more games instance");
        SDKString sDKString = null;
        for (n2 = 0; n2 < 3; ++n2) {
            sDKString = new SDKString(8, 0);
            sDKString.setLength(8);
            for (n = 0; n != 8; ++n) {
                sDKString.setCharAt(n, ' ');
            }
            this.m_rmsSimNameString[n2] = sDKString;
        }
        this.loadRMSAppSettings();
        this.initWraps();
        AppEngine.DEBUG_MEMORY("init wraps");
        this.loadTextSDKStrings();
        AppEngine.DEBUG_MEMORY("loaded strings");
        if (this.m_sdkStringInstances == null) {
            this.m_sdkStringInstances = new SDKString[10];
            for (n2 = 0; n2 < 10; ++n2) {
                this.m_sdkStringInstances[n2] = new SDKString();
            }
        }
        this.m_tempStringBuffers = new SDKString[25];
        for (n2 = 0; n2 < 25; ++n2) {
            this.m_tempStringBuffers[n2] = new SDKString(100, 0);
        }
        this.loadAllImages(1);
        AppEngine.DEBUG_MEMORY("loaded AppEngine images");
        this.resetRMSGameData();
        this.loadRMSGameData();
        AppEngine.DEBUG_MEMORY("loaded RMS");
        try {
            this.snow_man = Image.createImage((String)"/snow_man.png");
            this.reindeersleigh_large = Image.createImage((String)"/sleigh-large.png");
            this.reindeersleigh = Image.createImage((String)"/reindeersleigh.png");
            this.xmas = Image.createImage((String)"/xmas.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.skeer1 = Image.createImage((String)"/skier1_1.png");
            this.skeer2 = Image.createImage((String)"/skier2_2.png");
            this.skeer3 = Image.createImage((String)"/skier3_3.png");
            skiing_sprite1 = new Sprite(Image.createImage((String)"/skier1.png"));
            skiing_sprite2 = new Sprite(Image.createImage((String)"/skier2.png"));
            skiing_sprite3 = new Sprite(Image.createImage((String)"/skier3.png"));
            skiing_sprite4 = new Sprite(Image.createImage((String)"/skier4.png"));
            skiing_sprite5 = new Sprite(Image.createImage((String)"/skier5.png"));
            ski_sprite = skiing_sprite2;
            obstacle1 = Image.createImage((String)"/obstacle1.png");
            obstacle3 = Image.createImage((String)"/obstacle3.png");
            obstacle4 = Image.createImage((String)"/obstacle4.png");
            this.hud_candy = Image.createImage((String)"/hud_flag.png");
            this.timer = Image.createImage((String)"/chronometer.png");
            this.life = Image.createImage((String)"/life.png");
            this.skiing_candy = Image.createImage((String)"/flag.png");
            this.skiing_icon = Image.createImage((String)"/ski-slope.png");
            tree = Image.createImage((String)"/tree.png");
            tree1 = Image.createImage((String)"/tree1.png");
            tree2 = Image.createImage((String)"/tree2.png");
            ball = Image.createImage((String)"/ball.png");
            countdown = Image.createImage((String)"/countdown.png");
            adboard_red = Image.createImage((String)"/ad_red.png");
            adboard_green = Image.createImage((String)"/ad_green.png");
            adboard_orange = Image.createImage((String)"/ad_orange.png");
            fence = Image.createImage((String)"/fence.png");
            fence2 = Image.createImage((String)"/fence2.png");
            crowd1 = Image.createImage((String)"/crowd1.png");
            crowd2 = Image.createImage((String)"/crowd2.png");
            crowd3 = Image.createImage((String)"/crowd3.png");
            ad_EA = Image.createImage((String)"/ad_EA.png");
            start_Point = Image.createImage((String)"/start-point.png");
            crowd1_1 = Image.createImage((Image)Image.createImage((Image)crowd1, (int)0, (int)0, (int)crowd1.getWidth(), (int)crowd1.getHeight(), (int)2));
            crowd2_2 = Image.createImage((Image)Image.createImage((Image)crowd2, (int)0, (int)0, (int)crowd2.getWidth(), (int)crowd2.getHeight(), (int)2));
            crowd3_3 = Image.createImage((Image)Image.createImage((Image)crowd3, (int)0, (int)0, (int)crowd3.getWidth(), (int)crowd3.getHeight(), (int)2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Random random = new Random();
        this.m_snowParticle = new SnowParticle[60];
        for (n = 0; n < this.m_snowParticle.length; ++n) {
            this.m_snowParticle[n] = new SnowParticle(-this.getWidth() + n * (this.getWidth() / 10), -random.nextInt(this.getHeight()));
        }
        this.m_DrawTree = new DrawTree[3];
        for (n = 0; n < this.m_DrawTree.length; ++n) {
            this.m_DrawTree[n] = new DrawTree(SceneGame.STYLUS_TIP, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * (n + 1));
        }
        this.m_AddBoards = new AddBoards[3];
        for (n = 0; n < this.m_AddBoards.length; ++n) {
            this.m_AddBoards[n] = new AddBoards(SceneGame.STYLUS_TIP, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 0 + (adboard_red.getHeight() + 5) * n, 0, false);
        }
        this.m_AddBoards1 = new AddBoards[3];
        for (n = 0; n < this.m_AddBoards.length; ++n) {
            this.m_AddBoards1[n] = new AddBoards(SceneGame.STYLUS_TIP, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 1 + (adboard_red.getHeight() + 5) * n, 0, true);
        }
        this.m_AddBoards2 = new AddBoards[3];
        for (n = 0; n < this.m_AddBoards.length; ++n) {
            this.m_AddBoards2[n] = new AddBoards(SceneGame.STYLUS_TIP, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 2 + (adboard_red.getHeight() + 5) * n, 0, false);
        }
        this.m_AddBoardsEA1 = new AddBoardsEA[2];
        for (n = 0; n < this.m_AddBoardsEA1.length; ++n) {
            this.m_AddBoardsEA1[n] = new AddBoardsEA(SceneGame.STYLUS_TIP, SceneGame.MINI_GAME_SCREEN_HEIGHT / 2 * n, 0, true);
        }
        this.m_AddBoardsEA2 = new AddBoardsEA[2];
        for (n = 0; n < this.m_AddBoardsEA2.length; ++n) {
            this.m_AddBoardsEA2[n] = new AddBoardsEA(SceneGame.STYLUS_TIP, SceneGame.MINI_GAME_SCREEN_HEIGHT / 2 * n, 0, false);
        }
        this.createFence();
        this.m_Crowd = new Crowd[3];
        for (n = 0; n < this.m_Crowd.length; ++n) {
            this.m_Crowd[n] = new Crowd(0, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * n);
        }
        this.m_Obstacle = new Obstacle[2];
        for (n = 0; n < this.m_Obstacle.length; ++n) {
            this.m_Obstacle[n] = new Obstacle(SceneGame.MINI_GAME_SCREEN_WIDTH, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * (n + 1));
        }
        this.m_CandyCane = new CandyCane(SceneGame.STYLUS_TIP + (SceneGame.TRACK_WIDTH >> 1), SceneGame.MINI_GAME_SCREEN_HEIGHT, false);
    }

    public void createFence() {
        int n;
        this.m_FencePoint = new FencePoint[4];
        for (n = 0; n < this.m_FencePoint.length; ++n) {
            this.m_FencePoint[n] = new FencePoint(SceneGame.MINI_GAME_SCREEN_WIDTH, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 0 + (SceneGame.BORDER_POINT_HEIGHT + 6) * n, true);
        }
        this.m_FencePoint1 = new FencePoint[4];
        for (n = 0; n < this.m_FencePoint.length; ++n) {
            this.m_FencePoint1[n] = new FencePoint(SceneGame.MINI_GAME_SCREEN_WIDTH + 20, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 1 + (SceneGame.BORDER_POINT_HEIGHT + 6) * n, false);
        }
        this.m_FencePoint2 = new FencePoint[4];
        for (n = 0; n < this.m_FencePoint.length; ++n) {
            this.m_FencePoint2[n] = new FencePoint(SceneGame.MINI_GAME_SCREEN_WIDTH, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 2 + (SceneGame.BORDER_POINT_HEIGHT + 6) * n, true);
        }
        this.m_FencePoint2_0 = new FencePoint2[10];
        for (n = 0; n < this.m_FencePoint2_0.length; ++n) {
            this.m_FencePoint2_0[n] = new FencePoint2(SceneGame.MINI_GAME_SCREEN_WIDTH, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 0 + (SceneGame.BORDER_POINT_HEIGHT - 2) * n, true);
        }
        this.m_FencePoint2_1 = new FencePoint2[10];
        for (n = 0; n < this.m_FencePoint2_0.length; ++n) {
            this.m_FencePoint2_1[n] = new FencePoint2(SceneGame.MINI_GAME_SCREEN_WIDTH + 20, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 1 + (SceneGame.BORDER_POINT_HEIGHT - 2) * n, false);
        }
        this.m_FencePoint2_2 = new FencePoint2[10];
        for (n = 0; n < this.m_FencePoint2_0.length; ++n) {
            this.m_FencePoint2_2[n] = new FencePoint2(SceneGame.MINI_GAME_SCREEN_WIDTH, SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 2 + (SceneGame.BORDER_POINT_HEIGHT - 2) * n, true);
        }
    }

    public void initFence() {
        int n;
        for (n = 0; n < this.m_FencePoint.length; ++n) {
            this.m_FencePoint[n].fencePoint_x = SceneGame.MINI_GAME_SCREEN_WIDTH;
            this.m_FencePoint[n].fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 0 + (SceneGame.BORDER_POINT_HEIGHT + 6) * n;
        }
        for (n = 0; n < this.m_FencePoint.length; ++n) {
            this.m_FencePoint1[n].fencePoint_x = SceneGame.MINI_GAME_SCREEN_WIDTH;
            this.m_FencePoint1[n].fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 1 + (SceneGame.BORDER_POINT_HEIGHT + 6) * n;
        }
        for (n = 0; n < this.m_FencePoint.length; ++n) {
            this.m_FencePoint2[n].fencePoint_x = SceneGame.MINI_GAME_SCREEN_WIDTH;
            this.m_FencePoint2[n].fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 2 + (SceneGame.BORDER_POINT_HEIGHT + 6) * n;
        }
        for (n = 0; n < this.m_FencePoint2_0.length; ++n) {
            this.m_FencePoint2_0[n].fencePoint_x = SceneGame.MINI_GAME_SCREEN_WIDTH;
            this.m_FencePoint2_0[n].fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 0 + (SceneGame.BORDER_POINT_HEIGHT - 2) * n;
        }
        for (n = 0; n < this.m_FencePoint2_0.length; ++n) {
            this.m_FencePoint2_1[n].fencePoint_x = SceneGame.MINI_GAME_SCREEN_WIDTH;
            this.m_FencePoint2_1[n].fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 1 + (SceneGame.BORDER_POINT_HEIGHT - 2) * n;
        }
        for (n = 0; n < this.m_FencePoint2_0.length; ++n) {
            this.m_FencePoint2_2[n].fencePoint_x = SceneGame.MINI_GAME_SCREEN_WIDTH;
            this.m_FencePoint2_2[n].fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT / 3 * 2 + (SceneGame.BORDER_POINT_HEIGHT - 2) * n;
        }
    }

    public synchronized void start() {
        this.initSharedMenus();
        int n = 5;
        if (this.m_rmsGSLangIndex == -1) {
            n = 4;
        }
        this.changeScene(1, n);
        this.m_moreGames.setScreenSize(this.getWidth(), this.getHeight());
        this.m_paused = false;
    }

    public void end() {
        this.m_gameRunning = false;
        if (this.m_currentScene != null) {
            this.m_currentScene.end();
        }
        this.requestGC(true);
        for (int i = 0; i < SoundEventConstants.SOUND_DATA_SETS.length; ++i) {
            this.m_soundManager.unloadSound(i);
        }
    }

    public void showNotify() {
        if (this.m_paused) {
            this.resumeGame();
            this.startThread();
        }
    }

    public void hideNotify() {
        this.pauseGame();
    }

    public void startThread() {
        this.m_gameRunning = true;
        if (this.m_gameTimer != null) {
            this.m_gameTimer.cancel();
            this.m_gameTimer = null;
            AppEngine.doGC();
        }
        this.m_gameTimer = new Timer();
        this.m_gameTimer.schedule(new TimerTask(){
            private long m_timeStartFrame = System.currentTimeMillis();

            public synchronized void run() {
                if (!AppEngine.this.m_gameRunning) {
                    AppEngine.this.m_midlet.destroyApp(true);
                    return;
                }
                if (!AppEngine.this.m_paused && !AppEngine.this.m_paintScheduled) {
                    AppEngine.this.m_paintScheduled = true;
                    long l = System.currentTimeMillis();
                    AppEngine.this.runLoop((int)(l - this.m_timeStartFrame));
                    this.m_timeStartFrame = l;
                    AppEngine.this.repaint();
                }
            }
        }, 0L, 15L);
    }

    public void runLoop(int n) {
        int n2 = this.updateKeyBuffer();
        this.update(n);
        this.clearKeyBit(n2);
        if (this.m_runGarbageCollect) {
            AppEngine.doGC();
            this.m_runGarbageCollect = false;
        }
    }

    private int updateKeyBuffer() {
        int n;
        int[] nArray = this.m_keyBuffer;
        for (n = this.m_keyBufferIndex - 1; n >= 0; --n) {
            if (nArray[n] >= 0) continue;
            this.m_keysPressedDown &= ~(-nArray[n]);
            if (-nArray[n] != 131072 && -nArray[n] != 262144 && -nArray[n] != 524288) continue;
            this.m_commandPressedDown = 0;
        }
        for (n = this.m_keyBufferIndex - 1; n >= 0; --n) {
            if (nArray[n] <= 0) continue;
            this.m_keysPressedDown |= nArray[n];
            if (nArray[n] == 524288) {
                this.m_commandPressedDown = 4;
                continue;
            }
            if (nArray[n] == 262144) {
                this.m_commandPressedDown = this.m_rightCommandID;
                continue;
            }
            if (nArray[n] != 131072) continue;
            this.m_commandPressedDown = this.m_leftCommandID;
        }
        n = 0;
        for (int i = 1; i <= 18; ++i) {
            for (int j = 0; j < this.m_keyBufferIndex; ++j) {
                if (nArray[j] < 0) {
                    n |= -nArray[j];
                } else if (n == 1 << i && nArray[j] > 0) {
                    n &= ~nArray[j];
                }
                nArray[j] = 0;
            }
        }
        this.m_keyBufferIndex = 0;
        return n;
    }

    public void endGame() {
        this.m_soundManager.stopSounds();
        this.m_gameRunning = false;
    }

    public void pauseGame() {
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        if (this.m_currentScene != null) {
            this.m_currentScene.pause();
        }
        try {
            if (!isMinimized) {
                this.m_oldVolume = this.m_soundManager.getSoundVolume();
                this.m_soundManager.setSoundVolume(0);
            }
            isMinimized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_paused = true;
    }

    public void resumeGame() {
        if (this.m_currentScene != null) {
            this.m_currentScene.resume();
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        this.m_keyBufferIndex = 0;
        this.m_paused = false;
        if (this.m_musicID != -1 && !isMinimized) {
            this.startMusic(this.m_musicID);
        }
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    private final void update(int n) {
        try {
            Thread.sleep(33L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 150) {
            n = 150;
        }
        if (this.m_nextScene != -1) {
            this.performChangeScene(this.m_nextScene, this.m_nextSceneState);
            this.m_nextScene = -1;
            this.m_nextSceneState = -1;
        }
        if (this.m_currentScene != null) {
            if (this.m_fading) {
                this.m_fadeColor += this.m_fadeDir * this.m_fadeStep * (n >> 3);
                if (this.m_fadeDir > 0 && this.m_fadeColor >= 0xFFFFFF) {
                    this.m_fadeColor = 0xFFFFFF;
                } else if (this.m_fadeDir < 0 && this.m_fadeColor <= 0) {
                    this.m_fadeColor = 0;
                }
            }
            if (this.m_currentScene != null) {
                int n2 = 0;
                if (this.m_commandPressedDown == 4 && this.m_rightCommandID != 4 && this.m_leftCommandID != 4) {
                    n2 = 4;
                    this.m_commandPressedDown = 0;
                }
                this.m_currentScene.processKeys(this.m_keysPressedDown, n2);
                this.processSoftKeys(this.m_commandPressedDown);
                this.updateSoftKeys(n);
                this.m_currentScene.update(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void paint(Graphics graphics) {
        try {
            if (isFirstLaunch) {
                isFirstLaunch = false;
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            Graphics graphics2 = graphics;
            SDKUtils.setGraphics(graphics2);
            if (this.m_currentScene != null && this.m_gameRunning) {
                this.m_currentScene.render(graphics2);
            }
            if (this.isFading()) {
                this.renderFade(graphics2);
                if (this.m_fadeDir > 0 && this.m_fadeColor >= 0xFFFFFF || this.m_fadeDir < 0 && this.m_fadeColor <= 0) {
                    this.m_fadeColorReached = true;
                }
            }
        }
        finally {
            this.m_paintScheduled = false;
        }
    }

    public char getExtKey() {
        char c = this.m_extKey;
        this.m_extKey = '\u0000';
        return c;
    }

    private void addExtKey(char c) {
        if (this.m_extKey == '\u0000') {
            this.m_extKey = c;
        }
    }

    public void clearExtKey() {
        this.m_extKey = '\u0000';
    }

    private int translateKeyCode(int n) {
        switch (n) {
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 48: {
                return 1;
            }
            case 35: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case -6: {
                return 131072;
            }
            case -7: {
                return 262144;
            }
            case -81212: {
                return 524288;
            }
            case -8: 
            case 8: {
                return 4096;
            }
            case 1: {
                return 8192;
            }
            case 6: {
                return 16384;
            }
            case 2: {
                return 32768;
            }
            case 5: {
                return 65536;
            }
        }
        return 0;
    }

    private final void keyPressedBlackBerry(int n) {
        if (Keypad.key((int)n) == 4096) {
            int n2;
            currentVolume = n2 = Math.min(this.getSoundManager().getSoundVolume() + 20, 100);
            this.getSoundManager().setSoundVolume(n2);
            return;
        }
        if (Keypad.key((int)n) == 4097) {
            int n3;
            currentVolume = n3 = Math.max(this.getSoundManager().getSoundVolume() - 20, 0);
            this.getSoundManager().setSoundVolume(n3);
            return;
        }
    }

    public boolean keyStatus(int n, int n2) {
        return true;
    }

    public boolean keyRepeat(int n, int n2) {
        return true;
    }

    public boolean keyUp(int n, int n2) {
        Application application = Application.getApplication();
        if (!application.isForeground()) {
            return true;
        }
        if (n == 0x120000 || n == 0x110000 || n == 0x10030000) {
            return false;
        }
        if (n == 0x1110000) {
            if (!this.isMute) {
                this.isMute = true;
                currentVolume = this.getSoundManager().getSoundVolume();
                this.getSoundManager().setSoundVolume(0);
            } else {
                this.isMute = false;
                this.getSoundManager().setSoundVolume(currentVolume);
            }
            return true;
        }
        this.keyReleased(this.toCanvasKey(n));
        return true;
    }

    public boolean keyDown(int n, int n2) {
        Application application = Application.getApplication();
        if (!application.isForeground()) {
            return true;
        }
        if (n == 0x120000 || n == 0x110000 || n == 0x10030000) {
            return false;
        }
        if (Keypad.key((int)n) == 18 && !this.m_paused) {
            this.hideNotify();
            return false;
        }
        this.keyPressedBlackBerry(n);
        this.keyPressed(this.toCanvasKey(n));
        char c = (char)Keypad.key((int)n);
        if (c >= 'A' && c <= 'Z') {
            this.addExtKey(c);
        }
        return true;
    }

    public boolean keyChar(char c, int n, int n2) {
        return this.m_paused;
    }

    public int toCanvasKey(int n) {
        int n2 = Keypad.key((int)n);
        switch (n2) {
            case 10: {
                return 8;
            }
            case 27: {
                return -81212;
            }
            case 8: {
                return -81212;
            }
            case 4098: {
                return -81212;
            }
            case 261: {
                return 35;
            }
            case 81: 
            case 113: {
                return -6;
            }
            case 80: 
            case 112: {
                return -7;
            }
            case 32: {
                return 48;
            }
            case 87: 
            case 119: {
                return 49;
            }
            case 69: 
            case 101: {
                return 50;
            }
            case 82: 
            case 114: {
                return 51;
            }
            case 83: 
            case 115: {
                return 52;
            }
            case 68: 
            case 100: {
                return 53;
            }
            case 70: 
            case 102: {
                return 54;
            }
            case 90: 
            case 122: {
                return 55;
            }
            case 88: 
            case 120: {
                return 56;
            }
            case 67: 
            case 99: {
                return 57;
            }
            case 65: 
            case 97: {
                return 42;
            }
            case 76: 
            case 108: {
                return 35;
            }
        }
        return n2;
    }

    public void keyPressed(int n) {
        if (!is_Z_keyPressed && n == 90) {
            n = 55;
        }
        if (isMinimized) {
            try {
                this.m_soundManager.setSoundVolume(this.m_oldVolume);
                if (this.m_soundManager.isSoundEnabled()) {
                    Thread.sleep(1000L);
                    if (this.getSceneMenu() != null) {
                        this.startMusic(10);
                    }
                }
                isMinimized = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.m_moreGamesActive) {
            if (n == -81212) {
                n = -7;
            }
            this.m_moreGames.processKey(n);
            return;
        }
        int n2 = this.translateKeyCode(n);
        if (n2 != 0 && this.m_keyBufferIndex < this.m_keyBuffer.length) {
            this.m_keyBuffer[this.m_keyBufferIndex++] = n2;
            this.debugKey(n2);
        }
        is_Z_keyPressed = false;
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public void keyReleased(int n) {
        int n2;
        if (!is_Z_keyPressed && n == 90) {
            n = 55;
        }
        if ((n2 = this.translateKeyCode(n)) != 0 && this.m_keyBufferIndex < this.m_keyBuffer.length) {
            this.m_keyBuffer[this.m_keyBufferIndex++] = -n2;
        }
        is_Z_keyPressed = false;
    }

    public void clearKeyBit(int n) {
        this.m_keysPressedDown &= ~n;
    }

    public void clearKeysPressedDown() {
        this.m_keysPressedDown = 0;
    }

    public void clearCommandKeys() {
        this.m_commandPressedDown = 0;
        this.clearKeyBit(524288);
    }

    public void setSoftKeys(int n, int n2) {
        int n3 = n;
        n = n2;
        n2 = n3;
        if (n2 != this.m_rightCommandID) {
            this.m_rightCommandID = n2;
            this.m_rightSoftkeyTime = 0L;
        }
        if (n != this.m_leftCommandID) {
            this.m_leftCommandID = n;
            this.m_leftSoftkeyTime = 0L;
        }
    }

    public int getRightCommandID() {
        return this.m_rightCommandID;
    }

    public int getLeftCommandID() {
        return this.m_leftCommandID;
    }

    private static final int getCommandString(int n) {
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return 48;
        }
        if (n == 2) {
            return 39;
        }
        if (n == 4) {
            return 40;
        }
        if (n == 8) {
            return 41;
        }
        if (n == 16) {
            return 42;
        }
        if (n == 32) {
            return 43;
        }
        if (n == 64) {
            return 44;
        }
        if (n == 128) {
            return 52;
        }
        if (n == 256) {
            return 46;
        }
        if (n == 512) {
            return 47;
        }
        if (n == 1024) {
            return 38;
        }
        if (n == 2048) {
            return 49;
        }
        if (n == 4096) {
            return 50;
        }
        if (n == 8192) {
            return 51;
        }
        if (n == 16384) {
            return 1;
        }
        if (n == 32768) {
            return 2;
        }
        return -1;
    }

    private void loadTextSDKStrings() {
        s_blockBuf = new byte[2600];
        byte[] byArray = this.loadBlock("/hdr");
        this.m_numLanguages = SDKUtils.loadTextHeader(byArray);
        int n = 0;
        n += this.m_rmsGSLangIndex;
        int n2 = n = SDKUtils.chooseLanguage(n);
        if (n < 0) {
            n = 0;
        }
        Object[] objectArray = new Object[5];
        Image[] imageArray = new Image[5];
        this.m_fonts = objectArray;
        String string = "/" + SDKUtils.getFontDifferentiator(n);
        try {
            imageArray[0] = Image.createImage((String)(string + "font_sims_white_outline.png"));
            imageArray[1] = Image.createImage((String)(string + "font_sims_black.png"));
            imageArray[2] = Image.createImage((String)(string + "font_sims_white_smallcaps.png"));
            imageArray[3] = Image.createImage((String)(string + "font_the.png"));
            imageArray[4] = Image.createImage((String)(string + "font_thesmall.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray2 = this.loadBlock(string + "font_sims_white_outline.rff");
        objectArray[0] = SDKUtils.loadFont(imageArray[0], byArray2);
        byArray2 = this.loadBlock(string + "font_sims_black.rff");
        objectArray[1] = SDKUtils.loadFont(imageArray[1], byArray2);
        byArray2 = this.loadBlock(string + "font_sims_white_smallcaps.rff");
        objectArray[2] = SDKUtils.loadFont(imageArray[2], byArray2);
        byArray2 = this.loadBlock(string + "font_the.rff");
        objectArray[3] = SDKUtils.loadFont(imageArray[3], byArray2);
        byArray2 = this.loadBlock(string + "font_thesmall.rff");
        objectArray[4] = SDKUtils.loadFont(imageArray[4], byArray2);
        s_blockBuf = null;
        AppEngine.doGC();
        this.loadLanguageChunks(n);
        this.m_rmsGSLangIndex = n2;
        Object[] objectArray2 = new Object[]{objectArray[1], objectArray[0], objectArray[0], objectArray[1], objectArray[0]};
        this.m_moreGames.setFonts(objectArray2);
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(58);
            byte[] byArray3 = new byte[ResourceManager.getFileSize(58)];
            inputStream.read(byArray3);
            inputStream.close();
            this.m_moreGames.setProductData(byArray3);
            byArray3 = null;
            AppEngine.doGC();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getNumLanguages() {
        return this.m_numLanguages;
    }

    public void loadLanguageChunks(int n) {
        this.m_rmsGSLangIndex = n;
        SDKUtils.setCurrentLanguage(n);
        SDKUtils.loadStringsChunk(2);
        if (this.getSceneMenu() != null) {
            SDKUtils.loadStringsChunk(1);
        }
        AppEngine.fillArray(this.m_wrapChunkStringIds, -1);
        AppEngine.fillArray(this.m_wrapChunkStrings, null);
        this.m_wrapString = null;
        AppEngine.fillArray(this.m_scrollerStringId, -1);
        AppEngine.fillArray(this.m_scrollerStringArray, null);
    }

    private byte[] loadBlock(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                int n = inputStream.read(s_blockBuf);
                int n2 = 0;
                int n3 = 2600;
                while (n > 0) {
                    n = inputStream.read(s_blockBuf, n2 += n, n3 -= n);
                }
                byArray = new byte[n2];
                System.arraycopy(s_blockBuf, 0, byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public void drawString(int n, int n2, int n3, int n4, int n5) {
        if (n != -1) {
            SDKString sDKString = this.getString(n);
            SDKUtils.setFont(this.m_fonts[n2]);
            this.drawString(sDKString, n2, n3, n4, n5);
        }
    }

    public void drawString(SDKString sDKString, int n, int n2, int n3, int n4) {
        if (sDKString != null) {
            SDKUtils.setFont(this.m_fonts[n]);
            SDKUtils.setSpaceSpacing(5);
            if ((n4 & 2) != 0) {
                n3 -= SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() >> 1;
                n4 &= 0xFFFFFFFD;
            }
            SDKUtils.drawString(sDKString, n2, n3, n4);
        }
    }

    public int getSpaceWidth(int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getSpaceSpacing();
    }

    public int getLineHeight(int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getLineSize();
    }

    public SDKString getString(int n) {
        if (n < -2) {
            return this.m_dynamicStrings[n - -12];
        }
        SDKString sDKString = this.m_sdkStringInstances[this.m_getStringInstance];
        this.m_getStringInstance = (this.m_getStringInstance + 1) % 10;
        if (n <= 3) {
            return SDKUtils.getHeaderString(SDKUtils.getCurrentLanguage(), n, sDKString);
        }
        return SDKUtils.getString(n, sDKString);
    }

    public int getStringWidth(int n, int n2) {
        SDKUtils.setFont(this.m_fonts[n2]);
        SDKString sDKString = this.getString(n);
        return SDKUtils.getStringSize(sDKString);
    }

    public int getStringWidth(SDKString sDKString, int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getStringSize(sDKString);
    }

    public static SDKString stringToSDKString(String string) {
        return new SDKString(string);
    }

    public void dynamicString(int n, int n2, int n3) {
        SDKString sDKString = this.getString(n2);
        this.m_dynamicStrings[n - -12] = sDKString.replaceFirst(this.getString(n3));
    }

    public void dynamicString(int n, int n2, int n3, int n4) {
        SDKString sDKString = this.getString(n2);
        SDKString[] sDKStringArray = s_sdkStrings;
        sDKStringArray[0] = this.getString(n3);
        sDKStringArray[1] = this.getString(n4);
        this.m_dynamicStrings[n - -12] = sDKString.replace(sDKStringArray);
    }

    public void dynamicString(int n, int n2, SDKString sDKString) {
        SDKString sDKString2 = this.getString(n2);
        this.m_dynamicStrings[n - -12] = sDKString2.replaceFirst(sDKString);
    }

    public void dynamicString(int n, int n2, SDKString sDKString, SDKString sDKString2) {
        SDKString sDKString3 = this.getString(n2);
        SDKString[] sDKStringArray = s_sdkStrings;
        sDKStringArray[0] = sDKString;
        sDKStringArray[1] = sDKString2;
        this.m_dynamicStrings[n - -12] = sDKString3.replace(sDKStringArray);
    }

    public void dynamicString(int n, int n2, SDKString sDKString, SDKString sDKString2, SDKString sDKString3) {
        SDKString sDKString4 = this.getString(n2);
        SDKString[] sDKStringArray = s_sdkStrings;
        sDKStringArray[0] = sDKString;
        sDKStringArray[1] = sDKString2;
        sDKStringArray[2] = sDKString3;
        this.m_dynamicStrings[n - -12] = sDKString4.replace(sDKStringArray);
    }

    public void dynamicString(int n, SDKString sDKString) {
        this.m_dynamicStrings[n - -12] = sDKString;
    }

    public SDKString clearStringBuffer() {
        ++this.m_tempBufferIndex;
        if (this.m_tempBufferIndex >= 25) {
            this.m_tempBufferIndex = 0;
        }
        this.m_tempStringBuffer = this.m_tempStringBuffers[this.m_tempBufferIndex];
        AppEngine.ASSERT(this.m_tempBufferIndex <= 25, "invalid buffer id");
        this.m_tempStringBuffer.setLength(0);
        return this.m_tempStringBuffer;
    }

    public void appendStringIdToBuffer(int n) {
        this.m_tempStringBuffer.append(this.getString(n));
    }

    public void appendSDKStringToBuffer(SDKString sDKString) {
        this.m_tempStringBuffer.append(sDKString);
    }

    public void appendIntToBuffer(int n) {
        SDKString sDKString = this.m_tempStringBuffer;
        int n2 = sDKString.length();
        if (n == 0) {
            sDKString.setLength(n2 + 1);
            sDKString.setCharAt(n2, '0');
        } else {
            if (n < 0) {
                sDKString.setLength(n2 + 1);
                sDKString.setCharAt(n2++, '-');
                n = -n;
            }
            int n3 = -1;
            boolean bl = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl) {
                    bl = true;
                    sDKString.setLength(n2 + 1);
                    sDKString.setCharAt(n2++, (char)(48 + n3));
                }
                n -= n3 * i;
            }
        }
    }

    public void appendIntToBufferWithThousandSep(int n) {
        SDKString sDKString = this.m_tempStringBuffer;
        int n2 = sDKString.length();
        if (n == 0) {
            sDKString.setLength(n2 + 1);
            sDKString.setCharAt(n2++, '0');
        } else {
            if (n < 0) {
                sDKString.setLength(n2 + 1);
                sDKString.setCharAt(n2++, '-');
                n = -n;
            }
            int n3 = -1;
            boolean bl = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl) {
                    bl = true;
                    sDKString.setLength(n2 + 1);
                    sDKString.setCharAt(n2++, (char)(48 + n3));
                    if (i == 1000000000 || i == 1000000 || i == 1000) {
                        sDKString.append(this.getString(34));
                        n2 = sDKString.length();
                    }
                }
                n -= n3 * i;
            }
        }
    }

    public void appendMoneyToBuffer(int n) {
        int n2 = this.m_tempBufferIndex;
        SDKString sDKString = this.m_tempStringBuffer;
        SDKString sDKString2 = this.clearStringBuffer();
        this.appendIntToBufferWithThousandSep(Math.abs(n));
        SDKString sDKString3 = this.getString(33).replaceFirst(sDKString2);
        if (n < 0) {
            sDKString.append("-");
        }
        sDKString.append(sDKString3);
        this.m_tempStringBuffer = sDKString;
        this.m_tempBufferIndex = n2;
    }

    public void appendTimeToBuffer24Hour(int n) {
        int n2 = n / 60;
        int n3 = n - n2 * 60;
        int n4 = n2;
        SDKString sDKString = this.m_tempStringBuffer;
        int n5 = sDKString.length();
        char c = '0';
        if (n4 >= 20) {
            c = '2';
            n4 -= 20;
        } else if (n4 >= 10) {
            c = '1';
            n4 -= 10;
        }
        sDKString.setLength(n5 + 1);
        sDKString.setCharAt(n5++, c);
        sDKString.setLength(n5 + 1);
        sDKString.setCharAt(n5++, (char)(48 + n4));
        sDKString.setLength(n5 + 1);
        sDKString.setCharAt(n5++, ':');
        int n6 = n3 / 10;
        sDKString.setLength(n5 + 2);
        sDKString.setCharAt(n5++, (char)(48 + n6));
        sDKString.setCharAt(n5++, (char)(48 + (n3 - n6 * 10)));
    }

    private void initWraps() {
        this.m_wrapOffsets = new short[255];
        this.m_wrapOffsets[0] = 0;
        this.m_wrapChunkOffsets = new short[20][10];
        for (int i = 0; i < 20; ++i) {
            this.m_wrapChunkOffsets[i][0] = 0;
        }
        this.m_wrapChunkStrings = new SDKString[20];
        this.m_wrapChunkStringIds = new short[20];
    }

    public int wrapString(int n, int n2, int n3) {
        SDKUtils.setFont(this.m_fonts[n2]);
        if (n == -1) {
            return 0;
        }
        this.m_wrapString = this.getString(n).toSDKString();
        if (n == 92) {
            String string = this.m_midlet.getAppProperty("MIDlet-Version");
            this.m_wrapString = this.m_wrapString.replaceFirst(string);
        }
        SDKUtils.wrapString(this.m_wrapString, this.m_wrapOffsets, n3, (short)124);
        return this.m_wrapOffsets[0];
    }

    public int getNumWrappedLines() {
        return this.m_wrapOffsets[0];
    }

    public void drawWrappedString(int n, int n2, int n3, int n4) {
        SDKUtils.setFont(this.m_fonts[n]);
        SDKUtils.setSpaceSpacing(5);
        SDKUtils.drawWrappedString(this.m_wrapString, this.m_wrapOffsets, 1, this.m_wrapOffsets[0], n2, n3, n4);
    }

    public void drawPartWrappedString(int n, int n2, int n3, int n4, int n5, int n6) {
        SDKUtils.setFont(this.m_fonts[n]);
        SDKUtils.setSpaceSpacing(5);
        if ((n4 & 2) != 0) {
            int n7 = SDKUtils.getLineSize() + SDKUtils.getLeadingSpacing();
            int n8 = n6 * n7;
            int n9 = n8 >> 1;
            n3 -= n9;
            n4 ^= 2;
        }
        n6 = Math.min(this.m_wrapOffsets[0] - n5, n6);
        SDKUtils.drawWrappedString(this.m_wrapString, this.m_wrapOffsets, n5 + 1, n6, n2, n3, n4);
    }

    private int wrapStringChunk(int n, int n2, int n3, int n4) {
        SDKUtils.setFont(this.m_fonts[n3]);
        this.m_wrapChunkStringIds[n] = (short)n2;
        if (n2 == -1) {
            return 0;
        }
        this.m_wrapChunkStrings[n] = this.getString(n2).toSDKString();
        SDKUtils.wrapString(this.m_wrapChunkStrings[n], this.m_wrapChunkOffsets[n], n4, (short)124);
        return this.m_wrapChunkOffsets[n][0];
    }

    public void drawWrappedStringChunk(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 != this.m_wrapChunkStringIds[n]) {
            this.wrapStringChunk(n, n2, n3, n4);
            this.m_wrapChunkStringIds[n] = (short)n2;
        }
        SDKUtils.setFont(this.m_fonts[n3]);
        SDKUtils.setSpaceSpacing(5);
        SDKUtils.drawWrappedString(this.m_wrapChunkStrings[n], this.m_wrapChunkOffsets[n], 1, this.m_wrapChunkOffsets[n][0], n5, n6, n7);
    }

    public void drawClippedString(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawClippedString(graphics, this.getString(n), n2, n3, n4, n5, n6);
    }

    public void drawClippedString(Graphics graphics, SDKString sDKString, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getStringWidth(sDKString, n);
        if (n6 <= n4) {
            if ((n5 & 1) != 0) {
                n2 += n4 >> 1;
            }
            this.drawString(sDKString, n, n2, n3, n5);
        } else {
            int n7 = graphics.getClipX();
            int n8 = graphics.getClipY();
            int n9 = graphics.getClipWidth();
            int n10 = graphics.getClipHeight();
            int n11 = this.getStringWidth(29, n);
            graphics.setClip(n2, n8, n4 - n11, n10);
            this.drawString(sDKString, n, n2, n3, n5 & 0xFFFFFFF6 | 4);
            graphics.setClip(n7, n8, n9, n10);
            this.drawString(29, n, n2 + n4, n3, n5 & 0xFFFFFFFA | 8);
        }
    }

    public void resetScrollers() {
        for (int i = 0; i < 2; ++i) {
            this.m_scrollerStringId[i] = -1;
            this.m_scrollerStringArray[i] = null;
        }
    }

    private void setupScroller(int n, int n2, int n3) {
        if (n < 2) {
            this.m_scrollerTime[n] = 0;
            this.m_scrollerStringId[n] = n3;
            this.m_scrollerStringArray[n] = null;
            if (n3 != -1) {
                this.m_scrollerStringWidth[n] = this.getStringWidth(n3, n2);
                this.m_scrollerOffset[n] = 0;
            }
        }
    }

    private void setupScroller(int n, int n2, SDKString sDKString) {
        if (n < 2) {
            this.m_scrollerTime[n] = 0;
            this.m_scrollerStringId[n] = -1;
            this.m_scrollerStringArray[n] = sDKString;
            if (sDKString != null) {
                this.m_scrollerStringWidth[n] = this.getStringWidth(sDKString, n2);
                this.m_scrollerOffset[n] = 0;
            }
        }
    }

    public void updateScrollers(int n) {
        for (int i = 0; i < 2; ++i) {
            if (this.m_scrollerStringId[i] == -1 && this.m_scrollerStringArray[i] == null) continue;
            int n2 = i;
            this.m_scrollerTime[n2] = this.m_scrollerTime[n2] + n;
            if (this.m_scrollerTime[i] <= 1500) continue;
            long l = this.m_scrollerTime[i] - 1500;
            this.m_scrollerOffset[i] = (int)(l * 20L >> 10);
            int n3 = this.m_scrollerStringWidth[i] + 20;
            if (this.m_scrollerOffset[i] < n3) continue;
            int n4 = i;
            this.m_scrollerOffset[n4] = this.m_scrollerOffset[n4] - n3;
            int n5 = i;
            this.m_scrollerTime[n5] = this.m_scrollerTime[n5] - (n3 << 10) / 20;
        }
    }

    public void renderScroller(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        AppEngine.ASSERT(n >= 0 && n < 2, "invalid scroller id");
        if (this.m_scrollerStringId[n] != n2 || this.m_scrollerStringWidth[n] != this.getStringWidth(n2, n3)) {
            this.setupScroller(n, n3, n2);
        }
        if (this.m_scrollerStringWidth[n] <= n6) {
            if ((n7 & 1) != 0) {
                n4 += n6 >> 1;
            } else if ((n7 & 8) != 0) {
                n4 += n6;
            }
            this.drawString(n2, n3, n4, n5, n7);
        } else {
            int n8 = graphics.getClipX();
            int n9 = graphics.getClipY();
            int n10 = graphics.getClipWidth();
            int n11 = graphics.getClipHeight();
            graphics.setClip(n4, n9, n6, n11);
            n7 = n7 & 0xFFFFFFF6 | 4;
            this.drawString(n2, n3, n4 - this.m_scrollerOffset[n], n5, n7);
            this.drawString(n2, n3, n4 - this.m_scrollerOffset[n] + this.m_scrollerStringWidth[n] + 20, n5, n7);
            graphics.setClip(n8, n9, n10, n11);
        }
    }

    public void renderScroller(int n, Graphics graphics, SDKString sDKString, int n2, int n3, int n4, int n5, int n6) {
        AppEngine.ASSERT(n >= 0 && n < 2, "invalid scroller id");
        if (this.m_scrollerStringArray[n] != sDKString || this.m_scrollerStringWidth[n] != this.getStringWidth(sDKString, n2)) {
            this.setupScroller(n, n2, sDKString);
        }
        if (this.m_scrollerStringWidth[n] <= n5) {
            if ((n6 & 1) != 0) {
                n3 += n5 >> 1;
            } else if ((n6 & 8) != 0) {
                n3 += n5;
            }
            this.drawString(sDKString, n2, n3, n4, n6);
        } else {
            int n7 = graphics.getClipX();
            int n8 = graphics.getClipY();
            int n9 = graphics.getClipWidth();
            int n10 = graphics.getClipHeight();
            graphics.setClip(n3, n8, n5, n10);
            n6 = n6 & 0xFFFFFFF6 | 4;
            this.drawString(sDKString, n2, n3 - this.m_scrollerOffset[n], n4, n6);
            this.drawString(sDKString, n2, n3 - this.m_scrollerOffset[n] + this.m_scrollerStringWidth[n] + 20, n4, n6);
            graphics.setClip(n7, n8, n9, n10);
        }
    }

    public void renderWavyString(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        AppEngine.ASSERT(n >= 0 && n < 2, "invalid scroller id");
        if (this.m_scrollerStringId[n] != n2) {
            this.setupScroller(n, n3, SDKUtils.getString(n2, null));
            this.m_scrollerStringId[n] = n2;
            this.m_scrollerTime[n] = 1500;
        }
        SDKString sDKString = this.m_scrollerStringArray[n];
        int n7 = this.getStringWidth(sDKString, n3);
        if ((n6 & 1) != 0) {
            n4 -= n7 >> 1;
        } else if ((n6 & 8) != 0) {
            n4 -= n7;
        }
        n6 = n6 & 0xFFFFFFF6 | 4;
        SDKString sDKString2 = this.clearStringBuffer();
        sDKString2.setLength(1);
        int n8 = sDKString.length();
        int n9 = this.m_scrollerOffset[n] << 1;
        if (n9 > n7 + 20) {
            this.m_scrollerTime[n] = 1500;
            this.m_scrollerOffset[n] = 0;
            n9 = 0;
        }
        int n10 = n9 - 10 - 20;
        int n11 = n10 + 20;
        int n12 = 0;
        for (int i = 0; i < n8; ++i) {
            sDKString2.setCharAt(0, sDKString.charAt(i));
            if (n12 < n10 || n12 > n11) {
                this.drawString(sDKString2, n3, n4 + n12, n5, n6);
            } else {
                int n13 = MathExt.Fdiv(n12 - n10 << 16, 0x140000);
                int n14 = MathExt.Fmul(411775, n13) - 205887;
                this.DEBUG_RENDERWAVYSTRING(n13, n14);
                int n15 = MathExt.Fcos(n14) * 6;
                this.drawString(sDKString2, n3, n4 + n12, n5 - (n15 >> 16) - 6, n6);
            }
            n12 += this.getStringWidth(sDKString2, n3);
        }
        this.DEBUG_RENDERWAVYSTRING("string rendered...");
    }

    private final void DEBUG_RENDERWAVYSTRING(String string) {
    }

    private final void DEBUG_RENDERWAVYSTRING(int n, int n2) {
    }

    public void startFadeOut() {
        this.m_fadeColor = 0xFFFFFF;
        this.m_fadeDir = -1;
        this.m_fading = true;
        this.m_fadeColorReached = false;
    }

    public void startFadeIn() {
        this.m_fadeColor = 0;
        this.m_fadeDir = 1;
        this.m_fading = true;
        this.m_fadeColorReached = false;
    }

    public void stopFade() {
        this.m_fadeColor = 0xFFFFFF;
        this.m_fadeDir = -1;
        this.m_fading = false;
        this.m_fadeColorReached = true;
    }

    public boolean fadeColorReached() {
        return this.m_fadeColorReached;
    }

    public boolean isFading() {
        return this.m_fading && !this.fadeColorReached();
    }

    public boolean isFadingOut() {
        return this.isFading() && this.m_fadeDir == -1;
    }

    public void setFadeStep(int n) {
        this.m_fadeStep = n;
    }

    public void renderFade(Graphics graphics) {
        this.m_postEffects.setViewport(0, 0, this.getWidth(), this.getHeight());
        this.m_postEffects.setBlendMode(0);
        this.m_postEffects.setColor(this.m_fadeColor);
        this.m_postEffects.apply(graphics);
    }

    public void renderFade(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_postEffects.setBlendMode(n);
        this.m_postEffects.setViewport(n3, n4, n5, n6);
        this.m_postEffects.setColor(n2);
        this.m_postEffects.apply(graphics);
    }

    public void renderBackgroundDim(Graphics graphics) {
        AnimationManager.setColor(graphics, 60);
        int n = this.getHeight() - 15;
        int n2 = this.getWidth();
        graphics.fillRect(0, 0, n2, n);
    }

    public static final void doGC() {
    }

    public void requestGC(boolean bl) {
        if (bl) {
            AppEngine.doGC();
            this.m_runGarbageCollect = false;
        } else {
            this.m_runGarbageCollect = true;
        }
    }

    public Scene getScene() {
        return this.m_currentScene;
    }

    public SceneGame getSceneGame() {
        return this.m_currentScene instanceof SceneGame ? (SceneGame)this.m_currentScene : null;
    }

    public SceneMenu getSceneMenu() {
        return this.m_currentScene instanceof SceneMenu ? (SceneMenu)this.m_currentScene : null;
    }

    public int getNextSceneId() {
        return this.m_nextScene;
    }

    public void changeScene(int n, int n2) {
        this.m_nextScene = n;
        this.m_nextSceneState = n2;
    }

    private void performChangeScene(int n, int n2) {
        boolean bl = this.getSceneGame() != null && n == 2;
        this.m_loadingString = -1;
        if (this.m_currentScene != null) {
            this.m_currentScene.end();
        }
        this.stopFade();
        if (!bl) {
            this.m_currentScene = null;
        } else {
            AppEngine.DEBUG_MEMORY("scene recycled");
        }
        this.requestGC(true);
        AppEngine.DEBUG_MEMORY("scene GCed");
        if (!bl) {
            switch (n) {
                case 1: {
                    this.m_currentScene = new SceneMenu(this);
                    break;
                }
                case 2: {
                    this.m_currentScene = new SceneGame(this);
                    break;
                }
                default: {
                    AppEngine.ASSERT(false, "invalid scene");
                }
            }
            AppEngine.DEBUG_MEMORY("scene created");
        }
        this.m_currentScene.start(n2);
        AppEngine.DEBUG_MEMORY("scene started");
        this.clearKeysPressedDown();
        this.clearCommandKeys();
        this.repaint();
    }

    public int rand(int n, int n2) {
        int n3 = n2 + 1 - n;
        return n + this.m_randomInstance.nextInt(n3);
    }

    public int randPercent() {
        return this.rand(0, 99);
    }

    public void vibrate() {
        this.vibrate(400);
    }

    public void vibrate(int n) {
        if (this.m_rmsGSVibrationEnabled) {
            this.m_soundManager.vibrate(n);
        }
    }

    public static void ASSERT(boolean bl, String string) {
    }

    private void debugKey(int n) {
        for (int i = 0; i < DEBUG_CODES.length; ++i) {
            int[] nArray = DEBUG_CODES[i];
            int n2 = nArray.length - 1;
            int n3 = nArray[0];
            int n4 = nArray[n3 + 1];
            if (n4 == n) {
                if (++n3 == n2) {
                    n3 = 0;
                    switch (i) {
                        case 0: {
                            this.m_debugCheatMenuEnabled = !this.m_debugCheatMenuEnabled;
                        }
                    }
                }
            } else {
                n3 = 0;
            }
            nArray[0] = n3;
        }
    }

    public static void timerBegin() {
    }

    public static void timerEnd(String string) {
    }

    public static int popupSize(int n, int n2, int n3, long l, long l2) {
        if (l >= l2) {
            return n3;
        }
        if (l < 0L) {
            return n2;
        }
        int n4 = 0;
        switch (n) {
            default: {
                return (int)((long)n2 + l * (long)(n3 - n2) / l2);
            }
            case 2: {
                n4 = MathExt.smoothstepF(0, (int)l2, (int)l);
                break;
            }
            case 1: {
                int n5 = (int)(l2 >> 1);
                if (l < (long)n5) {
                    int n6 = MathExt.Fdiv(MathExt.Fmul((int)l, 102944), n5);
                    n4 = MathExt.Fmul(MathExt.Fsin(n6), 72089);
                    break;
                }
                int n7 = MathExt.Fdiv((int)l - n5, (int)l2 - n5);
                int n8 = MathExt.Fmul(n7, 617662);
                int n9 = 6554 - MathExt.Fmul(6554, n7);
                n4 = MathExt.Fmul(MathExt.Fcos(n8), n9) + 65536;
                break;
            }
        }
        return n2 + (n4 * (n3 - n2) >> 16);
    }

    private void processSoftKeys(int n) {
        if (this.isFading() || n == 0 || this.m_softKeyLAnimPlayer.isAnimating()) {
            return;
        }
        if (n == this.getLeftCommandID()) {
            this.clearCommandKeys();
            this.m_softKeyAnimateRight = false;
            this.m_softKeyLAnimPlayer.startAnim(684, 16);
            this.m_softKeyLAnimPlayer.setFrame(1);
            this.m_softKeyRAnimPlayer.startAnim(686, 16);
            this.m_softKeyRAnimPlayer.setFrame(1);
        } else if (n == this.getRightCommandID()) {
            this.clearCommandKeys();
            this.m_softKeyAnimateRight = true;
            this.m_softKeyLAnimPlayer.startAnim(684, 16);
            this.m_softKeyLAnimPlayer.setFrame(1);
            this.m_softKeyRAnimPlayer.startAnim(686, 16);
            this.m_softKeyRAnimPlayer.setFrame(1);
        }
    }

    private void updateSoftKeys(int n) {
        if (this.isFading()) {
            this.m_leftSoftkeyTime = 0L;
            this.m_rightSoftkeyTime = 0L;
        } else {
            if (this.m_leftSoftkeyTime < 0L) {
                this.m_leftSoftkeyTime += (long)n;
            }
            if (this.m_rightSoftkeyTime < 0L) {
                this.m_rightSoftkeyTime += (long)n;
            }
        }
        if (this.m_softKeyLAnimPlayer.isAnimating()) {
            this.m_softKeyLAnimPlayer.updateAnim(n);
            this.m_softKeyRAnimPlayer.updateAnim(n);
            if (!this.m_softKeyLAnimPlayer.isAnimating()) {
                int n2;
                int n3 = n2 = this.m_softKeyAnimateRight ? this.getRightCommandID() : this.getLeftCommandID();
                if (this.m_currentScene != null) {
                    this.m_currentScene.processKeys(0, n2);
                }
            }
        }
    }

    public void renderSoftkeyBar(Graphics graphics) {
        this.renderSoftkeyBar(graphics, 0);
    }

    public void renderSoftkeyBar(Graphics graphics, int n) {
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = AnimationManager.getAnimFrameWidth(683, 0);
        for (int i = 0; i < n3; i += n4) {
            AnimationManager.drawAnimFrame(graphics, 683, 0, i, n2 + n);
        }
        if (!this.isFading()) {
            this.renderSoftkeyButtons(graphics, n);
        }
    }

    private void renderSoftkeyButtons(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        SDKString sDKString;
        int n6 = AppEngine.getCommandString(this.getLeftCommandID());
        int n7 = AppEngine.getCommandString(this.getRightCommandID());
        if (n6 >= 0) {
            sDKString = this.getString(n6);
            SDKString sDKString2 = this.clearStringBuffer();
            SDKString sDKString3 = new SDKString("Q : ");
            this.appendSDKStringToBuffer(sDKString3);
            this.appendSDKStringToBuffer(sDKString);
            sDKString = sDKString2;
            int n8 = AppEngine.popupSize(1, 15, 0, this.m_leftSoftkeyTime, 0L);
            int n9 = this.getHeight() + n8 + n;
            n5 = n9 - 7;
            n4 = Math.max(25, this.getStringWidth(sDKString, 0));
            n3 = 11 + n4 - 4;
            n2 = 11 + n3 >> 1;
            if (this.m_softKeyLAnimPlayer.isAnimating() && !this.m_softKeyAnimateRight) {
                AnimationManager.drawAnim(graphics, this.m_softKeyLAnimPlayer, 11, n9);
                AnimationManager.drawAnim(graphics, this.m_softKeyRAnimPlayer, n3, n9);
                this.renderSoftKeyJoin(graphics, 13, n9, n3 - 11 - 4, true);
                this.drawString(sDKString, 0, n2, n5, 3);
            } else {
                AnimationManager.drawAnimFrame(graphics, 686, 0, n3, n9);
                AnimationManager.drawAnimFrame(graphics, 684, 0, 11, n9);
                this.renderSoftKeyJoin(graphics, 13, n9, n3 - 11 - 4, false);
                this.drawString(sDKString, 0, n2, n5, 3);
            }
        }
        if (n7 >= 0) {
            sDKString = this.getString(n7);
            SDKString sDKString4 = this.clearStringBuffer();
            SDKString sDKString5 = new SDKString("P : ");
            this.appendSDKStringToBuffer(sDKString5);
            this.appendSDKStringToBuffer(sDKString);
            sDKString = sDKString4;
            int n10 = AppEngine.popupSize(1, 15, 0, this.m_rightSoftkeyTime, 0L);
            int n11 = this.getHeight() + n10 + n;
            n5 = n11 - 7;
            n4 = Math.max(25, this.getStringWidth(sDKString, 0));
            int n12 = this.getWidth() - 11;
            n3 = n12 - n4 + 4;
            n2 = n3 + n12 >> 1;
            if (this.m_softKeyLAnimPlayer.isAnimating() && this.m_softKeyAnimateRight) {
                AnimationManager.drawAnim(graphics, this.m_softKeyLAnimPlayer, n3, n11);
                AnimationManager.drawAnim(graphics, this.m_softKeyRAnimPlayer, n12, n11);
                this.renderSoftKeyJoin(graphics, n3 + 2, n11, n12 - n3 - 4, true);
                this.drawString(sDKString, 0, n2, n5, 3);
            } else {
                AnimationManager.drawAnimFrame(graphics, 686, 0, n12, n11);
                AnimationManager.drawAnimFrame(graphics, 684, 0, n3, n11);
                this.renderSoftKeyJoin(graphics, n3 + 2, n11, n12 - n3 - 4, false);
                this.drawString(sDKString, 0, n2, n5, 3);
            }
        }
    }

    private void renderSoftKeyJoin(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = bl ? 1 : 0;
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        graphics.setClip(n, n6, n3, n8);
        AnimationManager.drawAnimFrame(graphics, 685, n4, n, n2);
        graphics.setClip(n5, n6, n7, n8);
    }

    public void loadImagesBegin() {
        this.m_loadImageIndex = 0;
    }

    public boolean loadImagesNext(int n) {
        return this.loadImagesNext(n, null, null, 0);
    }

    public boolean loadImagesNext(int n, int[] nArray, int[] nArray2, int n2) {
        int n3 = 2;
        ResourceManager resourceManager = this.getResourceManager();
        int n4 = 0;
        int n5 = this.m_loadImageIndex;
        while (n5 << 1 < this.d_images.length && n4 < n3) {
            if ((this.d_images[(n5 << 1) + 1] & n) != 0) {
                int n6;
                for (n6 = 1; !AnimationManager.loadImage(resourceManager, this.d_images[n5 << 1], nArray, nArray2, n2) && n6 < 2; ++n6) {
                    AppEngine.doGC();
                }
                if (n6 >= 2) {
                    throw new Error("OOM");
                }
                ++n4;
            }
            ++n5;
        }
        this.m_loadImageIndex = n5;
        return n5 << 1 == this.d_images.length;
    }

    public void loadAllImages(int n) {
        this.loadAllImages(n, null, null, 0);
    }

    public void loadAllImages(int n, int[] nArray, int[] nArray2, int n2) {
        this.loadImagesBegin();
        while (!this.loadImagesNext(n, nArray, nArray2, n2)) {
        }
    }

    public void unloadAllImages(int n, int n2) {
        int[] nArray = this.d_images;
        int n3 = 0;
        while (n3 << 1 < nArray.length) {
            if ((nArray[(n3 << 1) + 1] & n) != 0) {
                int n4 = nArray[n3 << 1];
                if (n2 == -1) {
                    for (int i = 0; i < 4; ++i) {
                        AnimationManager.unloadImage(n4, i);
                    }
                } else {
                    AnimationManager.unloadImage(n4, n2);
                }
            }
            ++n3;
        }
        AppEngine.doGC();
    }

    public static final void fillArray(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = object;
        }
    }

    public static final void fillArray(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)n;
        }
    }

    public static final void fillArray(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)n;
        }
    }

    public static final void fillArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static final void fillArray(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            AppEngine.fillArray(nArray[i], n);
        }
    }

    public static final void fillArray(short[][] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            AppEngine.fillArray(sArray[i], n);
        }
    }

    public static final int indexOf(int n, int[] nArray) {
        return AppEngine.indexOf(n, nArray, 0);
    }

    public static final int indexOf(int n, short[] sArray) {
        return AppEngine.indexOf(n, sArray, 0);
    }

    public static final int indexOf(int n, byte[] byArray) {
        return AppEngine.indexOf(n, byArray, 0);
    }

    public static final int indexOf(Object object, Object[] objectArray) {
        return AppEngine.indexOf(object, objectArray, 0);
    }

    public static final int indexOf(int n, int[] nArray, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int n, short[] sArray, int n2) {
        for (int i = n2; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int n, byte[] byArray, int n2) {
        for (int i = n2; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(Object object, Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfFlags(int n, short[] sArray) {
        return AppEngine.indexOfFlags(n, sArray, 0);
    }

    public static final int indexOfFlags(int n, short[] sArray, int n2) {
        for (int i = n2; i < sArray.length; ++i) {
            if ((sArray[i] & n) == 0) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfNthElement(int n, byte[] byArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == n2 || n3++ != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfNthElement(int n, short[] sArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == n2 || n3++ != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfNthElementFlags(int n, short[] sArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if ((sArray[i] & n2) == 0 || n3++ != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfNthElementFlags(int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n2) == 0 || n3++ != n) continue;
            return i;
        }
        return -1;
    }

    public static final int countOf(int n, short[] sArray) {
        int n2 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int countOf(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int countOfFlags(int n, int[] nArray) {
        return AppEngine.countOfFlags(n, nArray, 0);
    }

    public static final int countOfFlags(int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = n2; i < nArray.length; ++i) {
            if ((nArray[i] & n) == 0) continue;
            ++n3;
        }
        return n3;
    }

    public static final int countOfFlags(int n, short[] sArray) {
        return AppEngine.countOfFlags(n, sArray, 0);
    }

    public static final int countOfFlags(int n, short[] sArray, int n2) {
        int n3 = 0;
        for (int i = n2; i < sArray.length; ++i) {
            if ((sArray[i] & n) == 0) continue;
            ++n3;
        }
        return n3;
    }

    public static void menuClear(short[] sArray, int n) {
        AppEngine.menuClear(sArray, n, -1);
    }

    public static void menuClear(short[] sArray, int n, int n2) {
        sArray[1] = (short)n;
        sArray[2] = 0;
        sArray[3] = 0;
        sArray[4] = (short)n2;
        sArray[0] = 0;
    }

    public static void menuAppendItem(short[] sArray, int n) {
        short s = sArray[0];
        sArray[5 + s] = (short)n;
        sArray[0] = (short)(s + 1);
    }

    public static boolean menuContains(short[] sArray, int n) {
        int n2 = sArray[0] + 5;
        for (int i = 5; i < n2; ++i) {
            if (n != sArray[i]) continue;
            return true;
        }
        return false;
    }

    public static void menuCopy(short[] sArray, short[] sArray2) {
        System.arraycopy(sArray2, 0, sArray, 0, 5 + sArray2[0]);
    }

    public static void menuVisible(short[] sArray) {
        short s = sArray[4];
        if (s <= 0) {
            return;
        }
        int n = sArray[2];
        int n2 = sArray[3];
        if (n < n2) {
            n2 = n;
        } else if (n >= n2 + s) {
            n2 = Math.max(0, n - s + 1);
        }
        sArray[3] = (short)n2;
    }

    public boolean menuCursorUpDown(short[] sArray, int n) {
        short s = sArray[0];
        short s2 = sArray[2];
        if ((n & 0x2004) != 0) {
            this.clearKeyBit(8196);
            sArray[2] = (short)((s2 + s - 1) % s);
        }
        if ((n & 0x4100) != 0) {
            this.clearKeyBit(16640);
            sArray[2] = (short)((s2 + 1) % s);
        }
        if (sArray[2] != s2) {
            AppEngine.menuVisible(sArray);
            if (this.getSceneGame() != null) {
                this.m_soundManager.playSound(0);
            }
            return true;
        }
        return false;
    }

    public boolean menuCursorLeftRight(short[] sArray, int n) {
        short s = sArray[0];
        short s2 = sArray[2];
        if ((n & 0x8010) != 0) {
            this.clearKeyBit(32784);
            sArray[2] = (short)((s2 + s - 1) % s);
        }
        if ((n & 0x10040) != 0) {
            this.clearKeyBit(65600);
            sArray[2] = (short)((s2 + 1) % s);
        }
        if (sArray[2] != s2) {
            AppEngine.menuVisible(sArray);
            this.resetScrollers();
            if (this.getSceneGame() != null) {
                this.m_soundManager.playSound(1);
            }
            return true;
        }
        return false;
    }

    public static void menuSelectById(short[] sArray, int n) {
        for (int i = 5; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            sArray[2] = (short)(i - 5);
            return;
        }
    }

    public boolean getAutonomityEnabled() {
        return this.m_rmsGSAutonomityEnabled;
    }

    public boolean getTutorialsEnabled() {
        return this.m_rmsGSTutorialsEnabled;
    }

    public boolean getSavePromptsEnabled() {
        return this.m_rmsGSSavePrompts;
    }

    public int getRMSLangIndex() {
        return this.m_rmsGSLangIndex;
    }

    private void DEBUG_RMS(String string) {
    }

    private void resetRMSAppSettings() {
        this.m_rmsGSVibrationEnabled = true;
        this.m_rmsGSTutorialsEnabled = true;
        this.m_rmsGSAutonomityEnabled = true;
        this.m_rmsGSWinterSeasonEnabled = true;
        this.m_rmsGSSavePrompts = true;
        this.m_rmsGSBonusUnlocked = false;
        this.m_rmsGSXmasLightingEnabled = false;
        this.m_rmsGlobalDreamsDiscovered1 = 0L;
        this.m_rmsGlobalDreamsDiscovered2 = 0L;
        this.m_rmsGlobalDreamsComplete1 = 0L;
        this.m_rmsGlobalDreamsComplete2 = 0L;
        m_rmsGSXmasCoordinates_X = 0;
        m_rmsGSXmasCoordinates_Y = 0;
        this.m_rmsGSLangIndex = -1;
        this.resetSimSaveData();
    }

    public void loadRMSAppSettings() {
        this.DEBUG_RMS("loadRMSAppSettings");
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"sim3weset", (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            int n2 = ((DataInputStream)filterInputStream).readInt();
            if (n == 86 && n2 == 3) {
                this.m_rmsGSVibrationEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGSWinterSeasonEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGSTutorialsEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGSAutonomityEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGSSavePrompts = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGSBonusUnlocked = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGSXmasLightingEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsGlobalDreamsDiscovered1 = ((DataInputStream)filterInputStream).readLong();
                this.m_rmsGlobalDreamsDiscovered2 = ((DataInputStream)filterInputStream).readLong();
                this.m_rmsGlobalDreamsComplete1 = ((DataInputStream)filterInputStream).readLong();
                this.m_rmsGlobalDreamsComplete2 = ((DataInputStream)filterInputStream).readLong();
                m_rmsGSXmasCoordinates_X = ((DataInputStream)filterInputStream).readInt();
                m_rmsGSXmasCoordinates_Y = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsGSLangIndex = ((DataInputStream)filterInputStream).readByte();
                for (int i = 0; i != 3; ++i) {
                    boolean bl = false;
                    char c = ' ';
                    SDKString sDKString = this.m_rmsSimNameString[i];
                    for (int j = 0; j < 8; ++j) {
                        c = ((DataInputStream)filterInputStream).readChar();
                        if (c == ' ') {
                            bl = true;
                            continue;
                        }
                        if (bl) continue;
                        sDKString.setLength(j + 1);
                        sDKString.setCharAt(j, c);
                    }
                    if (!bl) {
                        sDKString.setLength(8);
                    }
                    this.m_rmsGSActiveGame[i] = ((DataInputStream)filterInputStream).readBoolean();
                }
            } else {
                this.resetRMSAppSettings();
                this.saveRMSAppSettings();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.DEBUG_RMS("game settings recordstore not found");
            this.resetRMSAppSettings();
        }
        catch (Exception exception) {
            this.DEBUG_RMS("exception reading RMS settings");
        }
        try {
            filterInputStream.close();
            byteArrayInputStream.close();
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean saveRMSAppSettings() {
        this.DEBUG_RMS("saveRMSAppSettings");
        try {
            RecordStore.deleteRecordStore((String)"sim3weset");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(86);
            dataOutputStream.writeInt(3);
            dataOutputStream.writeBoolean(this.m_rmsGSVibrationEnabled);
            dataOutputStream.writeBoolean(this.m_rmsGSWinterSeasonEnabled);
            dataOutputStream.writeBoolean(this.m_rmsGSTutorialsEnabled);
            dataOutputStream.writeBoolean(this.m_rmsGSAutonomityEnabled);
            dataOutputStream.writeBoolean(this.m_rmsGSSavePrompts);
            dataOutputStream.writeBoolean(this.m_rmsGSBonusUnlocked);
            dataOutputStream.writeBoolean(this.m_rmsGSXmasLightingEnabled);
            dataOutputStream.writeLong(this.m_rmsGlobalDreamsDiscovered1);
            dataOutputStream.writeLong(this.m_rmsGlobalDreamsDiscovered2);
            dataOutputStream.writeLong(this.m_rmsGlobalDreamsComplete1);
            dataOutputStream.writeLong(this.m_rmsGlobalDreamsComplete2);
            dataOutputStream.writeInt(m_rmsGSXmasCoordinates_X);
            dataOutputStream.writeInt(m_rmsGSXmasCoordinates_Y);
            dataOutputStream.writeByte(this.m_rmsGSLangIndex);
            for (int i = 0; i != 3; ++i) {
                SDKString sDKString = this.m_rmsSimNameString[i];
                for (int j = 0; j != 8; ++j) {
                    int n = 32;
                    if (j < sDKString.length()) {
                        n = sDKString.charAt(j);
                    }
                    dataOutputStream.writeChar(n);
                }
                dataOutputStream.writeBoolean(this.m_rmsGSActiveGame[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)"sim3weset", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
            byteArrayOutputStream.close();
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            bl = true;
        }
        return !bl;
    }

    public void resetRMSGameData() {
        this.DEBUG_RMS("resetRMSGameData");
        this.m_rmsGDTutorialFlags = 0;
        this.resetGDGoals();
        this.m_simData.resetRMSGameData();
        this.m_simWorld.resetRMSGameData();
    }

    public void loadRMSGameData() {
        this.DEBUG_RMS("loadRMSGameData");
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)("sim3wedat" + this.m_gameSlotIndex), (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 86) {
                this.m_rmsGDTutorialFlags = ((DataInputStream)filterInputStream).readInt();
                this.m_simData.loadRMSGameData((DataInputStream)filterInputStream);
                this.m_simWorld.loadRMSGameData((DataInputStream)filterInputStream);
                this.m_nextHouseId = 0;
            } else {
                this.resetRMSGameData();
                this.saveRMSGameData();
            }
        }
        catch (Exception exception) {
            this.DEBUG_RMS("exception reading game data");
            this.resetRMSGameData();
            this.saveRMSGameData();
        }
        try {
            filterInputStream.close();
            byteArrayInputStream.close();
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean saveRMSGameData() {
        this.DEBUG_RMS("saveRMSGameData");
        String string = "sim3wedat" + this.m_gameSlotIndex;
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_rmsGlobalDreamsDiscovered1 |= this.m_rmsGDDreamsDiscovered1;
        this.m_rmsGlobalDreamsDiscovered2 |= this.m_rmsGDDreamsDiscovered2;
        this.m_rmsGlobalDreamsComplete1 |= this.m_rmsGDDreamsComplete1;
        this.m_rmsGlobalDreamsComplete2 |= this.m_rmsGDDreamsComplete2;
        this.saveRMSAppSettings();
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(86);
            dataOutputStream.writeInt(this.m_rmsGDTutorialFlags);
            this.m_simData.saveRMSGameData(dataOutputStream);
            this.m_simWorld.saveRMSGameData(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
            byteArrayOutputStream.close();
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        return !bl;
    }

    public int getRMSOptionString(int n) {
        if (n == 82) {
            return this.m_soundManager.isSoundEnabled() ? 90 : 91;
        }
        if (n == 83) {
            return this.m_rmsGSVibrationEnabled ? 90 : 91;
        }
        if (n == 84) {
            return this.m_rmsGSTutorialsEnabled ? 90 : 91;
        }
        if (n == 85) {
            return this.m_rmsGSAutonomityEnabled ? 90 : 91;
        }
        if (n == 86) {
            return this.m_rmsGSSavePrompts ? 90 : 91;
        }
        if (n == 967) {
            return this.m_rmsGSWinterSeasonEnabled ? 90 : 91;
        }
        return -1;
    }

    public int getSimNameLength() {
        return this.m_rmsSimNameString[this.m_gameSlotIndex].length();
    }

    public void clearSimName() {
        SDKString sDKString = this.m_rmsSimNameString[this.m_gameSlotIndex];
        sDKString.setLength(0);
    }

    public void insertSimNameChar(int n, char c) {
        SDKString sDKString = this.m_rmsSimNameString[this.m_gameSlotIndex];
        sDKString.setLength(sDKString.length() + 1);
        for (int i = sDKString.length(); n < i; --i) {
            char c2 = sDKString.charAt(i - 1);
            sDKString.setCharAt(i, c2);
        }
        sDKString.setCharAt(n, c);
    }

    public void removeSimNameChar(int n) {
        SDKString sDKString = this.m_rmsSimNameString[this.m_gameSlotIndex];
        int n2 = sDKString.length() - 1;
        while (n != n2) {
            char c = sDKString.charAt(n + 1);
            sDKString.setCharAt(n, c);
            ++n;
        }
        sDKString.setCharAt(n, ' ');
        sDKString.setLength(n2);
    }

    public int getRMSGameSlotIndex() {
        return this.m_gameSlotIndex;
    }

    public void setRMSGameSlotIndex(int n) {
        this.m_gameSlotIndex = n;
        if (this.getRMSActiveGame()) {
            this.loadRMSGameData();
        }
    }

    public SDKString getSimName() {
        return this.m_rmsSimNameString[this.m_gameSlotIndex];
    }

    public SDKString getSimName(int n) {
        return this.m_rmsSimNameString[n];
    }

    public boolean getRMSActiveGame() {
        return this.m_rmsGSActiveGame[this.m_gameSlotIndex];
    }

    public boolean getRMSActiveGame(int n) {
        return this.m_rmsGSActiveGame[n];
    }

    private void resetSimSaveData() {
        this.DEBUG_RMS("resetSimSaveData");
        for (int i = 0; i < 3; ++i) {
            this.resetSimSaveData(i);
        }
    }

    public void resetSimSaveData(int n) {
        this.m_rmsGSActiveGame[n] = false;
    }

    public void newGame() {
        this.DEBUG_RMS("newGame");
        this.m_rmsGSActiveGame[this.m_gameSlotIndex] = true;
        this.m_rmsGDTutorialFlags = 0;
        this.saveRMSAppSettings();
        this.m_simData.newGame();
        this.saveRMSGameData();
    }

    public void beginGame() {
        this.DEBUG_RMS("beginGame");
        this.loadRMSGameData();
        this.m_nextHouseId = 0;
    }

    public boolean getRMSHasSeenTutorial(int n) {
        return (1 << n & this.m_rmsGDTutorialFlags) != 0;
    }

    public void setRMSHasSeenTutorial(int n) {
        this.m_rmsGDTutorialFlags |= 1 << n;
    }

    public boolean isBonusUnlocked() {
        return this.m_rmsGSBonusUnlocked;
    }

    public void unlockBonus() {
        this.m_rmsGSBonusUnlocked = true;
        this.saveRMSAppSettings();
    }

    private void resetGlobalGoals() {
        this.m_rmsGSBonusUnlocked = false;
        this.m_rmsGlobalDreamsDiscovered1 = 0L;
        this.m_rmsGlobalDreamsDiscovered2 = 0L;
        this.m_rmsGlobalDreamsComplete1 = 0L;
        this.m_rmsGlobalDreamsComplete2 = 0L;
    }

    public void resetGDGoals() {
        this.m_rmsGDDreamsDiscovered1 = 0L;
        this.m_rmsGDDreamsDiscovered2 = 0L;
        this.m_rmsGDDreamsComplete1 = 0L;
        this.m_rmsGDDreamsComplete2 = 0L;
    }

    public boolean isDreamDiscovered(int n) {
        if (n < 64) {
            long l = 1L << n;
            return ((this.m_rmsGlobalDreamsDiscovered1 | this.m_rmsGDDreamsDiscovered1) & l) != 0L;
        }
        long l = 1L << n - 64;
        return ((this.m_rmsGlobalDreamsDiscovered2 | this.m_rmsGDDreamsDiscovered2) & l) != 0L;
    }

    public void setGoalDiscovered(int n) {
        if (n < 64) {
            long l = 1L << n;
            this.m_rmsGDDreamsDiscovered1 |= l;
        } else {
            long l = 1L << n - 64;
            this.m_rmsGDDreamsDiscovered2 |= l;
        }
    }

    public int getNumGoalsDiscovered() {
        long l = this.m_rmsGlobalDreamsDiscovered1 | this.m_rmsGDDreamsDiscovered1;
        long l2 = this.m_rmsGlobalDreamsDiscovered2 | this.m_rmsGDDreamsDiscovered2;
        int n = 0;
        for (int i = 0; i != 64; ++i) {
            n = (int)((long)n + (l >> i & 1L));
            n = (int)((long)n + (l2 >> i & 1L));
        }
        return n;
    }

    public boolean isGoalCompleted(int n) {
        if (n < 64) {
            long l = 1L << n;
            return ((this.m_rmsGlobalDreamsComplete1 | this.m_rmsGDDreamsComplete1) & l) != 0L;
        }
        long l = 1L << n - 64;
        return ((this.m_rmsGlobalDreamsComplete2 | this.m_rmsGDDreamsComplete2) & l) != 0L;
    }

    public void setGoalCompleted(int n) {
        this.setGoalDiscovered(n);
        if (n < 64) {
            long l = 1L << n;
            this.m_rmsGDDreamsComplete1 |= l;
        } else {
            long l = 1L << n - 64;
            this.m_rmsGDDreamsComplete2 |= l;
        }
    }

    public int getNumGoalsComplete() {
        long l = this.m_rmsGlobalDreamsComplete1 | this.m_rmsGDDreamsComplete1;
        long l2 = this.m_rmsGlobalDreamsComplete2 | this.m_rmsGDDreamsComplete2;
        int n = 0;
        for (int i = 0; i != 64; ++i) {
            n = (int)((long)n + (l >> i & 1L));
            n = (int)((long)n + (l2 >> i & 1L));
        }
        return n;
    }

    public void updateLoading(int n) {
        if (this.m_loadingString == -1) {
            this.m_loadingString = this.rand(927, 965);
            this.m_loadingStringPosXF = this.getWidth() << 16;
            this.m_loadingStringWidth = this.getStringWidth(this.m_loadingString, 0);
        } else {
            this.m_loadingStringPosXF -= n * 4915;
            if (this.m_loadingStringPosXF < -(this.m_loadingStringWidth << 16)) {
                this.m_loadingString = -1;
            }
        }
    }

    private void drawThen(Graphics graphics, int n, int n2, int n3) {
        SDKString sDKString = this.getString(28);
        this.drawString(sDKString, n3, n, n2, 3);
    }

    public void renderLoading(Graphics graphics) {
        AnimationManager.setColor(graphics, 77);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawString(this.getScene().getUIString(35), 1, this.getHalfWidth(), this.getHalfHeight(), 17);
        if (this.getRMSLangIndex() == 1) {
            AnimationManager.drawAnimFrame(graphics, 568, 9, this.getWidth() >> 1, this.getHeight() >> 2);
        } else {
            AnimationManager.drawAnimFrame(graphics, 567, 9, this.getWidth() >> 1, this.getHeight() >> 2);
        }
        int[] nArray = this.m_currentScene.m_tempInt4;
        AnimationManager.getAnimFrameFirePoint(nArray, 567, 9, 0);
        this.drawThen(graphics, (this.getWidth() >> 1) + nArray[0], (this.getHeight() >> 2) + nArray[1] + 5, 4);
        if (this.m_loadingString != -1) {
            int n = this.getHeight() - 40;
            this.drawString(this.m_loadingString, 0, this.m_loadingStringPosXF >> 16, n, 20);
        }
    }

    public int getMaxMenuItemsPerScreen() {
        return this.m_maxMenuItemsPerScreen;
    }

    private void initSharedMenus() {
        this.m_maxMenuItemsPerScreen = (short)((this.getHeight() - 15 - 22) / 13);
        short[] sArray = new short[13];
        AppEngine.menuClear(sArray, 63, this.m_maxMenuItemsPerScreen);
        AppEngine.menuAppendItem(sArray, 82);
        AppEngine.menuAppendItem(sArray, 83);
        AppEngine.menuAppendItem(sArray, 84);
        AppEngine.menuAppendItem(sArray, 85);
        AppEngine.menuAppendItem(sArray, 86);
        AppEngine.menuAppendItem(sArray, 967);
        this.m_inGameOptionsMenu = new short[sArray[0] + 5];
        AppEngine.menuCopy(this.m_inGameOptionsMenu, sArray);
        AppEngine.menuAppendItem(sArray, 3);
        AppEngine.menuAppendItem(sArray, 88);
        this.m_optionsMenu = sArray;
        sArray = new short[13];
        AppEngine.menuClear(sArray, 64, this.m_maxMenuItemsPerScreen);
        AppEngine.menuAppendItem(sArray, 65);
        AppEngine.menuAppendItem(sArray, 93);
        AppEngine.menuAppendItem(sArray, 99);
        AppEngine.menuAppendItem(sArray, 101);
        AppEngine.menuAppendItem(sArray, 103);
        AppEngine.menuAppendItem(sArray, 105);
        AppEngine.menuAppendItem(sArray, 110);
        AppEngine.menuAppendItem(sArray, 112);
        this.m_helpMenu = sArray;
        this.m_sharedMenuState = -1;
    }

    public int getSharedMenuState() {
        return this.m_sharedMenuState;
    }

    public void stateTransitionSharedMenu(int n) {
        short[] sArray = null;
        int n2 = -1;
        int n3 = 4;
        int n4 = 16;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                sArray = this.m_optionsMenu;
                break;
            }
            case 1: {
                sArray = this.m_inGameOptionsMenu;
                break;
            }
            case 2: {
                n4 = 256;
                n3 = 512;
                n2 = 0;
                this.getScene().prepareGenericMessageBox(89, 88);
                break;
            }
            case 5: {
                n3 = 32768;
                n4 = 16384;
                break;
            }
            case 3: {
                sArray = this.m_helpMenu;
                break;
            }
            case 4: {
                n4 = 0;
                n2 = 3;
            }
        }
        if (this.m_sharedMenuState == -1 && sArray != null) {
            sArray[2] = 0;
        }
        this.m_sharedMenu = sArray;
        this.m_sharedMenuBackState = n2;
        this.m_sharedMenuState = n;
        this.setSoftKeys(n3, n4);
    }

    public void renderSharedMenu(Graphics graphics) {
        Scene scene = this.getScene();
        switch (this.m_sharedMenuState) {
            case -1: {
                AppEngine.ASSERT(false, "no shared menu");
                break;
            }
            case 0: {
                scene.drawGenericMenu(graphics, this.m_optionsMenu, 1);
                break;
            }
            case 1: {
                scene.drawGenericMenu(graphics, this.m_inGameOptionsMenu, 1);
                break;
            }
            case 2: {
                scene.drawGenericMessageBox(graphics);
                break;
            }
            case 3: {
                scene.drawGenericMenu(graphics, this.m_helpMenu, 1);
                break;
            }
            case 4: {
                scene.drawTextScreen(graphics);
                return;
            }
        }
    }

    public void processKeysSharedMenu(int n, int n2) {
        if (this.m_sharedMenu != null) {
            if (n2 == 16 || (n & 0x1020) != 0) {
                this.clearCommandKeys();
                this.clearKeyBit(4128);
                int n3 = 5 + this.m_sharedMenu[2];
                this.processSharedMenuItem(this.m_sharedMenu[n3]);
            } else {
                this.menuCursorUpDown(this.m_sharedMenu, n);
            }
        }
        if (this.m_sharedMenuState == 4) {
            this.getScene().processKeysTextScreen(n);
        } else if (this.m_sharedMenuState == 2) {
            if (n2 == 256) {
                this.clearCommandKeys();
                this.resetSimSaveData();
                this.resetGlobalGoals();
                this.saveRMSAppSettings();
                this.resetRMSGameData();
                this.saveRMSGameData();
                this.stateTransitionSharedMenu(this.m_sharedMenuBackState);
                this.getSceneMenu().initMainMenu(63);
            } else if (n2 == 512) {
                this.clearCommandKeys();
                this.stateTransitionSharedMenu(this.m_sharedMenuBackState);
            }
        }
        if (n2 == 4) {
            this.clearCommandKeys();
            this.stateTransitionSharedMenu(this.m_sharedMenuBackState);
        }
    }

    private void processSharedMenuItem(int n) {
        Scene scene = this.getScene();
        switch (n) {
            case 82: {
                this.m_soundManager.setSoundEnabled(!this.m_soundManager.isSoundEnabled());
                if (!this.m_soundManager.isSoundEnabled()) break;
                if (this.getSceneMenu() != null) {
                    this.startMusic(this.m_musicID);
                    break;
                }
                this.m_soundManager.playSound(1);
                break;
            }
            case 83: {
                boolean bl = this.m_rmsGSVibrationEnabled = !this.m_rmsGSVibrationEnabled;
                if (this.m_rmsGSVibrationEnabled) {
                    this.vibrate(400);
                }
                this.saveRMSAppSettings();
                break;
            }
            case 967: {
                this.m_rmsGSWinterSeasonEnabled = !this.m_rmsGSWinterSeasonEnabled;
                this.saveRMSAppSettings();
                break;
            }
            case 84: {
                this.m_rmsGSTutorialsEnabled = !this.m_rmsGSTutorialsEnabled;
                this.saveRMSAppSettings();
                break;
            }
            case 85: {
                this.m_rmsGSAutonomityEnabled = !this.m_rmsGSAutonomityEnabled;
                this.saveRMSAppSettings();
                break;
            }
            case 86: {
                this.m_rmsGSSavePrompts = !this.m_rmsGSSavePrompts;
                this.saveRMSAppSettings();
                break;
            }
            case 3: {
                this.stateTransitionSharedMenu(5);
                break;
            }
            case 88: {
                this.stateTransitionSharedMenu(2);
                break;
            }
            case 65: {
                scene.prepareTextScreen(92, 65);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 93: {
                scene.prepareTextScreen(94, 93);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 99: {
                scene.prepareTextScreen(100, 99);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 101: {
                scene.prepareTextScreen(102, 101);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 103: {
                scene.prepareTextScreen(104, 103);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 105: {
                scene.prepareTextScreen(106, 105);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 110: {
                scene.prepareTextScreen(111, 110);
                this.stateTransitionSharedMenu(4);
                break;
            }
            case 112: {
                scene.prepareTextScreen(113, 112);
                this.stateTransitionSharedMenu(4);
            }
        }
    }

    private void loadGameData() {
        this.loadUIPanels();
        this.m_simWorld = new SimWorld(this);
        this.m_simData = new SimData(this);
        this.m_nextHouseId = 0;
        this.m_nextZoomMapId = -1;
        this.m_encounterNPCId = -1;
    }

    public void setNextHouseId(int n) {
        this.m_nextHouseId = n;
        this.m_nextZoomMapId = -1;
    }

    public int getNextHouseId() {
        return this.m_nextHouseId;
    }

    public void setNextZoomMapId(int n) {
        this.m_nextZoomMapId = n;
    }

    public int getNextZoomMapId() {
        return this.m_nextZoomMapId;
    }

    public SimData getSimData() {
        return this.m_simData;
    }

    public SimWorld getSimWorld() {
        return this.m_simWorld;
    }

    public void setupEncounter(MapObjectSim mapObjectSim) {
        MapObjectSim mapObjectSim2 = this.getSceneGame().getPlayerSim();
        this.m_encounterPlayerXF = mapObjectSim2.getPosX();
        this.m_encounterPlayerZF = mapObjectSim2.getPosZ();
        if (mapObjectSim != null) {
            this.m_encounterNPCXF = mapObjectSim.getPosX();
            this.m_encounterNPCZF = mapObjectSim.getPosZ();
            this.m_encounterNPCId = mapObjectSim.getId();
        } else {
            this.m_encounterNPCId = -1;
        }
        this.m_nextHouseId = -1;
    }

    public int getEncounterPlayerX() {
        return this.m_encounterPlayerXF;
    }

    public int getEncounterPlayerZ() {
        return this.m_encounterPlayerZF;
    }

    public int getEncounterNPCX() {
        return this.m_encounterNPCXF;
    }

    public int getEncounterNPCZ() {
        return this.m_encounterNPCZF;
    }

    public int getEncounterNPCId() {
        return this.m_encounterNPCId;
    }

    private static final short lookupSimsUI(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private void loadUIPanels() {
        ResourceManager resourceManager = this.getResourceManager();
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(69));
            int n3 = dataInputStream.readByte();
            short[][] sArrayArray = new short[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = dataInputStream.readByte();
                short[] sArray = new short[n4 << 1];
                n = 0;
                for (int i = 0; i < n4; ++i) {
                    sArray[n] = dataInputStream.readByte();
                    sArray[n + 1] = AppEngine.lookupSimsUI(dataInputStream);
                    n += 2;
                }
                sArrayArray[n2] = sArray;
            }
            n2 = dataInputStream.readByte();
            int[] nArray = new int[n2 << 1];
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                nArray[n5] = AppEngine.lookupSimsUI(dataInputStream);
                nArray[n5 + 1] = dataInputStream.readInt();
                n5 += 2;
            }
            this.d_images = nArray;
            dataInputStream.close();
            this.d_uiPanels = sArrayArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public short[] getUIPanel(int n) {
        return this.d_uiPanels[n];
    }

    static {
        s_singletonAppEngine = null;
        isMinimized = false;
        isFirstLaunch = true;
        currentVolume = 0;
        is_Z_keyPressed = false;
        s_sdkStrings = new SDKString[3];
        DEBUG_CODES = new int[][]{{0, 2048, 2048, 16, 64, 128, 8}};
        FENCE_Y = 0;
    }

    class CandyCane {
        int candyX;
        int candyY;
        int candyPlace;
        boolean candy_taken;

        private CandyCane(int n, int n2, boolean bl) {
            this.candyX = n;
            this.candyY = n2;
        }

        public void drawCandyCane(Graphics graphics) {
            if (this.candyY < 0) {
                this.candyY = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                Random random = new Random();
                random.setSeed(System.currentTimeMillis());
                this.candyPlace = random.nextInt(3);
                this.candy_taken = false;
                switch (this.candyPlace) {
                    case 0: {
                        this.candyX = SceneGame.STYLUS_TIP + SceneGame.MAX_FLAG_OFFSET_X * 3;
                        break;
                    }
                    case 1: {
                        this.candyX = SceneGame.STYLUS_TIP + SceneGame.TRACK_WIDTH - (AppEngine.this.skiing_candy.getWidth() + SceneGame.MAX_FLAG_OFFSET_X);
                        break;
                    }
                    case 2: {
                        this.candyX = SceneGame.STYLUS_TIP + (SceneGame.TRACK_WIDTH >> 1) - (AppEngine.this.skiing_candy.getWidth() >> 1);
                    }
                }
            }
            if (this.isColliding(AppEngine.this.skiing_candy) && !this.candy_taken && !SceneGame.COLLISION_WITH_BORDER && !AppEngine.this.getSceneGame().lifeEnds()) {
                ++SceneGame.FLAG_TAKEN;
                this.candy_taken = true;
                SceneGame.collidedWithCandy = true;
            }
            if (!this.candy_taken) {
                graphics.drawImage(AppEngine.this.skiing_candy, this.candyX - SceneGame.CAMERA_PANNING_FACTOR, this.candyY, 20);
            }
            this.candyY -= SceneGame.SKIER_SPEED;
        }

        public boolean isColliding(Image image) {
            return ski_sprite.collidesWith(AppEngine.this.skiing_candy, this.candyX - SceneGame.CAMERA_PANNING_FACTOR, this.candyY, true);
        }
    }

    class Obstacle {
        int obstacleX;
        int obstacleY;
        int obstacleType;
        int obstaclePlace;
        Image obstacleImage;
        int differenceFromFlag = 60;

        private Obstacle(int n, int n2) {
            this.obstacleX = n;
            this.obstacleY = n2;
            this.obstacleImage = obstacle1;
        }

        public void drawObstacle(Graphics graphics) {
            if (this.obstacleY < 0) {
                this.obstacleY = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                Random random = new Random();
                random.setSeed(System.currentTimeMillis());
                this.obstacleType = random.nextInt(3);
                this.obstaclePlace = random.nextInt(3);
                switch (this.obstaclePlace) {
                    case 0: {
                        this.obstacleX = SceneGame.STYLUS_TIP + SceneGame.MAX_FLAG_OFFSET_X * 2;
                        break;
                    }
                    case 1: {
                        this.obstacleX = SceneGame.STYLUS_TIP + SceneGame.TRACK_WIDTH - (this.obstacleImage.getWidth() + SceneGame.MAX_FLAG_OFFSET_X);
                        break;
                    }
                    case 2: {
                        this.obstacleX = SceneGame.STYLUS_TIP + (SceneGame.TRACK_WIDTH >> 1) - (this.obstacleImage.getWidth() >> 1);
                    }
                }
                switch (this.obstacleType) {
                    case 0: {
                        this.obstacleImage = obstacle1;
                        break;
                    }
                    case 1: {
                        this.obstacleImage = obstacle3;
                        break;
                    }
                    case 2: {
                        this.obstacleImage = obstacle4;
                    }
                }
            }
            if (this.isColliding(this.obstacleImage) && !AppEngine.this.getSceneGame().miniGameOverByAnyCondition()) {
                SceneGame.SKIER_BLINKING = true;
                --SceneGame.LIFE_COUNT;
            }
            graphics.drawImage(this.obstacleImage, this.obstacleX - SceneGame.CAMERA_PANNING_FACTOR, this.obstacleY, 20);
            this.obstacleY -= SceneGame.SKIER_SPEED;
        }

        public boolean isColliding(Image image) {
            return !SceneGame.SKIER_BLINKING && ski_sprite.collidesWith(this.obstacleImage, this.obstacleX - SceneGame.CAMERA_PANNING_FACTOR, this.obstacleY, true);
        }
    }

    class Crowd {
        int x = 0;
        int y = 0;
        int side = 0;
        int crowd = 0;
        int crowdDistanceFromTrack = 40;

        private Crowd(int n, int n2) {
            this.x = n - this.crowdDistanceFromTrack;
            this.y = n2;
        }

        public void drawCrowd(Graphics graphics) {
            if (this.y < -fence.getHeight()) {
                this.y = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.x = SceneGame.STYLUS_TIP - this.crowdDistanceFromTrack;
                Random random = new Random();
                random.setSeed(System.currentTimeMillis());
                this.side = random.nextInt(2);
                this.crowd = random.nextInt(3);
            }
            block0 : switch (this.side) {
                case 0: {
                    switch (this.crowd) {
                        case 0: {
                            graphics.drawImage(crowd1, this.x - SceneGame.CAMERA_PANNING_FACTOR, this.y, 24);
                            break;
                        }
                        case 1: {
                            graphics.drawImage(crowd2, this.x - SceneGame.CAMERA_PANNING_FACTOR, this.y, 24);
                            break;
                        }
                        case 2: {
                            graphics.drawImage(crowd3, this.x - SceneGame.CAMERA_PANNING_FACTOR, this.y, 24);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.crowd) {
                        case 0: {
                            graphics.drawImage(crowd1_1, this.x + SceneGame.TRACK_WIDTH + this.crowdDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.y, 20);
                            break block0;
                        }
                        case 1: {
                            graphics.drawImage(crowd2_2, this.x + SceneGame.TRACK_WIDTH + this.crowdDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.y, 20);
                            break block0;
                        }
                        case 2: {
                            graphics.drawImage(crowd3_3, this.x + SceneGame.TRACK_WIDTH + this.crowdDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.y, 20);
                        }
                    }
                }
            }
            this.y -= SceneGame.SKIER_SPEED;
        }
    }

    class FencePoint2 {
        int fencePoint_x = 0;
        int fencePoint_y = 0;
        boolean fence_side = false;
        int fencePointDistanceFromTrack = 20;

        private FencePoint2(int n, int n2, boolean bl) {
            this.fencePoint_x = n - this.fencePointDistanceFromTrack;
            this.fencePoint_y = n2;
            this.fence_side = bl;
        }

        public void drawFencePoint2(Graphics graphics) {
            if (this.fencePoint_y < -adboard_red.getHeight()) {
                this.fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.fencePoint_x = SceneGame.STYLUS_TIP - this.fencePointDistanceFromTrack;
            }
            if (!this.fence_side) {
                graphics.drawImage(fence2, this.fencePoint_x - SceneGame.CAMERA_PANNING_FACTOR, this.fencePoint_y, 20);
            } else {
                graphics.drawImage(fence2, this.fencePoint_x + SceneGame.TRACK_WIDTH + this.fencePointDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.fencePoint_y, 20);
            }
            this.fencePoint_y -= SceneGame.SKIER_SPEED;
        }
    }

    class FencePoint {
        int fencePoint_x = 0;
        int fencePoint_y = 0;
        boolean fence_side = false;
        int fencePointDistanceFromTrack = 20;

        private FencePoint(int n, int n2, boolean bl) {
            this.fencePoint_x = n - this.fencePointDistanceFromTrack;
            this.fencePoint_y = n2;
            this.fence_side = bl;
        }

        public void drawFencePoint(Graphics graphics) {
            if (this.fencePoint_y < -adboard_red.getHeight()) {
                this.fencePoint_y = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.fencePoint_x = SceneGame.STYLUS_TIP - this.fencePointDistanceFromTrack;
            }
            if (!this.fence_side) {
                graphics.drawImage(fence, this.fencePoint_x - SceneGame.CAMERA_PANNING_FACTOR, this.fencePoint_y, 20);
            } else {
                graphics.drawImage(fence, this.fencePoint_x + SceneGame.TRACK_WIDTH + this.fencePointDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.fencePoint_y, 20);
            }
            this.fencePoint_y -= SceneGame.SKIER_SPEED;
        }
    }

    class AddBoardsEA {
        int billBoard_x = 0;
        int billBoard_y = 0;
        int ad_color = 0;
        boolean adBoard_side = false;
        int billBoardDistanceFromTrack = 90;

        private AddBoardsEA(int n, int n2, int n3, boolean bl) {
            this.billBoard_x = n - this.billBoardDistanceFromTrack;
            this.billBoard_y = n2;
            this.ad_color = n3;
            this.adBoard_side = bl;
        }

        public void drawAddBoardsEA(Graphics graphics) {
            if (this.billBoard_y < -ad_EA.getHeight()) {
                this.billBoard_y = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.billBoard_x = SceneGame.STYLUS_TIP - this.billBoardDistanceFromTrack;
            }
            switch (this.ad_color) {
                case 0: {
                    if (!this.adBoard_side) {
                        graphics.drawImage(ad_EA, this.billBoard_x - SceneGame.CAMERA_PANNING_FACTOR, this.billBoard_y, 24);
                        break;
                    }
                    graphics.drawImage(ad_EA, this.billBoard_x + SceneGame.TRACK_WIDTH + this.billBoardDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.billBoard_y, 20);
                }
            }
            this.billBoard_y -= SceneGame.SKIER_SPEED;
        }
    }

    class AddBoards {
        int billBoard_x = 0;
        int billBoard_y = 0;
        int ad_color = 0;
        boolean adBoard_side = false;
        int billBoardDistanceFromTrack = 20;

        private AddBoards(int n, int n2, int n3, boolean bl) {
            this.billBoard_x = n - this.billBoardDistanceFromTrack;
            this.billBoard_y = n2;
            this.ad_color = n3;
            this.adBoard_side = bl;
        }

        public void drawAddBoards(Graphics graphics) {
            if (this.billBoard_y < -adboard_red.getHeight()) {
                this.billBoard_y = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.billBoard_x = SceneGame.STYLUS_TIP - this.billBoardDistanceFromTrack;
            }
            switch (this.ad_color) {
                case 0: {
                    if (!this.adBoard_side) {
                        graphics.drawImage(adboard_red, this.billBoard_x - SceneGame.CAMERA_PANNING_FACTOR, this.billBoard_y, 24);
                        break;
                    }
                    graphics.drawImage(adboard_red, this.billBoard_x + SceneGame.TRACK_WIDTH + this.billBoardDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.billBoard_y, 20);
                }
            }
            this.billBoard_y -= SceneGame.SKIER_SPEED;
        }
    }

    class DrawTree {
        int pointX = 0;
        int pointY = 0;
        int side = 0;
        int tree_pattarn = 0;
        int treeDistanceFromTrack = 60;

        private DrawTree(int n, int n2) {
            this.pointX = n - this.treeDistanceFromTrack;
            this.pointY = n2;
        }

        public void drawTree(Graphics graphics) {
            if (this.pointY < -tree.getHeight()) {
                this.pointY = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.pointX = SceneGame.STYLUS_TIP - this.treeDistanceFromTrack;
                Random random = new Random();
                random.setSeed(System.currentTimeMillis());
                this.side = random.nextInt(2);
                this.tree_pattarn = random.nextInt(3);
            }
            block0 : switch (this.side) {
                case 0: {
                    switch (this.tree_pattarn) {
                        case 0: {
                            graphics.drawImage(tree, this.pointX - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 24);
                            break;
                        }
                        case 1: {
                            graphics.drawImage(tree1, this.pointX - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 24);
                            break;
                        }
                        case 2: {
                            graphics.drawImage(tree2, this.pointX - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 24);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.tree_pattarn) {
                        case 0: {
                            graphics.drawImage(tree, this.pointX + SceneGame.TRACK_WIDTH + this.treeDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 20);
                            break block0;
                        }
                        case 1: {
                            graphics.drawImage(tree1, this.pointX + SceneGame.TRACK_WIDTH + this.treeDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 20);
                            break block0;
                        }
                        case 2: {
                            graphics.drawImage(tree2, this.pointX + SceneGame.TRACK_WIDTH + this.treeDistanceFromTrack * 2 - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 20);
                        }
                    }
                }
            }
            this.pointY -= SceneGame.SKIER_SPEED;
        }
    }

    static class DrawBorderPoints {
        int pointX = 0;
        int pointY = 0;

        public DrawBorderPoints(int n, int n2) {
            this.pointX = n;
            this.pointY = n2;
        }

        public void drawBorderPoints(Graphics graphics) {
            if (this.pointY < 0) {
                this.pointY = SceneGame.MINI_GAME_SCREEN_HEIGHT;
                this.pointX = SceneGame.STYLUS_TIP;
            }
            graphics.drawImage(ball, this.pointX - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 24);
            graphics.drawImage(ball, this.pointX + SceneGame.TRACK_WIDTH - SceneGame.CAMERA_PANNING_FACTOR, this.pointY, 20);
            if (this.isColliding()) {
                SceneGame.COLLISION_WITH_BORDER = true;
            }
            this.pointY -= SceneGame.SKIER_SPEED;
        }

        public boolean isColliding() {
            if (SceneGame.SKIER_X < this.pointX - SceneGame.CAMERA_PANNING_FACTOR && SceneGame.SKIER_X > this.pointX - SceneGame.CAMERA_PANNING_FACTOR - ball.getWidth() - 10 && SceneGame.SKIER_Y > this.pointY - 3 && SceneGame.SKIER_Y < this.pointY + ball.getHeight() + 3) {
                return true;
            }
            return SceneGame.SKIER_X > this.pointX + SceneGame.TRACK_WIDTH - SceneGame.CAMERA_PANNING_FACTOR && SceneGame.SKIER_X < this.pointX + SceneGame.TRACK_WIDTH + ball.getWidth() - SceneGame.CAMERA_PANNING_FACTOR + 10 && SceneGame.SKIER_Y > this.pointY - 3 && SceneGame.SKIER_Y < this.pointY + ball.getHeight() + 3;
        }
    }

    class SnowParticle {
        int snowX = 0;
        int snowY = 0;
        byte snowSize = (byte)2;
        private int counter = 0;

        private SnowParticle(int n, int n2) {
            this.snowX = n;
            this.snowY = n2;
        }

        private int getRandom(int n) {
            return AppEngine.this.m_randomObject.nextInt(n);
        }

        public void drawSnow(Graphics graphics) {
            ++this.snowY;
            if (this.snowY + AppEngine.this.m_simWorld.getCameraPixelY() > AppEngine.this.getHeight()) {
                this.snowY = -this.getRandom(AppEngine.this.getHalfHeight());
            }
            graphics.fillRect(this.snowX + AppEngine.this.m_simWorld.getCameraPixelX(), this.snowY + AppEngine.this.m_simWorld.getCameraPixelY(), (int)this.snowSize, (int)this.snowSize);
        }
    }
}

