/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games.questions;

import com.c2m.screens.games.questions.QuestionListener;
import com.c2m.screens.games.questions.TextQuestion;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;

public class VisualMathQuestion
extends TextQuestion {
    private static final int[][] POS = new int[C.VISUAL_MATH_GRID[0] * C.VISUAL_MATH_GRID[1]][2];
    private static final int[] ITEMS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final int[] questionItems;
    private final String[] questionStrings;
    private final int[] questionStringsWidth;
    private final int questionWidth;
    private final int[] groupItems;
    private final int availableItems;

    protected VisualMathQuestion(int type, QuestionListener questionListener, int level, int randNum) {
        super(type, questionListener, level, randNum);
        U.suffle((Object[])POS);
        U.suffle(ITEMS);
        this.availableItems = 4 + level / 2;
        this.groupItems = new int[5 + level];
        for (int i = 0; i < this.groupItems.length; ++i) {
            this.groupItems[i] = ITEMS[U.rand(this.availableItems)];
        }
        this.questionItems = new int[2 + level / 5];
        System.arraycopy(ITEMS, 0, this.questionItems, 0, this.questionItems.length);
        this.questionStrings = new String[this.questionItems.length];
        this.questionStrings[this.questionStrings.length - 1] = " = ?";
        int[] sign = new int[]{1, level < 4 ? 1 : U.rand(2) * 2 - 1, level < 8 ? 1 : U.rand(2) * 2 - 1};
        for (int i = 1; i < this.questionStrings.length; ++i) {
            this.questionStrings[i - 1] = sign[i] < 0 ? " - " : " + ";
        }
        this.questionStringsWidth = new int[this.questionStrings.length];
        int w = 0;
        for (int i = 0; i < this.questionItems.length; ++i) {
            w += C.VISUAL_MATH_FRAMES[this.questionItems[i]][2];
            this.questionStringsWidth[i] = R.BLUE_FONT.f.getStringWidth(this.questionStrings[i]);
            w += this.questionStringsWidth[i];
        }
        this.questionWidth = w;
        int c = 0;
        for (int i = 0; i < this.groupItems.length; ++i) {
            for (int j = 0; j < this.questionItems.length; ++j) {
                if (this.groupItems[i] != this.questionItems[j]) continue;
                c += sign[j];
            }
        }
        this.correctAnswer = U.rand(4);
        this.answers[this.correctAnswer] = "" + c;
        this.answersWidths[this.correctAnswer] = R.BLUE_FONT.f.getStringWidth(this.answers[this.correctAnswer]);
        int a = c - U.rand(4);
        for (int i = 0; i < 4; ++i) {
            if (this.answers[i] != null) continue;
            if (a == c) {
                ++a;
            }
            this.answers[i] = "" + a;
            this.answersWidths[i] = R.BLUE_FONT.f.getStringWidth(this.answers[i]);
            ++a;
        }
    }

    protected void drawQuestion(Graphics g) {
        for (int i = 0; i < this.groupItems.length; ++i) {
            int[] f = C.VISUAL_MATH_FRAMES[this.groupItems[i]];
            g.drawRegion(R.VISUAL_MATH.i, f[0], f[1], f[2], f[3], 0, POS[i][0], POS[i][1], 3);
        }
        int x = (C.WIDTH - this.questionWidth) / 2;
        for (int i = 0; i < this.questionItems.length; ++i) {
            int[] f = C.VISUAL_MATH_FRAMES[this.questionItems[i]];
            g.drawRegion(R.VISUAL_MATH.i, f[0], f[1], f[2], f[3], 0, x, C.VISUAL_MATH_QUESTION_TITLE_Y + R.BLUE_FONT.f.getHeight() / 2, 6);
            R.BLUE_FONT.f.drawString(g, this.questionStrings[i], x += f[2], C.VISUAL_MATH_QUESTION_TITLE_Y, 0);
            x += this.questionStringsWidth[i];
        }
    }

    static {
        for (int i = 0; i < POS.length; ++i) {
            VisualMathQuestion.POS[i][0] = C.VISUAL_MATH_QUESTION_FRAME[0] + i % C.VISUAL_MATH_GRID[0] * C.VISUAL_MATH_QUESTION_FRAME[2] / (C.VISUAL_MATH_GRID[0] - 1);
            VisualMathQuestion.POS[i][1] = C.VISUAL_MATH_GRID[1] == 1 ? C.VISUAL_MATH_QUESTION_FRAME[1] : C.VISUAL_MATH_QUESTION_FRAME[1] + i / C.VISUAL_MATH_GRID[0] * C.VISUAL_MATH_QUESTION_FRAME[3] / (C.VISUAL_MATH_GRID[1] - 1);
        }
    }
}

