/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public class YesNoDialogBox
extends MainScreen {
    private Vector textLines = new Vector();
    private int backgroundColor;
    private String captionText;
    private CGTexture image;
    private CGTexture[] animation;
    private int currentFrame = 0;

    public YesNoDialogBox(String caption, String main, int color, String imgName, int numFrames, long speed) {
        this.width = ApplicationData.screenWidth;
        this.height = ApplicationData.screenHeight;
        this.init(caption, main, color);
        this.animation = new CGTexture[numFrames];
        try {
            for (int i = 0; i < numFrames; ++i) {
                this.animation[i] = TextureManager.AddTexture(imgName + i + ".png");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bIsOK = true;
        for (int i = 0; i < numFrames; ++i) {
            if (this.animation[i] != null) continue;
            bIsOK = false;
            break;
        }
        if (!bIsOK) {
            this.animation = new CGTexture[1];
            this.animation[0] = TextureManager.AddTexture(imgName + 0 + ".png");
        }
        if (this.animation[0] == null) {
            // empty if block
        }
    }

    public YesNoDialogBox(String caption, String main, int color, String imgName) {
        this.width = ApplicationData.screenWidth;
        this.height = ApplicationData.screenHeight;
        this.init(caption, main, color);
        try {
            this.image = TextureManager.AddTexture(imgName);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void init(String caption, String main, int color) {
        this.backgroundColor = color;
        this.captionText = caption;
        this.textLines = Utils.splitText(main, "+", this.width, 0);
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbCANCEL, ObjectsCache.menuSbCANCEL_a);
    }

    public YesNoDialogBox(String caption, String main, int color) {
        this.width = ApplicationData.screenWidth;
        this.height = ApplicationData.screenHeight;
        this.init(caption, main, color);
    }

    public void updateSize() {
    }

    public void drawWindowBackground() {
        this.drawBottom = false;
        int backgroundTileWidth = ObjectsCache.menuBackground.GetWidth();
        int backgroundTileHeight = ObjectsCache.menuBackground.GetHeight();
        int numTilesX = ApplicationData.screenWidth / backgroundTileWidth;
        int numTilesY = ApplicationData.screenHeight / backgroundTileHeight;
        for (int x = 0; x <= numTilesX; ++x) {
            for (int y = 0; y <= numTilesY; ++y) {
                Graphic2D.DrawImage(ObjectsCache.menuBackground, x * backgroundTileWidth, y * backgroundTileHeight, 20);
            }
        }
        if (this.drawTop) {
            // empty if block
        }
        if (this.drawBottom) {
            // empty if block
        }
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        if (this.animation != null) {
            this.image = this.animation[this.currentFrame];
        }
        int fontHeight = ApplicationData.defaultFont.getFontHeight();
        int yCenterAlign = (this.height - fontHeight * this.textLines.size() - (this.image != null ? this.image.GetHeight() : 0)) / 2;
        int yPosition = 0;
        for (int i = 0; i < this.textLines.size(); ++i) {
            yPosition = 0 + i * fontHeight + 0 + yCenterAlign;
            Utils.drawString((String)this.textLines.elementAt(i), this.width >> 1, yPosition, 17, 0);
        }
        if (this.image != null) {
            Graphic2D.DrawImage(this.image, this.width >> 1, yPosition += fontHeight, 17);
        }
    }
}

