/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gui.MainHintTextBox;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class HintScreen
extends MainScreen {
    public static int ID_HINT_HOTSEAT = 0;
    public static int ID_HINT_ENTER_CHAMPIONSHIPS = 1;
    public static int ID_HINT_ENTER_CAREER_SCREEN = 2;
    public static int ID_HINT_ENTER_GARAGE = 3;
    public static int ID_HINT_MULTIPLAYER = 4;
    public static int ID_HINT_ENTER_QUICK_RACE = 5;
    public static int ID_HINT_ENTER_TIME_ATTACK = 6;
    public static int ID_HINT_LOCAL_RESULTS = 7;
    public static int ID_HINT_WORLD_RESULTS = 8;
    public static int ID_HINT_ENTER_SYNCHRONIZATION = 9;
    public static int ID_HINT_END_OF_CHAMPIONSHIPS = 10;
    public static int ID_GAME_OVER = 11;
    public static int ID_HINT_START_LEAGUE1 = 12;
    public static int ID_HINT_START_LEAGUE2 = 13;
    public static int ID_HINT_START_LEAGUE3 = 14;
    public static int ID_HINT_PROMOTED_TO_ADV_LEAGUE = 15;
    public static int ID_HINT_PROMOTED_TO_MAS_LEAGUE = 16;
    public static int ID_HINT_FAILED_TO_PROMOTE = 17;
    public static int ID_HINT_PROMOTED_TO_ADV_LEAGUEB = 18;
    public static int ID_HINT_PROMOTED_TO_MAS_LEAGUEB = 19;
    public static int ID_HINT_FAILED_CHAMPIONSHIPS = 20;
    public static int ID_HINT_GOLD_IN_CHAMPIONSHIPS = 21;
    public static int ID_HINT_NOT_IN_DEMO = 22;
    public static int ID_HINT_QUALIFICATIONS = 23;
    private static final int MAX_NUM_HINTS = 24;
    private static boolean[] hintsShown = new boolean[24];
    private static String[] hintsTexts = new String[]{"ID_HINT_HOTSEAT", "ID_HINT_ENTER_CHAMPIONSHIPS", "ID_HINT_ENTER_CAREER_SCREEN", "ID_HINT_ENTER_GARAGE", "ID_HINT_MULTIPLAYER", "ID_HINT_ENTER_QUICK_RACE", "ID_HINT_ENTER_TIME_ATTACK", "ID_HINT_LOCAL_RESULTS", "ID_HINT_WORLD_RESULTS", "ID_HINT_ENTER_SYNCHRONIZATION", "ID_HINT_END_OF_CHAMPIONSHIPS", "ID_GAME_OVER", "ID_HINT_START_LEAGUE1", "ID_HINT_START_LEAGUE2", "ID_HINT_START_LEAGUE3", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE1", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE2", "ID_HINT_FAILED_TO_PROMOTE", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE1B", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE2B", "ID_HINT_FAILED_CHAMPIONSHIPS", "ID_HINT_GOLD_IN_CHAMPIONSHIPS", "ID_HINT_NOT_IN_DEMO", "ID_HINT_QUALIFICATIONS"};
    private static boolean[] hintsSwitchable = new boolean[]{true, true, true, true, true, true, true, true, true, true, false, false, true, true, true, false, false, false, false, false, false, false, false, true};
    int hintID;
    int hintFontID = 2;
    Vector askText;
    Vector mainText;
    private boolean scrollable = false;
    private final float SCROLL_SPEED;
    private float scrollOffset = 0.0f;
    private int textHeight;
    private int askAreaHeight = 0;
    private int mainTextArea;

    public static void showHintedScreen(UIScreen comeBackScreen, int hintID) {
        MainHintTextBox tb = new MainHintTextBox(true, 0, false, comeBackScreen);
        tb.SetHintID(hintID);
        tb.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        tb.autoSize();
        tb.setText(ApplicationData.lp.getTranslatedString(Options.languageID, hintsTexts[hintID]));
        UIScreen.SetCurrentScreen(tb);
    }

    private HintScreen(UIScreen _comeBackScreen, int _hintID) {
        this.SCROLL_SPEED = 30.0f;
        this.parentScreen = _comeBackScreen;
        this.hintID = _hintID;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, hintsSwitchable[this.hintID] ? ObjectsCache.menuSbCANCEL : null, hintsSwitchable[this.hintID] ? ObjectsCache.menuSbCANCEL_a : null);
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_HINT_HEADER"));
        this.askText = hintsSwitchable[this.hintID] ? Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_HINT_REPEAT"), "+", ApplicationData.screenWidth, this.hintFontID) : null;
        if (this.askText != null) {
            int offset = ApplicationData.getFontByID(2).getFontHeight() >> 1;
            this.askAreaHeight = offset * 2 * this.askText.size() + offset * 2;
            this.YScrollOffset = -this.askAreaHeight / 2;
        }
        this.autoSize();
        this.mainText = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, hintsTexts[this.hintID]), "+", ApplicationData.screenWidth, this.hintFontID);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.getFontByID(this.hintFontID).getFontHeight();
        this.checkIfScrollsAreNeeded();
        this.mainText = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, hintsTexts[this.hintID]), "+", ApplicationData.screenWidth, this.hintFontID);
        this.textHeight = (this.mainText.size() + 1) * ApplicationData.getFontByID(this.hintFontID).getFontHeight() - ApplicationData.getFontByID(this.hintFontID).getFontSpacing();
    }

    public void draw() {
    }

    private boolean checkIfScrollsAreNeeded() {
        this.showScrollbars = this.scrollable = this.textHeight > this.mainTextArea;
        return this.scrollable;
    }

    private void drawMainText(int bottomY) {
    }

    private void showOriginalScreen() {
        UIScreen.SetCurrentScreen(this.parentScreen);
    }

    public boolean rightSoftButton() {
        return false;
    }

    public boolean leftSoftButton() {
        this.showOriginalScreen();
        return true;
    }

    public static void serialize(DataOutputStream dos) throws IOException {
        for (int i = 0; i < 24; ++i) {
            dos.writeBoolean(hintsShown[i]);
        }
    }

    public static void deSerialize(DataInputStream inputStream) throws IOException {
        for (int i = 0; i < 24; ++i) {
            HintScreen.hintsShown[i] = inputStream.readBoolean();
        }
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
        if (this.scrollable) {
            int fontHeight;
            int maxScrollValue;
            if (ApplicationData.isUpPressed() && this.scrollOffset < 0.0f) {
                this.scrollOffset += deltaTime * 30.0f;
            }
            if (ApplicationData.isDownPressed() && this.scrollOffset > (float)(maxScrollValue = -(fontHeight = ApplicationData.getFontByID(this.hintFontID).getFontHeight()) * (this.mainText.size() + 1 - this.mainTextArea / fontHeight))) {
                this.scrollOffset -= deltaTime * 30.0f;
            }
        }
    }
}

