/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CarSelectionScreen;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.HintScreen;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectWorld;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;
import java.util.Random;
import java.util.Vector;

public class SelectTrack
extends MainUSRScreen {
    private static final int DEFAULT_NUMBER_OF_HS_PLAYERS = 2;
    public static int numHSplayers = 2;
    public static final int NUMBER_OF_LAPS_IN_CHAMPIONSHIPS = 3;
    public static final int NUM_TRACKS = 9;
    public int selectedTrack = 0;
    protected CGTexture[] countryImages = null;
    private CGTexture trackBackground = null;
    public static String[] cities = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "Spain", "Japan"};
    public String selectedLoc;
    public static int NUM_MENU_ELEMENTS = 3;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int currentMenuElement = 0;
    boolean selectTrack2 = false;
    private CGTexture cityTexture;
    private CGTexture cityName;
    private CGTexture cityBg;
    private CGTexture locked;
    private String eventID;
    private Vector length = new Vector();
    private Vector longest = new Vector();
    String lapButtonCaption = null;
    protected TrackStats trackStats = new TrackStats();
    private int anotherVar = 0;
    private UIButton lap1button;
    private UIButton lap3button;
    private UIButton lap5button;
    private final int LAP1_BUT_ID;
    private final int LAP3_BUT_ID;
    private final int LAP5_BUT_ID;

    public void autoSize() {
    }

    public SelectTrack() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.LAP1_BUT_ID = 501;
        this.LAP3_BUT_ID = 502;
        this.LAP5_BUT_ID = 503;
        if (Platform.IS_DEBUG_MODE) {
            for (int i = 0; i < CGUserCareer.tracksUnlocked.length; ++i) {
                CGUserCareer.tracksUnlocked[i] = true;
            }
        }
        this.init(0);
    }

    public SelectTrack(int n, Vector vector, Vector vector2, String string) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.LAP1_BUT_ID = 501;
        this.LAP3_BUT_ID = 502;
        this.LAP5_BUT_ID = 503;
        this.length = vector;
        this.longest = vector2;
        this.lapButtonCaption = string;
        this.selectTrack2 = true;
        this.init(n);
    }

    public SelectTrack(int n) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.LAP1_BUT_ID = 501;
        this.LAP3_BUT_ID = 502;
        this.LAP5_BUT_ID = 503;
        this.selectTrack2 = true;
        this.init(n);
    }

    public void init(int n) {
        this.cityBg = TextureManager.AddTexture("/car_bg.png");
        this.trackBackground = TextureManager.CreateTexture("/car_bg.png");
        this.drawLogo = true;
        this.selectedTrack = n;
        this.currentMenuElement = n;
        this.selectedTrack = n;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SELECT_CAR")));
        this.locked = TextureManager.AddTexture("/car_locked.png");
        int n2 = this.cityBg.GetHeight() / 2 + ObjectsCache.menuTitle.GetHeight() + ObjectsCache.scrollRightImg.GetHeight() / 2;
        int n3 = 0;
        int n4 = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        this.updateScreenInfo();
        this.strip2Y = (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + ApplicationData.screenHeight / 2 + this.cityTexture.GetHeight() / 2) / 2;
        this.strip1Y = (ApplicationData.screenHeight / 2 - this.cityTexture.GetHeight() / 2) / 2;
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n4 - ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4 - ObjectsCache.scrollRightImg.GetHeight() / 2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n3 + ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4 - ObjectsCache.scrollRightImg.GetHeight() / 2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
    }

    public void draw() {
        if (CGUserCareer.tracksUnlocked[this.anotherVar]) {
            Graphic2D.DrawImage(this.cityBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4, 3);
            Graphic2D.DrawImage(this.cityTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4, 3);
        } else {
            Graphic2D.DrawImage(this.cityBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4, 3);
            Graphic2D.DrawImage(this.locked, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4, 3);
        }
        this.drawStats(ApplicationData.screenHeight / 2 + this.cityBg.GetHeight() * 3 / 4);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(cities[this.anotherVar]), ApplicationData.screenWidth / 2, ObjectsCache.menuTitle.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 3 / 2, 17, 0);
    }

    public boolean rightSoftButton() {
        if (CGEngine.selectedGameMode == 1) {
            UIScreen.SetCurrentScreen(new CarSelectionScreen(this));
        } else if (CGEngine.selectedGameMode == 2) {
            UIScreen.SetCurrentScreen(new EditChampionshipsUserName());
        } else if (CGEngine.selectedGameMode == 3) {
            HintScreen.showHintedScreen(new CarSelectionScreen(this), new MainMenu(), HintScreen.ID_HINT_ENTER_TIME_ATTACK, "GAME_TYPE_TIMEATTACK");
        }
        return true;
    }

    public boolean leftSoftButton() {
        if (CGUserCareer.tracksUnlocked[this.anotherVar]) {
            this.selectedTrack = this.currentMenuElement;
            CGEngine.selectedTrack = this.anotherVar;
            UIScreen.SetCurrentScreen(new LoadingLevelScreen());
        }
        return true;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        int n = 3;
        ++this.selectedTrack;
        if (this.selectedTrack >= n) {
            this.selectedTrack = 0;
        }
        ++this.currentMenuElement;
        if (this.currentMenuElement >= NUM_MENU_ELEMENTS) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        int n = 3;
        --this.selectedTrack;
        if (this.selectedTrack < 0) {
            this.selectedTrack = n - 1;
        }
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = NUM_MENU_ELEMENTS - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    private void updateScreenInfo() {
        this.anotherVar = SelectWorld.selectedWorld * 3 + this.currentMenuElement;
        System.out.println("updateScreenInfo():" + this.anotherVar);
        this.cityTexture = TextureManager.AddTexture("/city_" + (this.anotherVar + 1) + "_ico.png");
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    private void drawDots(int n, int n2, int n3, int n4) {
        if (n > 0) {
            int n5 = ApplicationData.screenWidth / 2 - this.cityBg.GetWidth() / 2 + ObjectsCache.menuRedDot.GetWidth();
            for (int i = 0; i < n; ++i) {
                int n6 = n5 + i * ObjectsCache.menuRedDot.GetWidth() * 5 / 2;
                Graphic2D.DrawImage(i == n2 ? ObjectsCache.menuWhiteDot : ObjectsCache.menuRedDot, n6, n4, 17);
            }
        }
    }

    protected void initializeTouchButtons() {
        int n = ApplicationData.screenWidth / 2 - ObjectsCache.touchButton[0].GetWidth() / 2;
        int n2 = ObjectsCache.touchButton[0].GetWidth() / 10;
        int n3 = ApplicationData.screenHeight * 3 / 4;
        this.lap1button = new UIButton(n, n3, ObjectsCache.touchButton[1], ObjectsCache.touchButton[0], ObjectsCache.touchButton[0], 501);
        if (this.selectTrack2) {
            this.lap1button.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, this.lapButtonCaption));
        } else {
            this.lap1button.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_LAP1"));
        }
        this.lap1button.setScreen(this);
        this.addButton(this.lap1button);
    }

    protected void drawStats(int n) {
        int n2 = ApplicationData.defaultFont.getFontSpacing() * 2 + ApplicationData.defaultFont.getFontHeight();
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TRACK_LENGTH"), ApplicationData.screenWidth / 12, n, 20, 0);
        this.length = this.trackStats.getLenghtVector();
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(this.trackStats.getLength(this.selectedTrack).toString() + "m"), ApplicationData.screenWidth * 70 / 100, n, 20, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TRACK_BESTTIME"), ApplicationData.screenWidth / 12, n += n2, 20, 0);
        int n3 = CGUserCareer.tracksTime[SelectWorld.selectedWorld * 3 + this.selectedTrack];
        if (n3 == Integer.MAX_VALUE) {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("--:--:--"), ApplicationData.screenWidth * 70 / 100, n, 20, 0);
        } else {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(n3)), ApplicationData.screenWidth, n, 24, 0);
        }
    }

    protected class TrackStats {
        private Vector length = new Vector();
        private Vector longest = new Vector();

        public TrackStats() {
            Random random = new Random();
            for (int i = 0; i < 9; ++i) {
                this.length.addElement(new Integer(CGEngine.trackLength[i] / 40960));
                this.longest.addElement(new Integer(Math.abs(random.nextInt() % 2000 + 1000)));
            }
        }

        public Object getLength(int n) {
            return this.length.elementAt(n);
        }

        public Object getLongest(int n) {
            return this.longest.elementAt(n);
        }

        public Vector getLenghtVector() {
            return this.length;
        }

        public Vector getLongestVector() {
            return this.longest;
        }
    }
}

