/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectTrophy;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class GatheredAchievements
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedAchiev = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private String csText2;
    private String csText3;
    private String csText4;
    private CGTexture[] achievImages = null;

    protected void Clean() {
        for (int i = 0; i < 2; ++i) {
            TextureManager.DeleteTexture(this.achievImages[i]);
            this.achievImages[i] = null;
        }
        this.achievImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.achievImages == null) {
            this.achievImages = new CGTexture[2];
            this.achievImages[0] = TextureManager.CreateTexture("/achi_yes.png");
            this.achievImages[1] = TextureManager.CreateTexture("/achi_no.png");
        }
    }

    public GatheredAchievements() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedAchiev = 0;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_ACHIEVEMENTS_HEADER"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setDrawTitle(false);
        this.achievImages = new CGTexture[2];
        this.achievImages[0] = TextureManager.CreateTexture("/achi_yes.png");
        this.achievImages[1] = TextureManager.CreateTexture("/achi_no.png");
        int n = ApplicationData.screenHeight / 2 - 160 - ObjectsCache.scrollLeftImg.GetHeight() / 2;
        n = ApplicationData.screenHeight / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2;
        int n2 = 0;
        int n3 = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetHeight();
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n3 - ObjectsCache.menuWhiteDot.GetHeight(), n, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n2 + ObjectsCache.menuWhiteDot.GetHeight(), n, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
        this.nStartBoxY = ApplicationData.screenHeight / 2 + 160 - ObjectsCache.menuSbOK.GetHeight();
        if (this.nStartBoxY < ApplicationData.screenHeight / 2) {
            this.nStartBoxY = ApplicationData.screenHeight / 2;
        }
        this.nStopBoxY = this.nStartBoxY + 3 * ApplicationData.getFontByID(0).getFontHeight();
        this.nBoxWidth = ApplicationData.screenWidth - 4;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, ApplicationData.screenHeight / 2 + ApplicationData.defaultFont.getFontHeight() * 3, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedAchiev + 1) + " / " + 6);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_ACH_SHORT_" + selectedAchiev);
        this.csText3 = selectedAchiev < 3 ? "" : ApplicationData.lp.getTranslatedString(Options.languageID, "ID_ACH_QR");
        this.csText4 = ApplicationData.achievements.isAchievementCompleted(selectedAchiev) ? ApplicationData.lp.getTranslatedString(Options.languageID, "ID_UNLOCKED") : ApplicationData.lp.getTranslatedString(Options.languageID, "ID_LOCKED");
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_ACH_LONG_" + selectedAchiev));
    }

    public void autoSize() {
    }

    public void draw() {
        int n;
        int n2 = ApplicationData.screenHeight / 2 - 160;
        for (n = 0; n < ApplicationData.screenWidth; n += ObjectsCache.greyBar[0].GetWidth()) {
            Graphic2D.DrawImage(ObjectsCache.greyBar[0], n, n2, 20);
            Graphic2D.DrawImage(ObjectsCache.greyBar[1], n, n2, 36);
        }
        n = ApplicationData.screenWidth / 2;
        int n3 = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight() / 2;
        boolean bl = ApplicationData.achievements.isAchievementCompleted(selectedAchiev);
        if (bl) {
            Graphic2D.DrawImage(this.achievImages[0], n, n3, 3);
        } else {
            Graphic2D.DrawImage(this.achievImages[1], n, n3, 3);
        }
        n2 = n3 + ApplicationData.getFontByID(0).getFontHeight() * 3;
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, n2, 17, 0);
        Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, n2 += ApplicationData.getFontByID(0).getFontHeight(), 17, 0);
        n2 += ApplicationData.getFontByID(0).getFontHeight() * 2;
        this.infoBox.draw();
        Utils.drawString(this.csText4, ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight(), 33, 0);
    }

    public boolean rightSoftButton() {
        this.Clean();
        UIScreen.SetCurrentScreen(new SelectTrophy());
        return true;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedAchiev >= 6) {
            selectedAchiev = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedAchiev < 0) {
            selectedAchiev = 5;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

