/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGBolid;
import baltorogames.project_gameplay.CGBolidRecord;
import baltorogames.project_gameplay.CGCamera;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGRainSystem;
import baltorogames.project_gameplay.CGTrack;
import baltorogames.project_gameplay.CGTrackNode;
import baltorogames.project_gameplay.FXUtility;
import baltorogames.project_gameplay.MissionParams;
import baltorogames.project_gameplay.RoadRenderer;
import baltorogames.project_gameplay.Vector2FX;
import baltorogames.project_gameplay.Vector3FX;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.system.Options;
import baltorogames.system.Platform;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Image;

public class CarEngine2D {
    public static final int SHIFT = 12;
    public static final int MAX_TO_BAND_DISTANCE = 5;
    public static final int[] backgroundColor1 = new int[]{9212504, 5864065, 7692378, 11247148, 8484438, 5728384, 0x5A8555, 6717313, 9861474};
    public static final int[] backgroundColor2 = new int[]{5409920, 6049131, 5198914, 2196017, 4411959, 5455194, 3625800, 4275537, 4808760};
    static boolean m_bDrawBackground = true;
    static boolean m_bDrawHorizontsAndClouds = true;
    static boolean m_bDrawRoad = true;
    static boolean m_bDrawObjects = true;
    static boolean m_bDrawCars = true;
    static boolean m_bDrawWeather = true;
    public int m_nCurrentLevelIndex = -1;
    public int m_nTranslateScreenY = 0;
    long m_fxCameraDistanceFromStart = 12288L;
    long m_fxCameraStraight = 0L;
    int m_nMaxObjectsDistance = 900;
    CGCamera m_Camera = null;
    CGTrack m_Track = null;
    MissionParams m_Mission = null;
    public RoadRenderer m_RoadRenderer = null;
    CGRainSystem m_RainSystem = null;
    CGTexture m_BackGroundTexture = null;
    CGTexture m_HorizTexture = null;
    CGTexture m_Horiz2Texture = null;
    CGTexture m_RoadTexture = null;
    CGTexture m_CloudTexture = TextureManager.AddTexture("/gameplay/clouds.png");
    int m_nNrOfBolids;
    CGBolid[] m_Bolid;
    public long m_fxDeltaTime;
    public long m_fxCurrentTime;
    CGBolidRecord m_BestBolidRecord = null;
    CGBolidRecord m_BolidRecord = null;
    public long m_fxCameraAngle;
    int m_nGameState;
    public static int m_nPlayerGender = 0;
    public static final int ENGINE2D_STATE_PREPARE = 0;
    public static final int ENGINE2D_STATE_DRIVE = 1;
    public static final int ENGINE2D_STATE_ON_FINISH = 2;
    public static final int ENVIRONMENT_SAFARI = 1;
    public static final int ENVIRONMENT_WINTER = 2;
    public static final int ENVIRONMENT_HALOWEEN = 3;
    public static final int[] levelWeather = new int[]{1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0};
    public static final int[] levelEnvironment = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 4, 4, 5, 5, 5};
    public CGTexture[] m_TexturesSmoke = null;
    public int m_nNrOfPlayers = 0;
    public int m_nCurrentPlayer = 0;
    public int[] m_FinishTimes = new int[12];
    public int[] m_SortIndexFinishTimes = null;
    int roadLineParamsSize = 0;
    RoadLineParam[] roadLineParams = new RoadLineParam[320];
    protected CGTexture[] roadTex = new CGTexture[9];
    Vector2FX g_vecDir;
    Vector3FX g_vecPos3D;
    Vector2FX v;
    Random rnd;
    public static final int MAX_NUM_BOLIDS = 6;
    CGBillboardObject[] arrObj;
    int[] arrObjIndexes;
    CGBolid[] bol;
    Vector2FX vecPos;
    Vector2FX vecCameraDir;
    int[] arrPixels;

    public void SetGameState(int n) {
        this.m_nGameState = n;
    }

    public int GetGameState() {
        return this.m_nGameState;
    }

    public CGBolid GetHumanBolid() {
        return this.m_Bolid[0];
    }

    CGTrack GetTrack() {
        return this.m_Track;
    }

    public CGBolid GetBolid(int n) {
        return this.m_Bolid[n];
    }

    CarEngine2D() {
        this.roadTex[0] = TextureManager.AddTexture("/gameplay/Road1.png", 0, 0, null, null);
        this.roadTex[1] = TextureManager.AddTexture("/gameplay/Road2.png", 0, 0, null, null);
        this.roadTex[2] = TextureManager.AddTexture("/gameplay/Road3.png", 0, 0, null, null);
        this.roadTex[3] = TextureManager.AddTexture("/gameplay/Road4.png", 0, 0, null, null);
        this.roadTex[4] = TextureManager.AddTexture("/gameplay/Road5.png", 0, 0, null, null);
        this.roadTex[5] = TextureManager.AddTexture("/gameplay/Road6.png", 0, 0, null, null);
        this.roadTex[6] = TextureManager.AddTexture("/gameplay/Road7.png", 0, 0, null, null);
        this.roadTex[7] = TextureManager.AddTexture("/gameplay/Road8.png", 0, 0, null, null);
        this.roadTex[8] = TextureManager.AddTexture("/gameplay/Road9.png", 0, 0, null, null);
        this.g_vecDir = new Vector2FX();
        this.g_vecPos3D = new Vector3FX();
        this.v = new Vector2FX();
        this.rnd = new Random();
        this.arrObj = new CGBillboardObject[6];
        this.arrObjIndexes = new int[6];
        this.bol = new CGBolid[6];
        this.vecPos = new Vector2FX();
        this.vecCameraDir = new Vector2FX();
        this.arrPixels = new int[4];
        this.m_RainSystem = new CGRainSystem();
        this.m_RainSystem.Init(180, 90);
    }

    public void PrepareFinishTimes(int n, int n2) {
        int n3 = 1;
        while (n3 < 12) {
            long l = 4096 * n3 / 12;
            long l2 = (long)RandSync.nextInt(250) - 500L;
            long l3 = (long)RandSync.nextInt(250) - 500L;
            this.m_FinishTimes[n3] = (int)((long)n * l + (long)n2 * (4096L - l) + l2);
            int n4 = n3;
            this.m_FinishTimes[n4] = this.m_FinishTimes[n4] / 4096;
            this.m_FinishTimes[n3] = (int)((long)n * l + (long)n2 * (4096L - l) + l3);
            int n5 = n3++;
            this.m_FinishTimes[n5] = this.m_FinishTimes[n5] / 4096;
        }
    }

    public int GetRankingPos() {
        int n = 0;
        int n2 = this.m_nNrOfPlayers;
        if (n2 == 1) {
            n2 = 12;
        } else {
            n2 = this.m_nCurrentPlayer + 1;
            n = this.m_nCurrentPlayer;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.m_FinishTimes[i];
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[0];
            int n4 = 0;
            for (int j = 1; j < n2; ++j) {
                if (nArray[j] >= n3) continue;
                n3 = nArray[j];
                n4 = j;
            }
            nArray2[i] = n4;
            if (n4 == n) {
                return i;
            }
            nArray[n4] = 1000000;
        }
        return -1;
    }

    public int GetSummaryRankingPos() {
        int n = 0;
        int n2 = this.m_nNrOfPlayers;
        if (n2 == 1) {
            n2 = 12;
        } else {
            n2 = this.m_nCurrentPlayer + 1;
            n = this.m_nCurrentPlayer;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.m_FinishTimes[i];
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[0];
            int n4 = 0;
            for (int j = 1; j < n2; ++j) {
                if (nArray[j] >= n3) continue;
                n3 = nArray[j];
                n4 = j;
            }
            nArray2[i] = n4;
            if (n4 == n) {
                return i;
            }
            nArray[n4] = 1000000;
        }
        return -1;
    }

    public void Sort() {
        int n;
        int n2 = 0;
        int n3 = this.m_nNrOfPlayers;
        if (n3 == 1) {
            n3 = 12;
        } else {
            n3 = this.m_nNrOfPlayers;
            n2 = -1;
        }
        int[] nArray = new int[12];
        for (n = 0; n < n3; ++n) {
            nArray[n] = this.m_FinishTimes[n];
        }
        this.m_SortIndexFinishTimes = new int[n3];
        for (n = 0; n < n3; ++n) {
            int n4 = nArray[0];
            int n5 = 0;
            for (int i = 1; i < n3; ++i) {
                if (nArray[i] >= n4) continue;
                n4 = nArray[i];
                n5 = i;
            }
            this.m_SortIndexFinishTimes[n] = n5;
            if (n5 != n2 || n3 == 12) {
                // empty if block
            }
            nArray[n5] = 1000000;
        }
        nArray = null;
    }

    public void CreateAllTextures() {
    }

    protected void DeleteIngameTextures() {
    }

    public void PrepareRoad(int n) {
        int n2;
        if (this.m_RoadRenderer != null && this.m_RoadRenderer.m_nEnvironment == n) {
            return;
        }
        this.DeleteIngameTextures();
        this.m_TexturesSmoke = new CGTexture[9];
        this.m_TexturesSmoke[0] = TextureManager.AddTexture("/gameplay/dust1_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[1] = TextureManager.AddTexture("/gameplay/dust1_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[2] = TextureManager.AddTexture("/gameplay/dust1_3.png", 0, 0, null, null);
        this.m_TexturesSmoke[3] = TextureManager.AddTexture("/gameplay/s_right_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[4] = TextureManager.AddTexture("/gameplay/s_right_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[5] = TextureManager.AddTexture("/gameplay/s_right_3.png", 0, 0, null, null);
        this.m_TexturesSmoke[6] = TextureManager.AddTexture("/gameplay/s_left_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[7] = TextureManager.AddTexture("/gameplay/s_left_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[8] = TextureManager.AddTexture("/gameplay/s_left_3.png", 0, 0, null, null);
        for (n2 = 0; n2 < 320; ++n2) {
            this.roadLineParams[n2] = new RoadLineParam();
        }
        this.m_RoadRenderer = new RoadRenderer();
        this.m_RoadRenderer.m_nType = 0;
        System.out.println("Prepare road env = " + n);
        this.m_RoadTexture = this.roadTex[this.m_nCurrentLevelIndex % this.roadTex.length];
        this.m_RoadRenderer.m_nType = 1;
        this.m_RoadRenderer.m_Color1 = 50;
        this.m_RoadRenderer.m_Color2 = 60;
        n2 = 0;
        this.m_RoadRenderer.m_R = (n2 & 0xFF0000) >> 16;
        this.m_RoadRenderer.m_G = (n2 & 0xFF00) >> 8;
        this.m_RoadRenderer.m_B = n2 & 0xFF;
        this.m_RoadRenderer.m_nEnvironment = n;
        int n3 = backgroundColor1[(n - 1) % backgroundColor1.length];
        int n4 = backgroundColor2[(n - 1) % backgroundColor2.length];
        this.m_RoadRenderer.m_nColor1_R = n3 >> 16 & 0xFF;
        this.m_RoadRenderer.m_nColor1_G = n3 >> 8 & 0xFF;
        this.m_RoadRenderer.m_nColor1_B = n3 & 0xFF;
        this.m_RoadRenderer.m_nColor2_R = n4 >> 16 & 0xFF;
        this.m_RoadRenderer.m_nColor2_G = n4 >> 8 & 0xFF;
        this.m_RoadRenderer.m_nColor2_B = n4 & 0xFF;
        if (this.m_RoadTexture != null) {
            this.m_RoadRenderer.SetImage(this.m_RoadTexture.m_Image);
        }
        long l = 380L * this.m_Camera.m_fxCameraScale;
        this.m_RoadRenderer.Setup((int)(l >> 12), this.m_Camera.m_arrScaleForRay, this.m_Camera.m_nRayCastingCount);
    }

    public void SaveBolidRecord() {
        if (this.m_BolidRecord == null) {
            this.m_BestBolidRecord = null;
        } else {
            if (this.m_BestBolidRecord == null) {
                this.m_BestBolidRecord = this.m_BolidRecord;
            } else if (this.m_BolidRecord.GetTotalTime() < this.m_BestBolidRecord.GetTotalTime()) {
                this.m_BestBolidRecord = this.m_BolidRecord;
            }
            this.m_BolidRecord = null;
        }
    }

    public CGBolidRecord GetBestBolidRecord() {
        return this.m_BestBolidRecord;
    }

    public void ResetBestBolidRecord() {
        if (this.m_BestBolidRecord != null) {
            this.m_BestBolidRecord.Reset();
        }
        this.m_BestBolidRecord = null;
    }

    public CGBolidRecord GetBolidRecord() {
        return this.m_BolidRecord;
    }

    public void ResetBolidRecord() {
        if (this.m_BolidRecord != null) {
            this.m_BolidRecord.Reset();
            this.m_BolidRecord = null;
        }
    }

    public void Load(DataInputStream dataInputStream, int n) {
        CGTexture cGTexture;
        this.m_nCurrentLevelIndex = n;
        int n2 = levelEnvironment[n];
        System.out.println("Level ID = " + this.m_nCurrentLevelIndex + " Ev ID =  " + n2);
        this.m_BackGroundTexture = null;
        this.m_HorizTexture = null;
        this.m_Horiz2Texture = null;
        this.m_RoadTexture = null;
        if (this.m_Bolid != null && this.m_Bolid[0] != null) {
            this.m_Bolid[0].ResetObj();
            this.m_Bolid[0] = null;
            this.m_Bolid = null;
        }
        int n3 = n;
        if (CGEngine.selectedRaceType == 1) {
            n3 = 10;
        }
        if (n3 != CGTrack.m_nLastTrackIndex) {
            if (this.m_Track != null) {
                this.m_Track.ResetObj();
                this.m_Track = null;
            }
            this.m_Track = new CGTrack();
            if (this.m_Mission == null) {
                this.m_Mission = new MissionParams();
            }
            try {
                this.deSerialize(dataInputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.PrepareRoad(n2);
        }
        if ((cGTexture = TextureManager.AddTexture("/gameplay/BackGround" + n2 + ".png", 0, 0, null, null)) != null) {
            this.m_BackGroundTexture = new CGTexture();
            this.m_BackGroundTexture.m_nSizeX = cGTexture.m_Image.getWidth();
            this.m_BackGroundTexture.m_nSizeY = ApplicationData.screenHeight;
            this.m_BackGroundTexture.m_szName = this.m_BackGroundTexture.m_szName;
            this.m_BackGroundTexture.m_Image = Graphic2D.ScaleImage(cGTexture.m_Image, this.m_BackGroundTexture.m_nSizeX, this.m_BackGroundTexture.m_nSizeY);
        }
        n2 = n2 <= 3 ? 1 : (n2 <= 6 ? 2 : 3);
        this.m_HorizTexture = TextureManager.AddTexture("/gameplay/Horiz1Texture" + n2 + ".png", 0, 0, null, null);
        this.m_Horiz2Texture = TextureManager.AddTexture("/gameplay/Horiz2Texture" + n2 + ".png", 0, 0, null, null);
        this.AfterLoad();
        this.m_fxCurrentTime = 0L;
    }

    public void AfterLoad() {
        this.m_fxCameraDistanceFromStart = 4096L;
        this.m_fxCameraStraight = 0L;
        this.m_Camera.SetCurrentTrackNode(null);
        this.m_Track.m_vecLastCameraDir.x = -409600L;
        this.m_Track.m_vecLastCameraDir.y = -409600L;
        this.m_Camera.SetCurrentTrackNode(this.m_Track.m_pFirstTrackNode);
        this.m_nGameState = 0;
        this.m_Track.m_nCurrentCheckPointIndex = 0;
        this.m_Track.m_nCurrentStoneIndex = 0;
        this.m_Track.m_fxCurrentCameraAngle = 4096000L;
        this.m_RainSystem.SetMode(levelWeather[this.m_nCurrentLevelIndex]);
    }

    private void deSerialize(DataInputStream dataInputStream) throws IOException {
        this.m_Track.deSerialize(dataInputStream);
        this.m_Mission.deSerialize(dataInputStream);
    }

    public void Go() {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Go();
        }
        this.m_nGameState = 1;
        this.m_fxCurrentTime = 0L;
    }

    public long GetMaxObjectsDistanceScale() {
        return this.m_Camera.CalculateObjectScaleForDistance(this.m_nMaxObjectsDistance * 4096);
    }

    public void SetCameraSettings(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        this.m_Camera = new CGCamera();
        this.m_Camera.m_nScreenXSize = n;
        this.m_Camera.m_nScreenYSize = n2;
        this.m_Camera.m_nCameraHeight = n4;
        this.m_Camera.m_nCameraDistance = n5;
        this.m_Camera.m_nRayCastingCount = n3;
        this.m_Camera.m_fxCameraScale = l;
        this.m_Camera.PreparePlaneDistanceForRay();
        this.m_Camera.PrepareScaleForRay();
        this.m_Camera.PrepareMipMapForRay();
        this.m_fxCameraDistanceFromStart = 4096L;
        this.m_fxCameraStraight = 0L;
        this.m_Camera.SetCurrentTrackNode(null);
        this.m_nTranslateScreenY = n6;
    }

    public int GetHumanRacePosition() {
        long l = this.m_Bolid[0].GetRealDistanceFromStart();
        int n = 0;
        for (int i = 1; i < this.m_nNrOfBolids; ++i) {
            if (this.m_Bolid[i].GetState() != 2 && this.m_Bolid[i].GetRealDistanceFromStart() <= l) continue;
            ++n;
        }
        return n;
    }

    public int GetBolidRacePosition(int n) {
        long l = this.m_Bolid[n].GetRealDistanceFromStart();
        int n2 = 0;
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            if (n == i || this.m_Bolid[i].GetState() != 2 && this.m_Bolid[i].GetRealDistanceFromStart() <= l) continue;
            ++n2;
        }
        return n2;
    }

    public void SetupLaps(int n) {
        if (Platform.IS_DEBUG_MODE) {
            n = 1;
        }
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].SetupLaps(n);
        }
        this.m_nGameState = 0;
    }

    void StepBolids() {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Step();
        }
        if (this.m_nGameState == 1 && this.m_Bolid[0].GetState() == 2) {
            this.m_nGameState = 2;
            System.out.println("Change state to ENGINE2D_STATE_ON_FINISH");
        }
        this.m_fxCameraDistanceFromStart = this.m_Bolid[0].GetDistanceFromStart() - 102400L;
        this.m_fxCameraStraight = this.m_Bolid[0].GetCurrentStraight();
        CGTrackNode cGTrackNode = this.m_Track.FindPlaceOnTrack3D(this.m_Bolid[0].GetDistanceFromStart(), 0L, null, this.g_vecPos3D, this.g_vecDir);
        this.m_Bolid[0].GetBillboardObject().m_fxY = this.g_vecPos3D.y;
        if (this.m_fxCameraDistanceFromStart > this.m_Track.m_fxTrackLength) {
            this.m_fxCameraDistanceFromStart -= this.m_Track.m_fxTrackLength;
            this.m_Camera.SetCurrentTrackNode(this.m_Track.m_pFirstTrackNode);
        } else if (this.m_fxCameraDistanceFromStart < 0L) {
            this.m_fxCameraDistanceFromStart = this.m_Track.m_fxTrackLength + this.m_fxCameraDistanceFromStart;
        }
    }

    void DrawWeather() {
        if (m_bDrawWeather && this.m_RainSystem != null) {
            this.m_RainSystem.Step(this.m_fxDeltaTime);
            this.m_RainSystem.Render();
        }
    }

    void DrawBackground() {
        if (this.m_BackGroundTexture != null) {
            int n = this.m_BackGroundTexture.m_Image.getWidth();
            int n2 = this.m_Camera.m_nScreenXSize / n;
            for (int i = 0; i <= n2; ++i) {
                Graphic2D.DrawImage(this.m_BackGroundTexture, i * n, 0 - this.m_nTranslateScreenY, 20);
            }
        } else {
            Graphic2D.FillRect(-1, 0, this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount - this.m_nTranslateScreenY, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nRayCastingCount);
            Graphic2D.FillRect(-7360513, 0, 0 - this.m_nTranslateScreenY, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount);
        }
    }

    public void RenderObject(Image image, int n, int n2, int n3) {
        int n4 = n - image.getWidth() / 2;
        int n5 = n2 - image.getHeight();
        Graphic2D.DrawRegion(image, 0, 0, image.getWidth(), image.getHeight(), n3, n4, n5, 20);
    }

    public void RenderHoriz(CGTexture cGTexture, int n, int n2, int n3, int n4) {
        int n5 = cGTexture.GetWidth();
        if ((n3 %= n5) > 0) {
            n3 = -n3;
        }
        do {
            Graphic2D.DrawImage(cGTexture, n3, n4, 20);
        } while ((n3 += n5) < n);
    }

    void DrawHorizontsAndClouds() {
        if (m_bDrawHorizontsAndClouds && this.m_Horiz2Texture != null) {
            int n = this.m_Camera.m_nRayCastingCount;
            if (this.roadLineParamsSize < n) {
                n = this.roadLineParamsSize;
            }
            int n2 = 0;
            int n3 = this.m_Camera.m_nScreenYSize - n - this.m_Horiz2Texture.GetHeight() + 3;
            this.m_RoadRenderer.m_nLandShaftY = this.m_Camera.m_nScreenYSize - n3 - this.m_Horiz2Texture.GetHeight();
            this.RenderHoriz(this.m_Horiz2Texture, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nScreenYSize, n2 / 2, 0);
        }
    }

    void DrawRoadToTable() {
        long l = 190L * this.m_Camera.m_fxCameraScale;
        CGTrackNode cGTrackNode = this.m_Camera.GetCurrentTrackNode();
        CGTrackNode cGTrackNode2 = null;
        int n = -1;
        int n2 = 0;
        long l2 = -4096L;
        this.roadLineParamsSize = 0;
        int n3 = 1;
        if (m_bDrawRoad) {
            for (int i = 0; i <= 300; i += n3) {
                int n4 = this.m_Camera.m_nScreenYSize - 1 - i;
                long l3 = 0L;
                long l4 = i * 4096;
                long l5 = this.m_Camera.m_nCameraDistance * 4096;
                long l6 = (i - this.m_Camera.m_nCameraHeight) * 4096;
                long l7 = FXUtility.Sqrt(l5 * l5 / 4096L + l6 * l6 / 4096L);
                l5 *= 4096L;
                l5 /= l7;
                l6 *= 4096L;
                l6 /= l7;
                l5 = (long)((float)l5 * ((float)this.m_Camera.m_fxLastDistance / 4096.0f));
                l6 = (long)((float)l6 * ((float)this.m_Camera.m_fxLastDistance / 4096.0f));
                long l8 = this.m_Track.GetZForRay(l4, l3, l6 += l4, l5 += l3, cGTrackNode);
                if ((float)l8 < 0.0f && l2 < 0L && ++n2 > 10) break;
                l2 = l8;
                long l9 = l8;
                cGTrackNode2 = this.m_Track.GetXForZ(l9, cGTrackNode, this.v);
                if (cGTrackNode2 == null) break;
                long l10 = this.v.x;
                long l11 = this.v.y;
                cGTrackNode = cGTrackNode2;
                long l12 = l9;
                int n5 = this.m_Camera.FindRayIndexForDistance(l12);
                if (n5 < n) break;
                n = n5;
                l10 = this.m_Camera.CalculateFloatScreenX(l10, l9);
                int n6 = (int)((l10 *= this.m_Camera.m_fxCameraScale) / 0x1000000L);
                long l13 = (this.m_fxCameraDistanceFromStart + l12) / 4096L % 256L;
                this.roadLineParams[this.roadLineParamsSize].depth = l12;
                this.roadLineParams[this.roadLineParamsSize].nRayIndex = n5;
                this.roadLineParams[this.roadLineParamsSize].nX = n6 + this.m_Camera.m_nScreenXSize / 2;
                this.roadLineParams[this.roadLineParamsSize].nY = n4 - this.m_nTranslateScreenY;
                this.roadLineParams[this.roadLineParamsSize].uv = l13;
                ++this.roadLineParamsSize;
            }
        }
        this.m_RoadRenderer.m_nLandShaftY = ApplicationData.screenHeight - this.m_nTranslateScreenY - this.roadLineParams[this.roadLineParamsSize - 1].nY;
        if (this.m_RoadRenderer.m_nLandShaftY < ApplicationData.screenHeight / 3) {
            this.m_RoadRenderer.m_nLandShaftY = ApplicationData.screenHeight / 3;
        }
    }

    void Step() {
        int n;
        int n2;
        int n3;
        this.m_fxCurrentTime += this.m_fxDeltaTime;
        this.StepBolids();
        for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
            this.bol[n3] = this.m_Bolid[n3];
        }
        for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
            n2 = -1;
            long l = -4096L;
            for (n = 0; n < this.m_nNrOfBolids; ++n) {
                if (this.bol[n] == null || this.bol[n].GetRealDistanceFromStart() <= l) continue;
                n2 = n;
                l = this.bol[n].GetRealDistanceFromStart();
            }
            if (n2 < 0) break;
            this.arrObj[this.m_nNrOfBolids - 1 - n3] = this.bol[n2].GetBillboardObject();
            this.arrObjIndexes[this.m_nNrOfBolids - 1 - n3] = n2;
            this.bol[n2] = null;
        }
        CGTrackNode cGTrackNode = this.m_Track.PrepareTrackForCamera(this.m_fxCameraDistanceFromStart, this.m_fxCameraStraight, null, this.m_Camera.m_fxLastDistance, this.vecPos, this.vecCameraDir, this.arrObj, this.m_nNrOfBolids);
        this.m_Camera.SetCurrentTrackNode(cGTrackNode);
        this.m_fxCameraAngle = Vector2FX.AngleFromVector(this.vecCameraDir);
        this.DrawBackground();
        this.DrawHorizontsAndClouds();
        this.roadLineParamsSize = 0;
        this.DrawRoadToTable();
        n2 = 0;
        int n4 = 0;
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
        if (m_bDrawObjects) {
            for (int i = this.roadLineParamsSize - 1; i >= 0; --i) {
                n = this.m_Track.m_arrCurrentObjects.size();
                for (int j = n - 1; j >= 0; --j) {
                    CGBillboardObject cGBillboardObject = (CGBillboardObject)this.m_Track.m_arrCurrentObjects.elementAt(j);
                    if (cGBillboardObject.m_fxTrZ < 0L || cGBillboardObject.m_fxTrZ > (long)(this.m_nMaxObjectsDistance * 4096) || cGBillboardObject.m_fxTrZ < this.roadLineParams[i].depth || this.m_Camera.CalculateObjectScreenPosition(cGBillboardObject, this.arrPixels) <= 0) continue;
                    this.arrPixels[1] = this.m_Camera.m_nScreenYSize - this.arrPixels[1];
                    this.arrPixels[3] = this.m_Camera.m_nScreenYSize - this.arrPixels[3];
                    this.arrPixels[0] = this.arrPixels[0] + this.m_Camera.m_nScreenXSize / 2;
                    this.arrPixels[2] = this.arrPixels[2] + this.m_Camera.m_nScreenXSize / 2;
                    if (this.arrPixels[0] > this.m_Camera.m_nScreenXSize || this.arrPixels[2] < 0) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(j);
                        continue;
                    }
                    n2 = (this.arrPixels[0] + this.arrPixels[2]) / 2;
                    if (n2 > this.m_Camera.m_nScreenXSize || n2 < 0) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(j);
                        continue;
                    }
                    n4 = this.arrPixels[3];
                    if (cGBillboardObject.m_nLinearScale <= 0) {
                        int n5;
                        long l;
                        if (cGBillboardObject.m_nCarIndex == 0) {
                            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForObjects;
                            if (cGBillboardObject.m_Texture != null) {
                                l = cGBillboardObject.m_fxTrZ;
                                n5 = CGTexture.m_nNrOfMipMaps * (int)(cGBillboardObject.m_fxTrZ / (long)this.m_nMaxObjectsDistance) / 4096;
                                if (n5 >= CGTexture.m_nNrOfMipMaps) {
                                    n5 = CGTexture.m_nNrOfMipMaps - 1;
                                }
                                if (n5 < 0) {
                                    n5 = 0;
                                }
                                n5 = CGTexture.m_nNrOfMipMaps - 1 - n5;
                                this.RenderObject(cGBillboardObject.m_Texture.m_MipMaps[n5], n2, n4 - this.m_nTranslateScreenY, cGBillboardObject.m_nMirrored);
                            }
                        } else {
                            int n6;
                            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
                            l = cGBillboardObject.m_fxTrZ;
                            n5 = CGTexture.m_nNrOfMipMaps * (int)((cGBillboardObject.m_fxTrZ + 614400L) / (long)this.m_nMaxObjectsDistance) / 4096;
                            if (n5 >= CGTexture.m_nNrOfMipMaps) {
                                n5 = CGTexture.m_nNrOfMipMaps - 1;
                            }
                            if (n5 < 0) {
                                n5 = 0;
                            }
                            n5 = CGTexture.m_nNrOfMipMaps - 1 - n5;
                            int n7 = cGBillboardObject.m_nCarIndex - 1;
                            int n8 = 3;
                            boolean bl = false;
                            int n9 = 0;
                            long l2 = Vector2FX.AngleFromVector(this.m_Bolid[n7].m_DirVector);
                            if ((l2 -= this.m_fxCameraAngle) > 737280L) {
                                l2 -= 1474560L;
                            } else if (l2 < -737280L) {
                                l2 += 1474560L;
                            }
                            if (cGBillboardObject.m_nCarIndex > 1) {
                                if (l2 > 143360L) {
                                    n8 = 0;
                                    n9 = 2;
                                } else if (l2 > 81920L) {
                                    n8 = 1;
                                    n9 = 2;
                                } else if (l2 > 10L) {
                                    n8 = 2;
                                    n9 = 2;
                                } else if (l2 < -143360L) {
                                    n8 = 0;
                                } else if (l2 < -81920L) {
                                    n8 = 1;
                                } else if (l2 < -10L) {
                                    n8 = 2;
                                } else {
                                    n8 = 3;
                                    n9 = 0;
                                }
                                if (this.m_nGameState == 2) {
                                    n8 = 3;
                                }
                            } else if (this.m_Bolid[n7].IsStraightLeft() > 0) {
                                n8 = this.m_Bolid[n7].m_fxSterringLeftTime < 600L ? 2 : 1;
                                this.m_Bolid[n7].m_nViewAngleVariant = n8;
                            } else if (this.m_Bolid[n7].IsStraightRight() > 0) {
                                n8 = this.m_Bolid[n7].m_fxSterringRightTime < 600L ? 2 : 1;
                                n9 = 2;
                                this.m_Bolid[n7].m_nViewAngleVariant = -n8;
                            } else {
                                long l3 = this.m_Bolid[n7].GetCurrentSterringStraight();
                                if (this.m_Bolid[n7].m_nViewAngleVariant == 1) {
                                    this.m_Bolid[n7].m_nViewAngleVariant = n8 = 2;
                                } else if (this.m_Bolid[n7].m_nViewAngleVariant == -1) {
                                    n8 = 2;
                                    this.m_Bolid[n7].m_nViewAngleVariant = -n8;
                                    n9 = 2;
                                } else if (this.m_Bolid[n7].m_nViewAngleVariant == 2) {
                                    this.m_Bolid[n7].m_nViewAngleVariant = n8 = 3;
                                } else if (this.m_Bolid[n7].m_nViewAngleVariant == -2) {
                                    this.m_Bolid[n7].m_nViewAngleVariant = n8 = 3;
                                    n9 = 2;
                                }
                            }
                            if ((n6 = this.m_Bolid[n7].m_nJumpHeight) != 0) {
                                System.out.println("JJJ = " + n6);
                            }
                            if (cGBillboardObject.m_nCarIndex == 1) {
                                if (this.m_Bolid[0].IsDrift() != 0) {
                                    n8 = 0;
                                    n9 = this.m_Bolid[0].IsDrift() > 0 ? 2 : 0;
                                }
                                this.m_Bolid[n7].DrawSmoke(n2, n4 - this.m_nTranslateScreenY);
                                this.RenderObject(this.m_Bolid[n7].m_Textures[n8].m_MipMaps[n5], n2, n4 - this.m_nTranslateScreenY - n6, n9);
                            } else {
                                this.m_Bolid[n7].DrawSmoke(n2, n4 - this.m_nTranslateScreenY);
                                this.RenderObject(this.m_Bolid[n7].m_Textures[n8].m_MipMaps[n5], n2, n4 - this.m_nTranslateScreenY - n6, n9);
                            }
                        }
                    }
                    this.m_Track.m_arrCurrentObjects.removeElementAt(j);
                }
                this.m_RoadRenderer.DrawLine(i, this.roadLineParams[i].nRayIndex, this.roadLineParams[i].depth, this.roadLineParams[i].nX, this.roadLineParams[i].nY, this.roadLineParams[i].uv);
            }
        }
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
        this.DrawWeather();
    }

    public void SetupBolids(int n) {
        int n2;
        int n3;
        this.m_nNrOfBolids = n;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        long[] lArray3 = new long[n];
        long[] lArray4 = new long[n];
        String[] stringArray = new String[n];
        stringArray[0] = EditChampionshipsUserName.playerNick;
        if (CGEngine.selectedGameMode == 2) {
            // empty if block
        }
        if (n > 1) {
            stringArray[1] = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_1");
        }
        if (n > 8) {
            for (n3 = 2; n3 < n; ++n3) {
                stringArray[n3] = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_" + (n3 + 1));
            }
        }
        if (n == 1) {
            this.ResetBestBolidRecord();
            this.m_nNrOfBolids = n;
            lArray[0] = 0x190000L;
            lArray2[0] = 0L;
            lArray3[0] = 1843200L;
            lArray4[0] = 327680L;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
                this.m_Bolid[n3] = new CGBolid(n3);
            }
            this.m_Bolid[0].SetHuman(1);
        } else if (n == 2) {
            this.ResetBolidRecord();
            this.ResetBestBolidRecord();
            lArray[0] = 0x190000L;
            lArray[1] = 0x190000L;
            lArray2[0] = 2048L;
            lArray2[1] = -2048L;
            lArray3[0] = 1843200L;
            lArray3[1] = 1720320L;
            lArray4[0] = 327680L;
            lArray4[1] = 368640L;
            this.m_nNrOfBolids = n;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
                this.m_Bolid[n3] = new CGBolid(n3);
            }
            for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
                this.m_Bolid[n3].SetOpponents(this.m_nNrOfBolids, this.m_Bolid);
            }
            this.m_Bolid[0].SetHuman(1);
        } else if (n == 6) {
            this.ResetBolidRecord();
            this.ResetBestBolidRecord();
            lArray[0] = 1024000L;
            lArray[1] = 0x104000L;
            lArray[2] = 1228800L;
            lArray[3] = 1228800L;
            lArray[4] = 1433600L;
            lArray[5] = 1433600L;
            for (n3 = 0; n3 < 6; ++n3) {
                lArray2[n3] = (n3 % 2 == 0 ? -5 : 5) * 4096 / 10;
            }
            lArray3[0] = 1843200L;
            lArray3[1] = 0x226000L;
            lArray3[2] = 2048000L;
            lArray3[3] = 0x208000L;
            lArray3[4] = 1843200L;
            lArray3[5] = 1433600L;
            lArray4[0] = 327680L;
            lArray4[1] = 368640L;
            lArray4[2] = 471040L;
            lArray4[3] = 491520L;
            lArray4[4] = 450560L;
            lArray4[5] = 430080L;
            this.m_nNrOfBolids = n;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
                this.m_Bolid[n3] = new CGBolid(n3);
            }
            for (n3 = 0; n3 < this.m_nNrOfBolids; ++n3) {
                this.m_Bolid[n3].SetOpponents(this.m_nNrOfBolids, this.m_Bolid);
            }
            this.m_Bolid[0].SetHuman(1);
        } else {
            int n4;
            this.ResetBolidRecord();
            this.ResetBestBolidRecord();
            Random random = new Random();
            for (n4 = 0; n4 < n; ++n4) {
                lArray[n4] = n4 * 50 * 4096;
                lArray2[n4] = (n4 % 2 == 0 ? 5 : -5) * 4096 / 10;
                lArray3[n4] = (400 + n4 % 3 * 50) * 4096;
                lArray4[n4] = (80 + n4 % 3 * 10) * 4096;
            }
            this.m_nNrOfBolids = n;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (n4 = 0; n4 < this.m_nNrOfBolids; ++n4) {
                this.m_Bolid[n4] = new CGBolid(n4);
            }
            for (n4 = 0; n4 < this.m_nNrOfBolids; ++n4) {
                this.m_Bolid[n4].SetOpponents(this.m_nNrOfBolids, this.m_Bolid);
            }
            lArray[0] = 50 * n;
            this.m_Bolid[0].SetHuman(1);
        }
        for (n2 = 2; n2 < n; ++n2) {
            stringArray[n2] = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_" + (n2 + 1));
        }
        for (n2 = 0; n2 < this.m_nNrOfBolids; ++n2) {
            this.m_Bolid[n2].Setup(lArray[n2], lArray2[n2], lArray3[n2], lArray4[n2]);
            this.m_Bolid[n2].SetBolidIndex(n2);
            this.m_Bolid[n2].SetNick(stringArray[n2]);
            System.out.println("Name " + stringArray[n2]);
        }
        this.m_nGameState = 0;
    }

    public class RoadLineParam {
        public long depth;
        public int nRayIndex;
        public int nX;
        public int nY;
        public long uv;
    }
}

