/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.Platform;
import java.util.Vector;

public class UIFloatingTextBox {
    private Vector textLines = new Vector();
    private int textHeight = 0;
    private int scrollOffset = 0;
    private boolean scrollable = false;
    private final int SCROLL_SPEED;
    private int positionX;
    private int positionY;
    private int width;
    private int height;
    public boolean hasBackground = false;
    public int fontID = 0;

    public UIFloatingTextBox(boolean bl, int n, int n2, int n3, int n4) {
        this.SCROLL_SPEED = 1;
        this.positionX = n;
        this.positionY = n2;
        this.width = n3;
        this.height = n4;
        this.scrollable = bl;
    }

    public void setPositionY(int n) {
        this.positionY = n;
    }

    public void onUpdate(int n) {
        if (this.scrollable) {
            int n2;
            if (ApplicationData.isUpPressed() && this.scrollOffset < 0) {
                this.scrollOffset += n * 1 / 10;
            }
            if (ApplicationData.isDownPressed() && this.scrollOffset > (n2 = -ApplicationData.getFontByID(this.fontID).getFontHeight() * (this.textLines.size() - this.height / ApplicationData.getFontByID(this.fontID).getFontHeight()))) {
                this.scrollOffset -= n * 1 / 10;
            }
        }
    }

    public void setText(String string, String string2) {
        this.textLines = Utils.splitText(string, string2);
        this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight() - ApplicationData.getFontByID(this.fontID).getFontSpacing();
        if (this.checkIfScrollsAreNeeded()) {
            this.textLines = Utils.splitText(string, string2, ApplicationData.screenWidth - Platform.WND_FRAME_MARGIN_LEFT - Platform.WND_FRAME_MARGIN_RIGHT);
            this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
    }

    public void setText(String string) {
        this.setText(string, "+");
    }

    private boolean checkIfScrollsAreNeeded() {
        this.scrollable = this.textHeight > this.height;
        return this.scrollable;
    }

    public void draw() {
        int n = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int n2 = 0;
        if (!this.scrollable) {
            n2 = (this.height - n * this.textLines.size()) / 2;
        }
        Graphic2D.SetClip(this.positionX + Platform.WND_MARGIN_LEFT, this.positionY + Platform.WND_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT, this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM);
        if (this.hasBackground) {
            this.drawTextBoxBackground(this.width, this.height);
            Graphic2D.SetClip(this.positionX + Platform.WND_FRAME_MARGIN_LEFT, this.positionY + Platform.WND_FRAME_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_FRAME_MARGIN_RIGHT, this.height - Platform.WND_MARGIN_TOP - Platform.WND_FRAME_MARGIN_BOTTOM);
        } else {
            Graphic2D.SetClip(this.positionX, this.positionY + Platform.WND_FRAME_MARGIN_TOP, this.width, this.height - Platform.WND_MARGIN_TOP - Platform.WND_FRAME_MARGIN_BOTTOM);
        }
        int n3 = 0;
        for (int i = 0; i < this.textLines.size(); ++i) {
            int n4 = this.positionY + n3 + i * n + this.scrollOffset + n2;
            if (n4 < 0 || n4 > ApplicationData.screenHeight) continue;
            if (!this.scrollable) {
                System.out.println(">>" + this.positionX + "," + this.width / 2);
                Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, n4, 17, this.fontID);
                continue;
            }
            Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, n4, 17, this.fontID);
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    private void drawTextBoxBackground(int n, int n2) {
    }
}

