/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;
import kernel.KUtils;

public final class KFileBuffer {
    protected final byte[] m_data;
    public int m_start;
    public int m_pos;
    int m_end;

    public KFileBuffer(byte[] byArray, int n, int n2) {
        this.m_data = byArray;
        this.m_start = n;
        this.m_end = n2;
        this.m_pos = this.m_start;
    }

    public KFileBuffer(KFileBuffer kFileBuffer, int n) {
        int n2 = kFileBuffer.m_pos;
        kFileBuffer.Seek(n2 - kFileBuffer.m_start + 2 + (n << 2));
        this.m_start = 0 + kFileBuffer.readInt();
        this.m_end = 0 + kFileBuffer.readInt();
        this.m_data = kFileBuffer.m_data;
        this.m_pos = this.m_start;
        kFileBuffer.m_pos = n2;
    }

    public KFileBuffer(String object) {
        byte[] byArray = null;
        try {
            object = KUtils.s_midletApp.getClass().getResourceAsStream("/" + (String)object);
            byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            try {
                int n;
                while ((n = ((InputStream)object).read(byArray)) >= 1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {}
            byArray = byteArrayOutputStream.toByteArray();
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            byArray = new byte[]{};
        }
        this.m_data = byArray;
        this.m_start = 0;
        this.m_end = this.m_data.length;
        System.gc();
    }

    public KFileBuffer() {
        this.m_data = new byte[29];
        this.m_start = 0;
        this.m_end = this.m_data.length;
        this.m_pos = 0;
    }

    private KFileBuffer(byte[] byArray) {
        this.m_data = byArray;
        this.m_start = 0;
        this.m_end = byArray.length;
        this.m_pos = 0;
    }

    public KFileBuffer(KFileBuffer kFileBuffer, int n, int n2) {
        this.m_data = new byte[n2];
        this.m_start = 0;
        this.m_pos = 0;
        this.m_end = n2;
        System.arraycopy(kFileBuffer.m_data, kFileBuffer.m_start, this.m_data, 0, n2);
    }

    public final ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.m_data, this.m_pos, this.m_end - this.m_pos);
    }

    public final byte[] getByteArray() {
        if (this.m_pos == 0 && this.m_end == this.m_data.length) {
            return this.m_data;
        }
        byte[] byArray = new byte[this.m_end - this.m_pos];
        System.arraycopy(this.m_data, this.m_pos, byArray, 0, this.m_end - this.m_pos);
        return byArray;
    }

    public final byte[] getData() {
        return this.m_data;
    }

    public final int getLength() {
        return this.m_end - this.m_start;
    }

    public final void Seek(int n) {
        this.m_pos = this.m_start + n;
        if (this.m_pos < this.m_start) {
            this.m_pos = this.m_start;
        }
        if (this.m_pos > this.m_end) {
            this.m_pos = this.m_end;
        }
    }

    public final int Tell() {
        return this.m_pos - this.m_start;
    }

    public final boolean EOF() {
        return this.m_pos == this.m_end;
    }

    public final void writeByte(int n) {
        this.m_data[this.m_pos++] = (byte)n;
    }

    public final void writeArray$1cf967a4(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.m_data, this.m_pos, n);
        this.m_pos += n;
    }

    public final byte readByte() {
        return this.m_data[this.m_pos++];
    }

    public final short readShort() {
        return (short)(this.readByte() << 8 | this.readByte() & 0xFF);
    }

    public final int readUnsignedShort() {
        return this.readByte() << 8 | this.readByte() & 0xFF;
    }

    public final int readInt() {
        return this.readByte() << 24 | this.readByte() << 16 & 0xFF0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF;
    }

    public final boolean readBoolean() {
        if (this.m_pos >= this.m_end) {
            return false;
        }
        return this.m_data[this.m_pos++] != 0;
    }

    public final void readFully$1cf967a4(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.readByte();
        }
    }

    public final byte[] readBytes(int n, int n2, byte[] byArray) {
        if (n2 == 0) {
            n2 = this.m_end - this.m_start;
        }
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        System.arraycopy(this.m_data, n + this.m_start, byArray, 0, n2);
        return byArray;
    }

    private byte calculateSaveFileCRC(byte by) {
        for (int i = this.m_end - 2; i >= 0; --i) {
            by = (byte)(by + this.m_data[i]);
        }
        return by;
    }

    public final void appendSaveFileCRC$132be7() {
        this.m_data[this.m_end - 1] = this.calculateSaveFileCRC((byte)76);
    }

    public final boolean writeRMS(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            if (recordStore.getNextRecordID() > 1) {
                recordStore.setRecord(1, this.m_data, 0, this.m_end);
            } else {
                recordStore.addRecord(this.m_data, 0, this.m_end);
            }
        }
        catch (Exception exception) {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (Exception exception2) {}
            return false;
        }
        try {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static KFileBuffer readRMS(String object, int n, byte by) {
        RecordStore recordStore = null;
        KFileBuffer kFileBuffer = null;
        try {
            recordStore = RecordStore.openRecordStore((String)object, (boolean)false);
            object = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            if (object == null || ((Object)object).length != 29) {
                return null;
            }
            kFileBuffer = new KFileBuffer((byte[])object);
            if (kFileBuffer.m_data[kFileBuffer.m_end - 1] != kFileBuffer.calculateSaveFileCRC((byte)76)) {
                return null;
            }
        }
        catch (Exception exception) {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
            return null;
        }
        return kFileBuffer;
    }
}

