/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Game;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kernel.KCanvas;
import kernel.KFileBuffer;
import kernel.KFont;
import kernel.KGraphics;
import kernel.KRes;
import kernel.KUtils;

public final class Utils {
    private static boolean clearKeyisPressed = false;
    public static boolean rightSoftKeyDisabled = false;
    public static int BACK_BUFFER_HEIGHT;
    public static int BACK_BUFFER_WIDTH;
    private static Image back_image;
    private static Graphics back_buffer_graphic;
    public static byte REFRESH_NEEDED_FULL;
    public static byte REFRESH_NEEDED_PARTIAL;
    public static byte REFRESH_NEEDED_INTERRUPT;
    public static byte refresh;
    private static short[] s_savedClipInfo;
    private static int loadingPercent;
    private static byte s_progressBarType;
    public static boolean loadingCriticalPart;
    public static boolean loadingIsActive;
    private static int loading_x;
    private static int loading_y;
    private static int loading_width;
    private static int loading_height;
    public static int INDICATOR_HEIGHT;
    private static byte[] indicatorsId;
    private static char[][] indicatorsText;
    private static Image[] indicatorsImage;
    private static byte[] indicRefId_image;
    public static byte FADE_WHITE_OFFSET;
    public static char[] charBufferTmp;
    public static char[] charBuffer;
    public static int lengthVirtual;

    public static void clearKeyEnabled() {
        clearKeyisPressed = true;
        loadingPercent = -1;
    }

    public static void clearKeyDisabled() {
        clearKeyisPressed = false;
    }

    public static boolean clearKeyIsEnable() {
        return clearKeyisPressed;
    }

    public static String replaceVariable(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        string.getChars(0, n, charBuffer, 0);
        string3.getChars(0, string3.length(), charBuffer, n);
        string2.length();
        string.length();
        string2.length();
        string.getChars(n + string2.length(), string.length(), charBuffer, n + string3.length());
        return new String(charBuffer, 0, string.length() - string2.length() + string3.length());
    }

    public static void drawBackbuffer(Graphics graphics) {
        graphics.drawImage(back_image, 0, 0, 0);
    }

    public static void drawBackbufferRegion(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics = KGraphics.setGraphics(graphics);
        if (n + n3 < 0 || n > BACK_BUFFER_WIDTH || n2 + n4 < 0 || n2 > BACK_BUFFER_HEIGHT) {
            return;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        } else if (n + n3 > BACK_BUFFER_WIDTH) {
            n3 = BACK_BUFFER_WIDTH - n;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        } else if (n2 + n4 > BACK_BUFFER_HEIGHT) {
            n4 = n + n4 - BACK_BUFFER_HEIGHT;
        }
        KGraphics.drawRegion(back_image, n, n2, n3, n4, 0, n5, n6);
        KGraphics.setGraphics(graphics);
    }

    public static Graphics getBackBufferGraphics() {
        return back_buffer_graphic;
    }

    public static void iniBackBuffer(int n, int n2) {
        back_image = Image.createImage((int)n, (int)n2);
        back_buffer_graphic = back_image.getGraphics();
        BACK_BUFFER_HEIGHT = n2;
        BACK_BUFFER_WIDTH = n;
    }

    public static int getBackBufferWidth() {
        return back_image.getWidth();
    }

    public static int getBackBufferHeight() {
        return back_image.getHeight();
    }

    public static final void SaveClip() {
        short[] sArray;
        Object object = s_savedClipInfo;
        if (s_savedClipInfo == null) {
            object = KGraphics.getGraphics();
            short[] sArray2 = new short[4];
            sArray2[0] = (short)object.getClipX();
            sArray2[1] = (short)object.getClipY();
            sArray2[2] = (short)object.getClipWidth();
            sArray = sArray2;
            sArray2[3] = (short)object.getClipHeight();
        } else {
            Graphics graphics = KGraphics.getGraphics();
            object[0] = (short)graphics.getClipX();
            object[1] = (short)graphics.getClipY();
            object[2] = (short)graphics.getClipWidth();
            object[3] = (short)graphics.getClipHeight();
            sArray = object;
        }
        s_savedClipInfo = sArray;
    }

    public static final void SetClip$29abebcb(short s, short s2, short s3) {
        KGraphics.getGraphics().setClip((int)s, 0, (int)s2, (int)s3);
    }

    public static final void RestoreClip() {
        short[] sArray = s_savedClipInfo;
        if (s_savedClipInfo != null) {
            KGraphics.getGraphics().setClip((int)sArray[0], (int)sArray[1], (int)sArray[2], (int)sArray[3]);
        }
        Utils.s_savedClipInfo[0] = 0;
        Utils.s_savedClipInfo[1] = 0;
        Utils.s_savedClipInfo[2] = 0;
        Utils.s_savedClipInfo[3] = 0;
    }

    public static final int getLoadingPercent() {
        return loadingPercent;
    }

    public static final void loadingDraw(Graphics graphics) {
        switch (s_progressBarType) {
            case 1: {
                graphics.setColor(0);
                graphics.fillRect(0, 0, KCanvas.m_width, KCanvas.m_height);
            }
            case 2: {
                Utils.drawIndicatorBG(graphics);
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(loading_x - 1, loading_y - 3, (KCanvas.m_width << 1) / 4 + 1, 6);
                graphics.setColor(0xFF0000);
                graphics.fillRect(loading_x, loading_y - 2, (KCanvas.m_width << 1) / 4 * loadingPercent / 100, 4);
            }
        }
    }

    public static final void loadingIni$252c3fc(int n) {
        loadingIsActive = true;
        s_progressBarType = (byte)2;
        loading_width = KCanvas.m_width >> 1;
        loading_height = 4;
        if ((n & 1) == 1) {
            loading_x = 1;
        } else if ((n & 2) == 2) {
            loading_x = KCanvas.m_width - (loading_width + 1);
        } else if ((n & 4) == 4) {
            loading_x = KCanvas.m_width - loading_width >> 1;
        }
        if ((n & 8) == 8) {
            loading_y = 1;
            return;
        }
        if ((n & 0x10) == 16) {
            loading_y = KCanvas.m_height - (loading_height + 1);
            return;
        }
        if ((n & 0x20) == 32) {
            loading_y = KCanvas.m_height - loading_height >> 1;
        }
    }

    public static final boolean loadingRefresh(int n) {
        if (n > 100) {
            n = 100;
        }
        KUtils.updateElapsedMS();
        loadingPercent = n;
        KCanvas.s_instance.repaint();
        KCanvas.s_instance.serviceRepaints();
        KUtils.updateElapsedMS();
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {}
        if (n == 100) {
            loadingPercent = -1;
        }
        if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
            Utils.clearKeyEnabled();
            return false;
        }
        return true;
    }

    public static final boolean loadingIsActive() {
        return loadingPercent != -1 && loadingIsActive;
    }

    public static final void loadingDisable() {
        loadingIsActive = false;
    }

    public static final void loadingEnable() {
        loadingIsActive = true;
    }

    public static final void setIndicator(byte by, byte by2) {
        Utils.indicatorsId[by2] = by;
        switch (by) {
            case 1: {
                Utils.indicatorsText[by2] = Game.getWords(52);
                return;
            }
            case 3: {
                Utils.indicatorsText[by2] = Game.getWords(24);
                return;
            }
            case 5: {
                Utils.indicatorsText[by2] = Game.getWords(36);
                return;
            }
            case 2: {
                Utils.indicatorsText[by2] = Game.getWords(56);
                return;
            }
            case 6: {
                Utils.indicatorsText[by2] = Game.getWords(68);
                return;
            }
            case 4: {
                Utils.indicatorsText[by2] = Game.getWords(28);
                return;
            }
            case 7: {
                Utils.indicatorsText[by2] = Game.getWords(898);
                return;
            }
            case 8: {
                Utils.indicatorsText[by2] = Game.getWords(958);
                return;
            }
            case 10: {
                Utils.indicatorsText[by2] = Game.getWords(962);
                return;
            }
            case 9: {
                Utils.indicatorsText[by2] = Game.getWords(72);
                return;
            }
        }
        Utils.indicatorsId[by2] = 0;
    }

    public static final void setIndicator(byte by, byte by2, KFont kFont) {
        int n;
        if (kFont == null) {
            Utils.setIndicator(by, by2);
            return;
        }
        for (n = 0; n < indicRefId_image.length && by != indicRefId_image[n]; ++n) {
        }
        if (n >= indicRefId_image.length) {
            char[] cArray = null;
            switch (by) {
                case 6: {
                    cArray = Game.getWords(68);
                    break;
                }
                case 4: {
                    cArray = Game.getWords(28);
                }
            }
            int n2 = kFont.textWidth(cArray, 0, cArray.length);
            int n3 = kFont.m_height - 1;
            Utils.indicRefId_image[by2] = by;
            Utils.indicatorsImage[by2] = Image.createImage((int)n2, (int)n3);
            Graphics graphics = indicatorsImage[by2].getGraphics();
            Graphics graphics2 = KGraphics.setGraphics(graphics);
            graphics.setColor(0);
            graphics.fillRect(0, 0, indicatorsImage[by2].getWidth(), indicatorsImage[by2].getHeight());
            Utils.initTextRendering$55c32c91(kFont);
            KGraphics.drawText(cArray, 0, cArray.length, 0, -1);
            KGraphics.setGraphics(graphics2);
        } else {
            Utils.indicRefId_image[by2] = by;
            Utils.indicatorsImage[by2] = indicatorsImage[n];
        }
        Utils.indicatorsId[by2] = -2;
    }

    public static final void drawIndicators$bfed7fe(KFont kFont) {
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2;
            if (indicatorsId[i] != 0 && kFont != null && indicatorsId[i] != -2) {
                n2 = 0;
                n = 0;
                int n3 = KCanvas.m_height - kFont.m_height + 1;
                char[] cArray = indicatorsText[i];
                n = kFont.textWidth(cArray, 0, cArray.length);
                n2 = KCanvas.m_width - n;
                if (i == 1) {
                    n2 >>= 1;
                } else if (i == 0) {
                    n2 = 0;
                }
                KGraphics.s_fontBG = null;
                KGraphics.s_fontFG = kFont;
                KGraphics.s_shadow = false;
                KGraphics.drawText(cArray, 0, cArray.length, n2, n3 + 1);
                continue;
            }
            if (indicatorsId[i] != -2) continue;
            n2 = KCanvas.m_height - indicatorsImage[i].getHeight() + 2;
            n = KCanvas.m_width - indicatorsImage[i].getWidth();
            if (i == 1) {
                n >>= 1;
            } else if (i == 0) {
                n = 0;
            }
            KGraphics.drawImage(indicatorsImage[i], n, n2);
        }
    }

    public static final void drawIndicatorBG(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, KCanvas.m_height - 8, KCanvas.m_width, 8);
    }

    public static final byte[] getIndicators() {
        return indicatorsId;
    }

    public static void drawStipple(KRes kRes, int n) {
        Utils.drawStipple(kRes, n, 0, 0, KCanvas.m_width, KCanvas.m_height);
    }

    public static void drawStipple(KRes kRes, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (n < 0) {
            n = 0;
        }
        if (n > 32) {
            n = 32;
        }
        int n7 = ((Image)kRes.ro_ref).getWidth();
        for (int i = 0; i < n5; i += 4) {
            n6 = 0;
            while (n6 + n7 < n4) {
                KGraphics.drawRegion(kRes, 0, n << 2, n7, i + 4 < n5 ? 4 : n5 - i, 0, n2 + n6, n3 + i);
                n6 += n7;
            }
            n7 = n4 - n6;
            KGraphics.drawRegion(kRes, 0, n << 2, n7, i + 4 < n5 ? 4 : n5 - i, 0, n2 + n6, n3 + i);
        }
    }

    public static final void initTextRendering$55c32c91(KFont kFont) {
        KGraphics.s_fontFG = kFont;
        KGraphics.s_fontBG = null;
        KGraphics.s_shadow = false;
        KGraphics.s_shadowOffsetX = 0;
        KGraphics.s_shadowOffsetY = 0;
    }

    public static int charLastIndexOf(char[] cArray, char c, int n, int n2) {
        ++n;
        while (--n >= n2 && c != cArray[n]) {
        }
        if (n < n2) {
            n = -1;
        }
        return n;
    }

    public static int charIndexOf(char[] cArray, char c, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2 + n && cArray[n3] != c; ++n3) {
        }
        if (n3 >= n2 + n) {
            n3 = -1;
        }
        return n3;
    }

    public static int charIndexOf(char[] cArray, String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        boolean bl = false;
        for (n3 = n; n3 < n2 - (n4 - 1) + n && !bl; ++n3) {
            bl = true;
            for (n5 = 0; n5 < n4 && bl; ++n5) {
                if (cArray[n3 + n5] == string.charAt(n5)) continue;
                bl = false;
            }
        }
        n3 = bl ? --n3 : -1;
        return n3;
    }

    public static void charReplace(char[] cArray, char c, char c2, int n, int n2) {
        for (n = 0; n < n2; ++n) {
            if (cArray[n] != c) continue;
            cArray[n] = c2;
        }
    }

    public static void charInsert(char[] cArray, String string, char c, int n, int n2) {
        c = '\u0000';
        n = -1;
        do {
            int n3 = Utils.charIndexOf(cArray, string, (int)c, n2 - ++n);
            c = (char)n3;
            if (n3 == -1) continue;
            for (int i = c + '\u0001'; i < n2; ++i) {
                cArray[i + 1] = cArray[i];
            }
            cArray[c + '\u0001'] = 126;
        } while (c != '\uffffffff');
    }

    public static void charConcat(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n + n2] = cArray2[n2];
        }
    }

    public static final String getWordsFrom(int n, KRes kRes) {
        ((KFileBuffer)kRes.ro_ref).Seek(n + 1);
        return KUtils.readCompressedString((KFileBuffer)kRes.ro_ref, null).toString();
    }

    static {
        REFRESH_NEEDED_FULL = 1;
        REFRESH_NEEDED_PARTIAL = (byte)2;
        REFRESH_NEEDED_INTERRUPT = (byte)3;
        refresh = 0;
        s_savedClipInfo = null;
        loadingPercent = -1;
        s_progressBarType = (byte)-1;
        loadingCriticalPart = false;
        loadingIsActive = true;
        loading_x = 0;
        loading_y = 0;
        loading_width = 0;
        loading_height = 0;
        INDICATOR_HEIGHT = 0;
        indicatorsId = new byte[3];
        indicatorsText = new char[3][];
        indicatorsImage = new Image[3];
        indicRefId_image = new byte[3];
        FADE_WHITE_OFFSET = (byte)16;
        charBufferTmp = new char[50];
        charBuffer = new char[200];
        lengthVirtual = 0;
    }
}

