/*
 * Decompiled with CFR 0.152.
 */
package core;

import animation.AnimInstance;
import core.BoxData;
import core.ContentData;
import core.FontData;
import core.Game;
import core.HeapManager;
import core.PageData;
import core.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kernel.KCanvas;
import kernel.KFileBuffer;
import kernel.KFont;
import kernel.KGraphics;
import kernel.KRes;
import kernel.KResource;
import kernel.KUtils;

public final class CutScene {
    private static short pageOffsetX = (short)(Math.abs(KCanvas.m_width - 176) / 2);
    private static short pageOffsetY = (short)(Math.abs(KCanvas.m_height - 204) / 2);
    private byte state = 1;
    private byte resCount = 0;
    private byte nCurrentPage = 0;
    private byte nCurrentScene = 0;
    private byte nTotalScenes;
    private short nCurrentPos;
    private boolean bHasText = false;
    private long loadingTime = 0L;
    private int initialPercent = 0;
    private PageData[][] pageData;
    private boolean display = false;
    private int fadeInLevel = -1;
    private byte fadeType = 1;
    private static AnimInstance animInstance = null;
    private static KRes pictureImg = null;
    private static KRes background = null;
    private boolean backgroundDisplayed = false;
    private static KRes fileTxtKRes;
    private static KRes fileFpaksKRes;
    private static FontData[] fontData;
    private static KRes kfont;
    private static KRes kfontIndic;
    private static KRes kfontShadow;
    private static char[] text;
    private static short textLength;
    private static byte NONE;
    private boolean gameExit = false;

    public CutScene(int n) {
        Utils.iniBackBuffer(176, 204);
        this.ini(n, 13314);
        KUtils.updateElapsedMS();
        if (this.bHasText) {
            this.readFontFile(29786, 13315);
        }
        this.initialPercent = Utils.getLoadingPercent();
    }

    public final CutScene unload() {
        animInstance = null;
        pictureImg = null;
        if (fileTxtKRes != null) {
            fileTxtKRes = KResource.releaseRes(CutScene.fileTxtKRes.ro_hHandle);
        }
        if (fileFpaksKRes != null) {
            fileFpaksKRes = KResource.releaseRes(CutScene.fileFpaksKRes.ro_hHandle);
        }
        for (int n = 0; n < this.pageData.length; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < this.pageData[n].length; n2 = (int)((byte)(n2 + 1))) {
                for (int n3 = 0; n3 < this.pageData[n][n2].boxData.length; n3 = (int)((byte)(n3 + 1))) {
                    for (int n4 = 0; n4 < this.pageData[n][n2].boxData[n3].contentData.length; n4 = (int)((byte)(n4 + 1))) {
                        this.pageData[n][n2].boxData[n3].contentData[n4] = null;
                    }
                    this.pageData[n][n2].boxData[n3] = null;
                }
                this.pageData[n][n2] = null;
            }
            this.pageData[n] = null;
        }
        this.pageData = null;
        if (kfont != null) {
            HeapManager.instance.release(CutScene.kfont.ro_hHandle);
            kfont = null;
        }
        if (kfontShadow != null) {
            HeapManager.instance.release(CutScene.kfontShadow.ro_hHandle);
            kfontShadow = null;
        }
        if (kfontIndic != null) {
            HeapManager.instance.release(CutScene.kfontIndic.ro_hHandle);
            kfontIndic = null;
        }
        return null;
    }

    private void setState(byte by) {
        this.state = by;
        switch (by) {
            case 5: {
                Utils.setIndicator((byte)0, (byte)0);
                Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                if (!this.backgroundDisplayed) {
                    background = (KRes)HeapManager.instance.get(28673, (byte)1, 0);
                    KCanvas.s_instance.repaint();
                    KCanvas.s_instance.serviceRepaints();
                    background = null;
                }
                pictureImg = (KRes)HeapManager.instance.get(12289, (byte)1, 0);
                this.loadingTime = System.currentTimeMillis();
                if (this.fadeType == 1) {
                    this.fadeInLevel = 15;
                } else if (this.fadeType == 2) {
                    this.fadeInLevel = 0;
                }
                this.display = true;
                if (kfontIndic != null) {
                    HeapManager.instance.release(CutScene.kfontIndic.ro_hHandle);
                }
                kfontIndic = null;
                kfontIndic = (KRes)HeapManager.instance.get("fontCutScene.fpak", -3, false);
                return;
            }
            case 2: {
                this.fadeType = this.pageData[this.nCurrentScene][this.nCurrentPage].exit == 5 || this.pageData[this.nCurrentScene][this.nCurrentPage].exit == 6 ? (byte)2 : NONE;
                if (this.nCurrentPage + 1 < this.pageData[this.nCurrentScene].length) {
                    this.nCurrentPage = (byte)(this.nCurrentPage + 1);
                    if (!this.loadPage(this.nCurrentScene, this.nCurrentPage)) {
                        return;
                    }
                } else if (this.nCurrentScene + 1 < this.pageData.length) {
                    this.nCurrentScene = (byte)(this.nCurrentScene + 1);
                    if (!this.loadPage(this.nCurrentScene, 0)) {
                        return;
                    }
                } else {
                    if (1 == this.pageData[this.nCurrentScene].length) {
                        kfont = (KRes)HeapManager.instance.get("fontCutScene.fpak", -3, false);
                    }
                    this.gameExit = true;
                }
                this.setState((byte)4);
                return;
            }
            case 3: {
                if (this.nCurrentPage >= 0) {
                    if (!this.gameExit) {
                        if (this.nCurrentPage > 0) {
                            this.nCurrentPage = (byte)(this.nCurrentPage - 1);
                        }
                    } else {
                        this.gameExit = false;
                    }
                    this.fadeType = this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 5 || this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 6 ? (byte)1 : NONE;
                    this.loadPage(this.nCurrentScene, this.nCurrentPage);
                } else if (this.nCurrentScene > 0) {
                    this.nCurrentScene = (byte)(this.nCurrentScene - 1);
                    this.nCurrentPage = (byte)(this.pageData[this.nCurrentScene].length - 1);
                    this.fadeType = this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 5 || this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 6 ? (byte)1 : NONE;
                    this.loadPage(this.nCurrentScene, this.nCurrentPage);
                }
                this.setState((byte)5);
                return;
            }
            case 4: {
                if (Game.m_instance.m_extraMode) {
                    Utils.setIndicator((byte)2, (byte)0);
                }
                if (kfontIndic != null) {
                    HeapManager.instance.release(CutScene.kfontIndic.ro_hHandle);
                }
                kfontIndic = null;
                kfontIndic = (KRes)HeapManager.instance.get("fontCutScene.fpak", -3, false);
            }
        }
    }

    public final boolean move() {
        if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
            Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
            if (this.fadeType != 1) {
                this.fadeType = NONE;
            } else {
                this.fadeType = NONE;
                this.nCurrentPage = (byte)(this.nCurrentPage + 1);
            }
            this.backgroundDisplayed = false;
            this.setState((byte)3);
            return false;
        }
        switch (this.state) {
            case 1: {
                this.nCurrentPage = 0;
                this.loadPage(0, 0);
                this.fadeType = this.pageData[0][0].enter == 5 || this.pageData[0][0].enter == 6 ? (byte)1 : NONE;
                this.setState((byte)5);
                break;
            }
            case 4: {
                if (KCanvas.m_actionCode == 8) {
                    this.setState((byte)5);
                }
                if (KCanvas.m_actionCode != -6 || !Game.m_instance.m_extraMode) break;
                this.unload();
                return true;
            }
            case 5: {
                if (!this.display && this.gameExit) {
                    this.unload();
                    return true;
                }
                if (!(this.display || this.fadeType != 1 && this.fadeType != NONE)) {
                    pictureImg = null;
                    this.setState((byte)2);
                } else if (!this.display && this.fadeType == 2) {
                    this.fadeType = this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 5 || this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 6 ? (byte)1 : NONE;
                    this.setState((byte)5);
                }
                if (this.fadeType == 1) {
                    this.fadeInLevel = 15 - (int)((System.currentTimeMillis() - this.loadingTime) / 66L);
                    break;
                }
                if (this.fadeType != 2) break;
                this.fadeInLevel = (int)((System.currentTimeMillis() - this.loadingTime) / 66L);
            }
        }
        return false;
    }

    public final void frame() {
        if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
            return;
        }
        Graphics graphics = KGraphics.getGraphics();
        switch (this.state) {
            case 1: {
                Utils.drawIndicatorBG(graphics);
                return;
            }
            case 5: {
                if (!this.backgroundDisplayed) {
                    KGraphics.drawImage(background, 0, 0);
                    this.backgroundDisplayed = true;
                    return;
                }
                graphics.setColor(0);
                if (this.fadeType != 2) {
                    graphics.fillRect((int)pageOffsetX, (int)pageOffsetY, 176, 196);
                }
                if (this.fadeType == 1) {
                    Utils.drawBackbufferRegion(graphics, 0, 0, 176, 196, pageOffsetX, pageOffsetY);
                    Utils.drawIndicatorBG(graphics);
                    if (this.fadeInLevel < 0) {
                        this.display = false;
                    } else if (this.pageData[this.nCurrentScene][this.nCurrentPage].enter == 5) {
                        Utils.drawStipple(pictureImg, this.fadeInLevel, pageOffsetX, pageOffsetY, 176, 196);
                    } else {
                        Utils.drawStipple(pictureImg, this.fadeInLevel, pageOffsetX, pageOffsetY, 176, 196);
                    }
                } else if (this.fadeType == 2) {
                    if (this.fadeInLevel > 15) {
                        this.display = false;
                    } else {
                        if (this.pageData[this.nCurrentScene].length == 1) {
                            this.nCurrentPage = 1;
                        } else if (this.pageData[this.nCurrentScene].length == this.nCurrentPage + 1) {
                            this.nCurrentPage = (byte)(this.nCurrentPage + 1);
                        }
                        if (this.pageData[this.nCurrentScene][this.nCurrentPage - 1].exit == 5) {
                            Utils.drawStipple(pictureImg, this.fadeInLevel, pageOffsetX, pageOffsetY, 176, 196);
                            if (this.pageData[this.nCurrentScene].length == this.nCurrentPage) {
                                this.nCurrentPage = (byte)(this.nCurrentPage - 1);
                            }
                        } else {
                            Utils.drawStipple(pictureImg, this.fadeInLevel + Utils.FADE_WHITE_OFFSET, pageOffsetX, pageOffsetY, 176, 196);
                        }
                    }
                } else {
                    Utils.drawBackbufferRegion(graphics, 0, 0, 176, 196, pageOffsetX, pageOffsetY);
                    this.display = false;
                }
                graphics.setColor(0);
                graphics.drawRect(pageOffsetX - 1, pageOffsetY - 1, 177, 197);
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(pageOffsetX - 2, pageOffsetY - 2, 179, 199);
                if (Utils.getLoadingPercent() < -1) break;
                Utils.drawIndicatorBG(graphics);
                Utils.drawIndicators$bfed7fe((KFont)CutScene.kfontIndic.ro_ref);
                return;
            }
            case 4: {
                Utils.drawIndicatorBG(graphics);
                Utils.drawIndicators$bfed7fe((KFont)CutScene.kfontIndic.ro_ref);
                Utils.refresh = 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadPage(int n, int n2) {
        if (n >= this.nTotalScenes) return false;
        if (n < 0) return false;
        if (n2 >= this.pageData[n].length) return false;
        if (n2 < 0) {
            return false;
        }
        this.loadingTime = System.currentTimeMillis();
        Utils.loadingIni$252c3fc(20);
        if (Utils.getLoadingPercent() > 0) {
            Utils.loadingRefresh(Utils.getLoadingPercent() + 5);
        } else {
            Utils.loadingRefresh(0);
        }
        if (Utils.clearKeyIsEnable()) {
            return false;
        }
        int n3 = this.pageData[n][n2].boxData.length;
        Utils.getBackBufferGraphics().setColor(0);
        Utils.getBackBufferGraphics().fillRect(0, 0, Utils.BACK_BUFFER_WIDTH, Utils.BACK_BUFFER_HEIGHT);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4;
            BoxData boxData = this.pageData[n][n2].boxData[n4];
            CutScene cutScene = this;
            byte by = (byte)boxData.contentData.length;
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                int n6 = n5;
                byte by3 = by2;
                BoxData boxData2 = boxData;
                CutScene cutScene2 = cutScene;
                ContentData contentData = boxData2.contentData[by3];
                Graphics graphics = Utils.getBackBufferGraphics();
                if (contentData.type == 6) {
                    graphics.setClip((int)boxData2.left, (int)boxData2.top, boxData2.getWidth(), boxData2.getHeight());
                }
                Graphics graphics2 = KGraphics.setGraphics(graphics);
                switch (contentData.type) {
                    case 7: {
                        animInstance = (AnimInstance)HeapManager.instance.get(contentData.res_id, (byte)0, contentData.emotion);
                        ContentData contentData2 = contentData;
                        BoxData boxData3 = boxData2;
                        graphics.setClip((int)boxData3.left, (int)boxData3.top, boxData3.getWidth(), boxData3.getHeight());
                        animInstance.draw(contentData2.coord_X + boxData3.left, contentData2.coord_Y + boxData3.top, contentData2.flipx, contentData2.flipy);
                        animInstance = null;
                        break;
                    }
                    case 8: {
                        pictureImg = (KRes)HeapManager.instance.get(contentData.res_id, (byte)1, 0);
                        ContentData contentData3 = contentData;
                        BoxData boxData4 = boxData2;
                        contentData = graphics;
                        int n7 = 0;
                        if (contentData3.flipx) {
                            if (0 == contentData3.rotation) {
                                n7 = 2;
                            } else if (1 == contentData3.rotation) {
                                n7 = 7;
                            } else if (2 == contentData3.rotation) {
                                n7 = 1;
                            } else if (3 == contentData3.rotation) {
                                n7 = 4;
                            }
                        } else if (0 == contentData3.rotation) {
                            n7 = 0;
                        } else if (1 == contentData3.rotation) {
                            n7 = 5;
                        } else if (2 == contentData3.rotation) {
                            n7 = 3;
                        } else if (3 == contentData3.rotation) {
                            n7 = 6;
                        }
                        short s = (short)((Image)CutScene.pictureImg.ro_ref).getHeight();
                        int n8 = ((Image)CutScene.pictureImg.ro_ref).getWidth();
                        contentData.setClip(boxData4.left, boxData4.top, boxData4.getWidth(), boxData4.getHeight());
                        KGraphics.drawRegion(pictureImg, 0, 0, n8, (int)s, n7, contentData3.coord_X + boxData4.left, contentData3.coord_Y + boxData4.top);
                        pictureImg = null;
                        contentData.setClip(pageOffsetX, pageOffsetY, KCanvas.m_width - pageOffsetX, KCanvas.m_height - pageOffsetY);
                        break;
                    }
                    case 1: 
                    case 2: {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        short s10;
                        byte by4 = contentData.font_id;
                        kfont = (KRes)HeapManager.instance.get(CutScene.fontData[by4 - 1].filename, CutScene.fontData[by4 - 1].font_color, CutScene.fontData[by4 - 1].bold);
                        KGraphics.s_fontFG = (KFont)CutScene.kfont.ro_ref;
                        KGraphics.s_shadow = CutScene.fontData[by4 - 1].shadow;
                        if (CutScene.fontData[by4 - 1].shadow) {
                            kfontShadow = (KRes)HeapManager.instance.get(CutScene.fontData[by4 - 1].filename, CutScene.fontData[by4 - 1].shadow_color, CutScene.fontData[by4 - 1].bold);
                            KGraphics.s_fontBG = (KFont)CutScene.kfontShadow.ro_ref;
                            KGraphics.s_shadowOffsetX = CutScene.fontData[by4 - 1].offset_X;
                            KGraphics.s_shadowOffsetY = CutScene.fontData[by4 - 1].offset_Y;
                        }
                        Object object = contentData;
                        BoxData boxData5 = boxData2;
                        Graphics graphics3 = graphics;
                        String string = null;
                        StringBuffer stringBuffer = CutScene.getWordsFrom(((ContentData)object).res_id, fileTxtKRes);
                        string = stringBuffer.toString();
                        textLength = (short)stringBuffer.length();
                        stringBuffer.getChars(0, textLength, text, 0);
                        if (null != string) {
                            int n13;
                            int n14;
                            boolean bl;
                            byte by5;
                            int n15;
                            Graphics graphics4;
                            if (((ContentData)object).type == 1) {
                                graphics3.setClip((int)boxData5.left, (int)boxData5.top, boxData5.getWidth(), boxData5.getHeight());
                                s10 = textLength;
                                char[] cArray = text;
                                BoxData boxData6 = boxData5;
                                graphics4 = graphics3;
                                int n16 = ((ContentData)object).font_id - 1;
                                int n17 = CutScene.fontData[n16].label_color;
                                n15 = CutScene.fontData[n16].label;
                                by5 = (byte)(CutScene.fontData[n16].frame ? 1 : 0);
                                n16 = CutScene.fontData[n16].frame_color;
                                bl = false;
                                n14 = (short)(((ContentData)object).coord_X + boxData6.left);
                                n13 = ((ContentData)object).coord_Y + boxData6.top;
                                n12 = (short)((KFont)CutScene.kfont.ro_ref).m_height;
                                n11 = (short)((KFont)CutScene.kfont.ro_ref).textWidth(cArray, 0, s10);
                                if (((ContentData)object).alignment_H == 0) {
                                    n14 = (short)(n14 - n11 / 2);
                                } else if (((ContentData)object).alignment_H == 2) {
                                    n14 = (short)(n14 - n11);
                                }
                                bl = CutScene.isPaddingRequired(cArray, (short)0, s10);
                                n10 = (short)(n14 - 4);
                                n9 = n13;
                                short s2 = (short)(n9 + n12);
                                short s3 = (short)(n11 + n10 + 5);
                                if (bl) {
                                    s2 = (short)(s2 + 2);
                                }
                                if (n15 == 1) {
                                    graphics4.setColor(n17);
                                    graphics4.fillRect(n10, n9, s3 - n10 + 1, s2 - n9);
                                }
                                KGraphics.drawText(cArray, 0, s10, n14, n13);
                                if (by5 == 1) {
                                    graphics4.setColor(n16);
                                    graphics4.drawRect(n10, n9 - 1, s3 - n10, s2 - n9 + 1);
                                }
                                graphics3.setClip((int)pageOffsetX, (int)pageOffsetY, KCanvas.m_width - pageOffsetX, KCanvas.m_height - pageOffsetY);
                            } else if (((ContentData)object).type == 2) {
                                n11 = textLength;
                                char[] cArray = text;
                                ContentData contentData4 = object;
                                object = boxData5;
                                Graphics graphics5 = graphics3;
                                graphics4 = null;
                                by5 = (byte)(contentData4.font_id - 1);
                                bl = CutScene.fontData[by5].label;
                                n14 = CutScene.fontData[by5].label_color;
                                n13 = CutScene.fontData[by5].frame;
                                int n18 = CutScene.fontData[by5].frame_color;
                                boolean bl2 = false;
                                short s4 = 0;
                                short s5 = 0;
                                short s6 = ((BoxData)object).right;
                                short s7 = 0;
                                int n19 = 0;
                                n15 = 0;
                                n10 = (short)((KFont)CutScene.kfont.ro_ref).m_height;
                                int n20 = 0;
                                by5 = contentData4.alignment_V == 1 ? (byte)1 : 0;
                                do {
                                    s4 = ((BoxData)object).left;
                                    s7 = s5 = ((BoxData)object).top;
                                    if (n20 > 0 && by5 == 1) {
                                        by5 = 0;
                                        s7 = s5 = (short)(((BoxData)object).bottom - n10 * n20);
                                        n15 = ((BoxData)object).bottom;
                                    }
                                    if (n20 > 0 && bl) {
                                        bl = false;
                                        graphics5.setColor(n14);
                                        if (bl2) {
                                            n15 = (short)(n15 + 2);
                                        }
                                        graphics5.fillRect(s6 - 2, s7 - 1, n19 - s6 + 3, n15 - s7 + 1);
                                    }
                                    int n21 = n11 - 1;
                                    for (n15 = 0; n15 < n21 && cArray[n15] == ' '; n15 = (short)(n15 + 1)) {
                                    }
                                    while (n21 > n15 && cArray[n21] == ' ') {
                                        n21 = (short)(n21 - 1);
                                    }
                                    while (true) {
                                        short s8 = (short)((KFont)CutScene.kfont.ro_ref).textWidth(cArray, n15, n21 + 1 - n15);
                                        n12 = s8;
                                        if (s8 <= ((BoxData)object).getWidth()) break;
                                        int n22 = ((BoxData)object).getWidth();
                                        KFont kFont = (KFont)CutScene.kfont.ro_ref;
                                        char[] cArray2 = cArray;
                                        n12 = n15;
                                        n9 = n21;
                                        if (kFont.textWidth(cArray2, n12, n9 + 1 - n12) < n22) {
                                            n9 = 0;
                                        } else {
                                            while (kFont.textWidth(cArray2, n12, n9 - n12) > n22) {
                                                --n9;
                                                n9 = Utils.charLastIndexOf(cArray2, ' ', n9 - 1, n12);
                                            }
                                            n9 -= n12;
                                        }
                                        n9 = (short)n9;
                                        n12 = (short)((KFont)CutScene.kfont.ro_ref).textWidth(cArray, n15, n9);
                                        if (contentData4.alignment_H == 0) {
                                            s4 = (short)((short)((short)(((BoxData)object).getWidth() / 2) + ((BoxData)object).left) - n12 / 2);
                                        } else if (contentData4.alignment_H == 2) {
                                            s4 = (short)(((BoxData)object).right - n12);
                                        }
                                        if (by5 == 0 && !bl) {
                                            KGraphics.drawText(cArray, n15, n9, s4, s5);
                                        } else {
                                            n20 = (byte)(n20 + 1);
                                        }
                                        if (s4 < s6) {
                                            s6 = s4;
                                        }
                                        if (s4 + n12 > n19) {
                                            n19 = (short)(s4 + n12);
                                        }
                                        s5 = (short)(s5 + n10);
                                        n15 = (short)(n15 + (n9 + 1));
                                    }
                                    bl2 = CutScene.isPaddingRequired(cArray, (short)n15, (short)(n21 + 1 - n15));
                                    if (contentData4.alignment_H == 0) {
                                        s4 = (short)((short)((short)(((BoxData)object).getWidth() / 2) + ((BoxData)object).left) - n12 / 2);
                                    } else if (contentData4.alignment_H == 2) {
                                        s4 = (short)(((BoxData)object).right - n12);
                                    }
                                    if (by5 == 0 && !bl) {
                                        KGraphics.drawText(cArray, n15, n21 + 1 - n15, s4, s5);
                                    } else {
                                        n20 = (byte)(n20 + 1);
                                    }
                                    if (s4 + n12 > n19) {
                                        n19 = (short)(s4 + n12);
                                    }
                                    if (s4 < s6) {
                                        s6 = s4;
                                    }
                                    s6 = (short)(s6 - 2);
                                    n19 = (short)(n19 + 1);
                                    n15 = (short)(s5 + n10);
                                } while (by5 == 1 || bl);
                                if (n13 == 1) {
                                    graphics5.setColor(n18);
                                    if (bl2) {
                                        n15 = (short)(n15 + 2);
                                    }
                                    graphics5.drawRect((int)s6, s7 - 1, n19 - s6, n15 - s7 + 1);
                                }
                            }
                        }
                        HeapManager.instance.release(CutScene.kfont.ro_hHandle);
                        kfont = null;
                        if (kfontShadow == null) break;
                        HeapManager.instance.release(CutScene.kfontShadow.ro_hHandle);
                        kfontShadow = null;
                        break;
                    }
                    case 6: {
                        int n10;
                        ContentData contentData5 = contentData;
                        BoxData boxData7 = boxData2;
                        contentData = graphics;
                        boolean bl = false;
                        byte[] byArray = new byte[]{2, 3, 1, 2, 3, 5, 2, 1, 4, 4, 3, 1, 2, 5, 4, 2, 1, 2, 3, 4, 2};
                        int n23 = contentData5.fore_color;
                        int n8 = (short)(contentData5.coord_X + boxData7.left);
                        short s = (short)(contentData5.coord_Y + boxData7.top);
                        if (contentData5.style == 1) {
                            bl = true;
                        }
                        contentData.setClip(boxData7.left, boxData7.top, boxData7.getWidth(), boxData7.getHeight());
                        short s9 = (short)(KCanvas.m_width - pageOffsetX);
                        contentData.setColor(n23);
                        int n11 = (short)(s9 * 3);
                        n8 = (short)(n8 - (n11 >> 1));
                        s = (short)(s - (n11 >> 1));
                        int n24 = 0;
                        while (n24 < 360) {
                            for (n23 = 0; n23 < 20; n23 = (int)((short)(n23 + 1))) {
                                if (bl) {
                                    n24 = (short)(n24 + byArray[n23]);
                                    n10 = byArray[n23 + 1];
                                } else {
                                    n24 = (short)(n24 + 2);
                                    n10 = 2;
                                }
                                if (n23 % 2 != 0 || n24 >= 360) continue;
                                contentData.fillArc(n8, s, n11, n11, n24, n10);
                            }
                        }
                        contentData.setClip(pageOffsetX, pageOffsetY, KCanvas.m_width - pageOffsetX, KCanvas.m_height - pageOffsetY);
                        break;
                    }
                    case 5: {
                        int n10;
                        int n11;
                        int n12;
                        ContentData contentData6 = contentData;
                        BoxData boxData8 = boxData2;
                        contentData = graphics;
                        int n8 = 0;
                        short s = 0;
                        byte[] byArray = new byte[]{2, 3, 1, 2, 3, 5, 2, 1, 4, 4, 3, 1, 2, 5, 4, 2, 1, 2, 3, 4, 2};
                        int n25 = contentData6.fore_color;
                        if (contentData6.style == 1) {
                            s = 1;
                        }
                        if (contentData6.direction == 0) {
                            n8 = 1;
                        }
                        contentData.setClip(boxData8.left, boxData8.top, boxData8.getWidth(), boxData8.getHeight());
                        int n26 = KCanvas.m_width - pageOffsetX;
                        int n27 = KCanvas.m_height - pageOffsetY;
                        contentData.setColor(n25);
                        if (n8 == 1) {
                            n12 = n26;
                            n11 = n27;
                        } else {
                            n12 = n27;
                            n11 = n26;
                        }
                        int n28 = 0;
                        while (n28 < n12) {
                            for (n25 = 0; n25 < 20; n25 = (int)((short)(n25 + 1))) {
                                if (s == 1) {
                                    n28 = (short)(n28 + byArray[n25]);
                                    n10 = byArray[n25 + 1];
                                } else {
                                    n28 = (short)(n28 + 2);
                                    n10 = 2;
                                }
                                if (n25 % 2 != 0 || n28 >= n12) continue;
                                if (n8 == 1) {
                                    contentData.fillRect(n28, 0, n10, n11);
                                    continue;
                                }
                                contentData.fillRect(0, n28, n11, n10);
                            }
                        }
                        contentData.setClip(pageOffsetX, pageOffsetY, KCanvas.m_width - pageOffsetX, KCanvas.m_height - pageOffsetY);
                        break;
                    }
                    case 4: {
                        int n8;
                        short s;
                        ContentData contentData7 = contentData;
                        BoxData boxData9 = boxData2;
                        contentData = graphics;
                        KRes kRes = null;
                        int n29 = contentData7.back_color;
                        int n30 = contentData7.fore_color;
                        short s10 = boxData9.left;
                        int n11 = boxData9.top;
                        int n12 = boxData9.getWidth();
                        int n10 = boxData9.getHeight();
                        int n9 = 0;
                        contentData.setClip(boxData9.left, boxData9.top, boxData9.getWidth(), boxData9.getHeight());
                        if (contentData7.direction == 0) {
                            n9 = 1;
                        }
                        if (n9 == 1) {
                            n8 = n10;
                            s = (short)(n12 / 8);
                        } else {
                            s = (short)(n10 / 8);
                            n8 = n12;
                        }
                        kRes = KResource.addUserResource(KGraphics.createGradient(n8, n29, n30, n9 != 0));
                        for (n29 = 0; n29 < s; n29 = (int)((byte)(n29 + 1))) {
                            KGraphics.drawImage(kRes, (int)s10, n11);
                            if (n9 == 1) {
                                s10 = (short)(s10 + 8);
                                continue;
                            }
                            n11 = (short)(n11 + 8);
                        }
                        if (n9 == 1) {
                            s = (short)(n12 % 8);
                            s10 = (short)(s10 - (8 - s));
                        } else {
                            s = (short)(n10 % 8);
                            n11 = (short)(n11 - (8 - s));
                        }
                        if (s > 0) {
                            KGraphics.drawImage(kRes, (int)s10, n11);
                        }
                        if (kRes == null) break;
                        KResource.releaseRes(kRes.ro_hHandle);
                        break;
                    }
                    case 3: {
                        ContentData contentData8 = contentData;
                        BoxData boxData10 = boxData2;
                        contentData = graphics;
                        contentData.setColor(contentData8.fore_color);
                        contentData.setClip(boxData10.left, boxData10.top, boxData10.getWidth(), boxData10.getHeight());
                        contentData.fillRect(boxData10.left, boxData10.top, boxData10.getWidth(), boxData10.getHeight());
                        contentData.setClip(pageOffsetX, pageOffsetY, KCanvas.m_width - pageOffsetX, KCanvas.m_height - pageOffsetY);
                    }
                }
                if (boxData2.bordered) {
                    graphics.setColor(boxData2.frame_color);
                    graphics.setClip((int)boxData2.left, (int)boxData2.top, boxData2.getWidth(), boxData2.getHeight());
                    graphics.drawRect((int)boxData2.left, (int)boxData2.top, boxData2.getWidth() - 1, boxData2.getHeight() - 1);
                }
                graphics.setClip(0, 0, Utils.BACK_BUFFER_WIDTH, Utils.BACK_BUFFER_HEIGHT);
                KGraphics.setGraphics(graphics2);
                if (System.currentTimeMillis() - cutScene2.loadingTime > 700L) {
                    int n31 = cutScene2.pageData[cutScene2.nCurrentScene][cutScene2.nCurrentPage].boxData.length;
                    int n32 = boxData2.contentData.length;
                    int n33 = 100000;
                    if (n31 - 2 > 0) {
                        n33 = 100000 / (n31 - 2);
                    }
                    n32 = n33 / n32;
                    n32 = (n6 * n33 + by3 * n32) / 1000;
                    if ((n32 = cutScene2.initialPercent + n32 - Utils.getLoadingPercent() * n32 / 100) < Utils.getLoadingPercent()) {
                        n32 = Utils.getLoadingPercent();
                    }
                    if (n6 != n31 - 1 && !Utils.loadingRefresh(n32)) {
                        return false;
                    }
                    cutScene2.loadingTime = System.currentTimeMillis();
                }
                if (n6 == cutScene2.pageData[cutScene2.nCurrentScene][cutScene2.nCurrentPage].boxData.length - 1) {
                    Utils.loadingRefresh(100);
                    cutScene2.initialPercent = 0;
                    if (Utils.clearKeyIsEnable()) {
                        return false;
                    }
                }
                boolean bl = true;
                if (bl) continue;
                return false;
            }
            boolean bl = true;
            if (!bl) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private static boolean isPaddingRequired(char[] cArray, short s, short s2) {
        boolean bl = false;
        if (Utils.charIndexOf(cArray, 'g', (int)s, (int)s2) >= 0 || Utils.charIndexOf(cArray, 'j', (int)s, (int)s2) >= 0 || Utils.charIndexOf(cArray, 'y', (int)s, (int)s2) >= 0 || Utils.charIndexOf(cArray, 'p', (int)s, (int)s2) >= 0 || Utils.charIndexOf(cArray, 'q', (int)s, (int)s2) >= 0) {
            bl = true;
        }
        return bl;
    }

    private static StringBuffer getWordsFrom(int n, KRes kRes) {
        ((KFileBuffer)kRes.ro_ref).Seek(n + 1);
        return KUtils.readCompressedString((KFileBuffer)kRes.ro_ref, null);
    }

    private static int convertNegativeValue$255f288(int n) {
        if (n >= 2048) {
            n = 4095 - n;
            ++n;
            n = -n;
        }
        return n;
    }

    private static byte convertNegativeValue$252a9a1(byte by) {
        if (by >= 8) {
            by = -((byte)((byte)(15 - by) + 1));
        }
        return by;
    }

    private void ini(int n, int n2) {
        int n3;
        int n4;
        byte by;
        Object object = KResource.load(n, 125);
        Object object2 = (KFileBuffer)((KRes)object).ro_ref;
        KUtils.updateElapsedMS();
        KFileBuffer kFileBuffer = object2;
        object2 = this;
        byte[] byArray = null;
        ((CutScene)object2).resCount = 0;
        ((CutScene)object2).nCurrentPos = 1;
        int n5 = 0;
        boolean bl = false;
        ((CutScene)object2).nTotalScenes = kFileBuffer.readBytes(0, 1, null)[0];
        ((CutScene)object2).pageData = new PageData[((CutScene)object2).nTotalScenes][];
        for (by = 0; by < ((CutScene)object2).nTotalScenes; by = (byte)(by + 1)) {
            Object object3 = kFileBuffer;
            short s = ((CutScene)object2).nCurrentPos;
            Object object4 = null;
            if (object3 != null) {
                boolean bl2 = false;
                object4 = ((KFileBuffer)object3).readBytes(s, 2, null);
            }
            byArray = object4;
            n4 = object4[1];
            ((CutScene)object2).nCurrentPos = (short)(((CutScene)object2).nCurrentPos + byArray.length);
            ((CutScene)object2).pageData[by] = new PageData[n4];
            for (n3 = 0; n3 < n4; n3 = (int)((byte)(n3 + 1))) {
                object3 = kFileBuffer;
                s = ((CutScene)object2).nCurrentPos;
                object4 = null;
                if (object3 != null) {
                    boolean bl3 = false;
                    object4 = ((KFileBuffer)object3).readBytes(s, 6, null);
                }
                byArray = object4;
                ((CutScene)object2).pageData[by][n3] = new PageData();
                object3 = ((CutScene)object2).pageData[by][n3];
                byte[] byArray2 = byArray;
                ((PageData)object3).enter = (byte)(byArray2[5] >> 4 & 0xF);
                ((PageData)object3).exit = (byte)(byArray2[5] & 0xF);
                if (((CutScene)object2).pageData[by][n3].enter == 5 || ((CutScene)object2).pageData[by][n3].enter == 6) {
                    ((CutScene)object2).resCount = (byte)(((CutScene)object2).resCount + 1);
                }
                byte by2 = byArray[1];
                ((CutScene)object2).nCurrentPos = (short)(((CutScene)object2).nCurrentPos + byArray.length);
                ((CutScene)object2).pageData[by][n3].boxData = new BoxData[by2];
                for (byte by3 = 0; by3 < by2; by3 = (byte)(by3 + 1)) {
                    object3 = kFileBuffer;
                    short s2 = ((CutScene)object2).nCurrentPos;
                    object4 = null;
                    if (object3 != null) {
                        boolean bl4 = false;
                        byte[] byArray3 = ((KFileBuffer)object3).readBytes(s2, 1, null);
                        n5 = 1 == (byArray3[0] & 1) ? 10 : 7;
                        boolean bl5 = false;
                        object4 = ((KFileBuffer)object3).readBytes(s2, n5, null);
                    }
                    byArray = object4;
                    ((CutScene)object2).nCurrentPos = (short)(((CutScene)object2).nCurrentPos + byArray.length);
                    ((CutScene)object2).pageData[by][n3].boxData[by3] = new BoxData();
                    object4 = ((CutScene)object2).pageData[by][n3].boxData[by3];
                    object3 = byArray;
                    Object var12_29 = null;
                    object4.content_count = (byte)(object3[0] >> 4 & 0xF);
                    if (1 == (object3[0] & 1)) {
                        object4.bordered = true;
                        object4.frame_color = n5 = (((object3[7] & 0xFF) << 8) + (object3[8] & 0xFF) << 8) + (object3[9] & 0xFF);
                    } else {
                        object4.bordered = false;
                        object4.frame_color = 0;
                    }
                    short s3 = 0;
                    object4.left = s3 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)object3[1] << 4) + (object3[2] >> 4 & 0xF)));
                    object4.top = s3 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)(object3[2] & 0xF) << 8) + (object3[3] & 0xFF)));
                    object4.right = s3 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)object3[4] << 4) + (object3[5] >> 4 & 0xF)));
                    object4.bottom = s3 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)(object3[5] & 0xF) << 8) + (object3[6] & 0xFF)));
                    byte by4 = ((CutScene)object2).pageData[by][n3].boxData[by3].content_count;
                    ((CutScene)object2).pageData[by][n3].boxData[by3].contentData = new ContentData[by4];
                    for (byte by5 = 0; by5 < by4; by5 = (byte)(by5 + 1)) {
                        object3 = kFileBuffer;
                        short s4 = ((CutScene)object2).nCurrentPos;
                        object4 = null;
                        s3 = 0;
                        if (object3 != null) {
                            boolean bl6 = false;
                            object4 = ((KFileBuffer)object3).readBytes(s4, 1, null);
                            byte by6 = (byte)(object4[0] >> 4 & 0xF);
                            n5 = by6;
                            if (by6 == 0) {
                                s3 = 1;
                            } else if (n5 == 1) {
                                s3 = (short)7;
                            } else if (n5 == 2) {
                                s3 = (short)4;
                            } else if (n5 == 3) {
                                s3 = (short)4;
                            } else if (n5 == 4) {
                                s3 = (short)7;
                            } else if (n5 == 5) {
                                s3 = (short)4;
                            } else if (n5 == 6) {
                                s3 = (short)7;
                            } else if (n5 == 7) {
                                s3 = (short)7;
                            } else if (n5 == 8) {
                                s3 = (short)6;
                            }
                            if (s3 != 0) {
                                n5 = s3;
                                boolean bl7 = false;
                                object4 = ((KFileBuffer)object3).readBytes(s4, n5, null);
                            }
                        }
                        byArray = object4;
                        ((CutScene)object2).pageData[by][n3].boxData[by3].contentData[by5] = new ContentData();
                        object4 = ((CutScene)object2).pageData[by][n3].boxData[by3].contentData[by5];
                        object3 = byArray;
                        Object var12_31 = null;
                        object4.type = 0;
                        object4.res_id = 0;
                        object4.font_id = 0;
                        object4.alignment_H = 0;
                        object4.alignment_V = 0;
                        object4.coord_X = 0;
                        object4.coord_Y = 0;
                        object4.direction = 0;
                        object4.style = 0;
                        object4.flipx = false;
                        object4.flipy = false;
                        object4.rotation = 0;
                        object4.fore_color = 0;
                        object4.back_color = 0xFFFFFF;
                        object4.emotion = 0;
                        n5 = (byte)(object3[0] >> 4 & 0xF);
                        object4.type = (byte)n5;
                        if (n5 != 0) {
                            if (n5 == 1) {
                                object4.alignment_H = (byte)(object3[0] & 0xC);
                                object4.alignment_H = (byte)(object4.alignment_H >> 2);
                                short s5 = (short)(object3[1] & 0xF);
                                object4.font_id = (byte)s5;
                                object4.res_id = s5 = (short)((short)((short)(object3[2] & 0xFF) << 8) + (object3[3] & 0xFF));
                                object4.coord_X = s5 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)object3[4] << 4) + (object3[5] >> 4 & 0xF)));
                                object4.coord_Y = s5 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)(object3[5] & 0xF) << 8) + (object3[6] & 0xFF)));
                            } else if (n5 == 2) {
                                object4.alignment_H = (byte)(object3[0] & 0xC);
                                object4.alignment_H = (byte)(object4.alignment_H >> 2);
                                object4.alignment_V = (byte)(object3[0] & 3);
                                short s6 = (short)object3[1];
                                object4.font_id = (byte)s6;
                                object4.res_id = s6 = (short)((short)((short)(object3[2] & 0xFF) << 8) + (object3[3] & 0xFF));
                            } else if (n5 == 3) {
                                s3 = (short)((((object3[1] & 0xFF) << 8) + (object3[2] & 0xFF) << 8) + (object3[3] & 0xFF));
                                object4.fore_color = s3;
                            } else if (n5 == 4) {
                                if (4 == (object3[0] & 4)) {
                                    object4.direction = 1;
                                }
                                s3 = (short)((((object3[1] & 0xFF) << 8) + (object3[2] & 0xFF) << 8) + (object3[3] & 0xFF));
                                object4.fore_color = s3;
                                s3 = (short)((((object3[4] & 0xFF) << 8) + (object3[5] & 0xFF) << 8) + (object3[6] & 0xFF));
                                object4.back_color = s3;
                            } else if (n5 == 5) {
                                if (4 == (object3[0] & 4)) {
                                    object4.direction = 1;
                                }
                                if (1 == (object3[0] & 1)) {
                                    object4.style = 1;
                                }
                                s3 = (short)((((object3[1] & 0xFF) << 8) + (object3[2] & 0xFF) << 8) + (object3[3] & 0xFF));
                                object4.fore_color = s3;
                            } else if (n5 == 6) {
                                if (1 == (object3[0] & 1)) {
                                    object4.style = 1;
                                }
                                s3 = (short)((((object3[1] & 0xFF) << 8) + (object3[2] & 0xFF) << 8) + (object3[3] & 0xFF));
                                object4.fore_color = s3;
                                short s7 = 0;
                                object4.coord_X = s7 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)object3[4] << 4) + (object3[5] >> 4 & 0xF)));
                                object4.coord_Y = s7 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)(object3[5] & 0xF) << 8) + (object3[6] & 0xFF)));
                            } else if (n5 == 7) {
                                if ((object3[0] & 0xC) >> 2 == 3) {
                                    object4.flipx = true;
                                    object4.flipy = true;
                                } else {
                                    if ((object3[0] & 4) >> 2 == 1) {
                                        object4.flipx = true;
                                    }
                                    if ((object3[0] & 8) >> 3 == 1) {
                                        object4.flipy = true;
                                    }
                                }
                                short s8 = 0;
                                object4.res_id = s8 = (short)((short)((short)(object3[1] & 0xFF) << 8) + (object3[2] & 0xFF));
                                s8 = (short)object3[3];
                                object4.emotion = (byte)s8;
                                object4.coord_X = s8 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)object3[4] << 4) + (object3[5] >> 4 & 0xF)));
                                object4.coord_Y = s8 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)(object3[5] & 0xF) << 8) + (object3[6] & 0xFF)));
                            } else if (n5 == 8) {
                                if (4 == (object3[0] & 4)) {
                                    object4.flipx = true;
                                }
                                object4.rotation = (byte)(object3[0] & 3);
                                short s9 = 0;
                                object4.res_id = s9 = (short)((short)((short)(object3[1] & 0xFF) << 8) + (object3[2] & 0xFF));
                                object4.coord_X = s9 = (short)CutScene.convertNegativeValue$255f288((short)((short)((short)object3[3] << 4) + (object3[4] >> 4 & 0xF)));
                                object4.coord_Y = s9 = (short)CutScene.convertNegativeValue$255f288((short)((short)object3[5] | object3[5] & 0xFF));
                            }
                        }
                        if (((CutScene)object2).pageData[by][n3].boxData[by3].contentData[by5].type == 7 || ((CutScene)object2).pageData[by][n3].boxData[by3].contentData[by5].type == 8 || ((CutScene)object2).pageData[by][n3].boxData[by3].contentData[by5].type == 1 || ((CutScene)object2).pageData[by][n3].boxData[by3].contentData[by5].type == 2) {
                            ((CutScene)object2).resCount = (byte)(((CutScene)object2).resCount + 1);
                        }
                        ((CutScene)object2).nCurrentPos = (short)(((CutScene)object2).nCurrentPos + byArray.length);
                    }
                }
            }
        }
        if (object != null) {
            KResource.releaseRes(((KRes)object).ro_hHandle);
        }
        object = new short[this.resCount];
        object2 = new byte[this.resCount];
        int n6 = 0;
        for (int n7 = 0; n7 < this.pageData.length; n7 = (int)((byte)(n7 + 1))) {
            for (by = 0; by < this.pageData[n7].length; by = (byte)(by + 1)) {
                for (n4 = 0; n4 < this.pageData[n7][by].boxData.length; n4 = (int)((byte)(n4 + 1))) {
                    for (n3 = 0; n3 < this.pageData[n7][by].boxData[n4].contentData.length; n3 = (int)((byte)(n3 + 1))) {
                        if (this.pageData[n7][by].boxData[n4].contentData[n3].type == 7 || this.pageData[n7][by].boxData[n4].contentData[n3].type == 8) {
                            object[n6] = this.pageData[n7][by].boxData[n4].contentData[n3].res_id;
                            object2[n6] = this.pageData[n7][by].boxData[n4].contentData[n3].type == 8;
                            n6 = (byte)(n6 + 1);
                        }
                        if (this.bHasText || this.pageData[n7][by].boxData[n4].contentData[n3].type != 1 && this.pageData[n7][by].boxData[n4].contentData[n3].type != 2) continue;
                        this.bHasText = true;
                    }
                }
                if (this.pageData[n7][by].enter < 5 && this.pageData[n7][by].exit < 5) continue;
                object[n6] = 12289;
                object2[n6] = true;
                n6 = (byte)(n6 + 1);
            }
        }
        if (((Object)object).length > 0 && ((Object)object2).length > 0) {
            HeapManager.instance.set((short[])object, (byte[])object2);
        }
        if (this.bHasText) {
            fileTxtKRes = KResource.load(13314, 11);
        }
    }

    private void readFontFile(int n, int n2) {
        int n3 = 0;
        Object var4_4 = null;
        if (((CutScene)((Object)kRes)).bHasText) {
            fileFpaksKRes = KResource.load(13315, 11);
        }
        KRes kRes = KResource.load(29786, 125);
        KFileBuffer kFileBuffer = (KFileBuffer)kRes.ro_ref;
        int n4 = 0;
        boolean bl = false;
        Object object = null;
        n = kFileBuffer.readBytes(0, 1, null)[0];
        fontData = new FontData[n];
        n3 = 1;
        for (n2 = 0; n2 < n; n2 = (int)((byte)(n2 + 1))) {
            Object object2 = kFileBuffer;
            n4 = n3;
            object = null;
            int n5 = 6;
            if (object2 != null) {
                boolean bl2 = false;
                byte[] byArray = ((KFileBuffer)object2).readBytes(n4, 1, null);
                if ((byArray[0] & 4) != 0) {
                    n5 = 9;
                }
                if ((byArray[0] & 2) != 0) {
                    n5 = (byte)(n5 + 3);
                }
                if ((byArray[0] & 1) != 0) {
                    n5 = (byte)(n5 + 4);
                }
                int n6 = n4;
                n4 = n5;
                boolean bl3 = false;
                object = ((KFileBuffer)object2).readBytes(n6, n4, null);
            }
            FontData fontData = object;
            n3 = (short)(n3 + (fontData).length);
            CutScene.fontData[n2] = new FontData();
            object = CutScene.fontData[n2];
            object2 = fontData;
            n4 = 0;
            ((FontData)object).bold = false;
            ((FontData)object).label = false;
            ((FontData)object).frame = false;
            ((FontData)object).shadow = false;
            if ((object2[0] & 8) != 0) {
                ((FontData)object).bold = true;
            }
            if ((object2[0] & 4) != 0) {
                ((FontData)object).label = true;
            }
            if ((object2[0] & 2) != 0) {
                ((FontData)object).frame = true;
            }
            if ((object2[0] & 1) != 0) {
                ((FontData)object).shadow = true;
            }
            n5 = (short)((short)((short)(object2[1] & 0xFF) << 8) + (object2[2] & 0xFF));
            ((FontData)object).filename = new String(CutScene.getWordsFrom(n5, fileFpaksKRes));
            ((FontData)object).font_color = n4 = (((object2[3] & 0xFF) << 8) + (object2[4] & 0xFF) << 8) + (object2[5] & 0xFF);
            n5 = 6;
            if (((FontData)object).label) {
                ((FontData)object).label_color = n4 = (((object2[6] & 0xFF) << 8) + (object2[7] & 0xFF) << 8) + (object2[8] & 0xFF);
                n5 = 9;
            }
            if (((FontData)object).frame) {
                ((FontData)object).frame_color = n4 = (((object2[n5] & 0xFF) << 8) + (object2[n5 + 1] & 0xFF) << 8) + (object2[n5 + 2] & 0xFF);
                n5 = (short)(n5 + 3);
            }
            if (!((FontData)object).shadow) continue;
            ((FontData)object).shadow_color = n4 = (((object2[n5] & 0xFF) << 8) + (object2[n5 + 1] & 0xFF) << 8) + (object2[n5 + 2] & 0xFF);
            n5 = (short)(n5 + 3);
            n4 = CutScene.convertNegativeValue$252a9a1((byte)(object2[n5] >> 4 & 0xF));
            ((FontData)object).offset_X = (byte)n4;
            n4 = CutScene.convertNegativeValue$252a9a1((byte)(object2[n5] & 0xF));
            ((FontData)object).offset_Y = (byte)n4;
        }
        if (kRes != null) {
            KResource.releaseRes(kRes.ro_hHandle);
        }
    }

    public static void unloadFont() {
        if (kfont != null) {
            HeapManager.instance.release(CutScene.kfont.ro_hHandle);
            kfont = null;
        }
        if (kfontShadow != null) {
            HeapManager.instance.release(CutScene.kfontShadow.ro_hHandle);
            kfontShadow = null;
        }
        if (kfontIndic != null) {
            HeapManager.instance.release(CutScene.kfontIndic.ro_hHandle);
            kfontIndic = null;
        }
    }

    static {
        kfont = null;
        kfontIndic = null;
        kfontShadow = null;
        text = new char[250];
        textLength = 0;
        NONE = (byte)-1;
    }
}

