/*
 * Decompiled with CFR 0.152.
 */
package core;

import animation.AnimInstance;
import core.BattleTakeData;
import core.Game;
import core.HeapManager;
import core.RBSound;
import core.StoryManager;
import core.TextViewport;
import core.Tutorial;
import core.Utils;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kernel.KCanvas;
import kernel.KFileBuffer;
import kernel.KFont;
import kernel.KGraphics;
import kernel.KMath;
import kernel.KRes;
import kernel.KResource;
import kernel.KUtils;

public final class Battle {
    private static byte rankMaxPoints;
    private final int nPos18 = KCanvas.m_width / 8;
    private final int nPos14 = KCanvas.m_width / 4;
    private final int nPos34 = KCanvas.m_width * 3 / 4;
    private final int nPos78 = KCanvas.m_width * 7 / 8;
    private final int nPos116 = KCanvas.m_width / 16;
    private final int nPos38 = KCanvas.m_width * 3 / 8;
    private final int nPos58 = KCanvas.m_width * 5 / 8;
    private final int nPos12 = KCanvas.m_width / 2;
    private final int nPos26 = (KCanvas.m_width << 1) / 6;
    private final int nPos46 = (KCanvas.m_width << 2) / 6;
    private final int nPos56 = KCanvas.m_width * 5 / 6;
    private static final char[] TARGET_TEXT_SAMPLE;
    private static int SPACE_WIDTH;
    private static int TARGET_TEXT_WIDTH;
    private static byte m_state;
    private boolean m_battleRunning;
    public static boolean loadTutoPartEnable;
    private byte battleTakeID = 0;
    private byte battleType = 0;
    private byte level = 0;
    private byte threshold = 0;
    private byte rapper = 0;
    private byte opponent = 0;
    private byte rapperPartner = 0;
    private byte opponentPartner = 0;
    private byte location = 0;
    private byte loop = 0;
    private byte coop1stWordPercent = (byte)20;
    private byte coop2ndWordPercent = (byte)40;
    private byte mode;
    private byte para;
    private byte line;
    private int nLastLine;
    private boolean changeLine = false;
    private boolean lineScoreDisplayed = false;
    private boolean bMustDeleteTarget = false;
    private boolean bTargetDeleted = false;
    private int ballX;
    private int ballY;
    private int displayX;
    private int displayY;
    private int targetX;
    private int lastDisplayX;
    private int targetWordWidth;
    private int selectedX;
    private int selectedY;
    private int[] meterPositionX = new int[4];
    private int[] meterPositionY = new int[4];
    private byte tapsSucceed;
    private byte tapsMem = 0;
    private int score;
    private byte accuracy;
    private byte word;
    private int bonus;
    private int tmpBonus = 0;
    private short wordSelected;
    private byte wordStreak;
    private int pullback = 0;
    private int cpt_wordWrong;
    private int cpt_wordGood;
    private int cpt_wordBest;
    private int cpt_accMissed;
    private int cpt_accOk;
    private int cpt_accGood;
    private int cpt_accPerfect;
    private int cpt_blockMissed;
    private int cpt_rankPoints;
    private boolean lastHitSucceed;
    private boolean displayAnswer;
    private boolean bRoundLoaded = true;
    private boolean bNoTap;
    private boolean bStatsDisplayed;
    private boolean bPullingBack;
    public boolean bIntroDrawn = false;
    private boolean bInitialized;
    private boolean bAnswerGiven;
    private boolean bStateTutorial;
    private boolean bStateResume;
    private boolean bResumeDrawBubble = false;
    private boolean bRefreshedTopBattle = true;
    public static boolean bFiveActivated;
    public static boolean bTutorialMode;
    private static boolean tutorialFoldNotePad;
    private int currentPos;
    private int lastScrollPos = -1;
    private int scrollPos;
    private long currentTime;
    private int previousSilentTime;
    private long startTime;
    private long loopLapseTime;
    private long displayDelayTime;
    private int currentTempo;
    private int nPercentMax;
    private int nPercent;
    private int nHoldSlidePercent;
    private byte currentColorSet = 0;
    private long holdEndTime;
    private long holdStartTime;
    private long holdBeginTime;
    private long holdFinishTime;
    private boolean holdButton;
    private int leftTarget;
    private int rightTarget;
    private char[] charBufferWord = new char[9];
    private char[] charBufferZero = new char[8];
    private byte charBufferZeroLength = 0;
    private char[] charBufferByte = new char[15];
    private byte charBufferByteLength = 0;
    private char[][] charLyrics = new char[4][100];
    private char[][] charBeats = new char[4][100];
    private char[][] charTaps = new char[4][100];
    private short[] charBeatsLength = new short[4];
    private short[] charLyricsLength = new short[4];
    private short[] charTapsLength = new short[4];
    private int m_lastKeyPressed;
    private int m_keysSequence;
    private byte[] m_tapsPositions = new byte[8];
    private short[] keys = new short[]{2, 8, 4, 16};
    private static final int[] WORD_SCORE;
    private String[][] m_WordsBank = new String[4][];
    private int[][] m_WordsBankLenght = new int[4][];
    private int[] m_WordsBankScore = new int[4];
    private static byte COLOR_FLASH_TARGET;
    private static int[] m_ColorsSettings;
    private int[][] m_LinesDisplayArray = new int[4][];
    private KRes m_FontNotePad;
    private KRes m_FontIndicators;
    private KRes m_FontPreviousText;
    private KRes m_FontWhite;
    private KRes m_FontWhiteSmall;
    private KRes m_FontNotePadSmall;
    private int lineSwitchPercent;
    private long keySlidePercent;
    private static KRes m_ballImage;
    private static KRes m_ballImageSplash;
    private static KRes m_targetArrow;
    private static KRes m_greyArrow;
    private static KRes m_target;
    private static KRes m_XRed;
    private static KRes m_greenPaf;
    private static KRes m_meterImage;
    private static KRes m_scoreDigitsImage;
    private static KRes m_thresholdImage;
    public static KRes m_ledProgressBar;
    private static KRes m_holdMeterImage;
    private static KRes m_holdMeterBorderImage;
    private static KRes m_scratchImage;
    private static KRes m_scratchImage_176;
    private static KRes m_bubbleImage;
    private static KRes m_versusImage;
    private static KRes m_nextImage;
    private static KRes m_tutoNextImg;
    private KRes fileBufferString = null;
    private KRes fileBuffer = null;
    private KFileBuffer fileBinBuffer = null;
    private KFileBuffer fileOffset = null;
    private KFileBuffer fileDicoOffset = null;
    private KRes fileDico = null;
    private AnimInstance[] battlePose;
    private boolean bSlider1Loaded = false;
    private boolean bSlider2Loaded = false;
    private short[][] characters = new short[2][];
    private byte characterCounter = 0;
    private String display_waiting_time = "3";
    private long waitingTime = 0L;
    private long waiting_time_toggle = 0L;
    private String strFlashCard;
    private boolean bFlashCardLoaded = false;
    private boolean bFlashCardScrolled = false;
    private boolean bFlashCardDraw = false;
    private TextViewport tvpFlashCard;
    private boolean finishSlidingArrow = false;
    private boolean displaySplashHit = false;
    private boolean bRewriteLineAfterSplash = false;
    private int lastWrittenWord = 0;
    private int[] lastColorScribble = new int[4];
    private int[] displayed = new int[5];
    private short m_notePad_stats_y;
    private static byte[] bbuf_loadRoundLyrics;
    private byte oldLine = 0;
    private byte oldPara = 0;
    private byte oldMode = 0;
    private boolean bNeedToReSwitchLine = false;
    private boolean isInFlashCard = false;
    private boolean isInGoal = false;
    private boolean startNow = false;
    private int keyBeingHold = 0;
    private int vs_backgroundX = 0;
    private int vs_backgroundY = 0;
    private int vs_backgroundWidth = 0;
    private int vs_backgroundHeight = 0;
    private static byte[] bbuf_getParagraphData2;
    private static byte[] bbufWords_getParagraphData2;

    private boolean isRefreshDone(byte by, int n) {
        return (this.displayed[by] & n) == n;
    }

    private void refreshDone(byte by, int n) {
        for (int n2 = 0; n2 < this.displayed.length; n2 = (int)((byte)(n2 + 1))) {
            if (n2 == by) {
                int n3 = n2;
                this.displayed[n3] = this.displayed[n3] | n;
                continue;
            }
            int n4 = n2;
            this.displayed[n4] = this.displayed[n4] & ~n;
        }
    }

    private void refreshClearBits() {
        for (int n = 0; n < this.displayed.length; n = (int)((byte)(n + 1))) {
            this.displayed[n] = n == 0 ? Integer.MAX_VALUE : 0;
        }
    }

    public final void loadFile(int n) {
        this.fileBufferString = KResource.load((short)27649, 11);
        String string = Utils.getWordsFrom(122, this.fileBufferString);
        if (n < 10) {
            string = string.concat("0");
        }
        string.concat(Integer.toString(n));
        int n2 = n;
        int n3 = 0;
        switch (n2) {
            case 2: {
                n3 = 27650;
                break;
            }
            case 5: {
                n3 = 27651;
                break;
            }
            case 7: {
                n3 = 27652;
                break;
            }
            case 9: {
                n3 = 27653;
                break;
            }
            case 11: {
                n3 = 24576;
                break;
            }
            case 14: {
                n3 = 27654;
                break;
            }
            case 16: {
                n3 = 24577;
                break;
            }
            case 19: {
                n3 = 24578;
                break;
            }
            case 21: {
                n3 = 24579;
                break;
            }
            case 23: {
                n3 = 24580;
                break;
            }
            case 26: {
                n3 = 24581;
                break;
            }
            case 28: {
                n3 = 24582;
                break;
            }
            case 30: {
                n3 = 24583;
                break;
            }
            case 32: {
                n3 = 25600;
                break;
            }
            case 35: {
                n3 = 25601;
                break;
            }
            case 37: {
                n3 = 25602;
                break;
            }
            case 39: {
                n3 = 25603;
                break;
            }
            case 41: {
                n3 = 25604;
                break;
            }
            case 43: {
                n3 = 25605;
                break;
            }
            case 46: {
                n3 = 25606;
                break;
            }
            case 48: {
                n3 = 25607;
                break;
            }
            case 50: {
                n3 = 26625;
                break;
            }
            case 52: {
                n3 = 26626;
                break;
            }
            case 54: {
                n3 = 26627;
                break;
            }
            case 56: {
                n3 = 26628;
                break;
            }
            case 58: {
                n3 = 26629;
                break;
            }
            case 61: {
                n3 = 26630;
                break;
            }
            case 62: {
                n3 = 26631;
            }
        }
        int n4 = n3;
        n2 = n;
        n3 = 0;
        switch (n2) {
            case 2: {
                n3 = 29696;
                break;
            }
            case 5: {
                n3 = 29698;
                break;
            }
            case 7: {
                n3 = 29700;
                break;
            }
            case 9: {
                n3 = 29702;
                break;
            }
            case 11: {
                n3 = 29704;
                break;
            }
            case 14: {
                n3 = 29706;
                break;
            }
            case 16: {
                n3 = 29708;
                break;
            }
            case 19: {
                n3 = 29710;
                break;
            }
            case 21: {
                n3 = 29712;
                break;
            }
            case 23: {
                n3 = 29714;
                break;
            }
            case 26: {
                n3 = 29716;
                break;
            }
            case 28: {
                n3 = 29718;
                break;
            }
            case 30: {
                n3 = 29720;
                break;
            }
            case 32: {
                n3 = 29722;
                break;
            }
            case 35: {
                n3 = 29724;
                break;
            }
            case 37: {
                n3 = 29726;
                break;
            }
            case 39: {
                n3 = 29728;
                break;
            }
            case 41: {
                n3 = 29730;
                break;
            }
            case 43: {
                n3 = 29732;
                break;
            }
            case 46: {
                n3 = 29734;
                break;
            }
            case 48: {
                n3 = 29736;
                break;
            }
            case 50: {
                n3 = 29738;
                break;
            }
            case 52: {
                n3 = 29740;
                break;
            }
            case 54: {
                n3 = 29742;
                break;
            }
            case 56: {
                n3 = 29744;
                break;
            }
            case 58: {
                n3 = 29746;
                break;
            }
            case 61: {
                n3 = 29748;
                break;
            }
            case 62: {
                n3 = 29750;
            }
        }
        int n5 = n3;
        n2 = n;
        n3 = 0;
        switch (n2) {
            case 2: {
                n3 = 29697;
                break;
            }
            case 5: {
                n3 = 29699;
                break;
            }
            case 7: {
                n3 = 29701;
                break;
            }
            case 9: {
                n3 = 29703;
                break;
            }
            case 11: {
                n3 = 29705;
                break;
            }
            case 14: {
                n3 = 29707;
                break;
            }
            case 16: {
                n3 = 29709;
                break;
            }
            case 19: {
                n3 = 29711;
                break;
            }
            case 21: {
                n3 = 29713;
                break;
            }
            case 23: {
                n3 = 29715;
                break;
            }
            case 26: {
                n3 = 29717;
                break;
            }
            case 28: {
                n3 = 29719;
                break;
            }
            case 30: {
                n3 = 29721;
                break;
            }
            case 32: {
                n3 = 29723;
                break;
            }
            case 35: {
                n3 = 29725;
                break;
            }
            case 37: {
                n3 = 29727;
                break;
            }
            case 39: {
                n3 = 29729;
                break;
            }
            case 41: {
                n3 = 29731;
                break;
            }
            case 43: {
                n3 = 29733;
                break;
            }
            case 46: {
                n3 = 29735;
                break;
            }
            case 48: {
                n3 = 29737;
                break;
            }
            case 50: {
                n3 = 29739;
                break;
            }
            case 52: {
                n3 = 29741;
                break;
            }
            case 54: {
                n3 = 29743;
                break;
            }
            case 56: {
                n3 = 29745;
                break;
            }
            case 58: {
                n3 = 29747;
                break;
            }
            case 61: {
                n3 = 29749;
                break;
            }
            case 62: {
                n3 = 29751;
            }
        }
        n = n3;
        this.fileBuffer = KResource.load(n4, 11);
        KRes kRes = KResource.load(n5, 125);
        this.fileBinBuffer = (KFileBuffer)kRes.ro_ref;
        KResource.releaseRes(kRes.ro_hHandle);
        kRes = KResource.load(n, 125);
        this.fileOffset = (KFileBuffer)kRes.ro_ref;
        KResource.releaseRes(kRes.ro_hHandle);
        kRes = KResource.load((short)30720, 125);
        this.fileDicoOffset = (KFileBuffer)kRes.ro_ref;
        KResource.releaseRes(kRes.ro_hHandle);
        this.fileDico = KResource.load((short)30721, 11);
        KMath.loadSinTable((short)0);
        if (bTutorialMode) {
            StoryManager.instance.getTakeNumber(2);
        }
        BattleTakeData battleTakeData = StoryManager.instance.battleTake;
        Battle battle = this;
        this.battleTakeID = battleTakeData.takeID;
        battle.battleType = battleTakeData.battleType;
        battle.level = battleTakeData.level;
        battle.threshold = (byte)(battleTakeData.threshold * 5);
        battle.rapper = battleTakeData.rapper;
        battle.opponent = battleTakeData.opponent;
        battle.rapperPartner = battleTakeData.rapperPartner;
        battle.opponentPartner = battleTakeData.opponentPartner;
        battle.location = battleTakeData.location;
        battle.loop = battleTakeData.loop;
        if (battle.battleType == 5 || battle.battleType == 4) {
            battle.coop1stWordPercent = (byte)20;
            battle.coop2ndWordPercent = (byte)40;
            switch (battle.level) {
                case 5: {
                    battle.coop1stWordPercent = (byte)(battle.coop1stWordPercent + 20);
                    battle.coop2ndWordPercent = (byte)(battle.coop2ndWordPercent + 15);
                }
                case 4: {
                    battle.coop1stWordPercent = (byte)(battle.coop1stWordPercent + 5);
                    battle.coop2ndWordPercent = (byte)(battle.coop2ndWordPercent + 10);
                }
                case 3: {
                    battle.coop1stWordPercent = (byte)(battle.coop1stWordPercent + 5);
                    battle.coop2ndWordPercent = (byte)(battle.coop2ndWordPercent + 10);
                }
            }
        }
        switch (battle.battleType) {
            case 7: {
                battle.characters[0] = new short[]{Battle.getAnimConstant(battle.rapper), Battle.getAnimConstant(battle.opponent), Battle.getAnimConstant(battle.rapperPartner), Battle.getAnimConstant(battle.opponentPartner), 28686};
                battle.characters[1] = new short[]{1, 3, 0, 2, 28686};
                break;
            }
            case 4: {
                battle.characters[0] = new short[]{Battle.getAnimConstant(battle.rapper), Battle.getAnimConstant(battle.rapperPartner)};
                battle.characters[1] = new short[]{1, 0};
                break;
            }
            case 2: 
            case 3: {
                battle.characters[0] = new short[]{Battle.getAnimConstant(battle.opponent), Battle.getAnimConstant(battle.rapper)};
                battle.characters[1] = new short[]{3, 1};
                break;
            }
            case 6: {
                battle.characters[0] = new short[]{Battle.getAnimConstant(battle.opponent), Battle.getAnimConstant(battle.opponentPartner), Battle.getAnimConstant(battle.rapper)};
                battle.characters[1] = new short[]{3, 2, 1};
                break;
            }
            case 5: {
                battle.characters[0] = new short[]{Battle.getAnimConstant(battle.opponent), Battle.getAnimConstant(battle.opponentPartner), Battle.getAnimConstant(battle.rapper), Battle.getAnimConstant(battle.rapperPartner)};
                battle.characters[1] = new short[]{3, 2, 1, 0};
                break;
            }
            case 1: {
                if (battle.opponent != 0) {
                    battle.characters[0] = new short[]{Battle.getAnimConstant(battle.rapper), Battle.getAnimConstant(battle.opponent)};
                    battle.characters[1] = new short[]{1, 3};
                    break;
                }
                battle.characters[0] = new short[]{Battle.getAnimConstant(battle.rapper)};
                battle.characters[1] = new short[]{1};
            }
        }
        battle.battlePose = new AnimInstance[battle.characters[0].length];
        battle = this;
        Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
        battle.setState((byte)8);
        this.loadSong();
    }

    private void loadSong() {
        switch (this.loop) {
            case 8: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)1);
                }
                this.currentTempo = 659;
                this.loopLapseTime = 10544L;
                return;
            }
            case 1: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)2);
                }
                this.currentTempo = 666;
                this.loopLapseTime = 10656L;
                return;
            }
            case 7: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)3);
                }
                this.currentTempo = 666;
                this.loopLapseTime = 10656L;
                return;
            }
            case 5: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)4);
                }
                this.currentTempo = 666;
                this.loopLapseTime = 10656L;
                return;
            }
            case 4: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)5);
                }
                this.currentTempo = 750;
                this.loopLapseTime = 12000L;
                return;
            }
            case 9: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)6);
                }
                this.currentTempo = 600;
                this.loopLapseTime = 9600L;
                return;
            }
            case 3: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)8);
                }
                this.currentTempo = 705;
                this.loopLapseTime = 11280L;
                return;
            }
            case 2: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)9);
                }
                this.currentTempo = 666;
                this.loopLapseTime = 10656L;
                return;
            }
            case 6: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)10);
                }
                this.currentTempo = 666;
                this.loopLapseTime = 10656L;
                return;
            }
            case 10: {
                if (RBSound.instance != null) {
                    RBSound.instance.setSong((short)7);
                }
                this.currentTempo = 600;
                this.loopLapseTime = 9600L;
                return;
            }
        }
        if (RBSound.instance != null) {
            RBSound.instance.setSong((short)10);
        }
        this.currentTempo = 666;
        this.loopLapseTime = 10656L;
    }

    public final void unloadFile() {
        this.unloadFont();
        if (this.fileBuffer != null) {
            KResource.releaseRes(this.fileBuffer.ro_hHandle);
            this.fileBuffer = null;
        }
        if (this.fileBufferString != null) {
            KResource.releaseRes(this.fileBufferString.ro_hHandle);
            this.fileBufferString = null;
        }
        if (this.fileDico != null) {
            KResource.releaseRes(this.fileDico.ro_hHandle);
            this.fileDico = null;
        }
        if (m_ledProgressBar != null) {
            m_ledProgressBar = KResource.releaseRes(Battle.m_ledProgressBar.ro_hHandle);
        }
        this.fileBinBuffer = null;
        this.fileOffset = null;
        this.fileDicoOffset = null;
        KMath.unloadSinTable();
    }

    public final void unloadFont() {
        if (this.m_FontNotePad != null) {
            HeapManager.instance.release(this.m_FontNotePad.ro_hHandle);
            this.m_FontNotePad = null;
        }
        if (this.m_FontPreviousText != null) {
            HeapManager.instance.release(this.m_FontPreviousText.ro_hHandle);
            this.m_FontPreviousText = null;
        }
        if (this.m_FontWhite != null) {
            HeapManager.instance.release(this.m_FontWhite.ro_hHandle);
            this.m_FontWhite = null;
        }
        if (this.m_FontIndicators != null) {
            HeapManager.instance.release(this.m_FontIndicators.ro_hHandle);
            this.m_FontIndicators = null;
        }
        if (this.m_FontWhiteSmall != null) {
            HeapManager.instance.release(this.m_FontWhiteSmall.ro_hHandle);
            this.m_FontWhiteSmall = null;
        }
        if (this.m_FontNotePadSmall != null) {
            HeapManager.instance.release(this.m_FontNotePadSmall.ro_hHandle);
            this.m_FontNotePadSmall = null;
        }
    }

    private void loadFont() {
        if (this.m_FontNotePad == null) {
            this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
        }
        if (this.m_FontPreviousText == null) {
            this.m_FontPreviousText = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xD2D2D2, false);
        }
        if (this.m_FontWhiteSmall == null) {
            this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
        }
        if (this.m_FontNotePadSmall == null) {
            this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
        }
        if (HeapManager.getFontBufferSize() > 4 && this.m_FontWhite == null) {
            this.m_FontWhite = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
        }
    }

    public final void loadTutorialFont() {
        if (this.m_FontNotePad == null) {
            this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
        }
        if (this.m_FontIndicators == null) {
            this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
        }
        if (this.m_FontWhiteSmall == null) {
            this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
        }
        if (this.m_FontNotePadSmall == null) {
            this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
        }
    }

    private boolean loadRoundLyrics(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object = this;
        for (n7 = 0; n7 < 4; ++n7) {
            for (n6 = 0; n6 < 100; ++n6) {
                ((Battle)object).charLyrics[n7][n6] = '\u0000';
                ((Battle)object).charBeats[n7][n6] = '\u0000';
                ((Battle)object).charTaps[n7][n6] = '\u0000';
            }
            ((Battle)object).charBeatsLength[n7] = 0;
            ((Battle)object).charLyricsLength[n7] = 0;
            ((Battle)object).charTapsLength[n7] = 0;
        }
        object = this;
        Random random = new Random();
        int n8 = 0;
        n6 = 0;
        if (((Battle)object).fileBinBuffer != null) {
            int n9;
            int n10 = 0;
            n10 = 0;
            for (n7 = n; n7 > 1; --n7) {
                for (n5 = 4; n5 > 0; --n5) {
                    if (!((Battle)object).fileBinBuffer.EOF()) {
                        bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, 1, bbuf_getParagraphData2);
                        n9 = bbuf_getParagraphData2[0] & 0xFF;
                        bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(++n10, n9 - 1, bbuf_getParagraphData2);
                        n10 += n9 - 1;
                    }
                    if (!((Battle)object).fileBinBuffer.EOF()) {
                        bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, 1, bbuf_getParagraphData2);
                        n9 = bbuf_getParagraphData2[0] & 0xFF;
                        bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(++n10, n9 - 1, bbuf_getParagraphData2);
                        n10 += n9 - 1;
                    }
                    if (((Battle)object).fileBinBuffer.EOF()) continue;
                    bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, 1, bbuf_getParagraphData2);
                    ++n10;
                    n4 = 0;
                    n4 = (bbuf_getParagraphData2[0] & 0xF0) >> 4;
                    if (n4 <= 0) continue;
                    bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, n4 - 1, bbuf_getParagraphData2);
                    n10 += n4 - 1;
                }
            }
            int n11 = 0;
            for (n5 = 0; n5 < 4; ++n5) {
                if (!((Battle)object).fileBinBuffer.EOF()) {
                    bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, 1, bbuf_getParagraphData2);
                    n9 = bbuf_getParagraphData2[0] & 0xFF;
                    bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(++n10, n9 - 1, bbuf_getParagraphData2);
                    n10 += n9 - 1;
                    n3 = n9 - 1;
                    Utils.lengthVirtual = 0;
                    for (n4 = 1; n4 < n3; ++n4) {
                        for (n7 = 0; n7 < 8; ++n7) {
                            ((Battle)object).charBufferZero[n7] = 48;
                        }
                        ((Battle)object).charBufferZeroLength = (byte)8;
                        String string = Integer.toBinaryString(bbuf_getParagraphData2[n4] & 0xFF);
                        ((Battle)object).charBufferZeroLength = (byte)(8 - string.length());
                        string.getChars(0, string.length(), ((Battle)object).charBufferByte, 0);
                        ((Battle)object).charBufferByteLength = (byte)string.length();
                        Utils.charConcat(((Battle)object).charBufferZero, ((Battle)object).charBufferByte, ((Battle)object).charBufferZeroLength, 0, ((Battle)object).charBufferByteLength);
                        ((Battle)object).charBufferZeroLength = (byte)(((Battle)object).charBufferZeroLength + ((Battle)object).charBufferByteLength);
                        string = new String(((Battle)object).charBufferZero, 0, (int)((Battle)object).charBufferZeroLength);
                        string.getChars(0, string.length(), ((Battle)object).charBufferByte, 0);
                        Utils.charConcat(Utils.charBuffer, ((Battle)object).charBufferByte, Utils.lengthVirtual, 0, string.length());
                        Utils.lengthVirtual += string.length();
                    }
                    Utils.charReplace(Utils.charBuffer, '1', '*', 0, Utils.lengthVirtual);
                    Utils.charReplace(Utils.charBuffer, '0', ' ', 0, Utils.lengthVirtual);
                    n7 = Utils.lengthVirtual - 1;
                    while (Utils.charBuffer[n11] == ' ' && n11 < n7) {
                        ++n11;
                    }
                    while (Utils.charBuffer[n7] == ' ' && n7 > n11) {
                        --n7;
                    }
                    n8 = n7 - n11 + 1;
                    ((Battle)object).charBeatsLength[n5] = (short)(n7 - n11 + 1);
                    System.arraycopy(Utils.charBuffer, n11, ((Battle)object).charBeats[n5], 0, ((Battle)object).charBeatsLength[n5]);
                }
                if (!((Battle)object).fileBinBuffer.EOF()) {
                    bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, 1, bbuf_getParagraphData2);
                    n9 = bbuf_getParagraphData2[0] & 0xFF;
                    bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(++n10, n9 - 1, bbuf_getParagraphData2);
                    n10 += n9 - 1;
                    n3 = n9 - 1;
                    Utils.lengthVirtual = 0;
                    for (n4 = 0; n4 < n3; n4 += 2) {
                        n9 = (bbuf_getParagraphData2[n4] & 0xFF) - Utils.lengthVirtual;
                        while (n9 != 0) {
                            --n9;
                            Utils.charBuffer[Utils.lengthVirtual] = 32;
                            ++Utils.lengthVirtual;
                        }
                        n9 = bbuf_getParagraphData2[n4 + 1] & 0xFF;
                        while (n9 != 0) {
                            --n9;
                            Utils.charBuffer[Utils.lengthVirtual] = 42;
                            ++Utils.lengthVirtual;
                        }
                    }
                    while (n8 > Utils.lengthVirtual) {
                        Utils.charBuffer[Utils.lengthVirtual] = 32;
                        ++Utils.lengthVirtual;
                    }
                    if (Utils.charBuffer[0] == '*') {
                        Utils.charBuffer[0] = 32;
                    }
                    ((Battle)object).charTapsLength[n5] = (short)Utils.lengthVirtual;
                    System.arraycopy(Utils.charBuffer, 0, ((Battle)object).charTaps[n5], 0, ((Battle)object).charTapsLength[n5]);
                }
                if (((Battle)object).fileBinBuffer.EOF()) continue;
                bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, 1, bbuf_getParagraphData2);
                ++n10;
                n4 = 0;
                n4 = (bbuf_getParagraphData2[0] & 0xF0) >> 4;
                n9 = bbuf_getParagraphData2[0] & 0xF;
                Utils.lengthVirtual = 0;
                int n12 = n9;
                if (n4 <= 0) continue;
                if (n12 > 2) {
                    random.nextInt();
                }
                bbuf_getParagraphData2 = ((Battle)object).fileBinBuffer.readBytes(n10, n4 - 1, bbuf_getParagraphData2);
                n10 += n4 - 1;
                int n13 = (bbuf_getParagraphData2[0] & 0xF0) >> 4;
                int n14 = bbuf_getParagraphData2[0] & 0xF;
                n13 = (n13 - 1 << 1) + 1;
                n14 = (n14 - 1 << 1) + 1;
                n2 = 0;
                n3 = 1;
                while (n3 + n2 < n4 - 1) {
                    n7 = 0;
                    n7 = (bbuf_getParagraphData2[n3 + n2] & 0xFF) << 8;
                    n9 = bbuf_getParagraphData2[n3 + n2 + 1] & 0xFF;
                    n7 += n9;
                    n9 = bbuf_getParagraphData2[n3 + n2 + 2] & 0xFF;
                    if (n9 > 1) {
                        n12 = random.nextInt();
                        if (n12 < 0) {
                            n12 = -n12;
                        }
                        n9 = n12 % n9;
                        n7 += n9;
                    }
                    bbufWords_getParagraphData2 = ((Battle)object).fileDicoOffset.readBytes(n7 - 1 << 1, 2, bbufWords_getParagraphData2);
                    String string = Utils.getWordsFrom(((bbufWords_getParagraphData2[0] & 0xFF) << 8) + (bbufWords_getParagraphData2[1] & 0xFF), ((Battle)object).fileDico);
                    string.getChars(0, string.length(), ((Battle)object).charBufferWord, 0);
                    Utils.charConcat(Utils.charBuffer, ((Battle)object).charBufferWord, Utils.lengthVirtual, 0, string.length());
                    Utils.charBuffer[Utils.lengthVirtual += string.length()] = 47;
                    ++Utils.lengthVirtual;
                    ++n2;
                    n3 += 2;
                }
                n13 = n13 / 2 + n13 % 2;
                n14 = n14 / 2 + n14 % 2;
                n2 = 0;
                if (n13 != -1) {
                    n2 = 0 | 3 << 8 - (n13 << 1);
                }
                if (n14 != -1) {
                    n2 |= 2 << 8 - (n14 << 1);
                }
                if ((n2 & 0xC0) == 0) {
                    n2 |= 0x40;
                }
                if ((n2 & 0x30) == 0) {
                    n2 |= 0x10;
                }
                if ((n2 & 0xC) == 0) {
                    n2 |= 4;
                }
                if ((n2 & 3) == 0) {
                    n2 |= 1;
                }
                ((Battle)object).m_WordsBankScore[n5] = n2;
                super.countWordsBankLenght2(0, n5, Utils.charBuffer, 0, Utils.lengthVirtual - 1);
            }
        }
        n2 = 0;
        int n15 = 0;
        n4 = 0;
        n3 = 0;
        n5 = 0;
        for (n7 = 0; n7 < 4; ++n7) {
            n2 = -1;
            n15 = -1;
            n4 = -1;
            n5 = 0;
            bbuf_loadRoundLyrics = this.fileOffset.readBytes((n - 1 << 3) + (n7 << 1), 2, bbuf_loadRoundLyrics);
            int n16 = 0;
            n16 = ((bbuf_loadRoundLyrics[0] & 0xFF) << 8) + (bbuf_loadRoundLyrics[1] & 0xFF);
            if (!Utils.loadingRefresh(Utils.getLoadingPercent())) {
                return false;
            }
            object = Utils.getWordsFrom(n16, this.fileBuffer);
            for (n8 = 0; n8 < 4 && this.m_WordsBank[n7] != null; ++n8) {
                if (this.m_WordsBank[n7][n8] == null || n4 >= (n3 = ((KFont)this.m_FontNotePadSmall.ro_ref).textWidth(this.m_WordsBank[n7][n8].toCharArray(), 0, this.m_WordsBank[n7][n8].length()))) continue;
                n4 = n3 + 10;
            }
            if (n4 > TARGET_TEXT_WIDTH) {
                n2 = (n4 - TARGET_TEXT_WIDTH) / SPACE_WIDTH;
                if ((n4 - TARGET_TEXT_WIDTH) % SPACE_WIDTH > 0) {
                    ++n2;
                }
                n15 = ((String)object).lastIndexOf(40);
                n4 = ((String)object).lastIndexOf(41);
            }
            this.charLyricsLength[n7] = (short)((String)object).length();
            ((String)object).getChars(0, this.charLyricsLength[n7], this.charLyrics[n7], 0);
            if (n2 > 0 && n4 > 0) {
                for (n8 = 1; n8 <= this.charLyricsLength[n7] - n4; ++n8) {
                    this.charLyrics[n7][this.charLyricsLength[n7] - n8 + n2] = this.charLyrics[n7][this.charLyricsLength[n7] - n8];
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    this.charLyrics[n7][n4 + n8] = 95;
                }
                int n17 = n7;
                this.charLyricsLength[n17] = (short)(this.charLyricsLength[n17] + n2);
            }
            this.countLinesSize2$255f295(n7);
            if (n2 > 0 && n4 > 0) {
                int[] nArray = this.m_LinesDisplayArray[n7];
                int n18 = this.m_LinesDisplayArray[n7].length - 1;
                nArray[n18] = nArray[n18] + n2;
                for (n8 = this.charBeatsLength[n7]; n8 > n15; --n8) {
                    if (this.charBeatsLength[n7] != n8 && this.charBeats[n7][n8] == '*') {
                        n5 = 1;
                    }
                    this.charBeats[n7][n8] = 32;
                }
                this.charBeats[n7][this.charBeatsLength[n7] + n2 - 1] = 42;
                if (n5 != 0) {
                    this.charBeats[n7][n15 + (this.charBeatsLength[n7] + n2 - 1 - n15) / 2] = 42;
                }
                int n19 = n7;
                this.charBeatsLength[n19] = (short)(this.charBeatsLength[n19] + n2);
            }
            if (n7 != 0) {
                for (n8 = 0; n8 < this.charLyricsLength[n7]; ++n8) {
                    if (this.charLyrics[n7][n8] != '_') continue;
                    this.charLyrics[n7][n8] = 32;
                }
            }
            if (n7 == 0 && -1 != Utils.charIndexOf(this.charLyrics[n7], "___)", 0, (int)this.charLyricsLength[n7])) {
                Utils.charReplace(this.charLyrics[n7], '_', ' ', 0, this.charLyricsLength[n7]);
            }
            Utils.charInsert(this.charBeats[n7], "**", '~', 0, this.charBeatsLength[n7]);
        }
        this.getTargetPositions((byte)0);
        this.keySlidePercent = 0L;
        return true;
    }

    public static byte getState() {
        return m_state;
    }

    public final void returnToState() {
        this.setState((byte)5);
        this.unloadFont();
        this.setState((byte)1);
        this.unloadFont();
        this.unloadFont();
        if (this.m_FontNotePad == null) {
            this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
        }
        if (this.m_FontWhite == null) {
            this.m_FontWhite = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
        }
        if (this.m_FontNotePadSmall == null) {
            this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
        }
        if (this.m_FontWhiteSmall == null) {
            this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
        }
        if (this.m_FontPreviousText == null) {
            this.m_FontPreviousText = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xD2D2D2, false);
        }
        if (this.m_FontIndicators == null) {
            this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
        }
        this.loadTutorialFont();
        m_state = (byte)5;
    }

    public final void returnToState(byte by) {
        this.setState(by);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void setState(byte var1_3) {
        var2_8 /* !! */  = null;
        Battle.m_state = var1_3;
        switch (var1_3) {
            case 8: {
                this.bIntroDrawn = false;
                if (Battle.bTutorialMode) ** GOTO lbl230
                var1_4 = Utils.getBackBufferGraphics();
                var2_8 /* !! */  = KGraphics.getGraphics();
                KGraphics.setGraphics(var1_4);
                var1_4.setColor(0);
                var1_4.fillRect(0, 0, KCanvas.m_width, KCanvas.m_height);
                var3_14 = 0;
                var4_21 = 0;
                var5_27 = 0;
                var6_31 = 0;
                var6_31 = 0;
                var7_37 = false;
                var8_50 = Utils.getLoadingPercent();
                var8_50 = var8_50 == -1 ? 0 : (var8_50 += 5);
                var9_57 = 0;
                Utils.loadingIni$252c3fc(48);
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                var1_4.setColor(0);
                var1_4.fillRect(0, 0, KCanvas.m_width, KCanvas.m_height);
                var7_38 = (Image)((KRes)HeapManager.instance.get((int)28676, (byte)1, (int)0)).ro_ref;
                var3_14 = var7_38.getWidth();
                var5_27 = var7_38.getHeight();
                var3_14 = (Utils.BACK_BUFFER_WIDTH - var3_14 >> 1) - 7;
                var4_21 = Game.menu_position_y - Game.titleHeight >> 1;
                if (this.location == 0) ** GOTO lbl48
                var10_60 = Battle.getLocationBackgroundFilter(this.location);
                var11_68 = (Image)((KRes)HeapManager.instance.get((int)var10_60, (byte)1, (int)0)).ro_ref;
                this.vs_backgroundWidth = var11_68.getWidth();
                this.vs_backgroundHeight = var11_68.getHeight();
                this.vs_backgroundX = KCanvas.m_width - this.vs_backgroundWidth >> 1;
                this.vs_backgroundY = var4_21 + var5_27 + (KCanvas.m_height - var4_21 - var5_27 - 8 - this.vs_backgroundHeight >> 1);
                var1_4.drawImage((Image)var11_68, this.vs_backgroundX, this.vs_backgroundY, 0);
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += 10 - Utils.getLoadingPercent() / 10)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
lbl48:
                // 2 sources

                var1_4.drawImage(var7_38, var3_14, var4_21, 0);
                var2_8 /* !! */  = KGraphics.setGraphics(var1_4);
                if (this.battleType != 7) ** GOTO lbl58
                this.load5man((byte)0);
                if (Utils.clearKeyIsEnable()) ** GOTO lbl230
                var0_1 = false;
                var3_15 = Utils.getWordsFrom(71, this.fileBufferString);
                var0_2 = null;
                this.drawVersusString(var1_4, var3_15, (byte)104, 0, 0);
                ** GOTO lbl226
lbl58:
                // 1 sources

                if (this.opponent != 0) ** GOTO lbl124
                if (this.rapperPartner != 0) ** GOTO lbl75
                var9_57 = (100 - var8_50) / 2;
                var10_61 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, 0);
                var3_14 = KCanvas.m_width - 75 >> 2;
                var4_21 = (KCanvas.m_height - 90 << 1) / 3;
                var6_31 = var3_14 + 37;
                var7_39 = var4_21 + 90 - var10_61.getBottom();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 + var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                Battle.drawAnimRec(var1_4, var3_14, var4_21, 75, 90, 0xFF0000);
                var10_61.draw(var6_31, var7_39, false, false);
                Battle.drawVersusString(var1_4, this.getRappersName(this.rapper) + "\n" + Utils.getWordsFrom(65, this.fileBufferString), this.vs_backgroundX + 2, this.vs_backgroundY + this.vs_backgroundHeight + 2);
                ** GOTO lbl226
lbl75:
                // 1 sources

                var9_57 = (100 - var8_50) / 4;
                var10_62 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, 0);
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                var11_68 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, 0);
                var3_14 = var11_68.getLeft() + (var11_68.getRight() - var11_68.getLeft()) / 10;
                var4_21 = var11_68.getTop();
                var5_27 = var11_68.getBottom() - var4_21;
                var6_31 = var11_68.getRight() - var3_14 - (var11_68.getRight() - var3_14) / 10;
                var12_69 = KCanvas.m_width - 75 >> 1;
                var13_71 = (KCanvas.m_height - 90 << 1) / 3;
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                var14_73 = var4_21 + var13_71;
                Battle.drawAnimRec(var1_4, var3_14 += var12_69, var14_73, var6_31, var5_27, 0xFF0000);
                var6_31 = var12_69 + 25;
                var7_40 = var13_71 + 1;
                if (var10_62.getBottom() < var5_27) {
                    var7_40 = var13_71 + var11_68.getTop() + 1 + var5_27 - var10_62.getBottom();
                }
                var3_14 = var12_69 - 15;
                var4_21 = var13_71 + 1;
                var10_62 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, 0);
                Utils.SaveClip();
                Utils.SetClip$29abebcb((short)0, (short)KCanvas.m_width, (short)(var14_73 + var5_27 + 1));
                var10_62.draw(var6_31, var7_40, false, false);
                Utils.RestoreClip();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                var11_68 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, 0);
                Utils.SaveClip();
                Utils.SetClip$29abebcb((short)0, (short)KCanvas.m_width, (short)(var14_73 + var5_27 + 1));
                var11_68.draw(var3_14, var4_21, false, false);
                Utils.RestoreClip();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 + var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                Battle.drawVersusString(var1_4, this.getRappersName(this.rapper) + "\n" + this.getRappersName(this.rapperPartner), this.vs_backgroundX + 2, this.vs_backgroundY + this.vs_backgroundHeight + 2);
                ** GOTO lbl226
lbl124:
                // 1 sources

                var9_57 = this.rapperPartner != 0 && this.opponentPartner != 0 ? (100 - var8_50) / 8 : (this.rapperPartner != 0 || this.opponentPartner != 0 ? (100 - var8_50) / 6 : (100 - var8_50) / 4);
                var3_14 = KCanvas.m_width / 15;
                var4_21 = var4_21 + var5_27 + KCanvas.m_height / 15;
                var12_70 = KCanvas.m_width - var3_14 - 75;
                var13_72 = KCanvas.m_height - 8 - 1 - KCanvas.m_height / 15 - 90;
                Battle.drawAnimRec(var1_4, var3_14, var4_21, 75, 90, 0xFF0000);
                Battle.drawAnimRec(var1_4, var12_70, var13_72, 75, 90, 11495608);
                if (this.rapperPartner == 0) ** GOTO lbl151
                var6_31 = var3_14 + 57;
                var7_41 = var4_21;
                var10_63 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, 0);
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                if (var10_63.getBottom() < 90) {
                    var7_41 += 90 - var10_63.getBottom();
                }
                Utils.SaveClip();
                Utils.SetClip$29abebcb((short)var3_14, (short)KCanvas.m_width, (short)(var4_21 + 90));
                var10_63.draw(var6_31, var7_41, false, false);
                Utils.RestoreClip();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
lbl151:
                // 2 sources

                var6_31 = this.rapperPartner != 0 ? (var6_31 -= 37) : var3_14 + 37;
                var10_64 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, 0);
                var7_42 = var4_21 + 10;
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                if (var10_64.getBottom() < 90) {
                    var7_42 += 90 - var10_64.getBottom();
                }
                Utils.SaveClip();
                Utils.SetClip$29abebcb((short)var3_14, (short)KCanvas.m_width, (short)(var4_21 + 90));
                var10_64.draw(var6_31, var7_42, false, false);
                Utils.RestoreClip();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                if (this.opponentPartner == 0) ** GOTO lbl193
                var6_31 = var12_70 + 10;
                var7_42 = var13_72;
                var3_14 = 0;
                if (Battle.getAnimConstant(this.opponentPartner) == 28683) {
                    var3_14 = 2;
                }
                var10_64 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.opponentPartner), (byte)0, var3_14);
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                if (var10_64.getBottom() < 90) {
                    var7_42 += 90 - var10_64.getBottom();
                }
                Utils.SaveClip();
                Utils.SetClip$29abebcb((short)0, (short)(var12_70 + 75), (short)(var13_72 + 90));
                var10_64.draw(var6_31, var7_42, true, false);
                Utils.RestoreClip();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
lbl193:
                // 2 sources

                var6_31 = this.opponentPartner != 0 ? (var6_31 += 37) : var12_70 + 37;
                var10_64 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.opponent), (byte)0, 0);
                var7_42 = var13_72;
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 += var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                if (var10_64.getBottom() < 90) {
                    var7_42 += 90 - var10_64.getBottom();
                }
                Utils.SaveClip();
                Utils.SetClip$29abebcb((short)0, (short)(var12_70 + 75), (short)(var13_72 + 90));
                var10_64.draw(var6_31, var7_42, true, false);
                Utils.RestoreClip();
                KGraphics.setGraphics(var2_8 /* !! */ );
                if (!Utils.loadingRefresh(var8_50 + var9_57)) ** GOTO lbl230
                KGraphics.setGraphics(var1_4);
                if (this.rapperPartner == 0) {
                    this.drawVersusString(var1_4, this.getRappersName(this.rapper), (byte)109, this.vs_backgroundX + this.vs_backgroundWidth, this.vs_backgroundY - KGraphics.textHeight());
                } else {
                    this.drawVersusString(var1_4, this.getRappersName(this.rapper), (byte)109, this.vs_backgroundX + this.vs_backgroundWidth, this.vs_backgroundY - KGraphics.textHeight());
                    this.drawVersusString(var1_4, this.getRappersName(this.rapperPartner), (byte)109, this.vs_backgroundX + this.vs_backgroundWidth, this.vs_backgroundY - 2 * KGraphics.textHeight());
                }
                if (this.opponentPartner == 0) {
                    Battle.drawVersusString(var1_4, this.getRappersName(this.opponent), this.vs_backgroundX, this.vs_backgroundY + this.vs_backgroundHeight);
                } else {
                    Battle.drawVersusString(var1_4, this.getRappersName(this.opponent), this.vs_backgroundX, this.vs_backgroundY + this.vs_backgroundHeight);
                    Battle.drawVersusString(var1_4, this.getRappersName(this.opponentPartner), this.vs_backgroundX, this.vs_backgroundY + this.vs_backgroundHeight + KGraphics.textHeight());
                }
                if ((this.battleType == 3 || this.battleType == 2 || this.battleType == 5 || this.battleType == 6 || this.battleType == 1 && this.opponent != 0) && Battle.m_versusImage == null) {
                    Battle.m_versusImage = KResource.load((short)12292, 1);
                }
                KGraphics.drawImage(Battle.m_versusImage, this.vs_backgroundX + (this.vs_backgroundWidth - ((Image)Battle.m_versusImage.ro_ref).getWidth() >> 1), this.vs_backgroundY + (this.vs_backgroundHeight - ((Image)Battle.m_versusImage.ro_ref).getHeight() >> 1));
                Battle.m_versusImage = KResource.releaseRes(Battle.m_versusImage.ro_hHandle);
lbl226:
                // 4 sources

                KGraphics.setGraphics(var2_8 /* !! */ );
                Utils.loadingRefresh(100);
lbl230:
                // 18 sources

                Utils.setIndicator((byte)0, (byte)0);
                return;
            }
            case 0: {
                Utils.iniBackBuffer(KCanvas.m_width, KCanvas.m_height);
                var1_3 = (byte)Utils.getLoadingPercent();
                var3_16 = 50 - var1_3;
                this.tapsMem = 0;
                if (Battle.bTutorialMode) {
                    var3_16 = 100 - var1_3;
                }
                if (Utils.getLoadingPercent() == -1) {
                    var3_16 = Battle.bTutorialMode != false ? 100 : 50;
                    var1_3 = 0;
                }
                var5_28 = null;
                for (var4_22 = 0; var4_22 != -1; ++var4_22) {
                    switch (var4_22) {
                        case 0: {
                            Utils.loadingIni$252c3fc(20);
                            Utils.loadingRefresh(var1_3);
                            break;
                        }
                        case 1: {
                            KUtils.updateElapsedMS();
                            var5_28 = Utils.getBackBufferGraphics();
                            var5_28.setColor(0);
                            var5_28.fillRect(0, 0, KCanvas.m_width, KCanvas.m_height);
                            Utils.loadingRefresh(var1_3 + var3_16 * 30 / 100);
                            break;
                        }
                        case 2: {
                            if (this.location != 0) {
                                KUtils.updateElapsedMS();
                                var2_9 = Battle.getLocationBackground(this.location);
                                var2_8 /* !! */  = (KRes)HeapManager.instance.get(var2_9, (byte)1, 0);
                                KUtils.updateElapsedMS();
                                var6_32 = (Image)var2_8 /* !! */ .ro_ref;
                                var7_43 = KCanvas.m_width - var6_32.getWidth() >> 1;
                                var8_51 = false;
                                var5_28.drawImage(var6_32, var7_43, 165, 0);
                            }
                            Utils.loadingRefresh(var1_3 + var3_16 * 40 / 100);
                            break;
                        }
                        case 3: {
                            HeapManager.instance.releaseAll();
                            this.unloadFont();
                            KUtils.updateElapsedMS();
                            this.m_FontNotePad = Battle.bTutorialMode != false ? (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false) : (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
                            if (Battle.TARGET_TEXT_WIDTH == -1 && Battle.SPACE_WIDTH == -1) {
                                Battle.TARGET_TEXT_WIDTH = ((KFont)this.m_FontNotePad.ro_ref).textWidth(Battle.TARGET_TEXT_SAMPLE, 0, Battle.TARGET_TEXT_SAMPLE.length);
                                Battle.SPACE_WIDTH = ((KFont)this.m_FontNotePad.ro_ref).charWidth(' ');
                            }
                            KUtils.updateElapsedMS();
                            this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                            Utils.loadingRefresh(var1_3 + var3_16 * 44 / 100);
                            break;
                        }
                        case 4: {
                            Utils.setIndicator((byte)4, (byte)1, (KFont)this.m_FontIndicators.ro_ref);
                            Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontIndicators.ro_ref);
                            this.bIntroDrawn = true;
                            this.bInitialized = false;
                            this.m_battleRunning = true;
                            this.line = 0;
                            this.para = 1;
                            this.bonus = 0;
                            this.tmpBonus = 0;
                            this.score = 25;
                            Battle.rankMaxPoints = this.battleType == 6 || this.battleTakeID == 52 ? (byte)32 : (this.battleType == 5 || this.battleType == 3 || this.battleType == 2 ? (byte)48 : (this.battleType == 7 ? (byte)60 : (byte)36));
                            KUtils.updateElapsedMS();
                            if (Battle.m_ballImage == null) {
                                Battle.m_ballImage = KResource.load((short)12298, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_ballImageSplash == null) {
                                Battle.m_ballImageSplash = KResource.load((short)12299, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_targetArrow == null) {
                                Battle.m_targetArrow = KResource.load((short)12297, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_greyArrow == null) {
                                Battle.m_greyArrow = KResource.load((short)12293, 1);
                            }
                            Utils.loadingRefresh(var1_3 + var3_16 * 48 / 100);
                            break;
                        }
                        case 5: {
                            KUtils.updateElapsedMS();
                            if (Battle.m_target == null) {
                                Battle.m_target = KResource.load((short)12296, 1);
                            }
                            if (Battle.m_XRed == null) {
                                Battle.m_XRed = KResource.load((short)12304, 1);
                            }
                            if (Battle.m_greenPaf == null) {
                                Battle.m_greenPaf = KResource.load((short)12302, 1);
                            }
                            if (Battle.m_meterImage == null) {
                                Battle.m_meterImage = KResource.load((short)12300, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_thresholdImage == null) {
                                Battle.m_thresholdImage = KResource.load((short)12303, 1);
                            }
                            if (Battle.m_scoreDigitsImage == null) {
                                Battle.m_scoreDigitsImage = KResource.load((short)12301, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_holdMeterImage == null) {
                                Battle.m_holdMeterImage = KResource.load((short)12305, 1);
                            }
                            if (Battle.m_holdMeterBorderImage == null) {
                                Battle.m_holdMeterBorderImage = KResource.load((short)12306, 1);
                            }
                            Utils.loadingRefresh(var1_3 + var3_16 * 52 / 100);
                            break;
                        }
                        case 6: {
                            KUtils.updateElapsedMS();
                            var2_8 /* !! */  = (Image)((KRes)HeapManager.instance.get((int)12307, (byte)1, (int)0)).ro_ref;
                            KUtils.updateElapsedMS();
                            var5_28.drawImage((Image)var2_8 /* !! */ , 0, 0, 20);
                            var5_28.drawRegion((Image)var2_8 /* !! */ , 0, 22, Utils.BACK_BUFFER_WIDTH, var2_8 /* !! */ .getHeight() - 22, 0, 0, 50, 20);
                            var5_28.drawRegion((Image)var2_8 /* !! */ , 0, 22, Utils.BACK_BUFFER_WIDTH, var2_8 /* !! */ .getHeight() - 22, 0, 0, 78, 20);
                            var5_28.drawRegion((Image)var2_8 /* !! */ , 0, 22, Utils.BACK_BUFFER_WIDTH, var2_8 /* !! */ .getHeight() - 22, 0, 0, 106, 20);
                            Utils.loadingRefresh(var1_3 + var3_16 * 56 / 100);
                            break;
                        }
                        case 7: {
                            KUtils.updateElapsedMS();
                            if (Battle.m_scratchImage == null) {
                                Battle.m_scratchImage = KResource.load((short)12294, 1);
                            }
                            if (Battle.m_scratchImage_176 == null) {
                                Battle.m_scratchImage_176 = KResource.load((short)28674, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_nextImage == null) {
                                Battle.m_nextImage = KResource.load((short)12295, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_tutoNextImg == null) {
                                Battle.m_tutoNextImg = KResource.load((short)10240, 1);
                            }
                            if (this.battleType == 3 || this.battleType == 2 || this.battleType == 5 || this.battleType == 6 || this.battleType == 1 && this.opponent != 0) {
                                KUtils.updateElapsedMS();
                                if (Battle.m_bubbleImage == null) {
                                    Battle.m_bubbleImage = KResource.load((short)12291, 1);
                                }
                            }
                            Utils.loadingRefresh(var1_3 + var3_16 * 60 / 100);
                            break;
                        }
                        case 8: {
                            this.mode = this.battleType == 3 ? (byte)2 : 1;
                            KUtils.updateElapsedMS();
                            Battle.createLEDImage();
                            Utils.loadingRefresh(var1_3 + var3_16 * 70 / 100);
                            break;
                        }
                        case 9: {
                            this.unloadFont();
                            if (this.m_FontNotePad == null) {
                                this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
                            }
                            if (this.m_FontWhite == null) {
                                this.m_FontWhite = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
                            }
                            if (this.m_FontNotePadSmall == null) {
                                this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
                            }
                            if (this.m_FontWhiteSmall == null) {
                                this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
                            }
                            if (this.m_FontPreviousText == null) {
                                this.m_FontPreviousText = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xD2D2D2, false);
                            }
                            if (this.m_FontIndicators == null) {
                                this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                            }
                            KUtils.updateElapsedMS();
                            this.loadSong();
                            this.finishSlidingArrow = false;
                            break;
                        }
                        default: {
                            var4_22 = -2;
                        }
                    }
                    KUtils.updateElapsedMS();
                    if (!Utils.clearKeyIsEnable()) continue;
                    return;
                }
                break;
            }
            case 1: {
                Utils.loadingEnable();
                var1_3 = (byte)Utils.getLoadingPercent();
                var3_17 = 100 - var1_3;
                if (var1_3 == -1) {
                    var1_3 = 0;
                    var3_17 = 100;
                }
                for (var4_23 = 0; var4_23 != -1; ++var4_23) {
                    switch (var4_23) {
                        case 0: {
                            if (!Utils.loadingRefresh(var1_3)) {
                                Utils.loadingDisable();
                                return;
                            }
                            this.cpt_wordWrong = 0;
                            this.cpt_wordGood = 0;
                            this.cpt_wordBest = 0;
                            this.cpt_accMissed = 0;
                            this.cpt_accOk = 0;
                            this.cpt_accGood = 0;
                            this.cpt_accPerfect = 0;
                            this.cpt_blockMissed = 0;
                            this.cpt_rankPoints = Battle.rankMaxPoints;
                            this.bNoTap = false;
                            this.unloadFont();
                            break;
                        }
                        case 1: {
                            Utils.loadingRefresh(var1_3 + var3_17 * 25 / 100);
                            this.loadFont();
                            break;
                        }
                        case 2: {
                            KUtils.updateElapsedMS();
                            if (Battle.m_targetArrow == null) {
                                Battle.m_targetArrow = KResource.load((short)12297, 1);
                            }
                            if (Battle.m_greyArrow == null) {
                                Battle.m_greyArrow = KResource.load((short)12293, 1);
                            }
                            if (Battle.m_scratchImage == null) {
                                Battle.m_scratchImage = KResource.load((short)12294, 1);
                            }
                            KUtils.updateElapsedMS();
                            Battle.createLEDImage();
                            if (Battle.m_nextImage == null) {
                                Battle.m_nextImage = KResource.load((short)12295, 1);
                            }
                            if (Battle.m_meterImage == null) {
                                Battle.m_meterImage = KResource.load((short)12300, 1);
                            }
                            if (Battle.m_thresholdImage == null) {
                                Battle.m_thresholdImage = KResource.load((short)12303, 1);
                            }
                            if (Battle.m_scoreDigitsImage == null) {
                                Battle.m_scoreDigitsImage = KResource.load((short)12301, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_holdMeterImage == null) {
                                Battle.m_holdMeterImage = KResource.load((short)12305, 1);
                            }
                            if (Battle.m_holdMeterBorderImage == null) {
                                Battle.m_holdMeterBorderImage = KResource.load((short)12306, 1);
                            }
                            if (Battle.m_ballImage == null) {
                                Battle.m_ballImage = KResource.load((short)12298, 1);
                            }
                            if (Battle.m_greenPaf == null) {
                                Battle.m_greenPaf = KResource.load((short)12302, 1);
                            }
                            KUtils.updateElapsedMS();
                            if (Battle.m_XRed == null) {
                                Battle.m_XRed = KResource.load((short)12304, 1);
                            }
                            if (Battle.m_ballImageSplash == null) {
                                Battle.m_ballImageSplash = KResource.load((short)12299, 1);
                            }
                            if (Battle.m_target == null) {
                                Battle.m_target = KResource.load((short)12296, 1);
                            }
                            KUtils.updateElapsedMS();
                            this.battlePose[0] = (AnimInstance)HeapManager.instance.get(this.characters[0][0], (byte)0, this.getAnimEmo(this.characters[1][0]));
                            this.slideBattlePose(Utils.getBackBufferGraphics(), 0, 0);
                            this.battlePose[0] = null;
                            Utils.loadingRefresh(var1_3 + var3_17 * 50 / 100);
                            if (this.m_FontNotePad == null) break;
                            Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
                            break;
                        }
                        case 3: {
                            Utils.loadingRefresh(var1_3 + var3_17 * 75 / 100);
                            this.loadRoundLyrics(this.para);
                            break;
                        }
                        case 4: {
                            if (!Utils.loadingRefresh(var1_3 + var3_17)) {
                                Utils.loadingDisable();
                                return;
                            }
                            this.currentTime = 0L;
                            this.displayDelayTime = -1L;
                            this.tapsSucceed = 0;
                            this.startTime = KUtils.s_previousTime;
                            this.scrollPos = 1;
                            this.currentPos = 0;
                            if (!Battle.bTutorialMode) {
                                this.line = 0;
                            }
                            this.holdEndTime = -1L;
                            this.holdStartTime = -1L;
                            this.holdBeginTime = -1L;
                            this.holdFinishTime = -1L;
                            this.holdButton = false;
                            this.pullback = 0;
                            this.bPullingBack = false;
                            this.bSlider1Loaded = false;
                            this.bSlider2Loaded = false;
                            this.characterCounter = (byte)(this.characters[0].length - 1);
                            this.nPercent = 0;
                            this.nPercentMax = 0;
                            this.wordStreak = 0;
                            this.wordSelected = 0;
                            this.bonus = 0;
                            this.tmpBonus = 0;
                            this.displayAnswer = false;
                            this.bAnswerGiven = false;
                            this.bMustDeleteTarget = false;
                            this.bTargetDeleted = false;
                            if (!Battle.bTutorialMode || Battle.bTutorialMode && Tutorial.instance.bGenerateKeys) {
                                if (Battle.bTutorialMode) {
                                    this.line = Tutorial.instance.line;
                                }
                                if (this.mode == 2 || this.line == 0) {
                                    KUtils.updateElapsedMS();
                                    this.m_keysSequence = Battle.generateKeysSequence(0, 4, 4);
                                    KUtils.updateElapsedMS();
                                    this.getTapsPositions(this.line);
                                }
                                if (Tutorial.instance != null) {
                                    Tutorial.instance.bGenerateKeys = false;
                                }
                            }
                            if (this.mode == 1) {
                                this.holdEndTime = this.line == 0 ? this.loopLapseTime - (long)this.getLapseBullEye2EndLine(this.line) : this.loopLapseTime - (long)this.currentTempo - (long)this.getLapseBullEye2EndLine(this.line);
                            }
                            this.unloadFont();
                            if (this.m_FontNotePad == null) {
                                this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
                            }
                            if (this.m_FontWhite == null) {
                                this.m_FontWhite = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
                            }
                            if (this.m_FontNotePadSmall == null) {
                                this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
                            }
                            if (this.m_FontWhiteSmall == null) {
                                this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
                            }
                            if (this.m_FontPreviousText == null) {
                                this.m_FontPreviousText = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xD2D2D2, false);
                            }
                            if (this.m_FontIndicators != null) break;
                            this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                            break;
                        }
                        default: {
                            Utils.rightSoftKeyDisabled = false;
                            var4_23 = -2;
                        }
                    }
                    if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                        Utils.clearKeyEnabled();
                        Utils.loadingDisable();
                        return;
                    }
                    KUtils.updateElapsedMS();
                }
                Utils.loadingDisable();
                return;
            }
            case 4: {
                var1_5 = KResource.load((short)27648, 11);
                switch (this.battleTakeID) {
                    case 2: {
                        this.strFlashCard = new String(Utils.getWordsFrom(24, var1_5));
                        break;
                    }
                    case 7: {
                        this.strFlashCard = new String(Utils.getWordsFrom(91, var1_5));
                        break;
                    }
                    case 19: {
                        this.strFlashCard = new String(Utils.getWordsFrom(150, var1_5));
                    }
                }
                KResource.releaseRes(var1_5.ro_hHandle);
                Utils.setIndicator((byte)4, (byte)1, (KFont)this.m_FontWhite.ro_ref);
                Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontWhite.ro_ref);
                this.bFlashCardLoaded = false;
                return;
            }
            case 11: {
                var3_18 = null;
                var3_18 = Utils.replaceVariable(Utils.getWordsFrom(126, this.fileBufferString), "$p", String.valueOf(this.threshold));
                this.strFlashCard = Game.m_instance.m_bonusMode != false ? Utils.getWordsFrom(147, this.fileBufferString) : Utils.getWordsFrom(317, this.fileBufferString) + Game.m_instance.getBattleNumber(this.battleTakeID);
                this.strFlashCard = this.strFlashCard + "\n" + var3_18 + "\n\n" + Utils.getWordsFrom(140, this.fileBufferString);
                Utils.setIndicator((byte)4, (byte)1, (KFont)this.m_FontWhite.ro_ref);
                Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontWhite.ro_ref);
                this.bFlashCardLoaded = false;
                return;
            }
            case 2: {
                if (RBSound.instance != null) {
                    var2_10 = Game.m_instance.m_sound == false;
                    var1_6 = null;
                    RBSound.instance.soundOff = var2_10;
                    RBSound.instance.Play();
                }
                Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontWhite.ro_ref);
                return;
            }
            case 3: {
                KCanvas.m_keyPressed = 0;
                if (this.bNeedToReSwitchLine) {
                    this.line = this.oldLine;
                    this.para = this.oldPara;
                    this.mode = this.oldMode;
                }
                this.oldLine = this.line;
                this.oldPara = this.para;
                this.oldMode = this.mode;
                this.bNoTap = false;
                this.currentTime = 0L;
                this.displayDelayTime = -1L;
                this.tapsSucceed = 0;
                this.tapsMem = 0;
                this.startTime = KUtils.s_previousTime;
                this.scrollPos = 1;
                this.currentPos = 0;
                this.holdEndTime = -1L;
                this.holdStartTime = -1L;
                this.holdBeginTime = -1L;
                this.holdFinishTime = -1L;
                this.holdButton = false;
                this.pullback = 0;
                this.bPullingBack = false;
                this.bSlider1Loaded = false;
                this.bSlider2Loaded = false;
                this.characterCounter = (byte)(this.characters[0].length - 1);
                this.word = 0;
                this.accuracy = 0;
                this.nPercent = 0;
                this.nPercentMax = 0;
                this.wordSelected = 0;
                this.displayAnswer = false;
                this.bAnswerGiven = false;
                this.bMustDeleteTarget = false;
                this.bTargetDeleted = false;
                this.startNow = true;
                this.line = (byte)(this.line + 1);
                if (this.line == 4) {
                    RBSound.instance.Stop();
                    Utils.loadingIni$252c3fc(16);
                    this.bNeedToReSwitchLine = true;
                    Utils.loadingRefresh(25);
                    if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                        Utils.clearKeyEnabled();
                        return;
                    }
                    this.line = (byte)(this.line % 4);
                    this.para = (byte)(this.para + 1);
                    this.wordStreak = 0;
                    var4_24 = this.getMaxPara();
                    Utils.loadingRefresh(50);
                    if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                        Utils.clearKeyEnabled();
                        return;
                    }
                    Utils.loadingRefresh(75);
                    if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                        Utils.clearKeyEnabled();
                        return;
                    }
                    if (this.para > var4_24) {
                        this.m_battleRunning = false;
                        this.bNeedToReSwitchLine = false;
                        Utils.loadingRefresh(100);
                        if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                            Utils.clearKeyEnabled();
                            return;
                        }
                        Utils.drawIndicatorBG(KGraphics.getGraphics());
                        Utils.drawIndicators$bfed7fe(null);
                        return;
                    }
                    if (var4_24 == 6 || var4_24 == 4) {
                        this.mode = this.mode == 2 ? 1 : (byte)2;
                    }
                    if (this.m_FontNotePad == null) {
                        this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
                    }
                    if (Battle.m_targetArrow == null) {
                        Battle.m_targetArrow = KResource.load((short)12297, 1);
                    }
                    this.loadRoundLyrics(this.para);
                    Utils.loadingRefresh(100);
                    if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                        Utils.clearKeyEnabled();
                        return;
                    }
                    Utils.drawIndicatorBG(KGraphics.getGraphics());
                    Utils.drawIndicators$bfed7fe(null);
                    if (Utils.refresh != Utils.REFRESH_NEEDED_FULL) {
                        RBSound.instance.restartSong(this.currentTempo);
                        this.startTime = System.currentTimeMillis();
                    }
                }
                this.getTargetPositions(this.line);
                if (this.mode == 2 || this.line == 0) {
                    this.m_keysSequence = Battle.generateKeysSequence(0, 4, 4);
                    this.getTapsPositions(this.line);
                    if (this.getNextTap(this.currentPos + 1) == -1) {
                        this.bNoTap = true;
                    }
                }
                if (this.mode == 1) {
                    this.holdEndTime = this.line == 0 ? this.loopLapseTime - (long)this.getLapseBullEye2EndLine(this.line) : this.loopLapseTime - (long)this.currentTempo - (long)this.getLapseBullEye2EndLine(this.line);
                }
                KCanvas.m_keyPressed = 0;
                this.loadUpdatedPoses();
                this.bNeedToReSwitchLine = false;
                return;
            }
            case 5: {
                if (Utils.loadingCriticalPart) {
                    Utils.loadingCriticalPart = false;
                }
                RBSound.instance.Stop();
                this.bStateTutorial = false;
                if (Tutorial.instance.bFromInterrupt) {
                    this.lineScoreDisplayed = false;
                    Tutorial.instance.bDrawNext = true;
                    Tutorial.instance.bReload = true;
                    Tutorial.instance.bGenerateKeys = true;
                } else {
                    Tutorial.instance.bDrawNext = false;
                }
                Tutorial.instance.bReadyToLoadNext = true;
                if (Tutorial.instance.bDrawIndicator) {
                    this.unloadFont();
                    KUtils.updateElapsedMS();
                    Utils.setIndicator((byte)0, (byte)0);
                    this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                    KUtils.updateElapsedMS();
                    this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
                    Utils.setIndicator((byte)4, (byte)1, (KFont)this.m_FontIndicators.ro_ref);
                    Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontIndicators.ro_ref);
                    KUtils.updateElapsedMS();
                    Utils.drawIndicatorBG(Utils.getBackBufferGraphics());
                    Utils.drawIndicators$bfed7fe((KFont)this.m_FontIndicators.ro_ref);
                }
                this.unloadFont();
                if (this.m_FontNotePad == null) {
                    this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
                }
                if (this.m_FontWhite == null) {
                    this.m_FontWhite = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
                }
                if (this.m_FontNotePadSmall == null) {
                    this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
                }
                if (this.m_FontWhiteSmall == null) {
                    this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
                }
                if (this.m_FontPreviousText == null) {
                    this.m_FontPreviousText = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xD2D2D2, false);
                }
                if (this.m_FontIndicators != null) break;
                this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                return;
            }
            case 9: {
                Battle.UnloadUselessStuff();
                Game.m_instance.bonusNb = (byte)3;
                Utils.loadingIni$252c3fc(16);
                Utils.getBackBufferGraphics().setColor(0);
                Utils.getBackBufferGraphics().fillRect(0, 0, Utils.BACK_BUFFER_WIDTH, Utils.BACK_BUFFER_HEIGHT);
                var5_29 = 0;
                if (this.location != 0) {
                    var6_33 = Battle.getLocationBackgroundFilter(this.location);
                    var7_44 = (Image)((KRes)HeapManager.instance.get((int)var6_33, (byte)1, (int)0)).ro_ref;
                    var4_25 = Utils.BACK_BUFFER_WIDTH - var7_44.getWidth() >> 1;
                    var5_29 = (Utils.BACK_BUFFER_HEIGHT - var7_44.getHeight() << 2) / 7 + 9;
                    Utils.getBackBufferGraphics().drawImage(var7_44, var4_25, var5_29, 0);
                    if (!Utils.loadingRefresh(10)) {
                        return;
                    }
                }
                var6_34 = (Image)((KRes)HeapManager.instance.get((int)28676, (byte)1, (int)0)).ro_ref;
                var5_29 = Game.menu_position_y - Game.titleHeight >> 1;
                Utils.getBackBufferGraphics().drawImage(var6_34, (KCanvas.m_width - var6_34.getWidth()) / 3, var5_29, 0);
                var2_11 = false;
                var4_25 = KCanvas.m_width - 176 >> 1;
                var5_29 = (Utils.BACK_BUFFER_HEIGHT - var6_34.getHeight()) / 2;
                if (this.battleType == 7 && this.getRank() == 5) {
                    var5_29 -= 18;
                }
                var7_44 = Utils.getBackBufferGraphics();
                var7_44.setColor(144459);
                var7_44.fillRect(var4_25, var5_29, 176, 90);
                var7_44.setColor(0xFFFFFF);
                var7_44.drawRect(var4_25, var5_29, 176, 90);
                var4_25 += 2;
                var2_12 = KGraphics.setGraphics(Utils.getBackBufferGraphics());
                this.unloadFont();
                this.m_FontNotePad = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, true);
                Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
                var8_52 = 0;
                var1_3 = (byte)(18 - KGraphics.textHeight());
                if (this.getRank() == 5) {
                    var3_19 = Utils.getWordsFrom(164, this.fileBufferString);
                    var3_19.getChars(0, var3_19.length(), Utils.charBuffer, 0);
                } else {
                    var3_19 = Utils.getWordsFrom(153, this.fileBufferString);
                    var3_19.getChars(0, var3_19.length(), Utils.charBuffer, 0);
                }
                var6_35 = 0;
                if (KGraphics.textWidth(Utils.charBuffer, 0, var3_19.length()) > KCanvas.m_width) {
                    var7_45 = -1;
                    var8_52 = -1;
                    for (var10_65 = var9_58 = var3_19.length() / 2; var10_65 > -1; --var10_65) {
                        if (var3_19.charAt(var10_65) != ' ') continue;
                        var7_45 = var10_65;
                        var10_65 = -1;
                    }
                    for (var10_65 = var9_58 + 1; var10_65 < var3_19.length(); ++var10_65) {
                        if (var3_19.charAt(var10_65) != ' ') continue;
                        var8_52 = var10_65;
                        var10_65 = var3_19.length();
                    }
                    var10_65 = var9_58 - var7_45 < var8_52 - (var9_58 + 1) ? var7_45 : var8_52;
                    var3_19.getChars(0, var10_65, Utils.charBuffer, 0);
                    KGraphics.drawText(Utils.charBuffer, 0, var10_65, KCanvas.m_width - KGraphics.textWidth(Utils.charBuffer, 0, var10_65) >> 1, var1_3 + var5_29);
                    var3_19.getChars(var10_65 + 1, var3_19.length(), Utils.charBuffer, 0);
                    KGraphics.drawText(Utils.charBuffer, var10_65 + 1, var3_19.length() - var10_65 - 1, KCanvas.m_width - KGraphics.textWidth(Utils.charBuffer, var10_65 + 1, var3_19.length() - (var10_65 + 1)) >> 1, var1_3 + var5_29 + KGraphics.textHeight() - 2);
                } else {
                    KGraphics.drawText(Utils.charBuffer, 0, var3_19.length(), var4_25 + (176 - KGraphics.textWidth(Utils.charBuffer, 0, var3_19.length()) >> 1), var1_3 + var5_29);
                }
                KGraphics.s_fontFG.m_bold = false;
                var3_19 = this.getRank() == 5 ? Utils.getWordsFrom(196, this.fileBufferString) : Utils.getWordsFrom(186, this.fileBufferString);
                var3_19.getChars(0, var3_19.length(), Utils.charBuffer, 0);
                var3_19.length();
                KGraphics.drawText(Utils.charBuffer, 0, var3_19.length(), var4_25 + (176 - KGraphics.textWidth(Utils.charBuffer, 0, var3_19.length()) >> 1), var5_29 + var1_3 + 36);
                KGraphics.s_fontFG.m_bold = true;
                var3_19 = Utils.getWordsFrom(175, this.fileBufferString);
                var3_19.getChars(0, var3_19.length(), Utils.charBuffer, 0);
                var3_19 = new String(var3_19);
                var3_19 = var3_19 + " " + String.valueOf(this.score);
                var3_19 = var3_19 + String.valueOf(Utils.getWordsFrom(182, this.fileBufferString).toCharArray());
                var3_19.getChars(0, var3_19.length(), Utils.charBuffer, 0);
                var6_35 = KGraphics.textWidth(Utils.charBuffer, 0, var3_19.length());
                KGraphics.drawText(Utils.charBuffer, 0, var3_19.length(), var4_25 + (176 - var6_35 >> 1), var5_29 + var1_3 + 54);
                KGraphics.s_fontFG.m_bold = false;
                var7_46 = this.getRank() != 5 ? 0 : 1;
                if (this.battleType == 7) {
                    if (var7_46 == 1) {
                        this.load5manDespair();
                    } else {
                        this.load5man((byte)var7_46);
                    }
                    if (Utils.clearKeyIsEnable()) {
                        return;
                    }
                } else {
                    var4_25 = KCanvas.m_width - 75 >> 1;
                    Battle.drawAnimRec(Utils.getBackBufferGraphics(), var4_25, var5_29 += 110, 75, 90, 0xFF0000);
                    var8_53 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, var7_46);
                    var9_58 = var5_29 + 90 - var8_53.getBottom();
                    if (this.battleType == 4) {
                        KUtils.updateElapsedMS();
                        var10_65 = 0;
                        var1_7 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, var7_46);
                        var9_58 = var5_29 + 90 - var8_53.getBottom() + 1;
                        var10_65 = var5_29 + 90 - var1_7.getBottom() + 1;
                        ((AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, var7_46)).draw((var4_25 += 10) + 50, var9_58, false, false);
                        ((AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, var7_46)).draw((var4_25 -= 20) + 25, var10_65, false, false);
                    } else {
                        if (this.rapperPartner != 0) {
                            KUtils.updateElapsedMS();
                            var10_66 = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, var7_46);
                            v0 = var9_58;
                            var1_3 = (byte)v0;
                            if (v0 + var10_66.getBottom() < KCanvas.m_height - 8) {
                                var1_3 = (byte)(KCanvas.m_height - 8 - var10_66.getBottom());
                            }
                            if (var9_58 + var8_53.getBottom() < KCanvas.m_height - 8) {
                                var9_58 = KCanvas.m_height - 8 - var8_53.getBottom();
                            }
                            var10_66.draw(var4_25 + 50 + 10, var1_3, false, false);
                        }
                        if (this.rapperPartner != 0) {
                            ((AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, var7_46)).draw(var4_25 + 25 - 10, var9_58, false, false);
                        } else {
                            var8_53.draw(var4_25 + 37, var9_58, false, false);
                        }
                    }
                    Utils.getBackBufferGraphics().setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
                    KGraphics.setGraphics(var2_12);
                }
                Utils.setIndicator((byte)4, (byte)1);
                Utils.setIndicator((byte)6, (byte)2);
                if (Utils.loadingRefresh(100)) break;
                return;
            }
            case 10: {
                this.bStatsDisplayed = false;
                this.unloadFont();
                this.m_FontNotePad = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0, false);
                this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                var4_26 = Utils.getBackBufferGraphics();
                var4_26.setColor(0);
                var4_26.fillRect(0, 0, KCanvas.m_width, KCanvas.m_height);
                var5_30 = (Image)((KRes)HeapManager.instance.get((int)28676, (byte)1, (int)0)).ro_ref;
                var2_13 = (byte)(Game.menu_position_y - Game.titleHeight >> 1);
                var7_47 = (short)(var5_30.getHeight() + var2_13);
                var8_54 = (short)(var7_47 + var2_13);
                var1_3 = 0;
                var3_20 = (short)(Utils.BACK_BUFFER_WIDTH - 220 >> 1);
                this.m_notePad_stats_y = var7_47;
                var4_26.drawImage(var5_30, (Utils.BACK_BUFFER_WIDTH - var5_30.getWidth()) / 3, (int)var2_13, 0);
                var5_30 = (Image)((KRes)HeapManager.instance.get((int)12307, (byte)1, (int)0)).ro_ref;
                KGraphics.setGraphics(var4_26);
                KGraphics.drawRegion(var5_30, 0, 69, 220, 13, 1, (int)var3_20, (int)var8_54);
                var8_54 = (short)(var8_54 + 13);
                while (var8_54 + 38 < 300) {
                    KGraphics.drawRegion(var5_30, 0, 32, 220, 38, 0, (int)var3_20, (int)var8_54);
                    var8_54 = (short)(var8_54 + 38);
                }
                while (var8_54 + (var1_3 + 1) * 13 < 300) {
                    var1_3 = (byte)(var1_3 + 1);
                }
                if (var1_3 != 0) {
                    KGraphics.drawRegion(var5_30, 0, 32, 220, var1_3 * 13, 0, (int)var3_20, (int)var8_54);
                    var8_54 = (short)(var8_54 + var1_3 * 13);
                }
                var8_54 = (short)(var8_54 - 2);
                KGraphics.drawRegion(var5_30, 0, 69, 220, 13, 0, (int)var3_20, (int)var8_54);
                Utils.setIndicator((byte)4, (byte)1);
                Utils.setIndicator((byte)6, (byte)2);
                return;
            }
            case 6: {
                if (!this.bAnswerGiven) {
                    this.line = (byte)(this.line - 1);
                }
                this.setState((byte)3);
                Battle.m_state = (byte)6;
                if (this.m_FontWhite != null) {
                    Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontWhite.ro_ref);
                }
                Battle.createLEDImage();
                if (Battle.m_scratchImage == null) {
                    Battle.m_scratchImage = KResource.load((short)12294, 1);
                }
                Utils.rightSoftKeyDisabled = false;
                this.bStateResume = false;
                this.bResumeDrawBubble = true;
                this.setCrowdMeterColor((byte)1, this.bonus, this.score);
                if (!Battle.bTutorialMode) {
                    this.bonus = this.tmpBonus;
                    Utils.loadingIni$252c3fc(20);
                    if (!Utils.loadingRefresh(0)) {
                        return;
                    }
                    var6_36 = Utils.getBackBufferGraphics();
                    if (!Utils.loadingRefresh(30)) {
                        return;
                    }
                    if (this.location != 0) {
                        var7_48 = Battle.getLocationBackground(this.location);
                        var8_55 = null;
                        var9_59 = (Image)((KRes)HeapManager.instance.get((int)var7_48, (byte)1, (int)0)).ro_ref;
                        var10_67 = KCanvas.m_width - var9_59.getWidth() >> 1;
                        var6_36.drawImage(var9_59, var10_67, 165, 0);
                    }
                    if (!Utils.loadingRefresh(40)) {
                        return;
                    }
                    this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
                    this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                    if (!Utils.loadingRefresh(44)) {
                        return;
                    }
                    Utils.setIndicator((byte)4, (byte)1);
                    Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontIndicators.ro_ref);
                    if (Battle.m_ballImage == null) {
                        Battle.m_ballImage = KResource.load((short)12298, 1);
                    }
                    if (Battle.m_ballImageSplash == null) {
                        Battle.m_ballImageSplash = KResource.load((short)12299, 1);
                    }
                    if (Battle.m_targetArrow == null) {
                        Battle.m_targetArrow = KResource.load((short)12297, 1);
                    }
                    if (Battle.m_greyArrow == null) {
                        Battle.m_greyArrow = KResource.load((short)12293, 1);
                    }
                    if (!Utils.loadingRefresh(48)) {
                        return;
                    }
                    if (Battle.m_target == null) {
                        Battle.m_target = KResource.load((short)12296, 1);
                    }
                    if (Battle.m_XRed == null) {
                        Battle.m_XRed = KResource.load((short)12304, 1);
                    }
                    if (Battle.m_greenPaf == null) {
                        Battle.m_greenPaf = KResource.load((short)12302, 1);
                    }
                    if (Battle.m_meterImage == null) {
                        Battle.m_meterImage = KResource.load((short)12300, 1);
                    }
                    if (Battle.m_thresholdImage == null) {
                        Battle.m_thresholdImage = KResource.load((short)12303, 1);
                    }
                    if (Battle.m_scoreDigitsImage == null) {
                        Battle.m_scoreDigitsImage = KResource.load((short)12301, 1);
                    }
                    if (Battle.m_holdMeterImage == null) {
                        Battle.m_holdMeterImage = KResource.load((short)12305, 1);
                    }
                    if (Battle.m_holdMeterBorderImage == null) {
                        Battle.m_holdMeterBorderImage = KResource.load((short)12306, 1);
                    }
                    if (Battle.m_nextImage == null) {
                        Battle.m_nextImage = KResource.load((short)12295, 1);
                    }
                    if (Battle.m_tutoNextImg == null) {
                        Battle.m_tutoNextImg = KResource.load((short)10240, 1);
                    }
                    if ((this.battleType == 3 || this.battleType == 2 || this.battleType == 5 || this.battleType == 6 || this.battleType == 1 && this.opponent != 0) && Battle.m_bubbleImage == null) {
                        Battle.m_bubbleImage = KResource.load((short)12291, 1);
                    }
                    if (!Utils.loadingRefresh(52)) {
                        return;
                    }
                    var7_49 = (Image)((KRes)HeapManager.instance.get((int)12307, (byte)1, (int)0)).ro_ref;
                    var6_36.drawImage(var7_49, 0, 0, 20);
                    var6_36.drawRegion(var7_49, 0, 22, KCanvas.m_width, var7_49.getHeight() - 22, 0, 0, 50, 20);
                    var6_36.drawRegion(var7_49, 0, 22, KCanvas.m_width, var7_49.getHeight() - 22, 0, 0, 78, 20);
                    var6_36.drawRegion(var7_49, 0, 22, KCanvas.m_width, var7_49.getHeight() - 22, 0, 0, 106, 20);
                    if (!Utils.loadingRefresh(56)) {
                        return;
                    }
                    if (Battle.m_scratchImage == null) {
                        Battle.m_scratchImage = KResource.load((short)12294, 1);
                    }
                    if (Battle.m_scratchImage_176 == null) {
                        Battle.m_scratchImage_176 = KResource.load((short)28674, 1);
                    }
                    if (Battle.m_nextImage == null) {
                        Battle.m_nextImage = KResource.load((short)12295, 1);
                    }
                    if (!Utils.loadingRefresh(70)) {
                        return;
                    }
                }
                for (var8_56 = 0; var8_56 < this.characters[0].length; ++var8_56) {
                    if (this.battleType != 7) {
                        if (this.battleType == 7 || this.battleType == 5 || this.battleType == 6 || this.battleType == 4 && this.para % 2 == 1) {
                            this.battlePose[this.characters[0].length - var8_56 - 1] = (AnimInstance)HeapManager.instance.get(this.characters[0][this.characters[0].length - var8_56 - 1], (byte)0, this.getAnimEmo(this.characters[1][this.characters[0].length - var8_56 - 1]));
                        } else {
                            this.battlePose[var8_56] = (AnimInstance)HeapManager.instance.get(this.characters[0][var8_56], (byte)0, this.getAnimEmo(this.characters[1][var8_56]));
                        }
                    }
                    KUtils.updateElapsedMS();
                    KUtils.updateElapsedMS();
                    KUtils.updateElapsedMS();
                    if (this.battleType == 7) continue;
                    if (this.battleType == 7 || this.battleType == 5 || this.battleType == 6 || this.battleType == 4 && this.para % 2 == 1) {
                        this.slideBattlePose(null, 0, this.characters[0].length - var8_56 - 1);
                        this.battlePose[this.characters[0].length - var8_56 - 1] = null;
                        continue;
                    }
                    this.slideBattlePose(null, 0, var8_56);
                    this.battlePose[var8_56] = null;
                }
                if (this.battleType == 7) {
                    for (var8_56 = 4; var8_56 >= 0; --var8_56) {
                        this.battlePose[var8_56] = (AnimInstance)HeapManager.instance.get(this.characters[0][var8_56], (byte)0, this.getAnimEmo(this.characters[1][var8_56]));
                        KUtils.updateElapsedMS();
                        this.slideBattlePose(null, 0, var8_56);
                        this.battlePose[var8_56] = null;
                    }
                }
                if (!Battle.bTutorialMode && !Utils.loadingRefresh(85)) {
                    return;
                }
                this.unloadFont();
                if (this.m_FontNotePad == null) {
                    this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
                }
                if (this.m_FontWhite == null) {
                    this.m_FontWhite = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xFFFFFF, false);
                }
                if (this.m_FontNotePadSmall == null) {
                    this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
                }
                if (this.m_FontWhiteSmall == null) {
                    this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
                }
                if (this.m_FontPreviousText == null) {
                    this.m_FontPreviousText = (KRes)HeapManager.instance.get("fontBattle.fpak", 0xD2D2D2, false);
                }
                if (this.m_FontIndicators == null) {
                    this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                }
                Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
                this.bRoundLoaded = false;
                this.refreshClearBits();
                Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                this.display_waiting_time = String.valueOf(3);
                this.waitingTime = System.currentTimeMillis();
                KUtils.updateElapsedMS();
                Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontNotePad.ro_ref);
                this.loadSong();
                if (!Battle.bTutorialMode && !Utils.loadingRefresh(100)) {
                    return;
                }
                Utils.rightSoftKeyDisabled = false;
                return;
            }
            case 7: {
                if (!Tutorial.instance.isEventSuccessful()) break;
                this.refreshScore();
            }
        }
    }

    public static void UnloadUselessStuff() {
        if (m_ballImage != null) {
            m_ballImage = KResource.releaseRes(Battle.m_ballImage.ro_hHandle);
        }
        if (m_ballImageSplash != null) {
            m_ballImageSplash = KResource.releaseRes(Battle.m_ballImageSplash.ro_hHandle);
        }
        if (m_targetArrow != null) {
            m_targetArrow = KResource.releaseRes(Battle.m_targetArrow.ro_hHandle);
        }
        if (m_greyArrow != null) {
            m_greyArrow = KResource.releaseRes(Battle.m_greyArrow.ro_hHandle);
        }
        if (m_XRed != null) {
            m_XRed = KResource.releaseRes(Battle.m_XRed.ro_hHandle);
        }
        if (m_target != null) {
            m_target = KResource.releaseRes(Battle.m_target.ro_hHandle);
        }
        if (m_greenPaf != null) {
            m_greenPaf = KResource.releaseRes(Battle.m_greenPaf.ro_hHandle);
        }
        if (m_meterImage != null) {
            m_meterImage = KResource.releaseRes(Battle.m_meterImage.ro_hHandle);
        }
        if (m_scoreDigitsImage != null) {
            m_scoreDigitsImage = KResource.releaseRes(Battle.m_scoreDigitsImage.ro_hHandle);
        }
        if (m_thresholdImage != null) {
            m_thresholdImage = KResource.releaseRes(Battle.m_thresholdImage.ro_hHandle);
        }
        if (m_holdMeterImage != null) {
            m_holdMeterImage = KResource.releaseRes(Battle.m_holdMeterImage.ro_hHandle);
        }
        if (m_holdMeterBorderImage != null) {
            m_holdMeterBorderImage = KResource.releaseRes(Battle.m_holdMeterBorderImage.ro_hHandle);
        }
        if (m_ledProgressBar != null) {
            m_ledProgressBar = KResource.releaseRes(Battle.m_ledProgressBar.ro_hHandle);
        }
        if (m_scratchImage != null) {
            m_scratchImage = KResource.releaseRes(Battle.m_scratchImage.ro_hHandle);
        }
        if (m_bubbleImage != null) {
            m_bubbleImage = KResource.releaseRes(Battle.m_bubbleImage.ro_hHandle);
        }
        if (m_nextImage != null) {
            m_nextImage = KResource.releaseRes(Battle.m_nextImage.ro_hHandle);
        }
        if (m_tutoNextImg != null) {
            m_tutoNextImg = KResource.releaseRes(Battle.m_tutoNextImg.ro_hHandle);
        }
    }

    public final boolean move() {
        boolean bl = false;
        if (m_state == 2) {
            if (this.startNow) {
                this.startNow = false;
                this.startTime = KUtils.s_previousTime;
            }
            this.currentTime = KUtils.s_previousTime - this.startTime;
        }
        switch (m_state) {
            case 0: {
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                    this.unloadFont();
                    this.setState((byte)8);
                    this.bIntroDrawn = false;
                    break;
                }
                if (!this.bInitialized) {
                    Object var2_2 = null;
                    if (!bTutorialMode) {
                        for (int i = this.characters[0].length - 1; i >= 0; --i) {
                            this.battlePose[i] = (AnimInstance)HeapManager.instance.get(this.characters[0][i], (byte)0, this.getAnimEmo(this.characters[1][i]));
                            this.slideBattlePose(null, 0, i);
                            if (!Utils.loadingRefresh(Utils.getLoadingPercent() + 5)) {
                                return false;
                            }
                            this.battlePose[i] = null;
                        }
                        KGraphics.setGraphics(null);
                        if (!Utils.loadingRefresh(Utils.getLoadingPercent() + 5)) {
                            return false;
                        }
                    } else {
                        this.battlePose[0] = (AnimInstance)HeapManager.instance.get(this.characters[0][0], (byte)0, this.getAnimEmo(this.characters[1][0]));
                        this.slideBattlePose(null, 0, 0);
                        this.battlePose[0] = null;
                        this.loadRoundLyrics(this.para);
                        Utils.loadingRefresh(100);
                    }
                    if (KCanvas.m_actionCode == 97 || !KCanvas.s_gameIsRunning) {
                        Utils.clearKeyEnabled();
                        return false;
                    }
                    this.bInitialized = true;
                    this.bIntroDrawn = false;
                    break;
                }
                if (bTutorialMode && this.bIntroDrawn) {
                    this.setState((byte)5);
                    break;
                }
                if (bTutorialMode) {
                    this.setState((byte)5);
                } else {
                    this.unloadFont();
                    this.setState((byte)1);
                }
                KCanvas.m_keyPressed = 0;
                break;
            }
            case 1: {
                if ((KCanvas.m_keyPressed == 64 && Utils.refresh != Utils.REFRESH_NEEDED_FULL || loadTutoPartEnable && Tutorial.instance != null) && (KCanvas.m_keyPressed == 64 || Tutorial.instance.bActionNext)) {
                    this.bRoundLoaded = false;
                    KCanvas.m_keyPressed = 0;
                    this.characterCounter = (byte)(this.characters[0].length - 1);
                    if (!bTutorialMode) {
                        if (!(this.battleTakeID != 2 && this.battleTakeID != 7 && this.battleTakeID != 19 || Game.m_instance.m_extraMode)) {
                            this.setState((byte)4);
                        } else {
                            this.setState((byte)11);
                        }
                    } else {
                        this.waitingTime = System.currentTimeMillis();
                        m_state = (byte)6;
                    }
                }
                if (Utils.refresh != Utils.REFRESH_NEEDED_FULL) break;
                Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                this.setState((byte)8);
                break;
            }
            case 4: 
            case 11: {
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    this.setState((byte)6);
                    break;
                }
                if (m_state == 4) {
                    this.isInFlashCard = true;
                    this.isInGoal = false;
                } else {
                    this.isInFlashCard = false;
                    this.isInGoal = true;
                }
                if (!this.bFlashCardLoaded) {
                    char[][] cArrayArray = new char[][]{this.strFlashCard.toCharArray()};
                    this.tvpFlashCard = new TextViewport((KFont)this.m_FontNotePad.ro_ref, null, null, m_state == 4 ? null : (KFont)this.m_FontNotePad.ro_ref, cArrayArray, 26, 24, KCanvas.m_width - 52, 116, true, 2, 0, true);
                    if (m_state == 4) {
                        int n = this.strFlashCard.indexOf("\n");
                        boolean bl2 = false;
                        TextViewport textViewport = this.tvpFlashCard;
                        if (n > 0) {
                            textViewport.m_boldOffset = 0;
                            textViewport.m_boldLenght = n;
                        }
                    }
                    this.bFlashCardScrolled = true;
                    this.bFlashCardDraw = true;
                    this.bFlashCardLoaded = true;
                } else if (KCanvas.m_keyPressed == 64) {
                    if (!this.bFlashCardScrolled && this.tvpFlashCard.isTextScrollableDown()) {
                        this.tvpFlashCard.scrollTextDown(4);
                        this.bFlashCardScrolled = true;
                        this.bFlashCardDraw = true;
                    } else if (m_state == 4) {
                        this.isInGoal = true;
                        this.isInFlashCard = false;
                        this.setState((byte)11);
                        m_tutoNextImg = KResource.releaseRes(Battle.m_tutoNextImg.ro_hHandle);
                    } else {
                        this.tvpFlashCard = null;
                        Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
                        this.waitingTime = System.currentTimeMillis();
                        this.refreshClearBits();
                        this.isInGoal = false;
                        m_state = (byte)6;
                        Utils.setIndicator((byte)0, (byte)1);
                        this.refreshDone((byte)4, 0x100000);
                    }
                }
                KCanvas.m_keyPressed = 0;
                break;
            }
            case 2: {
                short s;
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    if (this.bAnswerGiven) {
                        this.lineScoreDisplayed = false;
                        this.refreshScore();
                        this.flushBattlePoses();
                        if (this.para == this.getMaxPara() && this.line == 3) {
                            this.refreshClearBits();
                            this.setState((byte)9);
                            break;
                        }
                    }
                    this.refreshClearBits();
                    this.setState((byte)6);
                    break;
                }
                int n = this.currentTempo;
                byte by = this.line;
                long l = this.currentTime;
                Battle battle = this;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                n3 = (int)(l / (long)n);
                n2 = (int)(l % (long)n);
                if (n3 >= 16) {
                    n3 %= 16;
                }
                short s2 = n3 + 1;
                n3 = Utils.charIndexOf(battle.charBeats[by], '*', 0, (int)battle.charBeatsLength[by]);
                for (s = 1; s < s2; ++s) {
                    n4 = Utils.charIndexOf(battle.charBeats[by], '~', n3 + 1, battle.charBeatsLength[by] - n3 - 1);
                    if ((n4 >= (n3 = Utils.charIndexOf(battle.charBeats[by], '*', n3 + 1, battle.charBeatsLength[by] - n3 - 1)) || n4 == -1) && (n3 != -1 || n4 == -1)) continue;
                    n3 = n4;
                }
                s2 = 0;
                if ('~' == battle.charBeats[by][n3]) {
                    --n3;
                    s2 = 1;
                }
                if ((n5 = Utils.charIndexOf(battle.charBeats[by], '*', n3 + 1, battle.charBeatsLength[by] - n3 - 1)) == -1) {
                    n5 = n3;
                }
                if ((n4 = (n4 = Utils.charIndexOf(battle.charBeats[by], '~', n3, battle.charBeatsLength[by] - n3)) != -1 && n4 < n5 ? 1 : 0) == 1) {
                    n2 = (n5 - n3) * (n2 * 50) / (n * 100);
                    if (s2 == 1) {
                        n2 += (n5 - n3) * 50 / 100;
                    }
                } else {
                    n2 = (n5 - n3) * n2 / n;
                }
                this.currentPos = n2 + n3;
                this.m_lastKeyPressed = KCanvas.m_keyPressed;
                int n6 = this.scrollPos;
                s2 = this.line;
                s = this.currentPos;
                int[] nArray = this.m_LinesDisplayArray[s2];
                n = 1;
                n2 = 1;
                while (n < nArray[0]) {
                    if (s >= nArray[(n << 1) + 1]) {
                        n2 += 2;
                        ++n;
                        continue;
                    }
                    n = nArray[0];
                }
                this.scrollPos = n2;
                battle = this;
                s = (int)(battle.currentTime * (long)270) / 1000 % 360;
                s2 = (int)(battle.currentTime * (long)270) / 1000 % 360;
                n4 = (100 * KMath.cos(s) >> 14) + 100 >> 1;
                n5 = (100 * KMath.cos(s2) >> 14) + 100 >> 1;
                s = (n4 + n5) / 2;
                int n7 = 0;
                s2 = s * 100 / 100;
                n4 = s * 96 / 100;
                n7 = s * 35 / 100;
                n4 += 57;
                n7 += 186;
                if ((s2 += 2) > 255) {
                    s2 = 255;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (n7 > 255) {
                    n7 = 255;
                }
                int n8 = 0;
                Battle.m_ColorsSettings[Battle.COLOR_FLASH_TARGET] = n8 = 0 + (s2 << 16) + (n4 << 8) + n7;
                if (n6 != this.scrollPos) {
                    this.displayDelayTime = -1L;
                }
                if (this.loopLapseTime <= this.currentTime) {
                    this.currentTime = -1L;
                    if (KCanvas.m_keyPressed != 0 && !this.lineScoreDisplayed) {
                        this.accuracy = 0;
                        this.lastHitSucceed = false;
                    }
                    this.lineScoreDisplayed = false;
                    if (bTutorialMode) {
                        if (Tutorial.instance.isTestingOffenseLine() || Tutorial.instance.isTestingLeaderLine2()) {
                            if (this.accuracy == 0) {
                                Tutorial.instance.setEventUnsuccessful(true);
                            } else if (this.getWordValue(this.line, this.wordSelected, false) != 3) {
                                Tutorial.instance.setEventUnsuccessful(false);
                            } else {
                                Tutorial.instance.setEventSuccessful();
                            }
                        } else if (Tutorial.instance.isTestingDefenseLine()) {
                            if (this.tapsSucceed < 2) {
                                Tutorial.instance.setEventUnsuccessful(true);
                            } else {
                                Tutorial.instance.setEventSuccessful();
                            }
                        }
                        this.setState((byte)7);
                        break;
                    }
                    this.refreshScore();
                    this.flushBattlePoses();
                    if (RBSound.instance != null && !bTutorialMode) {
                        RBSound.instance.Stop();
                        RBSound rBSound = RBSound.instance;
                        rBSound.Stop();
                        rBSound.s_playerSong = null;
                        System.gc();
                        this.loadSong();
                        boolean bl3 = !Game.m_instance.m_sound;
                        Object var2_6 = null;
                        RBSound.instance.soundOff = bl3;
                        RBSound.instance.restartSong(this.currentTempo);
                    }
                    this.setState((byte)3);
                    if (!Utils.clearKeyIsEnable()) break;
                    return false;
                }
                if (!this.m_battleRunning) {
                    KCanvas.m_keyPressed = 0;
                    if (RBSound.instance != null) {
                        RBSound.instance.Stop();
                    }
                    this.setState((byte)9);
                }
                if (this.mode == 1) {
                    if (this.line == 0) {
                        if (-1 == this.getNextTap(this.currentPos) || this.bNoTap) {
                            if (bTutorialMode && Tutorial.instance.isTestingLeaderLine1()) {
                                if (this.tapsSucceed == 0) {
                                    Tutorial.instance.setEventUnsuccessful(true);
                                } else {
                                    Tutorial.instance.setEventSuccessful();
                                }
                                this.setState((byte)5);
                                break;
                            }
                            if (this.holdStartTime == -1L && this.currentTime >= (long)(2 * this.currentTempo)) {
                                this.holdStartTime = this.currentTime + 250L;
                                this.keySlidePercent = this.currentTime + 250L;
                            }
                            if (KCanvas.m_keyPressed != 0 && this.holdBeginTime == -1L && this.currentTime >= (long)(2 * this.currentTempo)) {
                                n6 = this.getBigKey();
                                this.holdButton = this.checkKeyValue(KCanvas.m_keyPressed, n6);
                                if (this.holdButton) {
                                    this.holdBeginTime = this.currentTime;
                                    this.keyBeingHold = KCanvas.m_keyPressed;
                                }
                                this.nPercentMax = 100 - (int)(100L * (this.holdBeginTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime));
                                if (this.nPercentMax > 100) {
                                    this.nPercentMax = 100;
                                }
                            } else if (this.holdBeginTime != -1L && (KCanvas.m_keyPressed == 0 || KCanvas.m_keyPressed != this.keyBeingHold) && this.holdFinishTime == -1L && this.currentTime >= (long)(2 * this.currentTempo)) {
                                this.holdFinishTime = this.currentTime;
                                this.keyBeingHold = 0;
                                this.lastHitSucceed = this.isOnTarget(this.currentPos, this.line);
                                this.displayDelayTime = this.currentTime + 1000L;
                                this.displayX = this.ballX;
                                this.displayY = this.ballY;
                                this.holdButton = false;
                                this.bAnswerGiven = true;
                                if (bTutorialMode && Tutorial.instance.isTestingLeaderLine2()) {
                                    if (this.lastHitSucceed) {
                                        Tutorial.instance.setEventSuccessful();
                                    } else {
                                        Tutorial.instance.setEventUnsuccessful(false);
                                    }
                                    this.setState((byte)7);
                                }
                            } else if (this.holdButton) {
                                this.nPercent = (int)(100L * (this.currentTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime));
                                this.nPercent -= 100 - this.nPercentMax;
                            }
                        } else {
                            if (this.isOnTap(this.currentPos, this.line) && KCanvas.m_keyPressed != 0 && this.currentTime % (long)this.currentTempo > (long)(this.currentTempo / 10) && (KCanvas.m_keyPressed == 8 || KCanvas.m_keyPressed == 16 || KCanvas.m_keyPressed == 2 || KCanvas.m_keyPressed == 4) && this.disableKey(this.getCurrentTap(this.currentPos))) {
                                this.lastHitSucceed = this.checkKeyValue(KCanvas.m_keyPressed, this.getCurrentTap(this.currentPos));
                                this.displayDelayTime = 1000L + this.currentTime;
                                this.displayX = this.ballX;
                                this.displayY = this.ballY;
                                if (this.lastHitSucceed) {
                                    this.tapsSucceed = (byte)(this.tapsSucceed + 1);
                                } else if (bTutorialMode && Tutorial.instance.isTestingLeaderLine1()) {
                                    Tutorial.instance.setEventUnsuccessful(true);
                                    this.setState((byte)5);
                                }
                            }
                            KCanvas.m_keyPressed = 0;
                        }
                    } else {
                        n6 = (int)(100L * this.currentTime / this.holdEndTime);
                        if (n6 >= 15 && this.holdStartTime == -1L) {
                            this.holdStartTime = this.currentTime;
                        }
                        if (this.pullback < (n6 << 3) / 100) {
                            this.pullback = (n6 << 3) / 100;
                            if (this.pullback > 8) {
                                this.pullback = 8;
                            }
                            this.bPullingBack = true;
                        }
                        if (KCanvas.m_keyPressed != 0 && this.battleType != 2 && this.battleType != 3 && this.battleType != 6 && (KCanvas.m_keyPressed == 2 || KCanvas.m_keyPressed == 4 || KCanvas.m_keyPressed == 8 || KCanvas.m_keyPressed == 16)) {
                            s2 = this.line;
                            s = KCanvas.m_keyPressed;
                            Battle battle2 = this;
                            n8 = 1;
                            n = 0;
                            if (battle2.battleType == 1) {
                                if (battle2.wordStreak == 2) {
                                    if (1 == battle2.getWordValue((byte)s2, s, false)) {
                                        n8 = 0;
                                    }
                                } else if (battle2.wordStreak == 1) {
                                    if (1 == battle2.getWordValue((byte)s2, (short)2, false)) {
                                        n = 2;
                                    } else if (1 == battle2.getWordValue((byte)s2, (short)8, false)) {
                                        n = 8;
                                    } else if (1 == battle2.getWordValue((byte)s2, (short)4, false)) {
                                        n = 4;
                                    } else if (1 == battle2.getWordValue((byte)s2, (short)16, false)) {
                                        n = 16;
                                    }
                                    if (s == n) {
                                        n8 = 0;
                                    }
                                }
                            } else if (!battle2.holdButton) {
                                n2 = 0;
                                if (100L * (battle2.currentTime - battle2.holdStartTime) / (battle2.holdEndTime - battle2.holdStartTime) > (long)battle2.coop2ndWordPercent) {
                                    n2 = 2;
                                } else if (100L * (battle2.currentTime - battle2.holdStartTime) / (battle2.holdEndTime - battle2.holdStartTime) > (long)battle2.coop1stWordPercent) {
                                    n2 = 1;
                                }
                                n3 = 0;
                                n4 = 0;
                                while (battle2.keys[n3] != s) {
                                    if (battle2.getWordValue((byte)s2, battle2.keys[n3], true) == 1) {
                                        ++n4;
                                    }
                                    ++n3;
                                }
                                if (n4 < n2 && battle2.getWordValue((byte)s2, battle2.keys[n3], true) == 1) {
                                    n8 = 0;
                                }
                            }
                            if (n8 == 0) {
                                KCanvas.m_keyPressed = 0;
                            }
                        }
                        if (!(KCanvas.m_keyPressed != 2 && KCanvas.m_keyPressed != 4 && KCanvas.m_keyPressed != 8 && KCanvas.m_keyPressed != 16 || this.holdBeginTime != -1L || this.lineScoreDisplayed)) {
                            if (!this.holdButton) {
                                this.wordSelected = KCanvas.m_keyPressed;
                                this.m_lastKeyPressed = KCanvas.m_keyPressed;
                            }
                            this.holdButton = true;
                            this.keyBeingHold = KCanvas.m_keyPressed;
                            if (n6 >= 15) {
                                this.holdBeginTime = this.currentTime;
                                this.nPercentMax = 100 - (int)(100L * (this.holdBeginTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime));
                                if (this.nPercentMax > 100) {
                                    this.nPercentMax = 100;
                                }
                                this.nPercent = 0;
                            } else {
                                this.holdBeginTime = 0L;
                            }
                        } else if (this.holdBeginTime != -1L && (KCanvas.m_keyPressed == 0 || KCanvas.m_keyPressed != this.keyBeingHold) && this.holdFinishTime == -1L) {
                            this.holdFinishTime = this.currentTime;
                            this.keyBeingHold = 0;
                            if (this.leftTarget <= this.currentPos && this.rightTarget > this.currentPos) {
                                this.displayAnswer = true;
                                n6 = this.getWordValue(this.line, this.wordSelected, false);
                                if (2 <= n6) {
                                    this.lastHitSucceed = true;
                                    if (n6 == 3) {
                                        this.word = (byte)8;
                                    } else if (n6 == 2) {
                                        this.word = (byte)6;
                                    }
                                } else {
                                    this.lastHitSucceed = false;
                                    this.word = 0;
                                }
                                this.isOnTarget(this.currentPos, this.line);
                                this.holdButton = false;
                                this.displayDelayTime = 1000L + this.currentTime;
                                this.displayX = this.ballX;
                                this.displayY = this.ballY;
                            } else {
                                this.holdBeginTime = -1L;
                                this.holdFinishTime = -1L;
                                this.wordSelected = 0;
                                this.holdButton = false;
                                this.tmpBonus = this.bonus;
                                this.nPercent = 0;
                            }
                        } else if (this.holdButton && n6 >= 15) {
                            if (this.holdBeginTime == 0L) {
                                this.holdBeginTime = this.currentTime;
                                this.nPercentMax = 100 - (int)(100L * (this.holdBeginTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime));
                                if (this.nPercentMax > 100) {
                                    this.nPercentMax = 100;
                                }
                                this.nPercent = 0;
                            }
                            this.nPercent = (int)(100L * (this.currentTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime));
                            this.nPercent -= 100 - this.nPercentMax;
                        }
                    }
                } else if (this.mode == 2) {
                    if (this.isOnTap(this.currentPos, this.line) && KCanvas.m_keyPressed != 0 && this.currentTime % (long)this.currentTempo > (long)(this.currentTempo / 25) && (KCanvas.m_keyPressed == 8 || KCanvas.m_keyPressed == 16 || KCanvas.m_keyPressed == 2 || KCanvas.m_keyPressed == 4)) {
                        n6 = this.getCurrentTap(this.currentPos);
                        if (this.disableKey(n6)) {
                            this.lastHitSucceed = this.checkKeyValue(KCanvas.m_keyPressed, n6);
                            this.displayDelayTime = 1000L + this.currentTime;
                            this.displayX = this.ballX;
                            this.displayY = this.ballY;
                            if (this.lastHitSucceed) {
                                this.tapsSucceed = (byte)(this.tapsSucceed + 1);
                            }
                        }
                    } else {
                        KCanvas.m_keyPressed = 0;
                    }
                }
                this.loadUpdatedPoses();
                break;
            }
            case 5: {
                if (!Tutorial.instance.bHoldBattle && KCanvas.m_keyPressed == 64) {
                    if ((Tutorial.instance.getTutor() == 61 || Tutorial.instance.getTutor() == 5 || Tutorial.instance.getTutor() == 22 || Tutorial.instance.getTutor() == 42) && bFiveActivated) {
                        bFiveActivated = false;
                    } else if (Tutorial.instance.getTutor() == 61 || Tutorial.instance.getTutor() == 5 || Tutorial.instance.getTutor() == 22 || Tutorial.instance.getTutor() == 42) break;
                    this.line = Tutorial.instance.line;
                    this.para = Tutorial.instance.para;
                    this.refreshClearBits();
                    Utils.setIndicator((byte)0, (byte)1);
                    Utils.drawIndicatorBG(KGraphics.getGraphics());
                    Utils.drawIndicators$bfed7fe((KFont)this.m_FontIndicators.ro_ref);
                    if (Tutorial.instance.isTestingOffenseLine()) {
                        this.mode = 1;
                        this.unloadFont();
                        this.loadFont();
                        this.setState((byte)3);
                        if (Utils.clearKeyIsEnable()) {
                            return false;
                        }
                        tutorialFoldNotePad = false;
                    } else {
                        tutorialFoldNotePad = true;
                        if (Tutorial.instance.isTestingDefenseLine()) {
                            this.mode = (byte)2;
                        }
                        if (Tutorial.instance.bTutorialStarted) {
                            this.line = (byte)(this.line - 1);
                            this.unloadFont();
                            this.loadFont();
                            this.setState((byte)3);
                            if (Utils.clearKeyIsEnable()) {
                                return false;
                            }
                        } else {
                            this.unloadFont();
                            this.setState((byte)1);
                        }
                    }
                } else {
                    Tutorial.instance.loadNext((KFont)this.m_FontNotePad.ro_ref);
                    if (!bTutorialMode) {
                        KCanvas.m_keyPressed = 0;
                        bl = true;
                    } else if (Tutorial.instance.bRefresh && this.para != Tutorial.instance.para) {
                        this.para = Tutorial.instance.para;
                        Utils.loadingIni$252c3fc(16);
                        if (!Utils.loadingRefresh(33)) {
                            return false;
                        }
                        this.loadRoundLyrics(Tutorial.instance.para);
                        if (!Utils.loadingRefresh(66)) {
                            return false;
                        }
                        this.mode = this.para % 2 == 0 ? (byte)2 : (byte)1;
                        if (!Utils.loadingRefresh(100)) {
                            return false;
                        }
                        Utils.setIndicator((byte)4, (byte)1);
                        Utils.drawIndicatorBG(KGraphics.getGraphics());
                        Utils.drawIndicators$bfed7fe((KFont)this.m_FontIndicators.ro_ref);
                    } else if (Tutorial.instance.getTutor() == 99) {
                        Utils.setIndicator((byte)10, (byte)0);
                        Utils.drawIndicatorBG(KGraphics.getGraphics());
                        Utils.drawIndicators$bfed7fe((KFont)this.m_FontIndicators.ro_ref);
                    }
                }
                KCanvas.m_keyPressed = 0;
                break;
            }
            case 10: {
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    this.setState((byte)10);
                    Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                    break;
                }
                if (KCanvas.m_keyPressed != 64) break;
                KCanvas.m_keyPressed = 0;
                this.unloadFile();
                bl = true;
                break;
            }
            case 6: {
                if (KCanvas.m_keyPressed != 0 || KCanvas.m_actionCode != 0) {
                    KCanvas.m_keyPressed = 0;
                    KCanvas.m_actionCode = 0;
                }
                this.refreshClearBits();
                if (this.isInFlashCard) {
                    this.setState((byte)4);
                    break;
                }
                if (this.isInGoal) {
                    this.setState((byte)11);
                    break;
                }
                if (System.currentTimeMillis() - this.waitingTime > (long)(3 * this.currentTempo)) {
                    this.startTime = KUtils.s_previousTime;
                    this.setState((byte)2);
                    break;
                }
                this.display_waiting_time = String.valueOf(3L - (System.currentTimeMillis() - this.waitingTime) / (long)this.currentTempo);
                break;
            }
            case 8: {
                if (!this.bIntroDrawn) break;
                this.setState((byte)0);
                break;
            }
            case 9: {
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    this.setState((byte)9);
                    Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                    this.m_FontNotePad = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                }
                if (KCanvas.m_keyPressed != 64) break;
                KCanvas.m_keyPressed = 0;
                this.setState((byte)10);
                break;
            }
            case 3: {
                if (!this.bStateResume) break;
                this.unloadFont();
                this.setState((byte)6);
                break;
            }
            case 7: {
                if (!this.bStateTutorial) break;
                this.unloadFont();
                this.setState((byte)5);
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public final void frame() {
        var1_1 = KGraphics.getGraphics();
        if (Utils.loadingIsActive()) {
            Utils.loadingDraw(var1_1);
            return;
        }
        var2_2 = 1;
        switch (Battle.m_state) {
            case 8: {
                if (this.bIntroDrawn) break;
                if (!Battle.bTutorialMode) {
                    var1_1.setColor(0);
                    var1_1.fillRect(0, 0, KCanvas.m_width, KCanvas.m_height);
                    Utils.drawBackbuffer(var1_1);
                }
                this.bIntroDrawn = true;
                return;
            }
            case 0: {
                if (this.bIntroDrawn) break;
                if (Battle.bTutorialMode) {
                    this.mode = 1;
                    Tutorial.instance.startTutorial$bfed7fe(var1_1);
                    this.reloadBattle(var1_1);
                    Battle.DrawSmallBBOnScreen();
                    Utils.drawIndicatorBG(var1_1);
                    Utils.drawIndicators$bfed7fe(null);
                }
                this.bIntroDrawn = true;
                Game.loadInstrEnd = true;
                return;
            }
            case 1: {
                Utils.drawIndicatorBG(var1_1);
                Utils.drawIndicators$bfed7fe(null);
                return;
            }
            case 4: 
            case 11: {
                if (!this.bFlashCardDraw) break;
                var1_1.setClip(0, 0, KCanvas.m_width, KCanvas.m_height - 8);
                Utils.drawBackbuffer(var1_1);
                Battle.DrawSmallBBOnScreen();
                this.drawBubble(var1_1);
                this.setCrowdMeterColor((byte)1, this.bonus, this.score);
                this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                this.bRoundLoaded = true;
                Utils.drawIndicatorBG(var1_1);
                Utils.drawIndicators$bfed7fe(null);
                Tutorial.drawFlashBox(var1_1, 24, 22, KCanvas.m_width - 52 + 4, 137);
                this.tvpFlashCard.draw();
                if (Battle.m_state != 11) {
                    var3_6 = 26 + KCanvas.m_width - 52 + 4 - ((Image)Battle.m_nextImage.ro_ref).getWidth();
                    var2_2 = 165 - ((Image)Battle.m_nextImage.ro_ref).getHeight();
                    var1_1.drawImage((Image)Battle.m_tutoNextImg.ro_ref, var3_6, var2_2, 20);
                }
                this.bFlashCardScrolled = false;
                this.bFlashCardDraw = false;
                return;
            }
            case 3: {
                this.drawNotePadRegion(var1_1, -2147483648);
                if (Battle.bTutorialMode) {
                    var1_1.setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
                    Utils.drawIndicatorBG(var1_1);
                    Utils.drawIndicators$bfed7fe(null);
                }
                this.drawUpdatedPoses(var1_1);
                this.drawBubble(var1_1);
                this.setCrowdMeterColor((byte)1, this.bonus, this.score);
                this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                KGraphics.getGraphics().setClip(0, 0, KCanvas.m_width, KCanvas.m_height - 8);
                if (Battle.bTutorialMode) {
                    this.bStateResume = true;
                    return;
                }
                this.setState((byte)2);
                return;
            }
            case 2: 
            case 6: {
                var3_7 = this;
                if (Battle.m_ballImage == null) {
                    v0 = false;
                } else if (Battle.m_ballImageSplash == null) {
                    v0 = false;
                } else if (Battle.m_targetArrow == null) {
                    v0 = false;
                } else if (Battle.m_greyArrow == null) {
                    v0 = false;
                } else if (Battle.m_XRed == null) {
                    v0 = false;
                } else if (Battle.m_target == null) {
                    v0 = false;
                } else if (Battle.m_greenPaf == null) {
                    v0 = false;
                } else if (Battle.m_meterImage == null) {
                    v0 = false;
                } else if (Battle.m_scoreDigitsImage == null) {
                    v0 = false;
                } else if (Battle.m_thresholdImage == null) {
                    v0 = false;
                } else if (Battle.m_holdMeterImage == null) {
                    v0 = false;
                } else if (Battle.m_holdMeterBorderImage == null) {
                    v0 = false;
                } else if (Battle.m_ledProgressBar == null) {
                    v0 = false;
                } else if (Battle.m_scratchImage == null) {
                    v0 = false;
                } else if (Battle.m_nextImage == null) {
                    v0 = false;
                } else {
                    if (Battle.m_tutoNextImg == null) {
                        Battle.m_tutoNextImg = KResource.load((short)10240, 1);
                    }
                    if ((var3_7.battleType == 3 || var3_7.battleType == 2 || var3_7.battleType == 5 || var3_7.battleType == 6 || var3_7.battleType == 1 && var3_7.opponent != 0) && Battle.m_bubbleImage == null) {
                        Battle.m_bubbleImage = KResource.load((short)12291, 1);
                    }
                    v0 = true;
                }
                if (!v0) {
                    return;
                }
                Utils.rightSoftKeyDisabled = false;
                if (this.m_FontWhite != null) {
                    Utils.setIndicator((byte)6, (byte)2, (KFont)this.m_FontWhite.ro_ref);
                }
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    KGraphics.getGraphics().setClip(0, 0, KCanvas.m_width, KCanvas.m_height - 8);
                    Utils.drawBackbuffer(KGraphics.getGraphics());
                    return;
                }
                if (!this.bRoundLoaded) {
                    this.bRoundLoaded = true;
                    Battle.DrawSmallBBOnScreen();
                    this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                    Utils.drawIndicatorBG(var1_1);
                    Utils.drawIndicators$bfed7fe(null);
                }
                this.drawUpdatedPoses(var1_1);
                this.drawBubble(var1_1);
                if (!this.isRefreshDone((byte)0, -2147483648)) {
                    this.drawNotePadRegion(var1_1, -2147483648);
                    if (this.mode != 2 && !Battle.bTutorialMode || Battle.bTutorialMode && Battle.tutorialFoldNotePad) {
                        this.refreshDone((byte)1, 64);
                    }
                    this.refreshDone((byte)0, -2147483648);
                }
                if (this.displayAnswer && this.mode == 2 || this.mode == 1 && this.line != 0 && this.displayAnswer) {
                    var2_2 = 0;
                    this.bAnswerGiven = true;
                }
                if (Battle.m_state != 6) {
                    var3_8 = 10;
                    if (this.ballX + 10 > Utils.BACK_BUFFER_WIDTH) {
                        var3_8 = 10 - (this.ballX + 10 - Utils.BACK_BUFFER_WIDTH);
                    }
                    Utils.drawBackbufferRegion(var1_1, this.ballX, this.ballY, var3_8, 10, this.ballX, this.ballY);
                }
                if (this.lineSwitchPercent == 0 && this.displaySplashHit && this.displayDelayTime == this.currentTime + 1000L && !this.isRefreshDone((byte)0, 4096)) {
                    this.drawNotePadRegion(KGraphics.getGraphics(), 4096);
                    this.refreshDone((byte)0, 4096);
                    this.bRewriteLineAfterSplash = true;
                }
                this.writeLine$4e1616e9(var1_1, this.line, this.scrollPos, (boolean)var2_2);
                this.refreshDone((byte)1, 128);
                if (this.lineSwitchPercent > 0 && !this.bRefreshedTopBattle) {
                    this.bRefreshedTopBattle = true;
                    Utils.drawBackbufferRegion(var1_1, 0, 0, 26, 24, 0, 0);
                } else {
                    this.bRefreshedTopBattle = false;
                }
                if (Battle.m_state != 6) {
                    this.drawBall(var1_1, this.currentTime, this.line, this.currentTempo, this.currentPos);
                }
                if (this.lineSwitchPercent > 0) ** GOTO lbl211
                if (this.displayDelayTime < this.currentTime) ** GOTO lbl203
                this.displaySplashHit = true;
                if (!this.lastHitSucceed) ** GOTO lbl184
                if (!Battle.bTutorialMode) ** GOTO lbl176
                if (!Tutorial.instance.isTestingOffenseLine()) ** GOTO lbl174
                var3_9 = this.getWordValue(this.line, this.wordSelected, false);
                if (var3_9 == 2) {
                    var3_9 = 1;
                }
                if (1 != var3_9) ** GOTO lbl176
                Battle.drawAsset(var1_1, (byte)9, this.displayX, this.displayY, 0);
                ** GOTO lbl177
lbl174:
                // 1 sources

                Battle.drawAsset(var1_1, (byte)8, this.displayX, this.displayY, 0);
                ** GOTO lbl177
lbl176:
                // 2 sources

                Battle.drawAsset(var1_1, (byte)8, this.displayX, this.displayY, 0);
lbl177:
                // 3 sources

                this.refreshDone((byte)1, 4096);
                if (this.isLeaderLine() && this.tapsSucceed > 0 && this.tapsSucceed != this.tapsMem) {
                    this.tapsMem = this.tapsSucceed;
                    if (this.tapsSucceed > 0) {
                        this.setCrowdMeterColor((byte)2, this.bonus, this.score);
                        this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                    }
                }
                ** GOTO lbl193
lbl184:
                // 1 sources

                if (this.mode == 1 && this.holdFinishTime != -1L && this.line != 0) {
                    Battle.drawAsset(var1_1, (byte)9, this.displayX, this.displayY, 0);
                    this.refreshDone((byte)1, 4096);
                    if (this.pullback != 8) {
                        this.pullback = 8;
                        this.drawCrowdMeter(var1_1, this.score - this.pullback, this.bonus, this.threshold);
                    }
                } else {
                    Battle.drawAsset(var1_1, (byte)10, this.displayX, this.displayY, 0);
                    this.refreshDone((byte)1, 4096);
                }
lbl193:
                // 3 sources

                if (this.isLeaderLine() && Math.abs(this.holdEndTime - this.currentTime) < (long)this.currentTempo && this.currentColorSet != 1) {
                    this.setCrowdMeterColor((byte)1, this.bonus, this.score);
                    if (this.holdEndTime < this.currentTime) {
                        this.nPercent = this.nPercentMax;
                    }
                    this.bonus = this.tmpBonus + (this.tapsSucceed + 1) * this.nPercent * 25 / 100;
                    if (this.bonus > 100) {
                        this.bonus = 100;
                    }
                    this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                }
                this.lastDisplayX = this.displayX;
                ** GOTO lbl211
lbl203:
                // 1 sources

                this.displaySplashHit = false;
                if (!this.isRefreshDone((byte)0, 4096)) {
                    this.drawNotePadRegion(var1_1, 4096);
                    this.refreshDone((byte)0, 4096);
                    this.bRewriteLineAfterSplash = true;
                    this.writeLine$4e1616e9(var1_1, this.line, this.scrollPos, true);
                }
                if (this.bTargetDeleted && this.mode != 2) {
                    Battle.drawAsset(var1_1, (byte)12, this.displayX, this.displayY, 0);
                }
lbl211:
                // 5 sources

                if (this.lastHitSucceed && this.isLeaderLine() && this.tapsSucceed > 0 && this.tapsSucceed != this.tapsMem) {
                    this.tapsMem = this.tapsSucceed;
                    if (this.tapsSucceed > 0) {
                        this.setCrowdMeterColor((byte)2, this.bonus, this.score);
                        this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                    }
                }
                KGraphics.getGraphics().setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
                var3_10 = KCanvas.m_width - ((Image)Battle.m_nextImage.ro_ref).getWidth();
                var2_2 = 165 - ((Image)Battle.m_nextImage.ro_ref).getHeight();
                if (this.mode == 1) {
                    if (this.line == 0) {
                        if (-1 != this.getNextTap(this.currentPos) && !this.bNoTap) {
                            KGraphics.drawImage(Battle.m_nextImage, KCanvas.m_width - ((Image)Battle.m_nextImage.ro_ref).getWidth(), 165 - ((Image)Battle.m_nextImage.ro_ref).getHeight());
                        } else {
                            Utils.drawBackbufferRegion(var1_1, var3_10, var2_2, ((Image)Battle.m_nextImage.ro_ref).getWidth(), ((Image)Battle.m_nextImage.ro_ref).getWidth(), var3_10, var2_2);
                        }
                    }
                } else if (this.mode == 2) {
                    if (this.getNextTap(this.currentPos) < 4 && this.getNextTap(this.currentPos) != -1 && !this.changeLine) {
                        KGraphics.drawImage(Battle.m_nextImage, KCanvas.m_width - ((Image)Battle.m_nextImage.ro_ref).getWidth(), 165 - ((Image)Battle.m_nextImage.ro_ref).getHeight());
                    } else {
                        Utils.drawBackbufferRegion(var1_1, var3_10, var2_2, ((Image)Battle.m_nextImage.ro_ref).getWidth(), ((Image)Battle.m_nextImage.ro_ref).getWidth(), var3_10, var2_2);
                    }
                }
                this.refreshDone((byte)1, 64);
                if (this.isLeaderLine() && this.holdStartTime == -1L) {
                    this.eraseScrableWord(var1_1);
                }
                if (this.mode == 1 && this.line != 0 && Battle.m_state != 6) {
                    this.writeWordsBank(var1_1, this.line);
                }
                if (!this.isLeaderLine() || this.holdStartTime == -1L) ** GOTO lbl338
                var2_2 = this.getKeyValue(this.getBigKey());
                if (var2_2 == 0) {
                    var2_2 = 0;
                } else if (var2_2 == 1) {
                    var2_2 = 5;
                } else if (var2_2 == 2) {
                    var2_2 = 3;
                } else if (var2_2 == 3) {
                    var2_2 = 6;
                }
                if (this.keySlidePercent <= this.currentTime) {
                    this.keySlidePercent = 0L;
                }
                if (this.keySlidePercent == 0L && this.finishSlidingArrow) {
                    if (this.holdFinishTime == -1L) {
                        if (!this.isRefreshDone((byte)2, 32)) {
                            this.drawNotePadRegion(var1_1, 32768);
                            Battle.drawAsset(var1_1, (byte)5, (240 - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2, 120, var2_2);
                            this.refreshDone((byte)2, 32);
                        }
                        if (!this.isRefreshDone((byte)1, 16) || this.lastWrittenWord != 81) {
                            if (!this.isRefreshDone((byte)0, 16) || this.lastWrittenWord != 81) {
                                this.drawNotePadRegion(var1_1, 16);
                            }
                            this.displayInstructionKey(Utils.getWordsFrom(81, this.fileBufferString));
                            this.lastWrittenWord = 81;
                            this.refreshDone((byte)1, 16);
                        }
                    } else if (this.lastHitSucceed) {
                        var2_2 = (this.tapsSucceed + 1) * this.nPercentMax * 25 / 100 + 1;
                        if (var2_2 < 0) {
                            var2_2 = 0;
                        }
                        if (var2_2 > 25 * (this.tapsSucceed + 1)) {
                            var2_2 = 25 * (this.tapsSucceed + 1);
                        }
                        if (var2_2 + this.tmpBonus > 100) {
                            var2_3 = Utils.getWordsFrom(114, this.fileBufferString);
                            var3_10 = 114;
                        } else {
                            var2_3 = "+" + var2_2 + " " + Utils.getWordsFrom(107, this.fileBufferString);
                            var3_10 = 107;
                            Battle.drawBonusOnly$11c44857(var1_1, this.bonus);
                        }
                        var2_3.getChars(0, var2_3.length(), Utils.charBuffer, 0);
                        var4_12 = ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, var2_3.length());
                        if (this.lastWrittenWord != var3_10) {
                            if (!this.isRefreshDone((byte)0, 32)) {
                                this.drawNotePadRegion(var1_1, 32);
                            }
                            if (!this.isRefreshDone((byte)0, 16)) {
                                this.drawNotePadRegion(var1_1, 16);
                            }
                            Battle.displayInstructionKey(var2_3, (KCanvas.m_width - var4_12) / 2);
                            this.lastWrittenWord = var3_10;
                        }
                    } else {
                        Battle.drawBonusOnly$11c44857(var1_1, this.tmpBonus);
                        if (!this.isRefreshDone((byte)3, 32)) {
                            this.drawNotePadRegion(var1_1, 32);
                            this.refreshDone((byte)0, 32);
                            this.refreshDone((byte)4, 16384);
                        }
                        if (this.lastWrittenWord != 89) {
                            this.drawNotePadRegion(var1_1, 16);
                            this.displayInstructionKey(Utils.getWordsFrom(89, this.fileBufferString));
                            this.lastWrittenWord = 89;
                            this.refreshDone((byte)1, 16);
                        }
                        if (!this.isRefreshDone((byte)2, 32)) {
                            if (this.isRefreshDone((byte)3, 32)) {
                                this.drawNotePadRegion(var1_1, 32);
                            }
                            Battle.drawAsset(var1_1, (byte)6, (240 - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2, 120, var2_2);
                            Battle.drawAsset(var1_1, (byte)11, (240 - ((Image)Battle.m_XRed.ro_ref).getWidth()) / 2, 120, var2_2);
                            this.refreshDone((byte)2, 32);
                        }
                    }
                } else {
                    if (!this.isRefreshDone((byte)0, 64)) {
                        this.drawNotePadRegion(var1_1, 64);
                        this.refreshDone((byte)0, 64);
                    }
                    if (!this.isRefreshDone((byte)0, 16) || this.lastWrittenWord != 81) {
                        this.drawNotePadRegion(var1_1, 16);
                        this.refreshDone((byte)0, 16);
                    }
                    this.eraseScrableWord(var1_1);
                    if (this.keySlidePercent <= this.currentTime) {
                        this.nHoldSlidePercent = 0;
                        this.finishSlidingArrow = true;
                    } else {
                        this.nHoldSlidePercent = (int)((this.keySlidePercent - this.currentTime) * 100L) / 250;
                    }
                    if (!this.isRefreshDone((byte)0, 32768)) {
                        this.drawNotePadRegion(var1_1, 32768);
                    }
                    if (!this.isRefreshDone((byte)0, 16384)) {
                        this.drawNotePadRegion(var1_1, 16384);
                        this.refreshDone((byte)0, 16384);
                    }
                    Battle.drawAsset(var1_1, (byte)5, (240 - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2 + (240 - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2 * this.nHoldSlidePercent / 100, 120, var2_2);
                    this.refreshDone((byte)2, 32768);
                }
                if (this.holdFinishTime == -1L && this.holdButton) {
                    this.selectedX = (240 - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2 - Math.abs(((Image)Battle.m_holdMeterImage.ro_ref).getWidth() - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2 + 2;
                    this.selectedY = 120 - Math.abs(((Image)Battle.m_holdMeterImage.ro_ref).getHeight() - ((Image)Battle.m_targetArrow.ro_ref).getHeight()) / 2;
                }
                if (!this.holdButton) ** GOTO lbl359
                if (!this.isRefreshDone((byte)0, 32768)) {
                    this.drawNotePadRegion(var1_1, 32768);
                    this.refreshDone((byte)0, 32768);
                }
                this.drawProgressCircle(var1_1, this.selectedX - 2, this.selectedY, this.nPercent, this.nPercentMax);
                this.refreshDone((byte)3, 32);
                this.bonus = this.tmpBonus + (this.tapsSucceed + 1) * this.nPercent * 25 / 100;
                if (this.bonus > 100) {
                    this.bonus = 100;
                }
                if (this.bonus > 100) ** GOTO lbl359
                Battle.drawBonusOnly$11c44857(var1_1, this.bonus);
                ** GOTO lbl359
lbl338:
                // 1 sources

                if (this.mode == 1 && this.line != 0) {
                    this.finishSlidingArrow = false;
                    if (this.holdEndTime < this.currentTime) {
                        this.nPercent = this.nPercentMax;
                    }
                    if ((var2_2 = this.nPercent * 25 / 50) > 25) {
                        var2_2 = 25;
                    }
                    this.bonus = this.tmpBonus - var2_2;
                    if (this.bonus < 0) {
                        this.bonus = 0;
                    }
                    if (this.holdButton && this.holdStartTime != -1L) {
                        this.drawProgressCircle(var1_1, this.selectedX + 9, this.selectedY - 3, this.nPercent, this.nPercentMax);
                        if (this.bonus >= 0) {
                            Battle.drawBonusOnly$11c44857(var1_1, this.bonus);
                        }
                    } else if (this.holdFinishTime == this.currentTime && this.wordSelected == this.m_lastKeyPressed) {
                        this.drawProgressCircle(var1_1, this.selectedX, this.selectedY, this.nPercent, this.nPercentMax);
                    } else {
                        for (var2_2 = 0; var2_2 < 4; var2_2 = (int)((byte)(var2_2 + 1))) {
                            if (!this.isRefreshDone((byte)3, 256 << var2_2)) continue;
                            this.refreshDone((byte)4, 256 << var2_2);
                        }
                    }
                }
lbl359:
                // 8 sources

                if (this.bPullingBack) {
                    Utils.SaveClip();
                    Utils.SetClip$29abebcb((short)0, (short)KCanvas.m_width, (short)KCanvas.m_height);
                    this.drawCrowdMeter(var1_1, this.score - this.pullback, this.bonus, this.threshold);
                    this.bPullingBack = false;
                    Utils.RestoreClip();
                }
                if (Battle.m_state == 6) {
                    var2_4 = KCanvas.m_width / 2;
                    this.display_waiting_time.getChars(0, this.display_waiting_time.length(), Utils.charBuffer, 0);
                    if (System.currentTimeMillis() - this.waiting_time_toggle > (long)this.currentTempo) {
                        var1_1.setColor(0xFF0000);
                        var1_1.fillRect(var2_4 - 2, 123, KGraphics.textWidth(Utils.charBuffer, 0, 1) + 4, KGraphics.textHeight());
                        this.waiting_time_toggle = System.currentTimeMillis();
                    } else {
                        Utils.drawBackbufferRegion(var1_1, var2_4 - 2, 123, KGraphics.textWidth(Utils.charBuffer, 0, 1) + 4, KGraphics.textHeight(), var2_4 - 2, 123);
                    }
                    KGraphics.drawText(Utils.charBuffer, 0, this.display_waiting_time.length(), var2_4, 123);
                    var6_13 = this.currentPos;
                    var5_14 = this.currentTempo;
                    var4_12 = this.line;
                    var7_15 = this.currentTime;
                    var2_5 = var1_1;
                    var3_11 = this;
                    var9_16 = var3_11.getBallJump$799aa41f(var3_11.charLyrics[var4_12], var5_14, var7_15, 0, 0, var6_13, 9, false);
                    var4_12 = (int)(System.currentTimeMillis() - var3_11.waiting_time_toggle);
                    var4_12 = var4_12 >= var5_14 / 2 ? 200 - var4_12 * 200 / var5_14 : var4_12 * 200 / var5_14;
                    var5_14 = 9 - var4_12 * 10 / 100;
                    var4_12 = (int)(var9_16 & -65536L) >> 16;
                    var4_12 += 26;
                    var4_12 -= 5;
                    var6_13 = 10;
                    if (var3_11.ballX + 10 > Utils.BACK_BUFFER_WIDTH) {
                        var6_13 = 10 - (var3_11.ballX + 10 - Utils.BACK_BUFFER_WIDTH);
                    }
                    Utils.drawBackbufferRegion(var2_5, var3_11.ballX, var3_11.ballY, var6_13, 10, var3_11.ballX, var3_11.ballY);
                    Battle.drawAsset(var2_5, (byte)0, var4_12, var5_14, 0);
                    var3_11.ballX = var4_12;
                    var3_11.ballY = var5_14;
                }
                if (!this.isRefreshDone((byte)1, 0x100000)) {
                    Utils.drawIndicatorBG(var1_1);
                    Utils.drawIndicators$bfed7fe(null);
                    this.refreshDone((byte)1, 0x100000);
                }
                this.updateLineSwitchPercent(this.currentTime, this.line, this.currentTempo, this.currentPos);
                this.nLastLine = this.line;
                return;
            }
            case 5: {
                Game.loadInstrEnd = true;
                Tutorial.instance.flashArrow(var1_1);
                if (Tutorial.instance.bRefresh && Tutorial.instance.bDrawNext) {
                    Tutorial.instance.bRefresh = false;
                    this.currentTime = 0L;
                    this.displayDelayTime = -1L;
                    this.tapsSucceed = 0;
                    this.startTime = KUtils.s_previousTime;
                    this.scrollPos = 1;
                    this.holdEndTime = -1L;
                    this.holdStartTime = -1L;
                    this.holdBeginTime = -1L;
                    this.holdFinishTime = -1L;
                    this.holdButton = false;
                    this.pullback = 0;
                    this.bPullingBack = false;
                    this.word = 0;
                    this.lastHitSucceed = false;
                    this.displayAnswer = false;
                    if (!Tutorial.instance.bFromInterrupt) {
                        this.refreshBattle(var1_1);
                        Battle.DrawSmallBBOnScreen();
                        Utils.drawIndicatorBG(var1_1);
                        Utils.drawIndicators$bfed7fe((KFont)this.m_FontIndicators.ro_ref);
                    }
                }
                if (Tutorial.instance.bFromInterrupt) {
                    Tutorial.instance.loadNext((KFont)this.m_FontNotePad.ro_ref);
                    Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                    Tutorial.instance.bFromInterrupt = false;
                    this.wordStreak = 0;
                    this.bAnswerGiven = true;
                    this.reloadBattle(var1_1);
                    Tutorial.instance.bReload = false;
                    this.refreshBattle(var1_1);
                    Battle.DrawSmallBBOnScreen();
                    Utils.drawIndicatorBG(var1_1);
                    Utils.drawIndicators$bfed7fe(null);
                }
                Tutorial.instance.drawNext(var1_1, (KFont)this.m_FontNotePad.ro_ref, (KFont)this.m_FontIndicators.ro_ref, this.ballX, this.ballY);
                if (Tutorial.instance.bReload) {
                    Tutorial.instance.bReload = false;
                    this.reloadBattle(var1_1);
                }
                Utils.drawIndicatorBG(var1_1);
                ** GOTO lbl468
            }
            case 7: {
                if (Tutorial.instance.isEventSuccessful()) {
                    this.drawCrowdMeter(var1_1, this.score, this.bonus, this.threshold);
                }
                this.bStateTutorial = true;
                return;
            }
            case 9: {
                Utils.rightSoftKeyDisabled = false;
                Utils.drawBackbuffer(var1_1);
                Utils.drawIndicatorBG(var1_1);
                if (this.m_FontNotePad == null) break;
                Utils.drawIndicators$bfed7fe((KFont)this.m_FontNotePad.ro_ref);
                return;
            }
            case 10: {
                Utils.rightSoftKeyDisabled = false;
                if (Utils.refresh == Utils.REFRESH_NEEDED_FULL) {
                    return;
                }
                if (!this.bStatsDisplayed) {
                    this.bStatsDisplayed = true;
                    this.drawBattleStats();
                    Utils.refresh = Utils.REFRESH_NEEDED_PARTIAL;
                }
                Utils.drawIndicatorBG(var1_1);
                if (this.m_FontIndicators == null) {
                    this.m_FontIndicators = (KRes)HeapManager.instance.get("fontCutScene.fpak", 0xFFFFFF, false);
                }
lbl468:
                // 4 sources

                Utils.drawIndicators$bfed7fe((KFont)this.m_FontIndicators.ro_ref);
            }
        }
    }

    private final void drawVersusString(Graphics graphics, String string, byte by, int n, int n2) {
        char[] cArray = string.toCharArray();
        int n3 = KGraphics.textWidth(cArray, 0, cArray.length);
        int n4 = KGraphics.textHeight();
        if (string.indexOf("\n") != -1) {
            n4 = (n4 << 1) + 1;
        }
        switch (by) {
            case 100: {
                int n5 = KCanvas.m_width / 7;
                int n6 = this.vs_backgroundY - n4 >> 1;
                break;
            }
            case 101: {
                int n5 = KCanvas.m_width - n3 >> 1;
                int n6 = this.vs_backgroundY - n4 >> 1;
                break;
            }
            case 102: {
                int n5 = KCanvas.m_width - KCanvas.m_width / 7 - n3;
                int n6 = this.vs_backgroundY - n4 >> 1;
                break;
            }
            case 103: {
                int n5 = KCanvas.m_width / 7;
                int n6 = this.vs_backgroundY + this.vs_backgroundHeight + (KCanvas.m_height - (this.vs_backgroundY + this.vs_backgroundHeight + 8) - n4 >> 1);
                break;
            }
            case 104: {
                int n5 = KCanvas.m_width - n3 >> 1;
                int n6 = this.vs_backgroundY + this.vs_backgroundHeight + (KCanvas.m_height - (this.vs_backgroundY + this.vs_backgroundHeight + 8) - n4 >> 1);
                break;
            }
            case 105: {
                int n5 = KCanvas.m_width - KCanvas.m_width / 7 - n3;
                int n6 = this.vs_backgroundY + this.vs_backgroundHeight + (KCanvas.m_height - (this.vs_backgroundY + this.vs_backgroundHeight + 8) - n4 >> 1);
                break;
            }
            case 106: {
                int n5 = -(n3 >> 1);
                int n6 = this.vs_backgroundY - n4 >> 1;
                break;
            }
            case 107: {
                int n5 = -(n3 >> 1);
                int n6 = this.vs_backgroundY + this.vs_backgroundHeight + (KCanvas.m_height - (this.vs_backgroundY + this.vs_backgroundHeight + 8) - n4 >> 1);
                break;
            }
            case 109: {
                int n5 = -n3;
                int n6 = 0;
                break;
            }
            default: {
                int n5 = 0;
                int n6 = 0;
            }
        }
        Battle.drawVersusString(graphics, cArray, n5 += n, n6 += n2);
    }

    private static void drawVersusString(Graphics graphics, String string, int n, int n2) {
        Battle.drawVersusString(graphics, string.toCharArray(), n, n2);
    }

    private static void drawVersusString(Graphics graphics, char[] cArray, int n, int n2) {
        graphics = KGraphics.setGraphics(graphics);
        KGraphics.drawText(cArray, 0, cArray.length, n, n2);
        KGraphics.setGraphics(graphics);
    }

    private void eraseScrableWord(Graphics graphics) {
        for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
            if (this.isRefreshDone((byte)0, 1 << n)) continue;
            this.drawNotePadRegion(graphics, 1 << n);
            this.refreshDone((byte)0, 1 << n);
            this.refreshDone((byte)0, 16384);
            this.refreshDone((byte)0, 16);
            this.lastWrittenWord = 0;
        }
    }

    private void reloadBattle(Graphics graphics) {
        this.currentTime = 0L;
        this.displayDelayTime = -1L;
        this.tapsSucceed = 0;
        this.startTime = KUtils.s_previousTime;
        this.scrollPos = 1;
        this.holdEndTime = -1L;
        this.holdStartTime = -1L;
        this.holdBeginTime = -1L;
        this.holdFinishTime = -1L;
        this.holdButton = false;
        this.pullback = 0;
        this.bPullingBack = false;
        this.word = 0;
        this.lastHitSucceed = false;
        this.displayAnswer = false;
        if (Tutorial.instance.isTestingOffenseLine()) {
            this.drawNotePadRegion(graphics, 8);
            this.drawNotePadRegion(graphics, 4);
            this.drawNotePadRegion(graphics, 2);
            this.drawNotePadRegion(graphics, 1);
            return;
        }
        if (Tutorial.instance.getTutor() == 0) {
            this.refreshBattle(graphics);
        }
    }

    private void refreshBattle(Graphics graphics) {
        Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
        graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height - 8);
        this.line = Tutorial.instance.line;
        this.para = Tutorial.instance.para;
        this.mode = this.para % 2 == 0 ? (byte)2 : (byte)1;
        Utils.drawBackbuffer(KGraphics.getGraphics());
        this.refreshClearBits();
        if (Tutorial.instance.bGenerateKeys) {
            if (this.mode == 2 || this.line == 0) {
                this.m_keysSequence = Battle.generateKeysSequence(0, 4, 4);
                this.getTapsPositions(this.line);
            }
            Tutorial.instance.bGenerateKeys = false;
        }
        this.writeLine$4e1616e9(graphics, this.line, 1, false);
        if (this.mode == 1 && this.line != 0) {
            this.writeWordsBank(graphics, this.line);
        } else if (Tutorial.instance.isTestingLeaderLine2()) {
            this.displayInstructionKey(Utils.getWordsFrom(81, this.fileBufferString));
            Battle.drawAsset(graphics, (byte)5, (240 - ((Image)Battle.m_targetArrow.ro_ref).getWidth()) / 2, 120, 6);
        }
        this.drawBall(graphics, this.currentTime, this.line, this.currentTempo, 0);
        this.setCrowdMeterColor((byte)1, this.bonus, this.score);
        this.drawCrowdMeter(graphics, this.score, this.bonus, this.threshold);
        graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
    }

    public final void reloadBackground() {
        Object object;
        Graphics graphics = Utils.getBackBufferGraphics();
        if (((Battle)object).location != 0) {
            short s = Battle.getLocationBackground(((Battle)object).location);
            object = (KRes)HeapManager.instance.get(s, (byte)1, 0);
            Image image = (Image)((KRes)object).ro_ref;
            int n = KCanvas.m_width - image.getWidth() >> 1;
            int n2 = KCanvas.m_height - image.getHeight();
            graphics.drawImage((Image)((KRes)object).ro_ref, n, n2, 0);
        }
        object = (Image)((KRes)HeapManager.instance.get((int)12307, (byte)1, (int)0)).ro_ref;
        graphics.drawImage((Image)object, 0, 0, 20);
        graphics.drawRegion((Image)object, 0, 22, KCanvas.m_width, object.getHeight() - 22, 0, 0, 50, 20);
        graphics.drawRegion((Image)object, 0, 22, KCanvas.m_width, object.getHeight() - 22, 0, 0, 78, 20);
        graphics.drawRegion((Image)object, 0, 22, KCanvas.m_width, object.getHeight() - 22, 0, 0, 106, 20);
    }

    private void loadUpdatedPoses() {
        if (bTutorialMode) {
            return;
        }
        if (m_state == 3 && this.line == 0) {
            switch (this.battleType) {
                case 2: 
                case 3: {
                    if (this.currentTime > this.loopLapseTime - (long)this.currentTempo && !this.bSlider2Loaded && m_state == 2) {
                        if (this.mode == 2) {
                            this.characterCounter = 1;
                            this.battlePose[this.characterCounter] = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, 4);
                        } else {
                            this.characterCounter = 0;
                            this.battlePose[this.characterCounter] = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.opponent), (byte)0, 4);
                        }
                        this.bSlider2Loaded = true;
                        return;
                    }
                    if (this.currentTime <= this.loopLapseTime - (long)(2 * this.currentTempo) || this.bSlider1Loaded || m_state != 2) break;
                    if (this.mode == 1) {
                        this.characterCounter = 1;
                        this.battlePose[this.characterCounter] = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, 4);
                    } else {
                        this.characterCounter = 0;
                        this.battlePose[this.characterCounter] = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.opponent), (byte)0, 4);
                    }
                    this.bSlider1Loaded = true;
                    return;
                }
                case 4: {
                    if (m_state != 3 || this.line != 0) break;
                    this.battlePose[0] = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, this.getAnimEmo((short)1));
                    KUtils.updateElapsedMS();
                    this.battlePose[1] = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, this.getAnimEmo((short)0));
                    return;
                }
                case 7: {
                    if (m_state != 3 || this.line != 0) break;
                    this.battlePose[this.para - 1] = (AnimInstance)HeapManager.instance.get(this.characters[0][this.para - 1], (byte)0, this.getAnimEmo(this.characters[1][this.para - 1]));
                    return;
                }
                case 5: 
                case 6: {
                    if (this.currentTime > this.loopLapseTime - (long)this.currentTempo && !this.bSlider2Loaded && m_state == 2) {
                        this.characterCounter = this.mode == 2 ? (byte)3 : (byte)1;
                        this.battlePose[this.characterCounter - 1] = (AnimInstance)HeapManager.instance.get(this.characters[0][this.characterCounter - 1], (byte)0, 4);
                        if (this.characterCounter < this.characters[0].length) {
                            KUtils.updateElapsedMS();
                            this.battlePose[this.characterCounter] = (AnimInstance)HeapManager.instance.get(this.characters[0][this.characterCounter], (byte)0, 4);
                        }
                        this.bSlider2Loaded = true;
                        return;
                    }
                    if (this.currentTime <= this.loopLapseTime - (long)(2 * this.currentTempo) || this.bSlider1Loaded || m_state != 2) break;
                    this.characterCounter = this.mode == 1 ? (byte)3 : (byte)1;
                    this.battlePose[this.characterCounter - 1] = (AnimInstance)HeapManager.instance.get(this.characters[0][this.characterCounter - 1], (byte)0, 4);
                    if (this.characterCounter < this.characters[0].length) {
                        KUtils.updateElapsedMS();
                        this.battlePose[this.characterCounter] = (AnimInstance)HeapManager.instance.get(this.characters[0][this.characterCounter], (byte)0, 4);
                    }
                    this.bSlider1Loaded = true;
                }
            }
        }
    }

    private void drawUpdatedPoses(Graphics graphics) {
        if (bTutorialMode) {
            return;
        }
        Object var2_2 = null;
        if (m_state == 3 && this.para == 0) {
            switch (this.battleType) {
                case 2: 
                case 3: {
                    if (this.currentTime < this.loopLapseTime - (long)(2 * this.currentTempo)) break;
                    int n = 0;
                    if (this.currentTime >= this.loopLapseTime - (long)this.currentTempo) {
                        n = Math.abs((int)(100L * (this.loopLapseTime - (long)this.currentTempo - this.currentTime) / (long)this.currentTempo));
                    } else if (this.currentTime >= this.loopLapseTime - (long)(2 * this.currentTempo)) {
                        n = 200 - Math.abs((int)(100L * (this.loopLapseTime - this.currentTime) / (long)this.currentTempo));
                    }
                    if (n <= 0) {
                        return;
                    }
                    if (n > 100) {
                        n = 100;
                    }
                    this.slideBattlePose(graphics, n, this.characterCounter);
                    Battle.DrawSmallBBOnScreen();
                    if (this.mode == 1) {
                        this.drawCrowdMeter(graphics, this.score - 8, this.bonus, this.threshold);
                        break;
                    }
                    this.drawCrowdMeter(graphics, this.score, this.bonus, this.threshold);
                    break;
                }
                case 4: {
                    if (m_state != 3 || this.line != 0) break;
                    graphics.setClip(0, 165, KCanvas.m_width, KCanvas.m_height - 165 - 8);
                    Utils.drawBackbuffer(graphics);
                    graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height - 8);
                    if (this.para % 2 == 0) {
                        if (this.para <= this.getMaxPara()) {
                            boolean bl = false;
                            Object var2_5 = null;
                            this.slideBattlePose(graphics, 0, 0);
                            this.slideBattlePose(graphics, 0, 1);
                        }
                        Battle.DrawSmallBBOnScreen();
                        break;
                    }
                    Utils.drawBackbuffer(KGraphics.getGraphics());
                    break;
                }
                case 7: {
                    if (m_state != 3 || this.line != 0) break;
                    graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
                    this.slideBattlePose(graphics, 0, this.para - 1);
                    Battle.DrawSmallBBOnScreen();
                    break;
                }
                case 5: 
                case 6: {
                    if (this.currentTime < this.loopLapseTime - (long)(2 * this.currentTempo)) break;
                    int n = 100;
                    if (this.currentTime > this.loopLapseTime - (long)this.currentTempo) {
                        n = Math.abs((int)(100L * (this.loopLapseTime - (long)this.currentTempo - this.currentTime) / (long)this.currentTempo));
                    } else if (this.currentTime > this.loopLapseTime - (long)(2 * this.currentTempo)) {
                        n = 200 - Math.abs((int)(100L * (this.loopLapseTime - this.currentTime) / (long)this.currentTempo));
                    }
                    if (n < 1) {
                        n = 1;
                    } else if (n > 100) {
                        n = 100;
                    }
                    this.slideBattlePose(graphics, n, this.characterCounter);
                    this.slideBattlePose(graphics, n, this.characterCounter - 1);
                    Battle.DrawSmallBBOnScreen();
                    if (this.mode == 1) {
                        this.drawCrowdMeter(graphics, this.score - 8, this.bonus, this.threshold);
                        break;
                    }
                    this.drawCrowdMeter(graphics, this.score, this.bonus, this.threshold);
                }
            }
            Utils.drawIndicatorBG(graphics);
            Utils.drawIndicators$bfed7fe(null);
        }
    }

    private void drawBubble(Graphics graphics) {
        if ((this.currentTime >= this.loopLapseTime - (long)(2 * this.currentTempo) && this.line == 3 || this.currentTime == 0L && this.line == 0 || this.bResumeDrawBubble) && (this.battleType == 3 || this.battleType == 2 || this.battleType == 5 || this.battleType == 6 || this.battleType == 1 && this.opponent != 0)) {
            Utils.drawBackbufferRegion(graphics, (KCanvas.m_width - ((Image)Battle.m_bubbleImage.ro_ref).getWidth()) / 2, 165 + ((Image)Battle.m_bubbleImage.ro_ref).getHeight(), ((Image)Battle.m_bubbleImage.ro_ref).getWidth(), ((Image)Battle.m_bubbleImage.ro_ref).getHeight(), (KCanvas.m_width - ((Image)Battle.m_bubbleImage.ro_ref).getWidth()) / 2, 165 + ((Image)Battle.m_bubbleImage.ro_ref).getHeight());
            if (this.mode == 2) {
                KGraphics.drawRegion(m_bubbleImage, 0, 0, ((Image)Battle.m_bubbleImage.ro_ref).getWidth(), ((Image)Battle.m_bubbleImage.ro_ref).getHeight(), 2, (KCanvas.m_width - ((Image)Battle.m_bubbleImage.ro_ref).getWidth()) / 2, 165 + ((Image)Battle.m_bubbleImage.ro_ref).getHeight());
            } else {
                KGraphics.drawImage(m_bubbleImage, (KCanvas.m_width - ((Image)Battle.m_bubbleImage.ro_ref).getWidth()) / 2, 165 + ((Image)Battle.m_bubbleImage.ro_ref).getHeight());
            }
            this.bResumeDrawBubble = false;
        }
    }

    private void flushBattlePoses() {
        for (int i = 0; i < this.battlePose.length; ++i) {
            this.battlePose[i] = null;
        }
    }

    private static void DrawSmallBBOnScreen() {
        Utils.drawBackbufferRegion(KGraphics.getGraphics(), 0, 165, KCanvas.m_width, KCanvas.m_height - 165, 0, 165);
    }

    private boolean slideBattlePose(Graphics graphics, int n, int n2) {
        if (this.battlePose.length <= n2 || this.battlePose[n2] == null) {
            return false;
        }
        graphics = Utils.getBackBufferGraphics();
        n = KCanvas.m_height - 165;
        short s = this.characters[1][n2];
        int n3 = 0;
        if (this.battleType == 1) {
            n3 = 1;
        } else if (this.battleType == 4) {
            n3 = 2;
        } else if (this.battleType == 5) {
            n3 = 3;
        } else if (this.battleType == 6) {
            n3 = 4;
        } else if (this.battleType == 7) {
            n3 = 5;
        }
        int n4 = 0;
        boolean bl = false;
        Object var7_8 = null;
        switch (s) {
            case 0: {
                if (n3 == 3) {
                    n4 = this.nPos38;
                    break;
                }
                if (n3 == 2) {
                    n4 = this.nPos58;
                    break;
                }
                if (n3 == 5) {
                    n4 = this.nPos12;
                    break;
                }
                return true;
            }
            case 1: {
                if (n3 == 0 || n3 == 4) {
                    n4 = this.nPos14;
                    break;
                }
                if (n3 == 5) {
                    n4 = this.nPos116;
                    break;
                }
                if (n3 == 3) {
                    n4 = this.nPos18;
                    break;
                }
                if (n3 == 2) {
                    n4 = this.nPos38;
                    break;
                }
                if (n3 == 1) {
                    if (this.opponent != 0) {
                        n4 = this.nPos14;
                        break;
                    }
                    n4 = this.nPos12;
                    break;
                }
                return true;
            }
            case 2: {
                if (n3 == 5) {
                    n4 = this.nPos46;
                    break;
                }
                if (n3 >= 3) {
                    n4 = this.nPos58;
                    break;
                }
                return true;
            }
            case 3: {
                if (n3 == 0) {
                    n4 = this.nPos34;
                    break;
                }
                if (n3 == 5) {
                    n4 = this.nPos26;
                    break;
                }
                if (n3 == 1 || n3 >= 3) {
                    n4 = this.nPos78;
                    break;
                }
                return true;
            }
            case 28686: {
                n4 = this.nPos56;
            }
        }
        short n5 = n;
        n5 -= 8;
        if ((n5 -= this.battlePose[n2].getOffsetBottom()) - Math.abs(this.battlePose[n2].getOffsetTop()) < 0) {
            n5 += Math.abs(this.battlePose[n2].getOffsetTop()) - n5;
        }
        n = 0;
        if (s > 1 && this.battleType != 7) {
            n = 1;
        }
        graphics = KGraphics.setGraphics(graphics);
        if (KCanvas.m_height < 160 && this.characters[0][n2] == 28683) {
            n5 += 2;
        }
        this.battlePose[n2].draw(n4, n5 += 165, n != 0, false);
        this.battlePose[n2].release();
        KGraphics.setGraphics(graphics);
        return true;
    }

    private byte getAnimEmo(short s) {
        if (s == 3 && this.battleType == 1) {
            return 0;
        }
        return 5;
    }

    private static short getLocationBackground(byte by) {
        short s = 0;
        switch (by) {
            case 1: {
                s = 21504;
                break;
            }
            case 2: {
                s = 15360;
                break;
            }
            case 3: {
                s = 16384;
                break;
            }
            case 4: {
                s = 17408;
                break;
            }
            case 5: {
                s = 18432;
                break;
            }
            case 6: {
                s = 22528;
                break;
            }
            case 7: {
                s = 19456;
                break;
            }
            case 8: {
                s = 20480;
            }
        }
        return s;
    }

    private static int getLocationBackgroundFilter(byte by) {
        int n = 0;
        switch (by) {
            case 1: {
                n = 1409373184;
                break;
            }
            case 2: {
                n = 1006713856;
                break;
            }
            case 3: {
                n = 0x40014000;
                break;
            }
            case 4: {
                n = 0x44014400;
                break;
            }
            case 5: {
                n = 1208043520;
                break;
            }
            case 6: {
                n = 1476483072;
                break;
            }
            case 7: {
                n = 1275153408;
                break;
            }
            case 8: {
                n = 1879461888;
            }
        }
        return n;
    }

    private String getRappersName(byte by) {
        String string = "";
        switch (by) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = Utils.getWordsFrom(56, this.fileBufferString);
                break;
            }
            case 2: {
                string = Utils.getWordsFrom(61, this.fileBufferString);
                break;
            }
            case 3: {
                string = Utils.getWordsFrom(24, this.fileBufferString);
                break;
            }
            case 4: {
                string = Utils.getWordsFrom(30, this.fileBufferString);
                break;
            }
            case 5: {
                string = Utils.getWordsFrom(34, this.fileBufferString);
                break;
            }
            case 6: {
                string = Utils.getWordsFrom(38, this.fileBufferString);
                break;
            }
            case 7: {
                string = Utils.getWordsFrom(46, this.fileBufferString);
                break;
            }
            case 8: {
                string = Utils.getWordsFrom(52, this.fileBufferString);
            }
        }
        return string;
    }

    private int getMaxPara() {
        int n = 4;
        switch (this.battleType) {
            case 2: 
            case 3: 
            case 5: {
                if (this.battleTakeID == 52) break;
                n += 2;
                break;
            }
            case 7: {
                ++n;
                break;
            }
            case 1: 
            case 4: {
                --n;
            }
        }
        return n;
    }

    private void drawBattleStats() {
        String string;
        String string2;
        String string3;
        int n;
        int n2 = 1;
        if (this.score >= this.threshold) {
            n = 2;
            Utils.getWordsFrom(303, this.fileBufferString);
            string3 = null;
        } else {
            n = 1;
            Utils.getWordsFrom(310, this.fileBufferString);
            string3 = null;
        }
        switch (this.getRank()) {
            case 1: {
                string2 = "A+";
                string = Utils.getWordsFrom(205, this.fileBufferString);
                break;
            }
            case 2: {
                string2 = "A";
                string = Utils.getWordsFrom(216, this.fileBufferString);
                break;
            }
            case 3: {
                string2 = "B";
                string = Utils.getWordsFrom(227, this.fileBufferString);
                break;
            }
            case 4: {
                string2 = "C";
                string = Utils.getWordsFrom(237, this.fileBufferString);
                break;
            }
            default: {
                string2 = "F";
                string = Utils.getWordsFrom(244, this.fileBufferString);
            }
        }
        string3 = Utils.getWordsFrom(298, this.fileBufferString) + string2;
        Utils.drawBackbuffer(KGraphics.getGraphics());
        int n3 = this.battleTakeID == 2 ? 1 : 2;
        String[][] stringArrayArray = (String[][])HeapManager.instance.get(Battle.getAnimConstant((byte)n3), (byte)0, n);
        n3 = KCanvas.m_width * 75 / 100;
        if (n3 - Math.abs(stringArrayArray.getLeft()) > KCanvas.m_width) {
            n3 = KCanvas.m_width - Math.abs(stringArrayArray.getLeft());
        }
        if (n3 - Math.abs(stringArrayArray.getRight()) < KCanvas.m_width * 55 / 100) {
            n3 = KCanvas.m_width * 55 / 100 + Math.abs(stringArrayArray.getRight());
        }
        stringArrayArray.draw(n3, KCanvas.m_height - stringArrayArray.getBottom(), true, false);
        if (this.m_FontNotePad == null) {
            this.m_FontNotePad = (KRes)HeapManager.instance.get("fontBattle.fpak", 0, false);
        }
        Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
        ((KFont)this.m_FontNotePad.ro_ref).m_bold = true;
        string3.getChars(0, string3.length(), Utils.charBuffer, 0);
        n3 = KCanvas.m_width / 2 - ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, string3.length()) / 2;
        KGraphics.drawText(Utils.charBuffer, 0, string3.length(), n3, 112);
        Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
        ((KFont)this.m_FontNotePad.ro_ref).m_bold = false;
        string.getChars(0, string.length(), Utils.charBuffer, 0);
        n3 = KCanvas.m_width / 2 - ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, string.length()) / 2;
        KGraphics.drawText(Utils.charBuffer, 0, string.length(), n3, 125);
        ++n2;
        String string4 = "/" + this.getSubtotal(false);
        stringArrayArray = new String[][]{{Utils.getWordsFrom(254, this.fileBufferString), Utils.getWordsFrom(258, this.fileBufferString), Utils.getWordsFrom(263, this.fileBufferString), Utils.getWordsFrom(268, this.fileBufferString), Utils.getWordsFrom(273, this.fileBufferString), Utils.getWordsFrom(277, this.fileBufferString), Utils.getWordsFrom(263, this.fileBufferString), Utils.getWordsFrom(282, this.fileBufferString), Utils.getWordsFrom(289, this.fileBufferString)}, {null, this.cpt_wordBest + string4, this.cpt_wordGood + string4, this.cpt_wordWrong + string4, null, this.cpt_accPerfect + string4, this.cpt_accGood + string4, this.cpt_accOk + string4, this.cpt_accMissed + string4}, {Utils.getWordsFrom(294, this.fileBufferString), Utils.getWordsFrom(289, this.fileBufferString) + "  " + this.cpt_blockMissed + "/" + this.getSubtotal(true)}};
        int n4 = this.m_notePad_stats_y + 39 - 3;
        if (this.battleType != 1 && this.battleType != 7 && this.battleType != 4) {
            int n5 = KCanvas.m_width * 55 / 100;
            ((KFont)this.m_FontNotePad.ro_ref).m_bold = true;
            stringArrayArray[2][0].getChars(0, stringArrayArray[2][0].length(), Utils.charBuffer, 0);
            KGraphics.drawText(Utils.charBuffer, 0, stringArrayArray[2][0].length(), n5, n4 + 26 - 3);
            ((KFont)this.m_FontNotePad.ro_ref).m_bold = false;
            ++n2;
            stringArrayArray[2][1].getChars(0, stringArrayArray[2][1].length(), Utils.charBuffer, 0);
            KGraphics.drawText(Utils.charBuffer, 0, stringArrayArray[2][1].length(), n5, n4 + 39 - 3);
            n2 -= 2;
        } else {
            --n2;
        }
        int n6 = KCanvas.m_width / 10;
        for (int i = 0; i < stringArrayArray[0].length; ++i) {
            if (stringArrayArray[1][i] == null) {
                ((KFont)this.m_FontNotePad.ro_ref).m_bold = true;
                ++n2;
            }
            KGraphics.drawText(stringArrayArray[0][i].toCharArray(), 0, stringArrayArray[0][i].length(), n6, n4 + n2 * 13 - 3);
            if (stringArrayArray[1][i] == null) {
                ((KFont)this.m_FontNotePad.ro_ref).m_bold = false;
            } else {
                int n7 = KCanvas.m_width * 45 / 100 - ((KFont)this.m_FontNotePad.ro_ref).textWidth(stringArrayArray[1][i].toCharArray(), 0, stringArrayArray[1][i].length());
                KGraphics.drawText(stringArrayArray[1][i].toCharArray(), 0, stringArrayArray[1][i].length(), n7, n4 + n2 * 13 - 3);
            }
            ++n2;
        }
    }

    private byte getSubtotal(boolean bl) {
        int n = 9;
        int n2 = this.getMaxPara();
        if (this.battleType == 5 && n2 == 4 || this.battleType == 6) {
            n = bl ? 8 : 6;
        } else if (this.battleType == 7) {
            n = 15;
        } else if (bl) {
            n = 12;
        }
        return (byte)n;
    }

    private static short getAnimConstant(byte by) {
        short s = 0;
        switch (by) {
            case 8: {
                s = 28684;
                break;
            }
            case 1: {
                s = 28687;
                break;
            }
            case 6: {
                s = 28681;
                break;
            }
            case 5: {
                s = 28682;
                break;
            }
            case 4: {
                s = 28683;
                break;
            }
            case 7: {
                s = 28685;
                break;
            }
            case 3: {
                s = 28692;
                break;
            }
            case 2: {
                s = 28686;
            }
        }
        return s;
    }

    private static void displayInstructionKey(String string, int n) {
        string.getChars(0, string.length(), Utils.charBuffer, 0);
        KGraphics.drawText(Utils.charBuffer, 0, string.length(), n, 115);
    }

    private void displayInstructionKey(String string) {
        string.getChars(0, string.length(), Utils.charBuffer, 0);
        int n = 0;
        n = (120 - ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, string.length())) / 2;
        Battle.displayInstructionKey(string, n);
    }

    private int getLapseBullEye2EndLine(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n3 = Utils.charLastIndexOf(this.charLyrics[n], ' ', this.charLyricsLength[n] - 1, 0) + 1;
        n4 = this.charLyricsLength[n] - 1;
        int n5 = Utils.charLastIndexOf(this.charBeats[n], '*', n3 + (n4 - n3 + 1 >> 1), 0);
        int n6 = Utils.charIndexOf(this.charBeats[n], '*', n3 + (n4 - n3 + 1 >> 1), n4 - (n3 + (n4 - n3 + 1 >> 1)) + 1);
        if ((n3 = (n4 - n3 + 1 >> 1) + n3) != n5) {
            n2 = this.currentTempo * (n6 - n3) / (n6 - n5);
        }
        n2 += this.currentTempo;
        while (n6 < n4) {
            n2 += this.currentTempo;
            n6 = Utils.charIndexOf(this.charBeats[n], '*', n6 + 1, n4 - n6);
        }
        return n2;
    }

    private void displayAnswerDefense(Graphics graphics, byte by, int n, int n2, int n3) {
        int n4 = 0;
        if (this.m_WordsBankLenght[by] != null) {
            int n5 = 0;
            if (this.displayAnswer) {
                if (this.isDefenseSuccessful()) {
                    graphics.setColor(65280);
                    n5 = 1;
                } else {
                    graphics.setColor(0xFF0000);
                }
            } else {
                graphics.setColor(145850);
            }
            Battle.drawScribble(graphics, n, n2 - 1, n3);
            n4 = n + n3 / 2;
            this.m_WordsBank[by][n5].getChars(0, this.m_WordsBank[by][n5].length(), Utils.charBuffer, 0);
            KGraphics.drawText(Utils.charBuffer, 0, this.m_WordsBank[by][n5].length(), n4 -= ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, this.m_WordsBank[by][n5].length()) / 2, n2);
        }
    }

    private byte getWordValue(byte by, short s, boolean bl) {
        byte by2 = 0;
        by2 = this.m_WordsBankScore[by];
        by = (byte)this.m_WordsBankLenght[by][0];
        by2 = s == 2 && by > 0 ? (byte)((byte)((by2 & 0xC0) >> 6)) : (s == 8 && by > 1 ? (byte)((byte)((by2 & 0x30) >> 4)) : (s == 4 && by > 2 ? (byte)((byte)((by2 & 0xC) >> 2)) : (s == 16 && by > 3 ? (byte)((byte)(by2 & 3)) : (byte)0)));
        if (this.mode == 2 && 2 == by2 || 2 == by2 && (this.battleType == 7 || !bl && (this.battleType == 4 || this.battleType == 5 || this.battleType == 6))) {
            by2 = 1;
        }
        return by2;
    }

    private void writeWordsBank(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = ((Image)Battle.m_scratchImage.ro_ref).getHeight();
        if (HeapManager.getFontBufferSize() > 2) {
            Utils.initTextRendering$55c32c91((KFont)this.m_FontWhite.ro_ref);
        } else {
            Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
        }
        if (this.m_FontWhiteSmall == null) {
            this.m_FontWhiteSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0xFFFFFF, false);
        }
        if (this.m_FontNotePadSmall == null) {
            this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
        }
        Utils.initTextRendering$55c32c91((KFont)this.m_FontWhiteSmall.ro_ref);
        if (this.m_WordsBankLenght[n] != null) {
            int n6;
            int n7 = this.m_WordsBankLenght[n][0];
            int n8 = 107;
            int n9 = 0;
            int n10 = this.wordStreak;
            for (n6 = 0; n6 < n7; ++n6) {
                if (n == this.nLastLine) continue;
                this.drawNotePadRegion(graphics, 1 << n6);
                this.refreshDone((byte)0, 1 << n6);
                this.refreshDone((byte)0, 256 << n6);
            }
            for (n6 = 0; n6 < n7; ++n6) {
                int n11;
                if (n6 == 2) {
                    n8 += n5;
                }
                boolean bl = true;
                n9 = this.m_WordsBankLenght[n][(n6 << 2) + 3];
                int n12 = this.m_WordsBankLenght[n][(n6 << 2) + 4];
                if ((KCanvas.m_keyPressed == 2 && n6 == 0 || KCanvas.m_keyPressed == 8 && n6 == 1 || KCanvas.m_keyPressed == 4 && n6 == 2 || KCanvas.m_keyPressed == 16 && n6 == 3) && this.wordSelected == this.m_lastKeyPressed && !this.lineScoreDisplayed) {
                    n2 = m_ColorsSettings[COLOR_FLASH_TARGET];
                    graphics.setColor(m_ColorsSettings[COLOR_FLASH_TARGET]);
                    this.refreshDone((byte)0, 1 << n6);
                } else {
                    if (this.holdButton) {
                        graphics.setColor(this.lastColorScribble[n6]);
                        Battle.drawScribble(graphics, n9, n8 + 1, n12, true);
                        n9 = this.m_WordsBankLenght[n][(n6 << 2) + 2];
                        n11 = this.m_WordsBankLenght[n][(n6 << 2) + 1];
                        this.m_WordsBank[n][n6].getChars(0, this.m_WordsBank[n][n6].length(), Utils.charBuffer, 0);
                        KGraphics.drawText(Utils.charBuffer, 0, n11, n9, n8 + 2);
                        continue;
                    }
                    if (this.holdFinishTime != -1L && this.wordSelected == this.keys[n6]) {
                        if (this.getWordValue((byte)n, this.wordSelected, false) == 3) {
                            n2 = 65280;
                            graphics.setColor(65280);
                        } else {
                            if (this.getWordValue((byte)n, this.wordSelected, false) != 2 || bTutorialMode || this.battleType == 5 || this.battleType == 4 || this.battleType == 7) continue;
                            n2 = 15778315;
                            graphics.setColor(15778315);
                        }
                    } else {
                        n2 = 0;
                        graphics.setColor(0);
                    }
                }
                if (this.battleType == 5 || this.battleType == 4 || this.battleType == 7) {
                    if (this.getWordValue((byte)n, this.keys[n6], true) == 1) {
                        if (this.holdFinishTime != -1L) continue;
                        if (100L * (this.currentTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime) > (long)this.coop1stWordPercent && n3 == 0 && !this.holdButton) {
                            n2 = 0xAAAAAA;
                            graphics.setColor(0xAAAAAA);
                            bl = false;
                            n3 = 1;
                            if (this.lastColorScribble[n6] != n2) {
                                this.refreshDone((byte)0, 1 << n6);
                            }
                        } else if (100L * (this.currentTime - this.holdStartTime) / (this.holdEndTime - this.holdStartTime) > (long)this.coop2ndWordPercent && n3 == 1 && !this.holdButton) {
                            n2 = 0xAAAAAA;
                            graphics.setColor(0xAAAAAA);
                            bl = false;
                            n3 = 2;
                            if (this.lastColorScribble[n6] != n2) {
                                this.refreshDone((byte)0, 1 << n6);
                            }
                        }
                    }
                } else if (this.battleType == 1 && n10 > 0 && this.getWordValue((byte)n, this.keys[n6], false) == 1) {
                    --n10;
                    n2 = 0xAAAAAA;
                    graphics.setColor(0xAAAAAA);
                    bl = false;
                }
                if (this.holdFinishTime != -1L && this.keys[n6] == this.wordSelected && this.getWordValue((byte)n, this.keys[n6], false) != 1) {
                    bl = false;
                }
                if ((this.isRefreshDone((byte)3, 256 << n6) && bl || n2 == 0xAAAAAA) && !this.bAnswerGiven) {
                    this.drawNotePadRegion(graphics, 256 << n6);
                    graphics.setColor(n2);
                    if (n2 == 0xAAAAAA) {
                        this.refreshDone((byte)2, 256 << n6);
                    } else {
                        this.refreshDone((byte)0, 256 << n6);
                    }
                }
                if (this.battleType == 1 && (KCanvas.m_keyPressed == 2 && n6 == 0 || KCanvas.m_keyPressed == 8 && n6 == 1 || KCanvas.m_keyPressed == 4 && n6 == 2 || KCanvas.m_keyPressed == 16 && n6 == 3) && this.lastColorScribble[n6] == 0xAAAAAA) {
                    graphics.setColor(0xAAAAAA);
                }
                Battle.drawScribble(graphics, n9, n8 + 1, n12, true);
                this.lastColorScribble[n6] = n2;
                this.refreshDone((byte)4, 1 << n6);
                if (!(n2 != 15778315 && n2 != 65280 || this.bAnswerGiven)) {
                    this.drawProgressCircle(graphics, this.selectedX, this.selectedY, this.nPercent, this.nPercentMax);
                }
                if (this.holdFinishTime != -1L && this.keys[n6] == this.wordSelected && this.getWordValue((byte)n, this.keys[n6], false) != 1) {
                    this.lineScoreDisplayed = true;
                    n9 = 4 * this.nPercentMax / 100 + 1;
                    if (n9 > 4) {
                        n9 = 4;
                    }
                    if (this.nPercentMax > 50) {
                        n2 = 25;
                    } else {
                        n2 = this.nPercentMax / 2 + 1;
                        if (n2 > 25) {
                            n2 = 25;
                        }
                    }
                    if (this.tmpBonus < n2) {
                        n2 = this.tmpBonus;
                    }
                    if ((n2 /= 6) < 0) {
                        n2 = 0;
                    }
                    String string = "+" + (this.word + this.accuracy + n9 + n2);
                    string.getChars(0, string.length(), Utils.charBuffer, 0);
                    n9 = this.m_WordsBankLenght[n][(n6 << 2) + 3] + n12 / 2 - ((KFont)this.m_FontNotePadSmall.ro_ref).textWidth(Utils.charBuffer, 0, string.length()) / 2;
                    n11 = string.length();
                    Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePadSmall.ro_ref);
                    KGraphics.drawText(Utils.charBuffer, 0, n11, n9, n8 + 2);
                    if (HeapManager.getFontBufferSize() > 2) {
                        Utils.initTextRendering$55c32c91((KFont)this.m_FontWhite.ro_ref);
                    } else {
                        Utils.initTextRendering$55c32c91((KFont)this.m_FontPreviousText.ro_ref);
                    }
                    Utils.initTextRendering$55c32c91((KFont)this.m_FontWhiteSmall.ro_ref);
                } else {
                    n9 = this.m_WordsBankLenght[n][(n6 << 2) + 2];
                    n11 = this.m_WordsBankLenght[n][(n6 << 2) + 1];
                    if (!this.isRefreshDone((byte)1, 1 << n6) || !this.isRefreshDone((byte)2, 256 << n6) && n2 != 0xAAAAAA) {
                        this.m_WordsBank[n][n6].getChars(0, this.m_WordsBank[n][n6].length(), Utils.charBuffer, 0);
                        KGraphics.drawText(Utils.charBuffer, 0, n11, n9, n8 + 2);
                        this.refreshDone((byte)1, 1 << n6);
                    }
                    n9 = this.m_WordsBankLenght[n][(n6 << 2) + 3];
                }
                if (n6 == 0) {
                    n4 = 0;
                } else if (n6 == 1) {
                    n4 = 5;
                } else if (n6 == 2) {
                    n4 = 3;
                } else if (n6 == 3) {
                    n4 = 6;
                }
                if (bl && !this.isRefreshDone((byte)2, 256 << n6)) {
                    if (!this.bAnswerGiven) {
                        Battle.drawAsset(graphics, (byte)5, n9 + n12 + 10, n8 + (n5 - ((Image)Battle.m_targetArrow.ro_ref).getHeight()) / 2 - 3, n4);
                    }
                    this.refreshDone((byte)2, 256 << n6);
                }
                if ((KCanvas.m_keyPressed == 2 && n6 == 0 || KCanvas.m_keyPressed == 8 && n6 == 1 || KCanvas.m_keyPressed == 4 && n6 == 2 || KCanvas.m_keyPressed == 16 && n6 == 3) && this.wordSelected == KCanvas.m_keyPressed) {
                    this.selectedX = n9 + n12 + 2;
                    this.selectedY = n8 + (n5 - ((Image)Battle.m_targetArrow.ro_ref).getHeight()) / 2;
                }
                this.meterPositionX[n6] = n9 + n12;
                this.meterPositionY[n6] = n8 + (n5 - ((Image)Battle.m_targetArrow.ro_ref).getHeight() >> 1);
            }
        }
        Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
    }

    private static void drawScribble(Graphics graphics, int n, int n2, int n3) {
        Battle.drawScribble(graphics, n, n2, n3, false);
    }

    private static void drawScribble(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (bl) {
            n5 = ((Image)Battle.m_scratchImage_176.ro_ref).getHeight();
            n4 = ((Image)Battle.m_scratchImage_176.ro_ref).getWidth();
        } else {
            n5 = ((Image)Battle.m_scratchImage.ro_ref).getHeight();
            n4 = ((Image)Battle.m_scratchImage.ro_ref).getWidth();
        }
        graphics.setClip((n -= 4) - 4, n2 - 1, (n3 += 8) + 8, n5 + 2);
        graphics.fillRect(n - 3, n2, n3 + 6, n5);
        if (bl) {
            KGraphics.drawImage(m_scratchImage_176, n - 3, n2);
        } else {
            KGraphics.drawImage(m_scratchImage, n - 3, n2);
        }
        if (bl) {
            if (n3 + 6 > ((Image)Battle.m_scratchImage_176.ro_ref).getWidth() << 1) {
                n4 = n3 + 6 - (((Image)Battle.m_scratchImage_176.ro_ref).getWidth() << 1);
                KGraphics.drawRegion(m_scratchImage_176, ((Image)Battle.m_scratchImage_176.ro_ref).getWidth() - n4, 0, n4, n5, 3, n - 3 + ((Image)Battle.m_scratchImage_176.ro_ref).getWidth(), n2);
                n4 = ((Image)Battle.m_scratchImage_176.ro_ref).getWidth();
            }
        } else if (n3 + 6 > ((Image)Battle.m_scratchImage.ro_ref).getWidth() << 1) {
            n4 = n3 + 6 - (((Image)Battle.m_scratchImage.ro_ref).getWidth() << 1);
            KGraphics.drawRegion(m_scratchImage, ((Image)Battle.m_scratchImage.ro_ref).getWidth() - n4, 0, n4, n5, 3, n - 3 + ((Image)Battle.m_scratchImage.ro_ref).getWidth(), n2);
            n4 = ((Image)Battle.m_scratchImage.ro_ref).getWidth();
        }
        n = n + (n3 - n4) + 3;
        if (bl) {
            KGraphics.drawRegion(m_scratchImage_176, 0, 0, n4, n5, 3, n, n2);
        } else {
            KGraphics.drawRegion(m_scratchImage, 0, 0, n4, n5, 3, n, n2);
        }
        graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height - 8);
    }

    private void drawTarget(Graphics graphics, int n, char[] object, short s, short s2, boolean n2, boolean bl, boolean n3) {
        int n4 = 0;
        int n5 = 0;
        if (n2) {
            n2 = Utils.charLastIndexOf(object, ' ', s2 - 1 + s, s) + 1;
            n4 = ((KFont)this.m_FontNotePad.ro_ref).textWidth((char[])object, s, n2 - s) + 26;
            n5 = ((KFont)this.m_FontNotePad.ro_ref).textWidth((char[])object, n2, s2 + s - n2);
            if (this.holdStartTime == -1L) {
                graphics.setColor(145850);
            } else {
                graphics.setColor(m_ColorsSettings[COLOR_FLASH_TARGET]);
            }
            Battle.drawScribble(graphics, n4, n, n5);
            if (n3 == 1) {
                if (HeapManager.getFontBufferSize() > 2) {
                    Utils.initTextRendering$55c32c91((KFont)this.m_FontWhite.ro_ref);
                } else {
                    Utils.initTextRendering$55c32c91((KFont)this.m_FontPreviousText.ro_ref);
                }
                n3 = Utils.charLastIndexOf(object, '_', s + s2 - 1, n2);
                if (n3 != -1) {
                    object[n3] = 32;
                }
                KGraphics.drawText(object, n2, s2 + s - n2, n4, n + 1);
                Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
                if (n3 != -1) {
                    object[n3] = 95;
                }
            }
            if (bl) {
                Battle.drawAsset(graphics, (byte)1, n4 + n5 / 2, 12, 0);
            }
        } else {
            n2 = Utils.charIndexOf(object, '(', (int)s, (int)s2);
            if (n2 >= 0) {
                n4 = ((KFont)this.m_FontNotePad.ro_ref).textWidth((char[])object, s, n2 - s) + 26;
                int n6 = Utils.charIndexOf(object, ')', (int)s, (int)s2);
                s = (short)n6;
                if (n6 >= 0) {
                    n5 = ((KFont)this.m_FontNotePad.ro_ref).textWidth((char[])object, n2, s - n2 + 1);
                    if (this.holdStartTime == -1L) {
                        graphics.setColor(145850);
                    } else {
                        graphics.setColor(m_ColorsSettings[COLOR_FLASH_TARGET]);
                    }
                    if (!this.displayAnswer) {
                        Battle.drawScribble(graphics, n4, n, n5);
                        if (n3 == 1) {
                            if (HeapManager.getFontBufferSize() > 2) {
                                Utils.initTextRendering$55c32c91((KFont)this.m_FontWhite.ro_ref);
                            } else {
                                Utils.initTextRendering$55c32c91((KFont)this.m_FontPreviousText.ro_ref);
                            }
                            if (this.mode == 2) {
                                this.displayAnswerDefense(graphics, this.line, n4, n + 1, n5);
                            }
                            Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
                        }
                    } else if (this.mode == 2) {
                        int n7;
                        String string;
                        this.displayAnswerDefense(graphics, this.line, n4, n + 1, n5);
                        if (this.isDefenseSuccessful()) {
                            s = (short)94;
                            string = Utils.getWordsFrom(94, this.fileBufferString);
                            Utils.lengthVirtual = string.length();
                            string.getChars(0, Utils.lengthVirtual, Utils.charBuffer, 0);
                            n7 = ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, Utils.lengthVirtual) + 1;
                        } else {
                            s = (short)89;
                            string = Utils.getWordsFrom(89, this.fileBufferString);
                            Utils.lengthVirtual = string.length();
                            string.getChars(0, Utils.lengthVirtual, Utils.charBuffer, 0);
                            n7 = ((KFont)this.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, Utils.lengthVirtual) + 1;
                        }
                        if (!this.isRefreshDone((byte)1, 16384)) {
                            if (this.lastWrittenWord == 103 || this.lastWrittenWord == 81) {
                                this.drawNotePadRegion(KGraphics.getGraphics(), 16);
                                this.drawNotePadRegion(KGraphics.getGraphics(), 32768);
                            }
                            this.lastWrittenWord = s;
                            this.drawNotePadRegion(KGraphics.getGraphics(), 16384);
                            s = (short)((KCanvas.m_width - n7) / 2);
                            String string2 = string;
                            Battle.displayInstructionKey(string2, s);
                            Battle.displayInstructionKey(string2, s + 1);
                            this.refreshDone((byte)1, 16384);
                        }
                    } else {
                        int n8 = n5;
                        n3 = n;
                        n2 = n4;
                        s2 = this.wordSelected;
                        s = this.line;
                        object = graphics;
                        Battle battle = this;
                        if (battle.m_WordsBankLenght[s] != null) {
                            int n9 = battle.m_WordsBankLenght[s][0];
                            n9 = s2 == 2 && n9 > 0 ? 0 : (s2 == 8 && n9 > 1 ? 1 : (s2 == 4 && n9 > 2 ? 2 : (s2 == 16 && n9 > 3 ? 3 : -1)));
                            if (n9 != -1) {
                                s2 = battle.getWordValue((byte)s, s2, false);
                                if (bTutorialMode && s2 == 2) {
                                    s2 = 1;
                                }
                                if (1 == s2) {
                                    object.setColor(0xFF0000);
                                } else if (2 == s2) {
                                    object.setColor(15778315);
                                } else if (3 == s2) {
                                    object.setColor(65280);
                                } else {
                                    object.setColor(0xAAAAAA);
                                }
                                Battle.drawScribble((Graphics)object, n2, n3, n8);
                                int n10 = n2 + n8 / 2;
                                battle.m_WordsBank[s][n9].getChars(0, battle.m_WordsBank[s][n9].length(), Utils.charBuffer, 0);
                                KGraphics.drawText(Utils.charBuffer, 0, battle.m_WordsBank[s][n9].length(), n10 -= ((KFont)battle.m_FontNotePad.ro_ref).textWidth(Utils.charBuffer, 0, battle.m_WordsBank[s][n9].length()) / 2, n3);
                            }
                        }
                    }
                    if (bl) {
                        this.targetX = n4 + n5 / 2;
                        this.targetWordWidth = n5;
                        Battle.drawAsset(graphics, (byte)1, n4 + n5 / 2, 12, 0);
                    }
                }
            }
        }
        if (!bl && this.bMustDeleteTarget && !this.bTargetDeleted) {
            n = ((Image)Battle.m_target.ro_ref).getWidth();
            int n11 = ((Image)Battle.m_target.ro_ref).getHeight();
            s = (short)(n4 + n5 / 2 - n / 2);
            Utils.drawBackbufferRegion(graphics, s - 1, 11, n + 2, n11, s - 1, 11);
            this.bTargetDeleted = true;
            return;
        }
        if (!bl && this.bTargetDeleted && this.currentTime > this.displayDelayTime && this.mode != 2) {
            int n12 = this.lastDisplayX - ((Image)Battle.m_greenPaf.ro_ref).getWidth() / 2;
            if (n12 < 3) {
                n12 = 3;
            }
            if (n12 < n4) {
                n = n4 - n12;
                Utils.drawBackbufferRegion(graphics, n12 - 3, 24, n, 6, n12 - 3, 24);
            }
        }
    }

    private long getBallJump$799aa41f(char[] cArray, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = (int)(l % (long)n);
        if (n4 == n2) {
            this.previousSilentTime = 0;
        }
        if (bl && (n6 = n6 * 50 / 100) < this.previousSilentTime) {
            n6 += n / 2;
        }
        this.previousSilentTime = n6;
        int n7 = ((KFont)this.m_FontNotePad.ro_ref).textWidth(cArray, 0, n2);
        int n8 = ((KFont)this.m_FontNotePad.ro_ref).textWidth(cArray, 0, n3);
        int n9 = n7 + (n8 - n7) * n6 / n;
        n8 -= n7;
        n7 = n9 - n7;
        n = n8 / 2 * (n8 / 2 - n8);
        n8 = n7 * (n7 - n8);
        n8 = n != 0 ? n8 * n5 / n : n;
        return ((long)n9 << 16) + (long)n8;
    }

    private void updateLineSwitchPercent(long l, byte by, int n, int n2) {
        int[] nArray = this.m_LinesDisplayArray[by];
        int n3 = 0;
        int n4 = 0;
        this.lineSwitchPercent = 0;
        int n5 = 0;
        n3 = Utils.charLastIndexOf(this.charBeats[by], '*', n2, 0);
        n4 = Utils.charIndexOf(this.charBeats[by], '*', n2 + 1, this.charBeatsLength[by] - n2 - 1);
        if (n4 < 0) {
            n4 = n3;
        }
        n3 = Utils.charIndexOf(this.charBeats[by], '~', n3, this.charBeatsLength[by] - n3);
        n2 = 0;
        if (n3 != -1 && n3 < n4) {
            n2 = 1;
        }
        for (by = 1; by <= this.scrollPos; by = (byte)(by + 2)) {
            n5 += nArray[by + 1];
        }
        if (n4 > n5 && (this.scrollPos + 1) / 2 != nArray[0]) {
            int n6 = (int)l % n;
            if (n2 == 1 && (n6 = n6 * 50 / 100) < this.previousSilentTime) {
                n6 += n / 2;
            }
            this.lineSwitchPercent = n6 * 100 / n;
        }
    }

    private void drawBall(Graphics graphics, long l, byte by, int n, int n2) {
        int[] nArray = this.m_LinesDisplayArray[by];
        int n3 = 0;
        int n4 = 0;
        n3 = Utils.charLastIndexOf(this.charBeats[by], '*', n2, 0);
        n4 = Utils.charIndexOf(this.charBeats[by], '*', n2 + 1, this.charBeatsLength[by] - n2 - 1);
        if (n4 < 0) {
            n4 = n3;
        }
        int n5 = Utils.charIndexOf(this.charBeats[by], '~', n3, this.charBeatsLength[by] - n3);
        boolean bl = false;
        if (n5 != -1 && n5 < n4) {
            bl = true;
        }
        long l2 = this.getBallJump$799aa41f(this.charLyrics[by], n, l, n3, n4, n2, 11, bl);
        int n6 = (int)l2 & 0xFFFF;
        n6 = 11 - n6;
        if (this.isOnTap(n2, by)) {
            n6 = 11;
        }
        if (this.leftTarget != -1 && this.rightTarget != -1 && this.leftTarget <= n2 && this.rightTarget >= n2) {
            n6 = 11;
        }
        int n7 = (int)(l2 & 0xFFFFFFFFFFFF0000L) >> 16;
        n7 += 26;
        n7 -= 5;
        n = 1;
        n3 = nArray[2];
        n5 = 0;
        while (n < nArray[0]) {
            if (n2 >= nArray[(n << 1) + 1]) {
                n7 -= ((KFont)this.m_FontNotePad.ro_ref).textWidth(this.charLyrics[by], n5, n3 + 1);
                if (++n > nArray[0]) continue;
                n5 = nArray[(n << 1) - 1];
                n3 = nArray[n << 1];
                continue;
            }
            n = nArray[0];
        }
        by = 0;
        for (n = 1; n <= this.scrollPos; n += 2) {
            by = (byte)(by + nArray[n + 1]);
        }
        if (n4 > by && (this.scrollPos + 1) / 2 != nArray[0] && n4 > by + 1 && 240 < (n7 += (by = (byte)((240 - n7 + 26) * this.lineSwitchPercent / 100)))) {
            n7 -= 240;
        }
        if (m_ballImage != null && !this.changeLine) {
            Battle.drawAsset(graphics, (byte)0, n7, n6, 0);
        }
        this.ballX = n7;
        this.ballY = n6;
    }

    public static void drawAsset(Graphics graphics, byte by, int n, int n2, int n3) {
        switch (by) {
            case 0: {
                KGraphics.drawImage(m_ballImage, n, n2);
                return;
            }
            case 1: {
                by = (byte)((Image)Battle.m_target.ro_ref).getWidth();
                int n4 = ((Image)Battle.m_target.ro_ref).getHeight();
                if (n3 != 0) {
                    graphics.setColor(n3);
                } else {
                    graphics.setColor(m_ColorsSettings[COLOR_FLASH_TARGET]);
                }
                graphics.fillArc(n - 5, n2 - 1, (int)by, n4, 0, 360);
                KGraphics.drawImage(m_target, n - 5, n2 - 1);
                return;
            }
            case 2: {
                by = (byte)((Image)Battle.m_targetArrow.ro_ref).getWidth();
                int n5 = ((Image)Battle.m_targetArrow.ro_ref).getHeight();
                KGraphics.drawRegion(m_targetArrow, 0, 0, (int)by, n5, n3, n, n2);
                return;
            }
            case 3: {
                by = (byte)(((Image)Battle.m_greyArrow.ro_ref).getWidth() / 2);
                KGraphics.drawRegion(m_greyArrow, 0, (int)by, (int)by, (int)by, n3, n, n2);
                return;
            }
            case 4: {
                by = (byte)(((Image)Battle.m_greyArrow.ro_ref).getWidth() / 2);
                KGraphics.drawRegion(m_greyArrow, 0, 0, (int)by, (int)by, n3, n, n2);
                return;
            }
            case 5: {
                by = (byte)(((Image)Battle.m_greyArrow.ro_ref).getWidth() / 2);
                KGraphics.drawRegion(m_greyArrow, (int)by, 0, (int)by, (int)by, n3, n, n2);
                return;
            }
            case 6: {
                by = (byte)(((Image)Battle.m_greyArrow.ro_ref).getWidth() / 2);
                KGraphics.drawRegion(m_greyArrow, (int)by, (int)by, (int)by, (int)by, n3, n, n2);
                return;
            }
            case 8: {
                by = (byte)((Image)Battle.m_greenPaf.ro_ref).getWidth();
                int n6 = ((Image)Battle.m_greenPaf.ro_ref).getHeight() / 2;
                KGraphics.drawImage(m_ballImageSplash, n, n2);
                KGraphics.drawRegion(m_greenPaf, 0, n6, (int)by, n6, 0, n - Math.abs(by - 10) / 2, n2 - Math.abs(n6 - 10) / 2);
                return;
            }
            case 9: {
                by = (byte)((Image)Battle.m_greenPaf.ro_ref).getWidth();
                int n7 = ((Image)Battle.m_greenPaf.ro_ref).getHeight() / 2;
                KGraphics.drawImage(m_ballImageSplash, n, n2);
                KGraphics.drawRegion(m_greenPaf, 0, 0, (int)by, n7, 0, n - Math.abs(by - 10) / 2, n2 - Math.abs(n7 - 10) / 2);
                return;
            }
            case 12: {
                KGraphics.drawImage(m_ballImageSplash, n, n2);
                return;
            }
            case 10: {
                by = (byte)((Image)Battle.m_XRed.ro_ref).getWidth();
                int n8 = ((Image)Battle.m_XRed.ro_ref).getHeight();
                KGraphics.drawImage(m_ballImageSplash, n, n2);
                KGraphics.drawImage(m_XRed, n - (by - 10) / 2, n2 - (n8 - 10) / 2);
                return;
            }
            case 11: {
                KGraphics.drawImage(m_XRed, n, n2);
            }
        }
    }

    private int getBigKey() {
        return ((this.m_keysSequence & 0xC000) >> 14) + 1;
    }

    private int getKeyValue(int n) {
        int n2 = this.m_keysSequence & 0xFF;
        if (n == 1) {
            n2 &= 0xC0;
        } else if (n == 2) {
            n2 &= 0x30;
        } else if (n == 3) {
            n2 &= 0xC;
        } else if (n == 4) {
            n2 &= 3;
        }
        return n2 >> 8 - (n << 1);
    }

    private boolean checkKeyValue(short s, int n) {
        boolean bl = false;
        int n2 = this.getKeyValue(n);
        if (n2 == 1 && s == 8 || n2 == 2 && s == 4 || n2 == 3 && s == 16 || n2 == 0 && s == 2) {
            bl = true;
        }
        return bl;
    }

    private boolean disableKey(int n) {
        int n2 = 0;
        boolean bl = false;
        int n3 = 65535;
        n2 = 0;
        if (n == 1) {
            n3 = 63487;
            n2 = 2048;
        } else if (n == 2) {
            n3 = 62463;
            n2 = 1024;
        } else if (n == 3) {
            n3 = 61951;
            n2 = 512;
        } else if (n == 4) {
            n3 = 61695;
            n2 = 256;
        }
        n2 = (this.m_keysSequence & n2) >> 12 - n;
        this.m_keysSequence &= n3;
        if (n2 == 1) {
            bl = true;
        }
        return bl;
    }

    private static int generateKeysSequence(int n, int n2, int n3) {
        int n4 = (int)KUtils.s_previousTime;
        n = 12288 + 49152 + 3840;
        n3 = (n4 &= 0xFF) % 2 == 0 ? 2 : 3;
        n4 = n4 & 0xF0 & 0xC0;
        n2 = n4 >> 6;
        if ((n2 += 4) % 2 == 0) {
            n4 += (n2 + 1) % 4 << 4;
            n4 = n3 == 2 ? n4 + ((n2 + 2) % 4 << 2) + (n2 + 3) % 4 : n4 + ((n2 + 3) % 4 << 2) + (n2 + 2) % 4;
        } else {
            n4 += (n2 - 1) % 4 << 4;
            n4 = n3 == 2 ? n4 + ((n2 - 2) % 4 << 2) + (n2 - 3) % 4 : n4 + ((n2 - 3) % 4 << 2) + (n2 - 2) % 4;
        }
        return n + n4;
    }

    private void writeLine$4e1616e9(Graphics object, int n, int n2, boolean bl) {
        int n3;
        int n4;
        short s = 0;
        int n5 = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = this.charLyricsLength[n];
        short s5 = 0;
        int[] nArray = this.m_LinesDisplayArray[n];
        int n6 = 0;
        if (this.lastScrollPos == 5 && n2 == 1) {
            this.changeLine = true;
        }
        s = 0;
        if (n2 > this.lastScrollPos) {
            s = 1;
        }
        this.lastScrollPos = n2;
        n6 = 24;
        if (this.lineSwitchPercent != 0 || n != this.nLastLine) {
            if (this.mode == 2) {
                this.drawNotePadRegion((Graphics)object, Integer.MIN_VALUE);
                this.refreshDone((byte)0, Integer.MIN_VALUE);
                this.refreshDone((byte)0, 32);
                this.refreshDone((byte)0, 16);
                this.refreshDone((byte)0, 16384);
                this.refreshDone((byte)0, 8192);
                this.lastWrittenWord = 0;
            } else {
                this.drawNotePadRegion((Graphics)object, 128);
            }
            this.refreshDone((byte)0, 4096);
            this.refreshDone((byte)0, 128);
            this.refreshDone((byte)4, 65536);
            this.refreshDone((byte)4, 131072);
            this.refreshDone((byte)4, 262144);
            this.refreshDone((byte)4, 524288);
        }
        if (this.lineSwitchPercent > 0 && this.currentPos != nArray[n2] && (n6 = 24 - 24 * this.lineSwitchPercent / 100) < 24 && s != 0) {
            n6 = 24;
        }
        if ((n4 = (nArray[0] << 1) + 1) > (n3 = n2) + 5) {
            n4 = n3 + 5;
        }
        for (n3 = n2; n3 < n4; n3 += 2) {
            s3 = (short)nArray[n3];
            s2 = (short)nArray[n3 + 1];
            s = (short)nArray[n3];
            n5 = nArray[n3 + 1];
            short s6 = 0;
            if (this.scrollPos == n3 && this.lineSwitchPercent == 0) {
                if (this.mode == 2 || this.displayDelayTime == -1L || (nArray[0] << 1) - 1 != this.scrollPos) {
                    s6 = 1;
                } else {
                    this.bMustDeleteTarget = true;
                }
            }
            if (!this.isRefreshDone((byte)1, 128) || this.bRewriteLineAfterSplash) {
                KGraphics.drawText(this.charLyrics[n], s3, s2, 26, n6);
                this.bRewriteLineAfterSplash = false;
                this.changeLine = false;
            }
            Utils.SaveClip();
            if (this.mode == 1 && this.line != 0) {
                KGraphics.getGraphics().setClip(0, 0, KCanvas.m_width, 94);
            }
            if (n3 + 2 >= n4) {
                if (this.isLeaderLine()) {
                    if ((nArray[0] << 1) + 1 == n3 + 2 && !this.changeLine) {
                        this.drawTarget((Graphics)object, n6 - 1, this.charLyrics[n], s3, s2, true, s6 != 0, bl);
                        this.drawTextAroundTarget(this.charLyrics[n], s3, s2, 26, n6, true);
                    }
                } else if (this.mode == 2) {
                    if (!this.isRefreshDone((byte)1, 8192) || n2 + 1 == nArray[0] << 1) {
                        this.drawTarget((Graphics)object, n6 - 1, this.charLyrics[n], s3, s2, false, false, bl);
                        this.drawTextAroundTarget(this.charLyrics[n], s3, s2, 26, n6, false);
                        if (!this.displaySplashHit) {
                            this.refreshDone((byte)1, 8192);
                        } else {
                            this.refreshDone((byte)4, 8192);
                        }
                    }
                } else if (!this.changeLine) {
                    this.drawTarget((Graphics)object, n6 - 1, this.charLyrics[n], s3, s2, false, s6 != 0, bl);
                    this.drawTextAroundTarget(this.charLyrics[n], s3, s2, 26, n6, false);
                }
            }
            Utils.RestoreClip();
            short s7 = n3 == n2 ? (short)0 : 1;
            short s8 = s7;
            int n7 = nArray[n3];
            short s9 = s6;
            int n8 = n5;
            short s10 = s;
            char[] cArray = this.charTaps[n];
            s7 = s2;
            s6 = s3;
            char[] cArray2 = this.charLyrics[n];
            s2 = (short)n6;
            Object object2 = object;
            Battle battle = this;
            int n9 = 0;
            int n10 = -1;
            n9 = 0;
            while (n9 < n8) {
                if ((n9 = Utils.charIndexOf(cArray, '*', s10 + n9, n8 - n9)) != -1) {
                    int n11 = ((KFont)battle.m_FontNotePad.ro_ref).textWidth(cArray2, s6, n9 -= s10);
                    n10 = Utils.charIndexOf(cArray, ' ', s10 + n9, n8 - n9);
                    int n12 = n10 == -1 ? ((KFont)battle.m_FontNotePad.ro_ref).textWidth(cArray2, s6 + n9, s7 - n9) : ((KFont)battle.m_FontNotePad.ro_ref).textWidth(cArray2, s6 + n9, (n10 -= s10) - n9);
                    int n13 = battle.getCurrentTap(n9 + n7);
                    int n14 = battle.getKeyValue(n13);
                    int n15 = battle.getNextTap(battle.currentPos);
                    if (s8 != 0 && !battle.changeLine) {
                        object2.setColor(0x585858);
                        if (!battle.isRefreshDone((byte)2, 65536 << n14)) {
                            object2.drawRect(n11 + 26 + 1, s2 + 26 - 2, n12, 1);
                        }
                        if (n13 < n15 || n15 == -1) {
                            object2.setColor(0x585858);
                        } else if (n13 == n15) {
                            object2.setColor(m_ColorsSettings[COLOR_FLASH_TARGET]);
                        } else {
                            object2.setColor(255);
                        }
                        if (!battle.isRefreshDone((byte)2, 65536 << n14)) {
                            object2.drawRect(n11 + 26, s2 + 26 - 3, n12, 1);
                            if (!bTutorialMode) {
                                battle.refreshDone((byte)2, 65536 << n14);
                            }
                        }
                    }
                    int n16 = n14;
                    if (n14 == 0) {
                        n14 = 0;
                    } else if (n14 == 1) {
                        n14 = 5;
                    } else if (n14 == 2) {
                        n14 = 3;
                    } else if (n14 == 3) {
                        n14 = 6;
                    }
                    if (s9 != 0 && !battle.changeLine) {
                        if (n13 == n15) {
                            Battle.drawAsset(object2, (byte)2, n11 + 26 + n12 / 2 - (((Image)Battle.m_targetArrow.ro_ref).getWidth() << 1) / 3, 6, n14);
                        } else if (n13 < n15 || n15 == -1) {
                            Utils.SaveClip();
                            KGraphics.getGraphics().setClip(n11 + 26 + n12 / 2 - (((Image)Battle.m_targetArrow.ro_ref).getWidth() << 1) / 3, 3, ((Image)Battle.m_greyArrow.ro_ref).getWidth() / 2, ((Image)Battle.m_greyArrow.ro_ref).getWidth() / 2);
                            battle.drawNotePadRegion((Graphics)object2, Integer.MIN_VALUE);
                            Utils.RestoreClip();
                            Battle.drawAsset(object2, (byte)3, n11 + 26 + n12 / 2 - (((Image)Battle.m_targetArrow.ro_ref).getWidth() << 1) / 3, 6, n14);
                            if (!bTutorialMode) {
                                battle.refreshDone((byte)2, 65536 << n16);
                            }
                            battle.refreshDone((byte)4, 32);
                        } else if (!battle.isRefreshDone((byte)2, 65536 << n16)) {
                            Battle.drawAsset(object2, (byte)4, n11 + 26 + n12 / 2 - (((Image)Battle.m_targetArrow.ro_ref).getWidth() << 1) / 3, 6, n14);
                            battle.refreshDone((byte)2, 65536 << n16);
                        }
                    }
                    if (n13 == n15 && m_state != 6 && !battle.changeLine) {
                        battle.drawNotePadRegion((Graphics)object2, 32);
                        battle.refreshDone((byte)0, 32);
                        Battle.drawAsset(object2, (byte)4, 112, 120, n14);
                        battle.refreshDone((byte)2, 32);
                        if (!battle.isRefreshDone((byte)1, 16)) {
                            battle.displayInstructionKey(Utils.getWordsFrom(103, battle.fileBufferString));
                            battle.lastWrittenWord = 103;
                            battle.refreshDone((byte)1, 16);
                        }
                    }
                    battle.displayAnswer = n15 == -1;
                }
                if (n9 == -1 || n10 == -1) {
                    n9 = n8;
                    continue;
                }
                n9 = n10;
            }
            n6 += 28;
        }
        if (nArray[0] - n2 / 2 < 3 && n < 3) {
            Utils.initTextRendering$55c32c91((KFont)this.m_FontPreviousText.ro_ref);
            int[] nArray2 = this.m_LinesDisplayArray[n + 1];
            object = nArray2;
            s3 = (short)nArray2[1];
            s2 = (short)(object[1] + object[2]);
            if (n2 == (this.m_LinesDisplayArray[n][0] << 1) - 1) {
                s5 = (short)object[3];
                s4 = (short)object[4];
            }
            if (!this.isRefreshDone((byte)1, 128)) {
                KGraphics.drawText(this.charLyrics[n + 1], s3, s2, 26, n6);
                if (n2 == (this.m_LinesDisplayArray[n][0] << 1) - 1) {
                    KGraphics.drawText(this.charLyrics[n + 1], s5, s4, 26, n6 += 28);
                }
            }
            Utils.initTextRendering$55c32c91((KFont)this.m_FontNotePad.ro_ref);
        }
        if (!this.isRefreshDone((byte)1, 128)) {
            this.refreshDone((byte)1, 128);
        }
    }

    private void drawTextAroundTarget(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        KFont kFont = (KFont)((Battle)((Object)kFont)).m_FontNotePad.ro_ref;
        n3 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                if (cArray[n + i] == '(') {
                    n5 = i - 1;
                }
                if (cArray[n + i] != ')') continue;
                n6 = i + 1;
                n7 = i;
                break;
            }
            n7 = kFont.textWidth(cArray, n, n7 + 1);
        } else {
            for (int i = n2; i >= 0; --i) {
                if (cArray[n + i] == ' ') {
                    if (n3 == 0) continue;
                    n5 = i;
                    break;
                }
                n3 = 1;
            }
        }
        if (n5 >= 0) {
            KGraphics.drawText(cArray, n, n5, 26, n4);
            if (!bl) {
                KGraphics.drawText(cArray, n + n6, n2 - n6, n7 + 26, n4);
            }
        }
    }

    private boolean isOnTap(int n, byte by) {
        return this.charTaps[by][n] == '*';
    }

    private int getCurrentTap(int n) {
        int n2 = -1;
        for (int i = 0; i < 4; ++i) {
            if (n < this.m_tapsPositions[i << 1] || n > this.m_tapsPositions[(i << 1) + 1]) continue;
            n2 = i + 1;
            i = 8;
        }
        return n2;
    }

    private int getNextTap(int n) {
        int n2 = -1;
        for (int i = 3; i >= 0; --i) {
            if (n > this.m_tapsPositions[(i << 1) + 1]) continue;
            n2 = i + 1;
        }
        return n2;
    }

    private void getTapsPositions(byte by) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = Utils.charIndexOf(this.charTaps[by], '*', 0, (int)this.charTapsLength[by]);
        for (n4 = 0; n4 < 8; ++n4) {
            this.m_tapsPositions[n4] = 0;
        }
        n4 = 0;
        if (n != -1) {
            n2 = n;
            n3 = n;
        }
        while (n != -1) {
            if ((n = Utils.charIndexOf(this.charTaps[by], '*', n + 1, this.charTapsLength[by] - (n + 1))) == n3 + 1) {
                n3 = n;
                continue;
            }
            this.m_tapsPositions[n4] = (byte)n2;
            this.m_tapsPositions[n4 + 1] = (byte)n3;
            n4 += 2;
            n2 = n;
            n3 = n;
        }
        n2 = this.charTapsLength[by] - 1;
        for (n = 0; this.charTaps[by][n] == ' ' && n < this.charTapsLength[by]; ++n) {
        }
        while (n2 > -1 && this.charTaps[by][n2] == ' ') {
            --n2;
        }
        if (this.isLeaderLine() && n2 - n + 1 < 2) {
            this.bNoTap = true;
            this.lastHitSucceed = true;
            return;
        }
    }

    private boolean isOnTarget(int n, byte by) {
        boolean bl = false;
        if (by == 0) {
            if (n > this.leftTarget && n <= this.rightTarget) {
                bl = true;
            }
        } else {
            this.getTargetPositions(by);
            if (n >= this.leftTarget && n < this.rightTarget) {
                bl = true;
                this.accuracy = Math.abs(this.targetX - this.ballX) <= this.targetWordWidth * 10 / 100 ? (byte)4 : (Math.abs(this.targetX - this.ballX) <= this.targetWordWidth * 30 / 100 ? (byte)3 : (byte)2);
            } else {
                this.accuracy = 0;
            }
        }
        return bl;
    }

    private void getTargetPositions(byte by) {
        this.leftTarget = Utils.charIndexOf(this.charLyrics[by], '(', 0, (int)this.charLyricsLength[by]);
        this.rightTarget = Utils.charIndexOf(this.charLyrics[by], ')', 0, (int)this.charLyricsLength[by]);
        if (this.leftTarget == -1 || this.rightTarget == -1) {
            this.leftTarget = Utils.charLastIndexOf(this.charLyrics[by], ' ', this.charLyricsLength[by] - 1, 0);
            this.rightTarget = this.charLyricsLength[by] - 1;
        }
    }

    private void countLinesSize2$255f295(int n) {
        int n2;
        int n3 = this.charLyricsLength[n] - 1;
        int n4 = 0;
        int n5 = this.charLyricsLength[n] - 1;
        int n6 = 0;
        System.arraycopy(this.charLyrics[n], 0, Utils.charBuffer, 0, this.charLyricsLength[n]);
        int n7 = 1;
        n4 = this.getMaxStringLength2(Utils.charBuffer, 0, this.charLyricsLength[n] - 1);
        if (n4 <= 0) {
            n4 = this.charLyricsLength[n];
        }
        for (n6 = n4; n6 < n3; n6 += n4) {
            n4 = n6 + 1;
            n2 = this.getMaxStringLength2(Utils.charBuffer, n4, n5);
            ++n6;
            n4 = 0 != n2 ? n2 : n5 - n4 + 1;
            ++n7;
        }
        this.m_LinesDisplayArray[n] = new int[(n7 << 1) + 1];
        this.m_LinesDisplayArray[n][0] = n7;
        n5 = this.charLyricsLength[n] - 1;
        n7 = 1;
        n4 = this.getMaxStringLength2(Utils.charBuffer, 0, n5);
        if (n4 <= 0) {
            n4 = this.charLyricsLength[n];
        }
        this.m_LinesDisplayArray[n][1] = 0;
        this.m_LinesDisplayArray[n][2] = n4;
        for (n6 = n4; n6 < n3; n6 += n4) {
            n4 = n6 + 1;
            n2 = this.getMaxStringLength2(Utils.charBuffer, n4, n5);
            n4 = 0 != n2 ? n2 : n5 - n4 + 1;
            this.m_LinesDisplayArray[n][(++n7 << 1) - 1] = ++n6;
            this.m_LinesDisplayArray[n][n7 << 1] = n4;
        }
    }

    private int getMaxStringLength2(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n2;
        int n5 = Utils.charLastIndexOf(cArray, ' ', n2, n);
        int n6 = n5 = (n2 = Utils.charLastIndexOf(cArray, '-', n2, n)) > n5 ? n2 : n5;
        for (n3 = n; n3 < n4 && cArray[n3] == ' '; ++n3) {
        }
        while (n3 < n4 && cArray[n4] == ' ') {
            --n4;
        }
        n2 = Utils.charLastIndexOf(cArray, '-', (n5 = Utils.charLastIndexOf(cArray, ' ', n5 - 1, n)) - 1, n);
        int n7 = n5 = n2 > n5 ? n2 : n5;
        if (((KFont)this.m_FontNotePad.ro_ref).textWidth(cArray, n3, n4 - n3 + 1) <= 183) {
            return 0;
        }
        n2 = 0;
        if (((KFont)this.m_FontNotePad.ro_ref).textWidth(cArray, n3, n5 - n3 + 1) > 183) {
            n2 = 1;
        }
        while (((KFont)this.m_FontNotePad.ro_ref).textWidth(cArray, n3, n5 - n3 + 1) > 183) {
            if ((n5 = Utils.charLastIndexOf(cArray, ' ', n5, n)) == -1) {
                n5 = 0;
                break;
            }
            --n5;
        }
        if ((n5 += n2) == -1) {
            n5 = n4;
        }
        return n5 - n3;
    }

    private void countWordsBankLenght2(int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        int n7 = 0;
        n3 = 0;
        n = 0;
        this.m_WordsBank[n2] = new String[4];
        do {
            if ((n3 = Utils.charIndexOf(cArray, '/', n3 + 1, n4 - n3)) == -1) continue;
            this.m_WordsBank[n2][n5] = new String(cArray, n, n3 - n);
            n = n3 + 1;
            ++n5;
        } while (n3 != -1);
        this.m_WordsBankLenght[n2] = new int[(n5 << 2) + 1];
        this.m_WordsBankLenght[n2][0] = n5;
        if (n5 == 3) {
            int n8 = n2;
            this.m_WordsBankScore[n8] = this.m_WordsBankScore[n8] & 0xFC;
        }
        if (n5 == 2) {
            int n9 = n2;
            this.m_WordsBankScore[n9] = this.m_WordsBankScore[n9] & 0xF0;
        }
        this.shuffleWordBank$4868d30e(n2, n5);
        n = KCanvas.m_width;
        for (n6 = 0; n6 < n5; ++n6) {
            this.m_WordsBank[n2][n6].getChars(0, this.m_WordsBank[n2][n6].length(), Utils.charBufferTmp, 0);
            by = (byte)this.m_WordsBank[n2][n6].length();
            n3 = n / 2;
            int n10 = 0;
            if (n6 == 1 || n6 == 3) {
                n10 = n3 - 1;
                ++n3;
            }
            if (n6 == 2 && n5 == 3) {
                n10 = n3 / 2;
            }
            if (this.m_FontNotePad == null) {
                return;
            }
            if (this.m_FontNotePadSmall == null) {
                this.m_FontNotePadSmall = (KRes)HeapManager.instance.get("fontBattleSmall.fpak", 0, false);
            }
            while (((KFont)this.m_FontNotePadSmall.ro_ref).textWidth(Utils.charBufferTmp, 0, by) > n3 - 2) {
                by = (byte)(by - 1);
            }
            n7 = (n3 - ((KFont)this.m_FontNotePadSmall.ro_ref).textWidth(Utils.charBufferTmp, 0, by)) / 2;
            ++n7;
            n3 = ((KFont)this.m_FontNotePadSmall.ro_ref).textWidth(Utils.charBufferTmp, 0, by) + 2;
            Utils.charBuffer[0] = 109;
            Utils.charBuffer[1] = 109;
            n4 = ((KFont)this.m_FontNotePadSmall.ro_ref).textWidth(Utils.charBuffer, 0, 2);
            int n11 = 0;
            if (n4 > n3) {
                n11 = n4 - n3 >> 1;
                n3 = n4;
            }
            this.m_WordsBankLenght[n2][(n6 << 2) + 1] = by;
            this.m_WordsBankLenght[n2][(n6 << 2) + 2] = n10 + n7 - ((Image)Battle.m_targetArrow.ro_ref).getWidth() / 4;
            this.m_WordsBankLenght[n2][(n6 << 2) + 3] = n10 - 1 + n7 - n11 - ((Image)Battle.m_targetArrow.ro_ref).getWidth() / 4;
            this.m_WordsBankLenght[n2][(n6 << 2) + 4] = n3;
        }
    }

    private void shuffleWordBank$4868d30e(int n, int n2) {
        int n3;
        String[] stringArray = new String[4];
        if (this.mode == 2) {
            return;
        }
        long l = System.currentTimeMillis();
        int[] nArray = new int[n2];
        int[] nArray2 = nArray;
        nArray[0] = (int)(l % (long)n2);
        nArray2[1] = (int)(l / 109L % (long)n2);
        if (nArray2[0] == nArray2[1]) {
            nArray2[1] = (nArray2[1] + 1) % n2;
        }
        if (n2 > 2) {
            while (nArray2[2] == nArray2[1] || nArray2[2] == nArray2[0]) {
                nArray2[2] = nArray2[2] + 1;
            }
        }
        if (n2 > 3) {
            while (nArray2[3] == nArray2[1] || nArray2[3] == nArray2[0] || nArray2[3] == nArray2[2]) {
                nArray2[3] = nArray2[3] + 1;
            }
        }
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            stringArray[n3] = this.m_WordsBank[n][n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.m_WordsBank[n][nArray2[n3]] = stringArray[n3];
            n5 = (this.m_WordsBankScore[n] & WORD_SCORE[n3]) << (n3 << 1) >> (nArray2[n3] << 1) & 0xFF;
            n4 |= n5;
        }
        this.m_WordsBankScore[n] = n4;
    }

    private boolean isLeaderLine() {
        return this.mode == 1 && this.line == 0;
    }

    private void setCrowdMeterColor(byte by, int n, int n2) {
        this.currentColorSet = by;
        if (by == 2) {
            by = n <= 25 ? (byte)3436981 : (n <= 50 ? (byte)5608150 : (n <= 75 ? (byte)7779319 : (n <= 100 ? (byte)10016255 : (byte)0)));
            n = by;
            Battle.m_ColorsSettings[0] = by;
            Battle.m_ColorsSettings[1] = n;
            if (this.tapsSucceed > 0 && this.isLeaderLine()) {
                Battle.drawMultiplier(this.tapsSucceed);
                return;
            }
            Battle.drawMultiplier(0);
            return;
        }
        if (n2 == 0) {
            by = (byte)0x960000;
            n = 0xFF0000;
        } else if (n2 == 100) {
            by = (byte)38400;
            n = 65280;
        } else if (n2 == 50) {
            by = (byte)0x969600;
            n = 0xFFFF00;
        } else if (n2 < 50) {
            by = (byte)(0x960000 + (n2 * 3 << 8));
            n = 0xFF0000 + (n2 * 5 << 8);
        } else if (n2 > 50) {
            by = (byte)(38400 + (150 - (n2 -= 50) * 3 << 16));
            n = 65280 + (255 - n2 * 5 << 16);
        } else {
            by = 0;
            n = 0;
        }
        Battle.m_ColorsSettings[0] = by;
        Battle.m_ColorsSettings[1] = n;
    }

    private static void createLEDImage() {
        if (m_ledProgressBar != null) {
            return;
        }
        Image image = Image.createImage((int)74, (int)8);
        Graphics graphics = image.getGraphics();
        Image image2 = KGraphics.createGradient(37, 0xFF0000, 0xFFFF00, false);
        graphics.drawImage(image2, 0, 0, 20);
        image2 = KGraphics.createGradient(37, 0xFFFF00, 65280, false);
        graphics.drawImage(image2, 37, 0, 20);
        m_ledProgressBar = KResource.addUserResource(image);
    }

    private static void drawBonusOnly$11c44857(Graphics graphics, int n) {
        int n2;
        if (n > 100) {
            n = 100;
        } else if (n < 0) {
            n = 0;
        }
        int n3 = n == 0 ? 0 : (n % 25 != 0 ? 2 * (n % 25) : 50);
        int n4 = KCanvas.m_height - ((Image)Battle.m_meterImage.ro_ref).getHeight();
        n4 -= 8;
        n4 += 6;
        if (n <= 25) {
            n = 0;
            n2 = 3436981;
        } else if (n <= 50) {
            n = 3436981;
            n2 = 5608150;
        } else if (n <= 75) {
            n = 5608150;
            n2 = 7779319;
        } else {
            n = 7779319;
            n2 = 10016255;
        }
        graphics.setColor(0);
        graphics.fillRect(28, n4, 50, 5);
        graphics.setColor(n);
        graphics.fillRect(28, n4 + 1, 50, 3);
        graphics.setColor(n2);
        graphics.fillRect(28, n4 + 1, n3, 3);
    }

    private void drawCrowdMeter(Graphics graphics, int n, int n2, int n3) {
        Utils.SaveClip();
        graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
        if (m_ledProgressBar == null) {
            return;
        }
        if (n2 > 100) {
            n2 = 100;
        } else if (n2 < 0) {
            n2 = 0;
        }
        if (n > 100) {
            n = 100;
        } else if (n < 0) {
            n = 0;
        }
        int n4 = n * 3 / 4;
        int n5 = n3 * 3 / 4;
        graphics.setColor(m_ColorsSettings[0]);
        int n6 = KCanvas.m_height - ((Image)Battle.m_meterImage.ro_ref).getHeight();
        int n7 = 0;
        graphics.fillRect(4, (n6 -= 8) + 2, 21, 8);
        if ((n <= n3 / 2 || n >= n3) && m_ColorsSettings[0] < m_ColorsSettings[1]) {
            graphics.setColor(m_ColorsSettings[1]);
            graphics.drawRect(4, n6 + 2, 20, 7);
        }
        n6 = KCanvas.m_height;
        n6 -= 8;
        KGraphics.drawImage(m_ledProgressBar, 4, n6 -= ((Image)Battle.m_ledProgressBar.ro_ref).getHeight() + 1);
        n7 = n4 + 4;
        n4 = 75 - n4;
        graphics.setColor(0);
        graphics.fillRect(n7, n6, n4, ((Image)Battle.m_ledProgressBar.ro_ref).getHeight());
        n6 = KCanvas.m_height - ((Image)Battle.m_meterImage.ro_ref).getHeight();
        ((Image)Battle.m_meterImage.ro_ref).getWidth();
        KGraphics.drawImage(m_meterImage, 2, n6 -= 8);
        graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
        if (n2 >= 0) {
            Battle.drawBonusOnly$11c44857(graphics, n2);
        }
        n7 = n5 + 2 - 1;
        n6 = KCanvas.m_height;
        n6 -= 8;
        n6 -= ((Image)Battle.m_ledProgressBar.ro_ref).getHeight();
        KGraphics.drawRegion(m_thresholdImage, 0, 0, ((Image)Battle.m_thresholdImage.ro_ref).getWidth(), ((Image)Battle.m_thresholdImage.ro_ref).getHeight(), 3, n7, n6 -= 2);
        n6 += ((Image)Battle.m_ledProgressBar.ro_ref).getHeight();
        KGraphics.drawImage(m_thresholdImage, n7, n6 -= 2);
        if (this.mode == 2 && this.currentColorSet != 1) {
            this.setCrowdMeterColor((byte)1, this.bonus, this.score);
        } else if (this.mode == 1 && this.line != 0 && this.currentColorSet != 1) {
            this.setCrowdMeterColor((byte)1, this.bonus, this.score);
        } else if (this.isLeaderLine() && this.currentColorSet != 2 && this.currentTime < this.holdEndTime - (long)this.currentTempo) {
            this.setCrowdMeterColor((byte)2, this.bonus, this.score);
        }
        if (this.currentColorSet == 1 || this.tapsSucceed == 0 || this.bPullingBack) {
            int n8 = 0;
            n8 = this.score - this.pullback;
            if (n8 < 0) {
                n8 = 0;
            }
            n = KCanvas.m_height - ((Image)Battle.m_meterImage.ro_ref).getHeight();
            n -= 8;
            if (m_scoreDigitsImage != null) {
                int n9 = 2;
                n9 = n8 >= 100 ? (n9 += 3) : (n8 >= 10 ? (n9 += 5) : (n9 += 7));
                if (n8 >= 100) {
                    n2 = n8 / 100;
                    KGraphics.drawRegion(m_scoreDigitsImage, n2 % 5 * 3, n2 / 5 * 6, 3, 6, 0, n9, n + 3);
                    n9 += 4;
                }
                if (n8 >= 10) {
                    if (n8 >= 100) {
                        n8 -= 100;
                    }
                    n2 = n8 / 10;
                    KGraphics.drawRegion(m_scoreDigitsImage, n2 % 5 * 3, n2 / 5 * 6, 3, 6, 0, n9, n + 3);
                    n9 += 4;
                }
                if (n8 >= 0) {
                    n2 = n8 % 10;
                    KGraphics.drawRegion(m_scoreDigitsImage, n2 % 5 * 3, n2 / 5 * 6, 3, 6, 0, n9, n + 3);
                    n9 += 4;
                }
                KGraphics.drawRegion(m_scoreDigitsImage, 15, 6, 7, 6, 0, n9, n + 3);
            }
        } else {
            Battle.drawMultiplier(this.tapsSucceed + 1);
        }
        Utils.RestoreClip();
    }

    private static void drawMultiplier(int n) {
        int n2 = KCanvas.m_height - ((Image)Battle.m_meterImage.ro_ref).getHeight();
        n2 -= 8;
        ((Image)Battle.m_meterImage.ro_ref).getWidth();
        if (n > 0) {
            KGraphics.drawRegion(m_scoreDigitsImage, 18, 0, 3, 3, 0, 11, n2 + 3 + 3);
            KGraphics.drawRegion(m_scoreDigitsImage, n * 3, 0, 3, 6, 0, 15, n2 + 3);
        }
    }

    private void drawProgressCircle(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n > KCanvas.m_width - ((Image)Battle.m_holdMeterImage.ro_ref).getWidth()) {
            n = KCanvas.m_width - ((Image)Battle.m_holdMeterImage.ro_ref).getWidth();
        }
        int n5 = ((Image)Battle.m_holdMeterImage.ro_ref).getHeight();
        ++n;
        ++n2;
        KGraphics.drawImage(m_holdMeterImage, --n, --n2);
        ++n;
        ++n2;
        n5 -= 2;
        if (n4 > 100) {
            n4 = 100;
        }
        if (n3 > 100) {
            n3 = 100;
        }
        if ((n3 = n3 * 360 / 100) > (n4 = n4 * 360 / 100)) {
            n3 = n4;
        }
        graphics.setColor(0xAAAAAA);
        graphics.fillArc(n, n2, n5, n5, 90 - n4, n4 - n3);
        graphics.setColor(5608150);
        graphics.fillArc(n, n2, n5, n5, 90 - n3, n3);
        --n;
        --n2;
        ++n;
        ++n2;
        KGraphics.drawImage(m_holdMeterBorderImage, --n, --n2);
        int n6 = 256;
        if (n > 120) {
            n6 = 512;
        }
        if (n2 > 109) {
            n6 <<= 2;
        }
        this.refreshDone((byte)3, n6);
    }

    private void refreshScore() {
        switch (this.mode) {
            case 2: {
                this.score -= 8;
                if (this.isDefenseSuccessful()) {
                    this.score += 8;
                } else {
                    --this.cpt_rankPoints;
                    ++this.cpt_blockMissed;
                }
                if (this.score >= 0) break;
                this.score = 0;
                return;
            }
            case 1: {
                byte by;
                if (this.line == 0) {
                    boolean bl = false;
                    if (!this.lastHitSucceed) {
                        this.bonus = this.tmpBonus;
                    } else {
                        this.tmpBonus = this.bonus;
                    }
                    if (this.bonus <= 100) break;
                    this.bonus = 100;
                    return;
                }
                int n = 0;
                this.score -= 8;
                if (this.score < 0) {
                    this.score = 0;
                }
                this.pullback = 0;
                if (this.word != 0 && this.accuracy != 0 && this.lastHitSucceed) {
                    by = this.word;
                    byte by2 = this.accuracy;
                    int n2 = 4 * this.nPercentMax / 100 + 1;
                    if (n2 > 4) {
                        n2 = 4;
                    }
                    if (this.nPercentMax > 50) {
                        n = 25;
                    } else {
                        n = this.nPercentMax / 2 + 1;
                        if (n > 25) {
                            n = 25;
                        }
                    }
                    if (this.tmpBonus < n) {
                        n = this.tmpBonus;
                    }
                    if ((n /= 6) < 0) {
                        n = 0;
                    }
                    this.score += by + by2 + n2 + n;
                    if (this.score > 100) {
                        this.score = 100;
                    }
                } else if (!this.lastHitSucceed && this.bonus < 0) {
                    this.bonus = 0;
                }
                this.tmpBonus = this.bonus;
                by = this.accuracy;
                n = this.word;
                if (n == 0 || n == 6 && this.battleType != 3 && this.battleType != 2 && this.battleType != 1) {
                    this.cpt_rankPoints -= 2;
                    ++this.cpt_wordWrong;
                    this.wordStreak = 0;
                } else {
                    this.wordStreak = (byte)(this.wordStreak + 1);
                    if (n == 8) {
                        ++this.cpt_wordBest;
                    } else if (n == 6) {
                        ++this.cpt_wordGood;
                        --this.cpt_rankPoints;
                    }
                }
                if (by == 4) {
                    ++this.cpt_accPerfect;
                    return;
                }
                if (by == 3) {
                    ++this.cpt_accGood;
                    --this.cpt_rankPoints;
                    return;
                }
                this.cpt_rankPoints -= 2;
                if (by == 2) {
                    ++this.cpt_accOk;
                    return;
                }
                if (by != 0) break;
                ++this.cpt_accMissed;
            }
        }
    }

    public final byte getRank() {
        int n = this.score < this.threshold ? 5 : (this.cpt_rankPoints * 10 > rankMaxPoints * 9 && this.cpt_accMissed == 0 && this.cpt_wordWrong == 0 && this.cpt_blockMissed == 0 ? 1 : (this.cpt_rankPoints * 10 > rankMaxPoints << 3 ? 2 : (this.cpt_rankPoints * 10 > rankMaxPoints * 7 ? 3 : 4)));
        return (byte)n;
    }

    private boolean isDefenseSuccessful() {
        boolean bl = false;
        if (this.tapsSucceed >= this.level - 1 && this.tapsSucceed >= 2) {
            bl = true;
        }
        return bl;
    }

    private static void drawAnimRec(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n2 + n4 >= KCanvas.m_height - 8) {
            n4 = KCanvas.m_height - 8 - n2 - 1;
        }
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n - 1, n2 - 1, n3 + 1, n4 + 1);
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        graphics.setClip(n, n2, n3, n4);
        Image image = KGraphics.createGradient$7db24bf5$761a86b2(n4, n5);
        for (n5 = n; n5 < n + n3; n5 += 4) {
            graphics.drawImage(image, n5, n2, 0);
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    private void drawNotePadRegion(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 8: {
                n6 = 1;
            }
            case 4: {
                n6 = (byte)(n6 + 1);
            }
            case 2: {
                n6 = (byte)(n6 + 1);
            }
            case 1: {
                n4 = 120;
                n5 = ((Image)Battle.m_scratchImage.ro_ref).getHeight();
                n2 = n6 % 2 * 240 >> 1;
                n3 = n6 / 2 * n5 + 109 - 1;
                break;
            }
            case -2147483648: {
                n4 = KCanvas.m_width;
                n5 = 165;
                break;
            }
            case 16384: {
                n2 = 60;
                n4 = 120;
                n3 = 120;
                n5 = KGraphics.textHeight();
                break;
            }
            case 16: {
                n3 = 120;
                n4 = 90;
                n5 = KGraphics.textHeight();
                break;
            }
            case 32: {
                n2 = 111;
                n3 = 119;
                n4 = 19;
                n5 = 20;
                n2 -= 4;
                n4 += 4;
                n5 += 2;
                break;
            }
            case 64: {
                n4 = ((Image)Battle.m_nextImage.ro_ref).getWidth();
                n5 = ((Image)Battle.m_nextImage.ro_ref).getHeight();
                n2 = KCanvas.m_width - n4;
                n3 = 165 - n5;
                break;
            }
            case 128: {
                n4 = 240;
                n5 = 107;
                break;
            }
            case 32768: {
                n2 = 111;
                n3 = 120;
                n4 = 129;
                n5 = 18;
                break;
            }
            case 2048: {
                n6 = 1;
            }
            case 1024: {
                n6 = (byte)(n6 + 1);
            }
            case 512: {
                n6 = (byte)(n6 + 1);
            }
            case 256: {
                n2 = this.meterPositionX[n6] + 2;
                n3 = this.meterPositionY[n6];
                n4 = ((Image)Battle.m_holdMeterImage.ro_ref).getWidth() + 1;
                n5 = ((Image)Battle.m_holdMeterImage.ro_ref).getHeight() + 1;
                ++n4;
                ++n5;
                n2 += 9;
                n3 -= 3;
                break;
            }
            case 4096: {
                n2 = this.lastDisplayX - 26;
                if (n2 < 0) {
                    n2 = 0;
                }
                n4 = 52;
                n5 = (this.m_LinesDisplayArray[this.line][0] << 1) - 1 != this.scrollPos || this.isLeaderLine() && !this.lastHitSucceed || this.mode == 2 ? 29 : 24;
            }
        }
        Utils.drawBackbufferRegion(graphics, n2, n3, n4, n5, n2, n3);
    }

    private void load5man(byte by) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = Utils.getLoadingPercent();
        Graphics graphics = null;
        block7: for (int i = 0; i != -1; ++i) {
            switch (i) {
                case 0: {
                    this.bIntroDrawn = false;
                    graphics = KGraphics.setGraphics(Utils.getBackBufferGraphics());
                    n3 = 90;
                    n6 = 20;
                    n5 = KCanvas.m_width - 40;
                    n2 = m_state == 9 ? KCanvas.m_height - 90 - 8 - 1 : KCanvas.m_height >> 1;
                    Battle.drawAnimRec(Utils.getBackBufferGraphics(), 20, n2, n5, 90, 0xFF0000);
                    n = n5 / 4;
                    AnimInstance animInstance = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant((byte)2), (byte)0, by);
                    n4 = ++n2 - (animInstance.getBottom() - 90);
                    animInstance.draw(n5 += 20, n4, false, false);
                    KGraphics.setGraphics(graphics);
                    Utils.loadingRefresh(n7);
                    continue block7;
                }
                case 1: {
                    KGraphics.setGraphics(Utils.getBackBufferGraphics());
                    AnimInstance animInstance = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.opponentPartner), (byte)0, by);
                    n5 = n * 3 + n6;
                    n4 = n2 - (animInstance.getBottom() - n3);
                    animInstance.draw(n5, n4, false, false);
                    KGraphics.setGraphics(graphics);
                    Utils.loadingRefresh(n7);
                    continue block7;
                }
                case 2: {
                    KGraphics.setGraphics(Utils.getBackBufferGraphics());
                    AnimInstance animInstance = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapperPartner), (byte)0, by);
                    n5 = (n << 1) + n6;
                    n4 = n2 - (animInstance.getBottom() - n3);
                    animInstance.draw(n5, n4, false, false);
                    KGraphics.setGraphics(graphics);
                    Utils.loadingRefresh(n7);
                    continue block7;
                }
                case 3: {
                    KGraphics.setGraphics(Utils.getBackBufferGraphics());
                    AnimInstance animInstance = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.opponent), (byte)0, by);
                    n5 = n + n6;
                    n4 = n2 - (animInstance.getBottom() - n3);
                    animInstance.draw(n5, n4, false, false);
                    KGraphics.setGraphics(graphics);
                    Utils.loadingRefresh(n7);
                    continue block7;
                }
                case 4: {
                    KGraphics.setGraphics(Utils.getBackBufferGraphics());
                    AnimInstance animInstance = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant(this.rapper), (byte)0, by);
                    n5 = n6;
                    n4 = n2 - (animInstance.getBottom() - n3);
                    animInstance.draw(n5, n4, false, false);
                    Utils.getBackBufferGraphics().setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
                    continue block7;
                }
                default: {
                    i = -2;
                }
            }
            if (!Utils.clearKeyIsEnable()) continue;
            return;
        }
    }

    private void load5manDespair() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = KCanvas.m_width - 40;
        ((Battle)object).bIntroDrawn = false;
        Object object = KGraphics.setGraphics(Utils.getBackBufferGraphics());
        n2 = (KCanvas.m_height << 1) / 5;
        n = m_state == 9 ? KCanvas.m_height - n2 - 8 - 1 : n2;
        Battle.drawAnimRec(Utils.getBackBufferGraphics(), 20, n, n6, n2, 0xFF0000);
        KRes kRes = (KRes)HeapManager.instance.get(13313, (byte)1, 0);
        Utils.getBackBufferGraphics().setClip(0, 0, KCanvas.m_width, n + n2);
        n3 = n6 >> 2;
        int n7 = ((Image)kRes.ro_ref).getWidth();
        int n8 = 0;
        for (int i = 0; i < 5; ++i) {
            switch (i) {
                case 0: {
                    n8 = 2;
                    n4 = n3 + 20 + (n3 >> 4) - (n7 >> 1);
                    n5 = n - 6;
                    break;
                }
                case 1: {
                    n8 = 0;
                    n4 = n3 + 20 - n3 * 3 / 5 - (n7 >> 1);
                    n5 = n + 3;
                    break;
                }
                case 2: {
                    n8 = 2;
                    n4 = 20 + n3 * 3 - (n3 << 1) / 7 - (n7 >> 1);
                    n5 = n + 7;
                    break;
                }
                case 3: {
                    n8 = 2;
                    n4 = 20 + n3 * 3 + (n3 << 1) / 3 - (n7 >> 1);
                    n5 = n - 7;
                }
            }
            KGraphics.drawRegion(kRes, 0, 0, n7, ((Image)kRes.ro_ref).getHeight(), n8, n4, n5);
        }
        KGraphics.setGraphics((Graphics)object);
        if (!Utils.loadingRefresh(25)) {
            return;
        }
        KGraphics.setGraphics(Utils.getBackBufferGraphics());
        n4 = 20 + (n6 >> 1);
        n5 = n;
        object = (AnimInstance)HeapManager.instance.get(Battle.getAnimConstant((byte)2), (byte)0, 1);
        if (((AnimInstance)object).getBottom() < n2) {
            n5 += n2 - ((AnimInstance)object).getBottom();
        }
        ((AnimInstance)object).draw(n4, n5, false, false);
        Utils.getBackBufferGraphics().setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
    }

    static {
        TARGET_TEXT_SAMPLE = new char[]{'(', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ')'};
        SPACE_WIDTH = -1;
        TARGET_TEXT_WIDTH = -1;
        m_state = (byte)-1;
        loadTutoPartEnable = false;
        bFiveActivated = true;
        bTutorialMode = false;
        tutorialFoldNotePad = false;
        WORD_SCORE = new int[]{192, 48, 12, 3};
        COLOR_FLASH_TARGET = 1;
        m_ColorsSettings = new int[]{145850, 0x585858};
        bbuf_loadRoundLyrics = null;
        bbuf_getParagraphData2 = null;
        bbufWords_getParagraphData2 = null;
    }
}

