/*
 * Decompiled with CFR 0.152.
 */
package TW2006.renderer;

import TW2006.renderer.tEngine;
import TW2006.renderer.tMath;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tRenderScreen;
import TW2006.renderer.tVertex3D;

public final class tCamera {
    protected int nearClip = 0;
    protected int scalarX = 0;
    protected int scalarY = 0;
    protected int midX = 0;
    protected int midY = 0;
    protected tVertex3D position = new tVertex3D();
    protected int cosH = 0;
    protected int sinH = 0;
    protected int cosP = 0;
    protected int sinP = 0;
    protected int headingDeg = 0;
    protected int pitchingDeg = 0;
    protected boolean ortho = false;
    protected int orthoScale = tEngine.C3D_IntTo3DCoords(200);
    protected int screenXScroll = 0;
    protected int screenYScroll = 0;
    protected int prevScreenXScroll = 0;
    protected int prevScreenYScroll = 0;
    protected int accumScreenXScroll = 0;
    protected int accumScreenYScroll = 0;

    protected final void init(tRenderScreen tRenderScreen2, boolean bl) {
        this.setScreenProp(tRenderScreen2);
        this.nearClip = 16384;
        this.cosH = 256;
        this.sinH = 0;
        this.cosP = 256;
        this.sinP = 0;
        this.headingDeg = 0;
        this.position.x = 0;
        this.position.y = 0;
        this.position.z = 0;
        this.ortho = bl;
    }

    protected final void setScreenProp(tRenderScreen tRenderScreen2) {
        this.midX = tRenderScreen2.width / 2;
        this.midY = tRenderScreen2.height / 2;
        this.scalarX = tRenderScreen2.height;
        this.scalarY = tRenderScreen2.height;
    }

    protected final void setNearClip(int n) {
        this.nearClip = n;
    }

    protected final void setPosition(int n, int n2, int n3) {
        this.position.x = n;
        this.position.y = n2;
        this.position.z = n3;
        if (this.ortho) {
            int n4 = -(this.cosH * n) - this.sinH * n3;
            int n5 = -(this.sinH * n) + this.cosH * n3;
            int n6 = this.orthoScale << 8;
            this.screenXScroll = tMath.MulFraction(n4, this.scalarX, n6) + this.midX;
            this.screenYScroll = tMath.MulFraction(n5, this.scalarY, n6) + this.midY;
        }
    }

    protected final void setRotation(int n, int n2) {
        this.headingDeg = n;
        this.pitchingDeg = n2;
        this.cosH = tMath.COS(n);
        this.sinH = tMath.SIN(n);
        this.cosP = tMath.COS(n2);
        this.sinP = tMath.SIN(n2);
    }

    protected final boolean projectVertex(tVertex3D tVertex3D2, tProjVertex3D tProjVertex3D2) {
        int n = tVertex3D2.z;
        tProjVertex3D2.v.x = tVertex3D2.x;
        tProjVertex3D2.v.y = tVertex3D2.y;
        tProjVertex3D2.v.z = n;
        if (n < this.nearClip) {
            return false;
        }
        if (this.ortho) {
            n = this.orthoScale << 8;
        }
        tProjVertex3D2.s.x = tMath.MulFraction(tVertex3D2.x, this.scalarX, n) + this.midX;
        tProjVertex3D2.s.y = tMath.MulFraction(tVertex3D2.y, this.scalarY, n) + this.midY;
        return true;
    }

    protected final void transformVertex(tVertex3D tVertex3D2, tVertex3D tVertex3D3) {
        int n = tVertex3D2.x - this.position.x;
        int n2 = tVertex3D2.y - this.position.y;
        int n3 = tVertex3D2.z - this.position.z;
        int n4 = this.cosH * n - this.sinH * n3;
        int n5 = -n2;
        int n6 = this.sinH * n + this.cosH * n3;
        tVertex3D3.x = n4;
        tVertex3D3.y = this.cosP * n5 - (this.sinP * n6 >> 8);
        tVertex3D3.z = this.sinP * n5 + (this.cosP * n6 >> 8);
    }

    protected final int getHorizonY() {
        return this.midY - (this.sinP * this.scalarY >> 8);
    }
}

