/*
 * Decompiled with CFR 0.152.
 */
package TW2006.archive;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class tFileMgr {
    static String sArchiveFileName = null;
    private static final int FTEXT_MASK = 1;
    private static final int FHCRC_MASK = 2;
    private static final int FEXTRA_MASK = 4;
    private static final int FNAME_MASK = 8;
    private static final int FCOMMENT_MASK = 16;
    private static final int BTYPE_NONE = 0;
    private static final int BTYPE_FIXED = 1;
    private static final int BTYPE_DYNAMIC = 2;
    private static final int BTYPE_RESERVED = 3;
    private static final int MAX_BITS = 16;
    private static final int MAX_CODE_LITERALS = 287;
    private static final int MAX_CODE_DISTANCES = 31;
    private static final int MAX_CODE_LENGTHS = 18;
    private static final int EOB_CODE = 256;
    private static byte[] buffer;
    private static int buffer_index;
    private static int buffer_byte;
    private static int buffer_bit;
    private static byte[] uncompressed;
    private static int uncompressed_index;
    private static byte[] length_extra_bits;
    private static short[] length_values;
    private static byte[] distance_extra_bits;
    private static short[] distance_values;
    private static byte[] dynamic_length_order;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final InputStream getFileStream(String string) {
        InputStream inputStream = null;
        try {
            int n = tFileMgr.fileExist(string);
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                inputStream = string.getClass().getResourceAsStream("/" + string);
                if (inputStream != null) return new DataInputStream(inputStream);
                throw new RuntimeException("Could not get resource stream.");
            }
            if (n != 2) return null;
            RecordStore recordStore = null;
            try {
                recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
                byte[] byArray = recordStore.getRecord(1);
                byte[] byArray2 = null;
                byArray2 = tFileMgr.isGZData(byArray) ? tFileMgr.inflate(byArray) : byArray;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                return byteArrayInputStream;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            finally {
                try {
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        catch (Exception exception3) {
            System.out.println("<ERROR> Exception caught at getFileStream(): " + exception3.getMessage());
        }
        return null;
    }

    public static final byte[] getFileByteArray(String string) {
        block22: {
            RecordStore recordStore = null;
            InputStream inputStream = null;
            byte[] byArray = null;
            int n = 0;
            try {
                int n2 = tFileMgr.fileExist(string);
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    inputStream = string.getClass().getResourceAsStream("/" + string);
                    if (inputStream == null) {
                        throw new RuntimeException("Could not get resource stream.");
                    }
                    while (inputStream.read() != -1) {
                        ++n;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Could not close input stream after size computation.");
                    }
                    inputStream = string.getClass().getResourceAsStream("/" + string);
                    if (inputStream == null) {
                        throw new RuntimeException("Could not get resource stream.");
                    }
                    byArray = new byte[n];
                    tFileMgr.readData(inputStream, 0, byArray, 0, n);
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Could not close input stream after size computation.");
                    }
                    return byArray;
                }
                if (n2 != 2) break block22;
                try {
                    recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
                    byArray = recordStore.getRecord(1);
                    if (tFileMgr.isGZData(byArray)) {
                        byArray = tFileMgr.inflate(byArray);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                finally {
                    try {
                        if (recordStore != null) {
                            recordStore.closeRecordStore();
                        }
                    }
                    catch (Exception exception) {}
                }
                return byArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static final int readData(InputStream inputStream, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (byArray.length - n2 < n3) {
            throw new RuntimeException("Data array size is too small.");
        }
        try {
            for (int i = 0; i < n; ++i) {
                if (-1 != inputStream.read()) continue;
                throw new RuntimeException("EOF reached before requested source offset");
            }
            while ((n4 = inputStream.read(byArray, n2 + n5, n3 - n5)) != -1 && (n5 += n4) < n3) {
            }
            if (n5 < n3) {
                throw new RuntimeException("EOF reached before requested amount of data is read in.");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading input stream.");
        }
        if (n4 == -1) {
            return n4;
        }
        return n5;
    }

    public static final int fileExist(String string) {
        InputStream inputStream = string.getClass().getResourceAsStream("/" + string);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        }
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            int n = 2;
            return n;
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getClass().toString() + exception.getMessage());
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final int deleteFile(String string) {
        byte[] byArray = null;
        RecordStore recordStore = null;
        int n = 0;
        try {
            if (tFileMgr.fileExist(string) != 2) {
                int n2 = 0;
                return n2;
            }
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            byArray = recordStore.getRecord(1);
            if (byArray == null || byArray.length < 1) {
                recordStore.closeRecordStore();
                recordStore = null;
                RecordStore.deleteRecordStore((String)string);
                int n3 = 1;
                return n3;
            }
            if ((char)byArray[1] == 'A' && (char)byArray[2] == 'R' && (char)byArray[3] == 'C' && (char)byArray[4] == 'V') {
                int n4 = 0;
                int n5 = byArray[n4++] & 0xFF;
                n4 += 4;
                for (int i = 0; i < n5; ++i) {
                    int n6 = byArray[n4] & 0xFF;
                    String string2 = new String(byArray, ++n4, n6);
                    n += tFileMgr.deleteFile(string2);
                    n4 += n6;
                }
                recordStore.closeRecordStore();
                recordStore = null;
                RecordStore.deleteRecordStore((String)string);
                ++n;
            } else {
                recordStore.closeRecordStore();
                recordStore = null;
                RecordStore.deleteRecordStore((String)string);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getClass().toString() + exception.getMessage());
        }
        finally {
            byArray = null;
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
                recordStore = null;
            }
            System.gc();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int saveFileFromStream(String string, InputStream inputStream) {
        int n;
        block36: {
            byte[] byArray = null;
            byte[] byArray2 = new byte[20];
            Object var4_4 = null;
            n = 0;
            try {
                if (string == null || inputStream == null) {
                    throw new IllegalArgumentException("<ERROR> Null argument detected.");
                }
                if (tFileMgr.fileExist(string) != 0) {
                    int n2 = 0;
                    return n2;
                }
                System.gc();
                tFileMgr.readData(inputStream, 0, byArray2, 0, 4);
                if ((char)byArray2[0] == 'A' && (char)byArray2[1] == 'R' && (char)byArray2[2] == 'C' && (char)byArray2[3] == 'V') {
                    sArchiveFileName = string;
                    tFileMgr.readData(inputStream, 0, byArray2, 0, 4);
                    int n3 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8 | (byArray2[2] & 0xFF) << 16 | (byArray2[3] & 0xFF) << 24;
                    if (n3 <= 0) {
                        throw new RuntimeException("<ERROR> Invalid entry count.");
                    }
                    Vector<String> vector = new Vector<String>(n3 + 1);
                    String[] stringArray = new String[n3];
                    int[] nArray = new int[n3];
                    int[] nArray2 = new int[n3];
                    try {
                        int n4;
                        int n5;
                        for (n5 = 0; n5 < n3; ++n5) {
                            tFileMgr.readData(inputStream, 0, byArray2, 0, 20);
                            String string2 = new String(byArray2);
                            stringArray[n5] = string2.trim();
                            if (stringArray[n5].endsWith(".crs")) {
                                stringArray[n5] = sArchiveFileName + ".crs";
                            }
                            tFileMgr.readData(inputStream, 0, byArray2, 0, 12);
                            nArray[n5] = (byArray2[7] & 0xFF) << 24 | (byArray2[6] & 0xFF) << 16 | (byArray2[5] & 0xFF) << 8 | byArray2[4] & 0xFF;
                            nArray2[n5] = (byArray2[11] & 0xFF) << 24 | (byArray2[10] & 0xFF) << 16 | (byArray2[9] & 0xFF) << 8 | byArray2[8] & 0xFF;
                        }
                        n5 = 8 + 32 * n3;
                        for (n4 = 0; n4 < n3; ++n4) {
                            byArray2 = new byte[nArray[n4] + 1];
                            byArray2[nArray[n4]] = 0;
                            tFileMgr.readData(inputStream, 0, byArray2, 0, nArray[n4]);
                            n5 += nArray[n4];
                            if ((char)byArray2[0] == 'A' && (char)byArray2[1] == 'R' && (char)byArray2[2] == 'C' && (char)byArray2[3] == 'V') {
                                byArray2 = null;
                                System.gc();
                                continue;
                            }
                            if (tFileMgr.saveFileFromBuffer(stringArray[n4], byArray2, 0, nArray[n4]) > 0) {
                                vector.addElement(stringArray[n4]);
                            }
                            byArray2 = null;
                            System.gc();
                        }
                        n4 = 0;
                        byArray = new byte[5 + vector.size() * 20 + vector.size()];
                        byArray[n4++] = (byte)vector.size();
                        byArray[n4++] = 65;
                        byArray[n4++] = 82;
                        byArray[n4++] = 67;
                        byArray[n4++] = 86;
                        for (int i = 0; i < vector.size(); ++i) {
                            byArray[n4] = (byte)((String)vector.elementAt(i)).length();
                            System.arraycopy(((String)vector.elementAt(i)).getBytes(), 0, byArray, ++n4, byArray[n4 - 1] & 0xFF);
                            n4 += byArray[n4 - 1] & 0xFF;
                        }
                        if (tFileMgr.saveFileFromBuffer(string, byArray, 0, n4) != 1) {
                            throw new RuntimeException("Failed to save archive record into RMS.");
                        }
                        vector.addElement(string);
                    }
                    catch (Exception exception) {
                        for (int i = 0; i < vector.size(); ++i) {
                            RecordStore.deleteRecordStore((String)((String)vector.elementAt(i)));
                        }
                        throw new RuntimeException(exception.getMessage());
                    }
                    n = vector.size();
                    break block36;
                }
                int n6 = 0;
                return n6;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (var4_4 != null) {
                    try {
                        var4_4.closeRecordStore();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    var4_4 = null;
                    try {
                        RecordStore.deleteRecordStore((String)string);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                n = -1;
            }
            finally {
                sArchiveFileName = null;
                byArray2 = null;
                byArray = null;
                if (var4_4 != null) {
                    try {
                        var4_4.closeRecordStore();
                    }
                    catch (Exception exception) {}
                    var4_4 = null;
                }
                System.gc();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int saveFileFromBuffer(String string, byte[] byArray, int n, int n2) {
        Object var4_4 = null;
        RecordStore recordStore = null;
        int n3 = 0;
        try {
            if (string == null || byArray == null || n2 < 0 || n + n2 > byArray.length) {
                throw new IllegalArgumentException("<ERROR> Illegal argument detected.");
            }
            if (tFileMgr.fileExist(string) != 0) {
                int n4 = 0;
                return n4;
            }
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getSizeAvailable() < n2) {
                throw new RuntimeException("<ERROR> Not enough memory in RMS to complete save file: " + string);
            }
            int n5 = recordStore.addRecord(byArray, n, n2);
            n3 = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                recordStore = null;
                try {
                    RecordStore.deleteRecordStore((String)string);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            n3 = -1;
        }
        finally {
            var4_4 = null;
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
                recordStore = null;
            }
            System.gc();
        }
        return n3;
    }

    public static final boolean isGZData(byte[] byArray) {
        return (byArray[2] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[0] & 0xFF) << 16) == 2067208;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] inflate(byte[] byArray) throws IOException {
        try {
            buffer = byArray;
            if (tFileMgr.readBits(16) != 35615 || tFileMgr.readBits(8) != 8) {
                throw new IOException("Invalid GZIP format");
            }
            int n = tFileMgr.readBits(8);
            buffer_index += 6;
            if ((n & 4) != 0) {
                buffer_index += tFileMgr.readBits(16);
            }
            if ((n & 8) != 0) {
                while (buffer[buffer_index++] != 0) {
                }
            }
            if ((n & 0x10) != 0) {
                while (buffer[buffer_index++] != 0) {
                }
            }
            if ((n & 2) != 0) {
                buffer_index += 2;
            }
            int n2 = buffer_index;
            buffer_index = buffer.length - 4;
            uncompressed = new byte[tFileMgr.readBits(16) | tFileMgr.readBits(16) << 16];
            buffer_index = n2;
            length_extra_bits = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99};
            length_values = new short[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
            distance_extra_bits = new byte[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
            distance_values = new short[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
            dynamic_length_order = new byte[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
            int n3 = 0;
            int n4 = 0;
            do {
                n3 = tFileMgr.readBits(1);
                n4 = tFileMgr.readBits(2);
                if (n4 == 0) {
                    tFileMgr.inflateStored();
                    continue;
                }
                if (n4 == 1) {
                    tFileMgr.inflateFixed();
                    continue;
                }
                if (n4 == 2) {
                    tFileMgr.inflateDynamic();
                    continue;
                }
                throw new IOException("Invalid GZIP block");
            } while (n3 == 0);
            byte[] byArray2 = uncompressed;
            return byArray2;
        }
        finally {
            uncompressed_index = 0;
            buffer_bit = 0;
            buffer_byte = 0;
            buffer_index = 0;
            dynamic_length_order = null;
            distance_extra_bits = null;
            length_extra_bits = null;
            uncompressed = null;
            buffer = null;
            distance_values = null;
            length_values = null;
        }
    }

    private static final void inflateStored() {
        buffer_bit = 0;
        int n = tFileMgr.readBits(16);
        int n2 = tFileMgr.readBits(16);
        System.arraycopy(buffer, buffer_index, uncompressed, uncompressed_index, n);
        buffer_index += n;
        uncompressed_index += n;
    }

    private static final void inflateFixed() {
        int n;
        byte[] byArray = new byte[288];
        for (n = 0; n < 144; ++n) {
            byArray[n] = 8;
        }
        for (n = 144; n < 256; ++n) {
            byArray[n] = 9;
        }
        for (n = 256; n < 280; ++n) {
            byArray[n] = 7;
        }
        for (n = 280; n < 288; ++n) {
            byArray[n] = 8;
        }
        int[] nArray = tFileMgr.createHuffmanTree(byArray, 287);
        byte[] byArray2 = new byte[32];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = 5;
        }
        int[] nArray2 = tFileMgr.createHuffmanTree(byArray2, 31);
        tFileMgr.inflateBlock(nArray, nArray2);
    }

    private static final void inflateDynamic() {
        int n = tFileMgr.readBits(5) + 257;
        int n2 = tFileMgr.readBits(5) + 1;
        int n3 = tFileMgr.readBits(4) + 4;
        byte[] byArray = new byte[19];
        for (int i = 0; i < n3; ++i) {
            byArray[tFileMgr.dynamic_length_order[i]] = (byte)tFileMgr.readBits(3);
        }
        int[] nArray = tFileMgr.createHuffmanTree(byArray, 18);
        byte[] byArray2 = tFileMgr.decodeCodeLengths(nArray, n);
        int[] nArray2 = tFileMgr.createHuffmanTree(byArray2, n - 1);
        byte[] byArray3 = tFileMgr.decodeCodeLengths(nArray, n2);
        int[] nArray3 = tFileMgr.createHuffmanTree(byArray3, n2 - 1);
        tFileMgr.inflateBlock(nArray2, nArray3);
    }

    private static final void inflateBlock(int[] nArray, int[] nArray2) {
        int n = 0;
        byte by = 0;
        byte by2 = 0;
        while ((n = tFileMgr.readCode(nArray)) != 256) {
            if (n > 256) {
                int n2 = length_values[n -= 257];
                by = length_extra_bits[n];
                if (by > 0) {
                    n2 += tFileMgr.readBits(by);
                }
                n = tFileMgr.readCode(nArray2);
                int n3 = distance_values[n];
                by2 = distance_extra_bits[n];
                if (by2 > 0) {
                    n3 += tFileMgr.readBits(by2);
                }
                int n4 = uncompressed_index - n3;
                for (int i = 0; i < n2; ++i) {
                    tFileMgr.uncompressed[tFileMgr.uncompressed_index++] = uncompressed[n4 + i];
                }
                continue;
            }
            tFileMgr.uncompressed[tFileMgr.uncompressed_index++] = (byte)n;
        }
    }

    private static final int readBits(int n) {
        int n2 = buffer_bit == 0 ? (buffer_byte = buffer[buffer_index++] & 0xFF) : buffer_byte >> buffer_bit;
        for (int i = 8 - buffer_bit; i < n; i += 8) {
            buffer_byte = buffer[buffer_index++] & 0xFF;
            n2 |= buffer_byte << i;
        }
        buffer_bit = buffer_bit + n & 7;
        return n2 & (1 << n) - 1;
    }

    private static int readCode(int[] nArray) {
        int n = nArray[0];
        while (n >= 0) {
            if (buffer_bit == 0) {
                buffer_byte = buffer[buffer_index++] & 0xFF;
            }
            n = (buffer_byte & 1 << buffer_bit) == 0 ? nArray[n >> 16] : nArray[n & 0xFFFF];
            buffer_bit = buffer_bit + 1 & 7;
        }
        return n & 0xFFFF;
    }

    private static final int[] createHuffmanTree(byte[] byArray, int n) {
        int n2;
        int[] nArray = new int[17];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byte by = byArray[n2];
            nArray[by] = nArray[by] + 1;
        }
        n2 = 0;
        nArray[0] = 0;
        int[] nArray2 = new int[17];
        for (int i = 1; i <= 16; ++i) {
            nArray2[i] = n2 = n2 + nArray[i - 1] << 1;
        }
        int[] nArray3 = new int[(n << 1) + 16];
        int n3 = 1;
        for (int i = 0; i <= n; ++i) {
            byte by = byArray[i];
            if (by == 0) continue;
            byte by2 = by;
            nArray2[by2] = nArray2[by2] + 1;
            int n4 = 0;
            for (int j = by - 1; j >= 0; --j) {
                int n5;
                int n6 = n2 & 1 << j;
                if (n6 == 0) {
                    n5 = nArray3[n4] >> 16;
                    if (n5 == 0) {
                        int n7 = n4;
                        nArray3[n7] = nArray3[n7] | n3 << 16;
                        n4 = n3++;
                        continue;
                    }
                    n4 = n5;
                    continue;
                }
                n5 = nArray3[n4] & 0xFFFF;
                if (n5 == 0) {
                    int n8 = n4;
                    nArray3[n8] = nArray3[n8] | n3;
                    n4 = n3++;
                    continue;
                }
                n4 = n5;
            }
            nArray3[n4] = i | Integer.MIN_VALUE;
        }
        return nArray3;
    }

    private static final byte[] decodeCodeLengths(int[] nArray, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            n3 = tFileMgr.readCode(nArray);
            if (n3 >= 16) {
                int n5 = 0;
                if (n3 == 16) {
                    n5 = 3 + tFileMgr.readBits(2);
                    n3 = n4;
                } else {
                    n5 = n3 == 17 ? 3 + tFileMgr.readBits(3) : 11 + tFileMgr.readBits(7);
                    n3 = 0;
                }
                while (n5-- > 0) {
                    byArray[n2++] = (byte)n3;
                }
            } else if (n3 != 0) {
                byArray[n2++] = (byte)n3;
            } else {
                ++n2;
            }
            n4 = n3;
        }
        return byArray;
    }
}

