/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;
import com.ea.sdk.SDKImpl;

public class SDKString {
    public static final int CHAR_ENCODING_UTF16BE = 0;
    public static final int CHAR_ENCODING_ASCII = 1;
    public byte[] mPtr;
    public int mOff;
    public int mLen;
    public int mCap;
    public byte mEncoding;
    public byte[] mAppendBuf;
    public SDKString[] mReplBuf;

    public SDKString() {
    }

    public SDKString(String string) {
        int n;
        this.mOff = 0;
        this.mCap = this.mLen = string.length();
        this.mEncoding = (byte)65;
        this.mPtr = new byte[this.mCap];
        for (n = 0; n < this.mPtr.length; ++n) {
            this.mPtr[n] = 0;
        }
        for (n = 0; n < this.mLen; ++n) {
            this.mPtr[n] = (byte)string.charAt(n);
        }
    }

    public SDKString(int n) {
        this.mEncoding = (byte)65;
        this.mOff = 0;
        this.mPtr = SDKImpl.getInstance().itoa(n);
        this.mCap = this.mLen = StringUtils.StringLen(StringUtils.ToRawString(StringUtils.CreateString(new String(this.mPtr))));
    }

    public SDKString(int n, int n2) {
        this.mEncoding = (byte)(n2 | 0x80 | 0x40);
        this.mPtr = new byte[n2 == 0 ? n << 1 : n];
        this.mCap = n;
        this.mOff = 0;
        this.mLen = 0;
    }

    public SDKString(char[] cArray, int n, int n2) {
        int n3;
        this.mOff = 0;
        this.mLen = n2;
        this.mCap = 2 * this.mLen;
        this.mEncoding = (byte)64;
        this.mPtr = new byte[this.mCap];
        for (n3 = 0; n3 < this.mPtr.length; ++n3) {
            this.mPtr[n3] = 0;
        }
        for (n3 = n; n3 < n2; ++n3) {
            int n4 = n3 << 1;
            this.mPtr[n4] = (byte)(cArray[n3] >> 8);
            this.mPtr[n4 + 1] = (byte)cArray[n3];
        }
    }

    public SDKString(FlString flString) {
        int n;
        String string = new String(StringUtils.CreateJavaString(flString));
        this.mOff = 0;
        this.mCap = this.mLen = string.length();
        this.mEncoding = (byte)65;
        this.mPtr = new byte[this.mCap];
        for (n = 0; n < this.mPtr.length; ++n) {
            this.mPtr[n] = 0;
        }
        for (n = 0; n < this.mLen; ++n) {
            this.mPtr[n] = (byte)string.charAt(n);
        }
    }

    public void destruct() {
        if (this.mPtr != null && (this.mEncoding & 0x40) != 0) {
            this.mPtr = null;
            this.mPtr = null;
        }
        if (this.mAppendBuf != null) {
            this.mAppendBuf = null;
            this.mAppendBuf = null;
        }
        if (this.mReplBuf != null) {
            this.mReplBuf = null;
            this.mReplBuf = null;
        }
    }

    public boolean isMutable() {
        return (this.mEncoding & 0x80) != 0;
    }

    public SDKString append(SDKString sDKString) {
        if (!this.isMutable()) {
            return this;
        }
        byte by = (byte)this.getEncoding();
        byte by2 = (byte)sDKString.getEncoding();
        if (by2 != by && by2 != 1 && by != 0) {
            return this;
        }
        int n = this.mOff + (by == 0 ? this.mLen << 1 : this.mLen);
        SDKImpl.getInstance().convertBytes(sDKString.mPtr, sDKString.mOff, this.mPtr, n, (short)sDKString.mLen, by2, by);
        this.mLen += sDKString.mLen;
        return this;
    }

    public SDKString append(String string) {
        if (!this.isMutable()) {
            return this;
        }
        int n = string.length();
        int n2 = this.mLen;
        this.mLen += n;
        for (int i = 0; i < n; ++i) {
            this.setCharAt(n2 + i, string.charAt(i));
        }
        return this;
    }

    public SDKString append(int n) {
        short s;
        if (!this.isMutable()) {
            return this;
        }
        if (this.mAppendBuf == null) {
            this.mAppendBuf = new byte[11];
        }
        short s2 = 10;
        long l = n;
        if (n < 0) {
            l = -l;
        }
        for (s = 10; s >= 0; --s) {
            this.mAppendBuf[s] = (byte)(l % 10L | 0x30L);
            l /= 10L;
            if (this.mAppendBuf[s] == 48) continue;
            s2 = s;
        }
        if (n < 0) {
            this.mAppendBuf[--s2] = 45;
        }
        s = (short)(11 - s2);
        byte by = (byte)this.getEncoding();
        int n2 = this.mOff + (by == 0 ? this.mLen << 1 : this.mLen);
        SDKImpl.getInstance().convertBytes(this.mAppendBuf, s2, this.mPtr, n2, s, 1, by);
        this.mLen += s;
        return this;
    }

    public void setCharAt(int n, char c) {
        if (!this.isMutable()) {
            return;
        }
        byte by = (byte)this.getEncoding();
        short s = (short)c;
        if (s > 127 && by != 0) {
            s = SDKImpl.getInstance().utf2iso(s);
        }
        int n2 = this.mOff + (by == 0 ? n << 1 : n);
        if (by == 0) {
            this.mPtr[n2++] = (byte)(s >> 8);
        }
        this.mPtr[n2] = (byte)s;
    }

    public char charAt(int n) {
        short s = this.charCodeAt(n);
        if (s > 127 && this.getEncoding() != 0) {
            return (char)SDKImpl.getInstance().iso2utf(s);
        }
        return (char)s;
    }

    public short charCodeAt(int n) {
        if ((this.mEncoding & 0x3F) == 0) {
            int n2 = this.mOff + (n << 1);
            return (short)((this.mPtr[n2] & 0xFF) << 8 | this.mPtr[n2 + 1] & 0xFF);
        }
        return (short)(this.mPtr[this.mOff + n] & 0xFF);
    }

    public SDKString replace(SDKString[] sDKStringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        SDKString sDKString = new SDKString();
        sDKString.mEncoding = (byte)this.getEncoding();
        sDKString.mOff = 0;
        int n5 = 0;
        for (n4 = 0; n4 < this.mLen; ++n4) {
            n3 = this.charCodeAt(n4);
            if (n3 != 92 || ++n4 >= this.mLen) continue;
            n2 = this.charCodeAt(n4);
            if (n2 == 92) {
                --n5;
                continue;
            }
            if (n2 < 48 || n2 > 90) continue;
            n = n2 - 48;
            if (sDKStringArray[n].getEncoding() != sDKString.mEncoding && sDKStringArray[n].getEncoding() != 1) {
                sDKString.mEncoding = 0;
            }
            n5 += sDKStringArray[n].mLen - 2;
        }
        sDKString.mEncoding = (byte)(sDKString.mEncoding | 0x40);
        sDKString.mCap = sDKString.mLen = (int)((short)(this.mLen + n5));
        sDKString.mPtr = new byte[sDKString.getEncoding() == 0 ? sDKString.mLen << 1 : sDKString.mLen];
        n4 = 0;
        n3 = 0;
        n2 = this.getEncoding() == 0 ? 2 : 1;
        for (n = 0; n < this.mLen; ++n) {
            short s = this.charCodeAt(n);
            if (s != 92) continue;
            short s2 = (short)(n - n3);
            n4 += SDKImpl.getInstance().convertBytes(this.mPtr, this.mOff + n3 * n2, sDKString.mPtr, n4, s2, this.getEncoding(), sDKString.getEncoding());
            n3 = n++;
            if (n >= this.mLen) continue;
            short s3 = this.charCodeAt(n);
            if (s3 == 92) {
                n3 = n;
                continue;
            }
            if (s3 < 48 || s3 > 90) continue;
            int n6 = s3 - 48;
            n4 += SDKImpl.getInstance().convertBytes(sDKStringArray[n6].mPtr, sDKStringArray[n6].mOff, sDKString.mPtr, n4, (short)sDKStringArray[n6].mLen, sDKStringArray[n6].getEncoding(), sDKString.getEncoding());
            n3 = n + 1;
        }
        SDKImpl.getInstance().convertBytes(this.mPtr, this.mOff + n3 * n2, sDKString.mPtr, n4, (short)(this.mLen - n3), this.getEncoding(), sDKString.getEncoding());
        return sDKString;
    }

    public SDKString replaceFirst(SDKString sDKString) {
        if (this.mReplBuf == null) {
            this.mReplBuf = new SDKString[1];
        }
        this.mReplBuf[0] = sDKString;
        return this.replace(this.mReplBuf);
    }

    public SDKString replaceFirst(String string) {
        SDKString sDKString = null;
        if (this.mReplBuf == null) {
            this.mReplBuf = new SDKString[1];
        }
        this.mReplBuf[0] = new SDKString(string);
        sDKString = this.replace(this.mReplBuf);
        this.mReplBuf[0] = null;
        return sDKString;
    }

    public SDKString replaceFirst(int n) {
        SDKString sDKString = null;
        if (this.mReplBuf == null) {
            this.mReplBuf = new SDKString[1];
        }
        this.mReplBuf[0] = new SDKString(n);
        sDKString = this.replace(this.mReplBuf);
        this.mReplBuf[0] = null;
        return sDKString;
    }

    public SDKString concat(SDKString sDKString) {
        byte by = (byte)this.getEncoding();
        byte by2 = (byte)sDKString.getEncoding();
        SDKString sDKString2 = new SDKString();
        sDKString2.mCap = sDKString2.mLen = this.mLen + sDKString.mLen;
        sDKString2.mOff = 0;
        sDKString2.mEncoding = by == by2 || by2 == 1 ? by : (byte)0;
        sDKString2.mPtr = new byte[sDKString2.mEncoding == 0 ? sDKString2.mLen << 1 : sDKString2.mLen];
        int n = SDKImpl.getInstance().convertBytes(this.mPtr, this.mOff, sDKString2.mPtr, 0, (short)this.mLen, by, sDKString2.mEncoding);
        SDKImpl.getInstance().convertBytes(sDKString.mPtr, sDKString.mOff, sDKString2.mPtr, n, (short)sDKString.mLen, by2, sDKString2.mEncoding);
        sDKString2.mEncoding = (byte)(sDKString2.mEncoding | 0x40);
        return sDKString2;
    }

    public SDKString concat(String string) {
        SDKString sDKString = new SDKString(string);
        SDKString sDKString2 = this.concat(sDKString);
        sDKString = null;
        return sDKString2;
    }

    public SDKString concat(int n) {
        SDKString sDKString = new SDKString(n);
        SDKString sDKString2 = this.concat(sDKString);
        sDKString = null;
        return sDKString2;
    }

    public int length() {
        return this.mLen;
    }

    public int capacity() {
        return this.mCap;
    }

    public int getEncoding() {
        return this.mEncoding & 0x3F;
    }

    public SDKString substring(int n, int n2) {
        SDKString sDKString = new SDKString();
        sDKString.mEncoding = (byte)this.getEncoding();
        sDKString.mCap = sDKString.mLen = n2 - n;
        int n3 = sDKString.mEncoding == 0 ? 2 : 1;
        sDKString.mOff = this.mOff + n * n3;
        sDKString.mPtr = this.mPtr;
        return sDKString;
    }

    public void setLength(int n) {
        if (!this.isMutable()) {
            return;
        }
        this.mLen = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.mLen);
        for (int i = 0; i < this.mLen; ++i) {
            stringBuffer.append(this.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void ToFlightString(FlString flString) {
        String string = new String(this.toString());
        flString.Assign(StringUtils.ToRawString(StringUtils.CreateString(new String(string))));
        string = null;
    }

    public SDKString toSDKString() {
        SDKString sDKString = new SDKString("");
        return this.concat(sDKString);
    }

    public SDKString trim() {
        int n;
        int n2 = n = this.getEncoding() == 0 ? 2 : 1;
        while (this.mLen > 0 && this.charCodeAt(0) == 32) {
            this.mOff += n;
            --this.mLen;
        }
        while (this.mLen > 0 && this.charCodeAt(this.mLen - 1) == 32) {
            --this.mLen;
        }
        return this;
    }

    public int indexOf(SDKString sDKString, int n) {
        for (int i = n; i < this.mLen; ++i) {
            for (int j = 0; j < sDKString.length() && this.charCodeAt(i + j) == sDKString.charCodeAt(j); ++j) {
                if (j != sDKString.length() - 1) continue;
                return i;
            }
        }
        return -1;
    }

    public int compareTo(SDKString sDKString) {
        for (int i = 0; i < (this.mLen < sDKString.mLen ? this.mLen : sDKString.mLen); ++i) {
            if (this.charCodeAt(i) == sDKString.charCodeAt(i)) continue;
            return this.charCodeAt(i) - sDKString.charCodeAt(i);
        }
        if (this.mLen != sDKString.mLen) {
            return this.mLen - sDKString.mLen;
        }
        return 0;
    }

    public static SDKString[] InstArraySDKString(int n) {
        SDKString[] sDKStringArray = new SDKString[n];
        for (int i = 0; i < n; ++i) {
            sDKStringArray[i] = new SDKString();
        }
        return sDKStringArray;
    }

    public static SDKString[][] InstArraySDKString(int n, int n2) {
        SDKString[][] sDKStringArray = new SDKString[n][];
        for (int i = 0; i < n; ++i) {
            sDKStringArray[i] = new SDKString[n2];
            for (int j = 0; j < n2; ++j) {
                sDKStringArray[i][j] = new SDKString();
            }
        }
        return sDKStringArray;
    }

    public static SDKString[][][] InstArraySDKString(int n, int n2, int n3) {
        SDKString[][][] sDKStringArray = new SDKString[n][][];
        for (int i = 0; i < n; ++i) {
            sDKStringArray[i] = new SDKString[n2][];
            for (int j = 0; j < n2; ++j) {
                sDKStringArray[i][j] = new SDKString[n3];
                for (int k = 0; k < n3; ++k) {
                    sDKStringArray[i][j][k] = new SDKString();
                }
            }
        }
        return sDKStringArray;
    }
}

