/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.Memory;
import com.ea.sdk.GameApp;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKDebug;
import com.ea.sdk.SDKFont;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKUtils;
import java.io.IOException;
import java.io.InputStream;

public class SDKImpl
implements SDKDebug {
    public byte[] mItoaBuf;
    public byte[] mLanguageEncodings;
    public byte[][] mLanguageIsocodes;
    public short[] mNumStringsPerChunk;
    public byte[] mChunkFlags;
    public byte[] mChunkGroup;
    public short[][] mChunkSize;
    public short[] mGroupMaxSize;
    public byte[] mGroupMap;
    public byte[][] mChunkStringData;
    public short[][] mChunkStringOffsets;
    public byte mChunkConfig;
    public byte mNumActualChunks;
    public byte mNumStorageChunks;
    public short[] mGroupMaxNumOffsets;
    public byte[] mLanguageFontDifferentiator;
    public byte mLangIndex = 0;
    public byte mNumLangs;
    public short[] mCharMapISO = new short[128];
    public int mTextEncodings;
    public short[] mWrapOffsets;
    public int mWrapOffsetsLen;
    public SDKGraphics mGraphics;
    public int[] mCurrPenPoint = null;
    public int[] mCurrPenTerms = null;
    public StringBuffer mDrawStringBuff;
    public SDKFont mSdkFont = new SDKFont();
    public boolean mHdrLoaded;
    public boolean mForceChunkLoad;
    public int mDataFileCount;
    public int mBytesPerOffset;
    public int mExtraLocalizationsCount;
    public int[] mLastResourceIDs;
    public int[][] mDataFileSizes;
    public int mResCount;
    public boolean[][] mLocaleFlags;
    public int[] mDefaultOffsets;
    public int[][] mSuppOffsets;
    public int mCurrLocale;
    public boolean mIndexLoaded;
    public SDKSoundManager mSoundManager;
    public int mImgType = 4;
    public static byte[] PLTE = new byte[]{80, 76, 84, 69};

    public SDKImpl() {
        this.mCurrPenPoint = new int[2];
        this.mCurrPenTerms = new int[4];
    }

    public void destruct() {
        if (this.mHdrLoaded) {
            this.freeTextUtilsData();
        }
        if (this.mSoundManager != null) {
            this.freeSoundManager();
        }
        if (this.mItoaBuf != null) {
            this.mItoaBuf = null;
        }
    }

    public static SDKImpl getInstance() {
        return GameApp.Get().mSDKImpl;
    }

    public byte[] itoa(int n) {
        int n2;
        if (this.mItoaBuf == null) {
            this.mItoaBuf = new byte[11];
        }
        int n3 = 10;
        int n4 = n;
        if (n < 0) {
            n4 = -n4;
        }
        for (n2 = 10; n2 >= 0; --n2) {
            this.mItoaBuf[n2] = (byte)(n4 % 10 | 0x30);
            n4 /= 10;
            if (this.mItoaBuf[n2] == 48) continue;
            n3 = n2;
        }
        if (n < 0) {
            this.mItoaBuf[--n3] = 45;
        }
        n2 = (short)(11 - n3);
        byte[] byArray = new byte[n2 + 1];
        Memory.Copy(byArray, 0, this.mItoaBuf, n3, n2);
        byArray[n2] = 0;
        return byArray;
    }

    public int convertBytes(byte[] byArray, int n, byte[] byArray2, int n2, short n3, int n4, int n5) {
        int n6;
        int n7 = n6 = n5 == 0 ? n3 << 1 : n3;
        if (n4 == n5 || n4 == 1 && n5 != 0) {
            Memory.Copy(byArray2, n2, byArray, n, n6);
        } else {
            for (int i = n; i < n + n3; ++i) {
                short s = (short)(byArray[i] & 0xFF);
                if (s > 127) {
                    s = this.iso2utf(s);
                }
                byArray2[n2++] = (byte)(s >> 8);
                byArray2[n2++] = (byte)s;
            }
        }
        return n6;
    }

    public short iso2utf(short s) {
        return this.mCharMapISO[s - 128];
    }

    public short utf2iso(short s) {
        int n = this.getCodePos(this.mCharMapISO, s, 0, 127, 128);
        return (short)(n + 128);
    }

    public int getCharAdvance(short s) {
        int n = this.mSdkFont.mProps[6] & 0xFF;
        if (s == -1) {
            return (this.mSdkFont.mProps[5] & 0xFF) + n;
        }
        return (this.mSdkFont.mCharAndGlyphData[s & 0xFFFF] & 0xFF) + n;
    }

    public short getCharOffset(short s, int n) {
        int n2 = this.mSdkFont.mUTFCodes.length;
        if (n == 0) {
            return this.mSdkFont.mCharOffsets[this.getCodePos(this.mSdkFont.mUTFCodes, s, 0, n2 - 1, n2)];
        }
        if (s < 128 || n == this.mLanguageEncodings[this.mLangIndex]) {
            return this.mSdkFont.mCharOffsets[this.mSdkFont.mISOOffsetMap[s] & 0xFFFF];
        }
        return -1;
    }

    public void advance(int[] nArray, int n) {
        byte by = this.mSdkFont.mProps[8];
        if (by == 1) {
            nArray[0] = nArray[0] + n;
        } else if (by == 4) {
            nArray[0] = nArray[0] - n;
        } else if (by == 2) {
            nArray[1] = nArray[1] + n;
        } else if (by == 8) {
            nArray[1] = nArray[1] - n;
        }
    }

    public void loadCharMap(byte s) {
        block5: {
            int n = 0;
            for (short s2 = 1; s2 < s; s2 = (short)(s2 + 1)) {
                if ((this.mTextEncodings & 1 << s2) == 0) continue;
                ++n;
            }
            byte[] byArray = new byte[2];
            InputStream inputStream = null;
            try {
                inputStream = "".getClass().getResourceAsStream("/charmap");
                SDKUtils.skipNative(inputStream, n << 8);
                for (int i = 0; i < 128; ++i) {
                    byArray[0] = (byte)inputStream.read();
                    byArray[1] = (byte)inputStream.read();
                    this.mCharMapISO[i] = this.bytesToShort(byArray, 0);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                if (!SDKConfig.getDebugEnabled()) break block5;
                SDKUtils.debugLog("SDKImpl.loadCharMap.IOException, e.msg: " + iOException.getMessage(), 4);
            }
        }
        if (this.mSdkFont.mFontData != null && (this.mSdkFont.mProps[10] & 4) == 0 && (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport())) {
            this.refreshISOOffsets();
        }
    }

    public Object[] loadFontChunk(byte[] byArray) {
        short s;
        int n;
        boolean bl;
        int n2 = 0;
        byte by = byArray[n2++];
        if (SDKConfig.getDebugEnabled() && (by & 0x3F) != 33) {
            SDKUtils.debugLog("SDKImpl.loadFontChunk.unsupported font version:" + by, 4);
        }
        boolean bl2 = (by & 0x80) != 0;
        boolean bl3 = bl = (by & 0x40) != 0;
        if (bl2 && !SDKConfig.getRectangleFontSupport()) {
            SDKUtils.debugLog("SDKImpl.loadFontChunk.detected rectangle font but support disabled, use SDKConfig to enable", 4);
        }
        int n3 = 12;
        int n4 = 7;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        n2 += n4;
        byArray2[7] = 0;
        byArray2[8] = byArray2[0];
        byArray2[9] = byArray2[1];
        byArray2[10] = bl2 ? 2 : 1;
        if (bl) {
            byArray2[10] = (byte)(byArray2[10] | 0x80);
        }
        int n5 = this.bytesToShort(byArray, n2);
        short s2 = this.bytesToShort(byArray, n2 += 2);
        n2 += 2;
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog("SDKImpl.loadFontChunk.fontVersion = " + by, 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.textDirection = " + byArray2[0], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.lineDirection = " + byArray2[1], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.leading = " + byArray2[2], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.ascent = " + byArray2[3], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.descent = " + byArray2[4], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.space space= " + byArray2[5], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.char space= " + byArray2[6], 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.numChars = " + n5, 1);
            SDKUtils.debugLog("SDKImpl.loadFontChunk.numTotalGlyphs = " + s2, 1);
        }
        short[] sArray = new short[n5];
        for (int i = 0; i < n5; ++i) {
            sArray[i] = this.bytesToShort(byArray, n2);
            n2 += 2;
        }
        short[] sArray2 = new short[n5 + 1];
        for (n = 0; n < n5; ++n) {
            sArray2[n] = this.bytesToShort(byArray, n2);
            n2 += 2;
        }
        sArray2[n5] = -1;
        n = 6;
        if (bl2 && SDKConfig.getRectangleFontSupport()) {
            n = bl ? 4 : 5;
        }
        int n6 = (n5 << 1) + s2 * n;
        byte[] byArray3 = new byte[n6];
        System.arraycopy(byArray, n2, byArray3, 0, n6);
        n2 += n6;
        int[] nArray = null;
        if (bl2 && SDKConfig.getRectangleFontSupport()) {
            short s3 = byArray[n2++];
            nArray = new int[s3];
            for (s = 0; s < s3; s = (short)(s + 1)) {
                nArray[s] = (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
                n2 += 4;
            }
        }
        short[] sArray3 = new short[256];
        for (s = 0; s < 128; s = (short)(s + 1)) {
            sArray3[s] = (short)this.getCodePos(sArray, s, 0, n5 - 1, sArray.length);
        }
        byArray2[11] = 1;
        return new Object[]{byArray2, sArray, sArray3, sArray2, byArray3, nArray};
    }

    public void refreshISOOffsets() {
        int n = this.mSdkFont.mUTFCodes.length;
        for (short s = 128; s < 256; s = (short)(s + 1)) {
            this.mSdkFont.mISOOffsetMap[s] = (short)this.getCodePos(this.mSdkFont.mUTFCodes, this.iso2utf(s), 0, n - 1, n);
        }
        this.mSdkFont.mProps[11] = this.mLanguageEncodings[this.mLangIndex];
    }

    public short bytesToShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public int getCodePos(short[] sArray, int n, int n2, int n3, int n4) {
        if (n2 > n3) {
            return n4;
        }
        int n5 = n2 + n3 >> 1;
        int n6 = sArray[n5] & 0xFFFF;
        if (n == n6) {
            return n5;
        }
        return n < n6 ? this.getCodePos(sArray, n, n2, n5 - 1, n4) : this.getCodePos(sArray, n, n5 + 1, n3, n4);
    }

    public void freeTextUtilsData() {
        int n;
        for (n = 0; n < this.mNumLangs; ++n) {
            this.mLanguageIsocodes[n] = null;
            this.mChunkSize[n] = null;
        }
        this.mLanguageIsocodes = null;
        this.mChunkSize = null;
        for (n = 0; n < this.mNumStorageChunks; ++n) {
            this.mChunkStringData[n] = null;
            this.mChunkStringOffsets[n] = null;
        }
        this.mChunkStringData = null;
        this.mChunkStringOffsets = null;
        this.mLanguageEncodings = null;
        this.mNumStringsPerChunk = null;
        this.mChunkFlags = null;
        this.mChunkGroup = null;
        this.mGroupMaxSize = null;
        this.mGroupMap = null;
        this.mGroupMaxNumOffsets = null;
        this.mLanguageFontDifferentiator = null;
        this.mWrapOffsets = null;
    }

    public void freeSoundManager() {
        this.mSoundManager = null;
    }

    public static SDKImpl[] InstArraySDKImpl(int n) {
        SDKImpl[] sDKImplArray = new SDKImpl[n];
        for (int i = 0; i < n; ++i) {
            sDKImplArray[i] = new SDKImpl();
        }
        return sDKImplArray;
    }

    public static SDKImpl[][] InstArraySDKImpl(int n, int n2) {
        SDKImpl[][] sDKImplArray = new SDKImpl[n][];
        for (int i = 0; i < n; ++i) {
            sDKImplArray[i] = new SDKImpl[n2];
            for (int j = 0; j < n2; ++j) {
                sDKImplArray[i][j] = new SDKImpl();
            }
        }
        return sDKImplArray;
    }

    public static SDKImpl[][][] InstArraySDKImpl(int n, int n2, int n3) {
        SDKImpl[][][] sDKImplArray = new SDKImpl[n][][];
        for (int i = 0; i < n; ++i) {
            sDKImplArray[i] = new SDKImpl[n2][];
            for (int j = 0; j < n2; ++j) {
                sDKImplArray[i][j] = new SDKImpl[n3];
                for (int k = 0; k < n3; ++k) {
                    sDKImplArray[i][j][k] = new SDKImpl();
                }
            }
        }
        return sDKImplArray;
    }

    public class ResInfo {
        int dfi;
        int offset;
        int length;
    }
}

