/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ApplicationStarter;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.J2MEScene;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SpecConstants;
import ca.jamdat.flight.VibrationManager;
import ca.jamdat.flight.VideoMode;
import ca.jamdat.fuser.Constants;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.DeviceInfo;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.HolsterListener;
import net.rim.device.api.system.KeyListener;

public class J2MEApp
extends MIDlet
implements Runnable {
    private static final int MAX_EVENTS = 8;
    private static final int MAX_KEY_EVENTS = 6;
    private long mTotalTimePaused = FlApplication.GetRealTime();
    private long mStopTimeStamp = -1L;
    private long[] mEvtQueue = new long[8];
    private int mEvtCount;
    private volatile boolean mIsPaused;
    private boolean mForceRepaintBeforeNextEvent;
    private boolean mFirstTime = true;
    private volatile boolean mPauseInQueue;
    private boolean mIsSoundManagerMuted;
    private boolean mLaunchBrowserOnExit;
    private String mExitURI = "";
    private long mLastResumeTimeStamp = FlApplication.GetRealTime();
    private long mLastForcedPaintTimeStamp = FlApplication.GetRealTime();
    public static final short EVT_INVALID = 0;
    public static final short EVT_KEY_PRESSED = 1;
    public static final short EVT_KEY_RELEASED = 2;
    public static final short EVT_FLIGHT_KEY_PRESSED = 3;
    public static final short EVT_FLIGHT_KEY_RELEASED = 4;
    public static final short EVT_PAUSE = 5;
    public static final short EVT_RESUME = 6;
    public static final short EVT_REPAINT = 7;
    public static final short EVT_EXIT = 8;
    public static final short EVT_BALL_ROLL = 13;
    public static FrameworkGlobals mFrameworkGlobals;
    public static Object paintLock;
    public static J2MEApp instance;
    public volatile boolean mMustQuit;
    public boolean mDoublePaint;
    public boolean mResumeNextIsShown;
    public Thread mMainLoop;
    public static FlApplication mApplication;
    public static J2MEScene mScene;

    public J2MEApp() {
        J2MEScene.mApp = instance = this;
    }

    public void destruct() {
    }

    public void setLaunchBrowserOnExit(boolean bl) {
        this.mLaunchBrowserOnExit = bl;
    }

    public void setExitURI(String string) {
        this.mExitURI = string;
    }

    public boolean callPlatformRequest(String string) throws ConnectionNotFoundException {
        return this.platformRequest(string);
    }

    protected void startApp() {
        this.start();
    }

    public final void start() {
        this.StartTime();
        if (this.mMainLoop == null && this.mFirstTime) {
            this.mMainLoop = new Thread(this);
            this.InitializeFrameworkApplication();
            this.InitializeNetworkThreads();
            this.mMainLoop.start();
        } else if (this.mPauseInQueue || this.mIsPaused) {
            this.AddEvent((short)6);
        }
    }

    protected void pauseApp() {
        this.pause();
    }

    public void pause() {
        this.StopTime();
        if (!(this.mPauseInQueue || this.mIsPaused || this.mFirstTime || this.mMustQuit)) {
            this.AddEvent((short)5);
        }
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (!this.mMustQuit) {
            this.mMustQuit = true;
            mApplication.SaveGame();
        }
    }

    public void OSExit() {
        this.mMustQuit = true;
        mApplication.SaveGame();
        SoundManager.Get().StopAllSoundPlayers();
        if (this.mLaunchBrowserOnExit) {
            try {
                this.callPlatformRequest(this.mExitURI);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Application.getApplication().removeKeyListener((KeyListener)mScene);
        Application.getApplication().removeHolsterListener((HolsterListener)mScene);
        Application.getApplication().removeGlobalEventListener((GlobalEventListener)mScene);
        this.notifyDestroyed();
    }

    public final void forceRepaintBeforeNextEvent() {
        this.mForceRepaintBeforeNextEvent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        mScene = new J2MEScene();
        J2MEScene.repaintScene = false;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)mScene);
        this.mFirstTime = false;
        while (!this.mMustQuit) {
            long l = FlApplication.GetRealTime();
            this.ProcessEvents();
            if (this.mIsPaused) {
                if (this.mResumeNextIsShown && mScene.isShown()) {
                    this.mResumeNextIsShown = false;
                    this.start();
                }
                try {
                    Thread.sleep(SpecConstants.GetMainLoopPausedSleepTime());
                }
                catch (Exception exception) {}
                continue;
            }
            long l2 = l;
            Object object = paintLock;
            synchronized (object) {
                mScene.onTime(this.GetGameTime());
            }
            if (this.mMustQuit) {
                return;
            }
            if (l2 - this.mLastForcedPaintTimeStamp > (long)SpecConstants.GetForcePeriodicInvalidateTime()) {
                J2MEScene.repaintScene = true;
                FlApplication.GetInstance().Invalidate();
                this.mLastForcedPaintTimeStamp = l2;
            }
            if (l2 - this.mLastResumeTimeStamp < 2000L) {
                J2MEScene.repaintScene = true;
                FlApplication.GetInstance().Invalidate();
            }
            if (J2MEScene.repaintScene && FlApplication.GetInstance().IsDirty()) {
                mScene.paint2();
            }
            FlApplication.GetInstance().OnFrameLimit((int)(FlApplication.GetRealTime() - l));
        }
    }

    void InitializeNetworkThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ProcessEvents() {
        short s = 0;
        int n = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        Object object = paintLock;
        // MONITORENTER : object
        block17: while (this.mEvtCount > 0 && !this.mForceRepaintBeforeNextEvent) {
            long[] lArray = this.mEvtQueue;
            // MONITORENTER : this.mEvtQueue
            long[] lArray2 = this.mEvtQueue;
            s = (short)(lArray2[0] >>> 48);
            n = (int)((lArray2[0] & 0xFFFFFFFF0000L) >>> 16);
            s2 = (short)((lArray2[0] & 0xFFFF00000000L) >>> 32);
            s3 = (short)((lArray2[0] & 0xFFFF0000L) >>> 16);
            s4 = (short)(lArray2[0] & 0xFFFFL);
            if (this.mEvtCount > 1) {
                for (int i = 0; i < 7; ++i) {
                    lArray2[i] = lArray2[i + 1];
                }
            }
            --this.mEvtCount;
            // MONITOREXIT : lArray
            switch (s) {
                case 1: {
                    mScene.OnKeyPressed(n);
                    break;
                }
                case 2: {
                    mScene.OnKeyReleased(n);
                    break;
                }
                case 3: {
                    mScene.OnFlightKeyPressed(n);
                    break;
                }
                case 4: {
                    mScene.OnFlightKeyReleased(n);
                    break;
                }
                case 5: {
                    this.mPauseInQueue = false;
                    this.mIsPaused = true;
                    J2MEApp.mFrameworkGlobals.application.OnFocusLostFromOS();
                    J2MEApp.mFrameworkGlobals.application.OnSuspendFromOS();
                    break;
                }
                case 6: {
                    this.mLastResumeTimeStamp = FlApplication.GetRealTime();
                    if (!this.mIsPaused) break;
                    J2MEApp.mFrameworkGlobals.application.OnFocusGainedFromOS();
                    J2MEApp.mFrameworkGlobals.application.OnResumeFromOS();
                    SoundManager.Get().SetMuted(this.mIsSoundManagerMuted);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.mIsPaused = false;
                    this.mDoublePaint = true;
                    break;
                }
                case 7: {
                    J2MEScene.repaintScene = true;
                    FlApplication.GetInstance().Invalidate();
                    break;
                }
                case 8: {
                    FlApplication.GetInstance();
                    FlApplication.Exit();
                    break;
                }
                case 13: {
                    mScene.OnFlightKeyPressed(n);
                    mScene.OnFlightKeyReleased(n);
                    continue block17;
                }
            }
        }
        this.mForceRepaintBeforeNextEvent = false;
        // MONITOREXIT : object
    }

    public void AddEvent(short s) {
        this.AddEvent(s, (short)0, (short)0, (short)0);
    }

    public void AddEvent(short s, int n) {
        short s2 = (short)(n >>> 16);
        short s3 = (short)(n & 0xFFFF);
        this.AddEvent(s, s2, s3, (short)0);
    }

    public void AddEvent(short s, short s2, short s3) {
        this.AddEvent(s, s2, s3, (short)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddEvent(short s, short s2, short s3, short s4) {
        if ((this.mPauseInQueue || this.mIsPaused) && s != 6) {
            return;
        }
        switch (s) {
            case 5: {
                this.mPauseInQueue = true;
                this.PauseSoundsOnInterrupts();
                long[] lArray = this.mEvtQueue;
                synchronized (this.mEvtQueue) {
                    this.mEvtCount = 0;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    break;
                }
            }
            case 6: {
                this.ResumeSoundsOnInterrupts();
            }
        }
        {
            boolean bl = true;
            long[] lArray = this.mEvtQueue;
            synchronized (this.mEvtQueue) {
                switch (s) {
                    case 1: {
                        if (this.mEvtCount < 5) break;
                        bl = false;
                        break;
                    }
                    case 5: 
                    case 6: {
                        if (this.mEvtCount < 8) break;
                        bl = false;
                        break;
                    }
                    default: {
                        if (this.mEvtCount < 6) break;
                        bl = false;
                    }
                }
                if (bl) {
                    this.mEvtQueue[this.mEvtCount++] = (long)s << 48 | (long)s2 << 32 & 0xFFFF00000000L | (long)s3 << 16 & 0xFFFF0000L | (long)s4 & 0xFFFFL;
                }
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return;
            }
        }
    }

    private final void PauseSoundsOnInterrupts() {
        this.mIsSoundManagerMuted = SoundManager.Get().IsMuted();
        SoundManager.Get().SetMuted(true);
        VibrationManager.Get().Stop();
    }

    private final void ResumeSoundsOnInterrupts() {
        if (SoundManager.Get().IsPauseSoundsOnInterrupt()) {
            // empty if block
        }
        SoundManager.Get().SetMuted(false);
    }

    public final void StartTime() {
        if (this.mStopTimeStamp != -1L) {
            this.mTotalTimePaused += FlApplication.GetRealTime() - this.mStopTimeStamp;
            this.mStopTimeStamp = -1L;
        }
    }

    public final void StopTime() {
        this.StopTime(FlApplication.GetRealTime());
    }

    public final void StopTime(long l) {
        if (this.mStopTimeStamp == -1L) {
            this.mStopTimeStamp = l;
        }
    }

    public int GetGameTime() {
        if (this.mStopTimeStamp == -1L) {
            return (int)(FlApplication.GetRealTime() - this.mTotalTimePaused);
        }
        return (int)(this.mStopTimeStamp - this.mTotalTimePaused);
    }

    public static int[] GetPlatformVersion() {
        String string = DeviceInfo.getPlatformVersion();
        int[] nArray = new int[]{0, 0, 0, 0};
        int n = 1;
        int n2 = 3;
        char[] cArray = new char[]{'0', '0'};
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != '.') {
                cArray[n] = string.charAt(i);
                --n;
            }
            if (string.charAt(i) != '.' && i != 0) continue;
            nArray[n2] = Integer.parseInt(new String(cArray));
            n = 1;
            cArray[0] = 48;
            cArray[1] = 48;
            --n2;
        }
        return nArray;
    }

    public static J2MEScene GetCurrentScene() {
        return mScene;
    }

    public void InitializeFrameworkApplication() {
        mFrameworkGlobals = new FrameworkGlobals();
        FrameworkGlobals.GetInstance().j2meApp = this;
        VideoMode videoMode = new VideoMode(SpecConstants.GetUsedWidth(), SpecConstants.GetUsedHeight(), Constants.ScreenColorDepth());
        DisplayManager.Initialize(videoMode, videoMode);
        mApplication = ApplicationStarter.NewFlightApp();
    }

    public static J2MEApp[] InstArrayJ2MEApp(int n) {
        J2MEApp[] j2MEAppArray = new J2MEApp[n];
        for (int i = 0; i < n; ++i) {
            j2MEAppArray[i] = new J2MEApp();
        }
        return j2MEAppArray;
    }

    public static J2MEApp[][] InstArrayJ2MEApp(int n, int n2) {
        J2MEApp[][] j2MEAppArray = new J2MEApp[n][];
        for (int i = 0; i < n; ++i) {
            j2MEAppArray[i] = new J2MEApp[n2];
            for (int j = 0; j < n2; ++j) {
                j2MEAppArray[i][j] = new J2MEApp();
            }
        }
        return j2MEAppArray;
    }

    public static J2MEApp[][][] InstArrayJ2MEApp(int n, int n2, int n3) {
        J2MEApp[][][] j2MEAppArray = new J2MEApp[n][][];
        for (int i = 0; i < n; ++i) {
            j2MEAppArray[i] = new J2MEApp[n2][];
            for (int j = 0; j < n2; ++j) {
                j2MEAppArray[i][j] = new J2MEApp[n3];
                for (int k = 0; k < n3; ++k) {
                    j2MEAppArray[i][j][k] = new J2MEApp();
                }
            }
        }
        return j2MEAppArray;
    }

    static {
        paintLock = new Object();
    }
}

