/*
 * Decompiled with CFR 0.152.
 */
package sprites;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import sprites.ActiveSprite;
import sprites.Broker;
import sprites.MoveableLayerManager;
import sprites.Solid;

public class SolidSprite
extends ActiveSprite
implements Solid {
    private static final boolean pixelLevel = false;
    private Vector collisions = new Vector();

    public SolidSprite(Image image, int speedX, int speedY) {
        super(image, speedX, speedY);
    }

    public SolidSprite(Image image, int frameWidth, int frameHeight, int speedX, int speedY) {
        super(image, frameWidth, frameHeight, speedX, speedY);
    }

    public SolidSprite(SolidSprite s) {
        super(s);
        this.collisions = s.collisions;
    }

    public void move() {
        super.move();
        Vector lastCollisions = this.collisions;
        this.collisions = new Vector();
        MoveableLayerManager layers = (MoveableLayerManager)Broker.instance().get("layers");
        int i = 0;
        while (i < layers.getSize()) {
            Layer layer = layers.getLayerAt(i);
            if (layer != this) {
                TiledLayer tiles;
                Solid solid;
                if (layer instanceof Sprite) {
                    Sprite sprite = (Sprite)layer;
                    if (this.collidesWith(sprite, false) && sprite instanceof Solid) {
                        solid = (Solid)sprite;
                        this.collidesWith(solid);
                    }
                } else if (layer instanceof TiledLayer && this.collidesWith(tiles = (TiledLayer)layer, false) && tiles instanceof Solid) {
                    solid = (Solid)tiles;
                    this.collidesWith(solid);
                }
            }
            ++i;
        }
        Enumeration enumLastCollisions = lastCollisions.elements();
        while (enumLastCollisions.hasMoreElements()) {
            Solid solid = (Solid)enumLastCollisions.nextElement();
            if (this.collisions.contains(solid)) continue;
            solid.collisionEnds();
        }
        lastCollisions = null;
    }

    public void collidesWith(Solid anObstacle) {
        this.collisionStarts(anObstacle);
        if (anObstacle instanceof Layer) {
            int dy;
            Layer layer = (Layer)anObstacle;
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            int xA = this.getX();
            int yA = this.getY();
            int xB = this.getX() + this.getWidth();
            int yB = this.getY() + this.getHeight();
            int xC = layer.getX();
            int yC = layer.getY();
            int xD = layer.getX() + layer.getWidth();
            int yD = layer.getY() + layer.getHeight();
            right = xB >= xC && xB <= xD ? xB : xD;
            int dx = right - (left = xC >= xA && xC <= xB ? xC : xA);
            if (dx > (dy = (bottom = yB >= yC && yB <= yD ? yB : yD) - (top = yC >= yA && yC <= yB ? yC : yA))) {
                if (yA != top || yB != bottom) {
                    if (yA == top) {
                        this.setSpeed(this.getSpeedX(), Math.abs(this.getSpeedY()));
                    } else if (yB == bottom) {
                        this.setSpeed(this.getSpeedX(), -Math.abs(this.getSpeedY()));
                    }
                }
            } else if (dx < dy) {
                if (xA != left || xB != right) {
                    if (xA == left) {
                        this.setSpeed(Math.abs(this.getSpeedX()), this.getSpeedY());
                    } else if (xB == right) {
                        this.setSpeed(-Math.abs(this.getSpeedX()), this.getSpeedY());
                    }
                }
            } else if (xA != left || xB != right || yA != top || yB != bottom) {
                if (xA == left) {
                    this.setSpeed(Math.abs(this.getSpeedX()), this.getSpeedY());
                } else if (xB == right) {
                    this.setSpeed(-Math.abs(this.getSpeedX()), this.getSpeedY());
                }
                if (yA == top) {
                    this.setSpeed(this.getSpeedX(), Math.abs(this.getSpeedY()));
                } else if (yB == bottom) {
                    this.setSpeed(this.getSpeedX(), -Math.abs(this.getSpeedY()));
                }
            }
            if (!(anObstacle instanceof ActiveSprite)) {
                anObstacle.collidesWith(this);
            }
        }
    }

    public void collisionStarts(Solid anObstacle) {
        this.collisions.addElement(anObstacle);
    }

    public void collisionEnds() {
    }
}

