/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class WallFactory {
    private static Random random = new Random();

    public static Vector createWall(int left, int top, int right, int bottom, int level) throws IOException {
        Vector<Brick> wall = new Vector<Brick>();
        Image braun = Image.createImage((String)"/BRAUN.png");
        Image green = Image.createImage((String)"/GREEN.png");
        Image heavyBlue = Image.createImage((String)"/HEAVYBLUE.png");
        Image lightBlue = Image.createImage((String)"/LIGHTBLUE.png");
        Image pink = Image.createImage((String)"/PINK.png");
        Image red = Image.createImage((String)"/RED.png");
        Image white = Image.createImage((String)"/WHITE.png");
        Image heavy = Image.createImage((String)"/HEAVY.png");
        Image solid = Image.createImage((String)"/SOLID.png");
        Image magic = Image.createImage((String)"/MAGIC.png");
        int x = left;
        while (x + braun.getWidth() <= right) {
            int y = top;
            while (y + braun.getHeight() <= bottom) {
                Brick brick = null;
                int brickType = Math.abs(random.nextInt() % 30);
                switch (brickType) {
                    case 0: {
                        brick = new Brick(white);
                        break;
                    }
                    case 10: {
                        brick = new Brick(braun);
                        break;
                    }
                    case 1: 
                    case 11: {
                        brick = new Brick(green);
                        break;
                    }
                    case 2: 
                    case 12: {
                        brick = new Brick(heavyBlue);
                        break;
                    }
                    case 3: 
                    case 13: {
                        brick = new Brick(lightBlue);
                        break;
                    }
                    case 4: 
                    case 14: {
                        brick = new Brick(pink);
                        break;
                    }
                    case 5: 
                    case 15: {
                        brick = new Brick(red);
                        break;
                    }
                    case 6: {
                        brick = new BallBrick(magic);
                        break;
                    }
                    case 7: 
                    case 17: {
                        brick = new HeavyBrick(heavy, 16, 7, 2);
                        break;
                    }
                    case 8: 
                    case 18: {
                        brick = new HeavyBrick(solid, 16, 7, 3);
                        break;
                    }
                    case 9: {
                        brick = new SpeedBrick(magic, 1);
                    }
                }
                if (brick != null) {
                    brick.setPosition(x, y);
                    wall.addElement(brick);
                }
                y += braun.getHeight();
            }
            x += braun.getWidth();
        }
        return wall;
    }

    public static Image createBackGround() {
        Image motif = null;
        try {
            switch (Math.abs(random.nextInt() % 4)) {
                case 0: {
                    motif = Image.createImage((String)"/MOTIF1.png");
                    break;
                }
                case 1: {
                    motif = Image.createImage((String)"/MOTIF2.png");
                    break;
                }
                case 2: {
                    motif = Image.createImage((String)"/MOTIF3.png");
                    break;
                }
                case 3: {
                    motif = Image.createImage((String)"/MOTIF4.png");
                }
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return motif;
    }

    private WallFactory() {
    }
}

