/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import sprites.Broker;
import sprites.MoveableLayerManager;
import sprites.Solid;
import sprites.SolidSprite;

public class Ball
extends SolidSprite {
    private static Player brickSound;
    private static Player paddleSound;
    private static int maxSpeedX;
    private static int maxSpeedY;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;

    public Ball(Image image, int speedX, int speedY) {
        super(image, speedX, speedY);
        this.init();
    }

    public Ball(Image image, int frameWidth, int frameHeight, int speedX, int speedY) {
        super(image, frameWidth, frameHeight, speedX, speedY);
        this.init();
    }

    public Ball(Ball b) {
        super(b);
        this.xMin = b.xMin;
        this.yMin = b.yMin;
        this.xMax = b.xMax;
        this.yMax = b.yMax;
    }

    public void setBounds(int xMin, int yMin, int xMax, int yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
    }

    public void move() {
        MoveableLayerManager layers;
        super.move();
        if (this.getX() + this.getWidth() < this.xMin) {
            this.setSpeed(Math.abs(this.getSpeedX()), this.getSpeedY());
        } else if (this.getX() > this.xMax) {
            this.setSpeed(-Math.abs(this.getSpeedX()), this.getSpeedY());
        }
        if (this.getY() + this.getHeight() < this.yMin) {
            this.setSpeed(this.getSpeedX(), Math.abs(this.getSpeedY()));
        } else if (this.getY() > this.yMax && (layers = (MoveableLayerManager)Broker.instance().get("layers")) != null) {
            layers.remove((Layer)this);
        }
    }

    public void collidesWith(Solid anObstacle) {
        if (anObstacle instanceof Brick || anObstacle instanceof Ball) {
            if (brickSound != null) {
                try {
                    brickSound.start();
                }
                catch (MediaException me) {
                    System.out.println((Object)me);
                }
            }
            super.collidesWith(anObstacle);
        } else if (anObstacle instanceof Paddle) {
            if (paddleSound != null) {
                try {
                    paddleSound.start();
                }
                catch (MediaException me) {
                    System.out.println((Object)me);
                }
            }
            Paddle paddle = (Paddle)anObstacle;
            this.collisionStarts(paddle);
            int xBall = this.getX();
            int padPart1 = paddle.getX() + paddle.getWidth() * 0 / 8;
            int padPart2 = paddle.getX() + paddle.getWidth() * 1 / 8;
            int padPart3 = paddle.getX() + paddle.getWidth() * 2 / 8;
            int padPart4 = paddle.getX() + paddle.getWidth() * 3 / 8;
            int padPart5 = paddle.getX() + paddle.getWidth() * 4 / 8;
            int padPart6 = paddle.getX() + paddle.getWidth() * 5 / 8;
            int padPart7 = paddle.getX() + paddle.getWidth() * 6 / 8;
            int padPart8 = paddle.getX() + paddle.getWidth() * 7 / 8;
            if (xBall < padPart2) {
                this.setSpeed(-4, -Math.abs(this.getSpeedY()));
            } else if (xBall >= padPart2 && xBall < padPart3) {
                this.setSpeed(-3, -Math.abs(this.getSpeedY()));
            } else if (xBall >= padPart3 && xBall < padPart4) {
                this.setSpeed(-2, -Math.abs(this.getSpeedY()));
            } else if (xBall >= padPart4 && xBall < padPart5) {
                this.setSpeed(-1, -Math.abs(this.getSpeedY()));
            } else if (xBall >= padPart5 && xBall < padPart6) {
                this.setSpeed(1, -Math.abs(this.getSpeedY()));
            } else if (xBall >= padPart6 && xBall < padPart7) {
                this.setSpeed(2, -Math.abs(this.getSpeedY()));
            } else if (xBall >= padPart7 && xBall < padPart8) {
                this.setSpeed(3, -Math.abs(this.getSpeedY()));
            } else {
                this.setSpeed(4, -Math.abs(this.getSpeedY()));
            }
        } else {
            super.collidesWith(anObstacle);
        }
    }

    private void init() {
        InputStream is;
        if (brickSound == null) {
            try {
                is = this.getClass().getResourceAsStream("/audio/ball.wav");
                brickSound = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                brickSound.realize();
                brickSound.prefetch();
            }
            catch (MediaException me) {
                System.out.println((Object)me);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
        if (paddleSound == null) {
            try {
                is = this.getClass().getResourceAsStream("/audio/paddle.wav");
                paddleSound = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                paddleSound.realize();
                paddleSound.prefetch();
            }
            catch (MediaException me) {
                System.out.println((Object)me);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
    }

    public void setMaxSpeed(int maxSpeedX, int maxSpeedY) {
        Ball.maxSpeedX = Math.abs(maxSpeedX);
        Ball.maxSpeedY = Math.abs(maxSpeedY);
        this.setSpeed(this.getSpeedX(), this.getSpeedY());
    }

    public void setSpeed(int speedX, int speedY) {
        int newSpeedX = speedX;
        int newSpeedY = speedY;
        if (Math.abs(newSpeedX) > maxSpeedX) {
            newSpeedX = maxSpeedX;
        }
        if (Math.abs(newSpeedY) > maxSpeedY) {
            newSpeedY = maxSpeedY;
        }
        super.setSpeed(newSpeedX, newSpeedY);
    }
}

