/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import sprites.Broker;
import sprites.ConcreteGameCanvas;
import sprites.MoveableLayerManager;

public class ArkanoidLayerManager
extends MoveableLayerManager {
    private boolean area;
    private int brickCount;
    private int ballCount;
    private long score;
    private Wall leftSide;
    private Wall rightSide;
    private Wall upperSide;
    private Paddle paddle;
    private Vector playedBalls = new Vector();
    private Vector wall;

    public void append(Layer layer) {
        if (layer instanceof Ball) {
            Ball ball = (Ball)layer;
            ball.setMaxSpeed(ball.getWidth() - 1, ball.getHeight() - 1);
            ball.setBounds(this.leftSide.getX() + this.leftSide.getWidth(), this.upperSide.getY() + this.upperSide.getHeight(), this.rightSide.getX(), this.leftSide.getHeight());
            ++this.ballCount;
            this.playedBalls.addElement(ball);
        }
        super.append(layer);
    }

    public void remove(Layer layer) {
        if (layer instanceof Brick) {
            --this.brickCount;
            this.eraseScore();
            this.score += (long)((Brick)layer).points();
            this.drawScore();
        } else if (layer instanceof Ball) {
            --this.ballCount;
            this.eraseScore();
            this.drawScore();
            this.eraseLives();
            this.drawLives();
        }
        super.remove(layer);
    }

    public void gameOver() {
        this.cleanWall();
        this.score = 0L;
    }

    public void nextLevel() {
        this.cleanArea();
        this.buildWall();
    }

    private void buildWall() {
        try {
            this.wall = WallFactory.createWall(this.leftSide.getWidth(), this.upperSide.getHeight() * 2, this.rightSide.getX() - 1, this.leftSide.getHeight() / 3, 0);
            Enumeration bricks = this.wall.elements();
            while (bricks.hasMoreElements()) {
                Layer brick = (Layer)bricks.nextElement();
                this.append(brick);
            }
            this.brickCount = this.wall.size();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void cleanWall() {
        Enumeration bricks = this.wall.elements();
        while (bricks.hasMoreElements()) {
            Layer brick = (Layer)bricks.nextElement();
            this.remove(brick);
        }
    }

    public void buildArea() {
        if (!this.area) {
            ConcreteGameCanvas gameCanvas = (ConcreteGameCanvas)Broker.instance().get("canvas");
            try {
                Image left = Image.createImage((String)"/LEFTSIDE.png");
                Image right = Image.createImage((String)"/RIGHTSIDE.png");
                Image top = Image.createImage((String)"/UPPERSIDE.png");
                this.leftSide = new Wall(Image.createImage((Image)left, (int)0, (int)0, (int)left.getWidth(), (int)Math.min(gameCanvas.getHeight(), left.getHeight()), (int)0));
                this.rightSide = new Wall(Image.createImage((Image)right, (int)0, (int)0, (int)right.getWidth(), (int)Math.min(gameCanvas.getHeight(), right.getHeight()), (int)0));
                this.upperSide = new Wall(Image.createImage((Image)top, (int)0, (int)0, (int)Math.min(gameCanvas.getWidth() - this.leftSide.getWidth() - this.rightSide.getWidth(), top.getWidth()), (int)top.getHeight(), (int)0));
                this.leftSide.setPosition(0, 0);
                this.append((Layer)this.leftSide);
                this.upperSide.setPosition(this.leftSide.getX() + this.leftSide.getWidth(), 0);
                this.append((Layer)this.upperSide);
                this.rightSide.setPosition(this.upperSide.getX() + this.upperSide.getWidth(), 0);
                this.append((Layer)this.rightSide);
                this.paddle = new Paddle(Image.createImage((String)"/PADDLE.png"), 4);
                this.paddle.setBounds(this.leftSide.getX() + this.leftSide.getWidth(), this.rightSide.getX());
                this.paddle.setPosition(this.upperSide.getX() + (this.upperSide.getWidth() - this.paddle.getWidth()) / 2, this.leftSide.getHeight() - (this.paddle.getHeight() + Font.getFont((int)64, (int)1, (int)0).getHeight()));
                this.append((Layer)this.paddle);
                Broker.instance().put("player", this.paddle);
            }
            catch (IOException e) {
                System.out.println(e);
            }
            this.area = true;
        }
    }

    private void cleanArea() {
        if (this.ballCount > 0) {
            this.paddle.addBalls(1);
        }
        Enumeration ballsEnum = this.playedBalls.elements();
        while (ballsEnum.hasMoreElements()) {
            Layer ball = (Layer)ballsEnum.nextElement();
            this.remove(ball);
        }
        this.playedBalls.removeAllElements();
        this.ballCount = 0;
    }

    public int getBrickCount() {
        return this.brickCount;
    }

    public int getBallCount() {
        return this.ballCount;
    }

    public void drawScore() {
        ArkanoidGameCanvas canvas = (ArkanoidGameCanvas)Broker.instance().get("canvas");
        canvas.getOffscreen().drawString(new Long(this.score).toString(), this.rightSide.getX(), this.rightSide.getHeight(), 40);
    }

    public void eraseScore() {
        ArkanoidGameCanvas canvas = (ArkanoidGameCanvas)Broker.instance().get("canvas");
        Long lScore = new Long(this.score);
        Font font = canvas.getOffscreen().getFont();
        canvas.erase(this.rightSide.getX() - font.stringWidth(lScore.toString()), this.rightSide.getHeight() - font.getHeight(), font.stringWidth(lScore.toString()), font.getHeight());
    }

    public void drawLives() {
        ArkanoidGameCanvas canvas = (ArkanoidGameCanvas)Broker.instance().get("canvas");
        canvas.getOffscreen().drawString(new Integer(this.paddle.getBallCount()).toString(), this.leftSide.getWidth(), this.leftSide.getHeight(), 36);
    }

    public void eraseLives() {
        ArkanoidGameCanvas canvas = (ArkanoidGameCanvas)Broker.instance().get("canvas");
        Font font = canvas.getOffscreen().getFont();
        canvas.erase(this.leftSide.getWidth(), this.leftSide.getHeight() - font.getHeight(), font.stringWidth(new Integer(this.paddle.getBallCount()).toString()), font.getHeight());
    }
}

