/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Starfield
implements Constants,
GameConstants {
    static int m_nStarAppearHeight;
    static int m_nStarAppearWidth;
    static int m_nStarFieldGenerationPointX;
    static int m_nStarFieldGenerationPointY;
    static int m_nStarFieldGenerationPointOffsetX;
    static int m_nStarFieldGenerationPointOffsetY;
    static int m_nStarFieldWorldWidth;
    static int m_nStarFieldWorldHeight;
    static int MAX_GENERATION_OFFSET;
    static boolean m_bStartFieldGenerationPointGoingRight;
    static int STAR_ACC;
    static int STAR_DEC;
    static int STAR_MAX_SPEED;
    static int STAR_MIN_SPEED;
    static int[] starPosX;
    static int[] starPosY;
    static int[] starPosZ;
    static int[] starColour;
    static int STARGEN_AREA_WIDTH;
    static int STAR_SPEED;
    static int STAR_SPEEDY;
    static int STAR_SPEEDX;

    public static final void initStars() {
        int n;
        m_nStarAppearHeight = Graphic.m_nHeight / 4;
        m_nStarAppearWidth = Graphic.m_nWidth / 4;
        m_nStarFieldGenerationPointX = Graphic.m_nXCenter;
        m_nStarFieldGenerationPointY = Graphic.m_nYCenter;
        m_nStarFieldWorldWidth = Graphic.m_nDeviceWidth + MAX_GENERATION_OFFSET * 2;
        m_nStarFieldWorldHeight = Graphic.m_nDeviceHeight + MAX_GENERATION_OFFSET * 2;
        m_bStartFieldGenerationPointGoingRight = true;
        for (n = 0; n < GCanvasController.backgroundStarPosX.length; ++n) {
            GCanvasController.backgroundStarPosX[n] = Util.GetRandom(m_nStarFieldWorldWidth) - MAX_GENERATION_OFFSET;
            GCanvasController.backgroundStarPosY[n] = Util.GetRandom(m_nStarFieldWorldHeight) - MAX_GENERATION_OFFSET;
            GCanvasController.backgroundStarBright[n] = Util.GetRandom(255);
        }
        for (n = 0; n < 250; ++n) {
            Starfield.initStar(n);
        }
        STAR_SPEED = STAR_MIN_SPEED;
    }

    public static final void initStar(int n) {
        Starfield.initStar(n, 0, Graphic.m_nDeviceHeight);
    }

    public static final void initStar(int n, int n2, int n3) {
        int n4;
        do {
            int n5 = Util.GetRandom(m_nStarAppearWidth);
            int n6 = Util.GetRandom(m_nStarAppearHeight);
            Starfield.starPosX[n] = FP.toFP(m_nStarFieldGenerationPointX + m_nStarFieldGenerationPointOffsetX - (n5 - m_nStarAppearWidth / 2) * m_nStarFieldWorldWidth);
            Starfield.starPosY[n] = FP.toFP(m_nStarFieldGenerationPointY - (n6 - m_nStarAppearHeight / 2) * m_nStarFieldWorldHeight);
            Starfield.starPosZ[n] = FP.toFP(Util.GetRandom(255));
            int n7 = n;
            starPosZ[n7] = starPosZ[n7] - STAR_SPEED;
            if (starPosZ[n] <= 0) {
                Starfield.starPosZ[n] = 1024;
            }
            n4 = FP.fpDiv(starPosY[n], starPosZ[n]) + FP.toFP(m_nStarFieldGenerationPointY + m_nStarFieldGenerationPointOffsetY);
        } while ((n4 -= m_nStarFieldGenerationPointOffsetY) <= 1024 * n2 || n4 >= 1024 * (n2 + n3));
    }

    public static void moveStarfieldPosY(int n) {
        int n2 = n * 1024;
        for (int i = 0; i < 250; ++i) {
            int n3 = starPosY[i];
            int n4 = i;
            starPosY[n4] = starPosY[n4] + n2;
            int n5 = FP.fpDiv(starPosY[i], starPosZ[i] - STAR_SPEED) + FP.toFP(m_nStarFieldGenerationPointY + m_nStarFieldGenerationPointOffsetY);
            n5 -= m_nStarFieldGenerationPointOffsetY;
            if ((n5 = FP.toInt(n5)) < Graphic.m_nHeight && n5 > 0) continue;
            Starfield.starPosY[i] = FP.toFP(m_nStarAppearHeight) - n3;
        }
    }

    public static void drawStars(Graphics graphics, int n) {
        Starfield.drawStars(graphics, 0, 100, -1, -1, -1, -1, n);
    }

    public static void drawStars(Graphics graphics, int n, int n2, int n3) {
        Starfield.drawStars(graphics, n, n2, -1, -1, -1, -1, n3);
    }

    public static void drawStars(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        graphics.setColor(0xFFFFFF);
        int n8 = 0;
        int n9 = FP.toFP(m_nStarFieldGenerationPointX + m_nStarFieldGenerationPointOffsetX);
        int n10 = FP.toFP(m_nStarFieldGenerationPointY + m_nStarFieldGenerationPointOffsetY);
        int n11 = FP.toFP(Graphic.m_nWidth);
        int n12 = FP.toFP(Graphic.m_nHeight);
        int n13 = n3 * 1024;
        int n14 = n4 * 1024;
        int n15 = n5 * 1024;
        int n16 = n6 * 1024;
        for (int i = 0; i < 250; ++i) {
            int n17;
            int n18 = starPosX[i];
            int n19 = starPosY[i];
            int n20 = starPosZ[i];
            if (starPosZ[i] <= 0) {
                Starfield.starPosZ[i] = 1024;
            }
            int n21 = FP.fpDiv(n18, n20) + n9;
            int n22 = FP.fpDiv(n19, n20) + n10;
            int n23 = i;
            starPosZ[n23] = starPosZ[n23] - STAR_SPEED;
            n20 = starPosZ[n23];
            if (n20 <= 0) {
                Starfield.starPosZ[i] = 1024;
                n20 = 1024;
            }
            int n24 = FP.fpDiv(n18, n20) + n9;
            int n25 = FP.fpDiv(n19, n20) + n10;
            if (n24 < 0 || n24 > n11 || n25 < 0 || n25 > n12 || n20 < 2048) {
                if ((n24 -= m_nStarFieldGenerationPointOffsetX) >= 0 && n24 <= m_nStarFieldWorldWidth && (n25 -= m_nStarFieldGenerationPointOffsetY) >= 0 && n25 <= n12 && n20 >= 2048) continue;
                Starfield.initStar(i);
                continue;
            }
            int n26 = 255 - FP.toInt(n20);
            n26 = Math.max(0, n26);
            n26 = Math.min(255, n26);
            if (n7 == 4) {
                n8 = GraphicsUtil.blendColours(n26 << 16, n26, GCanvasController.m_nColourModifier);
                graphics.setColor(GraphicsUtil.blendColours(n, n8, n2));
            } else if (n7 == 100) {
                n17 = n26 | n26 << 8 | n26 << 16;
                n8 = GraphicsUtil.blendColours(n17, n26, GCanvasController.m_nColourModifier);
                graphics.setColor(GraphicsUtil.blendColours(n, n8, n2));
            } else if (n7 == 0) {
                n8 = GraphicsUtil.blendColours(n26, n26 << 16, GCanvasController.m_nColourModifier);
                graphics.setColor(GraphicsUtil.blendColours(n, n8, n2));
            } else if (n7 == 1) {
                n8 = GraphicsUtil.blendColours(n26 << 16, n26 << 8, GCanvasController.m_nColourModifier);
                graphics.setColor(GraphicsUtil.blendColours(n, n8, n2));
            } else if (n7 == 2) {
                n8 = GraphicsUtil.blendColours(n26 << 8, n26, GCanvasController.m_nColourModifier);
                graphics.setColor(GraphicsUtil.blendColours(n, n8, n2));
            } else if (n7 == 7) {
                n8 = GraphicsUtil.blendColours(n26, n26 << 8, GCanvasController.m_nColourModifier);
                graphics.setColor(GraphicsUtil.blendColours(n, n8, n2));
            }
            n17 = graphics.getColor();
            if (n3 != -1 && n21 > n13 && n21 < n13 + n15 && n22 > n14 && n22 < n14 + n16) continue;
            Starfield.bresenhamDrawLine2(graphics, FP.toInt(n21), FP.toInt(n22), FP.toInt(n24), FP.toInt(n25), n17, false, FP.toInt(starPosZ[i]));
        }
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static void bresenhamDrawLine2(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        if (!bl && Math.abs(n4 - n2) > Math.abs(n3 - n)) {
            Starfield.bresenhamDrawLine2(graphics, n2, n, n4, n3, n5, true, n6);
        } else {
            int n7;
            if (n > n3) {
                Starfield.bresenhamDrawLine3(graphics, n3, n4, n, n2, n5, bl, n6);
                return;
            }
            int n8 = n3 - n;
            int n9 = n4 - n2;
            if (n9 < 0) {
                n7 = -1;
                n9 = -n9;
            } else {
                n7 = 1;
            }
            int n10 = 2 * n9;
            int n11 = 2 * n9 - 2 * n8;
            int n12 = -(2 * n9 - n8);
            int n13 = n2;
            int n14 = 0xFF & n5;
            int n15 = 0xFF & n5 >> 8;
            int n16 = 0xFF & n5 >> 16;
            int n17 = 0;
            for (int i = n3; i >= n; --i) {
                int n18;
                int n19;
                graphics.setColor(n16, n15, n14);
                if (n6 > 0) {
                    n19 = 2;
                    n18 = 1;
                } else {
                    n19 = 1;
                    n18 = 0;
                }
                if (++n17 > 5) break;
                if (!bl) {
                    graphics.fillRect(i - n18, n13 - n18, n19, n19);
                } else {
                    graphics.fillRect(n13 - n18, i - n18, n19, n19);
                }
                n14 -= n14 * 10 / 100;
                n15 -= n15 * 10 / 100;
                n16 -= n16 * 10 / 100;
                if (n12 >= 0) {
                    n12 -= n10;
                    continue;
                }
                n12 -= n11;
                n13 -= n7;
            }
        }
    }

    static void bresenhamDrawLine3(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        int n7;
        int n8 = n3 - n;
        int n9 = n4 - n2;
        if (n9 < 0) {
            n7 = -1;
            n9 = -n9;
        } else {
            n7 = 1;
        }
        int n10 = 2 * n9;
        int n11 = 2 * n9 - 2 * n8;
        int n12 = 2 * n9 - n8;
        int n13 = n2;
        int n14 = 0xFF & n5;
        int n15 = 0xFF & n5 >> 8;
        int n16 = 0xFF & n5 >> 16;
        int n17 = 0;
        for (int i = n; i <= n3; ++i) {
            int n18;
            int n19;
            if (n6 > 0) {
                n19 = 2;
                n18 = 1;
            } else {
                n19 = 1;
                n18 = 0;
            }
            if (++n17 > 5) break;
            graphics.setColor(n16, n15, n14);
            if (!bl) {
                graphics.fillRect(i - n18, n13 - n18, n19, n19);
            } else {
                graphics.fillRect(n13 - n18, i - n18, n19, n19);
            }
            n14 -= n14 * 10 / 100;
            n15 -= n15 * 10 / 100;
            n16 -= n16 * 10 / 100;
            if (n12 <= 0) {
                n12 += n10;
                continue;
            }
            n12 += n11;
            n13 += n7;
        }
    }

    static {
        MAX_GENERATION_OFFSET = 40;
        starPosX = new int[250];
        starPosY = new int[250];
        starPosZ = new int[250];
        starColour = new int[250];
    }
}

