/*
 * Decompiled with CFR 0.152.
 */
public class ScoreController
implements Constants,
GameConstants {
    static final int[] MATCH_SCORE = new int[45];
    static int[] SCORED_GEM_LINKED_MATCH = new int[64];
    static int m_nDisplayScore;
    static int m_nCurrentScore;
    static int[] ALL_TIME_STATS;
    static int[] GAME_STATS;
    static final int[] HIGH_SCORES_BLITZ;
    static final int[] HIGH_SCORES_CLASSIC;
    static final int[] HIGH_SCORES_CLASSIC_LEVEL;
    static int m_nCurrentRankProgress;
    static long m_lScoredGems;
    static final int MAX_SQRT_ABLE = 130000;
    static int[] BLITZ_XP_SCORES;
    static int[] BLITZ_XP_STARS;

    static void init() {
        ScoreController.HIGH_SCORES_CLASSIC[0] = 160000;
        ScoreController.HIGH_SCORES_CLASSIC[1] = 80000;
        ScoreController.HIGH_SCORES_CLASSIC[2] = 40000;
        ScoreController.HIGH_SCORES_CLASSIC[3] = 20000;
        ScoreController.HIGH_SCORES_CLASSIC[4] = 10000;
        ScoreController.HIGH_SCORES_BLITZ[0] = 100000;
        ScoreController.HIGH_SCORES_BLITZ[1] = 80000;
        ScoreController.HIGH_SCORES_BLITZ[2] = 60000;
        ScoreController.HIGH_SCORES_BLITZ[3] = 40000;
        ScoreController.HIGH_SCORES_BLITZ[4] = 20000;
        for (int i = 0; i < HIGH_SCORES_CLASSIC_LEVEL.length; ++i) {
            ScoreController.HIGH_SCORES_CLASSIC_LEVEL[i] = 4 + (HIGH_SCORES_CLASSIC_LEVEL.length - 1 - i) * 2;
        }
        Util.resetArray(ALL_TIME_STATS, 0);
        m_nCurrentRankProgress = 0;
    }

    static void resetVars() {
        Util.resetArray(GAME_STATS, 0);
        Util.resetArray(MATCH_SCORE, 0);
        Util.resetArray(SCORED_GEM_LINKED_MATCH, -1);
        m_nDisplayScore = 0;
        m_nCurrentScore = 0;
        m_lScoredGems = 0L;
    }

    static void updateScore() {
        if (HUDController.m_nHudTopFading != 10) {
            m_nDisplayScore = m_nCurrentScore - m_nDisplayScore > 1000 ? (m_nDisplayScore += 300) : (m_nCurrentScore - m_nDisplayScore > 500 ? (m_nDisplayScore += 100) : (m_nCurrentScore - m_nDisplayScore > 100 ? (m_nDisplayScore += 30) : (m_nDisplayScore += 15)));
            if (m_nDisplayScore >= m_nCurrentScore) {
                m_nDisplayScore = m_nCurrentScore;
            }
        }
    }

    static void updateAllTimeStats(int n, int n2, int n3, int n4) {
        ALL_TIME_STATS[1] = ALL_TIME_STATS[1] + n;
        ALL_TIME_STATS[3] = ALL_TIME_STATS[3] + n2;
        if (n > ALL_TIME_STATS[4]) {
            ScoreController.ALL_TIME_STATS[4] = n;
        }
        if (n2 > ALL_TIME_STATS[5]) {
            ScoreController.ALL_TIME_STATS[5] = n2;
        }
        if (n3 > ALL_TIME_STATS[6]) {
            ScoreController.ALL_TIME_STATS[6] = n3;
        }
        if (n4 > ALL_TIME_STATS[7]) {
            ScoreController.ALL_TIME_STATS[7] = n4;
        }
    }

    static void updateRank(int n) {
        int n2;
        m_nCurrentRankProgress += ScoreController.getLevelsXP(n);
        while (ALL_TIME_STATS[0] < "\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u0100\u0101\u0102\u0103\u0104\u0105\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d\u010e\u010f\u0110\u0111\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123\u0124\u0125\u0126\u0127\u0128\u0129\u012a\u012b".length() - 1 && m_nCurrentRankProgress >= (n2 = ALL_TIME_STATS[0] * 15 + 15)) {
            m_nCurrentRankProgress -= n2;
            ALL_TIME_STATS[0] = ALL_TIME_STATS[0] + 1;
            if (!GameController.m_GameModeUnlocked[3] && ALL_TIME_STATS[0] >= 2) {
                GameController.m_GameModeUnlocked[3] = true;
                Hint.flagHint(19);
            }
            if (GameController.m_GameModeUnlocked[2] || ALL_TIME_STATS[0] < 1) continue;
            GameController.m_GameModeUnlocked[2] = true;
            Hint.flagHint(18);
        }
    }

    static final int getLevelsXP(int n) {
        int n2 = 0;
        if (GameController.m_nGameMode == 0) {
            n2 = n + 1;
        } else if (GameController.m_nGameMode == 1) {
            int n3 = (n + 1) / 2;
            if ((n + 1) % 2 == 1) {
                ++n3;
            }
            n2 = n3;
        } else if (GameController.m_nGameMode == 2) {
            int n4 = n % 7 + 1;
            n2 = 2 + 3 * n4;
        } else if (GameController.m_nGameMode == 3 && m_nCurrentScore > 0) {
            if (m_nCurrentScore > 130000) {
                n2 = ScoreController.getBlitzHighScoreXP(m_nCurrentScore);
            } else {
                n2 = FP.fpDiv(FP.fpSqrt(1024 * m_nCurrentScore), 30720);
                n2 = FP.toIntRound(n2);
            }
        }
        n2 = Math.min(n2, 30);
        return n2;
    }

    static int getBlitzHighScoreXP(int n) {
        for (int i = 0; i < BLITZ_XP_SCORES.length; ++i) {
            if (n >= BLITZ_XP_SCORES[i]) {
                if (i != BLITZ_XP_SCORES.length - 1) continue;
                return 30;
            }
            return BLITZ_XP_STARS[i];
        }
        return BLITZ_XP_STARS[0];
    }

    static void updateGameStats(int n, int n2, int n3, int n4) {
        ScoreController.GAME_STATS[0] = Math.min(GAME_STATS[0] + n, 9999999);
        if (n > GAME_STATS[1]) {
            ScoreController.GAME_STATS[1] = n;
        }
        if (n2 > GAME_STATS[2]) {
            ScoreController.GAME_STATS[2] = n2;
        }
        if (n3 > GAME_STATS[3]) {
            ScoreController.GAME_STATS[3] = n3;
        }
        if (n4 > GAME_STATS[4]) {
            ScoreController.GAME_STATS[4] = n4;
        }
    }

    static int updateHighscores(int n, int[] nArray, int n2) {
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (n <= nArray[n3]) continue;
            n4 = n3;
            break;
        }
        if (n4 != -1) {
            for (int i = nArray.length - 1; i > n3; --i) {
                nArray[i] = nArray[i - 1];
                if (n2 == -1) continue;
                ScoreController.HIGH_SCORES_CLASSIC_LEVEL[i] = HIGH_SCORES_CLASSIC_LEVEL[i - 1];
            }
            nArray[n3] = n;
            if (n2 != -1) {
                ScoreController.HIGH_SCORES_CLASSIC_LEVEL[n3] = n2;
            }
        }
        return n4;
    }

    static final void scoreMatch(int n, long l, long l2, int n2) {
        if (GameController.m_nGameMode == 2) {
            return;
        }
        int n3 = Util.bitsSetLong(l);
        int n4 = n;
        int n5 = Math.min(GameController.MAX_CHAIN_MULT_TEXT, GModel.m_nChainMultiplier + 1);
        int n6 = Math.max(1, n5 + n4 + Math.max(GModel.m_nCascades - 1, 0));
        int n7 = Util.bitsSetLong(l2 | l & GModel.BOARD[8] | l & GModel.BOARD[9] | l & GModel.BOARD[16] | l & GModel.BOARD[7] | l & GModel.BOARD[12] | l & GModel.BOARD[13]);
        int n8 = (n3 - n7) * n6 * 20;
        int n9 = n3 * 1;
        n7 = Util.bitsSetLong(l2);
        n9 += n7 * 3;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 50;
        n7 = Util.bitsSetLong(l & GModel.BOARD[8]);
        n9 += n7 * 3;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 100;
        n7 = Util.bitsSetLong(l & GModel.BOARD[9]);
        n9 += n7 * 10;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 200;
        n7 = Util.bitsSetLong(l & GModel.BOARD[16]);
        n9 += n7 * 20;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 1000;
        n7 = Util.bitsSetLong(l & GModel.BOARD[7]);
        n9 += n7 * 5;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 100;
        n7 = Util.bitsSetLong(l & GModel.BOARD[12]);
        n9 += n7 * 10;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 500;
        n7 = Util.bitsSetLong(l & GModel.BOARD[13]);
        n9 += n7 * 3;
        n9 -= n7 * 1;
        n8 += n7 * n6 * 100;
        if (GameController.m_nGameMode == 1) {
            n8 /= 2;
        } else if (GameController.m_nGameMode == 3) {
            n8 = n8 * 5 / 2;
        }
        ScoreController.MATCH_SCORE[n] = n8;
        GameController.m_nTurnScoreTotal += n8;
        m_nCurrentScore = Math.min(m_nCurrentScore + n8, 9999999);
        GModel.m_nReplayPoints += n9;
        BoardTexts.setupScores(n);
        m_lScoredGems |= l;
    }

    static final void linkDestroyedGemsToMatch(int n) {
        if (GameController.m_nGameMode == 2) {
            return;
        }
        long l = GModel.MATCHES[n];
        int n2 = Util.findNextSetBit(l, 0);
        while (n2 != -1) {
            ScoreController.SCORED_GEM_LINKED_MATCH[n2] = n;
            n2 = Util.findNextSetBit(l, n2 + 1);
        }
    }

    static final void linkGemToMatchScore(int n, int n2) {
        if (GameController.m_nGameMode == 2) {
            return;
        }
        if (SCORED_GEM_LINKED_MATCH[n] != -1) {
            return;
        }
        if (n2 == -1) {
            return;
        }
        ScoreController.SCORED_GEM_LINKED_MATCH[n] = n2;
    }

    static final void increaseMatchScore(int n) {
        if (GameController.m_nCurrentState == 8 || GameController.m_nGameMode == 2) {
            return;
        }
        int n2 = SCORED_GEM_LINKED_MATCH[n];
        long l = 1L << n;
        if (n2 == -1) {
            return;
        }
        if ((m_lScoredGems & l) != 0L) {
            return;
        }
        m_lScoredGems |= l;
        int n3 = 0;
        if ((GModel.BOARD[10] & l) != 0L) {
            n3 += 50;
            GModel.m_nReplayPoints += 3;
        } else if ((GModel.BOARD[8] & l) != 0L) {
            n3 += 100;
            GModel.m_nReplayPoints += 3;
        } else if ((GModel.BOARD[9] & l) != 0L) {
            n3 += 200;
            GModel.m_nReplayPoints += 10;
        } else if ((GModel.BOARD[16] & l) != 0L) {
            n3 += 1000;
            GModel.m_nReplayPoints += 20;
        } else if ((GModel.BOARD[7] & l) != 0L) {
            n3 += 100;
            GModel.m_nReplayPoints += 5;
        } else if ((GModel.BOARD[12] & l) != 0L) {
            n3 += 500;
            GModel.m_nReplayPoints += 10;
        } else if ((GModel.BOARD[13] & l) != 0L) {
            n3 += 100;
            GModel.m_nReplayPoints += 3;
        } else if ((GModel.BOARD[14] & l) != 0L) {
            n3 += 500;
            GModel.m_nReplayPoints += 10;
        } else {
            n3 += 20;
            ++GModel.m_nReplayPoints;
        }
        int n4 = n2;
        int n5 = Math.min(GameController.MAX_CHAIN_MULT_TEXT, GModel.m_nChainMultiplier + 1);
        int n6 = Math.max(1, n5 + n4 + Math.max(GModel.m_nCascades - 1, 0));
        n3 *= n6;
        if (GameController.m_nGameMode == 1) {
            n3 /= 2;
        } else if (GameController.m_nGameMode == 3) {
            n3 = n3 * 5 / 2;
        }
        GameController.m_nTurnScoreTotal += n3;
        m_nCurrentScore = Math.min(m_nCurrentScore + n3, 9999999);
        int n7 = n2;
        MATCH_SCORE[n7] = MATCH_SCORE[n7] + n3;
        if ((BoardTexts.m_lOnScreenScoreMatches & 1L << n2) == 0L) {
            GCanvasController.getGemPosition(n, true, false);
            BoardTexts.addText(GCanvasController.m_nGetGemPosX + 44, GCanvasController.m_nGetGemPosY + 44, n2, -1, -1);
        } else {
            BoardTexts.IncreaseScore(n2);
        }
    }

    static {
        ALL_TIME_STATS = new int[8];
        GAME_STATS = new int[5];
        HIGH_SCORES_BLITZ = new int[5];
        HIGH_SCORES_CLASSIC = new int[5];
        HIGH_SCORES_CLASSIC_LEVEL = new int[5];
        BLITZ_XP_SCORES = new int[]{150000, 170000, 190000, 210000, 250000, 300000, 350000, 400000, 450000, 500000, 550000, 600000};
        BLITZ_XP_STARS = new int[]{16, 17, 17, 18, 19, 20, 22, 23, 24, 26, 27, 28};
    }
}

