/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class ImageManager
implements Constants,
ImageConstants {
    static final String OPERATION_DATA_SIZE = "\b\b\u0004";
    static byte[] COLOR_MAGENTA = new byte[]{-1, 0, -1};
    static final int DERIVED_OPERATION_CROP = 0;
    static final int DERIVED_OPERATION_ROTATE = 1;
    static final int DERIVED_OPERATION_SCALE = 2;
    static byte[] m_ImageOperationsBuffer;
    static byte[] m_ImageDerivedBuffer;
    static int m_nImageDerivedSize;
    public static final int PNG_ID_LENGTH = 8;
    public static final int PNG_PLTE = 1347179589;
    public static final int PNG_TRNS = 1951551059;
    public static final int PNG_IHDR = 1229472850;
    public static final int PNG_IDAT = 1229209940;
    public static byte[] m_PaletteData;
    public static short[] m_PaletteOffsets;
    static final int MAX_FORCED_IMAGES = 384;
    static final int[] m_ForcedImages;
    static int m_nForcedImagesCount;
    public static byte[] DATA_WINDOW;
    private static int imageId;
    private static byte[] imageBuffer;
    private static int imgBufferUsedSize;
    private static int nBytesReadThisFile;

    public static void addForcedImage(int n) {
        if (n < 0 || n > 355) {
            return;
        }
        for (int i = 0; i < m_nForcedImagesCount; ++i) {
            if (m_ForcedImages[i] != n) continue;
            return;
        }
        if (m_nForcedImagesCount < 384) {
            ImageManager.m_ForcedImages[ImageManager.m_nForcedImagesCount++] = n;
        }
    }

    public static final void applyFromToPalette(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = m_PaletteOffsets[n4];
        int n6 = m_PaletteData[n5++] & 0xFF;
        int n7 = Util.readBytesAsInt(m_PaletteData, n5, 2);
        int n8 = Util.readBytesAsInt(m_PaletteData, n5 += 2, 2);
        int n9 = Util.readBytesAsInt(m_PaletteData, n5 += 2, 2);
        int n10 = Util.readBytesAsInt(m_PaletteData, n5 += 2, 2);
        n5 += 2;
        boolean bl = false;
        if (n10 > 0) {
            int n11 = n5 + 2 * n7 + 4 * n8 + 5 * n9;
            int n12 = n2 * n3;
            for (int i = 0; i < n10; ++i) {
                int n13 = (m_PaletteData[n11++] & 0xFF) << 16 | (m_PaletteData[n11++] & 0xFF) << 8 | m_PaletteData[n11++] & 0xFF;
                int n14 = (m_PaletteData[n11++] & 0xFF) << 16 | (m_PaletteData[n11++] & 0xFF) << 8 | m_PaletteData[n11++] & 0xFF;
                for (int j = n; j < n + n12; ++j) {
                    if ((nArray[j] & 0xFFFFFF) != n13) continue;
                    nArray[j] = n14 | nArray[j] & 0xFF000000;
                }
            }
        }
    }

    public static final byte[] transformPNGImage(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        if (n3 == 0 && n4 < 0 && n5 < 0) {
            return byArray;
        }
        int n6 = n;
        int n7 = 0;
        if (m_ImageOperationsBuffer == null) {
            m_ImageOperationsBuffer = new byte[Math.max(40565, 0)];
        }
        System.arraycopy(byArray, n6, m_ImageOperationsBuffer, n7, 8);
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 4) != 0;
        boolean bl4 = (n3 & 8) != 0;
        boolean bl5 = (n3 & 0x70) != 0;
        boolean bl6 = n4 >= 0;
        boolean bl7 = false;
        boolean bl8 = bl3 || bl4 || bl5 || bl6 || bl7;
        boolean bl9 = (n3 & 0x80) != 0;
        n6 += 8;
        n7 += 8;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        byte by = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 1;
        int n16 = 0;
        while (n6 < n + n2 - 8) {
            if (bl8 || bl || bl2) {
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                int n26;
                int n27;
                int n28;
                int n29;
                n8 = Util.readBytesAsInt(byArray, n6, 4);
                n9 = Util.readBytesAsInt(byArray, n6 + 4, 4);
                System.arraycopy(byArray, n6, m_ImageOperationsBuffer, n7, n8 + 12);
                if (n9 == 1229472850) {
                    n10 = Util.readBytesAsInt(byArray, n6 + 8, 4);
                    n11 = Util.readBytesAsInt(byArray, n6 + 12, 4);
                    by = byArray[n6 + 16];
                    n16 = byArray[n6 + 17];
                    if (n16 != 3 && (n16 & 2) != 0) {
                        n15 = 3;
                    }
                    if ((n16 & 4) != 0) {
                        ++n15;
                    }
                    n15 = (by - 1) * n15 / 8 + 1;
                    n14 = 8 / by;
                    if (n14 == 0) {
                        n14 = 1;
                    }
                    n12 = (1 << by) - 1;
                    n13 = n10 * by / 8 * n15 + 1;
                    if (n10 * by % 8 != 0) {
                        ++n13;
                    }
                } else if (n16 == 3 && bl8 && n9 == 1347179589) {
                    n29 = 0;
                    if (bl6) {
                        n28 = m_PaletteOffsets[n4];
                        n27 = m_PaletteData[n28++] & 0xFF;
                        n26 = Util.readBytesAsInt(m_PaletteData, n28, 2);
                        n25 = Util.readBytesAsInt(m_PaletteData, n28 += 2, 2);
                        n24 = Util.readBytesAsInt(m_PaletteData, n28 += 2, 2);
                        n23 = Util.readBytesAsInt(m_PaletteData, n28 += 2, 2);
                        n28 += 2;
                        if (n25 > 0) {
                            n22 = n28 + 2 * n26;
                            for (n21 = 0; n21 < n25; ++n21) {
                                n20 = m_PaletteData[n22++] & 0xFF;
                                n19 = n7 + 8 + n20 * 3;
                                ImageManager.m_ImageOperationsBuffer[n19++] = m_PaletteData[n22++];
                                ImageManager.m_ImageOperationsBuffer[n19++] = m_PaletteData[n22++];
                                ImageManager.m_ImageOperationsBuffer[n19] = m_PaletteData[n22++];
                            }
                            n29 = 1;
                        }
                        if (n24 > 0) {
                            n22 = n28 + 2 * n26 + 4 * n25;
                            for (n21 = 0; n21 < n24; ++n21) {
                                n20 = m_PaletteData[n22++] & 0xFF;
                                n19 = n7 + 8 + n20 * 3;
                                ImageManager.m_ImageOperationsBuffer[n19++] = m_PaletteData[n22++];
                                ImageManager.m_ImageOperationsBuffer[n19++] = m_PaletteData[n22++];
                                ImageManager.m_ImageOperationsBuffer[n19] = m_PaletteData[n22++];
                                ++n22;
                            }
                            n29 = 1;
                        }
                        if (n23 > 0) {
                            n22 = n28 + 2 * n26 + 4 * n25 + 5 * n24;
                            for (int i = 0; i < n23; ++i) {
                                n21 = m_PaletteData[n22++];
                                n18 = m_PaletteData[n22++];
                                n17 = m_PaletteData[n22++];
                                n19 = n7 + 8;
                                for (int j = 0; j < n8 / 3; ++j) {
                                    if (n21 == m_ImageOperationsBuffer[n19] && n18 == m_ImageOperationsBuffer[n19 + 1] && n17 == m_ImageOperationsBuffer[n19 + 2]) {
                                        ImageManager.m_ImageOperationsBuffer[n19] = m_PaletteData[n22];
                                        ImageManager.m_ImageOperationsBuffer[n19 + 1] = m_PaletteData[n22 + 1];
                                        ImageManager.m_ImageOperationsBuffer[n19 + 2] = m_PaletteData[n22 + 2];
                                        n29 = 1;
                                    }
                                    n19 += 3;
                                }
                                n22 += 3;
                            }
                        }
                        if (n27 == 0 && n26 == 0 && n24 == 0) {
                            bl6 = false;
                        }
                    }
                    if (bl5 || bl4 || bl3 || bl7) {
                        n28 = n7 + 8;
                        n26 = n3 & 0x70;
                        for (n25 = 0; n25 < n8 / 3; ++n25) {
                            if (bl5) {
                                if (n26 == 80) {
                                    n27 = m_ImageOperationsBuffer[n28];
                                    ImageManager.m_ImageOperationsBuffer[n28] = m_ImageOperationsBuffer[n28 + 2];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 2] = n27;
                                } else if (n26 == 64) {
                                    n27 = m_ImageOperationsBuffer[n28];
                                    ImageManager.m_ImageOperationsBuffer[n28] = m_ImageOperationsBuffer[n28 + 2];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 2] = m_ImageOperationsBuffer[n28 + 1];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 1] = n27;
                                } else if (n26 == 48) {
                                    n27 = m_ImageOperationsBuffer[n28];
                                    ImageManager.m_ImageOperationsBuffer[n28] = m_ImageOperationsBuffer[n28 + 1];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 1] = m_ImageOperationsBuffer[n28 + 2];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 2] = n27;
                                } else if (n26 == 32) {
                                    n27 = m_ImageOperationsBuffer[n28];
                                    ImageManager.m_ImageOperationsBuffer[n28] = m_ImageOperationsBuffer[n28 + 1];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 1] = n27;
                                } else if (n26 == 16) {
                                    n27 = m_ImageOperationsBuffer[n28 + 1];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 1] = m_ImageOperationsBuffer[n28 + 2];
                                    ImageManager.m_ImageOperationsBuffer[n28 + 2] = n27;
                                }
                                n29 = 1;
                            }
                            if (bl4) {
                                ImageManager.m_ImageOperationsBuffer[n28] = n27 = (int)((byte)((m_ImageOperationsBuffer[n28] + m_ImageOperationsBuffer[n28 + 1] + m_ImageOperationsBuffer[n28 + 2]) / 3));
                                ImageManager.m_ImageOperationsBuffer[n28 + 1] = n27;
                                ImageManager.m_ImageOperationsBuffer[n28 + 2] = n27;
                                n29 = 1;
                            }
                            if (bl3) {
                                ImageManager.m_ImageOperationsBuffer[n28] = (byte)(255 - m_ImageOperationsBuffer[n28]);
                                ImageManager.m_ImageOperationsBuffer[n28 + 1] = (byte)(255 - m_ImageOperationsBuffer[n28 + 1]);
                                ImageManager.m_ImageOperationsBuffer[n28 + 2] = (byte)(255 - m_ImageOperationsBuffer[n28 + 2]);
                                n29 = 1;
                            }
                            if (bl7) {
                                // empty if block
                            }
                            n28 += 3;
                        }
                        bl8 = false;
                    }
                    if (n29 != 0) {
                        n28 = Util.crc32(m_ImageOperationsBuffer, n7 + 4, n8 + 4);
                        Util.writeBytesFromInt(m_ImageOperationsBuffer, n28, n7 + n8 + 8, 4);
                    }
                } else if (n16 == 3 && bl6 && n9 == 1951551059) {
                    n29 = m_PaletteOffsets[n4];
                    n28 = m_PaletteData[n29++] & 0xFF;
                    n27 = Util.readBytesAsInt(m_PaletteData, n29, 2);
                    n26 = Util.readBytesAsInt(m_PaletteData, n29 += 2, 2);
                    n25 = Util.readBytesAsInt(m_PaletteData, n29 += 2, 2);
                    n24 = Util.readBytesAsInt(m_PaletteData, n29 += 2, 2);
                    n29 += 2;
                    if (n28 != 0) {
                        for (n20 = 0; n20 < n8; ++n20) {
                            n23 = m_ImageOperationsBuffer[n7 + 8 + n20];
                            if ((n23 += n28) < 0) {
                                n23 = 0;
                            } else if (n23 > 255) {
                                n23 = 255;
                            }
                            ImageManager.m_ImageOperationsBuffer[n7 + 8 + n20] = (byte)n23;
                        }
                    }
                    for (n23 = 0; n23 < n27; ++n23) {
                        ImageManager.m_ImageOperationsBuffer[n7 + 8 + (ImageManager.m_PaletteData[n29] & 0xFF)] = m_PaletteData[n29 + 1];
                        n29 += 2;
                    }
                    n29 += 4 * n26;
                    for (n23 = 0; n23 < n25; ++n23) {
                        ImageManager.m_ImageOperationsBuffer[n7 + 8 + (ImageManager.m_PaletteData[n29] & 0xFF)] = m_PaletteData[n29 + 4];
                        n29 += 5;
                    }
                    if (n27 > 0 || n25 > 0 || n28 != 0) {
                        n23 = Util.crc32(m_ImageOperationsBuffer, n7 + 4, n8 + 4);
                        Util.writeBytesFromInt(m_ImageOperationsBuffer, n23, n7 + n8 + 8, 4);
                    }
                    bl6 = false;
                } else if ((bl || bl2) && n9 == 1229209940) {
                    n29 = n7 + 15;
                    if (bl) {
                        n28 = n10 / 2 + n10 % 2;
                        n27 = n11;
                    } else {
                        n28 = n10;
                        n27 = n11 / 2 + n11 % 2;
                    }
                    n19 = bl && bl2 && n10 % 2 != 0 ? 1 : 0;
                    for (n21 = 0; n21 < n28; ++n21) {
                        if (n19 != 0 && n21 == n28 - 1) {
                            n27 /= 2;
                        }
                        for (n18 = 0; n18 < n27 && (n19 == 0 || n21 != n28 - 1 || n18 <= n11 / 2); ++n18) {
                            n26 = n18 * n13 + 1 + n21 / n14 * n15;
                            n25 = n21 % n14;
                            if (bl & bl2) {
                                n24 = (n11 - n18 - 1) * n13 + 1 + (n10 - n21 - 1) / n14 * n15;
                                n23 = (n10 - n21 - 1) % n14;
                            } else if (bl) {
                                n24 = n18 * n13 + 1 + (n10 - n21 - 1) / n14 * n15;
                                n23 = (n10 - n21 - 1) % n14;
                            } else {
                                n24 = (n11 - n18 - 1) * n13 + 1 + n21 / n14 * n15;
                                n23 = n21 % n14;
                            }
                            n25 = (n14 - n25 - 1) * by;
                            n23 = (n14 - n23 - 1) * by;
                            n26 += n29;
                            n24 += n29;
                            for (n17 = 0; n17 < n15; ++n17) {
                                n20 = m_ImageOperationsBuffer[n26 + n17] >> n25 & n12;
                                n22 = m_ImageOperationsBuffer[n24 + n17] >> n23 & n12;
                                int n30 = n26 + n17;
                                m_ImageOperationsBuffer[n30] = (byte)(m_ImageOperationsBuffer[n30] & ~(n12 << n25));
                                int n31 = n24 + n17;
                                m_ImageOperationsBuffer[n31] = (byte)(m_ImageOperationsBuffer[n31] & ~(n12 << n23));
                                int n32 = n26 + n17;
                                m_ImageOperationsBuffer[n32] = (byte)(m_ImageOperationsBuffer[n32] | n22 << n25);
                                int n33 = n24 + n17;
                                m_ImageOperationsBuffer[n33] = (byte)(m_ImageOperationsBuffer[n33] | n20 << n23);
                            }
                        }
                    }
                    n21 = Util.alder32(m_ImageOperationsBuffer, n29, n8 - 11);
                    Util.writeBytesFromInt(m_ImageOperationsBuffer, n21, n7 + n8 + 4, 4);
                    n18 = Util.crc32(m_ImageOperationsBuffer, n7 + 4, n8 + 4);
                    Util.writeBytesFromInt(m_ImageOperationsBuffer, n18, n7 + n8 + 8, 4);
                    bl = false;
                    bl2 = false;
                }
                n6 += n8 + 12;
                n7 += n8 + 12;
                continue;
            }
            System.arraycopy(byArray, n6, m_ImageOperationsBuffer, n7, n2 - n6);
            break;
        }
        return m_ImageOperationsBuffer;
    }

    public static void deriveImage(byte[] byArray, int n, int n2) throws IOException {
        if (m_ImageOperationsBuffer == null) {
            m_ImageOperationsBuffer = new byte[Math.max(40565, 0)];
        }
        if (m_ImageDerivedBuffer == null) {
            m_ImageDerivedBuffer = new byte[0];
        }
        m_nImageDerivedSize = n2;
        int n3 = n;
        int n4 = 0;
        System.arraycopy(byArray, n3, m_ImageDerivedBuffer, n4, 8);
        n3 += 8;
        n4 += 8;
        int n5 = 0;
        int n6 = 0;
        boolean bl = true;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        int n12 = 0;
        int n13 = -1;
        byte by = 0;
        boolean bl2 = false;
        int n14 = 1;
        byte by2 = 0;
        while (n3 < n + n2 - 8) {
            if (bl) {
                n5 = Util.readBytesAsInt(byArray, n3, 4);
                n6 = Util.readBytesAsInt(byArray, n3 + 4, 4);
                if (n6 == 1229472850) {
                    n7 = Util.readBytesAsInt(byArray, n3 + 8, 4);
                    n8 = Util.readBytesAsInt(byArray, n3 + 12, 4);
                    by = byArray[n3 + 16];
                    if (by != 8) {
                        throw new RuntimeException("DeriveImage error, Unsupported Color Depth!");
                    }
                    by2 = byArray[n3 + 17];
                    if (by2 != 3) {
                        n13 = 0;
                    }
                    if (by2 != 3 && (by2 & 2) != 0) {
                        n14 = 3;
                    }
                    if ((by2 & 4) != 0) {
                        ++n14;
                    }
                    System.arraycopy(byArray, n3, m_ImageDerivedBuffer, n4, n5 + 12);
                    n9 = n4;
                    n10 = n5;
                    n3 += n5 + 12;
                    n4 += n5 + 12;
                    continue;
                }
                if (n6 == 1951551059) {
                    System.arraycopy(byArray, n3, m_ImageDerivedBuffer, n4, n5 + 12);
                    n11 = n4;
                    n12 = n5;
                    n13 = -1;
                    n3 += n5 + 12;
                    n4 += n5 + 12;
                    continue;
                }
                if (n6 == 1229209940) {
                    int n15;
                    int n16;
                    int n17;
                    System.arraycopy(byArray, n3, m_ImageOperationsBuffer, 0, n5 + 12);
                    System.arraycopy(byArray, n3, m_ImageDerivedBuffer, n4, 15);
                    int n18 = 15;
                    int n19 = n4 + 15;
                    int n20 = n5;
                    int n21 = SplitFileInputStream.readUnsignedByte();
                    block6: for (n17 = 0; n17 < n21; ++n17) {
                        int n22 = SplitFileInputStream.readUnsignedByte();
                        switch (n22) {
                            case 0: {
                                n16 = SplitFileInputStream.readUnsignedShort();
                                n15 = SplitFileInputStream.readUnsignedShort();
                                int n23 = SplitFileInputStream.readUnsignedShort();
                                int n24 = SplitFileInputStream.readUnsignedShort();
                                if (n23 > n7 || n24 > n8) {
                                    throw new RuntimeException("Crop error, cropped image bigger than original!");
                                }
                                if (n7 == n23 && n8 == n24) {
                                    if (n17 != n21 - 1) continue block6;
                                    System.arraycopy(m_ImageOperationsBuffer, n18, m_ImageDerivedBuffer, n19, n20 - 3);
                                    continue block6;
                                }
                                int n25 = 0;
                                int n26 = n15;
                                while (n25 < n24) {
                                    ImageManager.m_ImageDerivedBuffer[n19 + n25 * (n23 * n14 + 1)] = m_ImageOperationsBuffer[n18 + n26 * (n7 * n14 + 1)];
                                    System.arraycopy(m_ImageOperationsBuffer, n18 + n26 * (n7 * n14 + 1) + 1 + n16 * n14, m_ImageDerivedBuffer, n19 + n25 * (n23 * n14 + 1) + 1, n23 * n14);
                                    ++n25;
                                    ++n26;
                                }
                                n20 += (n23 * n14 + 1) * n24 - (n7 * n14 + 1) * n8;
                                n7 = n23;
                                n8 = n24;
                                break;
                            }
                            case 1: {
                                int n27;
                                int n28;
                                int n26;
                                int n25;
                                int n24;
                                n16 = SplitFileInputStream.readInt();
                                n15 = SplitFileInputStream.readInt();
                                if (n15 == 65536 || n15 == -65536 || n16 == 65536 || n16 == -65536) {
                                    ImageManager.rotate90(n18, n19, n7, n8, n16, n15, n14);
                                    if (n16 == 0) break;
                                    n24 = n8;
                                    n25 = n7;
                                    n20 += (n24 * n14 + 1) * n25 - (n7 * n14 + 1) * n8;
                                    n7 = n24;
                                    n8 = n25;
                                    break;
                                }
                                if (n13 < 0) {
                                    n13 = 0;
                                    if (n11 >= 0) {
                                        n25 = 255;
                                        for (n26 = 0; n26 < n12; ++n26) {
                                            n24 = m_ImageDerivedBuffer[n11 + 8 + n26];
                                            if (n24 >= n25) continue;
                                            n25 = n24;
                                            n13 = (byte)n26;
                                        }
                                    }
                                }
                                long l = (long)n15 * (long)n7;
                                long l2 = (long)n15 * (long)n8;
                                long l3 = (long)n16 * (long)n7;
                                long l4 = (long)n16 * (long)n8;
                                int n29 = (int)(Math.max(Math.max(Math.max(Math.abs(l + l4), Math.abs(l - l4)), Math.abs(-l + l4)), Math.abs(-l - l4)) >> 16);
                                int n30 = (int)(Math.max(Math.max(Math.max(Math.abs(l3 + l2), Math.abs(l3 - l2)), Math.abs(-l3 + l2)), Math.abs(-l3 - l2)) >> 16);
                                int n31 = n7 * n14 + 1;
                                int n32 = n29 * n14 + 1;
                                int n33 = n30 / 2;
                                int n34 = n7 - n29 << 15;
                                int n35 = n8 - n30 << 15;
                                int n36 = (n29 << 15) - n15 * (n29 - 1 >> 1);
                                int n37 = (n30 << 15) - n16 * (n29 - 1 >> 1);
                                int n38 = (n7 << 16) - 1;
                                int n39 = (n8 << 16) - 1;
                                for (int i = 0; i < n30; ++i) {
                                    n28 = n36 + n16 * (n33 - i) + n34;
                                    n27 = n37 - n15 * (n33 - i) + n35;
                                    ImageManager.m_ImageDerivedBuffer[n19 + i * n32] = 0;
                                    for (int j = 0; j < n29; ++j) {
                                        int n40;
                                        if (n28 < 0 || n27 < 0 || n28 > n38 || n27 > n39) {
                                            if (by2 != 3) {
                                                for (n40 = 0; n40 < n14; ++n40) {
                                                    ImageManager.m_ImageDerivedBuffer[n19 + i * n32 + j * n14 + 1 + n40] = n40 == COLOR_MAGENTA.length ? (byte)0 : COLOR_MAGENTA[n40];
                                                }
                                            } else {
                                                ImageManager.m_ImageDerivedBuffer[n19 + i * n32 + j * n14 + 1] = n13;
                                            }
                                        } else {
                                            for (n40 = 0; n40 < n14; ++n40) {
                                                ImageManager.m_ImageDerivedBuffer[n19 + i * n32 + j * n14 + 1 + n40] = m_ImageOperationsBuffer[n18 + (n27 >> 16) * n31 + (n28 >> 16) * n14 + 1 + n40];
                                            }
                                        }
                                        n28 += n15;
                                        n27 += n16;
                                    }
                                }
                                n20 += n32 * n30 - n31 * n8;
                                n7 = n29;
                                n8 = n30;
                                break;
                            }
                            case 2: {
                                int n27;
                                int n34;
                                int n33;
                                int n32;
                                int n31;
                                int n30;
                                n16 = SplitFileInputStream.readUnsignedShort();
                                n15 = SplitFileInputStream.readUnsignedShort();
                                int n23 = n7 * n16 / 100;
                                int n24 = n8 * n15 / 100;
                                int n25 = n18;
                                int n26 = n19;
                                int n41 = n7 * n14 + 1;
                                int n42 = n23 * n14 + 1;
                                int n43 = n23 << 1;
                                int n44 = n24 << 1;
                                int n45 = n7 << 1;
                                int n29 = n8 << 1;
                                int n28 = n29 - n44;
                                for (n27 = 0; n27 < n24; ++n27) {
                                    n31 = n25;
                                    n32 = n26;
                                    ImageManager.m_ImageDerivedBuffer[n19 + n27 * n42] = 0;
                                    n30 = n45 - n43;
                                    for (n33 = 0; n33 < n23; ++n33) {
                                        for (n34 = 0; n34 < n14; ++n34) {
                                            ImageManager.m_ImageDerivedBuffer[n32 + n34] = m_ImageOperationsBuffer[n31 + n34];
                                        }
                                        n32 += n14;
                                        while (n30 >= 0) {
                                            n31 += n14;
                                            n30 -= n43;
                                        }
                                        n30 += n45;
                                    }
                                    while (n28 >= 0) {
                                        n25 += n41;
                                        n28 -= n44;
                                    }
                                    n26 += n42;
                                    n28 += n29;
                                }
                                n20 += n42 * n24 - n41 * n8;
                                n7 = n23;
                                n8 = n24;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown derived operation type: " + n22);
                            }
                        }
                        if (n17 >= n21 - 1) continue;
                        System.arraycopy(m_ImageDerivedBuffer, n4, m_ImageOperationsBuffer, 0, n20 + 12);
                    }
                    Util.writeBytesFromInt(m_ImageDerivedBuffer, n20, n4, 4);
                    n17 = (n7 * n14 + 1) * n8;
                    ImageManager.m_ImageDerivedBuffer[n4 + 11] = (byte)(n17 & 0xFF);
                    ImageManager.m_ImageDerivedBuffer[n4 + 12] = (byte)(n17 >> 8 & 0xFF);
                    ImageManager.m_ImageDerivedBuffer[n4 + 13] = (byte)(~n17 & 0xFF);
                    ImageManager.m_ImageDerivedBuffer[n4 + 14] = (byte)(~n17 >> 8 & 0xFF);
                    n16 = Util.alder32(m_ImageDerivedBuffer, n19, n20 - 11);
                    Util.writeBytesFromInt(m_ImageDerivedBuffer, n16, n4 + n20 + 4, 4);
                    n15 = Util.crc32(m_ImageDerivedBuffer, n4 + 4, n20 + 4);
                    Util.writeBytesFromInt(m_ImageDerivedBuffer, n15, n4 + n20 + 8, 4);
                    bl = false;
                    Util.writeBytesFromInt(m_ImageDerivedBuffer, n7, n9 + 8, 4);
                    Util.writeBytesFromInt(m_ImageDerivedBuffer, n8, n9 + 12, 4);
                    n15 = Util.crc32(m_ImageDerivedBuffer, n9 + 4, n10 + 4);
                    Util.writeBytesFromInt(m_ImageDerivedBuffer, n15, n9 + n10 + 8, 4);
                    n3 += n5 + 12;
                    n4 += n20 + 12;
                    continue;
                }
                System.arraycopy(byArray, n3, m_ImageDerivedBuffer, n4, n5 + 12);
                n3 += n5 + 12;
                n4 += n5 + 12;
                continue;
            }
            System.arraycopy(byArray, n3, m_ImageDerivedBuffer, n4, n2 - n3);
            n4 += n2 - n3;
            break;
        }
        m_nImageDerivedSize = n4;
    }

    static void rotate90(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        if (n5 != 0) {
            n9 = n4;
            n8 = n3;
        } else {
            n9 = n3;
            n8 = n4;
        }
        int n10 = n9 * n7 + 1;
        int n11 = n3 * n7 + 1;
        for (int i = 0; i < n8; ++i) {
            int n12 = n2 + i * n10;
            ImageManager.m_ImageDerivedBuffer[n12] = 0;
            for (int j = 0; j < n9; ++j) {
                int n13;
                int n14;
                if (n5 < 0) {
                    n14 = i;
                    n13 = n4 - j - 1;
                } else if (n5 > 0) {
                    n14 = n3 - i - 1;
                    n13 = j;
                } else {
                    n14 = n3 - j - 1;
                    n13 = n4 - i - 1;
                }
                for (int k = 0; k < n7; ++k) {
                    ImageManager.m_ImageDerivedBuffer[n12 + j * n7 + 1 + k] = m_ImageOperationsBuffer[n + n13 * n11 + n14 * n7 + 1 + k];
                }
            }
        }
    }

    public static void LoadPalettes() {
        if (m_PaletteData != null) {
            return;
        }
        InputStream inputStream = Graphic.STANDARD_GRAPHICS_FILE.getClass().getResourceAsStream("/p");
        m_PaletteData = new byte[12625];
        Util.safeRead(inputStream, m_PaletteData, 0, 12625);
        int n = m_PaletteData[0] & 0xFF;
        short s = 1;
        m_PaletteOffsets = new short[n];
        for (int i = 0; i < n; ++i) {
            ImageManager.m_PaletteOffsets[i] = s;
            int n2 = Util.readBytesAsInt(m_PaletteData, s + 1, 2);
            int n3 = Util.readBytesAsInt(m_PaletteData, s + 3, 2);
            int n4 = Util.readBytesAsInt(m_PaletteData, s + 5, 2);
            int n5 = Util.readBytesAsInt(m_PaletteData, s + 7, 2);
            int n6 = 9 + n2 * 2 + n3 * 4 + n4 * 5 + n5 * 6;
            s = (short)(s + n6);
        }
    }

    public static void UnloadPalettes() {
    }

    public static void preLoadImageSets() {
        imageId = 0;
        SplitFileInputStream.init();
        imageBuffer = new byte[40565];
        imgBufferUsedSize = 0;
        nBytesReadThisFile = 0;
    }

    public static void postLoadImageSets() {
        imageBuffer = null;
        m_ImageOperationsBuffer = null;
        m_ImageDerivedBuffer = null;
    }

    public static void LoadImageSets(long l, boolean bl) {
        try {
            if (imageId < 355) {
                long l2 = SplitFileInputStream.readLong();
                boolean bl2 = m_nForcedImagesCount > 0 || bl || (l2 & l) != 0L;
                int n = SplitFileInputStream.readInt();
                if (bl2) {
                    int n2;
                    int n3;
                    imgBufferUsedSize = n;
                    SplitFileInputStream.readFully(imageBuffer, 0, imgBufferUsedSize);
                    int n4 = SplitFileInputStream.readUnsignedShort();
                    int n5 = imageId;
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n6;
                        long l3 = SplitFileInputStream.readLong();
                        boolean bl3 = bl2 = bl || (l3 & l) != 0L;
                        if (!bl2) {
                            for (n6 = 0; n6 < m_nForcedImagesCount; ++n6) {
                                if (imageId != m_ForcedImages[n6]) continue;
                                bl2 = true;
                                break;
                            }
                        }
                        if (bl2) {
                            int n7;
                            n6 = SplitFileInputStream.readUnsignedByte();
                            n2 = SplitFileInputStream.readUnsignedShort();
                            if (n2 >= 65535) {
                                n2 = -1;
                            }
                            if ((n7 = SplitFileInputStream.readUnsignedByte()) >= 255) {
                                n7 = -1;
                            }
                            if (Graphic.m_ImgPool[imageId] == null) {
                                Graphic.CreateImage(imageId, imageBuffer, 0, imgBufferUsedSize, n5, n6, n2, n7, l3);
                            }
                            ResManager.UpdateLoadScreen(imageId * 100 / 355);
                        } else {
                            SplitFileInputStream.skipBytes(4);
                        }
                        ++imageId;
                    }
                    n3 = SplitFileInputStream.readUnsignedShort();
                    for (int i = 0; i < n3; ++i) {
                        long l4 = SplitFileInputStream.readLong();
                        boolean bl4 = bl2 = m_nForcedImagesCount > 0 || bl || (l4 & l) != 0L;
                        if (bl2) {
                            ImageManager.deriveImage(imageBuffer, 0, imgBufferUsedSize);
                            n4 = SplitFileInputStream.readUnsignedShort();
                            n5 = imageId;
                            for (n2 = 0; n2 < n4; ++n2) {
                                int n8;
                                long l5 = SplitFileInputStream.readLong();
                                boolean bl5 = bl2 = bl || (l5 & l) != 0L;
                                if (!bl2) {
                                    for (n8 = 0; n8 < m_nForcedImagesCount; ++n8) {
                                        if (imageId != m_ForcedImages[n8]) continue;
                                        bl2 = true;
                                        break;
                                    }
                                }
                                if (bl2) {
                                    int n9;
                                    n8 = SplitFileInputStream.readUnsignedByte();
                                    int n10 = SplitFileInputStream.readUnsignedShort();
                                    if (n10 >= 65535) {
                                        n10 = -1;
                                    }
                                    if ((n9 = SplitFileInputStream.readUnsignedByte()) >= 255) {
                                        n9 = -1;
                                    }
                                    if (Graphic.m_ImgPool[imageId] == null) {
                                        Graphic.CreateImage(imageId, m_ImageDerivedBuffer, 0, m_nImageDerivedSize, n5, n8, n10, n9, l5);
                                        ResManager.UpdateLoadScreen(imageId * 100 / 355);
                                    }
                                } else {
                                    SplitFileInputStream.skipBytes(4);
                                }
                                ++imageId;
                            }
                            continue;
                        }
                        n2 = SplitFileInputStream.readUnsignedByte();
                        for (int j = 0; j < n2; ++j) {
                            int n11 = SplitFileInputStream.readUnsignedByte();
                            SplitFileInputStream.skipBytes(OPERATION_DATA_SIZE.charAt(n11));
                        }
                        n4 = SplitFileInputStream.readUnsignedShort();
                        SplitFileInputStream.skipBytes(n4 * 12);
                        imageId += n4;
                    }
                } else {
                    SplitFileInputStream.skipBytes(n);
                    int n12 = SplitFileInputStream.readUnsignedShort();
                    SplitFileInputStream.skipBytes(n12 * 12);
                    imageId += n12;
                    int n13 = SplitFileInputStream.readUnsignedShort();
                    for (int i = 0; i < n13; ++i) {
                        SplitFileInputStream.skipBytes(8);
                        int n14 = SplitFileInputStream.readUnsignedByte();
                        for (int j = 0; j < n14; ++j) {
                            int n15 = SplitFileInputStream.readUnsignedByte();
                            SplitFileInputStream.skipBytes(OPERATION_DATA_SIZE.charAt(n15));
                        }
                        n12 = SplitFileInputStream.readUnsignedShort();
                        SplitFileInputStream.skipBytes(n12 * 12);
                        imageId += n12;
                    }
                }
                return;
            }
            Game.initPhase = 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResManager.UpdateLoadScreen(-1);
        ResManager.UpdateLoadScreen(-1);
    }

    static {
        m_ForcedImages = new int[384];
        m_nForcedImagesCount = 0;
        DATA_WINDOW = new byte[32768];
        imageId = 0;
        imageBuffer = null;
        imgBufferUsedSize = 0;
        nBytesReadThisFile = 0;
    }
}

