/*
 * Decompiled with CFR 0.152.
 */
public class GCanvasController
implements GameConstants,
Constants {
    static final int[] GEMS_FP_FALL_SPEED = new int[64];
    static final int[] GEMS_FP_FALL_OFFSET = new int[64];
    static int[] GEMS_FP_OFFSET_X = new int[64];
    static int[] GEMS_FP_OFFSET_Y = new int[64];
    static int[] GEMS_FP_OFFSET_TOTAL = new int[64];
    static int[] GEMS_FP_MOVE_PER_FRAME = new int[64];
    static int[] GEMS_OFFSET_DELAY = new int[64];
    static long[] GEMS_FLAGS = new long[64];
    public static final int[] TILE_FADE_COLS = new int[]{0x696969, 26880, 0x800000, 1644912, 0x8B8B00, 6824587, 9127168, 0x696969};
    static boolean m_bFinishTransition;
    static int m_nLevelFillPulseFrame;
    static int m_nFruitIdleSparkleFrame;
    static long m_lFruitIdleToSparkle;
    static int m_nCoalIdleFrame;
    static final int[] GEMS_CURRENT_FRAME;
    static final int[] TILES_CURRENT_FRAME;
    static final int[] OVERLAYS_CURRENT_FRAME;
    static int m_nGemsDestroyedFrame;
    static int m_nDisplayNumGemsDestroyed;
    static int[] backgroundStarPosX;
    static int[] backgroundStarPosY;
    static int[] backgroundStarBright;
    static boolean m_bAnimationResolved;
    static int m_nCursorFrame;
    static int m_nCursorFrameSkip;
    static int m_nCursorWaitFrame;
    static int m_nCursorBackgroundFrame;
    static int m_nCursorAnim;
    static int m_nCursorAnimCycles;
    static final int[] FADE_TILES;
    static int m_nColourModifier;
    static final int[] VECTOR_COUNTDOWN_PULSE_FRAMES;
    static final int[] VECTOR_COUNTDOWN_PULSE_COL;
    static final int[] VECTOR_COUNTDOWN_PULSE_TIMES;
    static int m_nGetGemPosX;
    static int m_nGetGemPosY;
    static final int[] GEMS_NEXT_ANIM_STATE;
    static final int[] GEMS_NEXT_ANIM_STATE_DELAY;
    static long m_lGemsDelayedAnimState;
    static long m_lAnimatedLightningsExploded;
    static int m_nAnimatedLightningFrame;
    static long m_lSuperLightningUp;
    static long m_lSuperLightningDown;
    static long m_lSuperLightningLeft;
    static long m_lSuperLightningRight;
    static int CASCADE_FP_PUSH;
    static int CASCADE_FP_INC;
    static int CASCADE_FP_DEC;
    static final int[] COUNTDOWN_PULSE_CHANCE;
    static long lBoardFadedRows;
    static int m_nBoardFadeFrame;
    static int m_nRemainingWisps;
    static int m_nRemainingWispGem;
    static int m_nRemainingWispsFrame;
    static final int[] COUNTDOWN_FONT_FRAME;

    static final void init() {
        Starfield.STAR_ACC = 1024;
        Starfield.STAR_DEC = FP.fpDiv(1, 2);
        Starfield.STAR_MAX_SPEED = FP.toFP(20);
        Starfield.STAR_MIN_SPEED = 1024;
        Starfield.initStars();
        CASCADE_FP_PUSH = FP.fpDiv(4096, 4096);
        CASCADE_FP_INC = FP.fpDiv(6144, 4096);
        CASCADE_FP_DEC = FP.fpDiv(4096, 4096);
    }

    static final void createGameImages() {
        HUD.createHUDImages();
    }

    static final void releaseGameImages() {
    }

    static final void resetVars() {
        Util.resetArray(GEMS_FP_FALL_SPEED, 0);
        Util.resetArray(GEMS_FP_FALL_OFFSET, 0);
        Util.resetArray(GEMS_FP_OFFSET_X, 0);
        Util.resetArray(GEMS_FP_OFFSET_Y, 0);
        Util.resetArray(GEMS_FP_OFFSET_TOTAL, 0);
        Util.resetArray(GEMS_FP_MOVE_PER_FRAME, 0);
        Util.resetArray(GEMS_FLAGS, 0L);
        m_bFinishTransition = false;
        m_nLevelFillPulseFrame = 0;
        Util.resetArray(GEMS_CURRENT_FRAME, 0);
        Util.resetArray(TILES_CURRENT_FRAME, 0);
        Util.resetArray(OVERLAYS_CURRENT_FRAME, 0);
        m_nGemsDestroyedFrame = -1;
        m_nDisplayNumGemsDestroyed = 0;
        m_bAnimationResolved = false;
        m_nCursorFrame = 0;
        m_nCursorWaitFrame = 0;
        m_nCursorFrameSkip = 0;
        m_nCursorBackgroundFrame = 0;
        m_nCursorAnim = 0;
        m_nCursorAnimCycles = 0;
        HUDController.m_nDisplayChainsCurrent = 0;
        HUDController.m_nDisplayChainMultiplier = 0;
        Util.resetArray(FADE_TILES, -1000);
        m_nColourModifier = 0;
        m_nGetGemPosX = -1;
        m_nGetGemPosY = -1;
        Util.resetArray(GEMS_NEXT_ANIM_STATE, -1);
        Util.resetArray(GEMS_NEXT_ANIM_STATE_DELAY, -1);
        m_lGemsDelayedAnimState = 0L;
        Util.resetArray(GemAnimation.GEM_ANIM_FRAME_COUNT, -1);
        m_lAnimatedLightningsExploded = -1L;
        m_nAnimatedLightningFrame = 0;
        m_lSuperLightningUp = 0L;
        m_lSuperLightningDown = 0L;
        m_lSuperLightningLeft = 0L;
        m_lSuperLightningRight = 0L;
        m_nFruitIdleSparkleFrame = 0;
        m_lFruitIdleToSparkle = 0L;
        m_nCoalIdleFrame = 0;
        Util.resetArray(COUNTDOWN_PULSE_CHANCE, 0);
        lBoardFadedRows = 0L;
        m_nBoardFadeFrame = -1;
        Particles.lPlasmaParticleGems = 0L;
        Particles.recycleParticles(true);
        Util.resetArray(VECTOR_COUNTDOWN_PULSE_FRAMES, -1);
        Util.resetArray(VECTOR_COUNTDOWN_PULSE_COL, -1);
        Util.resetArray(VECTOR_COUNTDOWN_PULSE_TIMES, -1);
        Util.resetArray(COUNTDOWN_FONT_FRAME, 0);
        m_nRemainingWisps = 0;
        m_nRemainingWispGem = -1;
        m_nRemainingWispsFrame = 0;
    }

    static final void resetStars() {
        Util.resetArray(backgroundStarPosX, 0);
        Util.resetArray(backgroundStarPosY, 0);
        Util.resetArray(Starfield.starPosX, 0);
        Util.resetArray(Starfield.starPosY, 0);
        Util.resetArray(Starfield.starPosZ, 0);
        Util.resetArray(Starfield.starColour, 0);
        Starfield.STARGEN_AREA_WIDTH = 80;
        Starfield.STAR_SPEED = 0;
        Starfield.STAR_SPEEDY = 0;
        Starfield.STAR_SPEEDX = 0;
        Starfield.m_nStarAppearHeight = 0;
        Starfield.m_nStarAppearWidth = 0;
    }

    static final void updateAnims() {
        if (!GameController.m_bReplaying) {
            Background.updateBackground();
        }
        GCanvasController.updateLightningAnim();
        GCanvasController.updateGemsNextAnimState();
        Particles.handleParticles();
        Particles.recycleParticles(false);
        GameController.updateLevelbar();
        BoardTexts.recycleScoreTexts();
        BoardTexts.updateScoreTexts();
        GCanvasController.updateFrameCounters();
        GCanvasController.updateCursorAnim();
        GCanvasController.randomGlowCoals();
        HUDController.updateHudAnims();
        GCanvasController.updateFruitIdleSparkle();
        GCanvasController.randomPulseCountDownGems();
        GCanvasController.updateSoftkeyDirtyRect();
        if (m_nRemainingWisps > 0 && ++m_nRemainingWispsFrame % 2 == 0) {
            --m_nRemainingWisps;
            GModel.handleChainMeter(true, false);
            HUDController.incHudChainLight();
        }
    }

    static final void updateFrameCounters() {
        if (++m_nLevelFillPulseFrame >= 11) {
            m_nLevelFillPulseFrame = 0;
        }
        GCanvasController.updateFadeTiles();
    }

    static final void updateFadeTiles() {
        for (int i = 0; i < 64; ++i) {
            if (FADE_TILES[i] == -1000) continue;
            int n = i;
            FADE_TILES[n] = FADE_TILES[n] + 1;
            GCanvasController.addDirtyGem(i);
            if (FADE_TILES[i] != 25) continue;
            GCanvasController.FADE_TILES[i] = -1000;
        }
    }

    static final void setCursorAnim(int n, int n2, int n3) {
        m_nCursorAnim = n;
        m_nCursorFrame = n2;
        m_nCursorAnimCycles = n3;
        m_nCursorFrameSkip = 0;
    }

    static final void updateCursorAnim() {
        if (GameController.m_nBoardStateFrame % 2 == 0 && ++m_nCursorBackgroundFrame >= 9) {
            m_nCursorBackgroundFrame = 0;
        }
        if (m_nCursorAnim == 0) {
            if (m_nCursorFrame >= 0) {
                if (++m_nCursorFrameSkip % 2 == 0 && ++m_nCursorFrame > GCanvas.CURSOR_SEQUENCES_PULSE.length - 1 + "\u0143\u013f\u013a".length() - 1) {
                    m_nCursorFrame = -1;
                    m_nCursorWaitFrame = 10;
                }
            } else if (m_nCursorWaitFrame >= 0 && --m_nCursorWaitFrame < 0) {
                m_nCursorFrameSkip = 0;
                m_nCursorFrame = 0;
            }
        } else if (m_nCursorAnim == 1) {
            if (++m_nCursorFrameSkip % 2 == 0 && ++m_nCursorFrame > GraphicsUtil.getPingPongMaxFrame("\u0143\u013f\u013a".length())) {
                m_nCursorFrame = 0;
                if (--m_nCursorAnimCycles <= 0) {
                    GCanvasController.setCursorAnim(0, 0, -1);
                }
            }
        } else if (m_nCursorAnim == 2 && ++m_nCursorFrame > GraphicsUtil.getPingPongMaxFrame("\u0147\u00b3\u00af\u00a9".length())) {
            m_nCursorFrame = 0;
            if (--m_nCursorAnimCycles <= 0) {
                GCanvasController.setCursorAnim(0, 0, -1);
            }
        }
    }

    static final void addDirtyCursor(int n, int n2) {
        int n3 = Math.abs(n2 - GameController.m_nCursorY);
        int n4 = Math.abs(n - GameController.m_nCursorX);
        n = GCanvas.BOARD_POSITION_X + Math.min(GameController.m_nCursorX, n) * 44;
        n2 = GCanvas.BOARD_POSITION_Y + Math.min(GameController.m_nCursorY, n2) * 44;
        DirtyRect.addDirty(n += (short)"\ufff9\r\u0005\ufffa,\ufffaH\rH-,M\u0005M\ufff9-".charAt(0), n2 += (short)"\ufff9\r\u0005\ufffa,\ufffaH\rH-,M\u0005M\ufff9-".charAt(1) - Graphic.GetImageHeight(290), GCanvas.CURSOR_QUAD_W * (2 + n4) + 0, GCanvas.CURSOR_QUAD_W * (2 + n3) + 0);
    }

    static final void setGemTileAnim(long l, int n) {
        int n2 = Util.findNextSetBit(l, 0);
        int n3 = 0;
        while (n2 != -1) {
            n3 = GModel.getGemColour(1L << n2);
            GCanvasController.FADE_TILES[n2] = n;
            GCanvasController.FADE_TILES[n2 + 64] = TILE_FADE_COLS[n3];
            n2 = Util.findNextSetBit(l, n2 + 1);
        }
    }

    static final void setGemAnimation(int n, int n2, int n3) {
        long l = 1L << n;
        if (n2 == 29 && GModel.getSpecialState(l, true, true, true) != -1) {
            GCanvasController.GEMS_NEXT_ANIM_STATE[n] = -1;
            GCanvasController.GEMS_NEXT_ANIM_STATE_DELAY[n] = -1;
            m_lGemsDelayedAnimState &= l ^ 0xFFFFFFFFFFFFFFFFL;
            GemAnimation.GEM_ANIM_FRAME_COUNT[n] = -1;
            return;
        }
        int n4 = n2 - 23;
        int n5 = GCanvasController.getCurrentGemAnimation(n);
        if (n5 == 32 || (GModel.BOARD[16] & l) != 0L) {
            Particles.killPlasmaParticles(n);
        }
        int n6 = n5 - 23;
        if (n3 < 0) {
            GCanvasController.setGemsNextAnimState(n, n2, Math.abs(n3));
            return;
        }
        if (GameController.m_nCurrentState != 2) {
            if (n2 == 24 || n2 == 31 || n2 == 32) {
                SoundManager.handleSoundEvent(32);
            } else if (n2 == 26) {
                SoundManager.handleSoundEvent(50);
            }
        }
        GCanvasController.GEMS_NEXT_ANIM_STATE[n] = -1;
        GCanvasController.GEMS_NEXT_ANIM_STATE_DELAY[n] = -1;
        m_lGemsDelayedAnimState &= l ^ 0xFFFFFFFFFFFFFFFFL;
        GemAnimation.GEM_ANIM_FRAME_COUNT[n] = -1;
        int n7 = Util.findNextSetBit(GemAnimation.ANIMATION_STATE_PARTICLES[n6], 0);
        if (n7 == 1) {
            n7 = Util.findNextSetBit(GemAnimation.ANIMATION_STATE_PARTICLES[n6], n7 + 1);
            while (n7 != -1 && n7 != 0) {
                GCanvasController.setGemAnimationParticles(n, n7);
                n7 = Util.findNextSetBit(GemAnimation.ANIMATION_STATE_PARTICLES[n6], n7 + 1);
            }
        }
        n7 = Util.findNextSetBit(GemAnimation.ANIMATION_STATE_PARTICLES[n4], 0);
        while (n7 != -1 && n7 != 0 && n7 != 1) {
            GCanvasController.setGemAnimationParticles(n, n7);
            n7 = Util.findNextSetBit(GemAnimation.ANIMATION_STATE_PARTICLES[n4], n7 + 1);
        }
        int n8 = 23;
        while (n8 < 61) {
            int n9 = n8++;
            GModel.BOARD[n9] = GModel.BOARD[n9] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int n10 = n2;
        GModel.BOARD[n10] = GModel.BOARD[n10] | l;
        GCanvasController.GEMS_CURRENT_FRAME[n] = n3;
        GCanvasController.TILES_CURRENT_FRAME[n] = 0;
        GCanvasController.OVERLAYS_CURRENT_FRAME[n] = 0;
        GCanvasController.addDirtyGem(n);
    }

    static final void setGemAnimationParticles(int n, int n2) {
        if (n2 == 9) {
            GCanvasController.setGemTileAnim(1L << n, 0);
        } else if (n2 == 2 && GameController.m_nCurrentState != 2) {
            Particles.setupParticles(15, n2, n, -1, -1, -1);
        } else if (n2 == 5 && GameController.m_nCurrentState != 2 && GameController.m_nCurrentState != 8 && GameController.m_nGameMode != 2) {
            Particles.setupParticles(Util.GetRandom(3, GModel.TWIST_LOGIC_RANDOMER) + 1, n2, n, -1, -1, -1);
        } else if (n2 == 7) {
            Particles.setupParticles(5, n2, n, -1, -1, -1);
        } else if (n2 == 8 && GameController.m_nCurrentState != 2) {
            Particles.setupParticles(40, n2, n, -1, -1, -1);
        } else if (n2 == 3) {
            Particles.setupParticles(15, n2, n, -1, -1, -1);
        } else if (n2 == 10) {
            Particles.setupParticles(15, n2, n, -1, -1, -1);
        } else if (n2 == 11) {
            Particles.setupParticles(3, 10, n, -1, -1, -1);
        } else if (n2 == 4 && GameController.m_nCurrentState != 2) {
            Particles.setupParticles(16, n2, n, -1, -1, -1);
        } else if (n2 == 13) {
            Particles.setupParticles(2, n2, n, -1, -1, -1);
        } else if (n2 == 22) {
            Particles.setupParticles(7, n2, n, -1, -1, -1);
        } else if (n2 == 24) {
            Particles.setupParticles(8, 24, n, -1, -1, 5);
        }
    }

    static final void setGemsBitfieldAnimation(long l, int n, int n2) {
        int n3 = Util.findNextSetBit(l, 0);
        while (n3 != -1 && n3 < 64) {
            GCanvasController.setGemAnimation(n3, n, n2);
            n3 = Util.findNextSetBit(l, n3 + 1);
        }
    }

    static final int getCurrentGemAnimation(int n) {
        for (int i = 23; i < 61; ++i) {
            if ((1L << n & GModel.BOARD[i]) <= 0L) continue;
            return i;
        }
        return 23;
    }

    static final void updateGlintGems(int n, boolean bl) {
    }

    static final boolean updateGem(int n) {
        long l = 1L << n;
        int n2 = GCanvasController.getAnimationArrayOffsetState(n);
        int n3 = GModel.getGemColour(l);
        if (n2 != -1 && n3 >= 0 && n3 < GemAnimation.GEM_SEQUENCES[n2].length()) {
            boolean bl = false;
            int n4 = GemAnimation.ANIMATION_NEXT_STATE[n2];
            int n5 = GemAnimation.ANIMATION_LAYER_CONTROLLER[n2];
            bl = n5 == 1;
            boolean bl2 = GCanvasController.updateGemLayerAnimationFrame(n, n4, n2, GemAnimation.TILE_ANIMATION_TYPE[n2], GemAnimation.TILE_NUM_FRAMES[n2], TILES_CURRENT_FRAME, bl);
            bl = n5 == 0;
            boolean bl3 = GCanvasController.updateGemLayerAnimationFrame(n, n4, n2, GemAnimation.GEM_ANIMATION_TYPES[n2], GemAnimation.GEM_NUM_FRAMES[n2], GEMS_CURRENT_FRAME, bl);
            bl = n5 == 2;
            boolean bl4 = GCanvasController.updateGemLayerAnimationFrame(n, n4, n2, GemAnimation.OVERLAY_ANIMATION_TYPE[n2], GemAnimation.OVERLAY_NUM_FRAMES[n2], OVERLAYS_CURRENT_FRAME, bl);
            if (bl2 || bl3 || bl4) {
                GCanvasController.addDirtyGem(n);
            }
            return true;
        }
        return false;
    }

    static final boolean updateGemLayerAnimationFrame(int n, int n2, int n3, long l, int n4, int[] nArray, boolean bl) {
        int n5 = nArray[n];
        boolean bl2 = false;
        boolean bl3 = true;
        if (bl && GemAnimation.TOTAL_ANIM_FRAMES[n3] != -1) {
            bl3 = false;
            int n6 = n;
            GemAnimation.GEM_ANIM_FRAME_COUNT[n6] = GemAnimation.GEM_ANIM_FRAME_COUNT[n6] + 1;
            if (GemAnimation.GEM_ANIM_FRAME_COUNT[n6] >= GemAnimation.TOTAL_ANIM_FRAMES[n3]) {
                bl2 = true;
            }
        }
        boolean bl4 = true;
        if ((l & 0x10L) != 0L) {
            bl4 = GameController.m_nBoardStateFrame % 2 == 0;
        } else if ((l & 0x20L) != 0L) {
            bl4 = GameController.m_nBoardStateFrame % 3 == 0;
        } else if ((l & 0x40L) != 0L) {
            bl4 = GameController.m_nBoardStateFrame % 4 == 0;
        } else if ((l & 0x2000L) != 0L) {
            bl4 = GameController.m_nBoardStateFrame % 10 == 0;
        }
        if (bl4) {
            if ((l & 1L) != 0L) {
                int n7 = n;
                nArray[n7] = nArray[n7] + 1;
            } else if ((l & 2L) != 0L) {
                int n8 = n;
                nArray[n8] = nArray[n8] + 1;
                n4 = n4 * 2 - 2;
            } else if ((l & 8L) != 0L) {
                nArray[n] = 0;
            } else if ((l & 4L) != 0L) {
                nArray[n] = Util.GetRandom(n4);
            } else if ((l & 0x1000L) != 0L) {
                int n9 = n;
                nArray[n9] = nArray[n9] + 1;
                if (Util.GetRandom(10) == 0) {
                    int n10 = n;
                    nArray[n10] = nArray[n10] + 1;
                }
            } else {
                int n11 = n;
                nArray[n11] = nArray[n11] + 1;
            }
        }
        if (nArray[n] >= n4 || bl2) {
            if (bl && n2 != -1 && bl3 && GEMS_NEXT_ANIM_STATE[n] == -1 || bl2) {
                if (n2 < 0) {
                    if (n2 == -2) {
                        GCanvasController.setGemAnimation(n, 28, 0);
                        GCanvasController.setGemTileAnim(1L << n, 0);
                    }
                } else {
                    GCanvasController.setGemAnimation(n, n2, 0);
                }
            } else {
                nArray[n] = 0;
            }
        }
        return nArray[n] != n5;
    }

    static final void updateBoard() {
        if (GameController.m_nCurrentState == 6) {
            m_bAnimationResolved = true;
            GCanvasController.updateCountdownVectorPulses(true);
            GCanvasController.updateDirtyFallingGridGems();
        }
        for (int i = 0; i < 64; ++i) {
            long l = 1L << i;
            if (GameController.m_nCurrentState == 6 && m_bAnimationResolved && GCanvasController.getGemPosition(i, false, true)) {
                m_bAnimationResolved = false;
            }
            if (GEMS_FP_OFFSET_TOTAL[i] != 0) {
                GCanvasController.updateGemsPushedOut(i);
            }
            if (!GCanvasController.updateGem(i)) {
                // empty if block
            }
            if (GameController.m_nCurrentState == 7 || GameController.m_nCurrentState == 14) continue;
            if (GEMS_FP_FALL_SPEED[i] != 0 || GEMS_FP_FALL_OFFSET[i] != 0) {
                GCanvasController.getGemPosition(i, false, true);
                int n = m_nGetGemPosX;
                int n2 = m_nGetGemPosY;
                int n3 = i;
                GEMS_FP_FALL_SPEED[n3] = GEMS_FP_FALL_SPEED[n3] + GModel.GEM_FP_GRAVITY;
                if (GEMS_FP_FALL_SPEED[i] > GCanvas.GEM_FP_MAX_GEM_FALL_SPEED) {
                    GCanvasController.GEMS_FP_FALL_SPEED[i] = GCanvas.GEM_FP_MAX_GEM_FALL_SPEED;
                }
                int n4 = i;
                GEMS_FP_FALL_OFFSET[n4] = GEMS_FP_FALL_OFFSET[n4] + GEMS_FP_FALL_SPEED[i];
                GCanvasController.addDirtyMovingGem(i, n, n2);
                continue;
            }
            if (GModel.getGemProperty(l, 17)) {
                GCanvasController.addDirtyGem(i);
                continue;
            }
            if (GModel.getGemProperty(l, 18)) {
                GCanvasController.addDirtyGem(i);
                continue;
            }
            if (GModel.getGemProperty(l, 19)) {
                GCanvasController.addDirtyGem(i);
                continue;
            }
            if (!GModel.getGemProperty(l, 20)) continue;
            GCanvasController.addDirtyGem(i);
        }
        GCanvasController.updateCountdownVectorPulses(false);
        GCanvasController.updateCountdownFont(13);
        GCanvasController.updateCountdownFont(14);
    }

    static final void updateGemsPushedOut(int n) {
        GCanvasController.getGemPosition(n, false, true);
        int n2 = m_nGetGemPosX;
        int n3 = m_nGetGemPosY;
        int n4 = GEMS_FP_MOVE_PER_FRAME[n];
        boolean bl = false;
        boolean bl2 = false;
        if ((GEMS_FLAGS[n] & 0x10L) == 0L) {
            if (GEMS_OFFSET_DELAY[n] > 0) {
                GCanvasController.GEMS_OFFSET_DELAY[n] = Math.max(GEMS_OFFSET_DELAY[n] - 1, 0);
                if (GEMS_OFFSET_DELAY[n] > 0) {
                    return;
                }
            }
        } else {
            int n5 = n;
            GEMS_OFFSET_DELAY[n5] = GEMS_OFFSET_DELAY[n5] - 1;
            if (GEMS_OFFSET_DELAY[n5] == 0) {
                GCanvasController.resetPushedOutGem(n);
            } else {
                int n6 = FP.fpDiv(GEMS_FP_OFFSET_TOTAL[n], 2048);
                GCanvasController.GEMS_FP_OFFSET_Y[n] = Particles.randFPValueAsFP(0, GEMS_FP_OFFSET_TOTAL[n]) - n6;
                GCanvasController.GEMS_FP_OFFSET_X[n] = Particles.randFPValueAsFP(0, GEMS_FP_OFFSET_TOTAL[n]) - n6;
            }
            GCanvasController.addDirtyMovingGem(n, n2, n3);
            return;
        }
        if ((GEMS_FLAGS[n] & 8L) == 0L) {
            if ((GEMS_FLAGS[n] & 1L) != 0L) {
                bl = true;
                n4 = CASCADE_FP_DEC;
            } else {
                n4 = CASCADE_FP_INC;
            }
        }
        if ((GEMS_FLAGS[n] & 2L) != 0L) {
            if (bl) {
                GCanvasController.GEMS_FP_OFFSET_X[n] = GEMS_FP_OFFSET_TOTAL[n] > 0 ? Math.max(0, GEMS_FP_OFFSET_X[n] - n4) : Math.min(0, GEMS_FP_OFFSET_X[n] + n4);
                if (GEMS_FP_OFFSET_X[n] == 0) {
                    int n7 = n;
                    GEMS_FLAGS[n7] = GEMS_FLAGS[n7] & 0xFFFFFFFFFFFFFFFDL;
                }
            } else {
                GCanvasController.GEMS_FP_OFFSET_X[n] = GEMS_FP_OFFSET_TOTAL[n] > 0 ? Math.min(GEMS_FP_OFFSET_TOTAL[n], GEMS_FP_OFFSET_X[n] + n4) : Math.max(GEMS_FP_OFFSET_TOTAL[n], GEMS_FP_OFFSET_X[n] - n4);
                if (GEMS_FP_OFFSET_X[n] == GEMS_FP_OFFSET_TOTAL[n]) {
                    if ((GEMS_FLAGS[n] & 8L) != 0L) {
                        bl2 = true;
                    } else {
                        int n8 = n;
                        GEMS_FLAGS[n8] = GEMS_FLAGS[n8] | 1L;
                    }
                }
            }
        }
        if ((GEMS_FLAGS[n] & 4L) != 0L) {
            if (bl) {
                GCanvasController.GEMS_FP_OFFSET_Y[n] = GEMS_FP_OFFSET_TOTAL[n] > 0 ? Math.max(0, GEMS_FP_OFFSET_Y[n] - n4) : Math.min(0, GEMS_FP_OFFSET_Y[n] + n4);
                if (GEMS_FP_OFFSET_Y[n] == 0) {
                    int n9 = n;
                    GEMS_FLAGS[n9] = GEMS_FLAGS[n9] & 0xFFFFFFFFFFFFFFFBL;
                }
            } else {
                GCanvasController.GEMS_FP_OFFSET_Y[n] = GEMS_FP_OFFSET_TOTAL[n] > 0 ? Math.min(GEMS_FP_OFFSET_TOTAL[n], GEMS_FP_OFFSET_Y[n] + n4) : Math.max(GEMS_FP_OFFSET_TOTAL[n], GEMS_FP_OFFSET_Y[n] - n4);
                if (GEMS_FP_OFFSET_Y[n] == GEMS_FP_OFFSET_TOTAL[n]) {
                    if ((GEMS_FLAGS[n] & 8L) != 0L) {
                        bl2 = true;
                    } else {
                        int n10 = n;
                        GEMS_FLAGS[n10] = GEMS_FLAGS[n10] | 1L;
                    }
                }
            }
        }
        if (bl2 || (GEMS_FLAGS[n] & 2L) == 0L && (GEMS_FLAGS[n] & 4L) == 0L) {
            GCanvasController.resetPushedOutGem(n);
        }
        GCanvasController.addDirtyMovingGem(n, n2, n3);
    }

    static final void resetPushedOutGem(int n) {
        GCanvasController.GEMS_FP_OFFSET_TOTAL[n] = 0;
        GCanvasController.GEMS_FP_OFFSET_X[n] = 0;
        GCanvasController.GEMS_FP_OFFSET_Y[n] = 0;
    }

    static final void pushGemsUp(long l) {
    }

    static final void pushSurroundingGemsOut(int n) {
        long l = -1L;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = FP.fpMul(CASCADE_FP_PUSH, 1024 * n);
        for (int i = 0; i < GModel.m_nMatchesCount; ++i) {
            l = GModel.MATCHES[i];
            n2 = Util.findNextSetBit(l, 0);
            while (n2 != -1) {
                n4 = n2 / 8;
                n3 = n2 % 8;
                if (n3 > 0) {
                    GCanvasController.pushGemOut(n2 - 1, -n5, 0, -n5, 0, 0L, false, 0);
                }
                if (n3 < 7 && n2 + 1 < 64) {
                    GCanvasController.pushGemOut(n2 + 1, n5, 0, n5, 0, 0L, false, 0);
                }
                if (n4 > 0) {
                    GCanvasController.pushGemOut(n2 - 8, 0, -n5, -n5, 0, 0L, false, 0);
                }
                if (n4 < 7 && n2 + 8 < 64) {
                    GCanvasController.pushGemOut(n2 + 8, 0, n5, n5, 0, 0L, false, 0);
                }
                n2 = Util.findNextSetBit(l, n2 + 1);
            }
        }
    }

    static final void pushGemOut(int n, int n2, int n3, int n4, int n5, long l, boolean bl, int n6) {
        if (n < 0) {
            return;
        }
        if (bl || (GModel.BOARD[21] & 1L << n) == 0L && (GModel.m_lSpecialGemsNewlyCreated & 1L << n) == 0L && GEMS_FP_OFFSET_X[n] == 0 && GEMS_FP_OFFSET_Y[n] == 0) {
            GCanvasController.GEMS_FP_OFFSET_X[n] = 0;
            GCanvasController.GEMS_FP_OFFSET_Y[n] = 0;
            GCanvasController.GEMS_FP_OFFSET_TOTAL[n] = n4;
            GCanvasController.GEMS_FLAGS[n] = l;
            GCanvasController.GEMS_OFFSET_DELAY[n] = Math.abs(n5);
            GCanvasController.GEMS_FP_MOVE_PER_FRAME[n] = n6;
            if (n2 != 0) {
                int n7 = n;
                GEMS_FLAGS[n7] = GEMS_FLAGS[n7] | 2L;
            }
            if (n3 != 0) {
                int n8 = n;
                GEMS_FLAGS[n8] = GEMS_FLAGS[n8] | 4L;
            }
        }
    }

    static final void getGridPos(int n) {
        GCanvasController.getGemPosition(n, true, false);
    }

    static final boolean getGemPosition(int n, boolean bl, boolean bl2) {
        int n2 = n % 8;
        int n3 = n / 8;
        boolean bl3 = false;
        if (bl) {
            m_nGetGemPosX = GCanvas.BOARD_POSITION_X + n2 * 44;
            m_nGetGemPosY = GCanvas.BOARD_POSITION_Y + n3 * 44;
            return bl3;
        }
        int n4 = 0;
        int n5 = 0;
        if (bl2) {
            long l = 1L << n;
            if (GameController.m_nCurrentState == 4 || GameController.m_nCurrentState == 11) {
                if ((GModel.BOARD[17] & l) != 0L) {
                    n5 = Math.abs(GModel.m_nMoveOffset) - 44;
                } else if ((GModel.BOARD[18] & l) != 0L) {
                    n5 = -Math.abs(GModel.m_nMoveOffset) + 44;
                } else if ((GModel.BOARD[19] & l) != 0L) {
                    n4 = -Math.abs(GModel.m_nMoveOffset) + 44;
                } else if ((GModel.BOARD[20] & l) != 0L) {
                    n4 = Math.abs(GModel.m_nMoveOffset) - 44;
                }
            } else {
                if (GEMS_FP_FALL_SPEED[n] != 0 || GEMS_FP_FALL_OFFSET[n] != 0) {
                    n4 = FP.toInt(GEMS_FP_FALL_OFFSET[n]);
                }
                int n6 = 0;
                int n7 = 0;
                if (GModel.BOARD_RESOLUTION_MOVES[n] >= 0) {
                    if (GModel.BOARD_RESOLUTION_MOVES[n] == 0) {
                        n4 = 0;
                    } else if (n4 >= GModel.BOARD_RESOLUTION_MOVES[n] * 44) {
                        n4 = 0;
                    } else {
                        n4 = -(GModel.BOARD_RESOLUTION_MOVES[n] * 44) + n4;
                        bl3 = true;
                    }
                } else {
                    n7 = -GModel.BOARD_RESOLUTION_MOVES[n] >> 16;
                    n6 = -GModel.BOARD_RESOLUTION_MOVES[n] & 0xFFFF;
                    if ((n4 -= n7 * GCanvas.GEM_FALL_GAP) > n6 * 44) {
                        n4 = 0;
                    } else {
                        n4 = -(44 * n6) + n4;
                        bl3 = true;
                    }
                }
                if (GEMS_FP_OFFSET_TOTAL[n] != 0 && (GEMS_OFFSET_DELAY[n] == 0 || (GEMS_FLAGS[n] & 0x10L) != 0L)) {
                    n5 += FP.toInt(GEMS_FP_OFFSET_X[n]);
                    n4 += FP.toInt(GEMS_FP_OFFSET_Y[n]);
                    bl3 = true;
                }
            }
        }
        m_nGetGemPosX = GCanvas.BOARD_POSITION_X + n5 + n2 * 44 + GCanvas.GRID_GEM_WIDTHDIFF;
        m_nGetGemPosY = GCanvas.BOARD_POSITION_Y + n4 + n3 * 44 + GCanvas.GRID_GEM_WIDTHDIFF;
        return bl3;
    }

    static final void addDirtyMovingGem(int n, int n2, int n3) {
        GCanvasController.getGemPosition(n, false, true);
        int n4 = Math.min(m_nGetGemPosX, n2);
        int n5 = Math.min(m_nGetGemPosY, n3);
        int n6 = Math.max(m_nGetGemPosX, n2);
        int n7 = Math.max(m_nGetGemPosY, n3);
        int n8 = Math.abs(n6 - n4) + GCanvas.GEM_WIDTH;
        int n9 = Math.abs(n7 - n5) + GCanvas.GEM_WIDTH;
        int n10 = GCanvas.BOARD_POSITION_X;
        int n11 = n10 + 352;
        int n12 = GCanvas.BOARD_POSITION_Y;
        int n13 = n12 + 352;
        if (n4 + n8 < n10 || n4 > n11 || n5 + n9 < n12 || n5 > n13) {
            return;
        }
        if (n4 < n10) {
            n8 -= Math.abs(n10 - n4);
            n4 = n10;
        } else if (n4 + n8 > n11) {
            n8 = Math.abs(n11 - n4);
        }
        if (n5 < n12) {
            n9 -= Math.abs(n12 - n5);
            n5 = n12;
        } else if (n5 + n9 > n13) {
            n9 = Math.abs(n13 - n5);
        }
        DirtyRect.addDirty(n4, n5, n8, n9);
    }

    static final void addDirtyGem(int n) {
        int n2;
        int n3;
        GCanvasController.getGemPosition(n, false, true);
        int n4 = GCanvasController.getAnimationArrayOffsetState(n);
        int n5 = m_nGetGemPosX;
        int n6 = m_nGetGemPosY;
        int n7 = 0;
        int n8 = 0;
        long l = 1L << n;
        int n9 = GModel.getGemColour(l);
        if (n9 >= 0) {
            if (GameController.m_nCurrentState == 2 && (0x7FL & 1L << GameController.m_nLevelUpState) != 0L) {
                return;
            }
            n3 = Math.max(GemAnimation.GEM_FRAME_WIDTHS[n4], Math.max(GemAnimation.TILE_FRAME_WIDTHS[n4], GemAnimation.OVERLAY_FRAME_WIDTHS[n4]));
            if (n4 != -1 && n3 != -1) {
                n2 = Math.max(GemAnimation.GEM_FRAME_WIDTHS[n4], Math.max(GemAnimation.TILE_FRAME_WIDTHS[n4], GemAnimation.OVERLAY_FRAME_WIDTHS[n4]));
                n7 = n3;
                n8 = n2;
            } else if (FADE_TILES[n] != -1000 || n4 + 23 == 49 || n4 + 23 == 60) {
                n7 = 44;
                n8 = 44;
            } else {
                return;
            }
        }
        n3 = GCanvas.BOARD_POSITION_X;
        n2 = n3 + 352;
        int n10 = GCanvas.BOARD_POSITION_Y;
        int n11 = n10 + 352;
        if ((n5 -= (n7 - 44) / 2) + n7 < n3 || n5 > n2 || (n6 -= (n8 - 44) / 2) + n8 < n10 || n6 > n11) {
            return;
        }
        if (n5 < n3) {
            n7 -= Math.abs(n3 - n5);
            n5 = n3;
        } else if (n5 + n7 > n2) {
            n7 = Math.abs(n2 - n5);
        }
        if (n6 < n10) {
            n8 -= Math.abs(n10 - n6);
            n6 = n10;
        } else if (n6 + n8 > n11) {
            n8 = Math.abs(n11 - n6);
        }
        DirtyRect.addDirty(n5, n6, n7, n8);
    }

    static final void updateDirtyGems() {
        if (DirtyRect.m_nDirtyIndex > -1) {
            GCanvasController.copyAllDirtyDataToDirtyGemData();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = DirtyRect.m_nDirtyGemIndex;
            int n8 = 0;
            int n9 = GCanvas.GEM_WIDTH - 1;
            while (n7 >= 0) {
                n3 = DirtyRect.DIRTY_GEM_DATA[n7 + 0];
                n4 = DirtyRect.DIRTY_GEM_DATA[n7 + 1];
                n5 = DirtyRect.DIRTY_GEM_DATA[n7 + 2] - 1;
                n6 = DirtyRect.DIRTY_GEM_DATA[n7 + 3] - 1;
                for (int i = 0; i < 64; ++i) {
                    GCanvasController.getGemPosition(i, false, true);
                    n = m_nGetGemPosX;
                    n2 = m_nGetGemPosY;
                    if ((n >= n3 && n <= n3 + n5 || n3 >= n && n3 <= n + n9) && (n2 >= n4 && n2 <= n4 + n6 || n4 >= n2 && n4 <= n2 + n9)) {
                        int n10 = n8;
                        DirtyRect.DIRTY_RECT_GEM_LIST[n10] = DirtyRect.DIRTY_RECT_GEM_LIST[n10] | 1L << i;
                    }
                    if (FADE_TILES[i] != -1000) continue;
                    GCanvasController.getGemPosition(i, true, false);
                    n = m_nGetGemPosX;
                    n2 = m_nGetGemPosY;
                    if ((n < n3 || n > n3 + n5) && (n3 < n || n3 > n + n9) || (n2 < n4 || n2 > n4 + n6) && (n4 < n2 || n4 > n2 + n9)) continue;
                    int n11 = n8;
                    DirtyRect.DIRTY_RECT_GRID_LIST[n11] = DirtyRect.DIRTY_RECT_GRID_LIST[n11] | 1L << i;
                }
                n7 -= 4;
                ++n8;
            }
        }
    }

    static final void copyAllDirtyDataToDirtyGemData() {
        Util.resetArray(DirtyRect.DIRTY_GEM_DATA, 0);
        System.arraycopy(DirtyRect.DIRTY, 0, DirtyRect.DIRTY_GEM_DATA, 0, DirtyRect.m_nDirtyIndex + 4);
        DirtyRect.m_nDirtyGemIndex = DirtyRect.m_nDirtyIndex;
    }

    static final void redrawEverything() {
        DirtyRect.addDirty(0, 0, GCanvas.WORLD_WIDTH, GCanvas.WORLD_HEIGHT);
        GCanvasController.updateDirtyGems();
    }

    static final void setGemsNextAnimState(int n, int n2, int n3) {
        GCanvasController.GEMS_NEXT_ANIM_STATE[n] = n2;
        GCanvasController.GEMS_NEXT_ANIM_STATE_DELAY[n] = Math.abs(n3);
        m_lGemsDelayedAnimState |= 1L << n;
    }

    static final void updateGemsNextAnimState() {
        if (m_lGemsDelayedAnimState != 0L) {
            for (int i = 0; i < GEMS_NEXT_ANIM_STATE.length; ++i) {
                if (GEMS_NEXT_ANIM_STATE_DELAY[i] <= 0) continue;
                int n = i;
                GEMS_NEXT_ANIM_STATE_DELAY[n] = GEMS_NEXT_ANIM_STATE_DELAY[n] - 1;
                if (GEMS_NEXT_ANIM_STATE_DELAY[n] != 0 || GEMS_NEXT_ANIM_STATE[i] == -1) continue;
                GCanvasController.setGemAnimation(i, GEMS_NEXT_ANIM_STATE[i], 0);
                GCanvasController.GEMS_NEXT_ANIM_STATE[i] = -1;
                GCanvasController.GEMS_NEXT_ANIM_STATE_DELAY[i] = -1;
                m_lGemsDelayedAnimState &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }

    static final boolean bAllGemExplodeAnimsFinished() {
        int n = Util.findNextSetBit(2035063394423275520L, 0);
        while (n != -1) {
            if (GModel.BOARD[n] != 0L) {
                return false;
            }
            n = Util.findNextSetBit(2035063394423275520L, n + 1);
        }
        if (m_lGemsDelayedAnimState > 0L) {
            for (int i = 0; i < GEMS_NEXT_ANIM_STATE.length; ++i) {
                if (GEMS_NEXT_ANIM_STATE_DELAY[i] <= 0 || GEMS_NEXT_ANIM_STATE[i] == -1) continue;
                n = Util.findNextSetBit(2035063394423275520L, 0);
                while (n != -1) {
                    if (GEMS_NEXT_ANIM_STATE[i] == n) {
                        return false;
                    }
                    n = Util.findNextSetBit(2035063394423275520L, n + 1);
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final boolean bFruitExplosionAnimFinsihed() {
        if (GModel.m_lCurrentFruitExploding == -1L) return true;
        if (GModel.BOARD[59] != 0L || GModel.BOARD[47] != 0L || GModel.BOARD[46] != 0L || GModel.BOARD[44] != 0L || GModel.BOARD[45] != 0L) return false;
        if (m_lGemsDelayedAnimState == 0L) return true;
        for (int i = 0; i < GEMS_NEXT_ANIM_STATE.length; ++i) {
            if (GEMS_NEXT_ANIM_STATE[i] != 59 && GEMS_NEXT_ANIM_STATE[i] != 47 && GEMS_NEXT_ANIM_STATE[i] != 46 && GEMS_NEXT_ANIM_STATE[i] != 44 && GEMS_NEXT_ANIM_STATE[i] != 45) continue;
            return false;
        }
        return true;
    }

    static final boolean bAllGemsFinsihedPushedOut() {
        for (int i = 0; i < 64; ++i) {
            if (GEMS_FP_OFFSET_TOTAL[i] == 0) continue;
            return false;
        }
        return true;
    }

    static int getAnimationArrayOffsetState(int n) {
        if (GEMS_CURRENT_FRAME[n] < 0) {
            return 0;
        }
        for (int i = 23; i < 61; ++i) {
            if ((GModel.BOARD[i] & 1L << n) == 0L) continue;
            return i - 23;
        }
        return -1;
    }

    static final void setExplodeGemAnim(int n, int n2, int n3) {
        int n4 = -1;
        long l = 1L << n;
        if (n3 != -1) {
            n4 = n3;
        } else if ((GModel.BOARD[7] & l) != 0L) {
            n4 = 41;
        } else if ((GModel.BOARD[13] & l) != 0L) {
            n4 = 36;
            GCanvasController.pushGemsUp(GModel.getAllGemsAbove(n));
        } else {
            n4 = (GModel.BOARD[12] & l) != 0L && GameController.m_nCurrentState != 2 ? 43 : ((GModel.BOARD[8] & l) != 0L && GameController.m_nCurrentState != 2 ? 50 : ((GModel.BOARD[14] & l) != 0L ? 58 : (GameController.m_nCurrentState == 8 ? 53 : 40)));
        }
        if (n2 < 0) {
            GCanvasController.setGemsNextAnimState(n, n4, Math.abs(n2));
        } else {
            GCanvasController.setGemAnimation(n, n4, 0);
        }
    }

    static final void setExplodeGemsBitfieldAnim(long l, int n) {
        int n2 = Util.findNextSetBit(l, 0);
        while (n2 != -1 && n2 < 64) {
            GCanvasController.setExplodeGemAnim(n2, n, -1);
            n2 = Util.findNextSetBit(l, n2 + 1);
        }
    }

    static final void updateLightningAnim() {
        if (m_lAnimatedLightningsExploded != -1L && GModel.BOARD[37] == 0L && GModel.BOARD[38] == 0L && GModel.BOARD[42] == 0L) {
            if (m_lGemsDelayedAnimState != 0L) {
                for (int i = 0; i < GEMS_NEXT_ANIM_STATE.length; ++i) {
                    if (GEMS_NEXT_ANIM_STATE[i] != 42 && GEMS_NEXT_ANIM_STATE[i] != 37) continue;
                    return;
                }
            }
            m_lAnimatedLightningsExploded = -1L;
            m_lSuperLightningRight = 0L;
            m_lSuperLightningLeft = 0L;
            m_lSuperLightningDown = 0L;
            m_lSuperLightningUp = 0L;
            m_nAnimatedLightningFrame = 0;
        }
    }

    static final int getGemsTotalSequenceFramesRemaining(int n) {
        int n2 = -1;
        if (GEMS_NEXT_ANIM_STATE[n] != -1) {
            n2 += GEMS_NEXT_ANIM_STATE_DELAY[n];
        }
        int n3 = -1;
        while (n3 != -1) {
        }
        return n2;
    }

    static final void updateFruitIdleSparkle() {
        if (GModel.BOARD[12] != 0L) {
            if (GameController.m_nCurrentState == 2) {
                return;
            }
            int n = Util.bitsSetLong(GModel.BOARD[12]);
            int n2 = Math.max(100 - n * 10, 15);
            if ((m_nFruitIdleSparkleFrame = Math.min(m_nFruitIdleSparkleFrame + 1, n2 - 1)) > n2 / 2 && Util.GetRandom(n2 - m_nFruitIdleSparkleFrame) == 0) {
                int n3;
                m_nFruitIdleSparkleFrame = 0;
                if (m_lFruitIdleToSparkle == 0L) {
                    m_lFruitIdleToSparkle = GModel.BOARD[12];
                }
                if ((n3 = Util.findRandSetBit(m_lFruitIdleToSparkle)) != -1) {
                    m_lFruitIdleToSparkle &= 1L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
                    if ((GModel.BOARD[12] & 1L << n3) != 0L) {
                        Particles.setupParticles(10, 12, n3, -1, -1, -1);
                    }
                }
            }
        }
    }

    static final void randomGlowCoals() {
        int n;
        int n2 = Util.bitsSetLong(GModel.BOARD[7]);
        if (n2 > 0 && GameController.m_nCurrentState != 8 && (m_nCoalIdleFrame = Math.min(m_nCoalIdleFrame + 1, (n = Math.max(100 - n2 * 5, 15)) - 1)) > n / 2 && Util.GetRandom(n - m_nCoalIdleFrame) == 0 && GameController.m_nCurrentState == 3) {
            int n3;
            m_nCoalIdleFrame = 0;
            int n4 = Util.findRandSetBit(GModel.BOARD[7]);
            if (n4 != -1 && (n3 = GCanvasController.getCurrentGemAnimation(n4)) == 23 && (GModel.BOARD[21] & 1L << n4) == 0L) {
                GCanvasController.setGemAnimation(n4, 39, 0);
            }
        }
    }

    static void pulseCountDownGems() {
        long l = 0L;
        for (int i = 0; i < 64; ++i) {
            l = 1L << i;
            if ((GModel.BOARD[27] & l) == 0L && (GModel.BOARD[34] & l) == 0L || (GModel.BOARD[21] & l) != 0L || GModel.GEM_COUNTDOWN_MOVES[i] <= 0 || GEMS_NEXT_ANIM_STATE[i] != -1) continue;
            int n = (GModel.getCountdownGemStartValue(13) - (GModel.GEM_COUNTDOWN_MOVES[i] + 3)) / 2;
            n = Math.max(n, 1);
            n = Math.min(n, 5);
            GCanvasController.setCountdownVectorPulse(i, n, false, -1);
        }
    }

    static void randomPulseCountDownGems() {
        block9: {
            if (GameController.m_nCurrentState != 3) break block9;
            boolean bl = false;
            int n = Util.findNextSetBit(GModel.BOARD[13], 0);
            while (n != -1) {
                block10: {
                    block12: {
                        block11: {
                            if (GModel.GEM_COUNTDOWN_MOVES[n] <= 3 && Util.GetRandom(2) == 0) {
                                Particles.setupParticles(4, 14, n, -1, -1, -1);
                            }
                            if (GEMS_NEXT_ANIM_STATE[n] != -1) break block10;
                            if (COUNTDOWN_FONT_FRAME[n] >= 0) break block11;
                            int n2 = n;
                            COUNTDOWN_PULSE_CHANCE[n2] = COUNTDOWN_PULSE_CHANCE[n2] - 1;
                            if (COUNTDOWN_PULSE_CHANCE[n2] <= 0) break block12;
                        }
                        if (!bl) break block10;
                    }
                    GCanvasController.setGemAnimation(n, 34, 0);
                    if (GModel.GEM_COUNTDOWN_MOVES[n] <= 5 && VECTOR_COUNTDOWN_PULSE_FRAMES[n] == -1) {
                        GCanvasController.setCountdownVectorPulse(n, 1, true, -1);
                    } else {
                        GCanvasController.setCountdownVectorPulse(n, 0, true, -1);
                    }
                    GCanvasController.COUNTDOWN_PULSE_CHANCE[n] = 5;
                    if (!bl) {
                        bl = true;
                        n = -1;
                    }
                }
                n = Util.findNextSetBit(GModel.BOARD[13], n + 1);
            }
            if (bl || Util.bitsSetLong(GModel.BOARD[13]) == 0 && Util.bitsSetLong(GModel.BOARD[14]) > 0) {
                GCanvasController.randomPulseDoomGems(bl);
            }
        }
    }

    static void randomPulseDoomGems(boolean bl) {
        block3: {
            if (GameController.m_nCurrentState != 3) break block3;
            int n = Util.findNextSetBit(GModel.BOARD[14], 0);
            while (n != -1) {
                block5: {
                    block4: {
                        if (bl) break block4;
                        if (GEMS_NEXT_ANIM_STATE[n] != -1 || COUNTDOWN_FONT_FRAME[n] >= 0) break block5;
                        int n2 = n;
                        COUNTDOWN_PULSE_CHANCE[n2] = COUNTDOWN_PULSE_CHANCE[n2] - 1;
                        if (COUNTDOWN_PULSE_CHANCE[n2] > 0) break block5;
                    }
                    GCanvasController.setGemAnimation(n, 57, 0);
                    GCanvasController.setCountdownVectorPulse(n, 0, true, -1);
                    GCanvasController.COUNTDOWN_PULSE_CHANCE[n] = 5;
                }
                n = Util.findNextSetBit(GModel.BOARD[14], n + 1);
            }
        }
    }

    static final void closeGameBoardPortrait() {
        int n = Math.max(4, 1);
        int n2 = ++m_nBoardFadeFrame + (n - 1);
        if (m_nBoardFadeFrame == 0) {
            n2 = 0;
        }
        if (n2 % n == 0) {
            int n3 = 0;
            if (n2 > 0) {
                n3 = n2 / n;
            }
            long l = 255L << n3 * 8;
            if ((lBoardFadedRows & 1L << n3) == 0L) {
                l &= GModel.BOARD[8] | GModel.BOARD[9] | GModel.BOARD[12] | GModel.BOARD[16];
                if (!GModel.m_StartingNewGameFromOldOne) {
                    GCanvasController.setExplodeGemsBitfieldAnim(l, 0);
                }
                lBoardFadedRows |= 1L << n3;
            }
            if ((lBoardFadedRows & 1L << (n3 = 7 - n3)) == 0L) {
                l = 255L << n3 * 8;
                l &= GModel.BOARD[8] | GModel.BOARD[9] | GModel.BOARD[12] | GModel.BOARD[16];
                if (!GModel.m_StartingNewGameFromOldOne) {
                    GCanvasController.setExplodeGemsBitfieldAnim(l, 0);
                }
                lBoardFadedRows |= 1L << n3;
            }
        }
    }

    static final void fadeGameBoard() {
        if (Util.bitsSetLong(lBoardFadedRows) == 8) {
            m_nBoardFadeFrame = Math.max(m_nBoardFadeFrame - 1, 0);
            return;
        }
        int n = 2;
        int n2 = ++m_nBoardFadeFrame + (n - 1);
        if (m_nBoardFadeFrame == 0) {
            n2 = 0;
        }
        if (n2 % n == 0) {
            int n3 = 0;
            if (n2 > 0) {
                n3 = n2 / n;
            }
            long l = 255L << n3 * 8;
            if ((lBoardFadedRows & 1L << n3) == 0L) {
                GCanvasController.setExplodeGemsBitfieldAnim(l &= (GModel.BOARD[8] | GModel.BOARD[9] | GModel.BOARD[12] | GModel.BOARD[16]) ^ 0xFFFFFFFFFFFFFFFFL, 0);
                lBoardFadedRows |= 1L << n3;
            }
            if (Util.bitsSetLong(lBoardFadedRows) == 8) {
                m_nBoardFadeFrame = 15;
            }
        }
    }

    static final void setGemsAnimMorphToSpecial(long l, int n, int n2, int n3) {
        int n4 = n2 / 8;
        int n5 = n2 % 8;
        GCanvasController.getGemPosition(n2, false, true);
        int n6 = m_nGetGemPosX;
        int n7 = m_nGetGemPosY;
        int n8 = Util.findNextSetBit(l, 0);
        while (n8 != -1) {
            if (GEMS_NEXT_ANIM_STATE[n8] == -1 && (GModel.m_lSpecialGemsNewlyCreated & 1L << n8) == 0L) {
                int n9 = n8 / 8;
                int n10 = n8 % 8;
                GCanvasController.getGemPosition(n8, false, true);
                int n11 = 1024 * (Math.abs(n6 - m_nGetGemPosX) - 22);
                int n12 = 1024 * (Math.abs(n7 - m_nGetGemPosY) - 22);
                if (n4 != n9) {
                    if (n9 < n4) {
                        GCanvasController.pushGemOut(n8, 0, n12, n12, n3, 8L, true, FP.fpDiv(n12, 4096));
                    } else {
                        GCanvasController.pushGemOut(n8, 0, -n12, -n12, n3, 8L, true, FP.fpDiv(n12, 4096));
                    }
                } else if (n10 < n5) {
                    GCanvasController.pushGemOut(n8, n11, 0, n11, n3, 8L, true, FP.fpDiv(n11, 4096));
                } else {
                    GCanvasController.pushGemOut(n8, -n11, 0, -n11, n3, 8L, true, FP.fpDiv(n11, 4096));
                }
                GCanvasController.setGemAnimation(n8, n, n3);
            }
            n8 = Util.findNextSetBit(l, n8 + 1);
        }
    }

    static final void updateCountdownVectorPulses(boolean bl) {
        for (int i = 0; i < VECTOR_COUNTDOWN_PULSE_FRAMES.length; ++i) {
            int n;
            if (VECTOR_COUNTDOWN_PULSE_FRAMES[i] < 0) continue;
            int n2 = i;
            VECTOR_COUNTDOWN_PULSE_FRAMES[n2] = VECTOR_COUNTDOWN_PULSE_FRAMES[n2] + 1;
            GCanvasController.getGemPosition(i, false, true);
            int n3 = 29 + 5 * VECTOR_COUNTDOWN_PULSE_FRAMES[i];
            int n4 = m_nGetGemPosX + GCanvas.GEM_WIDTH / 2 - n3 / 2;
            int n5 = GModel.getGemColour(1L << i);
            if (n5 == 5) {
                n = m_nGetGemPosY + GCanvas.GEM_WIDTH / 2 - n3 / 8 - n3 / 2;
                n4 -= 3;
                n -= 3;
                n3 += 7;
            } else if (n5 == 3) {
                n = m_nGetGemPosY + GCanvas.GEM_WIDTH / 2 + n3 / 8 - n3 / 2;
                n4 -= 3;
                n -= 3;
                n3 += 7;
            } else if (n5 == 4) {
                n = m_nGetGemPosY + GCanvas.GEM_WIDTH / 2 - n3 / 2;
                n4 -= 3;
                n -= 3;
                n3 += 6;
            } else {
                n = m_nGetGemPosY + GCanvas.GEM_WIDTH / 2 - n3 / 2;
            }
            DirtyRect.addDirty(n4, n, n3, n3);
            if ((GModel.BOARD[21] & 1L << i) != 0L) {
                GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[i] = -1;
                continue;
            }
            if (bl || VECTOR_COUNTDOWN_PULSE_FRAMES[i] < 6) continue;
            int n6 = i;
            int n7 = VECTOR_COUNTDOWN_PULSE_TIMES[n6] - 1;
            VECTOR_COUNTDOWN_PULSE_TIMES[n6] = n7;
            GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[i] = n7 <= 0 || GameController.m_nCurrentState == 2 ? -1 : 0;
        }
    }

    static final void setCountdownVectorPulse(int n, int n2, boolean bl, int n3) {
        if (GameController.m_nCurrentState == 2) {
            return;
        }
        if (n2 > 0) {
            GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[n] = 0;
            GCanvasController.VECTOR_COUNTDOWN_PULSE_COL[n] = GModel.getGemColour(1L << n);
            GCanvasController.VECTOR_COUNTDOWN_PULSE_TIMES[n] = n2;
        }
        if (bl) {
            GCanvasController.COUNTDOWN_FONT_FRAME[n] = n3 != -1 ? n3 : 0;
        }
    }

    static void updateSoftkeyDirtyRect() {
        for (int i = 0; i < 2; ++i) {
            int n = Input.m_ActiveCommands[i];
            if (n != 3) continue;
            GCanvasController.clearSoftkeyAreas(true, false);
        }
    }

    static void clearSoftkeyAreas(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n5 = 0; n5 < 2; ++n5) {
            int n6 = Input.m_ActiveCommands[n5];
            if (n6 == -1) continue;
            if (Input.m_commandPositions[n6] == 1) {
                bl3 = true;
                continue;
            }
            bl4 = true;
        }
        bl3 &= bl2;
        if (bl4 &= bl) {
            n5 = "\u015b\u0087\u00fd\u0097".charAt(0);
            n4 = Graphic.GetImageWidth(n5);
            n3 = Graphic.GetImageHeight(n5);
            n2 = 4;
            n = Graphic.m_nDeviceHeight - 4 - n3;
            DirtyRect.addDirty(n2, n, n4, n3);
        }
        if (bl3) {
            n5 = "\u015b\u0087\u00fd\u0097".charAt(0);
            n4 = Graphic.GetImageWidth(n5);
            n3 = Graphic.GetImageHeight(n5);
            n2 = Graphic.m_nDeviceWidth - 4 - n4;
            n = Graphic.m_nDeviceHeight - 4 - n3;
            DirtyRect.addDirty(n2, n, n4, n3);
        }
    }

    static final void updateCountdownFont(int n) {
        if (GModel.BOARD[n] != 0L) {
            int n2 = Util.findNextSetBit(GModel.BOARD[n], 0);
            while (n2 != -1) {
                if (GameController.m_nCurrentState == 8 || GameController.m_nCurrentState == 2) {
                    GCanvasController.COUNTDOWN_FONT_FRAME[n2] = -1;
                } else if (GModel.GEM_COUNTDOWN_MOVES[n2] > 0) {
                    if (COUNTDOWN_FONT_FRAME[n2] >= 0) {
                        GCanvasController.addDirtyGem(n2);
                    }
                    if (n == 13) {
                        if (COUNTDOWN_FONT_FRAME[n2] > -1 && (COUNTDOWN_FONT_FRAME[n2] < "\u0150\u0151\u0153\u0154\u0155".length() || GameController.m_nBoardStateFrame % 2 == 0)) {
                            int n3 = n2;
                            COUNTDOWN_FONT_FRAME[n3] = COUNTDOWN_FONT_FRAME[n3] + 1;
                            if (COUNTDOWN_FONT_FRAME[n3] > GraphicsUtil.getPingPongMaxFrame("\u0150\u0151\u0153\u0154\u0155".length())) {
                                GCanvasController.COUNTDOWN_FONT_FRAME[n2] = -1;
                            }
                        }
                    } else if (n == 14) {
                        if ((GModel.BOARD[21] & 1L << n2) != 0L) {
                            GCanvasController.COUNTDOWN_FONT_FRAME[n2] = -1;
                        } else if (COUNTDOWN_FONT_FRAME[n2] > -1 && (COUNTDOWN_FONT_FRAME[n2] < "\u0150\u0151\u0153\u0154\u0155".length() || GameController.m_nBoardStateFrame % 2 == 0)) {
                            int n4 = n2;
                            COUNTDOWN_FONT_FRAME[n4] = COUNTDOWN_FONT_FRAME[n4] + 1;
                            if (COUNTDOWN_FONT_FRAME[n4] > GraphicsUtil.getPingPongMaxFrame("\u0150\u0151\u0153\u0154\u0155".length())) {
                                GCanvasController.COUNTDOWN_FONT_FRAME[n2] = -1;
                            }
                        }
                    }
                }
                n2 = Util.findNextSetBit(GModel.BOARD[n], n2 + 1);
            }
        }
    }

    static final void updateDirtyFallingGridGems() {
        long l = 0L;
        int n = 0;
        for (int i = 63; i >= 0; --i) {
            if ((l & 1L << i) != 0L || !GCanvasController.getGemPosition(i, false, true) || FADE_TILES[i] != -1000) continue;
            n = i % 8;
            l |= 0x101010101010101L << n;
            GCanvasController.getGemPosition(n, true, false);
            int n2 = m_nGetGemPosX;
            int n3 = m_nGetGemPosY;
            GCanvasController.getGemPosition(i, true, false);
            int n4 = m_nGetGemPosY + 44;
            DirtyRect.addDirty(n2, n3, 44, n4 - n3);
        }
    }

    static final boolean bDrawCursor() {
        return !GameController.m_bReplaying && GameController.m_nCurrentState != 8 && GameController.m_nCurrentState != 9 && GameController.m_nCurrentState != 2 && (MainUIController.m_nUIState == -1 || MainUIController.getDrawType(MainUIController.m_nUIState) != 7) && GameController.m_nCurrentState != 12;
    }

    static {
        GEMS_CURRENT_FRAME = new int[64];
        TILES_CURRENT_FRAME = new int[64];
        OVERLAYS_CURRENT_FRAME = new int[64];
        backgroundStarPosX = new int[250];
        backgroundStarPosY = new int[250];
        backgroundStarBright = new int[250];
        FADE_TILES = new int[128];
        VECTOR_COUNTDOWN_PULSE_FRAMES = new int[64];
        VECTOR_COUNTDOWN_PULSE_COL = new int[64];
        VECTOR_COUNTDOWN_PULSE_TIMES = new int[64];
        GEMS_NEXT_ANIM_STATE = new int[64];
        GEMS_NEXT_ANIM_STATE_DELAY = new int[64];
        COUNTDOWN_PULSE_CHANCE = new int[64];
        COUNTDOWN_FONT_FRAME = new int[64];
    }
}

