/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class XFont {
    public static final char WHITE_SPACE = ' ';
    public static final char LINE_BREAK = '|';
    public static final char PAGE_BREAK = '\u00b6';
    int numCol;
    private int color = 0;
    public static final int COL_WHITE = 0;
    public static final int COL_BLACK = 1;
    private byte[][] col_palette;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    private int style;
    private Image[] xfontImg;
    private String characters;
    private int[][] xfontPosition;
    private int[][] xfontRectangles;
    private int[] xfontWidth;
    private int xfontHeight;
    private int xfontBaseline;
    private int xfontWordspace;
    private int xfontTracking;
    private Font systemFont;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private boolean isXFont = false;
    private static int[] CRCTable;

    public XFont() {
        this(null);
    }

    public XFont(byte[][] byArray) {
        this.numCol = byArray == null ? 1 : byArray.length;
        this.col_palette = byArray;
        this.systemFont = Font.getFont((int)0, (int)1, (int)8);
        this.style = 0;
    }

    public void setTracking(int n) {
        this.xfontTracking = n;
    }

    public int getTracking() {
        return this.xfontTracking;
    }

    public void setStyle(int n) {
        if (n == 1 && this.style == 0) {
            ++this.xfontTracking;
        }
        if (n == 0 && this.style == 1) {
            --this.xfontTracking;
        }
        this.style = n;
    }

    public void setColor(int n) {
        if (n > this.numCol - 1) {
            n = 0;
        }
        this.color = n;
    }

    public int getHeight() {
        if (this.isXFont) {
            return this.xfontHeight;
        }
        return this.systemFont.getHeight();
    }

    public int getBaseline() {
        if (this.isXFont) {
            return this.xfontBaseline;
        }
        return this.systemFont.getBaselinePosition();
    }

    public int stringWidth(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (this.isXFont) {
            int n = 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                n += this.charWidth(c2) + this.xfontTracking;
            }
            if (this.style == 1) {
                ++n;
            }
            return n - this.xfontTracking;
        }
        return this.systemFont.stringWidth(string);
    }

    public int charWidth(char c2) {
        if (this.isXFont) {
            int n = 0;
            int n2 = -1;
            n = c2 == ' ' ? this.xfontWordspace : (-1 != (n2 = this.characters.indexOf(c2)) ? this.xfontWidth[n2] : this.systemFont.charWidth(c2));
            return n;
        }
        return this.systemFont.charWidth(c2);
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.isXFont) {
            graphics.setColor(0xFFFFFF);
            int n4 = 0;
            int n5 = 0;
            int n6 = this.xfontBaseline;
            int n7 = n;
            int n8 = n2;
            if ((n3 & 4) == 0) {
                if ((n3 & 1) != 0) {
                    n7 -= this.stringWidth(string) / 2;
                } else if ((n3 & 8) != 0) {
                    n7 -= this.stringWidth(string);
                }
            }
            if ((n3 & 0x40) == 0) {
                if ((n3 & 0x10) != 0) {
                    n8 += n6;
                } else if ((n3 & 0x20) != 0) {
                    n8 += -(this.xfontHeight - n6);
                } else if ((n3 & 2) != 0) {
                    n8 += this.xfontHeight / 2 - (this.xfontHeight - n6);
                }
            } else {
                n8 = n2;
            }
            this.saveClip(graphics);
            try {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    int n9;
                    int n10;
                    char c2 = string.charAt(i2);
                    n4 = this.characters.indexOf(c2);
                    if (c2 == ' ') {
                        n7 += this.xfontWordspace + this.xfontTracking;
                        continue;
                    }
                    if (-1 != n4 && null != this.xfontPosition[n4]) {
                        for (int i3 = 0; i3 < this.xfontPosition[n4].length / 3; ++i3) {
                            n5 = this.xfontPosition[n4][i3 * 3];
                            int n11 = this.xfontPosition[n4][i3 * 3 + 1];
                            int n12 = this.xfontPosition[n4][i3 * 3 + 2];
                            int n13 = this.xfontRectangles[n5][0];
                            int n14 = this.xfontRectangles[n5][1];
                            n10 = this.xfontRectangles[n5][2];
                            n9 = this.xfontRectangles[n5][3];
                            this.drawImage(graphics, this.xfontImg[this.color], n7 + n11, n8 + n12, n13, n14, n10, n9);
                            if (this.style != 1) continue;
                            this.drawImage(graphics, this.xfontImg[this.color], n7 + n11 + 1, n8 + n12, n13, n14, n10, n9);
                        }
                        n7 += this.xfontWidth[n4] + this.xfontTracking;
                        continue;
                    }
                    n10 = this.charWidth(c2);
                    n9 = this.getHeight();
                    graphics.drawChar(c2, n7, n8, 20);
                    n7 += n10 + this.xfontTracking;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restoreClip(graphics);
        } else {
            graphics.setFont(this.systemFont);
            if ((n3 & 0x40) == 0) {
                if ((n3 & 2) != 0) {
                    n3 &= 0xFFFFFFFD;
                    n3 |= 0x10;
                    n2 -= this.systemFont.getHeight() / 2 - 2;
                }
            } else {
                n3 &= 0xFFFFFFBF;
                n3 |= 0x20;
                n2 += this.getHeight();
            }
            if (this.color == 0) {
                graphics.setColor(16751616);
            } else {
                graphics.setColor(0x777777);
            }
            graphics.drawString(string, n, n2, n3);
        }
    }

    private void drawImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.setClip(graphics, n, n2, n5, n6)) {
            graphics.drawImage(image, n - n3, n2 - n4, 20);
        }
    }

    public void load(String string, String string2) {
        try {
            int n;
            int n2;
            int n3;
            if (null == string || null == string2) {
                this.isXFont = false;
                return;
            }
            this.xfontImg = new Image[this.numCol];
            byte[] byArray = this.readResource(string);
            this.xfontImg[0] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            for (n3 = 1; n3 < this.numCol; ++n3) {
                this.xfontImg[n3] = this.createModifiedImage(byArray, this.col_palette[n3]);
            }
            n3 = 0;
            int n4 = 0;
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(string2));
            dataInputStream.readInt();
            this.characters = dataInputStream.readUTF();
            n3 = dataInputStream.readShort();
            this.xfontPosition = new int[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                n4 = dataInputStream.readByte();
                if (n4 == -1) continue;
                this.xfontPosition[n2] = new int[n4 * 3];
                for (n = 0; n < n4; ++n) {
                    this.xfontPosition[n2][0 + n * 3] = dataInputStream.readShort();
                    this.xfontPosition[n2][1 + n * 3] = dataInputStream.readByte();
                    this.xfontPosition[n2][2 + n * 3] = dataInputStream.readByte();
                }
            }
            n3 = dataInputStream.readShort();
            this.xfontRectangles = new int[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                this.xfontRectangles[n2] = new int[4];
                for (n = 0; n < 4; ++n) {
                    this.xfontRectangles[n2][n] = 0xFF & dataInputStream.readByte();
                }
            }
            n3 = dataInputStream.readShort();
            this.xfontWidth = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.xfontWidth[n2] = dataInputStream.readByte();
            }
            this.xfontHeight = dataInputStream.readByte();
            this.xfontBaseline = dataInputStream.readByte();
            this.xfontWordspace = dataInputStream.readByte();
            this.xfontTracking = dataInputStream.readByte();
            dataInputStream.close();
            System.gc();
            this.isXFont = true;
        }
        catch (Exception exception) {
            this.isXFont = false;
        }
    }

    public void unload() {
        this.xfontImg = null;
        this.characters = null;
        this.xfontPosition = null;
        this.xfontRectangles = null;
        this.xfontWidth = null;
        this.systemFont = null;
    }

    public Image createModifiedImage(byte[] byArray, byte[] byArray2) {
        int n = 0;
        try {
            for (int i2 = 16; i2 < byArray.length; ++i2) {
                if (byArray[i2 - 3] != 80 || byArray[i2 - 2] != 76 || byArray[i2 - 1] != 84 || byArray[i2 - 0] != 69) continue;
                n = i2 + 1;
                break;
            }
            byte[] byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
            int n2 = ~XFont.crc32(byArray3, n - 4, byArray2.length + 4);
            n += byArray2.length;
            byArray3[n++] = (byte)(n2 >> 24);
            byArray3[n++] = (byte)(n2 >> 16);
            byArray3[n++] = (byte)(n2 >> 8);
            byArray3[n] = (byte)n2;
            return Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void saveClip(Graphics graphics) {
        this.clipX = graphics.getClipX();
        this.clipY = graphics.getClipY();
        this.clipW = graphics.getClipWidth();
        this.clipH = graphics.getClipHeight();
    }

    private void restoreClip(Graphics graphics) {
        graphics.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
    }

    private boolean setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, this.clipX);
        int n6 = Math.max(n2, this.clipY);
        int n7 = Math.min(n + n3, this.clipX + this.clipW);
        int n8 = Math.min(n2 + n4, this.clipY + this.clipH);
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        if (n9 < 0 || n10 < 0) {
            return false;
        }
        graphics.setClip(n5, n6, n9, n10);
        return true;
    }

    private byte[] readResource(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private char[] wrap(String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.charWidth(' ');
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == ' ') {
                n3 = i2 + 1;
                n5 = 0;
                if (n3 < n2) {
                    while (cArray[n3] != ' ' && cArray[n3] != '|' && cArray[n3] != '\u00b6' && n4 + n5 <= n) {
                        n5 += this.charWidth(cArray[n3]) + this.xfontTracking;
                        if (++n3 < n2) continue;
                    }
                }
                if (n4 + n5 + n6 > n) {
                    cArray[i2] = 124;
                } else {
                    n4 += n6;
                }
            }
            if (cArray[i2] != '|' && cArray[i2] != '\u00b6' && cArray[i2] != ' ') {
                n4 += this.charWidth(cArray[i2]) + this.xfontTracking;
                continue;
            }
            if (cArray[i2] != '|' && cArray[i2] != '\u00b6') continue;
            n4 = 0;
        }
        return cArray;
    }

    public String[][] breakPages(String string, int n, int n2) {
        if (n2 <= 0) {
            n2 = 10000;
        }
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 / this.getHeight();
        char[] cArray = this.wrap(string, n);
        int n4 = cArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (cArray[i2] == '|' || cArray[i2] == '\u00b6') {
                vector2.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                --n3;
            } else {
                stringBuffer.append(cArray[i2]);
            }
            if (n3 > 0 && cArray[i2] != '\u00b6') continue;
            vector.addElement(vector2);
            vector2 = new Vector();
            n3 = n2 / this.getHeight();
        }
        vector2.addElement(stringBuffer.toString());
        vector.addElement(vector2);
        String[][] stringArray = new String[vector.size()][];
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            Vector vector3 = (Vector)vector.elementAt(i3);
            stringArray[i3] = new String[vector3.size()];
            for (int i4 = 0; i4 < stringArray[i3].length; ++i4) {
                stringArray[i3][i4] = (String)vector3.elementAt(i4);
            }
        }
        return stringArray;
    }

    private static int crc32(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (CRCTable == null) {
            CRCTable = new int[256];
            for (n4 = 0; n4 < 256; ++n4) {
                n3 = n4;
                for (int i2 = 8; i2 > 0; --i2) {
                    if ((n3 & 1) == 1) {
                        n3 = n3 >>> 1 ^ 0xEDB88320;
                        continue;
                    }
                    n3 >>>= 1;
                }
                XFont.CRCTable[n4] = n3;
            }
        }
        n4 = n;
        n3 = -1;
        while (n2-- != 0) {
            n3 = CRCTable[(n3 ^ byArray[n4++]) & 0xFF] ^ n3 >>> 8;
        }
        return n3;
    }

    public static String valueOf(int n, int n2) {
        String string = String.valueOf(n);
        return n2 <= string.length() ? string : ("0000000000000000" + string).substring(16 + string.length() - n2, 16 + string.length());
    }

    public static String replace(String string, String string2) {
        try {
            String string3 = string2.substring(0, string2.indexOf("%"));
            String string4 = string2.substring(string2.indexOf("%") + 1, string2.length());
            return string3 + string + string4;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public String replace(String string, String[] stringArray) {
        return this.replace(new StringBuffer(string), 0, stringArray).toString();
    }

    private StringBuffer replace(StringBuffer stringBuffer, int n, String[] stringArray) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i2 = n; i2 < stringBuffer.length(); ++i2) {
            if ('(' == stringBuffer.charAt(i2)) {
                this.replace(stringBuffer, i2 + 1, stringArray);
                --i2;
                continue;
            }
            if (')' == stringBuffer.charAt(i2)) {
                StringBuffer stringBuffer3 = this.replace(stringBuffer2, stringArray);
                stringBuffer.delete(n - 1, i2 + 1);
                stringBuffer.insert(n - 1, stringBuffer3.toString());
                return stringBuffer3;
            }
            stringBuffer2.append(stringBuffer.charAt(i2));
        }
        return stringBuffer;
    }

    private StringBuffer replace(StringBuffer stringBuffer, String[] stringArray) {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        block17: for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
            char c2 = stringBuffer.charAt(i2);
            if ('\"' == c2) {
                bl2 = !bl2;
                continue;
            }
            if (!bl2 && ' ' == c2) continue;
            if ('$' == c2) {
                int n3 = "0123456789".indexOf(stringBuffer.charAt(++i2));
                switch (n2) {
                    case 0: {
                        if (0 == n) {
                            stringBuffer3.append(stringArray[n3]);
                            break;
                        }
                        stringBuffer4.append(stringArray[n3]);
                        break;
                    }
                    case 1: {
                        if (!bl) break;
                        stringBuffer2.append(stringArray[n3]);
                        break;
                    }
                    case 2: {
                        if (bl) break;
                        stringBuffer2.append(stringArray[n3]);
                    }
                }
                continue;
            }
            if ('!' == c2) {
                n |= 1;
                continue;
            }
            if ('=' == c2) {
                n |= 2;
                continue;
            }
            if ('<' == c2) {
                n |= 4;
                continue;
            }
            if ('>' == c2) {
                n |= 8;
                continue;
            }
            if ('?' == c2) {
                switch (n) {
                    case 3: {
                        if (0 != stringBuffer4.toString().compareTo(stringBuffer3.toString())) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 6: {
                        if (0 <= stringBuffer4.toString().compareTo(stringBuffer3.toString())) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 10: {
                        if (0 >= stringBuffer4.toString().compareTo(stringBuffer3.toString())) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 4: {
                        if (0 < stringBuffer4.toString().compareTo(stringBuffer3.toString())) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 8: {
                        if (0 > stringBuffer4.toString().compareTo(stringBuffer3.toString())) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = 0 == stringBuffer4.toString().compareTo(stringBuffer3.toString());
                    }
                }
                n2 = 1;
                continue;
            }
            if (':' == c2) {
                n2 = 2;
                continue;
            }
            switch (n2) {
                case 0: {
                    if (0 == n) {
                        stringBuffer3.append(c2);
                        continue block17;
                    }
                    stringBuffer4.append(c2);
                    continue block17;
                }
                case 1: {
                    if (!bl) continue block17;
                    stringBuffer2.append(c2);
                    continue block17;
                }
                case 2: {
                    if (bl) continue block17;
                    stringBuffer2.append(c2);
                }
            }
        }
        if (0 == n2) {
            stringBuffer2 = stringBuffer3;
        }
        return stringBuffer2;
    }

    public String getLabelString(String string, int n) {
        if (n < this.stringWidth(string)) {
            int n2 = this.stringWidth("...");
            int n3 = 0;
            for (int i2 = 0; i2 < string.length() && n >= (n2 += this.charWidth(string.charAt(i2))); ++i2) {
                ++n3;
            }
            return string.substring(0, n3) + "...";
        }
        return string;
    }
}

