/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameLogic;
import com.ea.game.MainFrame;

public class Trajectory {
    private static final boolean DEBUG_TRAJECTORIES = true;
    public static final int TRAJECTORY_OBJECT_BALL = 0;
    public static final int TRAJECTORY_OBJECT_GOALKEEPER = 1;
    public static final int TRAJECTORY_OBJECTS_COUNT = 2;
    public static final int TRAJECTORY_PARAM_INITIAL_POSITION_X = 0;
    public static final int TRAJECTORY_PARAM_INITIAL_POSITION_Y = 1;
    public static final int TRAJECTORY_PARAM_INITIAL_POSITION_Z = 2;
    public static final int TRAJECTORY_PARAM_DISTANCE_X = 3;
    public static final int TRAJECTORY_PARAM_DISTANCE_Y = 4;
    public static final int TRAJECTORY_PARAM_DISTANCE_Z = 5;
    public static final int TRAJECTORY_PARAM_INITIAL_VELOCITY_Z = 6;
    public static final int TRAJECTORY_PARAM_CURRENT_FRAME = 7;
    public static final int TRAJECTORY_PARAM_TOTAL_FRAMES = 8;
    public static final int TRAJECTORY_PARAM_TOTAL_SWERVE_X = 9;
    public static final int TRAJECTORY_PARAM_TOTAL_SWERVE_Y = 10;
    public static final int TRAJECTORY_PARAMS_LAST_X = 11;
    public static final int TRAJECTORY_PARAMS_LAST_Y = 12;
    public static final int TRAJECTORY_PARAMS_COUNT = 13;
    public static int[][] m_trajectoryParams;

    public static void initTrajectory() {
        m_trajectoryParams = new int[2][13];
    }

    public static void resetAllTrajectoryData() {
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 13; ++i3) {
                Trajectory.m_trajectoryParams[i2][i3] = 0;
            }
        }
    }

    public static int calculateTrajectoryTimeFromHeights(int n2, int n3, int n4, boolean bl) {
        if (n4 < n3 || n4 < n2) {
            n4 += n2 > n3 ? n2 : n3;
        }
        int n5 = n2 < n3 ? n2 : n3;
        int n6 = DDMath.sqrtRout((n4 - n5) * 8 * MainFrame.m_inGameFrameRate * MainFrame.m_inGameFrameRate / 3278);
        if (n2 != n3) {
            int n7 = n2 > n3 ? n2 : n3;
            int n8 = Trajectory.calculateTrajectoryTimeFromHeights(n7, n7, n4, bl);
            n6 = bl ? (n6 -= (n6 - n8) / 2) : (n6 - n8) / 2;
        }
        if (n6 <= 0) {
            // empty if block
        }
        return n6;
    }

    public static void setupTrajectory(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if (n7 < -256 || n7 > 24878 || n8 < -256 || n8 > 32271) {
            DDDebug.msg("TRAJECTORY: BALL SET OUT OF PITCH  X:" + DDDebug.S24ToS0(n7) + "  Y:" + DDDebug.S24ToS0(n8));
        }
        n3 = DDMath.max(n3, 1);
        int n12 = n7 - n10 - n4;
        int n13 = n8 - n11 - n5;
        int n14 = n9 - n6;
        int[] nArray2 = m_trajectoryParams[n2];
        nArray2[0] = n4;
        nArray2[1] = n5;
        nArray2[2] = n6;
        nArray2[3] = n12;
        nArray2[4] = n13;
        nArray2[5] = n14;
        nArray2[7] = 0;
        nArray2[8] = n3;
        nArray2[9] = n10;
        nArray2[10] = n11;
        nArray2[11] = n4;
        nArray2[12] = n5;
        nArray[6] = nArray[6] | 2;
        nArray2[6] = n14 * MainFrame.m_inGameFrameRate / n3 + 3278 * n3 / (2 * MainFrame.m_inGameFrameRate);
        if (nArray == GameAI.m_ballStorage) {
            nArray[3] = nArray2[3] / n3;
            nArray[4] = nArray2[4] / n3;
        }
    }

    public static void changeTrajectoryEndPoint(int[] nArray, int n2, int n3, int n4, int n5) {
        int[] nArray2 = m_trajectoryParams[n2];
        if (n5 == -1) {
            n5 = nArray2[2] + nArray2[5];
        }
        int n6 = nArray2[7];
        Trajectory.setupTrajectory(nArray, n2, nArray2[8], nArray2[0], nArray2[1], nArray2[2], n3, n4, n5, nArray2[9], nArray2[10]);
        nArray2[7] = n6;
    }

    public static void updateTrajectory(int[] nArray, int n2) {
        int[] nArray2 = m_trajectoryParams[n2];
        int n3 = nArray2[7] = nArray2[7] + 1;
        nArray2[11] = nArray[0];
        nArray2[12] = nArray[1];
        Trajectory.calculateTrajectoryPosition(nArray, n2, n3);
        nArray[3] = nArray[0] - nArray2[11];
        nArray[4] = nArray[1] - nArray2[12];
        nArray[5] = (nArray2[6] - 3278 * n3 / MainFrame.m_inGameFrameRate) / MainFrame.m_inGameFrameRate;
        nArray[5] = DDMath.min(nArray[5], GameLogic.MAX_PARRY_VERICAL_SPEED);
        if (n3 >= nArray2[8]) {
            Trajectory.removeFromTrajectory(nArray, n2);
        }
    }

    public static void calculateTrajectoryPosition(int[] nArray, int n2, int n3) {
        int[] nArray2 = m_trajectoryParams[n2];
        int n4 = nArray2[8];
        if (n3 < n4) {
            nArray[0] = nArray2[0] + nArray2[3] * n3 / n4 + ((nArray2[9] << 8) / (n4 * n4) * (n3 * n3) >> 8);
            nArray[1] = nArray2[1] + nArray2[4] * n3 / n4 + ((nArray2[10] << 8) / (n4 * n4) * (n3 * n3) >> 8);
            int n5 = -3278 * n3 / (2 * MainFrame.m_inGameFrameRate);
            int n6 = nArray2[6] + n5;
            int n7 = n6 * n3 / MainFrame.m_inGameFrameRate;
            nArray[2] = nArray2[2] + n7;
        } else {
            nArray[0] = nArray2[0] + nArray2[3] + nArray2[9];
            nArray[1] = nArray2[1] + nArray2[4] + nArray2[10];
            nArray[2] = nArray2[2] + nArray2[5];
        }
    }

    public static void removeFromTrajectory(int[] nArray, int n2) {
        int[] nArray2 = m_trajectoryParams[n2];
        int n3 = nArray2[8];
        int n4 = nArray2[7];
        nArray[6] = nArray[6] & 0xFFFFFFFD;
        GameAI.m_ballInSwerveCross = false;
        if (n2 == 1) {
            GameAI.objectResetVelocity(nArray);
        } else {
            nArray[3] = nArray[0] - nArray2[11];
            nArray[4] = nArray[1] - nArray2[12];
            nArray[5] = (nArray2[6] - 3278 * n4 / MainFrame.m_inGameFrameRate) / MainFrame.m_inGameFrameRate;
            nArray[5] = DDMath.min(nArray[5], GameLogic.MAX_PARRY_VERICAL_SPEED);
        }
    }

    public static int getEndX(int n2) {
        return m_trajectoryParams[n2][0] + m_trajectoryParams[n2][3];
    }

    public static int getEndY(int n2) {
        return m_trajectoryParams[n2][1] + m_trajectoryParams[n2][4];
    }

    public static int getEndZ(int n2) {
        return m_trajectoryParams[n2][2] + m_trajectoryParams[n2][5];
    }

    public static int getEndVelocityX(int n2) {
        return m_trajectoryParams[n2][3] / m_trajectoryParams[n2][8];
    }

    public static int getEndVelocityY(int n2) {
        return m_trajectoryParams[n2][4] / m_trajectoryParams[n2][8];
    }

    public static int getEndVelocityZ(int n2) {
        return (m_trajectoryParams[n2][6] - 3278 * m_trajectoryParams[n2][8] / MainFrame.m_inGameFrameRate) / MainFrame.m_inGameFrameRate;
    }

    public static boolean isBallUnderTrajectoryControl() {
        return (GameAI.m_ballStorage[6] & 2) != 0;
    }

    public static boolean isObjectUnderTrajectoryControl(int[] nArray) {
        return (nArray[6] & 2) != 0;
    }

    public static int getTimeToTarget(int n2) {
        int[] nArray = m_trajectoryParams[n2];
        return nArray[8] - nArray[7];
    }

    public static int getPercentageCompleted(int n2) {
        int[] nArray = m_trajectoryParams[n2];
        return nArray[7] * 100 / nArray[8];
    }
}

